/*
 * Decompiled with CFR 0.152.
 */
package com.cmbchina.ccd.cmblife.sdk.cipher;

import com.cmbchina.ccd.cmblife.sdk.encode.Base64;
import com.cmbchina.ccd.cmblife.sdk.global.Constants;
import com.cmbchina.ccd.cmblife.sdk.global.StringUtils;
import com.cmbchina.ccd.gct.opensdk.GeneralCrypto;
import com.cmbchina.ccd.gct.opensdk.sm.SMCryptException;
import com.cmbchina.ccd.gct.opensdk.util.CommonUtil;
import java.util.Map;

public class SM2Utils {
    public static byte[] sign(byte[] signBody, byte[] privateKey) throws SMCryptException {
        return GeneralCrypto.sign((byte[])signBody, (byte[])privateKey);
    }

    public static String sign(String signBody, String privateKey) throws SMCryptException {
        byte[] sign = SM2Utils.sign(signBody.getBytes(Constants.DEFAULT_CHARSET_ENCODING), CommonUtil.hexStringToByteArray((String)privateKey));
        return new String(StringUtils.base64Encode(sign), Constants.DEFAULT_CHARSET_ENCODING);
    }

    public static boolean verify(byte[] verifyBody, byte[] publicKey, byte[] sign) throws SMCryptException {
        return 0 == GeneralCrypto.verifySign((byte[])verifyBody, (byte[])sign, (byte[])publicKey);
    }

    public static boolean verify(String verifyBody, String publicKey, String sign) throws SMCryptException {
        return SM2Utils.verify(verifyBody.getBytes(Constants.DEFAULT_CHARSET_ENCODING), CommonUtil.hexStringToByteArray((String)publicKey), StringUtils.base64Decode(sign.getBytes(Constants.DEFAULT_CHARSET_ENCODING)));
    }

    public static byte[] encrypt(byte[] encryptBody, byte[] publicKey) throws SMCryptException {
        return GeneralCrypto.asymmetricEncrypt((byte[])encryptBody, (byte[])publicKey);
    }

    public static String encrypt(String encryptBody, String publicKey) throws SMCryptException {
        byte[] body = SM2Utils.encrypt(encryptBody.getBytes(), CommonUtil.hexStringToByteArray((String)publicKey));
        return new String(StringUtils.base64Encode(body));
    }

    public static byte[] decrypt(byte[] decryptBody, byte[] privateKey) throws SMCryptException {
        return GeneralCrypto.asymmetricDecrypt((byte[])decryptBody, (byte[])privateKey);
    }

    public static String decrypt(String decryptBody, String privateKey) throws SMCryptException {
        byte[] body = SM2Utils.decrypt(StringUtils.base64Decode(decryptBody), CommonUtil.hexStringToByteArray((String)privateKey));
        return new String(body, Constants.DEFAULT_CHARSET_ENCODING);
    }

    public static Map<String, String> genKeyPairStr() throws SMCryptException {
        return GeneralCrypto.genAsymmetricKeyStr();
    }

    public static Map<String, byte[]> genKeyPair() {
        return GeneralCrypto.genAsymmetricKey();
    }

    public static String base64TransferHexStrForSM2Key(String base64Key) throws SMCryptException {
        byte[] keyBytes = Base64.decodeBase64(base64Key);
        return CommonUtil.byteArrayToHexString((byte[])keyBytes);
    }

    public static String hexStrTransferBase64ForSM2Key(String hexStrKey) throws SMCryptException {
        byte[] keyBytes = CommonUtil.hexStringToByteArray((String)hexStrKey);
        return Base64.encodeBase64String(keyBytes);
    }
}

