/*
 * Decompiled with CFR 0.152.
 */
package com.cmbchina.ccd.cmblife.sdk.cipher;

import com.cmbchina.ccd.cmblife.sdk.global.Constants;
import com.cmbchina.ccd.cmblife.sdk.global.StringUtils;
import com.cmbchina.ccd.gct.opensdk.GeneralCrypto;
import com.cmbchina.ccd.gct.opensdk.internal.CryptoEnum;
import com.cmbchina.ccd.gct.opensdk.sm.SMCryptException;
import com.cmbchina.ccd.gct.opensdk.util.CommonUtil;

public class SM4Utils {
    public static String encrypt(String encryptBody, String encryptKey, String iv) throws SMCryptException {
        byte[] body = SM4Utils.encrypt(encryptBody.getBytes(Constants.DEFAULT_CHARSET_ENCODING), CommonUtil.hexStringToByteArray((String)encryptKey), CommonUtil.hexStringToByteArray((String)iv));
        return new String(StringUtils.base64Encode(body), Constants.DEFAULT_CHARSET_ENCODING);
    }

    public static byte[] decrypt(byte[] encryptedBody, byte[] keyByte, byte[] iv, CryptoEnum mode) throws SMCryptException {
        return GeneralCrypto.symmetricDecrypt((byte[])encryptedBody, (byte[])keyByte, (byte[])iv, (CryptoEnum)mode);
    }

    public static byte[] decrypt(byte[] encryptedBody, byte[] keyByte, byte[] iv) throws SMCryptException {
        return SM4Utils.decrypt(encryptedBody, keyByte, iv, null);
    }

    public static String decrypt(String body, String key, String iv) throws SMCryptException {
        byte[] decryptBody = SM4Utils.decrypt(StringUtils.base64Decode(body), CommonUtil.hexStringToByteArray((String)key), CommonUtil.hexStringToByteArray((String)iv));
        return new String(decryptBody, Constants.DEFAULT_CHARSET_ENCODING);
    }

    public static String genSM4KeyString() throws SMCryptException {
        return GeneralCrypto.genSymmetricKeyStr();
    }

    public static byte[] genSM4Key() throws SMCryptException {
        return GeneralCrypto.genSymmetricKey();
    }

    public static byte[] genIv() throws SMCryptException {
        return GeneralCrypto.genIv();
    }

    public static String genIvStr() throws SMCryptException {
        return GeneralCrypto.genIvStr();
    }

    public static byte[] encrypt(byte[] encryptBody, byte[] encryptKey, byte[] iv, CryptoEnum mode) throws SMCryptException {
        return GeneralCrypto.symmetricEncrypt((byte[])encryptBody, (byte[])encryptKey, (byte[])iv, (CryptoEnum)mode);
    }

    public static byte[] encrypt(byte[] encryptBody, byte[] encryptKey, byte[] iv) throws SMCryptException {
        return SM4Utils.encrypt(encryptBody, encryptKey, iv, null);
    }
}

