/*
 * Decompiled with CFR 0.152.
 */
package com.cmbchina.ccd.gct.opensdk;

import com.cmbchina.ccd.gct.opensdk.internal.CryptoEnum;
import com.cmbchina.ccd.gct.opensdk.sm.SMCryptException;
import com.cmbchina.ccd.gct.opensdk.sm.algorithm.SM2;
import com.cmbchina.ccd.gct.opensdk.sm.algorithm.SM3;
import com.cmbchina.ccd.gct.opensdk.sm.algorithm.SM4;
import com.cmbchina.ccd.gct.opensdk.util.CommonUtil;
import java.util.HashMap;
import java.util.Map;

public class GeneralCrypto {
    public static final String PUBLIC_KEY = "publickey";
    public static final String PRIVATE_KEY = "privatekey";
    private static SM2 sm2 = SM2.getInstance();
    private static SM3 sm3 = SM3.getInstance();
    private static SM4 sm4 = SM4.getInstance();

    private GeneralCrypto() {
    }

    public static byte[] symmetricEncrypt(byte[] plain, byte[] key, byte[] iv, CryptoEnum mode) throws SMCryptException {
        if (mode == null) {
            mode = CryptoEnum.GCT_SM_CBC;
        }
        switch (mode) {
            case GCT_SM_ECB: {
                return sm4.sm4EncryptWithECB(key, plain);
            }
            case GCT_SM_CBC: {
                return sm4.sm4EncryptWithCBC(key, iv, plain);
            }
            case GCT_SM_CFB: {
                return sm4.sm4EncryptWithCFB(key, iv, plain);
            }
            case GCT_SM_OFB: {
                return sm4.sm4EncryptWithOFB(key, iv, plain);
            }
            case GCT_SM_CTR: {
                return sm4.sm4EncryptWithCTR(key, plain);
            }
        }
        return sm4.sm4EncryptWithCBC(key, iv, plain);
    }

    public static byte[] symmetricDecrypt(byte[] cipher, byte[] key, byte[] iv, CryptoEnum mode) throws SMCryptException {
        if (mode == null) {
            mode = CryptoEnum.GCT_SM_CBC;
        }
        switch (mode) {
            case GCT_SM_ECB: {
                return sm4.sm4DecryptWithECB(key, cipher);
            }
            case GCT_SM_CBC: {
                return sm4.sm4DecryptWithCBC(key, iv, cipher);
            }
            case GCT_SM_CFB: {
                return sm4.sm4DecryptWithCFB(key, iv, cipher);
            }
            case GCT_SM_OFB: {
                return sm4.sm4DecryptWithOFB(key, iv, cipher);
            }
            case GCT_SM_CTR: {
                return sm4.sm4DecryptWithCTR(key, cipher);
            }
        }
        return sm4.sm4DecryptWithCBC(key, iv, cipher);
    }

    public static byte[] genIv() throws SMCryptException {
        return CommonUtil.randomBytes(16);
    }

    public static String genIvStr() throws SMCryptException {
        byte[] iv = GeneralCrypto.genIv();
        return CommonUtil.byteArrayToHexString(iv);
    }

    public static byte[] genSymmetricKey() throws SMCryptException {
        return CommonUtil.randomBytes(16);
    }

    public static String genSymmetricKeyStr() throws SMCryptException {
        byte[] secKey = GeneralCrypto.genSymmetricKey();
        return CommonUtil.byteArrayToHexString(secKey);
    }

    public static byte[] asymmetricEncrypt(byte[] plain, byte[] publicKey) throws SMCryptException {
        return sm2.asymmetricEncrypt(publicKey, plain);
    }

    public static byte[] asymmetricDecrypt(byte[] cipher, byte[] privateKey) throws SMCryptException {
        return sm2.asymmetricDecrypt(privateKey, cipher);
    }

    public static Map<String, byte[]> genAsymmetricKey() {
        return sm2.sm2KeyGen();
    }

    public static Map<String, String> genAsymmetricKeyStr() throws SMCryptException {
        Map<String, byte[]> map = GeneralCrypto.genAsymmetricKey();
        String publicKey = CommonUtil.byteArrayToHexString(map.get(PUBLIC_KEY));
        String privateKey = CommonUtil.byteArrayToHexString(map.get(PRIVATE_KEY));
        HashMap<String, String> result = new HashMap<String, String>();
        result.put(PUBLIC_KEY, publicKey);
        result.put(PRIVATE_KEY, privateKey);
        return result;
    }

    public static byte[] sign(byte[] msg, byte[] privateKey) throws SMCryptException {
        return sm2.sm2SignWithSM3ASN1(privateKey, msg);
    }

    public static int verifySign(byte[] msg, byte[] signature, byte[] publicKey) throws SMCryptException {
        return sm2.sm2VerifyWithSM3ASN1(publicKey, msg, signature);
    }

    public static byte[] genDigest(byte[] msg) throws SMCryptException {
        return sm3.genDigest(msg);
    }
}

