/*
 * Decompiled with CFR 0.152.
 */
package com.cmbchina.ccd.gct.opensdk.sm.algorithm;

import com.cmbchina.ccd.gct.opensdk.sm.ErrorCode;
import com.cmbchina.ccd.gct.opensdk.sm.SMCryptException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithID;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.signers.SM2Signer;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;

public class SM2 {
    public static final String CURVE_NAME = "sm2p256v1";
    private static final byte[] USER_ID = "1234567812345678".getBytes();

    public static SM2 getInstance() {
        return new SM2();
    }

    private ECDomainParameters getECDomainParameters() {
        ECNamedCurveParameterSpec spec = ECNamedCurveTable.getParameterSpec((String)CURVE_NAME);
        return new ECDomainParameters(spec.getCurve(), spec.getG(), spec.getN(), spec.getH(), spec.getSeed());
    }

    private ECCurve getSM2Curve() {
        ECNamedCurveParameterSpec spec = ECNamedCurveTable.getParameterSpec((String)CURVE_NAME);
        return spec.getCurve();
    }

    public Map<String, byte[]> sm2KeyGen() {
        ECDomainParameters domainParameters = this.getECDomainParameters();
        ECKeyPairGenerator generator = new ECKeyPairGenerator();
        ECKeyGenerationParameters parameters = new ECKeyGenerationParameters(domainParameters, new SecureRandom());
        generator.init((KeyGenerationParameters)parameters);
        AsymmetricCipherKeyPair keyPair = generator.generateKeyPair();
        ECPublicKeyParameters publicKeyParameters = (ECPublicKeyParameters)keyPair.getPublic();
        ECPrivateKeyParameters privateKeyParameters = (ECPrivateKeyParameters)keyPair.getPrivate();
        HashMap<String, byte[]> map = new HashMap<String, byte[]>();
        map.put("publickey", publicKeyParameters.getQ().getEncoded(false));
        map.put("privatekey", this.format(privateKeyParameters.getD().toByteArray()));
        return map;
    }

    private byte[] format(byte[] value) {
        if (value.length == 32) {
            return value;
        }
        byte[] bytes = new byte[32];
        if (value.length > 32) {
            System.arraycopy(value, value.length - 32, bytes, 0, 32);
        } else {
            System.arraycopy(value, 0, bytes, 32 - value.length, value.length);
        }
        return bytes;
    }

    public byte[] asymmetricEncrypt(byte[] pubkey, byte[] msg) throws SMCryptException {
        if (pubkey == null) {
            throw new SMCryptException(ErrorCode.E10400);
        }
        if (msg == null) {
            throw new SMCryptException(ErrorCode.E10400);
        }
        if (msg.length == 0) {
            throw new SMCryptException(ErrorCode.E10415);
        }
        if (pubkey.length != 65) {
            throw new SMCryptException(ErrorCode.E10417);
        }
        if (pubkey[0] != 4) {
            throw new SMCryptException(ErrorCode.E10403);
        }
        ECPublicKeyParameters publicKey = null;
        try {
            publicKey = this.encodePublicKey(pubkey);
        }
        catch (Exception e) {
            throw new SMCryptException(ErrorCode.E10416);
        }
        SM2Engine engine = new SM2Engine();
        engine.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)publicKey, new SecureRandom()));
        try {
            byte[] cipherText = engine.processBlock(msg, 0, msg.length);
            return this.c1C2C3ToC1C3C2(cipherText);
        }
        catch (InvalidCipherTextException e) {
            throw new SMCryptException(ErrorCode.E10200, (Exception)((Object)e));
        }
    }

    public byte[] asymmetricDecrypt(byte[] privkey, byte[] msg) throws SMCryptException {
        if (privkey == null) {
            throw new SMCryptException(ErrorCode.E10400);
        }
        if (privkey.length != 32) {
            throw new SMCryptException(ErrorCode.E10418);
        }
        if (msg == null) {
            throw new SMCryptException(ErrorCode.E10400);
        }
        if (msg.length < 97) {
            throw new SMCryptException(ErrorCode.E10419);
        }
        if (msg[0] != 4) {
            throw new SMCryptException(ErrorCode.E10424);
        }
        msg = this.c1C3C2ToC1C2C3(msg);
        ECPrivateKeyParameters privateKey = null;
        try {
            privateKey = this.encodePrivateKey(privkey);
        }
        catch (Exception e) {
            throw new SMCryptException(ErrorCode.E10421);
        }
        SM2Engine engine = new SM2Engine();
        engine.init(false, (CipherParameters)privateKey);
        try {
            return engine.processBlock(msg, 0, msg.length);
        }
        catch (InvalidCipherTextException e) {
            throw new SMCryptException(ErrorCode.E10201, (Exception)((Object)e));
        }
    }

    private ECPublicKeyParameters encodePublicKey(byte[] value) {
        byte[] x = new byte[32];
        byte[] y = new byte[32];
        System.arraycopy(value, 1, x, 0, 32);
        System.arraycopy(value, 33, y, 0, 32);
        BigInteger X = new BigInteger(1, x);
        BigInteger Y = new BigInteger(1, y);
        ECPoint Q = this.getSM2Curve().createPoint(X, Y);
        return new ECPublicKeyParameters(Q, this.getECDomainParameters());
    }

    private ECPrivateKeyParameters encodePrivateKey(byte[] value) {
        BigInteger d = new BigInteger(1, value);
        return new ECPrivateKeyParameters(d, this.getECDomainParameters());
    }

    private byte[] c1C2C3ToC1C3C2(byte[] cipherText) throws SMCryptException {
        if (cipherText != null && cipherText.length >= 97) {
            byte[] bytes = new byte[cipherText.length];
            System.arraycopy(cipherText, 0, bytes, 0, 65);
            System.arraycopy(cipherText, cipherText.length - 32, bytes, 65, 32);
            System.arraycopy(cipherText, 65, bytes, 97, cipherText.length - 97);
            return bytes;
        }
        throw new SMCryptException(ErrorCode.E10406);
    }

    private byte[] c1C3C2ToC1C2C3(byte[] cipherText) throws SMCryptException {
        if (cipherText != null && cipherText.length >= 97) {
            byte[] bytes = new byte[cipherText.length];
            System.arraycopy(cipherText, 0, bytes, 0, 65);
            System.arraycopy(cipherText, 97, bytes, 65, cipherText.length - 97);
            System.arraycopy(cipherText, 65, bytes, cipherText.length - 32, 32);
            return bytes;
        }
        throw new SMCryptException(ErrorCode.E10406);
    }

    public byte[] sm2SignWithSM3(byte[] privkey, byte[] msg) throws SMCryptException {
        if (privkey == null) {
            throw new SMCryptException(ErrorCode.E10400);
        }
        if (msg == null) {
            throw new SMCryptException(ErrorCode.E10400);
        }
        if (msg.length == 0) {
            throw new SMCryptException(ErrorCode.E10415);
        }
        if (privkey.length != 32) {
            throw new SMCryptException(ErrorCode.E10418);
        }
        ECPrivateKeyParameters privateKey = this.encodePrivateKey(privkey);
        SM2Signer signer = new SM2Signer();
        ParametersWithID parameters = new ParametersWithID((CipherParameters)privateKey, USER_ID);
        signer.init(true, (CipherParameters)parameters);
        signer.update(msg, 0, msg.length);
        try {
            return this.decodeDERSignature(signer.generateSignature());
        }
        catch (Exception e) {
            throw new SMCryptException(ErrorCode.E10202, e);
        }
    }

    public int sm2VerifyWithSM3(byte[] pubkey, byte[] msg, byte[] signature) throws SMCryptException {
        if (pubkey == null) {
            throw new SMCryptException(ErrorCode.E10400);
        }
        if (signature == null) {
            throw new SMCryptException(ErrorCode.E10400);
        }
        if (msg == null) {
            throw new SMCryptException(ErrorCode.E10400);
        }
        if (msg.length == 0) {
            throw new SMCryptException(ErrorCode.E10415);
        }
        if (pubkey.length != 65) {
            throw new SMCryptException(ErrorCode.E10417);
        }
        if (pubkey[0] != 4) {
            throw new SMCryptException(ErrorCode.E10403);
        }
        if (signature.length != 64) {
            throw new SMCryptException(ErrorCode.E10405);
        }
        ECPublicKeyParameters publicKey = this.encodePublicKey(pubkey);
        SM2Signer signer = new SM2Signer();
        ParametersWithID parameters = new ParametersWithID((CipherParameters)publicKey, USER_ID);
        signer.init(false, (CipherParameters)parameters);
        signer.update(msg, 0, msg.length);
        if (!signer.verifySignature(this.encodeDERSignature(signature))) {
            return -1;
        }
        return 0;
    }

    public byte[] sm2SignWithSM3ASN1(byte[] privkey, byte[] msg) throws SMCryptException {
        byte[] rsSign = this.sm2SignWithSM3(privkey, msg);
        return this.encodeDERSignature(rsSign);
    }

    public int sm2VerifyWithSM3ASN1(byte[] pubkey, byte[] msg, byte[] signature) throws SMCryptException {
        if (signature == null) {
            throw new SMCryptException(ErrorCode.E10400);
        }
        if (signature.length == 64) {
            return this.sm2VerifyWithSM3(pubkey, msg, signature);
        }
        byte[] rsSign = this.decodeDERSignature(signature);
        return this.sm2VerifyWithSM3(pubkey, msg, rsSign);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] decodeDERSignature(byte[] signature) throws SMCryptException {
        try (ASN1InputStream stream = new ASN1InputStream((InputStream)new ByteArrayInputStream(signature));){
            ASN1Sequence primitive = (ASN1Sequence)stream.readObject();
            Enumeration enumeration = primitive.getObjects();
            BigInteger R = ((ASN1Integer)enumeration.nextElement()).getValue();
            BigInteger S = ((ASN1Integer)enumeration.nextElement()).getValue();
            byte[] bytes = new byte[64];
            byte[] r = this.format(R.toByteArray());
            byte[] s = this.format(S.toByteArray());
            System.arraycopy(r, 0, bytes, 0, 32);
            System.arraycopy(s, 0, bytes, 32, 32);
            byte[] byArray = bytes;
            return byArray;
        }
        catch (Exception e) {
            throw new SMCryptException(ErrorCode.E10501, e);
        }
    }

    private byte[] encodeDERSignature(byte[] signature) throws SMCryptException {
        byte[] r = new byte[32];
        byte[] s = new byte[32];
        System.arraycopy(signature, 0, r, 0, 32);
        System.arraycopy(signature, 32, s, 0, 32);
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add((ASN1Encodable)new ASN1Integer(new BigInteger(1, r)));
        vector.add((ASN1Encodable)new ASN1Integer(new BigInteger(1, s)));
        try {
            return new DERSequence(vector).getEncoded();
        }
        catch (IOException e) {
            throw new SMCryptException(ErrorCode.E10501, e);
        }
    }

    static {
        System.setProperty("org.bouncycastle.asn1.allow_unsafe_integer", "true");
    }
}

