/*
 * Decompiled with CFR 0.152.
 */
package com.cmbchina.ccd.gct.opensdk.sm.algorithm;

import com.cmbchina.ccd.gct.opensdk.sm.ErrorCode;
import com.cmbchina.ccd.gct.opensdk.sm.SMCryptException;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class SM3 {
    private static final Provider PROVIDER = new BouncyCastleProvider();

    public static SM3 getInstance() {
        Security.addProvider(PROVIDER);
        return new SM3();
    }

    public byte[] genDigest(byte[] msg) throws SMCryptException {
        if (msg == null) {
            throw new SMCryptException(ErrorCode.E10400);
        }
        if (msg.length <= 0) {
            throw new SMCryptException(ErrorCode.E10415);
        }
        byte[] bytes = new byte[32];
        SM3Digest digest = new SM3Digest();
        digest.update(msg, 0, msg.length);
        digest.doFinal(bytes, 0);
        digest.reset();
        return bytes;
    }
}

