/*
 * Decompiled with CFR 0.152.
 */
package com.cmbchina.ccd.gct.opensdk.sm.algorithm;

import com.cmbchina.ccd.gct.opensdk.sm.ErrorCode;
import com.cmbchina.ccd.gct.opensdk.sm.SMCryptException;
import java.security.Key;
import java.security.Provider;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class SM4 {
    private static final Provider PROVIDER = new BouncyCastleProvider();

    public static SM4 getInstance() {
        Security.addProvider(PROVIDER);
        return new SM4();
    }

    public byte[] sm4EncryptWithECB(byte[] key, byte[] input) throws SMCryptException {
        return this.doECBCipher(key, input, 1);
    }

    public byte[] sm4DecryptWithECB(byte[] key, byte[] input) throws SMCryptException {
        return this.doECBCipher(key, input, 2);
    }

    public byte[] sm4EncryptWithCBC(byte[] key, byte[] iv, byte[] input) throws SMCryptException {
        return this.doCipher(key, iv, input, "CBC", 1);
    }

    public byte[] sm4DecryptWithCBC(byte[] key, byte[] iv, byte[] input) throws SMCryptException {
        return this.doCipher(key, iv, input, "CBC", 2);
    }

    public byte[] sm4EncryptWithCFB(byte[] key, byte[] iv, byte[] input) throws SMCryptException {
        return this.doCipher(key, iv, input, "CFB", 1);
    }

    public byte[] sm4DecryptWithCFB(byte[] key, byte[] iv, byte[] input) throws SMCryptException {
        return this.doCipher(key, iv, input, "CFB", 2);
    }

    public byte[] sm4EncryptWithOFB(byte[] key, byte[] iv, byte[] input) throws SMCryptException {
        return this.doCipher(key, iv, input, "OFB", 1);
    }

    public byte[] sm4DecryptWithOFB(byte[] key, byte[] iv, byte[] input) throws SMCryptException {
        return this.doCipher(key, iv, input, "OFB", 2);
    }

    public byte[] sm4EncryptWithCTR(byte[] key, byte[] input) throws SMCryptException {
        return this.doCipher(key, new byte[16], input, "CTR", 1);
    }

    public byte[] sm4DecryptWithCTR(byte[] key, byte[] input) throws SMCryptException {
        return this.doCipher(key, new byte[16], input, "CTR", 2);
    }

    public byte[] sm4EncryptWithCTR(byte[] key, byte[] iv, byte[] input) throws SMCryptException {
        return this.doCipher(key, iv, input, "CTR", 1);
    }

    public byte[] sm4DecryptWithCTR(byte[] key, byte[] iv, byte[] input) throws SMCryptException {
        return this.doCipher(key, iv, input, "CTR", 2);
    }

    public byte[] doECBCipher(byte[] key, byte[] input, int operateMode) throws SMCryptException {
        if (key != null && key.length == 16) {
            if (input == null) {
                throw new SMCryptException(ErrorCode.E10400);
            }
            if (operateMode == 1) {
                this.check(input.length > 0, ErrorCode.E10408);
            } else {
                this.check(input.length > 0 && input.length % 16 == 0, ErrorCode.E10409);
            }
            SecretKeySpec spec = new SecretKeySpec(key, "SM4");
            try {
                Cipher cipher = Cipher.getInstance("SM4/ECB/PKCS5Padding", PROVIDER);
                cipher.init(operateMode, spec);
                return cipher.doFinal(input);
            }
            catch (Exception var6) {
                if (operateMode == 1) {
                    throw new SMCryptException(ErrorCode.E10204, var6);
                }
                throw new SMCryptException(ErrorCode.E10205, var6);
            }
        }
        throw new SMCryptException(ErrorCode.E10410);
    }

    private byte[] doCipher(byte[] key, byte[] iv, byte[] input, String mode, int operateMode) throws SMCryptException {
        if (key != null && key.length == 16) {
            if (input == null) {
                throw new SMCryptException(ErrorCode.E10400);
            }
            if (iv == null) {
                throw new SMCryptException(ErrorCode.E10411);
            }
            if (operateMode == 1) {
                if (input.length <= 0) {
                    throw new SMCryptException(ErrorCode.E10408);
                }
            } else if (input.length <= 0 || input.length % 16 != 0) {
                throw new SMCryptException(ErrorCode.E10409);
            }
            if (iv.length == 16) {
                SecretKeySpec spec = new SecretKeySpec(key, "SM4");
                IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
                try {
                    Cipher cipher = Cipher.getInstance("SM4/" + mode + "/PKCS5Padding", PROVIDER);
                    cipher.init(operateMode, (Key)spec, ivParameterSpec);
                    return cipher.doFinal(input);
                }
                catch (Exception e) {
                    if (operateMode == 1) {
                        throw new SMCryptException(ErrorCode.E10204, e);
                    }
                    throw new SMCryptException(ErrorCode.E10205, e);
                }
            }
            throw new SMCryptException(ErrorCode.E10411);
        }
        throw new SMCryptException(ErrorCode.E10410);
    }

    private void check(boolean b, ErrorCode code) throws SMCryptException {
        if (!b) {
            throw new SMCryptException(code);
        }
    }
}

