/*
 * Decompiled with CFR 0.152.
 */
package com.cmbchina.ccd.gct.opensdk.util;

import com.cmbchina.ccd.gct.opensdk.sm.SMCryptException;
import java.security.SecureRandom;

public class CommonUtil {
    public static final String DEFAULT_CHARSET = "UTF-8";

    private CommonUtil() {
    }

    public static byte[] randomBytes(int size) throws SMCryptException {
        try {
            byte[] buffer = new byte[size];
            new SecureRandom().nextBytes(buffer);
            return buffer;
        }
        catch (Exception e) {
            throw new SMCryptException(-9006, "Gen randomBytes error");
        }
    }

    public static byte[] getUtf8Bytes(String str) throws SMCryptException {
        if (null == str) {
            throw new SMCryptException(-9003, "UTF-8 String convert byteArray error");
        }
        try {
            return str.getBytes(DEFAULT_CHARSET);
        }
        catch (Exception e) {
            throw new SMCryptException(-9003, "UTF-8 String convert byteArray error");
        }
    }

    public static String getUtf8String(byte[] bytes) throws SMCryptException {
        if (null == bytes) {
            throw new SMCryptException(-9002, "ByteArray convert UTF-8 String error");
        }
        try {
            return new String(bytes, DEFAULT_CHARSET);
        }
        catch (Exception e) {
            throw new SMCryptException(-9002, "ByteArray convert UTF-8 String error");
        }
    }

    public static String byteArrayToHexString(byte[] byteArray) throws SMCryptException {
        StringBuilder result = new StringBuilder();
        if (null == byteArray) {
            throw new SMCryptException(-9004, "ByteArray convert Hex String error");
        }
        for (byte aByteArray : byteArray) {
            result.append(Character.forDigit(aByteArray >>> 4 & 0xF, 16));
            result.append(Character.forDigit(aByteArray & 0xF, 16));
        }
        return result.toString();
    }

    public static byte[] hexStringToByteArray(String src) throws SMCryptException {
        if (null == src) {
            throw new SMCryptException(-9005, "Hex String convert byteArray error");
        }
        int len = src.length();
        if (len % 2 != 0) {
            throw new SMCryptException(-9005, "Hex String convert byteArray error");
        }
        byte[] out = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            int h = CommonUtil.hexToBin(src.charAt(i));
            int l = CommonUtil.hexToBin(src.charAt(i + 1));
            if (h == -1 || l == -1) {
                throw new SMCryptException(-9005, "Hex String convert byteArray error");
            }
            out[i / 2] = (byte)(h * 16 + l);
        }
        return out;
    }

    private static int hexToBin(char ch) {
        if ('0' <= ch && ch <= '9') {
            return ch - 48;
        }
        if ('A' <= ch && ch <= 'F') {
            return ch - 65 + 10;
        }
        if ('a' <= ch && ch <= 'f') {
            return ch - 97 + 10;
        }
        return -1;
    }
}

