/*
 * Decompiled with CFR 0.152.
 */
package com.cmbchina.ccd.cmblife.sdk;

import com.cmbchina.ccd.cmblife.sdk.encrypt.AesUtils;
import com.cmbchina.ccd.cmblife.sdk.encrypt.RsaUtils;
import com.cmbchina.ccd.cmblife.sdk.global.Constants;
import com.cmbchina.ccd.cmblife.sdk.global.Utils;
import java.security.GeneralSecurityException;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;

public final class CmblifeUtils {
    public static String mapToQueryString(Map<String, String> map, boolean isSort, boolean isUrlEncode) {
        Map<String, String> tempMap;
        if (isSort) {
            tempMap = new TreeMap<String, String>();
            tempMap.putAll(map);
        } else {
            tempMap = map;
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : tempMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (Utils.isBlank(value)) continue;
            if (isUrlEncode) {
                value = Utils.urlEncode(value);
            }
            if (!Utils.isNotBlank(value)) continue;
            sb.append(key).append("=").append(value).append("&");
        }
        String queryString = sb.toString();
        if (queryString.length() > 1) {
            queryString = queryString.substring(0, queryString.length() - 1);
        }
        return queryString;
    }

    public static Map<String, String> mapUrlEncode(Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            map.put(entry.getKey(), Utils.urlEncode(entry.getValue()));
        }
        return map;
    }

    public static String assembleUrl(String prefix, String queryString) {
        if (Utils.isBlank(prefix)) {
            return queryString;
        }
        return prefix + (prefix.contains("?") ? "&" : "?") + queryString;
    }

    public static String assembleUrl(String prefix, Map<String, String> paramsMap, boolean isUrlEncode) {
        return CmblifeUtils.assembleUrl(prefix, CmblifeUtils.mapToQueryString(paramsMap, true, isUrlEncode));
    }

    public static String assembleProtocol(String funcName, String queryString) {
        return CmblifeUtils.assembleUrl("cmblife://" + funcName, queryString);
    }

    public static String assembleProtocol(String funcName, Map<String, String> paramsMap, boolean isUrlEncode) {
        return CmblifeUtils.assembleUrl("cmblife://" + funcName, paramsMap, isUrlEncode);
    }

    public static String assembleSign(String protocol, String sign) {
        if (Utils.isBlank(protocol)) {
            return null;
        }
        return protocol + (protocol.contains("?") ? "&" : "?") + "sign=" + Utils.urlEncode(sign);
    }

    public static String genProtocol(String funcName, Map<String, String> paramsMap, String signKey, String signAlgorithm) throws GeneralSecurityException {
        if (Utils.isBlank(signKey)) {
            throw new IllegalArgumentException("signKey\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Utils.isBlank(funcName)) {
            throw new IllegalArgumentException("funcName\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Utils.isBlank(signAlgorithm)) {
            throw new IllegalArgumentException("\u7b7e\u540d\u7b97\u6cd5\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        HashMap<String, String> tempMap = new HashMap<String, String>();
        tempMap.putAll(paramsMap);
        String signProtocol = CmblifeUtils.assembleProtocol(funcName, tempMap, false);
        String sign = CmblifeUtils.sign(signProtocol, signKey, signAlgorithm);
        return CmblifeUtils.assembleSign(CmblifeUtils.assembleProtocol(funcName, tempMap, true), sign);
    }

    public static String genProtocol(String funcName, Map<String, String> paramsMap, String signKey) throws GeneralSecurityException {
        return CmblifeUtils.genProtocol(funcName, paramsMap, signKey, "SHA256WithRSA");
    }

    public static String encrypt(String encryptBody, String encryptKey) throws GeneralSecurityException {
        if (Utils.isBlank(encryptBody)) {
            throw new IllegalArgumentException("\u62a5\u6587\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (Utils.isBlank(encryptKey)) {
            throw new IllegalArgumentException("\u516c\u94a5\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        byte[] aesKey = AesUtils.genAesKey();
        byte[] aesEncryptedBody = AesUtils.encrypt(encryptBody.getBytes(Constants.DEFAULT_CHARSET_ENCODING), aesKey);
        byte[] encryptedAesKey = RsaUtils.encrypt(aesKey, Utils.base64Decode(encryptKey));
        return Utils.newStringUtf8(Utils.base64Encode(encryptedAesKey)) + "|" + Utils.newStringUtf8(Utils.base64Encode(aesEncryptedBody));
    }

    public static String decrypt(String decryptBody, String decryptKey) throws GeneralSecurityException {
        String[] data = decryptBody.split("\\|");
        if (2 != data.length) {
            throw new IllegalArgumentException("\u52a0\u5bc6\u62a5\u6587\u683c\u5f0f\u9519\u8bef!");
        }
        byte[] aesKey = RsaUtils.decrypt(Utils.base64Decode(data[0]), Utils.base64Decode(decryptKey));
        byte[] body = AesUtils.decrypt(Utils.base64Decode(data[1]), aesKey);
        return new String(body, Constants.DEFAULT_CHARSET_ENCODING);
    }

    public static String sign(String signBody, String signKey, String signAlgorithm) throws GeneralSecurityException {
        if (Utils.isBlank(signBody)) {
            throw new IllegalArgumentException("\u5f85\u7b7e\u540d\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (Utils.isBlank(signKey)) {
            throw new IllegalArgumentException("\u79c1\u94a5\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (Utils.isBlank(signAlgorithm)) {
            throw new IllegalArgumentException("\u7b7e\u540d\u7b97\u6cd5\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        try {
            return RsaUtils.sign(signBody, signKey, signAlgorithm);
        }
        catch (InvalidKeySpecException e) {
            throw new InvalidKeySpecException("\u5bc6\u94a5\u683c\u5f0f\u4e0d\u5bf9!" + e.getMessage());
        }
    }

    public static String sign(String signBody, String signKey) throws GeneralSecurityException {
        return CmblifeUtils.sign(signBody, signKey, "SHA256WithRSA");
    }

    public static String sign(Map<String, String> paramsMap, String signKey, String signAlgorithm) throws GeneralSecurityException {
        return CmblifeUtils.sign(CmblifeUtils.mapToQueryString(paramsMap, true, false), signKey, signAlgorithm);
    }

    public static String sign(Map<String, String> paramsMap, String signKey) throws GeneralSecurityException {
        return CmblifeUtils.sign(paramsMap, signKey, "SHA256WithRSA");
    }

    public static String sign(String prefix, Map<String, String> paramsMap, String signKey, String signAlgorithm) throws GeneralSecurityException {
        String url = CmblifeUtils.assembleUrl(prefix, paramsMap, false);
        return CmblifeUtils.sign(url, signKey, signAlgorithm);
    }

    public static String sign(String prefix, Map<String, String> paramsMap, String signKey) throws GeneralSecurityException {
        String url = CmblifeUtils.assembleUrl(prefix, paramsMap, false);
        return CmblifeUtils.sign(url, signKey, "SHA256WithRSA");
    }

    public static boolean verify(String verifyBody, String sign, String verifyKey, String verifyAlgorithm) throws GeneralSecurityException {
        if (Utils.isBlank(verifyBody)) {
            throw new IllegalArgumentException("\u9a8c\u7b7e\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (Utils.isBlank(sign)) {
            throw new IllegalArgumentException("\u7b7e\u540d\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (Utils.isBlank(verifyKey)) {
            throw new IllegalArgumentException("\u516c\u94a5\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (Utils.isBlank(verifyAlgorithm)) {
            throw new IllegalArgumentException("\u9a8c\u7b7e\u7b97\u6cd5\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        try {
            return RsaUtils.verify(verifyBody, verifyKey, sign, verifyAlgorithm);
        }
        catch (InvalidKeySpecException e) {
            throw new InvalidKeySpecException("\u5bc6\u94a5\u683c\u5f0f\u4e0d\u5bf9!" + e.getMessage());
        }
        catch (SignatureException e) {
            throw new SignatureException("\u7b7e\u540d\u683c\u5f0f\u4e0d\u5bf9" + e.getMessage());
        }
    }

    public static boolean verify(String verifyBody, String sign, String verifyKey) throws GeneralSecurityException {
        return CmblifeUtils.verify(verifyBody, sign, verifyKey, "SHA256WithRSA");
    }

    public static boolean verify(Map<String, String> paramsMap, String verifyKey, String verifyAlgorithm) throws GeneralSecurityException {
        String sign = paramsMap.get("sign");
        paramsMap.remove("sign");
        return CmblifeUtils.verify(CmblifeUtils.mapToQueryString(paramsMap, true, false), sign, verifyKey, verifyAlgorithm);
    }

    public static boolean verify(Map<String, String> paramsMap, String verifyKey) throws GeneralSecurityException {
        return CmblifeUtils.verify(paramsMap, verifyKey, "SHA256WithRSA");
    }

    public static String genDate() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        Date date = new Date();
        return sdf.format(date);
    }

    public static String genRandom() {
        return UUID.randomUUID().toString().replace("-", "");
    }
}

