/*
 * Decompiled with CFR 0.152.
 */
package com.cmbchina.ccd.cmblife.sdk.encrypt;

import com.cmbchina.ccd.cmblife.sdk.global.Constants;
import com.cmbchina.ccd.cmblife.sdk.global.Utils;
import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class AesUtils {
    public static byte[] encrypt(byte[] encryptBody, byte[] encryptKey) throws GeneralSecurityException {
        return AesUtils.encrypt(encryptBody, encryptKey, null, "AES/ECB/PKCS5Padding");
    }

    public static String encrypt(String encryptBody, String encryptKey) throws GeneralSecurityException {
        byte[] body = AesUtils.encrypt(encryptBody.getBytes(Constants.DEFAULT_CHARSET_ENCODING), Utils.base64Decode(encryptKey));
        return new String(Utils.base64Encode(body), Constants.DEFAULT_CHARSET_ENCODING);
    }

    public static byte[] decrypt(byte[] encrypted, byte[] keyByte) throws GeneralSecurityException {
        return AesUtils.decrypt(encrypted, keyByte, null, "AES/ECB/PKCS5Padding");
    }

    public static String decrypt(String body, String key) throws GeneralSecurityException {
        byte[] decryptBody = AesUtils.decrypt(Utils.base64Decode(body), Utils.base64Decode(key));
        return new String(decryptBody, Constants.DEFAULT_CHARSET_ENCODING);
    }

    public static String genAesKeyString() throws GeneralSecurityException {
        return AesUtils.genAesKeyString(128);
    }

    public static byte[] genAesKey() throws GeneralSecurityException {
        return AesUtils.genAesKey(128);
    }

    public static String genAesKeyString(int size) throws GeneralSecurityException {
        return new String(Utils.base64Encode(AesUtils.genAesKey(size)), Constants.DEFAULT_CHARSET_ENCODING);
    }

    public static byte[] genAesKey(int size) throws GeneralSecurityException {
        KeyGenerator kg = KeyGenerator.getInstance("AES");
        kg.init(size);
        SecretKey secretKey = kg.generateKey();
        return secretKey.getEncoded();
    }

    private static Key byte2AESKey(byte[] keyByte) throws GeneralSecurityException {
        return new SecretKeySpec(keyByte, "AES");
    }

    private static byte[] encrypt(byte[] encryptBody, byte[] encryptKey, byte[] iv, String algorithm) throws GeneralSecurityException {
        Key key = AesUtils.byte2AESKey(encryptKey);
        Cipher cipher = Cipher.getInstance(algorithm);
        if (iv == null) {
            cipher.init(1, key);
        } else {
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            cipher.init(1, key, ivSpec);
        }
        return cipher.doFinal(encryptBody);
    }

    private static byte[] decrypt(byte[] decryptBody, byte[] decryptKey, byte[] iv, String algorithm) throws GeneralSecurityException {
        Key key = AesUtils.byte2AESKey(decryptKey);
        Cipher cipher = Cipher.getInstance(algorithm);
        if (iv == null) {
            cipher.init(2, key);
        } else {
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            cipher.init(2, key, ivSpec);
        }
        return cipher.doFinal(decryptBody);
    }
}

