/*
 * Decompiled with CFR 0.152.
 */
package com.cmbchina.ccd.cmblife.sdk.encrypt;

import com.cmbchina.ccd.cmblife.sdk.global.Constants;
import com.cmbchina.ccd.cmblife.sdk.global.Utils;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;

public final class RsaUtils {
    public static byte[] sign(byte[] signBody, byte[] signKey, String signatureAlgorithm) throws GeneralSecurityException {
        RSAPrivateKey key = (RSAPrivateKey)RsaUtils.byte2PrivateKey(signKey);
        Signature signature = Signature.getInstance(signatureAlgorithm);
        signature.initSign(key);
        signature.update(signBody);
        return signature.sign();
    }

    public static String sign(String signBody, String signKey, String signatureAlgorithm) throws GeneralSecurityException {
        byte[] sign = RsaUtils.sign(signBody.getBytes(Constants.DEFAULT_CHARSET_ENCODING), Utils.base64Decode(signKey), signatureAlgorithm);
        return new String(Utils.base64Encode(sign), Constants.DEFAULT_CHARSET_ENCODING);
    }

    public static boolean verify(byte[] verifyBody, byte[] verifyKey, byte[] sign, String verifyAlgorithm) throws GeneralSecurityException {
        RSAPublicKey key = (RSAPublicKey)RsaUtils.byte2PublicKey(verifyKey);
        Signature signature = Signature.getInstance(verifyAlgorithm);
        signature.initVerify(key);
        signature.update(verifyBody);
        return signature.verify(sign);
    }

    public static boolean verify(String verifyBody, String verifyKey, String sign, String verifyAlgorithm) throws GeneralSecurityException {
        return RsaUtils.verify(verifyBody.getBytes(Constants.DEFAULT_CHARSET_ENCODING), Utils.base64Decode(verifyKey), Utils.base64Decode(sign), verifyAlgorithm);
    }

    public static byte[] encrypt(byte[] encryptBody, byte[] encryptKey) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        RSAPublicKey key = (RSAPublicKey)RsaUtils.byte2PublicKey(encryptKey);
        cipher.init(1, key);
        return cipher.doFinal(encryptBody);
    }

    public static String encrypt(String encryptBody, String encryptKey) throws GeneralSecurityException {
        byte[] body = RsaUtils.encrypt(encryptBody.getBytes(Constants.DEFAULT_CHARSET_ENCODING), Utils.base64Decode(encryptKey));
        return new String(Utils.base64Encode(body), Constants.DEFAULT_CHARSET_ENCODING);
    }

    public static byte[] decrypt(byte[] decryptBody, byte[] decryptKey) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        RSAPrivateCrtKey key = (RSAPrivateCrtKey)RsaUtils.byte2PrivateKey(decryptKey);
        cipher.init(2, key);
        return cipher.doFinal(decryptBody);
    }

    public static String decrypt(String decryptBody, String decryptKey) throws GeneralSecurityException {
        byte[] body = RsaUtils.decrypt(Utils.base64Decode(decryptBody), Utils.base64Decode(decryptKey));
        return new String(body, Constants.DEFAULT_CHARSET_ENCODING);
    }

    private static PublicKey byte2PublicKey(byte[] keybyte) throws GeneralSecurityException {
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(keybyte);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePublic(x509KeySpec);
    }

    private static PrivateKey byte2PrivateKey(byte[] keybyte) throws GeneralSecurityException {
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keybyte);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePrivate(pkcs8KeySpec);
    }
}

