/*
 * Decompiled with CFR 0.152.
 */
package com.cmbchina.ccd.cmblife.sdk.global;

import com.cmbchina.ccd.cmblife.sdk.encode.Base64;
import com.cmbchina.ccd.cmblife.sdk.global.Constants;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;

public final class Utils {
    public static boolean isBlank(CharSequence cs) {
        int strLen;
        if (cs == null || (strLen = cs.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(CharSequence cs) {
        return !Utils.isBlank(cs);
    }

    public static String urlEncode(String str) {
        try {
            String[] temp = str.split("\\ ");
            StringBuffer sb = new StringBuffer();
            for (int t = 0; t < temp.length; ++t) {
                sb.append(URLEncoder.encode(temp[t], "UTF-8"));
                if (t >= temp.length - 1) continue;
                sb.append("%20");
            }
            return sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String urlDecode(String str) {
        try {
            return URLDecoder.decode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public static byte[] base64Encode(byte[] bytes) {
        return new Base64().encode(bytes);
    }

    public static byte[] base64Encode(String string) {
        return new Base64().encode(Utils.getBytesUtf8(string));
    }

    public static byte[] base64Decode(byte[] bytes) {
        return new Base64().decode(bytes);
    }

    public static byte[] base64Decode(String string) {
        return new Base64().decode(Utils.getBytesUtf8(string));
    }

    public static String newStringUtf8(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return new String(bytes, Constants.DEFAULT_CHARSET_ENCODING);
    }

    public static byte[] getBytesUtf8(String string) {
        if (string == null) {
            return null;
        }
        return string.getBytes(Constants.DEFAULT_CHARSET_ENCODING);
    }
}

