/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.config.loader;

import com.couchbase.client.core.ClusterFacade;
import com.couchbase.client.core.config.BucketConfig;
import com.couchbase.client.core.config.LoaderType;
import com.couchbase.client.core.config.loader.Loader;
import com.couchbase.client.core.config.parser.BucketConfigParser;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.lang.Tuple;
import com.couchbase.client.core.lang.Tuple2;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.message.ResponseStatus;
import com.couchbase.client.core.message.internal.AddNodeRequest;
import com.couchbase.client.core.message.internal.AddNodeResponse;
import com.couchbase.client.core.message.internal.AddServiceRequest;
import com.couchbase.client.core.message.internal.AddServiceResponse;
import com.couchbase.client.core.message.internal.RemoveServiceRequest;
import com.couchbase.client.core.message.internal.RemoveServiceResponse;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.utils.NetworkAddress;
import rx.Observable;
import rx.functions.Func1;

public abstract class AbstractLoader
implements Loader {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(Loader.class);
    private final ClusterFacade cluster;
    private final CoreEnvironment environment;
    private final ServiceType serviceType;
    private final LoaderType loaderType;

    protected AbstractLoader(LoaderType loaderType, ServiceType serviceType, ClusterFacade cluster, CoreEnvironment environment) {
        this.loaderType = loaderType;
        this.serviceType = serviceType;
        this.cluster = cluster;
        this.environment = environment;
    }

    protected abstract int port();

    protected abstract Observable<String> discoverConfig(String var1, String var2, String var3, NetworkAddress var4);

    @Override
    public Observable<Tuple2<LoaderType, BucketConfig>> loadConfig(NetworkAddress seedNode, String bucket, String password) {
        LOGGER.debug("Loading Config for bucket {}", (Object)bucket);
        return this.loadConfig(seedNode, bucket, bucket, password);
    }

    @Override
    public Observable<Tuple2<LoaderType, BucketConfig>> loadConfig(NetworkAddress seedNode, String bucket, String username, String password) {
        LOGGER.debug("Loading Config for bucket {}", (Object)bucket);
        return this.loadConfigAtAddr(seedNode, bucket, username, password);
    }

    private Observable<Tuple2<LoaderType, BucketConfig>> loadConfigAtAddr(final NetworkAddress node, final String bucket, final String username, final String password) {
        return Observable.just((Object)node).flatMap((Func1)new Func1<NetworkAddress, Observable<AddNodeResponse>>(){

            public Observable<AddNodeResponse> call(NetworkAddress address) {
                return AbstractLoader.this.cluster.send(new AddNodeRequest(address));
            }
        }).flatMap((Func1)new Func1<AddNodeResponse, Observable<AddServiceResponse>>(){

            public Observable<AddServiceResponse> call(final AddNodeResponse response) {
                if (!response.status().isSuccess()) {
                    return Observable.error((Throwable)new IllegalStateException("Could not add node for config loading."));
                }
                LOGGER.debug("Successfully added Node {}", (Object)response.hostname());
                return AbstractLoader.this.cluster.send(new AddServiceRequest(AbstractLoader.this.serviceType, bucket, username, password, AbstractLoader.this.port(), response.hostname())).onErrorResumeNext((Func1)new Func1<Throwable, Observable<AddServiceResponse>>(){

                    public Observable<AddServiceResponse> call(Throwable throwable) {
                        LOGGER.debug("Could not add service on {} because of {}, removing it again.", (Object)node, (Object)throwable);
                        return AbstractLoader.this.cluster.send(new RemoveServiceRequest(AbstractLoader.this.serviceType, bucket, node)).map((Func1)new Func1<RemoveServiceResponse, AddServiceResponse>(){

                            public AddServiceResponse call(RemoveServiceResponse removeServiceResponse) {
                                return new AddServiceResponse(ResponseStatus.FAILURE, response.hostname());
                            }
                        });
                    }
                });
            }
        }).flatMap((Func1)new Func1<AddServiceResponse, Observable<String>>(){

            public Observable<String> call(AddServiceResponse response) {
                if (!response.status().isSuccess()) {
                    return Observable.error((Throwable)new IllegalStateException("Could not add service for config loading."));
                }
                LOGGER.debug("Successfully enabled Service {} on Node {}", (Object)AbstractLoader.this.serviceType, (Object)response.hostname());
                return AbstractLoader.this.discoverConfig(bucket, username, password, response.hostname());
            }
        }).map((Func1)new Func1<String, Tuple2<LoaderType, BucketConfig>>(){

            public Tuple2<LoaderType, BucketConfig> call(String rawConfig) {
                LOGGER.debug("Got configuration from Service, attempting to parse.");
                BucketConfig config = BucketConfigParser.parse(rawConfig, AbstractLoader.this.env());
                config.username(username);
                config.password(password);
                return Tuple.create(AbstractLoader.this.loaderType, config);
            }
        });
    }

    protected ClusterFacade cluster() {
        return this.cluster;
    }

    protected CoreEnvironment env() {
        return this.environment;
    }

    protected String replaceHostWildcard(String input, NetworkAddress hostname) {
        return input.replace("$HOST", hostname.address());
    }
}

