/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.endpoint.kv;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.endpoint.ResponseStatusConverter;
import com.couchbase.client.core.endpoint.ServerFeatures;
import com.couchbase.client.core.endpoint.ServerFeaturesEvent;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.message.ResponseStatus;
import com.couchbase.client.deps.com.fasterxml.jackson.databind.ObjectMapper;
import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.deps.io.netty.channel.ChannelHandlerContext;
import com.couchbase.client.deps.io.netty.channel.ChannelOutboundHandler;
import com.couchbase.client.deps.io.netty.channel.ChannelPromise;
import com.couchbase.client.deps.io.netty.channel.SimpleChannelInboundHandler;
import com.couchbase.client.deps.io.netty.handler.codec.memcache.binary.DefaultFullBinaryMemcacheRequest;
import com.couchbase.client.deps.io.netty.handler.codec.memcache.binary.FullBinaryMemcacheRequest;
import com.couchbase.client.deps.io.netty.handler.codec.memcache.binary.FullBinaryMemcacheResponse;
import com.couchbase.client.deps.io.netty.util.concurrent.Future;
import com.couchbase.client.deps.io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class KeyValueFeatureHandler
extends SimpleChannelInboundHandler<FullBinaryMemcacheResponse>
implements ChannelOutboundHandler {
    private static final ObjectMapper JACKSON = new ObjectMapper();
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(KeyValueFeatureHandler.class);
    private static final byte HELLO_CMD = 31;
    private final List<ServerFeatures> features;
    private final CoreContext ctx;
    private ChannelPromise originalPromise;

    public KeyValueFeatureHandler(CoreContext ctx) {
        boolean xerrorEnabled = Boolean.parseBoolean(System.getProperty("com.couchbase.xerrorEnabled", "true"));
        boolean snappyEnabled = Boolean.parseBoolean(System.getProperty("com.couchbase.snappyEnabled", "false"));
        this.ctx = ctx;
        boolean tcpNodelay = ctx.environment().tcpNodelayEnabled();
        this.features = new ArrayList<ServerFeatures>();
        if (ctx.environment().mutationTokensEnabled()) {
            this.features.add(ServerFeatures.MUTATION_SEQNO);
        }
        this.features.add(tcpNodelay ? ServerFeatures.TCPNODELAY : ServerFeatures.TCPDELAY);
        this.features.add(ServerFeatures.XATTR);
        this.features.add(ServerFeatures.SELECT_BUCKET);
        if (snappyEnabled) {
            this.features.add(ServerFeatures.SNAPPY);
        }
        if (xerrorEnabled) {
            this.features.add(ServerFeatures.XERROR);
        }
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, FullBinaryMemcacheResponse msg) throws Exception {
        ArrayList<ServerFeatures> supported = new ArrayList<ServerFeatures>();
        ResponseStatus responseStatus = ResponseStatusConverter.fromBinary(msg.getStatus());
        if (responseStatus.isSuccess()) {
            while (msg.content().isReadable()) {
                supported.add(ServerFeatures.fromValue(msg.content().readShort()));
            }
        } else {
            LOGGER.debug("HELLO Negotiation did not succeed ({}).", (Object)responseStatus);
        }
        LOGGER.debug("Negotiated supported features: {}", (Object)supported);
        ctx.fireUserEventTriggered(new ServerFeaturesEvent(supported));
        this.originalPromise.setSuccess();
        ctx.pipeline().remove(this);
        ctx.fireChannelActive();
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        ctx.writeAndFlush(this.helloRequest(ctx.channel().hashCode()));
    }

    private FullBinaryMemcacheRequest helloRequest(int connId) throws Exception {
        byte[] key = KeyValueFeatureHandler.generateAgentJson(this.ctx.environment().userAgent(), this.ctx.coreId(), connId);
        short keyLength = (short)key.length;
        ByteBuf wanted = Unpooled.buffer(this.features.size() * 2);
        for (ServerFeatures feature : this.features) {
            wanted.writeShort(feature.value());
        }
        LOGGER.debug("Requesting supported features: {}", (Object)this.features);
        DefaultFullBinaryMemcacheRequest request = new DefaultFullBinaryMemcacheRequest(key, Unpooled.EMPTY_BUFFER, wanted);
        request.setOpcode((byte)31);
        request.setKeyLength(keyLength);
        request.setTotalBodyLength(keyLength + wanted.readableBytes());
        return request;
    }

    static byte[] generateAgentJson(String agent, long coreId, long channelId) throws Exception {
        String id = KeyValueFeatureHandler.paddedHex(coreId) + "/" + KeyValueFeatureHandler.paddedHex(channelId);
        if (agent.length() > 200) {
            agent = agent.substring(0, 200);
        }
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("a", agent);
        result.put("i", id);
        return JACKSON.writeValueAsBytes(result);
    }

    private static String paddedHex(long number) {
        return String.format("%016X", number);
    }

    @Override
    public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        this.originalPromise = promise;
        ChannelPromise downPromise = ctx.newPromise();
        downPromise.addListener((GenericFutureListener<? extends Future<? super Void>>)new GenericFutureListener<Future<Void>>(){

            @Override
            public void operationComplete(Future<Void> future) throws Exception {
                if (!future.isSuccess() && !KeyValueFeatureHandler.this.originalPromise.isDone()) {
                    KeyValueFeatureHandler.this.originalPromise.setFailure(future.cause());
                }
            }
        });
        ctx.connect(remoteAddress, localAddress, downPromise);
    }

    @Override
    public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        ctx.disconnect(promise);
    }

    @Override
    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        ctx.close(promise);
    }

    @Override
    public void deregister(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        ctx.deregister(promise);
    }

    @Override
    public void read(ChannelHandlerContext ctx) throws Exception {
        ctx.read();
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        ctx.write(msg, promise);
    }

    @Override
    public void flush(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }

    @Override
    public void bind(ChannelHandlerContext ctx, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        ctx.bind(localAddress, promise);
    }
}

