/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.spring.cache;

import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.bucket.BucketManager;
import com.couchbase.client.java.document.Document;
import com.couchbase.client.java.document.SerializableDocument;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.error.DocumentAlreadyExistsException;
import com.couchbase.client.java.error.QueryExecutionException;
import com.couchbase.client.java.view.AsyncViewResult;
import com.couchbase.client.java.view.AsyncViewRow;
import com.couchbase.client.java.view.DefaultView;
import com.couchbase.client.java.view.DesignDocument;
import com.couchbase.client.java.view.Stale;
import com.couchbase.client.java.view.View;
import com.couchbase.client.java.view.ViewQuery;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.cache.support.SimpleValueWrapper;
import rx.Observable;
import rx.functions.Func1;

public class CouchbaseCache
implements Cache {
    private static final Cache.ValueWrapper EMPTY_WRAPPER = new SimpleValueWrapper(null);
    private final Logger logger = LoggerFactory.getLogger(CouchbaseCache.class);
    private final Bucket client;
    private final String name;
    private final int ttl;
    private final String DELIMITER = ":";
    private final String CACHE_PREFIX = "cache";
    private final String CACHE_DESIGN_DOCUMENT = "cache";
    private final String CACHE_VIEW = "names";
    private Boolean alwaysFlush = false;
    private static final Func1<AsyncViewRow, String> ROW_TO_ID = new Func1<AsyncViewRow, String>(){

        public String call(AsyncViewRow asyncViewRow) {
            return asyncViewRow.id();
        }
    };
    private static final Func1<JsonObject, Observable<String>> JSON_TO_ONERROR = new Func1<JsonObject, Observable<String>>(){

        public Observable<String> call(JsonObject jsonError) {
            return Observable.error((Throwable)new QueryExecutionException("Error during view query execution: ", jsonError));
        }
    };
    private static Func1<AsyncViewResult, Observable<String>> ROW_IDS_OR_ERROR = new Func1<AsyncViewResult, Observable<String>>(){

        public Observable<String> call(AsyncViewResult asyncViewResult) {
            if (asyncViewResult.success()) {
                return asyncViewResult.rows().map(ROW_TO_ID);
            }
            return asyncViewResult.error().flatMap(JSON_TO_ONERROR);
        }
    };

    public CouchbaseCache(String name, Bucket client) {
        this.name = name;
        this.client = client;
        this.ttl = 0;
        if (!this.getAlwaysFlush().booleanValue()) {
            this.ensureViewExists();
        }
    }

    public CouchbaseCache(String name, Bucket client, int ttl) {
        this.name = name;
        this.client = client;
        this.ttl = ttl;
        if (!this.getAlwaysFlush().booleanValue()) {
            this.ensureViewExists();
        }
    }

    public final String getName() {
        return this.name;
    }

    public final Bucket getNativeCache() {
        return this.client;
    }

    public final int getTtl() {
        return this.ttl;
    }

    public final Cache.ValueWrapper get(Object key) {
        String documentId = this.getDocumentId(key.toString());
        SerializableDocument doc = (SerializableDocument)this.client.get(documentId, SerializableDocument.class);
        if (doc == null) {
            return null;
        }
        if (doc.content() == null) {
            return EMPTY_WRAPPER;
        }
        return new SimpleValueWrapper(doc.content());
    }

    public final <T> T get(Object key, Class<T> clazz) {
        String documentId = this.getDocumentId(key.toString());
        SerializableDocument doc = (SerializableDocument)this.client.get(documentId, SerializableDocument.class);
        return (T)(doc == null ? null : doc.content());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T get(Object key, Callable<T> valueLoader) {
        String documentId = this.getDocumentId(key.toString());
        SerializableDocument doc = (SerializableDocument)this.client.get(documentId, SerializableDocument.class);
        if (doc == null && valueLoader != null) {
            Bucket bucket = this.client;
            synchronized (bucket) {
                doc = (SerializableDocument)this.client.get(documentId, SerializableDocument.class);
                if (doc == null) {
                    try {
                        T value = valueLoader.call();
                        this.put(key, value);
                        return value;
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(String.format("Failed to load key %s using valueLoader %s", key, valueLoader.getClass().getName()));
                    }
                }
            }
        }
        if (doc != null) {
            return (T)doc.content();
        }
        return null;
    }

    public final void put(Object key, Object value) {
        if (value != null) {
            if (!(value instanceof Serializable)) {
                throw new IllegalArgumentException(String.format("Value %s of type %s is not Serializable", value.toString(), value.getClass().getName()));
            }
            String documentId = this.getDocumentId(key.toString());
            SerializableDocument doc = SerializableDocument.create((String)documentId, (int)this.ttl, (Serializable)((Serializable)value));
            this.client.upsert((Document)doc);
        } else {
            this.evict(key);
        }
    }

    public final void evict(Object key) {
        String documentId = this.getDocumentId(key.toString());
        this.client.remove(documentId);
    }

    public final void clear() {
        if (this.getAlwaysFlush().booleanValue()) {
            try {
                this.client.bucketManager().flush();
            }
            catch (Exception e) {
                this.logger.error("Couchbase flush error: ", (Throwable)e);
            }
        } else {
            this.evictAllDocuments();
        }
    }

    public Cache.ValueWrapper putIfAbsent(Object key, Object value) {
        if (value != null && !(value instanceof Serializable)) {
            throw new IllegalArgumentException(String.format("Value %s of type %s is not Serializable", value.toString(), value.getClass().getName()));
        }
        String documentId = this.getDocumentId(key.toString());
        SerializableDocument doc = SerializableDocument.create((String)documentId, (int)this.ttl, (Serializable)((Serializable)value));
        try {
            this.client.insert((Document)doc);
            return null;
        }
        catch (DocumentAlreadyExistsException e) {
            SerializableDocument existingDoc = (SerializableDocument)this.client.get(documentId, SerializableDocument.class);
            if (existingDoc == null) {
                return EMPTY_WRAPPER;
            }
            return new SimpleValueWrapper(existingDoc.content());
        }
    }

    protected String getDocumentId(String key) {
        if (this.name == null || this.name.trim().length() == 0) {
            return "cache::" + key;
        }
        return "cache:" + this.name + ":" + key;
    }

    private void evictAllDocuments() {
        ViewQuery query = ViewQuery.from((String)"cache", (String)"names");
        query.stale(Stale.FALSE);
        if (this.name == null || this.name.trim().length() == 0) {
            query.key("");
        } else {
            query.key(this.name);
        }
        this.client.async().query(query).flatMap(ROW_IDS_OR_ERROR).flatMap((Func1)new Func1<String, Observable<? extends Document>>(){

            public Observable<? extends Document> call(String id) {
                return CouchbaseCache.this.client.async().remove(id, SerializableDocument.class);
            }
        }).toBlocking().lastOrDefault(null);
    }

    private void ensureViewExists() {
        DesignDocument doc;
        BucketManager bucketManager;
        block6: {
            bucketManager = this.client.bucketManager();
            doc = null;
            try {
                doc = bucketManager.getDesignDocument("cache");
            }
            catch (Exception e) {
                if (!this.logger.isDebugEnabled()) break block6;
                this.logger.debug("Unable to retrieve design document cache", (Throwable)e);
            }
        }
        if (doc != null) {
            for (View view : doc.views()) {
                if (!"names".equals(view.name())) continue;
                return;
            }
        }
        String function = "function (doc, meta) {var tokens = meta.id.split(':'); if(tokens.length > 2 && tokens[0] == 'cache') emit(tokens[1]);}";
        View v = DefaultView.create((String)"names", (String)function);
        if (doc == null) {
            ArrayList<View> viewList = new ArrayList<View>(1);
            viewList.add(v);
            doc = DesignDocument.create((String)"cache", viewList);
        } else {
            doc.views().add(v);
        }
        bucketManager.upsertDesignDocument(doc);
    }

    public Boolean getAlwaysFlush() {
        return this.alwaysFlush;
    }

    public void setAlwaysFlush(Boolean alwaysFlush) {
        this.alwaysFlush = alwaysFlush;
    }
}

