/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.query;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.query.N1qlParams;
import com.couchbase.client.java.query.ParameterizedN1qlQuery;
import com.couchbase.client.java.query.PreparedPayload;
import com.couchbase.client.java.query.Statement;

@InterfaceStability.Experimental
@InterfaceAudience.Private
public class PreparedN1qlQuery
extends ParameterizedN1qlQuery {
    private boolean encodedPlanEnabled = true;

    public PreparedN1qlQuery(PreparedPayload plan, JsonArray positionalParams, N1qlParams params) {
        super((Statement)plan, positionalParams, params);
    }

    public PreparedN1qlQuery(PreparedPayload plan, JsonObject namedParams, N1qlParams params) {
        super((Statement)plan, namedParams, params);
    }

    public PreparedN1qlQuery(PreparedPayload plan, N1qlParams params) {
        super((Statement)plan, (JsonArray)null, params);
    }

    @Override
    protected String statementType() {
        return "prepared";
    }

    @Override
    protected Object statementValue() {
        return this.statement().payload();
    }

    @Override
    public PreparedPayload statement() {
        return (PreparedPayload)super.statement();
    }

    public void setEncodedPlanEnabled(boolean enabled) {
        this.encodedPlanEnabled = enabled;
    }

    public boolean isEncodedPlanEnabled() {
        return this.encodedPlanEnabled;
    }

    @Override
    public JsonObject n1ql() {
        JsonObject n1ql = super.n1ql();
        String encodedPlan = this.statement().encodedPlan();
        if (encodedPlan != null && this.encodedPlanEnabled) {
            n1ql.put("encoded_plan", encodedPlan);
        }
        return n1ql;
    }
}

