/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.analytics;

import com.couchbase.client.core.ClusterFacade;
import com.couchbase.client.core.message.CouchbaseRequest;
import com.couchbase.client.core.message.analytics.GenericAnalyticsRequest;
import com.couchbase.client.core.message.analytics.GenericAnalyticsResponse;
import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.java.CouchbaseAsyncBucket;
import com.couchbase.client.java.analytics.AnalyticsMetrics;
import com.couchbase.client.java.analytics.AnalyticsQuery;
import com.couchbase.client.java.analytics.AnalyticsQueryResult;
import com.couchbase.client.java.analytics.AsyncAnalyticsQueryResult;
import com.couchbase.client.java.analytics.AsyncAnalyticsQueryRow;
import com.couchbase.client.java.analytics.DefaultAnalyticsQueryResult;
import com.couchbase.client.java.analytics.DefaultAsyncAnalyticsQueryResult;
import com.couchbase.client.java.analytics.DefaultAsyncAnalyticsQueryRow;
import com.couchbase.client.java.bucket.api.Utils;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.env.CouchbaseEnvironment;
import com.couchbase.client.java.error.TranscodingException;
import com.couchbase.client.java.transcoder.TranscoderUtils;
import com.couchbase.client.java.util.OnSubscribeDeferAndWatch;
import io.opentracing.tag.Tags;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Func1;
import rx.functions.Func6;

public class AnalyticsQueryExecutor {
    private final ClusterFacade core;
    private final String bucket;
    private final String username;
    private final String password;
    public static final Func1<? super AsyncAnalyticsQueryResult, ? extends Observable<? extends AnalyticsQueryResult>> ASYNC_RESULT_TO_SYNC = new Func1<AsyncAnalyticsQueryResult, Observable<AnalyticsQueryResult>>(){

        public Observable<AnalyticsQueryResult> call(AsyncAnalyticsQueryResult aqr) {
            final boolean parseSuccess = aqr.parseSuccess();
            final String requestId = aqr.requestId();
            final String clientContextId = aqr.clientContextId();
            return Observable.zip((Observable)aqr.rows().toList(), (Observable)aqr.signature().singleOrDefault((Object)JsonObject.empty()), (Observable)aqr.info().singleOrDefault((Object)AnalyticsMetrics.EMPTY_METRICS), (Observable)aqr.errors().toList(), aqr.status(), (Observable)aqr.finalSuccess().singleOrDefault((Object)Boolean.FALSE), (Func6)new Func6<List<AsyncAnalyticsQueryRow>, Object, AnalyticsMetrics, List<JsonObject>, String, Boolean, AnalyticsQueryResult>(){

                public AnalyticsQueryResult call(List<AsyncAnalyticsQueryRow> rows, Object signature, AnalyticsMetrics info, List<JsonObject> errors, String finalStatus, Boolean finalSuccess) {
                    return new DefaultAnalyticsQueryResult(rows, signature, info, errors, finalStatus, finalSuccess, parseSuccess, requestId, clientContextId);
                }
            });
        }
    };

    public AnalyticsQueryExecutor(ClusterFacade core, String bucket, String username, String password) {
        this.core = core;
        this.bucket = bucket;
        this.username = username;
        this.password = password;
    }

    public Observable<AsyncAnalyticsQueryResult> execute(final AnalyticsQuery query, final CouchbaseEnvironment env, final long timeout, final TimeUnit timeUnit) {
        return OnSubscribeDeferAndWatch.deferAndWatch(new Func1<Subscriber, Observable<GenericAnalyticsResponse>>(){

            public Observable<GenericAnalyticsResponse> call(Subscriber subscriber) {
                GenericAnalyticsRequest request = GenericAnalyticsRequest.jsonQuery((String)query.query().toString(), (String)AnalyticsQueryExecutor.this.bucket, (String)AnalyticsQueryExecutor.this.username, (String)AnalyticsQueryExecutor.this.password);
                Utils.addRequestSpan(env, (CouchbaseRequest)request, "analytics");
                if (env.operationTracingEnabled()) {
                    request.span().setTag(Tags.DB_STATEMENT.getKey(), query.statement());
                }
                request.subscriber(subscriber);
                return Utils.applyTimeout(AnalyticsQueryExecutor.this.core.send((CouchbaseRequest)request), (CouchbaseRequest)request, env, timeout, timeUnit);
            }
        }).flatMap((Func1)new Func1<GenericAnalyticsResponse, Observable<AsyncAnalyticsQueryResult>>(){

            public Observable<AsyncAnalyticsQueryResult> call(GenericAnalyticsResponse response) {
                Observable rows = response.rows().map((Func1)new Func1<ByteBuf, AsyncAnalyticsQueryRow>(){

                    public AsyncAnalyticsQueryRow call(ByteBuf byteBuf) {
                        try {
                            TranscoderUtils.ByteBufToArray rawData = TranscoderUtils.byteBufToByteArray(byteBuf);
                            byte[] copy = Arrays.copyOfRange(rawData.byteArray, rawData.offset, rawData.offset + rawData.length);
                            DefaultAsyncAnalyticsQueryRow defaultAsyncAnalyticsQueryRow = new DefaultAsyncAnalyticsQueryRow(copy);
                            return defaultAsyncAnalyticsQueryRow;
                        }
                        catch (Exception e) {
                            throw new TranscodingException("Could not decode Analytics Query Row.", e);
                        }
                        finally {
                            byteBuf.release();
                        }
                    }
                });
                Observable signature = response.signature().map((Func1)new Func1<ByteBuf, Object>(){

                    public Object call(ByteBuf byteBuf) {
                        try {
                            Object object = CouchbaseAsyncBucket.JSON_OBJECT_TRANSCODER.byteBufJsonValueToObject(byteBuf);
                            return object;
                        }
                        catch (Exception e) {
                            throw new TranscodingException("Could not decode Analytics Query Signature", e);
                        }
                        finally {
                            byteBuf.release();
                        }
                    }
                });
                Observable info = response.info().map((Func1)new Func1<ByteBuf, JsonObject>(){

                    public JsonObject call(ByteBuf byteBuf) {
                        try {
                            JsonObject jsonObject = CouchbaseAsyncBucket.JSON_OBJECT_TRANSCODER.byteBufToJsonObject(byteBuf);
                            return jsonObject;
                        }
                        catch (Exception e) {
                            throw new TranscodingException("Could not decode Analytics Query Metrics.", e);
                        }
                        finally {
                            byteBuf.release();
                        }
                    }
                }).map((Func1)new Func1<JsonObject, AnalyticsMetrics>(){

                    public AnalyticsMetrics call(JsonObject jsonObject) {
                        return new AnalyticsMetrics(jsonObject);
                    }
                });
                Observable finalStatus = response.queryStatus();
                Observable errors = response.errors().map((Func1)new Func1<ByteBuf, JsonObject>(){

                    public JsonObject call(ByteBuf byteBuf) {
                        try {
                            JsonObject jsonObject = CouchbaseAsyncBucket.JSON_OBJECT_TRANSCODER.byteBufToJsonObject(byteBuf);
                            return jsonObject;
                        }
                        catch (Exception e) {
                            throw new TranscodingException("Could not decode Analytics Errors.", e);
                        }
                        finally {
                            byteBuf.release();
                        }
                    }
                });
                boolean parseSuccess = response.status().isSuccess();
                String contextId = response.clientRequestId() == null ? "" : response.clientRequestId();
                String requestId = response.requestId();
                DefaultAsyncAnalyticsQueryResult r = new DefaultAsyncAnalyticsQueryResult((Observable<AsyncAnalyticsQueryRow>)rows, (Observable<Object>)signature, (Observable<AnalyticsMetrics>)info, (Observable<JsonObject>)errors, (Observable<String>)finalStatus, parseSuccess, requestId, contextId);
                return Observable.just((Object)r);
            }
        });
    }
}

