/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.openapi.client.service;

import com.ctrip.framework.apollo.openapi.client.exception.ApolloOpenApiException;
import com.ctrip.framework.apollo.openapi.client.url.OpenApiPathBuilder;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.gson.Gson;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;

abstract class AbstractOpenApiService {
    private final String baseUrl;
    protected final CloseableHttpClient client;
    protected final Gson gson;

    AbstractOpenApiService(CloseableHttpClient client, String baseUrl, Gson gson) {
        this.client = client;
        this.baseUrl = baseUrl;
        this.gson = gson;
    }

    protected CloseableHttpResponse get(OpenApiPathBuilder path) throws IOException {
        HttpGet get = new HttpGet(path.buildPath(this.baseUrl));
        return this.execute((HttpUriRequest)get);
    }

    protected CloseableHttpResponse post(OpenApiPathBuilder path, Object entity) throws IOException {
        HttpPost post = new HttpPost(path.buildPath(this.baseUrl));
        return this.execute((HttpEntityEnclosingRequestBase)post, entity);
    }

    protected CloseableHttpResponse put(OpenApiPathBuilder path, Object entity) throws IOException {
        HttpPut put = new HttpPut(path.buildPath(this.baseUrl));
        return this.execute((HttpEntityEnclosingRequestBase)put, entity);
    }

    protected CloseableHttpResponse delete(OpenApiPathBuilder path) throws IOException {
        HttpDelete delete = new HttpDelete(path.buildPath(this.baseUrl));
        return this.execute((HttpUriRequest)delete);
    }

    private CloseableHttpResponse execute(HttpEntityEnclosingRequestBase requestBase, Object entity) throws IOException {
        requestBase.setEntity((HttpEntity)new StringEntity(this.gson.toJson(entity), ContentType.APPLICATION_JSON));
        return this.execute((HttpUriRequest)requestBase);
    }

    private CloseableHttpResponse execute(HttpUriRequest request) throws IOException {
        CloseableHttpResponse response = this.client.execute(request);
        this.checkHttpResponseStatus((HttpResponse)response);
        return response;
    }

    private void checkHttpResponseStatus(HttpResponse response) {
        if (response.getStatusLine().getStatusCode() == 200) {
            return;
        }
        StatusLine status = response.getStatusLine();
        String message = "";
        try {
            message = EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        throw new ApolloOpenApiException(status.getStatusCode(), status.getReasonPhrase(), message);
    }

    protected void checkNotEmpty(String value, String name) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)value) ? 1 : 0) != 0, (Object)(name + " should not be null or empty"));
    }
}

