/*
 * Decompiled with CFR 0.152.
 */
package com.cv4j.proxy;

import com.cv4j.proxy.ProxyPool;
import com.cv4j.proxy.domain.Proxy;
import com.cv4j.proxy.http.HttpManager;
import com.cv4j.proxy.task.ProxyPageCallable;
import com.safframework.tony.common.utils.Preconditions;
import io.reactivex.Flowable;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.http.HttpHost;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyManager {
    private static final Logger log = LoggerFactory.getLogger(ProxyManager.class);

    private ProxyManager() {
    }

    public static ProxyManager get() {
        return Holder.MANAGER;
    }

    public void start() {
        Flowable.fromIterable(ProxyPool.proxyMap.keySet()).parallel().map((Function)new Function<String, List<Proxy>>(){

            public List<Proxy> apply(String s) throws Exception {
                try {
                    return new ProxyPageCallable(s).call();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return new ArrayList<Proxy>();
                }
            }
        }).flatMap((Function)new Function<List<Proxy>, Publisher<Proxy>>(){

            public Publisher<Proxy> apply(List<Proxy> proxies) throws Exception {
                if (Preconditions.isNotBlank(proxies)) {
                    List result = ((Stream)proxies.stream().parallel()).filter(new Predicate<Proxy>(){

                        @Override
                        public boolean test(Proxy proxy) {
                            HttpHost httpHost = new HttpHost(proxy.getIp(), proxy.getPort(), proxy.getType());
                            boolean result = HttpManager.get().checkProxy(httpHost);
                            if (result) {
                                log.info("checkProxy " + proxy.getProxyStr() + ", " + result);
                            }
                            return result;
                        }
                    }).collect(Collectors.toList());
                    return Flowable.fromIterable(result);
                }
                return Flowable.empty();
            }
        }).sequential().subscribe((Consumer)new Consumer<Proxy>(){

            public void accept(Proxy proxy) throws Exception {
                if (proxy != null) {
                    log.info("accept " + proxy.getProxyStr());
                    proxy.setLastSuccessfulTime(new Date().getTime());
                    ProxyPool.proxyList.add(proxy);
                }
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) throws Exception {
                log.error("ProxyManager is error: " + throwable.getMessage());
            }
        });
    }

    private static class Holder {
        private static final ProxyManager MANAGER = new ProxyManager();

        private Holder() {
        }
    }
}

