/*
 * Decompiled with CFR 0.152.
 */
package com.cv4j.proxy.domain;

import java.io.Serializable;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpHost;

public class Proxy
implements Delayed,
Serializable {
    private static final long serialVersionUID = -8788193271053510562L;
    private long timeInterval;
    private String id;
    private String ip;
    private int port;
    private String type;
    private boolean availableFlag;
    private boolean anonymousFlag;
    private long lastSuccessfulTime;
    private long successfulTotalTime;
    private int failureTimes;
    private int successfulTimes;
    private double successfulAverageTime;

    public Proxy() {
    }

    public Proxy(String ip, int port, long timeInterval) {
        this.ip = ip;
        this.port = port;
        this.type = "http";
        this.timeInterval = timeInterval;
        this.timeInterval = TimeUnit.NANOSECONDS.convert(timeInterval, TimeUnit.MILLISECONDS) + System.nanoTime();
    }

    public Proxy(String ip, int port, String type, long timeInterval) {
        this.ip = ip;
        this.port = port;
        this.type = type.toLowerCase();
        this.timeInterval = timeInterval;
        this.timeInterval = TimeUnit.NANOSECONDS.convert(timeInterval, TimeUnit.MILLISECONDS) + System.nanoTime();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isAvailableFlag() {
        return this.availableFlag;
    }

    public void setAvailableFlag(boolean availableFlag) {
        this.availableFlag = availableFlag;
    }

    public boolean isAnonymousFlag() {
        return this.anonymousFlag;
    }

    public void setAnonymousFlag(boolean anonymousFlag) {
        this.anonymousFlag = anonymousFlag;
    }

    public long getTimeInterval() {
        return this.timeInterval;
    }

    public long getLastSuccessfulTime() {
        return this.lastSuccessfulTime;
    }

    public void setLastSuccessfulTime(long lastSuccessfulTime) {
        this.lastSuccessfulTime = lastSuccessfulTime;
    }

    public long getSuccessfulTotalTime() {
        return this.successfulTotalTime;
    }

    public void setSuccessfulTotalTime(long successfulTotalTime) {
        this.successfulTotalTime = successfulTotalTime;
    }

    public void setTimeInterval(long timeInterval) {
        this.timeInterval = TimeUnit.NANOSECONDS.convert(timeInterval, TimeUnit.MILLISECONDS) + System.nanoTime();
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(this.timeInterval - System.nanoTime(), TimeUnit.NANOSECONDS);
    }

    @Override
    public int compareTo(Delayed o) {
        Proxy element = (Proxy)o;
        if (this.successfulAverageTime == 0.0 || element.successfulAverageTime == 0.0) {
            return 0;
        }
        return this.successfulAverageTime > element.successfulAverageTime ? 1 : (this.successfulAverageTime < element.successfulAverageTime ? -1 : 0);
    }

    public int getFailureTimes() {
        return this.failureTimes;
    }

    public void setFailureTimes(int failureTimes) {
        this.failureTimes = failureTimes;
    }

    public int getSuccessfulTimes() {
        return this.successfulTimes;
    }

    public void setSuccessfulTimes(int successfulTimes) {
        this.successfulTimes = successfulTimes;
    }

    public double getSuccessfulAverageTime() {
        return this.successfulAverageTime;
    }

    public void setSuccessfulAverageTime(double successfulAverageTime) {
        this.successfulAverageTime = successfulAverageTime;
    }

    public String toString() {
        return "Proxy{timeInterval=" + this.timeInterval + ", ip='" + this.ip + '\'' + ", port=" + this.port + ", availableFlag=" + this.availableFlag + ", anonymousFlag=" + this.anonymousFlag + ", lastSuccessfulTime=" + this.lastSuccessfulTime + ", successfulTotalTime=" + this.successfulTotalTime + ", failureTimes=" + this.failureTimes + ", successfulTimes=" + this.successfulTimes + ", successfulAverageTime=" + this.successfulAverageTime + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Proxy proxy = (Proxy)o;
        if (this.port != proxy.port) {
            return false;
        }
        return this.ip.equals(proxy.ip);
    }

    public int hashCode() {
        int result = this.ip.hashCode();
        result = 31 * result + this.port;
        return result;
    }

    public String getProxyStr() {
        return this.type + "://" + this.ip + ":" + this.port;
    }

    public HttpHost toHttpHost() {
        return new HttpHost(this.ip, this.port, this.type);
    }
}

