/*
 * Decompiled with CFR 0.152.
 */
package com.cv4j.proxy.http;

import com.cv4j.proxy.config.Constant;
import com.cv4j.proxy.domain.Page;
import com.cv4j.proxy.domain.Proxy;
import com.cv4j.proxy.http.RetryHandler;
import com.safframework.tony.common.utils.IOUtils;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Random;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class HttpManager {
    private static PoolingHttpClientConnectionManager connManager = null;

    private HttpManager() {
    }

    public static HttpManager get() {
        return Holder.MANAGER;
    }

    public CloseableHttpClient createHttpClient() {
        return this.createHttpClient(20000, null, null);
    }

    public CloseableHttpClient createHttpClient(int timeOut, HttpHost proxy, BasicClientCookie cookie) {
        RequestConfig.Builder builder = RequestConfig.custom().setConnectionRequestTimeout(timeOut).setConnectTimeout(timeOut).setSocketTimeout(timeOut).setCookieSpec("standard");
        if (proxy != null) {
            builder.setProxy(proxy);
        }
        RequestConfig requestConfig = builder.build();
        HttpClientBuilder httpClientBuilder = HttpClients.custom();
        httpClientBuilder.setDefaultRequestConfig(requestConfig).setRetryHandler((HttpRequestRetryHandler)new RetryHandler()).setConnectionManager((HttpClientConnectionManager)connManager);
        if (cookie != null) {
            BasicCookieStore cookieStore = new BasicCookieStore();
            cookieStore.addCookie((Cookie)cookie);
            httpClientBuilder.setDefaultCookieStore((CookieStore)cookieStore);
        }
        return httpClientBuilder.build();
    }

    public CloseableHttpResponse getResponse(String url) {
        return this.getResponse(url, null);
    }

    public CloseableHttpResponse getResponse(String url, Proxy proxy) {
        HttpGet request = new HttpGet(url);
        return this.getResponse((HttpRequestBase)request, proxy);
    }

    public CloseableHttpResponse getResponse(HttpRequestBase request, Proxy proxy) {
        request.setHeader("User-Agent", Constant.userAgentArray[new Random().nextInt(Constant.userAgentArray.length)]);
        HttpClientContext httpClientContext = HttpClientContext.create();
        CloseableHttpResponse response = null;
        try {
            response = proxy == null ? this.createHttpClient().execute((HttpUriRequest)request, (HttpContext)httpClientContext) : this.createHttpClient(20000, proxy.toHttpHost(), null).execute((HttpUriRequest)request, (HttpContext)httpClientContext);
        }
        catch (NoHttpResponseException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkProxy(HttpHost proxy) {
        if (proxy == null) {
            return false;
        }
        Socket socket = null;
        try {
            socket = new Socket();
            InetSocketAddress endpointSocketAddr = new InetSocketAddress(proxy.getHostName(), proxy.getPort());
            socket.connect(endpointSocketAddr, 3000);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            IOUtils.closeQuietly((Closeable)socket);
        }
    }

    public Page getWebPage(String url) throws IOException {
        return this.getWebPage(url, "UTF-8", null);
    }

    public Page getWebPage(String url, Proxy proxy) throws IOException {
        return this.getWebPage(url, "UTF-8", proxy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Page getWebPage(String url, String charset, Proxy proxy) throws IOException {
        Page page = new Page();
        CloseableHttpResponse response = null;
        response = proxy == null ? HttpManager.get().getResponse(url) : HttpManager.get().getResponse(url, proxy);
        if (response != null) {
            page.setStatusCode(response.getStatusLine().getStatusCode());
            page.setUrl(url);
            try {
                if (page.getStatusCode() != 200) return page;
                page.setHtml(EntityUtils.toString((HttpEntity)response.getEntity(), (String)charset));
                return page;
            }
            catch (IOException e) {
                e.printStackTrace();
                return page;
            }
            finally {
                IOUtils.closeQuietly((Closeable)response);
            }
        } else {
            page.setUrl(url);
        }
        return page;
    }

    static {
        SSLContext sslcontext = null;
        try {
            sslcontext = SSLContext.getInstance("TLS");
            sslcontext.init(null, new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }}, null);
            SSLConnectionSocketFactory scsf = new SSLConnectionSocketFactory(sslcontext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            RequestConfig defaultConfig = RequestConfig.custom().setCookieSpec("standard-strict").setExpectContinueEnabled(true).setTargetPreferredAuthSchemes(Arrays.asList("NTLM", "Digest")).setProxyPreferredAuthSchemes(Arrays.asList("Basic")).build();
            Registry sfr = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)scsf).build();
            connManager = new PoolingHttpClientConnectionManager(sfr);
            connManager.setMaxTotal(200);
            connManager.setDefaultMaxPerRoute(20);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
    }

    private static class Holder {
        private static final HttpManager MANAGER = new HttpManager();

        private Holder() {
        }
    }
}

