/*
 * Decompiled with CFR 0.152.
 */
package com.cv4j.proxy.site.coderbusy;

import com.cv4j.proxy.ProxyListPageParser;
import com.cv4j.proxy.domain.Proxy;
import java.util.ArrayList;
import java.util.List;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoderBusyProxyListPageParser
implements ProxyListPageParser {
    private static final Logger log = LoggerFactory.getLogger(CoderBusyProxyListPageParser.class);

    @Override
    public List<Proxy> parse(String content) {
        Document document = Jsoup.parse((String)content);
        Elements elements = document.select("div[class='card-table'] table tr:gt(0)");
        ArrayList<Proxy> proxyList = new ArrayList<Proxy>(elements.size());
        for (Element element : elements) {
            String ip = element.select("td:eq(0)").first().text();
            String port = element.select("td:eq(1)").first().text();
            String type = element.select("td:eq(4)").first().text();
            String isAnonymous = element.select("td:eq(6)").first().text();
            log.debug("parse result = " + type + "://" + ip + ":" + port + "  " + isAnonymous);
            if (!isAnonymous.contains("\u533f")) continue;
            proxyList.add(new Proxy(ip, Integer.valueOf(port), type, 1000L));
        }
        return proxyList;
    }
}

