/*
 * Decompiled with CFR 0.152.
 */
package com.cv4j.proxy.task;

import com.cv4j.proxy.ProxyListPageParser;
import com.cv4j.proxy.ProxyPool;
import com.cv4j.proxy.domain.Page;
import com.cv4j.proxy.domain.Proxy;
import com.cv4j.proxy.http.HttpManager;
import com.cv4j.proxy.site.ProxyListPageParserFactory;
import com.safframework.tony.common.utils.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyPageCallable
implements Callable<List<Proxy>> {
    private static final Logger log = LoggerFactory.getLogger(ProxyPageCallable.class);
    protected String url;

    public ProxyPageCallable(String url) {
        this.url = url;
    }

    @Override
    public List<Proxy> call() throws Exception {
        long requestStartTime = System.currentTimeMillis();
        try {
            Page page = HttpManager.get().getWebPage(this.url);
            int status = page.getStatusCode();
            long requestEndTime = System.currentTimeMillis();
            StringBuilder sb = new StringBuilder();
            sb.append(Thread.currentThread().getName()).append(" ").append("  ,executing request ").append(page.getUrl()).append(" ,response statusCode:").append(status).append("  ,request cost time:").append(requestEndTime - requestStartTime).append("ms");
            String logStr = sb.toString();
            if (status == 200) {
                log.info("Success: " + logStr);
                return this.handle(page);
            }
            if (status >= 400) {
                Proxy proxy = null;
                for (int i = 0; i < 3; ++i) {
                    proxy = ProxyPool.getProxy();
                    if (proxy == null || !HttpManager.get().checkProxy(proxy.toHttpHost())) continue;
                    requestStartTime = System.currentTimeMillis();
                    page = HttpManager.get().getWebPage(this.url, proxy);
                    status = page.getStatusCode();
                    requestEndTime = System.currentTimeMillis();
                    sb = new StringBuilder();
                    sb.append(Thread.currentThread().getName()).append(" ").append("  ,executing request ").append(page.getUrl()).append(" ,response statusCode:").append(status).append("  ,request cost time:").append(requestEndTime - requestStartTime).append("ms");
                    logStr = sb.toString();
                    if (status == 200) {
                        log.info("Success: " + logStr);
                        return this.handle(page);
                    }
                    log.info("Failure: " + logStr);
                }
            } else {
                log.info("Failure: " + logStr);
            }
        }
        catch (IOException e) {
            log.info("IOException: e=" + e.getMessage());
        }
        return new ArrayList<Proxy>();
    }

    private List<Proxy> handle(Page page) {
        List<Proxy> proxyList;
        if (page == null || Preconditions.isBlank((Object)page.getHtml())) {
            return new ArrayList<Proxy>();
        }
        ArrayList<Proxy> result = new ArrayList<Proxy>();
        ProxyListPageParser parser = ProxyListPageParserFactory.getProxyListPageParser(ProxyPool.proxyMap.get(this.url));
        if (parser != null && Preconditions.isNotBlank(proxyList = parser.parse(page.getHtml()))) {
            for (Proxy p : proxyList) {
                if (ProxyPool.proxyList.contains(p)) continue;
                result.add(p);
            }
        }
        return result;
    }
}

