/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.common.base;

import com.diffplug.common.base.Box;
import com.diffplug.common.base.Converter;
import com.diffplug.common.base.ConverterNullable;
import java.util.Objects;
import java.util.function.Function;

final class BoxImp {
    private BoxImp() {
    }

    static final class Nullable {
        private Nullable() {
        }

        static final class Mapped<T, R>
        implements Box.Nullable<R> {
            private final Box.Nullable<T> delegate;
            private final ConverterNullable<T, R> converter;

            public Mapped(Box.Nullable<T> delegate, ConverterNullable<T, R> converter) {
                this.delegate = delegate;
                this.converter = converter;
            }

            @Override
            @javax.annotation.Nullable
            public R get() {
                return this.converter.convert(this.delegate.get());
            }

            @Override
            public void set(@javax.annotation.Nullable R value) {
                this.delegate.set(this.converter.revert(value));
            }

            @Override
            public R modify(Function<? super R, ? extends R> mutator) {
                Objects.requireNonNull(mutator);
                Box.Nullable<Object> result = Box.Nullable.of(null);
                this.delegate.modify((? super T input) -> {
                    Object unmappedResult = mutator.apply((R)this.converter.convert(input));
                    result.set(unmappedResult);
                    return this.converter.revert(unmappedResult);
                });
                return (R)result.get();
            }

            public String toString() {
                return "[" + this.delegate + " mapped to [" + this.get() + "] by " + this.converter + "]";
            }
        }

        static final class Volatile<T>
        implements Box.Nullable<T> {
            private volatile T obj;

            Volatile(T init) {
                this.set(init);
            }

            @Override
            @javax.annotation.Nullable
            public T get() {
                return this.obj;
            }

            @Override
            public void set(@javax.annotation.Nullable T obj) {
                this.obj = obj;
            }

            public String toString() {
                return "Box.Nullable.ofVolatile[" + this.get() + "]";
            }
        }

        static final class Default<T>
        implements Box.Nullable<T> {
            private T obj;

            Default(T init) {
                this.obj = init;
            }

            @Override
            public T get() {
                return this.obj;
            }

            @Override
            public void set(T obj) {
                this.obj = obj;
            }

            public String toString() {
                return "Box.Nullable.of[" + this.get() + "]";
            }
        }
    }

    public static final class Volatile<T>
    implements Box<T> {
        private volatile T obj;

        Volatile(T init) {
            this.set(init);
        }

        @Override
        public T get() {
            return this.obj;
        }

        @Override
        public void set(T obj) {
            this.obj = Objects.requireNonNull(obj);
        }

        public String toString() {
            return "Box.ofVolatile[" + this.get() + "]";
        }
    }

    public static final class Default<T>
    implements Box<T> {
        private T obj;

        Default(T init) {
            this.set(init);
        }

        @Override
        public T get() {
            return this.obj;
        }

        @Override
        public void set(T obj) {
            this.obj = Objects.requireNonNull(obj);
        }

        public String toString() {
            return "Box.of[" + this.get() + "]";
        }
    }

    public static final class Mapped<T, R>
    implements Box<R> {
        private final Box<T> delegate;
        private final Converter<T, R> converter;

        public Mapped(Box<T> delegate, Converter<T, R> converter) {
            this.delegate = delegate;
            this.converter = converter;
        }

        @Override
        public R get() {
            return this.converter.convertNonNull(this.delegate.get());
        }

        @Override
        public void set(R value) {
            this.delegate.set(this.converter.revertNonNull(value));
        }

        @Override
        public R modify(Function<? super R, ? extends R> mutator) {
            Objects.requireNonNull(mutator);
            Box.Nullable<Object> result = Box.Nullable.of(null);
            this.delegate.modify((? super T input) -> {
                Object unmappedResult = mutator.apply((R)this.converter.convertNonNull(input));
                result.set(unmappedResult);
                return this.converter.revertNonNull(unmappedResult);
            });
            return (R)result.get();
        }

        public String toString() {
            return "[" + this.delegate + " mapped to [" + this.get() + "] by " + this.converter + "]";
        }
    }
}

