/*
 * Decompiled with CFR 0.152.
 */
package com.dingtalk.chatbot.message;

import com.alibaba.fastjson.JSON;
import com.dingtalk.chatbot.message.Message;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextMessage
implements Message {
    private String text;
    private List<String> atMobiles;
    private boolean isAtAll;

    public TextMessage(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public List<String> getAtMobiles() {
        return this.atMobiles;
    }

    public void setAtMobiles(List<String> atMobiles) {
        this.atMobiles = atMobiles;
    }

    public boolean isAtAll() {
        return this.isAtAll;
    }

    public void setIsAtAll(boolean isAtAll) {
        this.isAtAll = isAtAll;
    }

    @Override
    public String toJsonString() {
        HashMap<String, Object> items = new HashMap<String, Object>();
        items.put("msgtype", "text");
        HashMap<String, String> textContent = new HashMap<String, String>();
        if (StringUtils.isBlank((CharSequence)this.text)) {
            throw new IllegalArgumentException("text should not be blank");
        }
        textContent.put("content", this.text);
        items.put("text", textContent);
        HashMap<String, Object> atItems = new HashMap<String, Object>();
        if (this.atMobiles != null && !this.atMobiles.isEmpty()) {
            atItems.put("atMobiles", this.atMobiles);
        }
        if (this.isAtAll) {
            atItems.put("isAtAll", this.isAtAll);
        }
        items.put("at", atItems);
        return JSON.toJSONString(items);
    }
}

