/*
 * Decompiled with CFR 0.152.
 */
package com.dingtalk.chatbot.demo;

import com.dingtalk.chatbot.DingtalkChatbotClient;
import com.dingtalk.chatbot.SendResult;
import com.dingtalk.chatbot.message.MarkdownMessage;
import java.net.URLEncoder;
import java.util.ArrayList;
import org.junit.Test;

public class MarkdownMessageTest {
    private DingtalkChatbotClient client = new DingtalkChatbotClient();

    @Test
    public void testSendMarkdownMessage() throws Exception {
        MarkdownMessage message = new MarkdownMessage();
        message.setTitle("This is a markdown message");
        message.add(MarkdownMessage.getHeaderText(1, "header 1"));
        message.add(MarkdownMessage.getHeaderText(2, "header 2"));
        message.add(MarkdownMessage.getHeaderText(3, "header 3"));
        message.add(MarkdownMessage.getHeaderText(4, "header 4"));
        message.add(MarkdownMessage.getHeaderText(5, "header 5"));
        message.add(MarkdownMessage.getHeaderText(6, "header 6"));
        message.add(MarkdownMessage.getReferenceText("reference text"));
        message.add("\n\n");
        message.add("normal text");
        message.add("\n\n");
        message.add(MarkdownMessage.getBoldText("Bold Text"));
        message.add("\n\n");
        message.add(MarkdownMessage.getItalicText("Italic Text"));
        message.add("\n\n");
        ArrayList<String> orderList = new ArrayList<String>();
        orderList.add("order item1");
        orderList.add("order item2");
        message.add(MarkdownMessage.getOrderListText(orderList));
        message.add("\n\n");
        ArrayList<String> unorderList = new ArrayList<String>();
        unorderList.add("unorder item1");
        unorderList.add("unorder item2");
        message.add(MarkdownMessage.getUnorderListText(unorderList));
        message.add("\n\n");
        message.add(MarkdownMessage.getImageText("http://img01.taobaocdn.com/top/i1/LB1GCdYQXXXXXXtaFXXXXXXXXXX"));
        message.add(MarkdownMessage.getLinkText("This is a link", "dtmd://dingtalkclient/sendMessage?content=linkmessage"));
        message.add(MarkdownMessage.getLinkText("\u4e2d\u6587\u8df3\u8f6c", "dtmd://dingtalkclient/sendMessage?content=" + URLEncoder.encode("\u94fe\u63a5\u6d88\u606f", "UTF-8")));
        SendResult result = this.client.send("https://oapi.dingtalk.com/robot/send?access_token=5dbe45a28dfcf369a8ac651461ebf5205f3ed1c19b61e3a08e180070e18aca4c", message);
        System.out.println(result);
    }
}

