/*
 * Decompiled with CFR 0.152.
 */
package com.dingtalk.chatbot.message;

import com.alibaba.fastjson.JSON;
import com.dingtalk.chatbot.message.FeedCardMessageItem;
import com.dingtalk.chatbot.message.Message;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeedCardMessage
implements Message {
    private List<FeedCardMessageItem> feedItems;

    public List<FeedCardMessageItem> getFeedItems() {
        return this.feedItems;
    }

    public void setFeedItems(List<FeedCardMessageItem> feedItems) {
        this.feedItems = feedItems;
    }

    @Override
    public String toJsonString() {
        HashMap<String, Object> items = new HashMap<String, Object>();
        items.put("msgtype", "feedCard");
        HashMap<String, List<FeedCardMessageItem>> feedCard = new HashMap<String, List<FeedCardMessageItem>>();
        if (this.feedItems == null || this.feedItems.isEmpty()) {
            throw new IllegalArgumentException("feedItems should not be null or empty");
        }
        for (FeedCardMessageItem item : this.feedItems) {
            if (StringUtils.isBlank((CharSequence)item.getTitle())) {
                throw new IllegalArgumentException("title should not be blank");
            }
            if (StringUtils.isBlank((CharSequence)item.getMessageURL())) {
                throw new IllegalArgumentException("messageURL should not be blank");
            }
            if (!StringUtils.isBlank((CharSequence)item.getPicURL())) continue;
            throw new IllegalArgumentException("picURL should not be blank");
        }
        feedCard.put("links", this.feedItems);
        items.put("feedCard", feedCard);
        return JSON.toJSONString(items);
    }
}

