/*
 * Decompiled with CFR 0.152.
 */
package com.dingtalk.open.app.api;

import com.dingtalk.open.app.api.ClientOption;
import com.dingtalk.open.app.api.DingTalkAppError;
import com.dingtalk.open.app.api.OpenDingTalkAppException;
import com.dingtalk.open.app.api.OpenDingTalkClient;
import com.dingtalk.open.app.api.UserAgent;
import com.dingtalk.open.app.api.command.CommandDispatcher;
import com.dingtalk.open.app.api.open.OpenApiClient;
import com.dingtalk.open.app.api.open.OpenApiClientBuilder;
import com.dingtalk.open.app.api.open.OpenConnectionRequest;
import com.dingtalk.open.app.api.open.OpenConnectionResponse;
import com.dingtalk.open.app.api.protocol.AppServiceListener;
import com.dingtalk.open.app.api.security.DingTalkCredential;
import com.dingtalk.open.app.api.util.IpUtils;
import com.dingtalk.open.app.stream.network.api.EndPointConnection;
import com.dingtalk.open.app.stream.network.core.EndPointConnectionFactory;
import com.dingtalk.open.app.stream.network.core.NetWorkService;
import com.dingtalk.open.app.stream.network.core.Subscription;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;

class OpenDingTalkStreamClient
implements OpenDingTalkClient {
    private final DingTalkCredential credential;
    private final CommandDispatcher dispatcher;
    private final ExecutorService executor;
    private final ClientOption option;
    private NetWorkService netWorkService;
    private OpenApiClient openApiClient;
    private Set<Subscription> subscriptions;
    private final AtomicReference<Status> status;

    public OpenDingTalkStreamClient(DingTalkCredential credential, CommandDispatcher dispatcher, ExecutorService executor, ClientOption option, Set<Subscription> subscriptions) {
        this.credential = credential;
        this.dispatcher = dispatcher;
        this.executor = executor;
        this.option = option;
        this.subscriptions = Collections.unmodifiableSet(subscriptions);
        this.status = new AtomicReference<Status>(Status.INIT);
    }

    @Override
    public synchronized void start() throws OpenDingTalkAppException {
        if (this.status.get() == Status.INIT) {
            this.openApiClient = OpenApiClientBuilder.create().setHost(this.option.getOpenApiHost()).setTimeout(this.option.getConnectionTTL()).build();
            EndPointConnectionFactory factory = () -> this.openConnection(this.credential, this.subscriptions);
            AppServiceListener listener = new AppServiceListener(this.dispatcher, this.executor);
            this.netWorkService = new NetWorkService(factory, listener, this.option.getMaxConnectionCount(), this.option.getConnectionTTL(), this.option.getConnectTimeout(), this.option.getKeepAliveOption().getKeepAliveIdleMill());
            this.netWorkService.start();
            this.status.set(Status.ACTIVE);
        } else if (this.status.get() == Status.INACTIVE) {
            throw new OpenDingTalkAppException(DingTalkAppError.CLIENT_STATE_ERROR, new String[0]);
        }
    }

    @Override
    public synchronized void stop() throws Exception {
        if (this.status.get() == Status.ACTIVE) {
            if (this.netWorkService != null) {
                this.netWorkService.shutdown();
            }
            if (this.executor != null) {
                this.executor.shutdown();
            }
            this.status.set(Status.INACTIVE);
        }
    }

    private EndPointConnection openConnection(DingTalkCredential credential, Set<Subscription> subscriptions) throws Exception {
        OpenConnectionRequest request = new OpenConnectionRequest();
        request.setClientId(credential.getClientId());
        request.setClientSecret(credential.getClientSecret());
        request.setUa(UserAgent.getUserAgent().getUa());
        request.setSubscriptions(subscriptions);
        request.setLocalIp(IpUtils.getLocalIP());
        OpenConnectionResponse response = this.openApiClient.openConnection(request);
        return new EndPointConnection(credential.getClientId(), response.getEndpoint(), response.getTicket());
    }

    static enum Status {
        INIT,
        ACTIVE,
        INACTIVE;

    }
}

