/*
 * Decompiled with CFR 0.152.
 */
package com.dingtalk.open.app.api.open;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.dingtalk.open.app.api.DingTalkAppError;
import com.dingtalk.open.app.api.open.OpenApiClient;
import com.dingtalk.open.app.api.open.OpenConnectionRequest;
import com.dingtalk.open.app.api.open.OpenConnectionResponse;
import com.dingtalk.open.app.api.util.IoUtils;
import java.net.HttpURLConnection;
import java.net.URL;

class HttpOpenApiClient
implements OpenApiClient {
    private final String host;
    private final int timeout;

    public HttpOpenApiClient(String host, int timeout) {
        this.host = host;
        this.timeout = timeout;
    }

    @Override
    public OpenConnectionResponse openConnection(OpenConnectionRequest request) throws Exception {
        HttpURLConnection connection = (HttpURLConnection)new URL(this.host + "/v1.0/gateway/connections/open").openConnection();
        connection.setRequestMethod("POST");
        connection.setReadTimeout(this.timeout);
        connection.setConnectTimeout(this.timeout);
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setRequestProperty("Accept", "application/json");
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.connect();
        connection.getOutputStream().write(JSON.toJSONBytes((Object)request, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteEnumUsingToString}));
        connection.getOutputStream().flush();
        if (connection.getResponseCode() == 200) {
            byte[] content = IoUtils.readAll(connection.getInputStream());
            return (OpenConnectionResponse)JSON.parseObject((byte[])content, OpenConnectionResponse.class, (Feature[])new Feature[0]);
        }
        byte[] content = IoUtils.readAll(connection.getErrorStream());
        throw DingTalkAppError.HTTP_ERROR_RESPONSE.toException(String.format("status=%s,msg=%s", connection.getResponseCode(), content != null ? new String(content) : ""));
    }
}

