/*
 * Decompiled with CFR 0.152.
 */
package com.dingtalk.open.app.stream.network.api;

import com.dingtalk.open.app.stream.network.api.TransportProtocol;
import java.net.URI;
import java.net.URISyntaxException;

public class EndPointConnection {
    private final String clientId;
    private final URI endPoint;
    private final String connectionId;

    public EndPointConnection(String clientId, String endPoint, String connectionId) {
        this.clientId = clientId;
        try {
            this.endPoint = new URI(endPoint);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        this.connectionId = connectionId;
    }

    public URI getEndPoint() {
        return this.endPoint;
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public TransportProtocol getProtocol() {
        return TransportProtocol.parseScheme(this.endPoint.getScheme());
    }
}

