/*
 * Decompiled with CFR 0.152.
 */
package com.dingtalk.open.app.stream.network.ws;

import com.dingtalk.open.app.stream.network.api.ClientConnectionListener;
import com.dingtalk.open.app.stream.network.api.ConnectOption;
import com.dingtalk.open.app.stream.network.api.EndPointConnection;
import com.dingtalk.open.app.stream.network.api.NetworkSharedResources;
import com.dingtalk.open.app.stream.network.api.Protocol;
import com.dingtalk.open.app.stream.network.api.Session;
import com.dingtalk.open.app.stream.network.api.TransportConnector;
import com.dingtalk.open.app.stream.network.api.TransportProtocol;
import com.dingtalk.open.app.stream.network.api.logger.InternalLogger;
import com.dingtalk.open.app.stream.network.api.logger.InternalLoggerFactory;
import com.dingtalk.open.app.stream.network.ws.KeepAliveHandler;
import com.dingtalk.open.app.stream.network.ws.NettyClientHandler;
import com.dingtalk.open.app.stream.network.ws.ProtocolConnectHandler;
import com.dingtalk.open.app.stream.network.ws.ProtocolFrameHandler;
import com.dingtalk.open.app.stream.network.ws.WebSocketSession;
import com.dingtalk.open.app.stream.network.ws.WebsocketIdleHandler;
import java.net.URI;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import shade.io.netty.bootstrap.Bootstrap;
import shade.io.netty.channel.Channel;
import shade.io.netty.channel.ChannelInitializer;
import shade.io.netty.channel.socket.SocketChannel;
import shade.io.netty.channel.socket.nio.NioSocketChannel;
import shade.io.netty.handler.codec.http.HttpClientCodec;
import shade.io.netty.handler.codec.http.HttpObjectAggregator;
import shade.io.netty.handler.codec.http.websocketx.WebSocketClientProtocolConfig;
import shade.io.netty.handler.codec.http.websocketx.WebSocketClientProtocolHandler;
import shade.io.netty.handler.ssl.SslContext;
import shade.io.netty.handler.ssl.SslContextBuilder;
import shade.io.netty.handler.ssl.SslHandler;

@Protocol(protocol={TransportProtocol.WSS})
public class WebsocketTransportConnector
implements TransportConnector {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getLogger(WebsocketTransportConnector.class);

    @Override
    public Session connect(final EndPointConnection connection, final ClientConnectionListener listener, final ConnectOption option) throws Exception {
        LOGGER.info("[DingTalk] start websocket connection, uri={}", connection.getEndPoint().toString());
        final CompletableFuture future = new CompletableFuture();
        Bootstrap bootstrap = new Bootstrap();
        bootstrap.channel(NioSocketChannel.class);
        bootstrap.group(NetworkSharedResources.getNetWorkEventLoopGroup());
        ((Bootstrap)bootstrap.handler(new ChannelInitializer<SocketChannel>(){

            @Override
            protected void initChannel(SocketChannel socketChannel) throws Exception {
                WebSocketClientProtocolConfig config = WebSocketClientProtocolConfig.newBuilder().dropPongFrames(false).webSocketUri(WebsocketTransportConnector.configureWebsocketUri(connection)).handshakeTimeoutMillis(option.getTtl()).dropPongFrames(false).handleCloseFrames(true).build();
                SslContext sslContext = SslContextBuilder.forClient().build();
                if (connection.getProtocol().isTls()) {
                    SSLEngine engine = sslContext.newEngine(socketChannel.alloc());
                    SSLParameters sslParameters = new SSLParameters();
                    sslParameters.setServerNames(Collections.singletonList(new SNIHostName(connection.getEndPoint().getHost())));
                    engine.setSSLParameters(sslParameters);
                    socketChannel.pipeline().addLast(new SslHandler(engine));
                }
                socketChannel.pipeline().addLast(new HttpClientCodec());
                socketChannel.pipeline().addLast(new HttpObjectAggregator(8192));
                socketChannel.pipeline().addLast(new WebSocketClientProtocolHandler(config));
                socketChannel.pipeline().addLast(new WebsocketIdleHandler(option.getKeepAliveIdle()));
                socketChannel.pipeline().addLast(new ProtocolConnectHandler(future, option.getTimeout()));
                socketChannel.pipeline().addLast(new KeepAliveHandler(option.getKeepAliveTimeout()));
                socketChannel.pipeline().addLast(new ProtocolFrameHandler());
                socketChannel.pipeline().addLast(new NettyClientHandler(connection.getConnectionId(), listener));
            }
        })).connect(connection.getEndPoint().getHost(), connection.getEndPoint().getPort());
        future.get(option.getTimeout(), TimeUnit.MILLISECONDS);
        return new WebSocketSession((Channel)future.get(), connection.getConnectionId(), option.getTtl());
    }

    private static URI configureWebsocketUri(EndPointConnection connection) throws Exception {
        return new URI(connection.getEndPoint().getScheme() + "://" + connection.getEndPoint().getHost() + ":" + connection.getEndPoint().getPort() + "/connect?ticket=" + connection.getConnectionId());
    }
}

