/*
 * Decompiled with CFR 0.152.
 */
package com.foldright.auto.pipeline.processor.generator;

import com.foldright.auto.pipeline.processor.AutoPipelineClassDescriptor;
import com.foldright.auto.pipeline.processor.AutoPipelineOperatorsDescriptor;
import com.foldright.auto.pipeline.processor.generator.AbstractGenerator;
import com.foldright.auto.pipeline.processor.generator.PipelineGenerator;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Modifier;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/foldright/auto/pipeline/processor/generator/PipelineGenerator;", "Lcom/foldright/auto/pipeline/processor/generator/AbstractGenerator;", "desc", "Lcom/foldright/auto/pipeline/processor/AutoPipelineClassDescriptor;", "filer", "Ljavax/annotation/processing/Filer;", "(Lcom/foldright/auto/pipeline/processor/AutoPipelineClassDescriptor;Ljavax/annotation/processing/Filer;)V", "gen", "", "auto-pipeline-processor"})
public final class PipelineGenerator
extends AbstractGenerator {
    @NotNull
    private final AutoPipelineClassDescriptor desc;
    @NotNull
    private final Filer filer;

    public PipelineGenerator(@NotNull AutoPipelineClassDescriptor desc, @NotNull Filer filer) {
        Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
        Intrinsics.checkNotNullParameter((Object)filer, (String)"filer");
        super(desc);
        this.desc = desc;
        this.filer = filer;
    }

    public final void gen() {
        Modifier[] modifierArray = new Modifier[]{Modifier.PUBLIC};
        TypeSpec.Builder builder = TypeSpec.classBuilder((ClassName)this.desc.getPipelineRawClassName()).addModifiers(modifierArray).addTypeVariables((Iterable)this.desc.getEntityDeclaredTypeVariables()).addSuperinterface(this.desc.getEntityType());
        modifierArray = new Modifier[]{Modifier.PRIVATE, Modifier.FINAL};
        TypeSpec.Builder builder2 = builder.addField(this.desc.getAbstractHandlerContextTypeName(), "head", modifierArray);
        modifierArray = new Modifier[]{Modifier.PRIVATE, Modifier.FINAL};
        TypeSpec.Builder pipelineClassBuilder = builder2.addField(this.desc.getAbstractHandlerContextTypeName(), "tail", modifierArray);
        Modifier[] modifierArray2 = new Modifier[]{Modifier.PUBLIC};
        MethodSpec pipelineConstructor = MethodSpec.constructorBuilder().addModifiers(modifierArray2).addCode("head = new HeadContext(this);\ntail = new TailContext(this);\n\nhead.prev = null;\nhead.next = tail;\ntail.prev = head;\ntail.next = null;", new Object[0]).build();
        pipelineClassBuilder.addMethod(pipelineConstructor);
        pipelineClassBuilder.addMethods((Iterable)this.genPipelineOverrideMethodsViaDelegate("head"));
        Object[] objectArray = new Modifier[]{Modifier.PUBLIC, Modifier.SYNCHRONIZED};
        MethodSpec.Builder builder3 = MethodSpec.methodBuilder((String)"addFirst").addModifiers(objectArray).addParameter(this.desc.getHandlerTypeName(), "handler", new Modifier[0]).returns(this.desc.getPipelineTypeName());
        objectArray = new Object[]{this.desc.getAbstractHandlerContextTypeName(), this.desc.getDefaultHandlerContextTypeName(), this.desc.getAbstractHandlerContextTypeName()};
        MethodSpec addFirstMethod = builder3.addCode("$T newCtx = new $T(this, handler);\n$T nextCtx = head.next;\nhead.next = newCtx;\nnewCtx.prev = head;\nnewCtx.next = nextCtx;\nnextCtx.prev = newCtx;\n\nreturn this;", objectArray).build();
        pipelineClassBuilder.addMethod(addFirstMethod);
        Modifier[] modifierArray3 = new Modifier[]{Modifier.PUBLIC, Modifier.SYNCHRONIZED};
        MethodSpec.Builder builder4 = MethodSpec.methodBuilder((String)"addFirst").addModifiers(modifierArray3);
        modifierArray3 = new TypeName[]{this.desc.getHandlerTypeName()};
        MethodSpec addFirstListMethod = builder4.addParameter((TypeName)ParameterizedTypeName.get((ClassName)this.desc.getListTypeName(), (TypeName[])modifierArray3), "handlers", new Modifier[0]).returns(this.desc.getPipelineTypeName()).addCode("if (handlers == null || handlers.isEmpty()) {\n    return this;\n}\n\nint size = handlers.size();\nfor (int i = 0; i < size; i++) {\n    addFirst(handlers.get(size - i - 1));\n}\n\nreturn this;", new Object[0]).build();
        pipelineClassBuilder.addMethod(addFirstListMethod);
        Object[] objectArray2 = new Modifier[]{Modifier.PUBLIC, Modifier.SYNCHRONIZED};
        MethodSpec.Builder builder5 = MethodSpec.methodBuilder((String)"addLast").addModifiers(objectArray2).addParameter(this.desc.getHandlerTypeName(), "handler", new Modifier[0]).returns(this.desc.getPipelineTypeName());
        objectArray2 = new Object[]{this.desc.getAbstractHandlerContextTypeName(), this.desc.getDefaultHandlerContextTypeName(), this.desc.getAbstractHandlerContextTypeName()};
        MethodSpec addLastMethod = builder5.addCode("$T newCtx = new $T(this, handler);\n$T prevCtx = tail.prev;\n\nnewCtx.prev = prevCtx;\nnewCtx.next = tail;\nprevCtx.next = newCtx;\ntail.prev = newCtx;\n\nreturn this;", objectArray2).build();
        pipelineClassBuilder.addMethod(addLastMethod);
        Object[] objectArray3 = new Modifier[]{Modifier.PUBLIC, Modifier.SYNCHRONIZED};
        MethodSpec.Builder builder6 = MethodSpec.methodBuilder((String)"addLast").addModifiers(objectArray3);
        objectArray3 = new TypeName[]{this.desc.getHandlerTypeName()};
        MethodSpec.Builder builder7 = builder6.addParameter((TypeName)ParameterizedTypeName.get((ClassName)this.desc.getListTypeName(), (TypeName[])objectArray3), "handlers", new Modifier[0]).returns(this.desc.getPipelineTypeName());
        objectArray3 = new Object[]{this.desc.getHandlerTypeName()};
        MethodSpec addLastListMethod = builder7.addCode("if (handlers == null || handlers.isEmpty()) {\n    return this;\n}\n\nfor ($T handler : handlers) {\n    addLast(handler);\n}\n\nreturn this;", objectArray3).build();
        pipelineClassBuilder.addMethod(addLastListMethod);
        Modifier[] modifierArray4 = new Modifier[]{Modifier.PRIVATE, Modifier.STATIC};
        TypeSpec.Builder builder8 = TypeSpec.classBuilder((String)"HeadContext").addModifiers(modifierArray4).addTypeVariables((Iterable)this.desc.getEntityDeclaredTypeVariables()).superclass(this.desc.getAbstractHandlerContextTypeName()).addMethod(MethodSpec.constructorBuilder().addParameter(this.desc.getPipelineTypeName(), "pipeline", new Modifier[0]).addStatement("super(pipeline)", new Object[0]).build());
        modifierArray4 = new Modifier[]{Modifier.PROTECTED};
        TypeSpec headContextClass = builder8.addMethod(MethodSpec.methodBuilder((String)"handler").addAnnotation(Override.class).addModifiers(modifierArray4).returns(this.desc.getHandlerTypeName()).addStatement("return null", new Object[0]).build()).addMethods((Iterable)this.genPipelineOverrideMethodsViaDelegate("next")).build();
        pipelineClassBuilder.addType(headContextClass);
        Modifier[] modifierArray5 = new Modifier[]{Modifier.PRIVATE, Modifier.STATIC};
        TypeSpec.Builder builder9 = TypeSpec.classBuilder((String)"TailContext").addModifiers(modifierArray5).addTypeVariables((Iterable)this.desc.getEntityDeclaredTypeVariables()).superclass(this.desc.getAbstractHandlerContextTypeName()).addMethod(MethodSpec.constructorBuilder().addParameter(this.desc.getPipelineTypeName(), "pipeline", new Modifier[0]).addStatement("super(pipeline)", new Object[0]).build());
        modifierArray5 = new Modifier[]{Modifier.PROTECTED};
        TypeSpec tailContextClass2 = builder9.addMethod(MethodSpec.methodBuilder((String)"handler").addAnnotation(Override.class).addModifiers(modifierArray5).returns(this.desc.getHandlerTypeName()).addStatement("return null", new Object[0]).build()).addMethods((Iterable)this.genPipelineOverrideMethods((Function1<? super AutoPipelineOperatorsDescriptor, String>)((Function1)gen.tailContextClass.1.INSTANCE))).build();
        pipelineClassBuilder.addType(tailContextClass2);
        modifierArray5 = this.desc.getPipelineRawClassName().packageName();
        Intrinsics.checkNotNullExpressionValue((Object)modifierArray5, (String)"desc.pipelineRawClassName.packageName()");
        Object object = modifierArray5;
        modifierArray5 = pipelineClassBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)modifierArray5, (String)"pipelineClassBuilder.build()");
        this.javaFileBuilder((String)object, (TypeSpec)modifierArray5).build().writeTo(this.filer);
    }
}

