package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.TaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.response.DeliveryTemplatesGetResponse;
import com.taobao.api.ApiRuleException;
/**
 * TOP API: taobao.delivery.templates.get request
 * 
 * @author auto create
 * @since 1.0, 2012-05-15 12:35:44
 */
public class DeliveryTemplatesGetRequest implements TaobaoRequest<DeliveryTemplatesGetResponse> {

	private TaobaoHashMap udfParams; // add user-defined text parameters
	private Long timestamp;

	/** 
	* 需返回的字段列表。 
可选值:DeliveryTemplate结构体中的所有字段以及定义的四个常量;各字段之间用","隔开
<br/> 
DeliveryTemplate结构:
template_id：查询模板ID template_name:查询模板名称 assumer：查询服务承担放 
valuation:查询计价规则 supports:查询增值服务列表 created:查询模板创建时间 modified:查询修改时间；
<br/>
常量:<br/>
query_cod:查询货到付款运费信息； 
query_post:查询平邮运费信息； 
query_express:查询快递公司运费信息； 
query_ems:查询EMS运费信息
<br/>
<font color=red>不能有空格</font>
	 */
	private String fields;

	public void setFields(String fields) {
		this.fields = fields;
	}
	public String getFields() {
		return this.fields;
	}

	public Long getTimestamp() {
		return this.timestamp;
	}
	public void setTimestamp(Long timestamp) {
		this.timestamp = timestamp;
	}

	public String getApiMethodName() {
		return "taobao.delivery.templates.get";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("fields", this.fields);
		if(udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public void putOtherTextParam(String key, String value) {
		if(this.udfParams == null) {
			this.udfParams = new TaobaoHashMap();
		}
		this.udfParams.put(key, value);
	}

	public Class<DeliveryTemplatesGetResponse> getResponseClass() {
		return DeliveryTemplatesGetResponse.class;
	}
	
	public void check() throws ApiRuleException {
		
		RequestCheckUtils.checkNotEmpty(fields,"fields");
	}
}
