package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.TaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.response.HotelRoomsUpdateResponse;
import com.taobao.api.ApiRuleException;
/**
 * TOP API: taobao.hotel.rooms.update request
 * 
 * @author auto create
 * @since 1.0, 2012-05-15 12:35:44
 */
public class HotelRoomsUpdateRequest implements TaobaoRequest<HotelRoomsUpdateResponse> {

	private TaobaoHashMap udfParams; // add user-defined text parameters
	private Long timestamp;

	/** 
	* 多商品房态信息。json encode。每个商品房态参考单商品更新中的room_quota字段。反序列化后入：array(( 'gid'=>1, 'roomQuota'=>array(('date'=>'2011-01-29', 'price'=>100, 'num'=>1),('date'=>'2011-01-30', 'price'=>100, 'num'=>1)),( 'gid'=>2, 'roomQuota'=>array(('date'=>'2011-01-29', 'price'=>100, 'num'=>1),('date'=>'2011-01-30', 'price'=>100, 'num'=>1)))
	 */
	private String gidRoomQuotaMap;

	public void setGidRoomQuotaMap(String gidRoomQuotaMap) {
		this.gidRoomQuotaMap = gidRoomQuotaMap;
	}
	public String getGidRoomQuotaMap() {
		return this.gidRoomQuotaMap;
	}

	public Long getTimestamp() {
		return this.timestamp;
	}
	public void setTimestamp(Long timestamp) {
		this.timestamp = timestamp;
	}

	public String getApiMethodName() {
		return "taobao.hotel.rooms.update";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("gid_room_quota_map", this.gidRoomQuotaMap);
		if(udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public void putOtherTextParam(String key, String value) {
		if(this.udfParams == null) {
			this.udfParams = new TaobaoHashMap();
		}
		this.udfParams.put(key, value);
	}

	public Class<HotelRoomsUpdateResponse> getResponseClass() {
		return HotelRoomsUpdateResponse.class;
	}
	
	public void check() throws ApiRuleException {
		
		RequestCheckUtils.checkNotEmpty(gidRoomQuotaMap,"gidRoomQuotaMap");
	}
}
