package com.taobao.api.request;

import java.util.Date;
import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.TaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.response.PosterPostersSearchResponse;
import com.taobao.api.ApiRuleException;
/**
 * TOP API: taobao.poster.posters.search request
 * 
 * @author auto create
 * @since 1.0, 2012-05-15 12:35:44
 */
public class PosterPostersSearchRequest implements TaobaoRequest<PosterPostersSearchResponse> {

	private TaobaoHashMap udfParams; // add user-defined text parameters
	private Long timestamp;

	/** 
	* 频道id列表
	 */
	private String channelIds;

	/** 
	* 编辑推荐：editor_recommend = 1；
	 */
	private Long editorRecommend;

	/** 
	* 结束时间
	 */
	private Date endDate;

	/** 
	* 关键词出现在标题，短标题，标签中
	 */
	private String keyWord;

	/** 
	* 当前页
	 */
	private Long pageNo;

	/** 
	* 每页显示画报数
<br>注：
<br>1.当输入的值小于10或者大于20，会按照默认值10返回
<br>2.最大支持20条返回
	 */
	private Long pageSize;

	/** 
	* 服饰 频道	{
推荐系数  2 	服饰—平铺图;
推荐系数  5	服饰—真人秀;
;推荐系数  7	服饰—风格秀场;
}
男人 频道{
推荐系数  8	男人频道—卖家画报;
}	
女人 频道{
推荐系数 6	女人频道—淘宝红人;
推荐系数 8	女人频道—优质街拍;
}	
亲子 频道{
推荐系数 1	亲子频道—亲子单品；
推荐系数 8	亲子频道—卖家画报；
}		
美容 频道{
推荐系数 5+关键字:护肤	美容频道—护肤内容；
推荐系数 5+关键字:彩妆	美容频道—彩妆内容；
推荐系数 5+关键字:美发	美容频道—扎发类内容；
}
居家 频道{
推荐系数 5	居家频道—线下体验馆-爱蜂潮；
}
	 */
	private Long recommendFactor;

	/** 
	* 1："点击升序"；
2："点击降序"；
3："创建时间升序"；
4："创建时间降序"；
	 */
	private Long sortType;

	/** 
	* 开始时间
	 */
	private Date startDate;

	/** 
	* 制作画报的 用户名
	 */
	private String userNick;

	public void setChannelIds(String channelIds) {
		this.channelIds = channelIds;
	}
	public String getChannelIds() {
		return this.channelIds;
	}

	public void setEditorRecommend(Long editorRecommend) {
		this.editorRecommend = editorRecommend;
	}
	public Long getEditorRecommend() {
		return this.editorRecommend;
	}

	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}
	public Date getEndDate() {
		return this.endDate;
	}

	public void setKeyWord(String keyWord) {
		this.keyWord = keyWord;
	}
	public String getKeyWord() {
		return this.keyWord;
	}

	public void setPageNo(Long pageNo) {
		this.pageNo = pageNo;
	}
	public Long getPageNo() {
		return this.pageNo;
	}

	public void setPageSize(Long pageSize) {
		this.pageSize = pageSize;
	}
	public Long getPageSize() {
		return this.pageSize;
	}

	public void setRecommendFactor(Long recommendFactor) {
		this.recommendFactor = recommendFactor;
	}
	public Long getRecommendFactor() {
		return this.recommendFactor;
	}

	public void setSortType(Long sortType) {
		this.sortType = sortType;
	}
	public Long getSortType() {
		return this.sortType;
	}

	public void setStartDate(Date startDate) {
		this.startDate = startDate;
	}
	public Date getStartDate() {
		return this.startDate;
	}

	public void setUserNick(String userNick) {
		this.userNick = userNick;
	}
	public String getUserNick() {
		return this.userNick;
	}

	public Long getTimestamp() {
		return this.timestamp;
	}
	public void setTimestamp(Long timestamp) {
		this.timestamp = timestamp;
	}

	public String getApiMethodName() {
		return "taobao.poster.posters.search";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("channel_ids", this.channelIds);
		txtParams.put("editor_recommend", this.editorRecommend);
		txtParams.put("end_date", this.endDate);
		txtParams.put("key_word", this.keyWord);
		txtParams.put("page_no", this.pageNo);
		txtParams.put("page_size", this.pageSize);
		txtParams.put("recommend_factor", this.recommendFactor);
		txtParams.put("sort_type", this.sortType);
		txtParams.put("start_date", this.startDate);
		txtParams.put("user_nick", this.userNick);
		if(udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public void putOtherTextParam(String key, String value) {
		if(this.udfParams == null) {
			this.udfParams = new TaobaoHashMap();
		}
		this.udfParams.put(key, value);
	}

	public Class<PosterPostersSearchResponse> getResponseClass() {
		return PosterPostersSearchResponse.class;
	}
	
	public void check() throws ApiRuleException {
		
		RequestCheckUtils.checkMaxListSize(channelIds,20,"channelIds");
		RequestCheckUtils.checkMaxLength(channelIds,100,"channelIds");
		RequestCheckUtils.checkMaxValue(editorRecommend,1L,"editorRecommend");
		RequestCheckUtils.checkMinValue(editorRecommend,1L,"editorRecommend");
		RequestCheckUtils.checkNotEmpty(pageNo,"pageNo");
		RequestCheckUtils.checkNotEmpty(pageSize,"pageSize");
		RequestCheckUtils.checkMaxValue(recommendFactor,10L,"recommendFactor");
		RequestCheckUtils.checkMinValue(recommendFactor,0L,"recommendFactor");
		RequestCheckUtils.checkMaxValue(sortType,4L,"sortType");
		RequestCheckUtils.checkMinValue(sortType,1L,"sortType");
	}
}
