package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.TaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.response.TaohuaItemcommentsGetResponse;
import com.taobao.api.ApiRuleException;
/**
 * TOP API: taobao.taohua.itemcomments.get request
 * 
 * @author auto create
 * @since 1.0, 2012-05-15 12:35:44
 */
public class TaohuaItemcommentsGetRequest implements TaobaoRequest<TaohuaItemcommentsGetResponse> {

	private TaobaoHashMap udfParams; // add user-defined text parameters
	private Long timestamp;

	/** 
	* 指定商品的ID
	 */
	private Long itemId;

	/** 
	* 页码。
取值范围：大于零的整数
默认值：1 即返回第一页数据
	 */
	private Long pageNo;

	/** 
	* 每页记录数
取值范围：大于零的整数 
默认值：10 即每页返回10条数据
	 */
	private Long pageSize;

	public void setItemId(Long itemId) {
		this.itemId = itemId;
	}
	public Long getItemId() {
		return this.itemId;
	}

	public void setPageNo(Long pageNo) {
		this.pageNo = pageNo;
	}
	public Long getPageNo() {
		return this.pageNo;
	}

	public void setPageSize(Long pageSize) {
		this.pageSize = pageSize;
	}
	public Long getPageSize() {
		return this.pageSize;
	}

	public Long getTimestamp() {
		return this.timestamp;
	}
	public void setTimestamp(Long timestamp) {
		this.timestamp = timestamp;
	}

	public String getApiMethodName() {
		return "taobao.taohua.itemcomments.get";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("item_id", this.itemId);
		txtParams.put("page_no", this.pageNo);
		txtParams.put("page_size", this.pageSize);
		if(udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public void putOtherTextParam(String key, String value) {
		if(this.udfParams == null) {
			this.udfParams = new TaobaoHashMap();
		}
		this.udfParams.put(key, value);
	}

	public Class<TaohuaItemcommentsGetResponse> getResponseClass() {
		return TaohuaItemcommentsGetResponse.class;
	}
	
	public void check() throws ApiRuleException {
		
		RequestCheckUtils.checkNotEmpty(itemId,"itemId");
		RequestCheckUtils.checkMinValue(pageNo,1L,"pageNo");
	}
}
