package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.TaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.response.WidgetCartitemAddResponse;
import com.taobao.api.ApiRuleException;
/**
 * TOP API: taobao.widget.cartitem.add request
 * 
 * @author auto create
 * @since 1.0, 2012-05-15 12:35:44
 */
public class WidgetCartitemAddRequest implements TaobaoRequest<WidgetCartitemAddResponse> {

	private TaobaoHashMap udfParams; // add user-defined text parameters
	private Long timestamp;

	/** 
	* 要购买的商品的数字id，同Item的num_iid字段
	 */
	private Long itemId;

	/** 
	* 需要购买的数量，至少购买1件
	 */
	private Long quantity;

	/** 
	* 要购买的sku的id，如果是无sku的商品此字段不传，如果是有sku的商品必需指定sku_id。同sku的sku_id字段
	 */
	private Long skuId;

	public void setItemId(Long itemId) {
		this.itemId = itemId;
	}
	public Long getItemId() {
		return this.itemId;
	}

	public void setQuantity(Long quantity) {
		this.quantity = quantity;
	}
	public Long getQuantity() {
		return this.quantity;
	}

	public void setSkuId(Long skuId) {
		this.skuId = skuId;
	}
	public Long getSkuId() {
		return this.skuId;
	}

	public Long getTimestamp() {
		return this.timestamp;
	}
	public void setTimestamp(Long timestamp) {
		this.timestamp = timestamp;
	}

	public String getApiMethodName() {
		return "taobao.widget.cartitem.add";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("item_id", this.itemId);
		txtParams.put("quantity", this.quantity);
		txtParams.put("sku_id", this.skuId);
		if(udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public void putOtherTextParam(String key, String value) {
		if(this.udfParams == null) {
			this.udfParams = new TaobaoHashMap();
		}
		this.udfParams.put(key, value);
	}

	public Class<WidgetCartitemAddResponse> getResponseClass() {
		return WidgetCartitemAddResponse.class;
	}
	
	public void check() throws ApiRuleException {
		
		RequestCheckUtils.checkNotEmpty(itemId,"itemId");
		RequestCheckUtils.checkNotEmpty(quantity,"quantity");
		RequestCheckUtils.checkMaxValue(quantity,999999L,"quantity");
		RequestCheckUtils.checkMinValue(quantity,1L,"quantity");
		RequestCheckUtils.checkMinValue(skuId,1L,"skuId");
	}
}
