package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.TaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.response.WidgetCartitemDeleteResponse;
import com.taobao.api.ApiRuleException;
/**
 * TOP API: taobao.widget.cartitem.delete request
 * 
 * @author auto create
 * @since 1.0, 2012-05-15 12:35:44
 */
public class WidgetCartitemDeleteRequest implements TaobaoRequest<WidgetCartitemDeleteResponse> {

	private TaobaoHashMap udfParams; // add user-defined text parameters
	private Long timestamp;

	/** 
	* 要删除的购物车记录id号
	 */
	private Long cartId;

	public void setCartId(Long cartId) {
		this.cartId = cartId;
	}
	public Long getCartId() {
		return this.cartId;
	}

	public Long getTimestamp() {
		return this.timestamp;
	}
	public void setTimestamp(Long timestamp) {
		this.timestamp = timestamp;
	}

	public String getApiMethodName() {
		return "taobao.widget.cartitem.delete";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("cart_id", this.cartId);
		if(udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public void putOtherTextParam(String key, String value) {
		if(this.udfParams == null) {
			this.udfParams = new TaobaoHashMap();
		}
		this.udfParams.put(key, value);
	}

	public Class<WidgetCartitemDeleteResponse> getResponseClass() {
		return WidgetCartitemDeleteResponse.class;
	}
	
	public void check() throws ApiRuleException {
		
		RequestCheckUtils.checkNotEmpty(cartId,"cartId");
		RequestCheckUtils.checkMinValue(cartId,1L,"cartId");
	}
}
