/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.internal.stream;

import com.taobao.api.internal.stream.Configuration;
import com.taobao.api.internal.stream.StreamImplementation;
import com.taobao.api.internal.stream.TopCometStream;
import com.taobao.api.internal.stream.TopCometStreamRequest;
import com.taobao.api.internal.stream.TopCometSysErrorException;
import com.taobao.api.internal.stream.connect.ConnectionLifeCycleListener;
import com.taobao.api.internal.stream.connect.HttpClient;
import com.taobao.api.internal.stream.connect.HttpResponse;
import com.taobao.api.internal.stream.message.MessageStreamImpl;
import com.taobao.api.internal.stream.message.StreamMsgConsumeFactory;
import com.taobao.api.internal.stream.message.TopCometMessageListener;
import com.taobao.api.internal.util.RequestParametersHolder;
import com.taobao.api.internal.util.StringUtils;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.TaobaoUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

public class TopCometStreamImpl
implements TopCometStream {
    private static final Logger logger = Logger.getLogger(TopCometStreamImpl.class);
    private ConnectionLifeCycleListener connectionListener;
    private TopCometMessageListener cometMessageListener;
    private Configuration conf;
    private StreamMsgConsumeFactory msgConsumeFactory = null;
    private boolean gloableStop = false;
    private List<ControlThread> controlThreads = new ArrayList<ControlThread>();

    protected TopCometStreamImpl(Configuration conf) {
        this.conf = conf;
    }

    public void setConnectionListener(ConnectionLifeCycleListener connectionLifeCycleListener) {
        this.connectionListener = connectionLifeCycleListener;
    }

    public void setMessageListener(TopCometMessageListener cometMessageListener) {
        this.cometMessageListener = cometMessageListener;
    }

    public void start() {
        if (this.cometMessageListener == null) {
            throw new RuntimeException("Comet message listener must not null");
        }
        Set<TopCometStreamRequest> cometRequests = this.conf.getConnectReqParam();
        for (TopCometStreamRequest cometRequest : cometRequests) {
            if (cometRequest.getConnectListener() == null) {
                cometRequest.setConnectListener(this.connectionListener);
            }
            if (cometRequest.getMsgListener() != null) continue;
            cometRequest.setMsgListener(this.cometMessageListener);
        }
        this.msgConsumeFactory = new StreamMsgConsumeFactory(this.conf.getMinThreads(), this.conf.getMaxThreads(), this.conf.getQueueSize());
        for (TopCometStreamRequest cometRequest : cometRequests) {
            ControlThread ct = new ControlThread(cometRequest);
            this.controlThreads.add(ct);
            new Thread((Runnable)ct, "stream-control-thread-connectid-" + cometRequest.getConnectId()).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.gloableStop = true;
        for (ControlThread ct : this.controlThreads) {
            try {
                ct.lock.lock();
                ct.controlCondition.signalAll();
            }
            catch (Exception exception) {}
            continue;
            finally {
                ct.lock.unlock();
            }
        }
        this.msgConsumeFactory.shutdown();
        logger.info((Object)"Stop stream consume");
    }

    class TopCometStreamConsume
    implements Runnable {
        private StreamImplementation stream;
        private boolean closed = false;
        private ControlThread ct;
        private ConnectionLifeCycleListener connectListener;

        TopCometStreamConsume(StreamImplementation stream, ControlThread ct, ConnectionLifeCycleListener connectListener) {
            this.stream = stream;
            this.ct = ct;
            this.connectListener = connectListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.closed && this.stream.isAlive()) {
                try {
                    this.stream.nextMsg();
                }
                catch (IOException e) {
                    if (this.stream != null) {
                        try {
                            this.stream.close();
                        }
                        catch (IOException e1) {
                            logger.error((Object)e1, (Throwable)e1);
                        }
                    }
                    this.stream = null;
                    this.closed = true;
                    if (this.connectListener != null) {
                        try {
                            this.connectListener.onReadTimeout();
                        }
                        catch (Exception ex) {
                            logger.error((Object)ex, (Throwable)ex);
                        }
                    }
                    if (System.currentTimeMillis() - this.ct.lastStartConsumeThread < 1800000L) {
                        this.ct.startConsumeThreadTimes++;
                        if (this.ct.startConsumeThreadTimes >= 10) {
                            this.ct.stop = true;
                            if (this.connectListener != null) {
                                try {
                                    this.connectListener.onMaxReadTimeoutException();
                                }
                                catch (Exception maxE) {
                                    logger.error((Object)maxE, (Throwable)maxE);
                                }
                            }
                            logger.error((Object)"Occure too many exception,stop the system,please check");
                            try {
                                this.ct.lock.lock();
                                this.ct.controlCondition.signalAll();
                            }
                            catch (Exception e2) {}
                            continue;
                            finally {
                                this.ct.lock.unlock();
                                continue;
                            }
                        }
                        this.ct.startConsumeThreadTimes = 0;
                        this.ct.serverRespCode = "500";
                        try {
                            this.ct.lock.lock();
                            this.ct.controlCondition.signalAll();
                        }
                        catch (Exception e2) {}
                        continue;
                        finally {
                            this.ct.lock.unlock();
                            continue;
                        }
                    }
                    this.ct.startConsumeThreadTimes = 0;
                    this.ct.serverRespCode = "500";
                    try {
                        this.ct.lock.lock();
                        this.ct.controlCondition.signalAll();
                    }
                    catch (Exception exception) {}
                    continue;
                    finally {
                        this.ct.lock.unlock();
                    }
                }
            }
            if (this.stream != null) {
                try {
                    this.stream.close();
                }
                catch (Exception e) {
                    logger.warn((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public class ControlThread
    implements Runnable {
        private static final String threadName = "top-stream-consume-thread";
        private TopCometStreamConsume currentStreamConsume;
        private boolean isReconnect = false;
        private String serverRespCode = "501";
        private ReentrantLock lock = new ReentrantLock();
        private Condition controlCondition = this.lock.newCondition();
        private int startConsumeThreadTimes = 0;
        private long lastStartConsumeThread = System.currentTimeMillis();
        private boolean stop = false;
        private TopCometStreamRequest cometReq;

        public ControlThread(TopCometStreamRequest cometReq) {
            this.cometReq = cometReq;
        }

        public ReentrantLock getLock() {
            return this.lock;
        }

        public Condition getControlCondition() {
            return this.controlCondition;
        }

        public void setServerRespCode(String serverRespCode) {
            this.serverRespCode = serverRespCode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            long lastSleepTime = 0L;
            while (!this.stop && !TopCometStreamImpl.this.gloableStop) {
                try {
                    if ("102".equals(this.serverRespCode)) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Server is upgrade sleep " + TopCometStreamImpl.this.conf.getSleepTimeOfServerInUpgrade() + " seconds"));
                        }
                        try {
                            Thread.sleep(TopCometStreamImpl.this.conf.getSleepTimeOfServerInUpgrade() * 1000);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        this.startConsumeThread();
                    } else if ("501".equals(this.serverRespCode) || "103".equals(this.serverRespCode) || "101".equals(this.serverRespCode) || "500".equals(this.serverRespCode)) {
                        this.startConsumeThread();
                    } else if ("104".equals(this.serverRespCode) || "105".equals(this.serverRespCode)) {
                        if ("104".equals(this.serverRespCode) && !this.isReconnect || "105".equals(this.serverRespCode)) {
                            this.stop = true;
                            if (this.currentStreamConsume == null) break;
                            this.currentStreamConsume.closed = true;
                            break;
                        }
                    } else {
                        this.stop = true;
                        break;
                    }
                    try {
                        this.lock.lock();
                        lastSleepTime = System.currentTimeMillis();
                        this.controlCondition.await(TopCometStreamImpl.this.conf.getHttpReconnectInterval(), TimeUnit.SECONDS);
                        if (System.currentTimeMillis() - lastSleepTime < (long)((TopCometStreamImpl.this.conf.getHttpReconnectInterval() - 300) * 1000)) continue;
                        this.serverRespCode = "500";
                        this.isReconnect = true;
                    }
                    catch (Exception e) {
                        logger.error((Object)e, (Throwable)e);
                    }
                    finally {
                        this.lock.unlock();
                    }
                }
                catch (Throwable e) {
                    logger.error((Object)"Occur some error,stop the stream consume", e);
                    this.stop = true;
                    try {
                        this.lock.lock();
                        this.controlCondition.signalAll();
                    }
                    catch (Exception ex) {}
                    continue;
                    finally {
                        this.lock.unlock();
                    }
                }
            }
            TopCometStreamImpl.this.controlThreads.remove(this);
        }

        private void startConsumeThread() {
            StreamImplementation stream;
            block5: {
                stream = null;
                try {
                    stream = this.getMsgStreamImpl();
                    if (this.cometReq.getConnectListener() != null) {
                        this.cometReq.getConnectListener().onConnect();
                    }
                }
                catch (TopCometSysErrorException e) {
                    this.stop = true;
                    logger.error((Object)e, (Throwable)e);
                    if (this.cometReq.getConnectListener() != null) {
                        this.cometReq.getConnectListener().onSysErrorException(e);
                    }
                }
                catch (Exception ex) {
                    this.stop = true;
                    logger.error((Object)ex, (Throwable)ex);
                    if (this.cometReq.getConnectListener() == null) break block5;
                    this.cometReq.getConnectListener().onConnectError(ex);
                }
            }
            this.currentStreamConsume = new TopCometStreamConsume(stream, this, this.cometReq.getConnectListener());
            Thread consumeThread = new Thread((Runnable)this.currentStreamConsume, threadName);
            consumeThread.setDaemon(true);
            consumeThread.start();
            this.lastStartConsumeThread = System.currentTimeMillis();
        }

        private StreamImplementation getMsgStreamImpl() throws TopCometSysErrorException, Exception {
            TaobaoHashMap param = new TaobaoHashMap();
            param.put("app_key", this.cometReq.getAppkey());
            if (!StringUtils.isEmpty(this.cometReq.getUserId())) {
                param.put("user", this.cometReq.getUserId());
            }
            if (!StringUtils.isEmpty(this.cometReq.getConnectId())) {
                param.put("id", this.cometReq.getConnectId());
            }
            String timestamp = String.valueOf(System.currentTimeMillis());
            param.put("timestamp", timestamp);
            RequestParametersHolder paramHolder = new RequestParametersHolder();
            paramHolder.setProtocalMustParams(param);
            String sign = null;
            try {
                sign = TaobaoUtils.signTopRequestNew(paramHolder, this.cometReq.getSecret(), false);
                if (StringUtils.isEmpty(sign)) {
                    throw new RuntimeException("Get sign error");
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            param.put("sign", sign);
            HttpClient httpClient = new HttpClient(TopCometStreamImpl.this.conf, param);
            HttpResponse response = httpClient.post();
            return new MessageStreamImpl(TopCometStreamImpl.this.msgConsumeFactory, response, this.cometReq.getMsgListener(), this);
        }
    }
}

