/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.internal.stream.connect;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpResponse {
    private HttpURLConnection con;
    private InputStream is;
    private BufferedReader reader;

    public HttpResponse(HttpURLConnection con) throws IOException {
        if (con == null) {
            throw new IOException("Http url connection is null");
        }
        this.con = con;
        this.is = con.getErrorStream();
        if (null == this.is) {
            this.is = con.getInputStream();
        }
        if (this.is != null && "gzip".equals(con.getContentEncoding())) {
            this.is = new GZIPInputStream(this.is);
        }
        this.reader = new BufferedReader(new InputStreamReader(this.is, "UTF-8"));
    }

    public String getResponseHeader(String name) {
        return this.con.getHeaderField(name);
    }

    public Map<String, List<String>> getResponseHeaderFields() {
        return this.con.getHeaderFields();
    }

    public void close() {
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (this.is != null) {
            try {
                this.is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.con != null) {
            this.con.disconnect();
        }
    }

    public String getMsg() throws IOException {
        return this.reader.readLine();
    }
}

