/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.internal.stream.message;

import com.taobao.api.internal.stream.AbstractStreamImpl;
import com.taobao.api.internal.stream.TopCometException;
import com.taobao.api.internal.stream.TopCometStreamImpl;
import com.taobao.api.internal.stream.connect.HttpResponse;
import com.taobao.api.internal.stream.message.StreamMsgConsumeFactory;
import com.taobao.api.internal.stream.message.TopCometMessageListener;
import com.taobao.api.internal.util.StringUtils;
import java.io.IOException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class MessageStreamImpl
extends AbstractStreamImpl {
    private static final Logger logger = Logger.getLogger(MessageStreamImpl.class);
    private TopCometMessageListener msgListener;
    private Pattern pattern = Pattern.compile("\\{\"packet\":\\{\"code\":(\\d+)(,\"msg\":(.+))?\\}\\}");
    private Condition controlCondition;
    private Lock lock;
    private TopCometStreamImpl.ControlThread ct;

    public MessageStreamImpl(StreamMsgConsumeFactory msgConsumeFactory, HttpResponse response, TopCometMessageListener msgListener, TopCometStreamImpl.ControlThread ct) {
        super(msgConsumeFactory, response);
        this.msgListener = msgListener;
        this.controlCondition = ct.getControlCondition();
        this.lock = ct.getLock();
        this.ct = ct;
    }

    public String parseLine(String msg) throws TopCometException, IOException {
        if (!StringUtils.isEmpty(msg)) {
            try {
                Matcher matcher = this.pattern.matcher(msg);
                if (matcher.find()) {
                    String code = matcher.group(1);
                    if ("202".equals(code)) {
                        return matcher.group(3);
                    }
                    if ("201".equals(code)) {
                        this.msgListener.onHeartBeat();
                    } else if ("101".equals(code)) {
                        this.msgListener.onConnectReachMaxTime();
                        this.weakUp(code);
                    } else if ("203".equals(code)) {
                        this.msgListener.onDiscardMsg(matcher.group(3));
                    } else if ("102".equals(code)) {
                        this.msgListener.onServerUpgrade(matcher.group(3));
                        this.weakUp(code);
                    } else if ("103".equals(code)) {
                        this.msgListener.onServerRehash();
                        this.weakUp(code);
                    } else if ("104".equals(code)) {
                        this.msgListener.onClientKickOff();
                        this.weakUp(code);
                    } else if ("105".equals(code)) {
                        this.msgListener.onServerKickOff();
                        this.weakUp(code);
                    } else if ("200".equals(code)) {
                        this.msgListener.onConnectMsg(matcher.group(3));
                    } else {
                        this.msgListener.onOtherMsg(matcher.group(3));
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)("Message is invalid:" + msg), (Throwable)e);
                this.msgListener.onException(e);
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void weakUp(String code) {
        try {
            this.lock.lock();
            this.ct.setServerRespCode(code);
            this.controlCondition.signalAll();
        }
        catch (Exception exception) {
        }
        finally {
            this.lock.unlock();
        }
    }

    public TopCometMessageListener getMessageListener() {
        return this.msgListener;
    }

    public void onException(Exception ex) {
        logger.error((Object)ex, (Throwable)ex);
    }

    public void close() throws IOException {
        this.streamAlive = false;
        this.response.close();
    }
}

