/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.dash;

import android.net.Uri;
import android.support.annotation.Nullable;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.drm.DrmInitData;
import com.google.android.exoplayer2.extractor.ChunkIndex;
import com.google.android.exoplayer2.extractor.Extractor;
import com.google.android.exoplayer2.extractor.mkv.MatroskaExtractor;
import com.google.android.exoplayer2.extractor.mp4.FragmentedMp4Extractor;
import com.google.android.exoplayer2.source.chunk.ChunkExtractorWrapper;
import com.google.android.exoplayer2.source.chunk.InitializationChunk;
import com.google.android.exoplayer2.source.dash.manifest.DashManifest;
import com.google.android.exoplayer2.source.dash.manifest.DashManifestParser;
import com.google.android.exoplayer2.source.dash.manifest.Period;
import com.google.android.exoplayer2.source.dash.manifest.RangedUri;
import com.google.android.exoplayer2.source.dash.manifest.Representation;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.upstream.ParsingLoadable;
import java.io.IOException;
import java.util.List;

public final class DashUtil {
    public static DashManifest loadManifest(DataSource dataSource, Uri uri) throws IOException {
        return (DashManifest)ParsingLoadable.load((DataSource)dataSource, (ParsingLoadable.Parser)new DashManifestParser(), (Uri)uri, (int)4);
    }

    @Nullable
    public static DrmInitData loadDrmInitData(DataSource dataSource, Period period) throws IOException, InterruptedException {
        int primaryTrackType = 2;
        Representation representation = DashUtil.getFirstRepresentation(period, primaryTrackType);
        if (representation == null && (representation = DashUtil.getFirstRepresentation(period, primaryTrackType = 1)) == null) {
            return null;
        }
        Format manifestFormat = representation.format;
        Format sampleFormat = DashUtil.loadSampleFormat(dataSource, primaryTrackType, representation);
        return sampleFormat == null ? manifestFormat.drmInitData : sampleFormat.copyWithManifestFormatInfo((Format)manifestFormat).drmInitData;
    }

    @Nullable
    public static Format loadSampleFormat(DataSource dataSource, int trackType, Representation representation) throws IOException, InterruptedException {
        ChunkExtractorWrapper extractorWrapper = DashUtil.loadInitializationData(dataSource, trackType, representation, false);
        return extractorWrapper == null ? null : extractorWrapper.getSampleFormats()[0];
    }

    @Nullable
    public static ChunkIndex loadChunkIndex(DataSource dataSource, int trackType, Representation representation) throws IOException, InterruptedException {
        ChunkExtractorWrapper extractorWrapper = DashUtil.loadInitializationData(dataSource, trackType, representation, true);
        return extractorWrapper == null ? null : (ChunkIndex)extractorWrapper.getSeekMap();
    }

    @Nullable
    private static ChunkExtractorWrapper loadInitializationData(DataSource dataSource, int trackType, Representation representation, boolean loadIndex) throws IOException, InterruptedException {
        RangedUri requestUri;
        RangedUri initializationUri = representation.getInitializationUri();
        if (initializationUri == null) {
            return null;
        }
        ChunkExtractorWrapper extractorWrapper = DashUtil.newWrappedExtractor(trackType, representation.format);
        if (loadIndex) {
            RangedUri indexUri = representation.getIndexUri();
            if (indexUri == null) {
                return null;
            }
            requestUri = initializationUri.attemptMerge(indexUri, representation.baseUrl);
            if (requestUri == null) {
                DashUtil.loadInitializationData(dataSource, representation, extractorWrapper, initializationUri);
                requestUri = indexUri;
            }
        } else {
            requestUri = initializationUri;
        }
        DashUtil.loadInitializationData(dataSource, representation, extractorWrapper, requestUri);
        return extractorWrapper;
    }

    private static void loadInitializationData(DataSource dataSource, Representation representation, ChunkExtractorWrapper extractorWrapper, RangedUri requestUri) throws IOException, InterruptedException {
        DataSpec dataSpec = new DataSpec(requestUri.resolveUri(representation.baseUrl), requestUri.start, requestUri.length, representation.getCacheKey());
        InitializationChunk initializationChunk = new InitializationChunk(dataSource, dataSpec, representation.format, 0, null, extractorWrapper);
        initializationChunk.load();
    }

    private static ChunkExtractorWrapper newWrappedExtractor(int trackType, Format format) {
        String mimeType = format.containerMimeType;
        boolean isWebm = mimeType != null && (mimeType.startsWith("video/webm") || mimeType.startsWith("audio/webm"));
        MatroskaExtractor extractor = isWebm ? new MatroskaExtractor() : new FragmentedMp4Extractor();
        return new ChunkExtractorWrapper((Extractor)extractor, trackType, format);
    }

    @Nullable
    private static Representation getFirstRepresentation(Period period, int type) {
        int index = period.getAdaptationSetIndex(type);
        if (index == -1) {
            return null;
        }
        List<Representation> representations = period.adaptationSets.get((int)index).representations;
        return representations.isEmpty() ? null : representations.get(0);
    }

    private DashUtil() {
    }
}

