// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/logging/type/http_request.proto

package com.google.logging.type;

/**
 * <pre>
 * A common proto for logging HTTP requests. Only contains semantics
 * defined by the HTTP specification. Product-specific logging
 * information MUST be defined in a separate message.
 * </pre>
 *
 * Protobuf type {@code google.logging.type.HttpRequest}
 */
public  final class HttpRequest extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:google.logging.type.HttpRequest)
    HttpRequestOrBuilder {
private static final long serialVersionUID = 0L;
  // Use HttpRequest.newBuilder() to construct.
  private HttpRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private HttpRequest() {
    requestMethod_ = "";
    requestUrl_ = "";
    userAgent_ = "";
    remoteIp_ = "";
    serverIp_ = "";
    referer_ = "";
    protocol_ = "";
  }

  @Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private HttpRequest(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10: {
            String s = input.readStringRequireUtf8();

            requestMethod_ = s;
            break;
          }
          case 18: {
            String s = input.readStringRequireUtf8();

            requestUrl_ = s;
            break;
          }
          case 24: {

            requestSize_ = input.readInt64();
            break;
          }
          case 32: {

            status_ = input.readInt32();
            break;
          }
          case 40: {

            responseSize_ = input.readInt64();
            break;
          }
          case 50: {
            String s = input.readStringRequireUtf8();

            userAgent_ = s;
            break;
          }
          case 58: {
            String s = input.readStringRequireUtf8();

            remoteIp_ = s;
            break;
          }
          case 66: {
            String s = input.readStringRequireUtf8();

            referer_ = s;
            break;
          }
          case 72: {

            cacheHit_ = input.readBool();
            break;
          }
          case 80: {

            cacheValidatedWithOriginServer_ = input.readBool();
            break;
          }
          case 88: {

            cacheLookup_ = input.readBool();
            break;
          }
          case 96: {

            cacheFillBytes_ = input.readInt64();
            break;
          }
          case 106: {
            String s = input.readStringRequireUtf8();

            serverIp_ = s;
            break;
          }
          case 114: {
            com.google.protobuf.Duration.Builder subBuilder = null;
            if (latency_ != null) {
              subBuilder = latency_.toBuilder();
            }
            latency_ = input.readMessage(com.google.protobuf.Duration.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(latency_);
              latency_ = subBuilder.buildPartial();
            }

            break;
          }
          case 122: {
            String s = input.readStringRequireUtf8();

            protocol_ = s;
            break;
          }
          default: {
            if (!parseUnknownField(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return com.google.logging.type.HttpRequestProto.internal_static_google_logging_type_HttpRequest_descriptor;
  }

  @Override
  protected FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.logging.type.HttpRequestProto.internal_static_google_logging_type_HttpRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            HttpRequest.class, Builder.class);
  }

  public static final int REQUEST_METHOD_FIELD_NUMBER = 1;
  private volatile Object requestMethod_;
  /**
   * <pre>
   * The request method. Examples: `"GET"`, `"HEAD"`, `"PUT"`, `"POST"`.
   * </pre>
   *
   * <code>string request_method = 1;</code>
   */
  public String getRequestMethod() {
    Object ref = requestMethod_;
    if (ref instanceof String) {
      return (String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      String s = bs.toStringUtf8();
      requestMethod_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * The request method. Examples: `"GET"`, `"HEAD"`, `"PUT"`, `"POST"`.
   * </pre>
   *
   * <code>string request_method = 1;</code>
   */
  public com.google.protobuf.ByteString
      getRequestMethodBytes() {
    Object ref = requestMethod_;
    if (ref instanceof String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (String) ref);
      requestMethod_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REQUEST_URL_FIELD_NUMBER = 2;
  private volatile Object requestUrl_;
  /**
   * <pre>
   * The scheme (http, https), the host name, the path and the query
   * portion of the URL that was requested.
   * Example: `"http://example.com/some/info?color=red"`.
   * </pre>
   *
   * <code>string request_url = 2;</code>
   */
  public String getRequestUrl() {
    Object ref = requestUrl_;
    if (ref instanceof String) {
      return (String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      String s = bs.toStringUtf8();
      requestUrl_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * The scheme (http, https), the host name, the path and the query
   * portion of the URL that was requested.
   * Example: `"http://example.com/some/info?color=red"`.
   * </pre>
   *
   * <code>string request_url = 2;</code>
   */
  public com.google.protobuf.ByteString
      getRequestUrlBytes() {
    Object ref = requestUrl_;
    if (ref instanceof String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (String) ref);
      requestUrl_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REQUEST_SIZE_FIELD_NUMBER = 3;
  private long requestSize_;
  /**
   * <pre>
   * The size of the HTTP request message in bytes, including the request
   * headers and the request body.
   * </pre>
   *
   * <code>int64 request_size = 3;</code>
   */
  public long getRequestSize() {
    return requestSize_;
  }

  public static final int STATUS_FIELD_NUMBER = 4;
  private int status_;
  /**
   * <pre>
   * The response code indicating the status of response.
   * Examples: 200, 404.
   * </pre>
   *
   * <code>int32 status = 4;</code>
   */
  public int getStatus() {
    return status_;
  }

  public static final int RESPONSE_SIZE_FIELD_NUMBER = 5;
  private long responseSize_;
  /**
   * <pre>
   * The size of the HTTP response message sent back to the client, in bytes,
   * including the response headers and the response body.
   * </pre>
   *
   * <code>int64 response_size = 5;</code>
   */
  public long getResponseSize() {
    return responseSize_;
  }

  public static final int USER_AGENT_FIELD_NUMBER = 6;
  private volatile Object userAgent_;
  /**
   * <pre>
   * The user agent sent by the client. Example:
   * `"Mozilla/4.0 (compatible; MSIE 6.0; Windows 98; Q312461; .NET
   * CLR 1.0.3705)"`.
   * </pre>
   *
   * <code>string user_agent = 6;</code>
   */
  public String getUserAgent() {
    Object ref = userAgent_;
    if (ref instanceof String) {
      return (String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      String s = bs.toStringUtf8();
      userAgent_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * The user agent sent by the client. Example:
   * `"Mozilla/4.0 (compatible; MSIE 6.0; Windows 98; Q312461; .NET
   * CLR 1.0.3705)"`.
   * </pre>
   *
   * <code>string user_agent = 6;</code>
   */
  public com.google.protobuf.ByteString
      getUserAgentBytes() {
    Object ref = userAgent_;
    if (ref instanceof String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (String) ref);
      userAgent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REMOTE_IP_FIELD_NUMBER = 7;
  private volatile Object remoteIp_;
  /**
   * <pre>
   * The IP address (IPv4 or IPv6) of the client that issued the HTTP
   * request. Examples: `"192.168.1.1"`, `"FE80::0202:B3FF:FE1E:8329"`.
   * </pre>
   *
   * <code>string remote_ip = 7;</code>
   */
  public String getRemoteIp() {
    Object ref = remoteIp_;
    if (ref instanceof String) {
      return (String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      String s = bs.toStringUtf8();
      remoteIp_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * The IP address (IPv4 or IPv6) of the client that issued the HTTP
   * request. Examples: `"192.168.1.1"`, `"FE80::0202:B3FF:FE1E:8329"`.
   * </pre>
   *
   * <code>string remote_ip = 7;</code>
   */
  public com.google.protobuf.ByteString
      getRemoteIpBytes() {
    Object ref = remoteIp_;
    if (ref instanceof String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (String) ref);
      remoteIp_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SERVER_IP_FIELD_NUMBER = 13;
  private volatile Object serverIp_;
  /**
   * <pre>
   * The IP address (IPv4 or IPv6) of the origin server that the request was
   * sent to.
   * </pre>
   *
   * <code>string server_ip = 13;</code>
   */
  public String getServerIp() {
    Object ref = serverIp_;
    if (ref instanceof String) {
      return (String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      String s = bs.toStringUtf8();
      serverIp_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * The IP address (IPv4 or IPv6) of the origin server that the request was
   * sent to.
   * </pre>
   *
   * <code>string server_ip = 13;</code>
   */
  public com.google.protobuf.ByteString
      getServerIpBytes() {
    Object ref = serverIp_;
    if (ref instanceof String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (String) ref);
      serverIp_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REFERER_FIELD_NUMBER = 8;
  private volatile Object referer_;
  /**
   * <pre>
   * The referer URL of the request, as defined in
   * [HTTP/1.1 Header Field
   * Definitions](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html).
   * </pre>
   *
   * <code>string referer = 8;</code>
   */
  public String getReferer() {
    Object ref = referer_;
    if (ref instanceof String) {
      return (String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      String s = bs.toStringUtf8();
      referer_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * The referer URL of the request, as defined in
   * [HTTP/1.1 Header Field
   * Definitions](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html).
   * </pre>
   *
   * <code>string referer = 8;</code>
   */
  public com.google.protobuf.ByteString
      getRefererBytes() {
    Object ref = referer_;
    if (ref instanceof String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (String) ref);
      referer_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LATENCY_FIELD_NUMBER = 14;
  private com.google.protobuf.Duration latency_;
  /**
   * <pre>
   * The request processing latency on the server, from the time the request was
   * received until the response was sent.
   * </pre>
   *
   * <code>.google.protobuf.Duration latency = 14;</code>
   */
  public boolean hasLatency() {
    return latency_ != null;
  }
  /**
   * <pre>
   * The request processing latency on the server, from the time the request was
   * received until the response was sent.
   * </pre>
   *
   * <code>.google.protobuf.Duration latency = 14;</code>
   */
  public com.google.protobuf.Duration getLatency() {
    return latency_ == null ? com.google.protobuf.Duration.getDefaultInstance() : latency_;
  }
  /**
   * <pre>
   * The request processing latency on the server, from the time the request was
   * received until the response was sent.
   * </pre>
   *
   * <code>.google.protobuf.Duration latency = 14;</code>
   */
  public com.google.protobuf.DurationOrBuilder getLatencyOrBuilder() {
    return getLatency();
  }

  public static final int CACHE_LOOKUP_FIELD_NUMBER = 11;
  private boolean cacheLookup_;
  /**
   * <pre>
   * Whether or not a cache lookup was attempted.
   * </pre>
   *
   * <code>bool cache_lookup = 11;</code>
   */
  public boolean getCacheLookup() {
    return cacheLookup_;
  }

  public static final int CACHE_HIT_FIELD_NUMBER = 9;
  private boolean cacheHit_;
  /**
   * <pre>
   * Whether or not an entity was served from cache
   * (with or without validation).
   * </pre>
   *
   * <code>bool cache_hit = 9;</code>
   */
  public boolean getCacheHit() {
    return cacheHit_;
  }

  public static final int CACHE_VALIDATED_WITH_ORIGIN_SERVER_FIELD_NUMBER = 10;
  private boolean cacheValidatedWithOriginServer_;
  /**
   * <pre>
   * Whether or not the response was validated with the origin server before
   * being served from cache. This field is only meaningful if `cache_hit` is
   * True.
   * </pre>
   *
   * <code>bool cache_validated_with_origin_server = 10;</code>
   */
  public boolean getCacheValidatedWithOriginServer() {
    return cacheValidatedWithOriginServer_;
  }

  public static final int CACHE_FILL_BYTES_FIELD_NUMBER = 12;
  private long cacheFillBytes_;
  /**
   * <pre>
   * The number of HTTP response bytes inserted into cache. Set only when a
   * cache fill was attempted.
   * </pre>
   *
   * <code>int64 cache_fill_bytes = 12;</code>
   */
  public long getCacheFillBytes() {
    return cacheFillBytes_;
  }

  public static final int PROTOCOL_FIELD_NUMBER = 15;
  private volatile Object protocol_;
  /**
   * <pre>
   * Protocol used for the request. Examples: "HTTP/1.1", "HTTP/2", "websocket"
   * </pre>
   *
   * <code>string protocol = 15;</code>
   */
  public String getProtocol() {
    Object ref = protocol_;
    if (ref instanceof String) {
      return (String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      String s = bs.toStringUtf8();
      protocol_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Protocol used for the request. Examples: "HTTP/1.1", "HTTP/2", "websocket"
   * </pre>
   *
   * <code>string protocol = 15;</code>
   */
  public com.google.protobuf.ByteString
      getProtocolBytes() {
    Object ref = protocol_;
    if (ref instanceof String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (String) ref);
      protocol_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;
  @Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (!getRequestMethodBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, requestMethod_);
    }
    if (!getRequestUrlBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, requestUrl_);
    }
    if (requestSize_ != 0L) {
      output.writeInt64(3, requestSize_);
    }
    if (status_ != 0) {
      output.writeInt32(4, status_);
    }
    if (responseSize_ != 0L) {
      output.writeInt64(5, responseSize_);
    }
    if (!getUserAgentBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, userAgent_);
    }
    if (!getRemoteIpBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, remoteIp_);
    }
    if (!getRefererBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, referer_);
    }
    if (cacheHit_ != false) {
      output.writeBool(9, cacheHit_);
    }
    if (cacheValidatedWithOriginServer_ != false) {
      output.writeBool(10, cacheValidatedWithOriginServer_);
    }
    if (cacheLookup_ != false) {
      output.writeBool(11, cacheLookup_);
    }
    if (cacheFillBytes_ != 0L) {
      output.writeInt64(12, cacheFillBytes_);
    }
    if (!getServerIpBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 13, serverIp_);
    }
    if (latency_ != null) {
      output.writeMessage(14, getLatency());
    }
    if (!getProtocolBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 15, protocol_);
    }
    unknownFields.writeTo(output);
  }

  @Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getRequestMethodBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, requestMethod_);
    }
    if (!getRequestUrlBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, requestUrl_);
    }
    if (requestSize_ != 0L) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt64Size(3, requestSize_);
    }
    if (status_ != 0) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(4, status_);
    }
    if (responseSize_ != 0L) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt64Size(5, responseSize_);
    }
    if (!getUserAgentBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, userAgent_);
    }
    if (!getRemoteIpBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, remoteIp_);
    }
    if (!getRefererBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, referer_);
    }
    if (cacheHit_ != false) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(9, cacheHit_);
    }
    if (cacheValidatedWithOriginServer_ != false) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(10, cacheValidatedWithOriginServer_);
    }
    if (cacheLookup_ != false) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(11, cacheLookup_);
    }
    if (cacheFillBytes_ != 0L) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt64Size(12, cacheFillBytes_);
    }
    if (!getServerIpBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(13, serverIp_);
    }
    if (latency_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(14, getLatency());
    }
    if (!getProtocolBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(15, protocol_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @Override
  public boolean equals(final Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof HttpRequest)) {
      return super.equals(obj);
    }
    HttpRequest other = (HttpRequest) obj;

    if (!getRequestMethod()
        .equals(other.getRequestMethod())) return false;
    if (!getRequestUrl()
        .equals(other.getRequestUrl())) return false;
    if (getRequestSize()
        != other.getRequestSize()) return false;
    if (getStatus()
        != other.getStatus()) return false;
    if (getResponseSize()
        != other.getResponseSize()) return false;
    if (!getUserAgent()
        .equals(other.getUserAgent())) return false;
    if (!getRemoteIp()
        .equals(other.getRemoteIp())) return false;
    if (!getServerIp()
        .equals(other.getServerIp())) return false;
    if (!getReferer()
        .equals(other.getReferer())) return false;
    if (hasLatency() != other.hasLatency()) return false;
    if (hasLatency()) {
      if (!getLatency()
          .equals(other.getLatency())) return false;
    }
    if (getCacheLookup()
        != other.getCacheLookup()) return false;
    if (getCacheHit()
        != other.getCacheHit()) return false;
    if (getCacheValidatedWithOriginServer()
        != other.getCacheValidatedWithOriginServer()) return false;
    if (getCacheFillBytes()
        != other.getCacheFillBytes()) return false;
    if (!getProtocol()
        .equals(other.getProtocol())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + REQUEST_METHOD_FIELD_NUMBER;
    hash = (53 * hash) + getRequestMethod().hashCode();
    hash = (37 * hash) + REQUEST_URL_FIELD_NUMBER;
    hash = (53 * hash) + getRequestUrl().hashCode();
    hash = (37 * hash) + REQUEST_SIZE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
        getRequestSize());
    hash = (37 * hash) + STATUS_FIELD_NUMBER;
    hash = (53 * hash) + getStatus();
    hash = (37 * hash) + RESPONSE_SIZE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
        getResponseSize());
    hash = (37 * hash) + USER_AGENT_FIELD_NUMBER;
    hash = (53 * hash) + getUserAgent().hashCode();
    hash = (37 * hash) + REMOTE_IP_FIELD_NUMBER;
    hash = (53 * hash) + getRemoteIp().hashCode();
    hash = (37 * hash) + SERVER_IP_FIELD_NUMBER;
    hash = (53 * hash) + getServerIp().hashCode();
    hash = (37 * hash) + REFERER_FIELD_NUMBER;
    hash = (53 * hash) + getReferer().hashCode();
    if (hasLatency()) {
      hash = (37 * hash) + LATENCY_FIELD_NUMBER;
      hash = (53 * hash) + getLatency().hashCode();
    }
    hash = (37 * hash) + CACHE_LOOKUP_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
        getCacheLookup());
    hash = (37 * hash) + CACHE_HIT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
        getCacheHit());
    hash = (37 * hash) + CACHE_VALIDATED_WITH_ORIGIN_SERVER_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
        getCacheValidatedWithOriginServer());
    hash = (37 * hash) + CACHE_FILL_BYTES_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
        getCacheFillBytes());
    hash = (37 * hash) + PROTOCOL_FIELD_NUMBER;
    hash = (53 * hash) + getProtocol().hashCode();
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static HttpRequest parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static HttpRequest parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static HttpRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static HttpRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static HttpRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static HttpRequest parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static HttpRequest parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static HttpRequest parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static HttpRequest parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static HttpRequest parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static HttpRequest parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static HttpRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(HttpRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @Override
  protected Builder newBuilderForType(
      BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * A common proto for logging HTTP requests. Only contains semantics
   * defined by the HTTP specification. Product-specific logging
   * information MUST be defined in a separate message.
   * </pre>
   *
   * Protobuf type {@code google.logging.type.HttpRequest}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:google.logging.type.HttpRequest)
      com.google.logging.type.HttpRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.logging.type.HttpRequestProto.internal_static_google_logging_type_HttpRequest_descriptor;
    }

    @Override
    protected FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.logging.type.HttpRequestProto.internal_static_google_logging_type_HttpRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              HttpRequest.class, Builder.class);
    }

    // Construct using com.google.logging.type.HttpRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    @Override
    public Builder clear() {
      super.clear();
      requestMethod_ = "";

      requestUrl_ = "";

      requestSize_ = 0L;

      status_ = 0;

      responseSize_ = 0L;

      userAgent_ = "";

      remoteIp_ = "";

      serverIp_ = "";

      referer_ = "";

      if (latencyBuilder_ == null) {
        latency_ = null;
      } else {
        latency_ = null;
        latencyBuilder_ = null;
      }
      cacheLookup_ = false;

      cacheHit_ = false;

      cacheValidatedWithOriginServer_ = false;

      cacheFillBytes_ = 0L;

      protocol_ = "";

      return this;
    }

    @Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return com.google.logging.type.HttpRequestProto.internal_static_google_logging_type_HttpRequest_descriptor;
    }

    @Override
    public HttpRequest getDefaultInstanceForType() {
      return HttpRequest.getDefaultInstance();
    }

    @Override
    public HttpRequest build() {
      HttpRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @Override
    public HttpRequest buildPartial() {
      HttpRequest result = new HttpRequest(this);
      result.requestMethod_ = requestMethod_;
      result.requestUrl_ = requestUrl_;
      result.requestSize_ = requestSize_;
      result.status_ = status_;
      result.responseSize_ = responseSize_;
      result.userAgent_ = userAgent_;
      result.remoteIp_ = remoteIp_;
      result.serverIp_ = serverIp_;
      result.referer_ = referer_;
      if (latencyBuilder_ == null) {
        result.latency_ = latency_;
      } else {
        result.latency_ = latencyBuilder_.build();
      }
      result.cacheLookup_ = cacheLookup_;
      result.cacheHit_ = cacheHit_;
      result.cacheValidatedWithOriginServer_ = cacheValidatedWithOriginServer_;
      result.cacheFillBytes_ = cacheFillBytes_;
      result.protocol_ = protocol_;
      onBuilt();
      return result;
    }

    @Override
    public Builder clone() {
      return super.clone();
    }
    @Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        Object value) {
      return super.setField(field, value);
    }
    @Override
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }
    @Override
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }
    @Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, Object value) {
      return super.setRepeatedField(field, index, value);
    }
    @Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        Object value) {
      return super.addRepeatedField(field, value);
    }
    @Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof HttpRequest) {
        return mergeFrom((HttpRequest)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(HttpRequest other) {
      if (other == HttpRequest.getDefaultInstance()) return this;
      if (!other.getRequestMethod().isEmpty()) {
        requestMethod_ = other.requestMethod_;
        onChanged();
      }
      if (!other.getRequestUrl().isEmpty()) {
        requestUrl_ = other.requestUrl_;
        onChanged();
      }
      if (other.getRequestSize() != 0L) {
        setRequestSize(other.getRequestSize());
      }
      if (other.getStatus() != 0) {
        setStatus(other.getStatus());
      }
      if (other.getResponseSize() != 0L) {
        setResponseSize(other.getResponseSize());
      }
      if (!other.getUserAgent().isEmpty()) {
        userAgent_ = other.userAgent_;
        onChanged();
      }
      if (!other.getRemoteIp().isEmpty()) {
        remoteIp_ = other.remoteIp_;
        onChanged();
      }
      if (!other.getServerIp().isEmpty()) {
        serverIp_ = other.serverIp_;
        onChanged();
      }
      if (!other.getReferer().isEmpty()) {
        referer_ = other.referer_;
        onChanged();
      }
      if (other.hasLatency()) {
        mergeLatency(other.getLatency());
      }
      if (other.getCacheLookup() != false) {
        setCacheLookup(other.getCacheLookup());
      }
      if (other.getCacheHit() != false) {
        setCacheHit(other.getCacheHit());
      }
      if (other.getCacheValidatedWithOriginServer() != false) {
        setCacheValidatedWithOriginServer(other.getCacheValidatedWithOriginServer());
      }
      if (other.getCacheFillBytes() != 0L) {
        setCacheFillBytes(other.getCacheFillBytes());
      }
      if (!other.getProtocol().isEmpty()) {
        protocol_ = other.protocol_;
        onChanged();
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @Override
    public final boolean isInitialized() {
      return true;
    }

    @Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      HttpRequest parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (HttpRequest) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private Object requestMethod_ = "";
    /**
     * <pre>
     * The request method. Examples: `"GET"`, `"HEAD"`, `"PUT"`, `"POST"`.
     * </pre>
     *
     * <code>string request_method = 1;</code>
     */
    public String getRequestMethod() {
      Object ref = requestMethod_;
      if (!(ref instanceof String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        String s = bs.toStringUtf8();
        requestMethod_ = s;
        return s;
      } else {
        return (String) ref;
      }
    }
    /**
     * <pre>
     * The request method. Examples: `"GET"`, `"HEAD"`, `"PUT"`, `"POST"`.
     * </pre>
     *
     * <code>string request_method = 1;</code>
     */
    public com.google.protobuf.ByteString
        getRequestMethodBytes() {
      Object ref = requestMethod_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (String) ref);
        requestMethod_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * The request method. Examples: `"GET"`, `"HEAD"`, `"PUT"`, `"POST"`.
     * </pre>
     *
     * <code>string request_method = 1;</code>
     */
    public Builder setRequestMethod(
        String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      requestMethod_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The request method. Examples: `"GET"`, `"HEAD"`, `"PUT"`, `"POST"`.
     * </pre>
     *
     * <code>string request_method = 1;</code>
     */
    public Builder clearRequestMethod() {
      
      requestMethod_ = getDefaultInstance().getRequestMethod();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The request method. Examples: `"GET"`, `"HEAD"`, `"PUT"`, `"POST"`.
     * </pre>
     *
     * <code>string request_method = 1;</code>
     */
    public Builder setRequestMethodBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      requestMethod_ = value;
      onChanged();
      return this;
    }

    private Object requestUrl_ = "";
    /**
     * <pre>
     * The scheme (http, https), the host name, the path and the query
     * portion of the URL that was requested.
     * Example: `"http://example.com/some/info?color=red"`.
     * </pre>
     *
     * <code>string request_url = 2;</code>
     */
    public String getRequestUrl() {
      Object ref = requestUrl_;
      if (!(ref instanceof String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        String s = bs.toStringUtf8();
        requestUrl_ = s;
        return s;
      } else {
        return (String) ref;
      }
    }
    /**
     * <pre>
     * The scheme (http, https), the host name, the path and the query
     * portion of the URL that was requested.
     * Example: `"http://example.com/some/info?color=red"`.
     * </pre>
     *
     * <code>string request_url = 2;</code>
     */
    public com.google.protobuf.ByteString
        getRequestUrlBytes() {
      Object ref = requestUrl_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (String) ref);
        requestUrl_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * The scheme (http, https), the host name, the path and the query
     * portion of the URL that was requested.
     * Example: `"http://example.com/some/info?color=red"`.
     * </pre>
     *
     * <code>string request_url = 2;</code>
     */
    public Builder setRequestUrl(
        String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      requestUrl_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The scheme (http, https), the host name, the path and the query
     * portion of the URL that was requested.
     * Example: `"http://example.com/some/info?color=red"`.
     * </pre>
     *
     * <code>string request_url = 2;</code>
     */
    public Builder clearRequestUrl() {
      
      requestUrl_ = getDefaultInstance().getRequestUrl();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The scheme (http, https), the host name, the path and the query
     * portion of the URL that was requested.
     * Example: `"http://example.com/some/info?color=red"`.
     * </pre>
     *
     * <code>string request_url = 2;</code>
     */
    public Builder setRequestUrlBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      requestUrl_ = value;
      onChanged();
      return this;
    }

    private long requestSize_ ;
    /**
     * <pre>
     * The size of the HTTP request message in bytes, including the request
     * headers and the request body.
     * </pre>
     *
     * <code>int64 request_size = 3;</code>
     */
    public long getRequestSize() {
      return requestSize_;
    }
    /**
     * <pre>
     * The size of the HTTP request message in bytes, including the request
     * headers and the request body.
     * </pre>
     *
     * <code>int64 request_size = 3;</code>
     */
    public Builder setRequestSize(long value) {
      
      requestSize_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The size of the HTTP request message in bytes, including the request
     * headers and the request body.
     * </pre>
     *
     * <code>int64 request_size = 3;</code>
     */
    public Builder clearRequestSize() {
      
      requestSize_ = 0L;
      onChanged();
      return this;
    }

    private int status_ ;
    /**
     * <pre>
     * The response code indicating the status of response.
     * Examples: 200, 404.
     * </pre>
     *
     * <code>int32 status = 4;</code>
     */
    public int getStatus() {
      return status_;
    }
    /**
     * <pre>
     * The response code indicating the status of response.
     * Examples: 200, 404.
     * </pre>
     *
     * <code>int32 status = 4;</code>
     */
    public Builder setStatus(int value) {
      
      status_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The response code indicating the status of response.
     * Examples: 200, 404.
     * </pre>
     *
     * <code>int32 status = 4;</code>
     */
    public Builder clearStatus() {
      
      status_ = 0;
      onChanged();
      return this;
    }

    private long responseSize_ ;
    /**
     * <pre>
     * The size of the HTTP response message sent back to the client, in bytes,
     * including the response headers and the response body.
     * </pre>
     *
     * <code>int64 response_size = 5;</code>
     */
    public long getResponseSize() {
      return responseSize_;
    }
    /**
     * <pre>
     * The size of the HTTP response message sent back to the client, in bytes,
     * including the response headers and the response body.
     * </pre>
     *
     * <code>int64 response_size = 5;</code>
     */
    public Builder setResponseSize(long value) {
      
      responseSize_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The size of the HTTP response message sent back to the client, in bytes,
     * including the response headers and the response body.
     * </pre>
     *
     * <code>int64 response_size = 5;</code>
     */
    public Builder clearResponseSize() {
      
      responseSize_ = 0L;
      onChanged();
      return this;
    }

    private Object userAgent_ = "";
    /**
     * <pre>
     * The user agent sent by the client. Example:
     * `"Mozilla/4.0 (compatible; MSIE 6.0; Windows 98; Q312461; .NET
     * CLR 1.0.3705)"`.
     * </pre>
     *
     * <code>string user_agent = 6;</code>
     */
    public String getUserAgent() {
      Object ref = userAgent_;
      if (!(ref instanceof String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        String s = bs.toStringUtf8();
        userAgent_ = s;
        return s;
      } else {
        return (String) ref;
      }
    }
    /**
     * <pre>
     * The user agent sent by the client. Example:
     * `"Mozilla/4.0 (compatible; MSIE 6.0; Windows 98; Q312461; .NET
     * CLR 1.0.3705)"`.
     * </pre>
     *
     * <code>string user_agent = 6;</code>
     */
    public com.google.protobuf.ByteString
        getUserAgentBytes() {
      Object ref = userAgent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (String) ref);
        userAgent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * The user agent sent by the client. Example:
     * `"Mozilla/4.0 (compatible; MSIE 6.0; Windows 98; Q312461; .NET
     * CLR 1.0.3705)"`.
     * </pre>
     *
     * <code>string user_agent = 6;</code>
     */
    public Builder setUserAgent(
        String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      userAgent_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The user agent sent by the client. Example:
     * `"Mozilla/4.0 (compatible; MSIE 6.0; Windows 98; Q312461; .NET
     * CLR 1.0.3705)"`.
     * </pre>
     *
     * <code>string user_agent = 6;</code>
     */
    public Builder clearUserAgent() {
      
      userAgent_ = getDefaultInstance().getUserAgent();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The user agent sent by the client. Example:
     * `"Mozilla/4.0 (compatible; MSIE 6.0; Windows 98; Q312461; .NET
     * CLR 1.0.3705)"`.
     * </pre>
     *
     * <code>string user_agent = 6;</code>
     */
    public Builder setUserAgentBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      userAgent_ = value;
      onChanged();
      return this;
    }

    private Object remoteIp_ = "";
    /**
     * <pre>
     * The IP address (IPv4 or IPv6) of the client that issued the HTTP
     * request. Examples: `"192.168.1.1"`, `"FE80::0202:B3FF:FE1E:8329"`.
     * </pre>
     *
     * <code>string remote_ip = 7;</code>
     */
    public String getRemoteIp() {
      Object ref = remoteIp_;
      if (!(ref instanceof String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        String s = bs.toStringUtf8();
        remoteIp_ = s;
        return s;
      } else {
        return (String) ref;
      }
    }
    /**
     * <pre>
     * The IP address (IPv4 or IPv6) of the client that issued the HTTP
     * request. Examples: `"192.168.1.1"`, `"FE80::0202:B3FF:FE1E:8329"`.
     * </pre>
     *
     * <code>string remote_ip = 7;</code>
     */
    public com.google.protobuf.ByteString
        getRemoteIpBytes() {
      Object ref = remoteIp_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (String) ref);
        remoteIp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * The IP address (IPv4 or IPv6) of the client that issued the HTTP
     * request. Examples: `"192.168.1.1"`, `"FE80::0202:B3FF:FE1E:8329"`.
     * </pre>
     *
     * <code>string remote_ip = 7;</code>
     */
    public Builder setRemoteIp(
        String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      remoteIp_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The IP address (IPv4 or IPv6) of the client that issued the HTTP
     * request. Examples: `"192.168.1.1"`, `"FE80::0202:B3FF:FE1E:8329"`.
     * </pre>
     *
     * <code>string remote_ip = 7;</code>
     */
    public Builder clearRemoteIp() {
      
      remoteIp_ = getDefaultInstance().getRemoteIp();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The IP address (IPv4 or IPv6) of the client that issued the HTTP
     * request. Examples: `"192.168.1.1"`, `"FE80::0202:B3FF:FE1E:8329"`.
     * </pre>
     *
     * <code>string remote_ip = 7;</code>
     */
    public Builder setRemoteIpBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      remoteIp_ = value;
      onChanged();
      return this;
    }

    private Object serverIp_ = "";
    /**
     * <pre>
     * The IP address (IPv4 or IPv6) of the origin server that the request was
     * sent to.
     * </pre>
     *
     * <code>string server_ip = 13;</code>
     */
    public String getServerIp() {
      Object ref = serverIp_;
      if (!(ref instanceof String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        String s = bs.toStringUtf8();
        serverIp_ = s;
        return s;
      } else {
        return (String) ref;
      }
    }
    /**
     * <pre>
     * The IP address (IPv4 or IPv6) of the origin server that the request was
     * sent to.
     * </pre>
     *
     * <code>string server_ip = 13;</code>
     */
    public com.google.protobuf.ByteString
        getServerIpBytes() {
      Object ref = serverIp_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (String) ref);
        serverIp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * The IP address (IPv4 or IPv6) of the origin server that the request was
     * sent to.
     * </pre>
     *
     * <code>string server_ip = 13;</code>
     */
    public Builder setServerIp(
        String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      serverIp_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The IP address (IPv4 or IPv6) of the origin server that the request was
     * sent to.
     * </pre>
     *
     * <code>string server_ip = 13;</code>
     */
    public Builder clearServerIp() {
      
      serverIp_ = getDefaultInstance().getServerIp();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The IP address (IPv4 or IPv6) of the origin server that the request was
     * sent to.
     * </pre>
     *
     * <code>string server_ip = 13;</code>
     */
    public Builder setServerIpBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      serverIp_ = value;
      onChanged();
      return this;
    }

    private Object referer_ = "";
    /**
     * <pre>
     * The referer URL of the request, as defined in
     * [HTTP/1.1 Header Field
     * Definitions](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html).
     * </pre>
     *
     * <code>string referer = 8;</code>
     */
    public String getReferer() {
      Object ref = referer_;
      if (!(ref instanceof String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        String s = bs.toStringUtf8();
        referer_ = s;
        return s;
      } else {
        return (String) ref;
      }
    }
    /**
     * <pre>
     * The referer URL of the request, as defined in
     * [HTTP/1.1 Header Field
     * Definitions](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html).
     * </pre>
     *
     * <code>string referer = 8;</code>
     */
    public com.google.protobuf.ByteString
        getRefererBytes() {
      Object ref = referer_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (String) ref);
        referer_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * The referer URL of the request, as defined in
     * [HTTP/1.1 Header Field
     * Definitions](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html).
     * </pre>
     *
     * <code>string referer = 8;</code>
     */
    public Builder setReferer(
        String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      referer_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The referer URL of the request, as defined in
     * [HTTP/1.1 Header Field
     * Definitions](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html).
     * </pre>
     *
     * <code>string referer = 8;</code>
     */
    public Builder clearReferer() {
      
      referer_ = getDefaultInstance().getReferer();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The referer URL of the request, as defined in
     * [HTTP/1.1 Header Field
     * Definitions](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html).
     * </pre>
     *
     * <code>string referer = 8;</code>
     */
    public Builder setRefererBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      referer_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.Duration latency_;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.protobuf.Duration, com.google.protobuf.Duration.Builder, com.google.protobuf.DurationOrBuilder> latencyBuilder_;
    /**
     * <pre>
     * The request processing latency on the server, from the time the request was
     * received until the response was sent.
     * </pre>
     *
     * <code>.google.protobuf.Duration latency = 14;</code>
     */
    public boolean hasLatency() {
      return latencyBuilder_ != null || latency_ != null;
    }
    /**
     * <pre>
     * The request processing latency on the server, from the time the request was
     * received until the response was sent.
     * </pre>
     *
     * <code>.google.protobuf.Duration latency = 14;</code>
     */
    public com.google.protobuf.Duration getLatency() {
      if (latencyBuilder_ == null) {
        return latency_ == null ? com.google.protobuf.Duration.getDefaultInstance() : latency_;
      } else {
        return latencyBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * The request processing latency on the server, from the time the request was
     * received until the response was sent.
     * </pre>
     *
     * <code>.google.protobuf.Duration latency = 14;</code>
     */
    public Builder setLatency(com.google.protobuf.Duration value) {
      if (latencyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        latency_ = value;
        onChanged();
      } else {
        latencyBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * The request processing latency on the server, from the time the request was
     * received until the response was sent.
     * </pre>
     *
     * <code>.google.protobuf.Duration latency = 14;</code>
     */
    public Builder setLatency(
        com.google.protobuf.Duration.Builder builderForValue) {
      if (latencyBuilder_ == null) {
        latency_ = builderForValue.build();
        onChanged();
      } else {
        latencyBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * The request processing latency on the server, from the time the request was
     * received until the response was sent.
     * </pre>
     *
     * <code>.google.protobuf.Duration latency = 14;</code>
     */
    public Builder mergeLatency(com.google.protobuf.Duration value) {
      if (latencyBuilder_ == null) {
        if (latency_ != null) {
          latency_ =
            com.google.protobuf.Duration.newBuilder(latency_).mergeFrom(value).buildPartial();
        } else {
          latency_ = value;
        }
        onChanged();
      } else {
        latencyBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * The request processing latency on the server, from the time the request was
     * received until the response was sent.
     * </pre>
     *
     * <code>.google.protobuf.Duration latency = 14;</code>
     */
    public Builder clearLatency() {
      if (latencyBuilder_ == null) {
        latency_ = null;
        onChanged();
      } else {
        latency_ = null;
        latencyBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * The request processing latency on the server, from the time the request was
     * received until the response was sent.
     * </pre>
     *
     * <code>.google.protobuf.Duration latency = 14;</code>
     */
    public com.google.protobuf.Duration.Builder getLatencyBuilder() {
      
      onChanged();
      return getLatencyFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * The request processing latency on the server, from the time the request was
     * received until the response was sent.
     * </pre>
     *
     * <code>.google.protobuf.Duration latency = 14;</code>
     */
    public com.google.protobuf.DurationOrBuilder getLatencyOrBuilder() {
      if (latencyBuilder_ != null) {
        return latencyBuilder_.getMessageOrBuilder();
      } else {
        return latency_ == null ?
            com.google.protobuf.Duration.getDefaultInstance() : latency_;
      }
    }
    /**
     * <pre>
     * The request processing latency on the server, from the time the request was
     * received until the response was sent.
     * </pre>
     *
     * <code>.google.protobuf.Duration latency = 14;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.protobuf.Duration, com.google.protobuf.Duration.Builder, com.google.protobuf.DurationOrBuilder> 
        getLatencyFieldBuilder() {
      if (latencyBuilder_ == null) {
        latencyBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration, com.google.protobuf.Duration.Builder, com.google.protobuf.DurationOrBuilder>(
                getLatency(),
                getParentForChildren(),
                isClean());
        latency_ = null;
      }
      return latencyBuilder_;
    }

    private boolean cacheLookup_ ;
    /**
     * <pre>
     * Whether or not a cache lookup was attempted.
     * </pre>
     *
     * <code>bool cache_lookup = 11;</code>
     */
    public boolean getCacheLookup() {
      return cacheLookup_;
    }
    /**
     * <pre>
     * Whether or not a cache lookup was attempted.
     * </pre>
     *
     * <code>bool cache_lookup = 11;</code>
     */
    public Builder setCacheLookup(boolean value) {
      
      cacheLookup_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Whether or not a cache lookup was attempted.
     * </pre>
     *
     * <code>bool cache_lookup = 11;</code>
     */
    public Builder clearCacheLookup() {
      
      cacheLookup_ = false;
      onChanged();
      return this;
    }

    private boolean cacheHit_ ;
    /**
     * <pre>
     * Whether or not an entity was served from cache
     * (with or without validation).
     * </pre>
     *
     * <code>bool cache_hit = 9;</code>
     */
    public boolean getCacheHit() {
      return cacheHit_;
    }
    /**
     * <pre>
     * Whether or not an entity was served from cache
     * (with or without validation).
     * </pre>
     *
     * <code>bool cache_hit = 9;</code>
     */
    public Builder setCacheHit(boolean value) {
      
      cacheHit_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Whether or not an entity was served from cache
     * (with or without validation).
     * </pre>
     *
     * <code>bool cache_hit = 9;</code>
     */
    public Builder clearCacheHit() {
      
      cacheHit_ = false;
      onChanged();
      return this;
    }

    private boolean cacheValidatedWithOriginServer_ ;
    /**
     * <pre>
     * Whether or not the response was validated with the origin server before
     * being served from cache. This field is only meaningful if `cache_hit` is
     * True.
     * </pre>
     *
     * <code>bool cache_validated_with_origin_server = 10;</code>
     */
    public boolean getCacheValidatedWithOriginServer() {
      return cacheValidatedWithOriginServer_;
    }
    /**
     * <pre>
     * Whether or not the response was validated with the origin server before
     * being served from cache. This field is only meaningful if `cache_hit` is
     * True.
     * </pre>
     *
     * <code>bool cache_validated_with_origin_server = 10;</code>
     */
    public Builder setCacheValidatedWithOriginServer(boolean value) {
      
      cacheValidatedWithOriginServer_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Whether or not the response was validated with the origin server before
     * being served from cache. This field is only meaningful if `cache_hit` is
     * True.
     * </pre>
     *
     * <code>bool cache_validated_with_origin_server = 10;</code>
     */
    public Builder clearCacheValidatedWithOriginServer() {
      
      cacheValidatedWithOriginServer_ = false;
      onChanged();
      return this;
    }

    private long cacheFillBytes_ ;
    /**
     * <pre>
     * The number of HTTP response bytes inserted into cache. Set only when a
     * cache fill was attempted.
     * </pre>
     *
     * <code>int64 cache_fill_bytes = 12;</code>
     */
    public long getCacheFillBytes() {
      return cacheFillBytes_;
    }
    /**
     * <pre>
     * The number of HTTP response bytes inserted into cache. Set only when a
     * cache fill was attempted.
     * </pre>
     *
     * <code>int64 cache_fill_bytes = 12;</code>
     */
    public Builder setCacheFillBytes(long value) {
      
      cacheFillBytes_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The number of HTTP response bytes inserted into cache. Set only when a
     * cache fill was attempted.
     * </pre>
     *
     * <code>int64 cache_fill_bytes = 12;</code>
     */
    public Builder clearCacheFillBytes() {
      
      cacheFillBytes_ = 0L;
      onChanged();
      return this;
    }

    private Object protocol_ = "";
    /**
     * <pre>
     * Protocol used for the request. Examples: "HTTP/1.1", "HTTP/2", "websocket"
     * </pre>
     *
     * <code>string protocol = 15;</code>
     */
    public String getProtocol() {
      Object ref = protocol_;
      if (!(ref instanceof String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        String s = bs.toStringUtf8();
        protocol_ = s;
        return s;
      } else {
        return (String) ref;
      }
    }
    /**
     * <pre>
     * Protocol used for the request. Examples: "HTTP/1.1", "HTTP/2", "websocket"
     * </pre>
     *
     * <code>string protocol = 15;</code>
     */
    public com.google.protobuf.ByteString
        getProtocolBytes() {
      Object ref = protocol_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (String) ref);
        protocol_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Protocol used for the request. Examples: "HTTP/1.1", "HTTP/2", "websocket"
     * </pre>
     *
     * <code>string protocol = 15;</code>
     */
    public Builder setProtocol(
        String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      protocol_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Protocol used for the request. Examples: "HTTP/1.1", "HTTP/2", "websocket"
     * </pre>
     *
     * <code>string protocol = 15;</code>
     */
    public Builder clearProtocol() {
      
      protocol_ = getDefaultInstance().getProtocol();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Protocol used for the request. Examples: "HTTP/1.1", "HTTP/2", "websocket"
     * </pre>
     *
     * <code>string protocol = 15;</code>
     */
    public Builder setProtocolBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      protocol_ = value;
      onChanged();
      return this;
    }
    @Override
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:google.logging.type.HttpRequest)
  }

  // @@protoc_insertion_point(class_scope:google.logging.type.HttpRequest)
  private static final HttpRequest DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new HttpRequest();
  }

  public static HttpRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<HttpRequest>
      PARSER = new com.google.protobuf.AbstractParser<HttpRequest>() {
    @Override
    public HttpRequest parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new HttpRequest(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<HttpRequest> parser() {
    return PARSER;
  }

  @Override
  public com.google.protobuf.Parser<HttpRequest> getParserForType() {
    return PARSER;
  }

  @Override
  public HttpRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

