/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2018-11-06 at 09:43:21 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.storage.model;

/**
 * A list of buckets.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Storage JSON API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Buckets extends com.google.api.client.json.GenericJson {

  /**
   * The list of items.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Bucket> items;

  static {
    // hack to force ProGuard to consider Bucket used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Bucket.class);
  }

  /**
   * The kind of item this is. For lists of buckets, this is always storage#buckets.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The continuation token, used to page through large result sets. Provide this value in a
   * subsequent request to return the next page of results.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * The list of items.
   * @return value or {@code null} for none
   */
  public java.util.List<Bucket> getItems() {
    return items;
  }

  /**
   * The list of items.
   * @param items items or {@code null} for none
   */
  public Buckets setItems(java.util.List<Bucket> items) {
    this.items = items;
    return this;
  }

  /**
   * The kind of item this is. For lists of buckets, this is always storage#buckets.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * The kind of item this is. For lists of buckets, this is always storage#buckets.
   * @param kind kind or {@code null} for none
   */
  public Buckets setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The continuation token, used to page through large result sets. Provide this value in a
   * subsequent request to return the next page of results.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * The continuation token, used to page through large result sets. Provide this value in a
   * subsequent request to return the next page of results.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public Buckets setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  @Override
  public Buckets set(String fieldName, Object value) {
    return (Buckets) super.set(fieldName, value);
  }

  @Override
  public Buckets clone() {
    return (Buckets) super.clone();
  }

}
