// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: network-bid.proto

package com.google.protos.adx;

public final class NetworkBid {
  private NetworkBid() {}
  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistryLite registry) {
  }

  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistry registry) {
    registerAllExtensions(
        (com.google.protobuf.ExtensionRegistryLite) registry);
  }
  /**
   * <pre>
   * SKAdNetwork API starting from version 2.2 supports multiple ad
   * presentation options specified by the `fidelity-type` parameter of the
   * SKAdNetwork signature.  The following are the fidelity types supported by
   * Apple. For more info visit:
   * https://developer.apple.com/documentation/storekit/skadnetwork/signing_and_providing_ads
   * </pre>
   *
   * Protobuf enum {@code com.google.protos.adx.SKAdNetworkFidelityType}
   */
  public enum SKAdNetworkFidelityType
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     * Attribution for app installs within 24 hours of viewing an ad for at least
     * 3 seconds. Supported for SKAdnetwork version 2.2 and up. For more info see:
     * https://developer.apple.com/documentation/storekit/skadnetwork/generating_the_signature_to_validate_view-through_ads
     * </pre>
     *
     * <code>VIEW_THROUGH_ADS = 0;</code>
     */
    VIEW_THROUGH_ADS(0),
    /**
     * <pre>
     * Attribution for app installs initiated from the StoreKit-rendered App Store
     * product page driven by ad clicks. Supported for all SKAdNetwork versions.
     * For more info see:
     * https://developer.apple.com/documentation/storekit/skadnetwork/generating_the_signature_to_validate_storekit-rendered_ads
     * </pre>
     *
     * <code>STOREKIT_RENDERED_ADS = 1;</code>
     */
    STOREKIT_RENDERED_ADS(1),
    ;

    /**
     * <pre>
     * Attribution for app installs within 24 hours of viewing an ad for at least
     * 3 seconds. Supported for SKAdnetwork version 2.2 and up. For more info see:
     * https://developer.apple.com/documentation/storekit/skadnetwork/generating_the_signature_to_validate_view-through_ads
     * </pre>
     *
     * <code>VIEW_THROUGH_ADS = 0;</code>
     */
    public static final int VIEW_THROUGH_ADS_VALUE = 0;
    /**
     * <pre>
     * Attribution for app installs initiated from the StoreKit-rendered App Store
     * product page driven by ad clicks. Supported for all SKAdNetwork versions.
     * For more info see:
     * https://developer.apple.com/documentation/storekit/skadnetwork/generating_the_signature_to_validate_storekit-rendered_ads
     * </pre>
     *
     * <code>STOREKIT_RENDERED_ADS = 1;</code>
     */
    public static final int STOREKIT_RENDERED_ADS_VALUE = 1;


    public final int getNumber() {
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SKAdNetworkFidelityType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static SKAdNetworkFidelityType forNumber(int value) {
      switch (value) {
        case 0: return VIEW_THROUGH_ADS;
        case 1: return STOREKIT_RENDERED_ADS;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<SKAdNetworkFidelityType>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        SKAdNetworkFidelityType> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<SKAdNetworkFidelityType>() {
            public SKAdNetworkFidelityType findValueByNumber(int number) {
              return SKAdNetworkFidelityType.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return com.google.protos.adx.NetworkBid.getDescriptor().getEnumTypes().get(0);
    }

    private static final SKAdNetworkFidelityType[] VALUES = values();

    public static SKAdNetworkFidelityType valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private SKAdNetworkFidelityType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:com.google.protos.adx.SKAdNetworkFidelityType)
  }

  public interface BidRequestOrBuilder extends
      // @@protoc_insertion_point(interface_extends:com.google.protos.adx.BidRequest)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Unique request id generated by Google. This is 16 bytes long.
     * </pre>
     *
     * <code>required bytes id = 2;</code>
     * @return Whether the id field is set.
     */
    boolean hasId();
    /**
     * <pre>
     * Unique request id generated by Google. This is 16 bytes long.
     * </pre>
     *
     * <code>required bytes id = 2;</code>
     * @return The id.
     */
    com.google.protobuf.ByteString getId();

    /**
     * <pre>
     * The first 3 bytes of the IP address in network byte order for IPv4, or the
     * first 6 bytes for IPv6. Note that the number and position of the bytes
     * included from IPv6 addresses may change later.
     * </pre>
     *
     * <code>optional bytes ip = 4;</code>
     * @return Whether the ip field is set.
     */
    boolean hasIp();
    /**
     * <pre>
     * The first 3 bytes of the IP address in network byte order for IPv4, or the
     * first 6 bytes for IPv6. Note that the number and position of the bytes
     * included from IPv6 addresses may change later.
     * </pre>
     *
     * <code>optional bytes ip = 4;</code>
     * @return The ip.
     */
    com.google.protobuf.ByteString getIp();

    /**
     * <pre>
     * When user_data_treatment is set, the user's cookie/id data is cleared from
     * the request and is not sent in callout.
     * The impacted fields are:
     *  * google_user_id
     *  * hosted_match_data
     *  * mobile.encrypted_advertising_id
     *  * mobile.encrypted_hashed_idfa
     *  * session_id
     * </pre>
     *
     * <code>repeated .com.google.protos.adx.BidRequest.UserDataTreatment user_data_treatment = 49;</code>
     * @return A list containing the userDataTreatment.
     */
    java.util.List<com.google.protos.adx.NetworkBid.BidRequest.UserDataTreatment> getUserDataTreatmentList();
    /**
     * <pre>
     * When user_data_treatment is set, the user's cookie/id data is cleared from
     * the request and is not sent in callout.
     * The impacted fields are:
     *  * google_user_id
     *  * hosted_match_data
     *  * mobile.encrypted_advertising_id
     *  * mobile.encrypted_hashed_idfa
     *  * session_id
     * </pre>
     *
     * <code>repeated .com.google.protos.adx.BidRequest.UserDataTreatment user_data_treatment = 49;</code>
     * @return The count of userDataTreatment.
     */
    int getUserDataTreatmentCount();
    /**
     * <pre>
     * When user_data_treatment is set, the user's cookie/id data is cleared from
     * the request and is not sent in callout.
     * The impacted fields are:
     *  * google_user_id
     *  * hosted_match_data
     *  * mobile.encrypted_advertising_id
     *  * mobile.encrypted_hashed_idfa
     *  * session_id
     * </pre>
     *
     * <code>repeated .com.google.protos.adx.BidRequest.UserDataTreatment user_data_treatment = 49;</code>
     * @param index The index of the element to return.
     * @return The userDataTreatment at the given index.
     */
    com.google.protos.adx.NetworkBid.BidRequest.UserDataTreatment getUserDataTreatment(int index);

    /**
     * <pre>
     * The Google ID for the user. This field is the unpadded web-safe base64
     * encoded version of a binary cookie id. See the "Base 64 Encoding with URL
     * and Filename Safe Alphabet" section in RFC 3548 for encoding details. This
     * field may be the same as the Google ID returned by the cookie matching
     * service. Not set if there is one or more user_data_treatment value.
     * </pre>
     *
     * <code>optional string google_user_id = 21;</code>
     * @return Whether the googleUserId field is set.
     */
    boolean hasGoogleUserId();
    /**
     * <pre>
     * The Google ID for the user. This field is the unpadded web-safe base64
     * encoded version of a binary cookie id. See the "Base 64 Encoding with URL
     * and Filename Safe Alphabet" section in RFC 3548 for encoding details. This
     * field may be the same as the Google ID returned by the cookie matching
     * service. Not set if there is one or more user_data_treatment value.
     * </pre>
     *
     * <code>optional string google_user_id = 21;</code>
     * @return The googleUserId.
     */
    java.lang.String getGoogleUserId();
    /**
     * <pre>
     * The Google ID for the user. This field is the unpadded web-safe base64
     * encoded version of a binary cookie id. See the "Base 64 Encoding with URL
     * and Filename Safe Alphabet" section in RFC 3548 for encoding details. This
     * field may be the same as the Google ID returned by the cookie matching
     * service. Not set if there is one or more user_data_treatment value.
     * </pre>
     *
     * <code>optional string google_user_id = 21;</code>
     * @return The bytes for googleUserId.
     */
    com.google.protobuf.ByteString
        getGoogleUserIdBytes();

    /**
     * <pre>
     * The version number of the google_user_id. We may sometimes change the
     * mapping from cookie to google_user_id. In this case the version will be
     * incremented.
     * </pre>
     *
     * <code>optional uint32 cookie_version = 20;</code>
     * @return Whether the cookieVersion field is set.
     */
    boolean hasCookieVersion();
    /**
     * <pre>
     * The version number of the google_user_id. We may sometimes change the
     * mapping from cookie to google_user_id. In this case the version will be
     * incremented.
     * </pre>
     *
     * <code>optional uint32 cookie_version = 20;</code>
     * @return The cookieVersion.
     */
    int getCookieVersion();

    /**
     * <pre>
     * The time in seconds since the google_user_id was created.
     * This number may be quantized.
     * </pre>
     *
     * <code>optional int32 cookie_age_seconds = 31;</code>
     * @return Whether the cookieAgeSeconds field is set.
     */
    boolean hasCookieAgeSeconds();
    /**
     * <pre>
     * The time in seconds since the google_user_id was created.
     * This number may be quantized.
     * </pre>
     *
     * <code>optional int32 cookie_age_seconds = 31;</code>
     * @return The cookieAgeSeconds.
     */
    int getCookieAgeSeconds();

    /**
     * <pre>
     * Match data stored for this google_user_id through the cookie matching
     * service. If a match exists, then this field holds the decoded data that
     * was passed in the google_hm parameter.
     * Not set if there is one or more user_data_treatment value.
     * </pre>
     *
     * <code>optional bytes hosted_match_data = 37;</code>
     * @return Whether the hostedMatchData field is set.
     */
    boolean hasHostedMatchData();
    /**
     * <pre>
     * Match data stored for this google_user_id through the cookie matching
     * service. If a match exists, then this field holds the decoded data that
     * was passed in the google_hm parameter.
     * Not set if there is one or more user_data_treatment value.
     * </pre>
     *
     * <code>optional bytes hosted_match_data = 37;</code>
     * @return The hostedMatchData.
     */
    com.google.protobuf.ByteString getHostedMatchData();

    /**
     * <pre>
     * Represents a short-lived user session on CTV/OTT devices,
     * with a maximum session duration of 6 hours.
     * The use of session_id is never allowed for ads personalization.
     * session_id may only be used for frequency capping, competitive exclusions
     * or related purposes.
     * </pre>
     *
     * <code>optional string session_id = 65;</code>
     * @return Whether the sessionId field is set.
     */
    boolean hasSessionId();
    /**
     * <pre>
     * Represents a short-lived user session on CTV/OTT devices,
     * with a maximum session duration of 6 hours.
     * The use of session_id is never allowed for ads personalization.
     * session_id may only be used for frequency capping, competitive exclusions
     * or related purposes.
     * </pre>
     *
     * <code>optional string session_id = 65;</code>
     * @return The sessionId.
     */
    java.lang.String getSessionId();
    /**
     * <pre>
     * Represents a short-lived user session on CTV/OTT devices,
     * with a maximum session duration of 6 hours.
     * The use of session_id is never allowed for ads personalization.
     * session_id may only be used for frequency capping, competitive exclusions
     * or related purposes.
     * </pre>
     *
     * <code>optional string session_id = 65;</code>
     * @return The bytes for sessionId.
     */
    com.google.protobuf.ByteString
        getSessionIdBytes();

    /**
     * <pre>
     * A string that identifies the browser and type of device that sent the
     * request. Certain data may be redacted or replaced.
     * </pre>
     *
     * <code>optional string user_agent = 6;</code>
     * @return Whether the userAgent field is set.
     */
    boolean hasUserAgent();
    /**
     * <pre>
     * A string that identifies the browser and type of device that sent the
     * request. Certain data may be redacted or replaced.
     * </pre>
     *
     * <code>optional string user_agent = 6;</code>
     * @return The userAgent.
     */
    java.lang.String getUserAgent();
    /**
     * <pre>
     * A string that identifies the browser and type of device that sent the
     * request. Certain data may be redacted or replaced.
     * </pre>
     *
     * <code>optional string user_agent = 6;</code>
     * @return The bytes for userAgent.
     */
    com.google.protobuf.ByteString
        getUserAgentBytes();

    /**
     * <code>optional .com.google.protos.adx.BidRequest.PrivacyTreatments privacy_treatments = 71;</code>
     * @return Whether the privacyTreatments field is set.
     */
    boolean hasPrivacyTreatments();
    /**
     * <code>optional .com.google.protos.adx.BidRequest.PrivacyTreatments privacy_treatments = 71;</code>
     * @return The privacyTreatments.
     */
    com.google.protos.adx.NetworkBid.BidRequest.PrivacyTreatments getPrivacyTreatments();
    /**
     * <code>optional .com.google.protos.adx.BidRequest.PrivacyTreatments privacy_treatments = 71;</code>
     */
    com.google.protos.adx.NetworkBid.BidRequest.PrivacyTreatmentsOrBuilder getPrivacyTreatmentsOrBuilder();

    /**
     * <pre>
     * Structured user agent information. If both BidRequest.ua and
     * BidRequest.sua are present, BidRequest.sua should be considered the
     * more accurate representation of the device attributes. This is because
     * BidRequest.ua may contain a frozen or reduced user agent string.
     * </pre>
     *
     * <code>optional .com.google.protos.adx.BidRequest.UserAgent user_agent_data = 63;</code>
     * @return Whether the userAgentData field is set.
     */
    boolean hasUserAgentData();
    /**
     * <pre>
     * Structured user agent information. If both BidRequest.ua and
     * BidRequest.sua are present, BidRequest.sua should be considered the
     * more accurate representation of the device attributes. This is because
     * BidRequest.ua may contain a frozen or reduced user agent string.
     * </pre>
     *
     * <code>optional .com.google.protos.adx.BidRequest.UserAgent user_agent_data = 63;</code>
     * @return The userAgentData.
     */
    com.google.protos.adx.NetworkBid.BidRequest.UserAgent getUserAgentData();
    /**
     * <pre>
     * Structured user agent information. If both BidRequest.ua and
     * BidRequest.sua are present, BidRequest.sua should be considered the
     * more accurate representation of the device attributes. This is because
     * BidRequest.ua may contain a frozen or reduced user agent string.
     * </pre>
     *
     * <code>optional .com.google.protos.adx.BidRequest.UserAgent user_agent_data = 63;</code>
     */
    com.google.protos.adx.NetworkBid.BidRequest.UserAgentOrBuilder getUserAgentDataOrBuilder();

    /**
     * <pre>
     * The billing address country of the publisher. This may be different from
     * the detected country of the user in geo_criteria_id or the hosting country
     * of the website. For a complete list of country codes, please refer to
     * https://developers.google.com/google-ads/api/reference/data/codes-formats#country_codes
     * </pre>
     *
     * <code>optional string publisher_country = 55;</code>
     * @return Whether the publisherCountry field is set.
     */
    boolean hasPublisherCountry();
    /**
     * <pre>
     * The billing address country of the publisher. This may be different from
     * the detected country of the user in geo_criteria_id or the hosting country
     * of the website. For a complete list of country codes, please refer to
     * https://developers.google.com/google-ads/api/reference/data/codes-formats#country_codes
     * </pre>
     *
     * <code>optional string publisher_country = 55;</code>
     * @return The publisherCountry.
     */
    java.lang.String getPublisherCountry();
    /**
     * <pre>
     * The billing address country of the publisher. This may be different from
     * the detected country of the user in geo_criteria_id or the hosting country
     * of the website. For a complete list of country codes, please refer to
     * https://developers.google.com/google-ads/api/reference/data/codes-formats#country_codes
     * </pre>
     *
     * <code>optional string publisher_country = 55;</code>
     * @return The bytes for publisherCountry.
     */
    com.google.protobuf.ByteString
        getPublisherCountryBytes();

    /**
     * <pre>
     * The ID of the host publisher. When populated, indicates that the host
     * publisher participated in revenue sharing, and the ID can be used to
     * authorize ads.txt.
     * </pre>
     *
     * <code>optional string host_publisher_id = 73;</code>
     * @return Whether the hostPublisherId field is set.
     */
    boolean hasHostPublisherId();
    /**
     * <pre>
     * The ID of the host publisher. When populated, indicates that the host
     * publisher participated in revenue sharing, and the ID can be used to
     * authorize ads.txt.
     * </pre>
     *
     * <code>optional string host_publisher_id = 73;</code>
     * @return The hostPublisherId.
     */
    java.lang.String getHostPublisherId();
    /**
     * <pre>
     * The ID of the host publisher. When populated, indicates that the host
     * publisher participated in revenue sharing, and the ID can be used to
     * authorize ads.txt.
     * </pre>
     *
     * <code>optional string host_publisher_id = 73;</code>
     * @return The bytes for hostPublisherId.
     */
    com.google.protobuf.ByteString
        getHostPublisherIdBytes();

    /**
     * <pre>
     * Location of the end user. Uses a subset of the codes used in the Google
     * Ads API. See the geo-table.csv table in the technical documentation for a
     * list of IDs. The geo_criteria_id field replaces the deprecated country,
     * region, city, and metro fields.
     * It is recommended that BidRequest.geo be used instead of this field.
     * See Geotargeting Guide:
     * https://developers.google.com/authorized-buyers/rtb/geotargeting
     * </pre>
     *
     * <code>optional int32 geo_criteria_id = 39;</code>
     * @return Whether the geoCriteriaId field is set.
     */
    boolean hasGeoCriteriaId();
    /**
     * <pre>
     * Location of the end user. Uses a subset of the codes used in the Google
     * Ads API. See the geo-table.csv table in the technical documentation for a
     * list of IDs. The geo_criteria_id field replaces the deprecated country,
     * region, city, and metro fields.
     * It is recommended that BidRequest.geo be used instead of this field.
     * See Geotargeting Guide:
     * https://developers.google.com/authorized-buyers/rtb/geotargeting
     * </pre>
     *
     * <code>optional int32 geo_criteria_id = 39;</code>
     * @return The geoCriteriaId.
     */
    int getGeoCriteriaId();

    /**
     * <code>optional .com.google.protos.adx.BidRequest.Geo geo = 62;</code>
     * @return Whether the geo field is set.
     */
    boolean hasGeo();
    /**
     * <code>optional .com.google.protos.adx.BidRequest.Geo geo = 62;</code>
     * @return The geo.
     */
    com.google.protos.adx.NetworkBid.BidRequest.Geo getGeo();
    /**
     * <code>optional .com.google.protos.adx.BidRequest.Geo geo = 62;</code>
     */
    com.google.protos.adx.NetworkBid.BidRequest.GeoOrBuilder getGeoOrBuilder();

    /**
     * <pre>
     * Detected postal code of the appropriate type for the country of the end
     * user (e.g., zip code if the country is "US"). The postal_code_prefix field
     * is set when accuracy is too low to imply a full code, otherwise the
     * postal_code field is set.
     * It is recommended that BidRequest.geo be used instead of this field.
     * See Geotargeting Guide:
     * https://developers.google.com/authorized-buyers/rtb/geotargeting
     * </pre>
     *
     * <code>optional string postal_code = 33;</code>
     * @return Whether the postalCode field is set.
     */
    boolean hasPostalCode();
    /**
     * <pre>
     * Detected postal code of the appropriate type for the country of the end
     * user (e.g., zip code if the country is "US"). The postal_code_prefix field
     * is set when accuracy is too low to imply a full code, otherwise the
     * postal_code field is set.
     * It is recommended that BidRequest.geo be used instead of this field.
     * See Geotargeting Guide:
     * https://developers.google.com/authorized-buyers/rtb/geotargeting
     * </pre>
     *
     * <code>optional string postal_code = 33;</code>
     * @return The postalCode.
     */
    java.lang.String getPostalCode();
    /**
     * <pre>
     * Detected postal code of the appropriate type for the country of the end
     * user (e.g., zip code if the country is "US"). The postal_code_prefix field
     * is set when accuracy is too low to imply a full code, otherwise the
     * postal_code field is set.
     * It is recommended that BidRequest.geo be used instead of this field.
     * See Geotargeting Guide:
     * https://developers.google.com/authorized-buyers/rtb/geotargeting
     * </pre>
     *
     * <code>optional string postal_code = 33;</code>
     * @return The bytes for postalCode.
     */
    com.google.protobuf.ByteString
        getPostalCodeBytes();

    /**
     * <pre>
     * It is recommended that BidRequest.geo be used instead of this field.
     * See Geotargeting Guide:
     * https://developers.google.com/authorized-buyers/rtb/geotargeting
     * </pre>
     *
     * <code>optional string postal_code_prefix = 34;</code>
     * @return Whether the postalCodePrefix field is set.
     */
    boolean hasPostalCodePrefix();
    /**
     * <pre>
     * It is recommended that BidRequest.geo be used instead of this field.
     * See Geotargeting Guide:
     * https://developers.google.com/authorized-buyers/rtb/geotargeting
     * </pre>
     *
     * <code>optional string postal_code_prefix = 34;</code>
     * @return The postalCodePrefix.
     */
    java.lang.String getPostalCodePrefix();
    /**
     * <pre>
     * It is recommended that BidRequest.geo be used instead of this field.
     * See Geotargeting Guide:
     * https://developers.google.com/authorized-buyers/rtb/geotargeting
     * </pre>
     *
     * <code>optional string postal_code_prefix = 34;</code>
     * @return The bytes for postalCodePrefix.
     */
    com.google.protobuf.ByteString
        getPostalCodePrefixBytes();

    /**
     * <pre>
     * Hyperlocal targeting signal when available, encrypted as described at
     * https://developers.google.com/authorized-buyers/rtb/response-guide/decrypt-hyperlocal
     * </pre>
     *
     * <code>optional bytes encrypted_hyperlocal_set = 40;</code>
     * @return Whether the encryptedHyperlocalSet field is set.
     */
    boolean hasEncryptedHyperlocalSet();
    /**
     * <pre>
     * Hyperlocal targeting signal when available, encrypted as described at
     * https://developers.google.com/authorized-buyers/rtb/response-guide/decrypt-hyperlocal
     * </pre>
     *
     * <code>optional bytes encrypted_hyperlocal_set = 40;</code>
     * @return The encryptedHyperlocalSet.
     */
    com.google.protobuf.ByteString getEncryptedHyperlocalSet();

    /**
     * <pre>
     * Unencrypted version of encrypted_hyperlocal_set. This field is only set
     * when using an SSL connection.
     * </pre>
     *
     * <code>optional .com.google.protos.adx.BidRequest.HyperlocalSet hyperlocal_set = 53;</code>
     * @return Whether the hyperlocalSet field is set.
     */
    boolean hasHyperlocalSet();
    /**
     * <pre>
     * Unencrypted version of encrypted_hyperlocal_set. This field is only set
     * when using an SSL connection.
     * </pre>
     *
     * <code>optional .com.google.protos.adx.BidRequest.HyperlocalSet hyperlocal_set = 53;</code>
     * @return The hyperlocalSet.
     */
    com.google.protos.adx.NetworkBid.BidRequest.HyperlocalSet getHyperlocalSet();
    /**
     * <pre>
     * Unencrypted version of encrypted_hyperlocal_set. This field is only set
     * when using an SSL connection.
     * </pre>
     *
     * <code>optional .com.google.protos.adx.BidRequest.HyperlocalSet hyperlocal_set = 53;</code>
     */
    com.google.protos.adx.NetworkBid.BidRequest.HyperlocalSetOrBuilder getHyperlocalSetOrBuilder();

    /**
     * <pre>
     * The offset of the user's time from GMT in minutes. For example, GMT+10 is
     * timezone_offset = 600.
     * </pre>
     *
     * <code>optional int32 timezone_offset = 25;</code>
     * @return Whether the timezoneOffset field is set.
     */
    boolean hasTimezoneOffset();
    /**
     * <pre>
     * The offset of the user's time from GMT in minutes. For example, GMT+10 is
     * timezone_offset = 600.
     * </pre>
     *
     * <code>optional int32 timezone_offset = 25;</code>
     * @return The timezoneOffset.
     */
    int getTimezoneOffset();

    /**
     * <code>repeated .com.google.protos.adx.BidRequest.UserList user_list = 32;</code>
     */
    java.util.List<com.google.protos.adx.NetworkBid.BidRequest.UserList> 
        getUserListList();
    /**
     * <code>repeated .com.google.protos.adx.BidRequest.UserList user_list = 32;</code>
     */
    com.google.protos.adx.NetworkBid.BidRequest.UserList getUserList(int index);
    /**
     * <code>repeated .com.google.protos.adx.BidRequest.UserList user_list = 32;</code>
     */
    int getUserListCount();
    /**
     * <code>repeated .com.google.protos.adx.BidRequest.UserList user_list = 32;</code>
     */
    java.util.List<? extends com.google.protos.adx.NetworkBid.BidRequest.UserListOrBuilder> 
        getUserListOrBuilderList();
    /**
     * <code>repeated .com.google.protos.adx.BidRequest.UserList user_list = 32;</code>
     */
    com.google.protos.adx.NetworkBid.BidRequest.UserListOrBuilder getUserListOrBuilder(
        int index);

    /**
     * <pre>
     * The publisher ID as defined by the publisher code suffix of
     * the web property code. For instance, "pub-123" is the publisher code of web
     * property code "ca-pub-123" (ca- is the product specific prefix of the web
     * property).
     * </pre>
     *
     * <code>optional string publisher_id = 56;</code>
     * @return Whether the publisherId field is set.
     */
    boolean hasPublisherId();
    /**
     * <pre>
     * The publisher ID as defined by the publisher code suffix of
     * the web property code. For instance, "pub-123" is the publisher code of web
     * property code "ca-pub-123" (ca- is the product specific prefix of the web
     * property).
     * </pre>
     *
     * <code>optional string publisher_id = 56;</code>
     * @return The publisherId.
     */
    java.lang.String getPublisherId();
    /**
     * <pre>
     * The publisher ID as defined by the publisher code suffix of
     * the web property code. For instance, "pub-123" is the publisher code of web
     * property code "ca-pub-123" (ca- is the product specific prefix of the web
     * property).
     * </pre>
     *
     * <code>optional string publisher_id = 56;</code>
     * @return The bytes for publisherId.
     */
    com.google.protobuf.ByteString
        getPublisherIdBytes();

    /**
     * <pre>
     * The seller network id. See seller-network-ids.txt file in the technical
     * documentation for a list of ids. This is only set if the site is not
     * anonymous and the publisher allows site targeting.
     * </pre>
     *
     * <code>optional int32 seller_network_id = 41;</code>
     * @return Whether the sellerNetworkId field is set.
     */
    boolean hasSellerNetworkId();
    /**
     * <pre>
     * The seller network id. See seller-network-ids.txt file in the technical
     * documentation for a list of ids. This is only set if the site is not
     * anonymous and the publisher allows site targeting.
     * </pre>
     *
     * <code>optional int32 seller_network_id = 41;</code>
     * @return The sellerNetworkId.
     */
    int getSellerNetworkId();

    /**
     * <pre>
     * Id for the partner that provides this inventory. This is only set when
     * seller_network_id is also set and further partner information beyond the
     * seller_network_id is also available. The value of the partner_id is not
     * meaningful beyond providing a stable identifier.
     * </pre>
     *
     * <code>optional fixed64 partner_id = 52;</code>
     * @return Whether the partnerId field is set.
     */
    boolean hasPartnerId();
    /**
     * <pre>
     * Id for the partner that provides this inventory. This is only set when
     * seller_network_id is also set and further partner information beyond the
     * seller_network_id is also available. The value of the partner_id is not
     * meaningful beyond providing a stable identifier.
     * </pre>
     *
     * <code>optional fixed64 partner_id = 52;</code>
     * @return The partnerId.
     */
    long getPartnerId();

    /**
     * <pre>
     * The URL of the page with parameters removed. This is only set if the
     * publisher allows site targeting. This always starts with a protocol (either
     * http or https).
     * </pre>
     *
     * <code>optional string url = 11;</code>
     * @return Whether the url field is set.
     */
    boolean hasUrl();
    /**
     * <pre>
     * The URL of the page with parameters removed. This is only set if the
     * publisher allows site targeting. This always starts with a protocol (either
     * http or https).
     * </pre>
     *
     * <code>optional string url = 11;</code>
     * @return The url.
     */
    java.lang.String getUrl();
    /**
     * <pre>
     * The URL of the page with parameters removed. This is only set if the
     * publisher allows site targeting. This always starts with a protocol (either
     * http or https).
     * </pre>
     *
     * <code>optional string url = 11;</code>
     * @return The bytes for url.
     */
    com.google.protobuf.ByteString
        getUrlBytes();

    /**
     * <pre>
     * Indicates that the request is using semi-transparent branding,
     * which means only a truncated version of the request URL will
     * be provided. This decision is made by the publisher, see
     * https://support.google.com/admanager/answer/4584891#urls for context.
     * </pre>
     *
     * <code>optional bool is_semi_transparent_request = 67;</code>
     * @return Whether the isSemiTransparentRequest field is set.
     */
    boolean hasIsSemiTransparentRequest();
    /**
     * <pre>
     * Indicates that the request is using semi-transparent branding,
     * which means only a truncated version of the request URL will
     * be provided. This decision is made by the publisher, see
     * https://support.google.com/admanager/answer/4584891#urls for context.
     * </pre>
     *
     * <code>optional bool is_semi_transparent_request = 67;</code>
     * @return The isSemiTransparentRequest.
     */
    boolean getIsSemiTransparentRequest();

    /**
     * <pre>
     * Detected user languages, based on the language of the web page, the browser
     * settings, and other signals. The order is arbitrary. The codes are 2 or 5
     * characters and are documented at
     * https://developers.google.com/google-ads/api/reference/data/codes-formats#languages
     * </pre>
     *
     * <code>repeated string detected_language = 12;</code>
     * @return A list containing the detectedLanguage.
     */
    java.util.List<java.lang.String>
        getDetectedLanguageList();
    /**
     * <pre>
     * Detected user languages, based on the language of the web page, the browser
     * settings, and other signals. The order is arbitrary. The codes are 2 or 5
     * characters and are documented at
     * https://developers.google.com/google-ads/api/reference/data/codes-formats#languages
     * </pre>
     *
     * <code>repeated string detected_language = 12;</code>
     * @return The count of detectedLanguage.
     */
    int getDetectedLanguageCount();
    /**
     * <pre>
     * Detected user languages, based on the language of the web page, the browser
     * settings, and other signals. The order is arbitrary. The codes are 2 or 5
     * characters and are documented at
     * https://developers.google.com/google-ads/api/reference/data/codes-formats#languages
     * </pre>
     *
     * <code>repeated string detected_language = 12;</code>
     * @param index The index of the element to return.
     * @return The detectedLanguage at the given index.
     */
    java.lang.String getDetectedLanguage(int index);
    /**
     * <pre>
     * Detected user languages, based on the language of the web page, the browser
     * settings, and other signals. The order is arbitrary. The codes are 2 or 5
     * characters and are documented at
     * https://developers.google.com/google-ads/api/reference/data/codes-formats#languages
     * </pre>
     *
     * <code>repeated string detected_language = 12;</code>
     * @param index The index of the value to return.
     * @return The bytes of the detectedLanguage at the given index.
     */
    com.google.protobuf.ByteString
        getDetectedLanguageBytes(int index);

    /**
     * <pre>
     * Unordered list of detected content verticals. See the
     * publisher-verticals.txt file in the technical documentation for a list of
     * ids.
     * </pre>
     *
     * <code>repeated .com.google.protos.adx.BidRequest.Vertical detected_vertical = 13;</code>
     */
    java.util.List<com.google.protos.adx.NetworkBid.BidRequest.Vertical> 
        getDetectedVerticalList();
    /**
     * <pre>
     * Unordered list of detected content verticals. See the
     * publisher-verticals.txt file in the technical documentation for a list of
     * ids.
     * </pre>
     *
     * <code>repeated .com.google.protos.adx.BidRequest.Vertical detected_vertical = 13;</code>
     */
    com.google.protos.adx.NetworkBid.BidRequest.Vertical getDetectedVertical(int index);
    /**
     * <pre>
     * Unordered list of detected content verticals. See the
     * publisher-verticals.txt file in the technical documentation for a list of
     * ids.
     * </pre>
     *
     * <code>repeated .com.google.protos.adx.BidRequest.Vertical detected_vertical = 13;</code>
     */
    int getDetectedVerticalCount();
    /**
     * <pre>
     * Unordered list of detected content verticals. See the
     * publisher-verticals.txt file in the technical documentation for a list of
     * ids.
     * </pre>
     *
     * <code>repeated .com.google.protos.adx.BidRequest.Vertical detected_vertical = 13;</code>
     */
    java.util.List<? extends com.google.protos.adx.NetworkBid.BidRequest.VerticalOrBuilder> 
        getDetectedVerticalOrBuilderList();
    /**
     * <pre>
     * Unordered list of detected content verticals. See the
     * publisher-verticals.txt file in the technical documentation for a list of
     * ids.
     * </pre>
     *
     * <code>repeated .com.google.protos.adx.BidRequest.Vertical detected_vertical = 13;</code>
     */
    com.google.protos.adx.NetworkBid.BidRequest.VerticalOrBuilder getDetectedVerticalOrBuilder(
        int index);

    /**
     * <pre>
     * List of detected content labels. See content-labels.txt file in the
     * technical documentation for a list of ids.
     * </pre>
     *
     * <code>repeated int32 detected_content_label = 26 [packed = true];</code>
     * @return A list containing the detectedContentLabel.
     */
    java.util.List<java.lang.Integer> getDetectedContentLabelList();
    /**
     * <pre>
     * List of detected content labels. See content-labels.txt file in the
     * technical documentation for a list of ids.
     * </pre>
     *
     * <code>repeated int32 detected_content_label = 26 [packed = true];</code>
     * @return The count of detectedContentLabel.
     */
    int getDetectedContentLabelCount();
    /**
     * <pre>
     * List of detected content labels. See content-labels.txt file in the
     * technical documentation for a list of ids.
     * </pre>
     *
     * <code>repeated int32 detected_content_label = 26 [packed = true];</code>
     * @param index The index of the element to return.
     * @return The detectedContentLabel at the given index.
     */
    int getDetectedContentLabel(int index);

    /**
     * <pre>
     * This represents a unique ID for the overall query. In the event
     * that there are multiple callouts for a query, all callout requests for that
     * query will contain the same google_query_id.
     * </pre>
     *
     * <code>optional string google_query_id = 59;</code>
     * @return Whether the googleQueryId field is set.
     */
    boolean hasGoogleQueryId();
    /**
     * <pre>
     * This represents a unique ID for the overall query. In the event
     * that there are multiple callouts for a query, all callout requests for that
     * query will contain the same google_query_id.
     * </pre>
     *
     * <code>optional string google_query_id = 59;</code>
     * @return The googleQueryId.
     */
    java.lang.String getGoogleQueryId();
    /**
     * <pre>
     * This represents a unique ID for the overall query. In the event
     * that there are multiple callouts for a query, all callout requests for that
     * query will contain the same google_query_id.
     * </pre>
     *
     * <code>optional string google_query_id = 59;</code>
     * @return The bytes for googleQueryId.
     */
    com.google.protobuf.ByteString
        getGoogleQueryIdBytes();

    /**
     * <code>optional .com.google.protos.adx.BidRequest.AuctionType auction_type = 60 [default = SECOND_PRICE];</code>
     * @return Whether the auctionType field is set.
     */
    boolean hasAuctionType();
    /**
     * <code>optional .com.google.protos.adx.BidRequest.AuctionType auction_type = 60 [default = SECOND_PRICE];</code>
     * @return The auctionType.
     */
    com.google.protos.adx.NetworkBid.BidRequest.AuctionType getAuctionType();

    /**
     * <code>optional .com.google.protos.adx.BidRequest.Device device = 54;</code>
     * @return Whether the device field is set.
     */
    boolean hasDevice();
    /**
     * <code>optional .com.google.protos.adx.BidRequest.Device device = 54;</code>
     * @return The device.
     */
    com.google.protos.adx.NetworkBid.BidRequest.Device getDevice();
    /**
     * <code>optional .com.google.protos.adx.BidRequest.Device device = 54;</code>
     */
    com.google.protos.adx.NetworkBid.BidRequest.DeviceOrBuilder getDeviceOrBuilder();

    /**
     * <code>repeated .com.google.protos.adx.BidRequest.KeyValue key_value = 38;</code>
     */
    java.util.List<com.google.protos.adx.NetworkBid.BidRequest.KeyValue> 
        getKeyValueList();
    /**
     * <code>repeated .com.google.protos.adx.BidRequest.KeyValue key_value = 38;</code>
     */
    com.google.protos.adx.NetworkBid.BidRequest.KeyValue getKeyValue(int index);
    /**
     * <code>repeated .com.google.protos.adx.BidRequest.KeyValue key_value = 38;</code>
     */
    int getKeyValueCount();
    /**
     * <code>repeated .com.google.protos.adx.BidRequest.KeyValue key_value = 38;</code>
     */
    java.util.List<? extends com.google.protos.adx.NetworkBid.BidRequest.KeyValueOrBuilder> 
        getKeyValueOrBuilderList();
    /**
     * <code>repeated .com.google.protos.adx.BidRequest.KeyValue key_value = 38;</code>
     */
    com.google.protos.adx.NetworkBid.BidRequest.KeyValueOrBuilder getKeyValueOrBuilder(
        int index);

    /**
     * <code>optional .com.google.protos.adx.BidRequest.Mobile mobile = 28;</code>
     * @return Whether the mobile field is set.
     */
    boolean hasMobile();
    /**
     * <code>optional .com.google.protos.adx.BidRequest.Mobile mobile = 28;</code>
     * @return The mobile.
     */
    com.google.protos.adx.NetworkBid.BidRequest.Mobile getMobile();
    /**
     * <code>optional .com.google.protos.adx.BidRequest.Mobile mobile = 28;</code>
     */
    com.google.protos.adx.NetworkBid.BidRequest.MobileOrBuilder getMobileOrBuilder();

    /**
     * <code>optional .com.google.protos.adx.BidRequest.Video video = 29;</code>
     * @return Whether the video field is set.
     */
    boolean hasVideo();
    /**
     * <code>optional .com.google.protos.adx.BidRequest.Video video = 29;</code>
     * @return The video.
     */
    com.google.protos.adx.NetworkBid.BidRequest.Video getVideo();
    /**
     * <code>optional .com.google.protos.adx.BidRequest.Video video = 29;</code>
     */
    com.google.protos.adx.NetworkBid.BidRequest.VideoOrBuilder getVideoOrBuilder();

    /**
     * <pre>
     * The publisher settings list id that applies to this page.
     * See the RTB Publisher Settings guide at
     * https://developers.google.com/authorized-buyers/rtb/pub-settings-guide
     * for details.
     * </pre>
     *
     * <code>optional fixed64 publisher_settings_list_id = 42;</code>
     * @return Whether the publisherSettingsListId field is set.
     */
    boolean hasPublisherSettingsListId();
    /**
     * <pre>
     * The publisher settings list id that applies to this page.
     * See the RTB Publisher Settings guide at
     * https://developers.google.com/authorized-buyers/rtb/pub-settings-guide
     * for details.
     * </pre>
     *
     * <code>optional fixed64 publisher_settings_list_id = 42;</code>
     * @return The publisherSettingsListId.
     */
    long getPublisherSettingsListId();

    /**
     * <code>optional .com.google.protos.adx.BidRequest.PublisherType publisher_type = 51 [default = UNKNOWN_PUBLISHER_TYPE];</code>
     * @return Whether the publisherType field is set.
     */
    boolean hasPublisherType();
    /**
     * <code>optional .com.google.protos.adx.BidRequest.PublisherType publisher_type = 51 [default = UNKNOWN_PUBLISHER_TYPE];</code>
     * @return The publisherType.
     */
    com.google.protos.adx.NetworkBid.BidRequest.PublisherType getPublisherType();

    /**
     * <pre>
     * The visibility state of the web page containing the ad slots.
     * See https://www.w3.org/TR/page-visibility/.
     * </pre>
     *
     * <code>optional .com.google.protos.adx.BidRequest.VisibilityState page_visibility = 66 [default = VISIBILITY_STATE_UNKNOWN];</code>
     * @return Whether the pageVisibility field is set.
     */
    boolean hasPageVisibility();
    /**
     * <pre>
     * The visibility state of the web page containing the ad slots.
     * See https://www.w3.org/TR/page-visibility/.
     * </pre>
     *
     * <code>optional .com.google.protos.adx.BidRequest.VisibilityState page_visibility = 66 [default = VISIBILITY_STATE_UNKNOWN];</code>
     * @return The pageVisibility.
     */
    com.google.protos.adx.NetworkBid.BidRequest.VisibilityState getPageVisibility();

    /**
     * <code>repeated .com.google.protos.adx.BidRequest.AdSlot adslot = 14;</code>
     */
    java.util.List<com.google.protos.adx.NetworkBid.BidRequest.AdSlot> 
        getAdslotList();
    /**
     * <code>repeated .com.google.protos.adx.BidRequest.AdSlot adslot = 14;</code>
     */
    com.google.protos.adx.NetworkBid.BidRequest.AdSlot getAdslot(int index);
    /**
     * <code>repeated .com.google.protos.adx.BidRequest.AdSlot adslot = 14;</code>
     */
    int getAdslotCount();
    /**
     * <code>repeated .com.google.protos.adx.BidRequest.AdSlot adslot = 14;</code>
     */
    java.util.List<? extends com.google.protos.adx.NetworkBid.BidRequest.AdSlotOrBuilder> 
        getAdslotOrBuilderList();
    /**
     * <code>repeated .com.google.protos.adx.BidRequest.AdSlot adslot = 14;</code>
     */
    com.google.protos.adx.NetworkBid.BidRequest.AdSlotOrBuilder getAdslotOrBuilder(
        int index);

    /**
     * <code>repeated .com.google.protos.adx.BidRequest.BidResponseFeedback bid_response_feedback = 44;</code>
     */
    java.util.List<com.google.protos.adx.NetworkBid.BidRequest.BidResponseFeedback> 
        getBidResponseFeedbackList();
    /**
     * <code>repeated .com.google.protos.adx.BidRequest.BidResponseFeedback bid_response_feedback = 44;</code>
     */
    com.google.protos.adx.NetworkBid.BidRequest.BidResponseFeedback getBidResponseFeedback(int index);
    /**
     * <code>repeated .com.google.protos.adx.BidRequest.BidResponseFeedback bid_response_feedback = 44;</code>
     */
    int getBidResponseFeedbackCount();
    /**
     * <code>repeated .com.google.protos.adx.BidRequest.BidResponseFeedback bid_response_feedback = 44;</code>
     */
    java.util.List<? extends com.google.protos.adx.NetworkBid.BidRequest.BidResponseFeedbackOrBuilder> 
        getBidResponseFeedbackOrBuilderList();
    /**
     * <code>repeated .com.google.protos.adx.BidRequest.BidResponseFeedback bid_response_feedback = 44;</code>
     */
    com.google.protos.adx.NetworkBid.BidRequest.BidResponseFeedbackOrBuilder getBidResponseFeedbackOrBuilder(
        int index);

    /**
     * <pre>
     * How many milliseconds Google will wait for a response before ignoring it.
     * </pre>
     *
     * <code>optional int32 response_deadline_ms = 57;</code>
     * @return Whether the responseDeadlineMs field is set.
     */
    boolean hasResponseDeadlineMs();
    /**
     * <pre>
     * How many milliseconds Google will wait for a response before ignoring it.
     * </pre>
     *
     * <code>optional int32 response_deadline_ms = 57;</code>
     * @return The responseDeadlineMs.
     */
    int getResponseDeadlineMs();

    /**
     * <pre>
     * If true, then this is a test request. Results will not be displayed to
     * users and you will not be billed for a response even if it wins the
     * auction. You should still do regular processing since the request may be
     * used to evaluate latencies or for other testing. During your initial
     * testing with Google traffic any response that you make will be filtered
     * out of the auction whether this flag has a value of true or false.
     * </pre>
     *
     * <code>optional bool is_test = 15 [default = false];</code>
     * @return Whether the isTest field is set.
     */
    boolean hasIsTest();
    /**
     * <pre>
     * If true, then this is a test request. Results will not be displayed to
     * users and you will not be billed for a response even if it wins the
     * auction. You should still do regular processing since the request may be
     * used to evaluate latencies or for other testing. During your initial
     * testing with Google traffic any response that you make will be filtered
     * out of the auction whether this flag has a value of true or false.
     * </pre>
     *
     * <code>optional bool is_test = 15 [default = false];</code>
     * @return The isTest.
     */
    boolean getIsTest();

    /**
     * <pre>
     * If true, then this request is intended to measure network latency. Please
     * return an empty BidResponse with only processing_time_ms set as quickly as
     * possible without executing any bidding logic.
     * </pre>
     *
     * <code>optional bool is_ping = 17 [default = false];</code>
     * @return Whether the isPing field is set.
     */
    boolean hasIsPing();
    /**
     * <pre>
     * If true, then this request is intended to measure network latency. Please
     * return an empty BidResponse with only processing_time_ms set as quickly as
     * possible without executing any bidding logic.
     * </pre>
     *
     * <code>optional bool is_ping = 17 [default = false];</code>
     * @return The isPing.
     */
    boolean getIsPing();

    /**
     * <pre>
     * If true, then the callout model predicted that you will not bid
     * on this request. We send a sampled percentage of such requests so that we
     * can automatically update the model when bidding patterns change.
     * </pre>
     *
     * <code>optional bool is_predicted_to_be_ignored = 45 [default = false];</code>
     * @return Whether the isPredictedToBeIgnored field is set.
     */
    boolean hasIsPredictedToBeIgnored();
    /**
     * <pre>
     * If true, then the callout model predicted that you will not bid
     * on this request. We send a sampled percentage of such requests so that we
     * can automatically update the model when bidding patterns change.
     * </pre>
     *
     * <code>optional bool is_predicted_to_be_ignored = 45 [default = false];</code>
     * @return The isPredictedToBeIgnored.
     */
    boolean getIsPredictedToBeIgnored();

    /**
     * <code>optional .com.google.protos.adx.BidRequest.SupplyChain supply_chain = 69;</code>
     * @return Whether the supplyChain field is set.
     */
    boolean hasSupplyChain();
    /**
     * <code>optional .com.google.protos.adx.BidRequest.SupplyChain supply_chain = 69;</code>
     * @return The supplyChain.
     */
    com.google.protos.adx.NetworkBid.BidRequest.SupplyChain getSupplyChain();
    /**
     * <code>optional .com.google.protos.adx.BidRequest.SupplyChain supply_chain = 69;</code>
     */
    com.google.protos.adx.NetworkBid.BidRequest.SupplyChainOrBuilder getSupplyChainOrBuilder();

    /**
     * <code>optional .com.google.protos.adx.BidRequest.FrequencyCappingScope frequency_capping_scope = 70;</code>
     * @return Whether the frequencyCappingScope field is set.
     */
    boolean hasFrequencyCappingScope();
    /**
     * <code>optional .com.google.protos.adx.BidRequest.FrequencyCappingScope frequency_capping_scope = 70;</code>
     * @return The frequencyCappingScope.
     */
    com.google.protos.adx.NetworkBid.BidRequest.FrequencyCappingScope getFrequencyCappingScope();
  }
  /**
   * <pre>
   * This is the message that Google uses to request bids. A BidRequest
   * includes the ad slot from a single impression.
   * </pre>
   *
   * Protobuf type {@code com.google.protos.adx.BidRequest}
   */
  public static final class BidRequest extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:com.google.protos.adx.BidRequest)
      BidRequestOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use BidRequest.newBuilder() to construct.
    private BidRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private BidRequest() {
      id_ = com.google.protobuf.ByteString.EMPTY;
      ip_ = com.google.protobuf.ByteString.EMPTY;
      userDataTreatment_ = java.util.Collections.emptyList();
      googleUserId_ = "";
      hostedMatchData_ = com.google.protobuf.ByteString.EMPTY;
      sessionId_ = "";
      userAgent_ = "";
      publisherCountry_ = "";
      hostPublisherId_ = "";
      postalCode_ = "";
      postalCodePrefix_ = "";
      encryptedHyperlocalSet_ = com.google.protobuf.ByteString.EMPTY;
      userList_ = java.util.Collections.emptyList();
      publisherId_ = "";
      url_ = "";
      detectedLanguage_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      detectedVertical_ = java.util.Collections.emptyList();
      detectedContentLabel_ = emptyIntList();
      googleQueryId_ = "";
      auctionType_ = 2;
      keyValue_ = java.util.Collections.emptyList();
      publisherType_ = 0;
      pageVisibility_ = 0;
      adslot_ = java.util.Collections.emptyList();
      bidResponseFeedback_ = java.util.Collections.emptyList();
      frequencyCappingScope_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new BidRequest();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private BidRequest(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      int mutable_bitField1_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 18: {
              bitField0_ |= 0x00000001;
              id_ = input.readBytes();
              break;
            }
            case 34: {
              bitField0_ |= 0x00000002;
              ip_ = input.readBytes();
              break;
            }
            case 50: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000080;
              userAgent_ = bs;
              break;
            }
            case 90: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00400000;
              url_ = bs;
              break;
            }
            case 98: {
              com.google.protobuf.ByteString bs = input.readBytes();
              if (!((mutable_bitField0_ & 0x04000000) != 0)) {
                detectedLanguage_ = new com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x04000000;
              }
              detectedLanguage_.add(bs);
              break;
            }
            case 106: {
              if (!((mutable_bitField0_ & 0x08000000) != 0)) {
                detectedVertical_ = new java.util.ArrayList<com.google.protos.adx.NetworkBid.BidRequest.Vertical>();
                mutable_bitField0_ |= 0x08000000;
              }
              detectedVertical_.add(
                  input.readMessage(com.google.protos.adx.NetworkBid.BidRequest.Vertical.PARSER, extensionRegistry));
              break;
            }
            case 114: {
              if (!((mutable_bitField1_ & 0x00000040) != 0)) {
                adslot_ = new java.util.ArrayList<com.google.protos.adx.NetworkBid.BidRequest.AdSlot>();
                mutable_bitField1_ |= 0x00000040;
              }
              adslot_.add(
                  input.readMessage(com.google.protos.adx.NetworkBid.BidRequest.AdSlot.PARSER, extensionRegistry));
              break;
            }
            case 120: {
              bitField1_ |= 0x00000002;
              isTest_ = input.readBool();
              break;
            }
            case 136: {
              bitField1_ |= 0x00000004;
              isPing_ = input.readBool();
              break;
            }
            case 160: {
              bitField0_ |= 0x00000008;
              cookieVersion_ = input.readUInt32();
              break;
            }
            case 170: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000004;
              googleUserId_ = bs;
              break;
            }
            case 200: {
              bitField0_ |= 0x00040000;
              timezoneOffset_ = input.readInt32();
              break;
            }
            case 208: {
              if (!((mutable_bitField0_ & 0x10000000) != 0)) {
                detectedContentLabel_ = newIntList();
                mutable_bitField0_ |= 0x10000000;
              }
              detectedContentLabel_.addInt(input.readInt32());
              break;
            }
            case 210: {
              int length = input.readRawVarint32();
              int limit = input.pushLimit(length);
              if (!((mutable_bitField0_ & 0x10000000) != 0) && input.getBytesUntilLimit() > 0) {
                detectedContentLabel_ = newIntList();
                mutable_bitField0_ |= 0x10000000;
              }
              while (input.getBytesUntilLimit() > 0) {
                detectedContentLabel_.addInt(input.readInt32());
              }
              input.popLimit(limit);
              break;
            }
            case 226: {
              com.google.protos.adx.NetworkBid.BidRequest.Mobile.Builder subBuilder = null;
              if (((bitField0_ & 0x08000000) != 0)) {
                subBuilder = mobile_.toBuilder();
              }
              mobile_ = input.readMessage(com.google.protos.adx.NetworkBid.BidRequest.Mobile.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(mobile_);
                mobile_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x08000000;
              break;
            }
            case 234: {
              com.google.protos.adx.NetworkBid.BidRequest.Video.Builder subBuilder = null;
              if (((bitField0_ & 0x10000000) != 0)) {
                subBuilder = video_.toBuilder();
              }
              video_ = input.readMessage(com.google.protos.adx.NetworkBid.BidRequest.Video.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(video_);
                video_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x10000000;
              break;
            }
            case 248: {
              bitField0_ |= 0x00000010;
              cookieAgeSeconds_ = input.readInt32();
              break;
            }
            case 258: {
              if (!((mutable_bitField0_ & 0x00100000) != 0)) {
                userList_ = new java.util.ArrayList<com.google.protos.adx.NetworkBid.BidRequest.UserList>();
                mutable_bitField0_ |= 0x00100000;
              }
              userList_.add(
                  input.readMessage(com.google.protos.adx.NetworkBid.BidRequest.UserList.PARSER, extensionRegistry));
              break;
            }
            case 266: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00004000;
              postalCode_ = bs;
              break;
            }
            case 274: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00008000;
              postalCodePrefix_ = bs;
              break;
            }
            case 298: {
              bitField0_ |= 0x00000020;
              hostedMatchData_ = input.readBytes();
              break;
            }
            case 306: {
              if (!((mutable_bitField1_ & 0x00000001) != 0)) {
                keyValue_ = new java.util.ArrayList<com.google.protos.adx.NetworkBid.BidRequest.KeyValue>();
                mutable_bitField1_ |= 0x00000001;
              }
              keyValue_.add(
                  input.readMessage(com.google.protos.adx.NetworkBid.BidRequest.KeyValue.PARSER, extensionRegistry));
              break;
            }
            case 312: {
              bitField0_ |= 0x00001000;
              geoCriteriaId_ = input.readInt32();
              break;
            }
            case 322: {
              bitField0_ |= 0x00010000;
              encryptedHyperlocalSet_ = input.readBytes();
              break;
            }
            case 328: {
              bitField0_ |= 0x00100000;
              sellerNetworkId_ = input.readInt32();
              break;
            }
            case 337: {
              bitField0_ |= 0x20000000;
              publisherSettingsListId_ = input.readFixed64();
              break;
            }
            case 354: {
              if (!((mutable_bitField1_ & 0x00000080) != 0)) {
                bidResponseFeedback_ = new java.util.ArrayList<com.google.protos.adx.NetworkBid.BidRequest.BidResponseFeedback>();
                mutable_bitField1_ |= 0x00000080;
              }
              bidResponseFeedback_.add(
                  input.readMessage(com.google.protos.adx.NetworkBid.BidRequest.BidResponseFeedback.PARSER, extensionRegistry));
              break;
            }
            case 360: {
              bitField1_ |= 0x00000008;
              isPredictedToBeIgnored_ = input.readBool();
              break;
            }
            case 392: {
              int rawValue = input.readEnum();
              @SuppressWarnings("deprecation")
              com.google.protos.adx.NetworkBid.BidRequest.UserDataTreatment value = com.google.protos.adx.NetworkBid.BidRequest.UserDataTreatment.valueOf(rawValue);
              if (value == null) {
                unknownFields.mergeVarintField(49, rawValue);
              } else {
                if (!((mutable_bitField0_ & 0x00000004) != 0)) {
                  userDataTreatment_ = new java.util.ArrayList<java.lang.Integer>();
                  mutable_bitField0_ |= 0x00000004;
                }
                userDataTreatment_.add(rawValue);
              }
              break;
            }
            case 394: {
              int length = input.readRawVarint32();
              int oldLimit = input.pushLimit(length);
              while(input.getBytesUntilLimit() > 0) {
                int rawValue = input.readEnum();
                @SuppressWarnings("deprecation")
                com.google.protos.adx.NetworkBid.BidRequest.UserDataTreatment value = com.google.protos.adx.NetworkBid.BidRequest.UserDataTreatment.valueOf(rawValue);
                if (value == null) {
                  unknownFields.mergeVarintField(49, rawValue);
                } else {
                  if (!((mutable_bitField0_ & 0x00000004) != 0)) {
                    userDataTreatment_ = new java.util.ArrayList<java.lang.Integer>();
                    mutable_bitField0_ |= 0x00000004;
                  }
                  userDataTreatment_.add(rawValue);
                }
              }
              input.popLimit(oldLimit);
              break;
            }
            case 408: {
              int rawValue = input.readEnum();
                @SuppressWarnings("deprecation")
              com.google.protos.adx.NetworkBid.BidRequest.PublisherType value = com.google.protos.adx.NetworkBid.BidRequest.PublisherType.valueOf(rawValue);
              if (value == null) {
                unknownFields.mergeVarintField(51, rawValue);
              } else {
                bitField0_ |= 0x40000000;
                publisherType_ = rawValue;
              }
              break;
            }
            case 417: {
              bitField0_ |= 0x00200000;
              partnerId_ = input.readFixed64();
              break;
            }
            case 426: {
              com.google.protos.adx.NetworkBid.BidRequest.HyperlocalSet.Builder subBuilder = null;
              if (((bitField0_ & 0x00020000) != 0)) {
                subBuilder = hyperlocalSet_.toBuilder();
              }
              hyperlocalSet_ = input.readMessage(com.google.protos.adx.NetworkBid.BidRequest.HyperlocalSet.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(hyperlocalSet_);
                hyperlocalSet_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00020000;
              break;
            }
            case 434: {
              com.google.protos.adx.NetworkBid.BidRequest.Device.Builder subBuilder = null;
              if (((bitField0_ & 0x04000000) != 0)) {
                subBuilder = device_.toBuilder();
              }
              device_ = input.readMessage(com.google.protos.adx.NetworkBid.BidRequest.Device.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(device_);
                device_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x04000000;
              break;
            }
            case 442: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000400;
              publisherCountry_ = bs;
              break;
            }
            case 450: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00080000;
              publisherId_ = bs;
              break;
            }
            case 456: {
              bitField1_ |= 0x00000001;
              responseDeadlineMs_ = input.readInt32();
              break;
            }
            case 474: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x01000000;
              googleQueryId_ = bs;
              break;
            }
            case 480: {
              int rawValue = input.readEnum();
                @SuppressWarnings("deprecation")
              com.google.protos.adx.NetworkBid.BidRequest.AuctionType value = com.google.protos.adx.NetworkBid.BidRequest.AuctionType.valueOf(rawValue);
              if (value == null) {
                unknownFields.mergeVarintField(60, rawValue);
              } else {
                bitField0_ |= 0x02000000;
                auctionType_ = rawValue;
              }
              break;
            }
            case 498: {
              com.google.protos.adx.NetworkBid.BidRequest.Geo.Builder subBuilder = null;
              if (((bitField0_ & 0x00002000) != 0)) {
                subBuilder = geo_.toBuilder();
              }
              geo_ = input.readMessage(com.google.protos.adx.NetworkBid.BidRequest.Geo.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(geo_);
                geo_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00002000;
              break;
            }
            case 506: {
              com.google.protos.adx.NetworkBid.BidRequest.UserAgent.Builder subBuilder = null;
              if (((bitField0_ & 0x00000200) != 0)) {
                subBuilder = userAgentData_.toBuilder();
              }
              userAgentData_ = input.readMessage(com.google.protos.adx.NetworkBid.BidRequest.UserAgent.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(userAgentData_);
                userAgentData_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000200;
              break;
            }
            case 522: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000040;
              sessionId_ = bs;
              break;
            }
            case 528: {
              int rawValue = input.readEnum();
                @SuppressWarnings("deprecation")
              com.google.protos.adx.NetworkBid.BidRequest.VisibilityState value = com.google.protos.adx.NetworkBid.BidRequest.VisibilityState.valueOf(rawValue);
              if (value == null) {
                unknownFields.mergeVarintField(66, rawValue);
              } else {
                bitField0_ |= 0x80000000;
                pageVisibility_ = rawValue;
              }
              break;
            }
            case 536: {
              bitField0_ |= 0x00800000;
              isSemiTransparentRequest_ = input.readBool();
              break;
            }
            case 554: {
              com.google.protos.adx.NetworkBid.BidRequest.SupplyChain.Builder subBuilder = null;
              if (((bitField1_ & 0x00000010) != 0)) {
                subBuilder = supplyChain_.toBuilder();
              }
              supplyChain_ = input.readMessage(com.google.protos.adx.NetworkBid.BidRequest.SupplyChain.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(supplyChain_);
                supplyChain_ = subBuilder.buildPartial();
              }
              bitField1_ |= 0x00000010;
              break;
            }
            case 560: {
              int rawValue = input.readEnum();
                @SuppressWarnings("deprecation")
              com.google.protos.adx.NetworkBid.BidRequest.FrequencyCappingScope value = com.google.protos.adx.NetworkBid.BidRequest.FrequencyCappingScope.valueOf(rawValue);
              if (value == null) {
                unknownFields.mergeVarintField(70, rawValue);
              } else {
                bitField1_ |= 0x00000020;
                frequencyCappingScope_ = rawValue;
              }
              break;
            }
            case 570: {
              com.google.protos.adx.NetworkBid.BidRequest.PrivacyTreatments.Builder subBuilder = null;
              if (((bitField0_ & 0x00000100) != 0)) {
                subBuilder = privacyTreatments_.toBuilder();
              }
              privacyTreatments_ = input.readMessage(com.google.protos.adx.NetworkBid.BidRequest.PrivacyTreatments.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(privacyTreatments_);
                privacyTreatments_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000100;
              break;
            }
            case 586: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000800;
              hostPublisherId_ = bs;
              break;
            }
            default: {
              if (!parseUnknownField(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x04000000) != 0)) {
          detectedLanguage_ = detectedLanguage_.getUnmodifiableView();
        }
        if (((mutable_bitField0_ & 0x08000000) != 0)) {
          detectedVertical_ = java.util.Collections.unmodifiableList(detectedVertical_);
        }
        if (((mutable_bitField1_ & 0x00000040) != 0)) {
          adslot_ = java.util.Collections.unmodifiableList(adslot_);
        }
        if (((mutable_bitField0_ & 0x10000000) != 0)) {
          detectedContentLabel_.makeImmutable(); // C
        }
        if (((mutable_bitField0_ & 0x00100000) != 0)) {
          userList_ = java.util.Collections.unmodifiableList(userList_);
        }
        if (((mutable_bitField1_ & 0x00000001) != 0)) {
          keyValue_ = java.util.Collections.unmodifiableList(keyValue_);
        }
        if (((mutable_bitField1_ & 0x00000080) != 0)) {
          bidResponseFeedback_ = java.util.Collections.unmodifiableList(bidResponseFeedback_);
        }
        if (((mutable_bitField0_ & 0x00000004) != 0)) {
          userDataTreatment_ = java.util.Collections.unmodifiableList(userDataTreatment_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.protos.adx.NetworkBid.BidRequest.class, com.google.protos.adx.NetworkBid.BidRequest.Builder.class);
    }

    /**
     * <pre>
     * Reasons for special treatment of user data (google_user_id,
     * hosted_match_data, IDFA, etc).
     * </pre>
     *
     * Protobuf enum {@code com.google.protos.adx.BidRequest.UserDataTreatment}
     */
    public enum UserDataTreatment
        implements com.google.protobuf.ProtocolMessageEnum {
      /**
       * <pre>
       * The current request should be treated as child-directed for purposes of
       * the Children's Online Privacy Protection Act. See
       * https://support.google.com/admanager/answer/4442399 for more information.
       * </pre>
       *
       * <code>TAG_FOR_CHILD_DIRECTED_TREATMENT = 0;</code>
       */
      TAG_FOR_CHILD_DIRECTED_TREATMENT(0),
      ;

      /**
       * <pre>
       * The current request should be treated as child-directed for purposes of
       * the Children's Online Privacy Protection Act. See
       * https://support.google.com/admanager/answer/4442399 for more information.
       * </pre>
       *
       * <code>TAG_FOR_CHILD_DIRECTED_TREATMENT = 0;</code>
       */
      public static final int TAG_FOR_CHILD_DIRECTED_TREATMENT_VALUE = 0;


      public final int getNumber() {
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static UserDataTreatment valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static UserDataTreatment forNumber(int value) {
        switch (value) {
          case 0: return TAG_FOR_CHILD_DIRECTED_TREATMENT;
          default: return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<UserDataTreatment>
          internalGetValueMap() {
        return internalValueMap;
      }
      private static final com.google.protobuf.Internal.EnumLiteMap<
          UserDataTreatment> internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<UserDataTreatment>() {
              public UserDataTreatment findValueByNumber(int number) {
                return UserDataTreatment.forNumber(number);
              }
            };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor
          getValueDescriptor() {
        return getDescriptor().getValues().get(ordinal());
      }
      public final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptorForType() {
        return getDescriptor();
      }
      public static final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptor() {
        return com.google.protos.adx.NetworkBid.BidRequest.getDescriptor().getEnumTypes().get(0);
      }

      private static final UserDataTreatment[] VALUES = values();

      public static UserDataTreatment valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException(
            "EnumValueDescriptor is not for this type.");
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private UserDataTreatment(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:com.google.protos.adx.BidRequest.UserDataTreatment)
    }

    /**
     * <pre>
     * The type of auction that will be run for this query.
     * </pre>
     *
     * Protobuf enum {@code com.google.protos.adx.BidRequest.AuctionType}
     */
    public enum AuctionType
        implements com.google.protobuf.ProtocolMessageEnum {
      /**
       * <code>UNKNOWN_AUCTION_TYPE = 0;</code>
       */
      UNKNOWN_AUCTION_TYPE(0),
      /**
       * <code>FIRST_PRICE = 1;</code>
       */
      FIRST_PRICE(1),
      /**
       * <code>SECOND_PRICE = 2;</code>
       */
      SECOND_PRICE(2),
      /**
       * <code>FIXED_PRICE = 3;</code>
       */
      FIXED_PRICE(3),
      ;

      /**
       * <code>UNKNOWN_AUCTION_TYPE = 0;</code>
       */
      public static final int UNKNOWN_AUCTION_TYPE_VALUE = 0;
      /**
       * <code>FIRST_PRICE = 1;</code>
       */
      public static final int FIRST_PRICE_VALUE = 1;
      /**
       * <code>SECOND_PRICE = 2;</code>
       */
      public static final int SECOND_PRICE_VALUE = 2;
      /**
       * <code>FIXED_PRICE = 3;</code>
       */
      public static final int FIXED_PRICE_VALUE = 3;


      public final int getNumber() {
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static AuctionType valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static AuctionType forNumber(int value) {
        switch (value) {
          case 0: return UNKNOWN_AUCTION_TYPE;
          case 1: return FIRST_PRICE;
          case 2: return SECOND_PRICE;
          case 3: return FIXED_PRICE;
          default: return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<AuctionType>
          internalGetValueMap() {
        return internalValueMap;
      }
      private static final com.google.protobuf.Internal.EnumLiteMap<
          AuctionType> internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<AuctionType>() {
              public AuctionType findValueByNumber(int number) {
                return AuctionType.forNumber(number);
              }
            };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor
          getValueDescriptor() {
        return getDescriptor().getValues().get(ordinal());
      }
      public final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptorForType() {
        return getDescriptor();
      }
      public static final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptor() {
        return com.google.protos.adx.NetworkBid.BidRequest.getDescriptor().getEnumTypes().get(1);
      }

      private static final AuctionType[] VALUES = values();

      public static AuctionType valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException(
            "EnumValueDescriptor is not for this type.");
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private AuctionType(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:com.google.protos.adx.BidRequest.AuctionType)
    }

    /**
     * <pre>
     * Publisher type of the inventory where the ad will be shown. For a given
     * request, publisher inventory can be either owned and operated (O&amp;O),
     * represented by the publisher, or of unknown status.
     * </pre>
     *
     * Protobuf enum {@code com.google.protos.adx.BidRequest.PublisherType}
     */
    public enum PublisherType
        implements com.google.protobuf.ProtocolMessageEnum {
      /**
       * <code>UNKNOWN_PUBLISHER_TYPE = 0;</code>
       */
      UNKNOWN_PUBLISHER_TYPE(0),
      /**
       * <code>PUBLISHER_OWNED_AND_OPERATED = 1;</code>
       */
      PUBLISHER_OWNED_AND_OPERATED(1),
      /**
       * <code>PUBLISHER_REPRESENTED = 2;</code>
       */
      PUBLISHER_REPRESENTED(2),
      /**
       * <code>DEPRECATED_GOOGLE_REPRESENTED = 3 [deprecated = true];</code>
       */
      @java.lang.Deprecated
      DEPRECATED_GOOGLE_REPRESENTED(3),
      ;

      /**
       * <code>UNKNOWN_PUBLISHER_TYPE = 0;</code>
       */
      public static final int UNKNOWN_PUBLISHER_TYPE_VALUE = 0;
      /**
       * <code>PUBLISHER_OWNED_AND_OPERATED = 1;</code>
       */
      public static final int PUBLISHER_OWNED_AND_OPERATED_VALUE = 1;
      /**
       * <code>PUBLISHER_REPRESENTED = 2;</code>
       */
      public static final int PUBLISHER_REPRESENTED_VALUE = 2;
      /**
       * <code>DEPRECATED_GOOGLE_REPRESENTED = 3 [deprecated = true];</code>
       */
      @java.lang.Deprecated public static final int DEPRECATED_GOOGLE_REPRESENTED_VALUE = 3;


      public final int getNumber() {
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static PublisherType valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static PublisherType forNumber(int value) {
        switch (value) {
          case 0: return UNKNOWN_PUBLISHER_TYPE;
          case 1: return PUBLISHER_OWNED_AND_OPERATED;
          case 2: return PUBLISHER_REPRESENTED;
          case 3: return DEPRECATED_GOOGLE_REPRESENTED;
          default: return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<PublisherType>
          internalGetValueMap() {
        return internalValueMap;
      }
      private static final com.google.protobuf.Internal.EnumLiteMap<
          PublisherType> internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<PublisherType>() {
              public PublisherType findValueByNumber(int number) {
                return PublisherType.forNumber(number);
              }
            };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor
          getValueDescriptor() {
        return getDescriptor().getValues().get(ordinal());
      }
      public final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptorForType() {
        return getDescriptor();
      }
      public static final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptor() {
        return com.google.protos.adx.NetworkBid.BidRequest.getDescriptor().getEnumTypes().get(2);
      }

      private static final PublisherType[] VALUES = values();

      public static PublisherType valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException(
            "EnumValueDescriptor is not for this type.");
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private PublisherType(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:com.google.protos.adx.BidRequest.PublisherType)
    }

    /**
     * Protobuf enum {@code com.google.protos.adx.BidRequest.VisibilityState}
     */
    public enum VisibilityState
        implements com.google.protobuf.ProtocolMessageEnum {
      /**
       * <code>VISIBILITY_STATE_UNKNOWN = 0;</code>
       */
      VISIBILITY_STATE_UNKNOWN(0),
      /**
       * <pre>
       * The page is at least partially visible. For example, in the foreground
       * tab of a non-minimized window.
       * </pre>
       *
       * <code>VISIBILITY_STATE_VISIBLE = 1;</code>
       */
      VISIBILITY_STATE_VISIBLE(1),
      /**
       * <pre>
       * The page is not visible to users. For example, when the page is in a
       * background browser tab, or in a minimized window.
       * </pre>
       *
       * <code>VISIBILITY_STATE_HIDDEN = 2;</code>
       */
      VISIBILITY_STATE_HIDDEN(2),
      ;

      /**
       * <code>VISIBILITY_STATE_UNKNOWN = 0;</code>
       */
      public static final int VISIBILITY_STATE_UNKNOWN_VALUE = 0;
      /**
       * <pre>
       * The page is at least partially visible. For example, in the foreground
       * tab of a non-minimized window.
       * </pre>
       *
       * <code>VISIBILITY_STATE_VISIBLE = 1;</code>
       */
      public static final int VISIBILITY_STATE_VISIBLE_VALUE = 1;
      /**
       * <pre>
       * The page is not visible to users. For example, when the page is in a
       * background browser tab, or in a minimized window.
       * </pre>
       *
       * <code>VISIBILITY_STATE_HIDDEN = 2;</code>
       */
      public static final int VISIBILITY_STATE_HIDDEN_VALUE = 2;


      public final int getNumber() {
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static VisibilityState valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static VisibilityState forNumber(int value) {
        switch (value) {
          case 0: return VISIBILITY_STATE_UNKNOWN;
          case 1: return VISIBILITY_STATE_VISIBLE;
          case 2: return VISIBILITY_STATE_HIDDEN;
          default: return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<VisibilityState>
          internalGetValueMap() {
        return internalValueMap;
      }
      private static final com.google.protobuf.Internal.EnumLiteMap<
          VisibilityState> internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<VisibilityState>() {
              public VisibilityState findValueByNumber(int number) {
                return VisibilityState.forNumber(number);
              }
            };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor
          getValueDescriptor() {
        return getDescriptor().getValues().get(ordinal());
      }
      public final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptorForType() {
        return getDescriptor();
      }
      public static final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptor() {
        return com.google.protos.adx.NetworkBid.BidRequest.getDescriptor().getEnumTypes().get(3);
      }

      private static final VisibilityState[] VALUES = values();

      public static VisibilityState valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException(
            "EnumValueDescriptor is not for this type.");
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private VisibilityState(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:com.google.protos.adx.BidRequest.VisibilityState)
    }

    /**
     * <pre>
     * Experimental feature; may be subject to change. See
     * https://support.google.com/authorizedbuyers/answer/10890762 for more
     * information.
     * Describes the scope of frequency cap enforcement available for this
     * request. Frequency caps to be enforced for a bid can be specified in the
     * BidResponse.ad.adslot.frequency_cap field.
     * </pre>
     *
     * Protobuf enum {@code com.google.protos.adx.BidRequest.FrequencyCappingScope}
     */
    public enum FrequencyCappingScope
        implements com.google.protobuf.ProtocolMessageEnum {
      /**
       * <pre>
       * Default value which should not be used, or which can indicate that
       * frequency cap scope could not be reliably determined.
       * </pre>
       *
       * <code>FREQUENCY_CAPPING_SCOPE_UNKNOWN = 0;</code>
       */
      FREQUENCY_CAPPING_SCOPE_UNKNOWN(0),
      /**
       * <pre>
       * Frequency capping based on bid response specifications is not available
       * for this request. A frequency-capped bid for a bid request with no
       * frequency cap availability will be filtered prior to the auction.
       * </pre>
       *
       * <code>FREQUENCY_CAPPING_SCOPE_NONE = 1;</code>
       */
      FREQUENCY_CAPPING_SCOPE_NONE(1),
      /**
       * <pre>
       * Frequency capping enforcement is available across multiple sites within
       * the same browser.
       * </pre>
       *
       * <code>FREQUENCY_CAPPING_SCOPE_BROWSER = 2;</code>
       */
      FREQUENCY_CAPPING_SCOPE_BROWSER(2),
      /**
       * <pre>
       * Frequency capping enforcement is available across multiple apps on the
       * device, excluding browsers.
       * </pre>
       *
       * <code>FREQUENCY_CAPPING_SCOPE_DEVICE = 3;</code>
       */
      FREQUENCY_CAPPING_SCOPE_DEVICE(3),
      /**
       * <pre>
       * Frequency capping enforcement is available within a single app.
       * </pre>
       *
       * <code>FREQUENCY_CAPPING_SCOPE_APP = 4;</code>
       */
      FREQUENCY_CAPPING_SCOPE_APP(4),
      /**
       * <pre>
       * Frequency capping enforcement is available within a single site.
       * </pre>
       *
       * <code>FREQUENCY_CAPPING_SCOPE_SITE = 5;</code>
       */
      FREQUENCY_CAPPING_SCOPE_SITE(5),
      ;

      /**
       * <pre>
       * Default value which should not be used, or which can indicate that
       * frequency cap scope could not be reliably determined.
       * </pre>
       *
       * <code>FREQUENCY_CAPPING_SCOPE_UNKNOWN = 0;</code>
       */
      public static final int FREQUENCY_CAPPING_SCOPE_UNKNOWN_VALUE = 0;
      /**
       * <pre>
       * Frequency capping based on bid response specifications is not available
       * for this request. A frequency-capped bid for a bid request with no
       * frequency cap availability will be filtered prior to the auction.
       * </pre>
       *
       * <code>FREQUENCY_CAPPING_SCOPE_NONE = 1;</code>
       */
      public static final int FREQUENCY_CAPPING_SCOPE_NONE_VALUE = 1;
      /**
       * <pre>
       * Frequency capping enforcement is available across multiple sites within
       * the same browser.
       * </pre>
       *
       * <code>FREQUENCY_CAPPING_SCOPE_BROWSER = 2;</code>
       */
      public static final int FREQUENCY_CAPPING_SCOPE_BROWSER_VALUE = 2;
      /**
       * <pre>
       * Frequency capping enforcement is available across multiple apps on the
       * device, excluding browsers.
       * </pre>
       *
       * <code>FREQUENCY_CAPPING_SCOPE_DEVICE = 3;</code>
       */
      public static final int FREQUENCY_CAPPING_SCOPE_DEVICE_VALUE = 3;
      /**
       * <pre>
       * Frequency capping enforcement is available within a single app.
       * </pre>
       *
       * <code>FREQUENCY_CAPPING_SCOPE_APP = 4;</code>
       */
      public static final int FREQUENCY_CAPPING_SCOPE_APP_VALUE = 4;
      /**
       * <pre>
       * Frequency capping enforcement is available within a single site.
       * </pre>
       *
       * <code>FREQUENCY_CAPPING_SCOPE_SITE = 5;</code>
       */
      public static final int FREQUENCY_CAPPING_SCOPE_SITE_VALUE = 5;


      public final int getNumber() {
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static FrequencyCappingScope valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static FrequencyCappingScope forNumber(int value) {
        switch (value) {
          case 0: return FREQUENCY_CAPPING_SCOPE_UNKNOWN;
          case 1: return FREQUENCY_CAPPING_SCOPE_NONE;
          case 2: return FREQUENCY_CAPPING_SCOPE_BROWSER;
          case 3: return FREQUENCY_CAPPING_SCOPE_DEVICE;
          case 4: return FREQUENCY_CAPPING_SCOPE_APP;
          case 5: return FREQUENCY_CAPPING_SCOPE_SITE;
          default: return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<FrequencyCappingScope>
          internalGetValueMap() {
        return internalValueMap;
      }
      private static final com.google.protobuf.Internal.EnumLiteMap<
          FrequencyCappingScope> internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<FrequencyCappingScope>() {
              public FrequencyCappingScope findValueByNumber(int number) {
                return FrequencyCappingScope.forNumber(number);
              }
            };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor
          getValueDescriptor() {
        return getDescriptor().getValues().get(ordinal());
      }
      public final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptorForType() {
        return getDescriptor();
      }
      public static final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptor() {
        return com.google.protos.adx.NetworkBid.BidRequest.getDescriptor().getEnumTypes().get(4);
      }

      private static final FrequencyCappingScope[] VALUES = values();

      public static FrequencyCappingScope valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException(
            "EnumValueDescriptor is not for this type.");
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private FrequencyCappingScope(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:com.google.protos.adx.BidRequest.FrequencyCappingScope)
    }

    public interface PrivacyTreatmentsOrBuilder extends
        // @@protoc_insertion_point(interface_extends:com.google.protos.adx.BidRequest.PrivacyTreatments)
        com.google.protobuf.MessageOrBuilder {

      /**
       * <code>repeated .com.google.protos.adx.BidRequest.PrivacyTreatments.NonPersonalizedAdsReason non_personalized_ads_reason = 6 [packed = true];</code>
       * @return A list containing the nonPersonalizedAdsReason.
       */
      java.util.List<com.google.protos.adx.NetworkBid.BidRequest.PrivacyTreatments.NonPersonalizedAdsReason> getNonPersonalizedAdsReasonList();
      /**
       * <code>repeated .com.google.protos.adx.BidRequest.PrivacyTreatments.NonPersonalizedAdsReason non_personalized_ads_reason = 6 [packed = true];</code>
       * @return The count of nonPersonalizedAdsReason.
       */
      int getNonPersonalizedAdsReasonCount();
      /**
       * <code>repeated .com.google.protos.adx.BidRequest.PrivacyTreatments.NonPersonalizedAdsReason non_personalized_ads_reason = 6 [packed = true];</code>
       * @param index The index of the element to return.
       * @return The nonPersonalizedAdsReason at the given index.
       */
      com.google.protos.adx.NetworkBid.BidRequest.PrivacyTreatments.NonPersonalizedAdsReason getNonPersonalizedAdsReason(int index);

      /**
       * <pre>
       * True if publisher grants the permission to allow the bidder to use
       * user visitation information from the publisher's site to create
       * interest categories that can be used to serve ads based on those
       * categories. To use this data to create interest categories, a bidder must
       * also win a given impression.
       * https://support.google.com/admanager/answer/11956152
       * </pre>
       *
       * <code>optional bool allow_user_data_collection = 7;</code>
       * @return Whether the allowUserDataCollection field is set.
       */
      boolean hasAllowUserDataCollection();
      /**
       * <pre>
       * True if publisher grants the permission to allow the bidder to use
       * user visitation information from the publisher's site to create
       * interest categories that can be used to serve ads based on those
       * categories. To use this data to create interest categories, a bidder must
       * also win a given impression.
       * https://support.google.com/admanager/answer/11956152
       * </pre>
       *
       * <code>optional bool allow_user_data_collection = 7;</code>
       * @return The allowUserDataCollection.
       */
      boolean getAllowUserDataCollection();
    }
    /**
     * <pre>
     * Information about privacy treatments that apply to an ad opportunity
     * offered via this request.
     * </pre>
     *
     * Protobuf type {@code com.google.protos.adx.BidRequest.PrivacyTreatments}
     */
    public static final class PrivacyTreatments extends
        com.google.protobuf.GeneratedMessageV3 implements
        // @@protoc_insertion_point(message_implements:com.google.protos.adx.BidRequest.PrivacyTreatments)
        PrivacyTreatmentsOrBuilder {
    private static final long serialVersionUID = 0L;
      // Use PrivacyTreatments.newBuilder() to construct.
      private PrivacyTreatments(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }
      private PrivacyTreatments() {
        nonPersonalizedAdsReason_ = java.util.Collections.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(
          UnusedPrivateParameter unused) {
        return new PrivacyTreatments();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet
      getUnknownFields() {
        return this.unknownFields;
      }
      private PrivacyTreatments(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        int mutable_bitField0_ = 0;
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 48: {
                int rawValue = input.readEnum();
                @SuppressWarnings("deprecation")
                com.google.protos.adx.NetworkBid.BidRequest.PrivacyTreatments.NonPersonalizedAdsReason value = com.google.protos.adx.NetworkBid.BidRequest.PrivacyTreatments.NonPersonalizedAdsReason.valueOf(rawValue);
                if (value == null) {
                  unknownFields.mergeVarintField(6, rawValue);
                } else {
                  if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                    nonPersonalizedAdsReason_ = new java.util.ArrayList<java.lang.Integer>();
                    mutable_bitField0_ |= 0x00000001;
                  }
                  nonPersonalizedAdsReason_.add(rawValue);
                }
                break;
              }
              case 50: {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while(input.getBytesUntilLimit() > 0) {
                  int rawValue = input.readEnum();
                  @SuppressWarnings("deprecation")
                  com.google.protos.adx.NetworkBid.BidRequest.PrivacyTreatments.NonPersonalizedAdsReason value = com.google.protos.adx.NetworkBid.BidRequest.PrivacyTreatments.NonPersonalizedAdsReason.valueOf(rawValue);
                  if (value == null) {
                    unknownFields.mergeVarintField(6, rawValue);
                  } else {
                    if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                      nonPersonalizedAdsReason_ = new java.util.ArrayList<java.lang.Integer>();
                      mutable_bitField0_ |= 0x00000001;
                    }
                    nonPersonalizedAdsReason_.add(rawValue);
                  }
                }
                input.popLimit(oldLimit);
                break;
              }
              case 56: {
                bitField0_ |= 0x00000001;
                allowUserDataCollection_ = input.readBool();
                break;
              }
              default: {
                if (!parseUnknownField(
                    input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(
              e).setUnfinishedMessage(this);
        } finally {
          if (((mutable_bitField0_ & 0x00000001) != 0)) {
            nonPersonalizedAdsReason_ = java.util.Collections.unmodifiableList(nonPersonalizedAdsReason_);
          }
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_PrivacyTreatments_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_PrivacyTreatments_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.protos.adx.NetworkBid.BidRequest.PrivacyTreatments.class, com.google.protos.adx.NetworkBid.BidRequest.PrivacyTreatments.Builder.class);
      }

      /**
       * <pre>
       * Specifies the reasons that ads returned in response to this request
       * should not be personalized.
       * </pre>
       *
       * Protobuf enum {@code com.google.protos.adx.BidRequest.PrivacyTreatments.NonPersonalizedAdsReason}
       */
      public enum NonPersonalizedAdsReason
          implements com.google.protobuf.ProtocolMessageEnum {
        /**
         * <code>UNKNOWN = 0;</code>
         */
        UNKNOWN(0),
        /**
         * <pre>
         * The publisher has declared that this request should serve
         * non-personalized ads independent of other signals.
         * https://support.google.com/admanager/answer/9005435#npa
         * </pre>
         *
         * <code>PUBLISHER_DECLARED_NPA = 1;</code>
         */
        PUBLISHER_DECLARED_NPA(1),
        /**
         * <pre>
         * The publisher has requested restricted data processing for this
         * request. https://support.google.com/authorizedbuyers/answer/11121285
         * </pre>
         *
         * <code>RESTRICT_DATA_PROCESSING = 2;</code>
         */
        RESTRICT_DATA_PROCESSING(2),
        /**
         * <pre>
         * The user has opted out of ads personalization.
         * </pre>
         *
         * <code>USER_OPT_OUT = 3;</code>
         */
        USER_OPT_OUT(3),
        ;

        /**
         * <code>UNKNOWN = 0;</code>
         */
        public static final int UNKNOWN_VALUE = 0;
        /**
         * <pre>
         * The publisher has declared that this request should serve
         * non-personalized ads independent of other signals.
         * https://support.google.com/admanager/answer/9005435#npa
         * </pre>
         *
         * <code>PUBLISHER_DECLARED_NPA = 1;</code>
         */
        public static final int PUBLISHER_DECLARED_NPA_VALUE = 1;
        /**
         * <pre>
         * The publisher has requested restricted data processing for this
         * request. https://support.google.com/authorizedbuyers/answer/11121285
         * </pre>
         *
         * <code>RESTRICT_DATA_PROCESSING = 2;</code>
         */
        public static final int RESTRICT_DATA_PROCESSING_VALUE = 2;
        /**
         * <pre>
         * The user has opted out of ads personalization.
         * </pre>
         *
         * <code>USER_OPT_OUT = 3;</code>
         */
        public static final int USER_OPT_OUT_VALUE = 3;


        public final int getNumber() {
          return value;
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static NonPersonalizedAdsReason valueOf(int value) {
          return forNumber(value);
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         */
        public static NonPersonalizedAdsReason forNumber(int value) {
          switch (value) {
            case 0: return UNKNOWN;
            case 1: return PUBLISHER_DECLARED_NPA;
            case 2: return RESTRICT_DATA_PROCESSING;
            case 3: return USER_OPT_OUT;
            default: return null;
          }
        }

        public static com.google.protobuf.Internal.EnumLiteMap<NonPersonalizedAdsReason>
            internalGetValueMap() {
          return internalValueMap;
        }
        private static final com.google.protobuf.Internal.EnumLiteMap<
            NonPersonalizedAdsReason> internalValueMap =
              new com.google.protobuf.Internal.EnumLiteMap<NonPersonalizedAdsReason>() {
                public NonPersonalizedAdsReason findValueByNumber(int number) {
                  return NonPersonalizedAdsReason.forNumber(number);
                }
              };

        public final com.google.protobuf.Descriptors.EnumValueDescriptor
            getValueDescriptor() {
          return getDescriptor().getValues().get(ordinal());
        }
        public final com.google.protobuf.Descriptors.EnumDescriptor
            getDescriptorForType() {
          return getDescriptor();
        }
        public static final com.google.protobuf.Descriptors.EnumDescriptor
            getDescriptor() {
          return com.google.protos.adx.NetworkBid.BidRequest.PrivacyTreatments.getDescriptor().getEnumTypes().get(0);
        }

        private static final NonPersonalizedAdsReason[] VALUES = values();

        public static NonPersonalizedAdsReason valueOf(
            com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
          if (desc.getType() != getDescriptor()) {
            throw new java.lang.IllegalArgumentException(
              "EnumValueDescriptor is not for this type.");
          }
          return VALUES[desc.getIndex()];
        }

        private final int value;

        private NonPersonalizedAdsReason(int value) {
          this.value = value;
        }

        // @@protoc_insertion_point(enum_scope:com.google.protos.adx.BidRequest.PrivacyTreatments.NonPersonalizedAdsReason)
      }

      private int bitField0_;
      public static final int NON_PERSONALIZED_ADS_REASON_FIELD_NUMBER = 6;
      private java.util.List<java.lang.Integer> nonPersonalizedAdsReason_;
      private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.protos.adx.NetworkBid.BidRequest.PrivacyTreatments.NonPersonalizedAdsReason> nonPersonalizedAdsReason_converter_ =
              new com.google.protobuf.Internal.ListAdapter.Converter<
                  java.lang.Integer, com.google.protos.adx.NetworkBid.BidRequest.PrivacyTreatments.NonPersonalizedAdsReason>() {
                public com.google.protos.adx.NetworkBid.BidRequest.PrivacyTreatments.NonPersonalizedAdsReason convert(java.lang.Integer from) {
                  @SuppressWarnings("deprecation")
                  com.google.protos.adx.NetworkBid.BidRequest.PrivacyTreatments.NonPersonalizedAdsReason result = com.google.protos.adx.NetworkBid.BidRequest.PrivacyTreatments.NonPersonalizedAdsReason.valueOf(from);
                  return result == null ? com.google.protos.adx.NetworkBid.BidRequest.PrivacyTreatments.NonPersonalizedAdsReason.UNKNOWN : result;
                }
              };
      /**
       * <code>repeated .com.google.protos.adx.BidRequest.PrivacyTreatments.NonPersonalizedAdsReason non_personalized_ads_reason = 6 [packed = true];</code>
       * @return A list containing the nonPersonalizedAdsReason.
       */
      @java.lang.Override
      public java.util.List<com.google.protos.adx.NetworkBid.BidRequest.PrivacyTreatments.NonPersonalizedAdsReason> getNonPersonalizedAdsReasonList() {
        return new com.google.protobuf.Internal.ListAdapter<
            java.lang.Integer, com.google.protos.adx.NetworkBid.BidRequest.PrivacyTreatments.NonPersonalizedAdsReason>(nonPersonalizedAdsReason_, nonPersonalizedAdsReason_converter_);
      }
      /**
       * <code>repeated .com.google.protos.adx.BidRequest.PrivacyTreatments.NonPersonalizedAdsReason non_personalized_ads_reason = 6 [packed = true];</code>
       * @return The count of nonPersonalizedAdsReason.
       */
      @java.lang.Override
      public int getNonPersonalizedAdsReasonCount() {
        return nonPersonalizedAdsReason_.size();
      }
      /**
       * <code>repeated .com.google.protos.adx.BidRequest.PrivacyTreatments.NonPersonalizedAdsReason non_personalized_ads_reason = 6 [packed = true];</code>
       * @param index The index of the element to return.
       * @return The nonPersonalizedAdsReason at the given index.
       */
      @java.lang.Override
      public com.google.protos.adx.NetworkBid.BidRequest.PrivacyTreatments.NonPersonalizedAdsReason getNonPersonalizedAdsReason(int index) {
        return nonPersonalizedAdsReason_converter_.convert(nonPersonalizedAdsReason_.get(index));
      }
      private int nonPersonalizedAdsReasonMemoizedSerializedSize;

      public static final int ALLOW_USER_DATA_COLLECTION_FIELD_NUMBER = 7;
      private boolean allowUserDataCollection_;
      /**
       * <pre>
       * True if publisher grants the permission to allow the bidder to use
       * user visitation information from the publisher's site to create
       * interest categories that can be used to serve ads based on those
       * categories. To use this data to create interest categories, a bidder must
       * also win a given impression.
       * https://support.google.com/admanager/answer/11956152
       * </pre>
       *
       * <code>optional bool allow_user_data_collection = 7;</code>
       * @return Whether the allowUserDataCollection field is set.
       */
      @java.lang.Override
      public boolean hasAllowUserDataCollection() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <pre>
       * True if publisher grants the permission to allow the bidder to use
       * user visitation information from the publisher's site to create
       * interest categories that can be used to serve ads based on those
       * categories. To use this data to create interest categories, a bidder must
       * also win a given impression.
       * https://support.google.com/admanager/answer/11956152
       * </pre>
       *
       * <code>optional bool allow_user_data_collection = 7;</code>
       * @return The allowUserDataCollection.
       */
      @java.lang.Override
      public boolean getAllowUserDataCollection() {
        return allowUserDataCollection_;
      }

      private byte memoizedIsInitialized = -1;
      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output)
                          throws java.io.IOException {
        getSerializedSize();
        if (getNonPersonalizedAdsReasonList().size() > 0) {
          output.writeUInt32NoTag(50);
          output.writeUInt32NoTag(nonPersonalizedAdsReasonMemoizedSerializedSize);
        }
        for (int i = 0; i < nonPersonalizedAdsReason_.size(); i++) {
          output.writeEnumNoTag(nonPersonalizedAdsReason_.get(i));
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeBool(7, allowUserDataCollection_);
        }
        unknownFields.writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        {
          int dataSize = 0;
          for (int i = 0; i < nonPersonalizedAdsReason_.size(); i++) {
            dataSize += com.google.protobuf.CodedOutputStream
              .computeEnumSizeNoTag(nonPersonalizedAdsReason_.get(i));
          }
          size += dataSize;
          if (!getNonPersonalizedAdsReasonList().isEmpty()) {  size += 1;
            size += com.google.protobuf.CodedOutputStream
              .computeUInt32SizeNoTag(dataSize);
          }nonPersonalizedAdsReasonMemoizedSerializedSize = dataSize;
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.CodedOutputStream
            .computeBoolSize(7, allowUserDataCollection_);
        }
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
         return true;
        }
        if (!(obj instanceof com.google.protos.adx.NetworkBid.BidRequest.PrivacyTreatments)) {
          return super.equals(obj);
        }
        com.google.protos.adx.NetworkBid.BidRequest.PrivacyTreatments other = (com.google.protos.adx.NetworkBid.BidRequest.PrivacyTreatments) obj;

        if (!nonPersonalizedAdsReason_.equals(other.nonPersonalizedAdsReason_)) return false;
        if (hasAllowUserDataCollection() != other.hasAllowUserDataCollection()) return false;
        if (hasAllowUserDataCollection()) {
          if (getAllowUserDataCollection()
              != other.getAllowUserDataCollection()) return false;
        }
        if (!unknownFields.equals(other.unknownFields)) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (getNonPersonalizedAdsReasonCount() > 0) {
          hash = (37 * hash) + NON_PERSONALIZED_ADS_REASON_FIELD_NUMBER;
          hash = (53 * hash) + nonPersonalizedAdsReason_.hashCode();
        }
        if (hasAllowUserDataCollection()) {
          hash = (37 * hash) + ALLOW_USER_DATA_COLLECTION_FIELD_NUMBER;
          hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
              getAllowUserDataCollection());
        }
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.protos.adx.NetworkBid.BidRequest.PrivacyTreatments parseFrom(
          java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.PrivacyTreatments parseFrom(
          java.nio.ByteBuffer data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.PrivacyTreatments parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.PrivacyTreatments parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.PrivacyTreatments parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.PrivacyTreatments parseFrom(
          byte[] data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.PrivacyTreatments parseFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.PrivacyTreatments parseFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.PrivacyTreatments parseDelimitedFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.PrivacyTreatments parseDelimitedFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.PrivacyTreatments parseFrom(
          com.google.protobuf.CodedInputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.PrivacyTreatments parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() { return newBuilder(); }
      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }
      public static Builder newBuilder(com.google.protos.adx.NetworkBid.BidRequest.PrivacyTreatments prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }
      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE
            ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * <pre>
       * Information about privacy treatments that apply to an ad opportunity
       * offered via this request.
       * </pre>
       *
       * Protobuf type {@code com.google.protos.adx.BidRequest.PrivacyTreatments}
       */
      public static final class Builder extends
          com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
          // @@protoc_insertion_point(builder_implements:com.google.protos.adx.BidRequest.PrivacyTreatments)
          com.google.protos.adx.NetworkBid.BidRequest.PrivacyTreatmentsOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
          return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_PrivacyTreatments_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_PrivacyTreatments_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.protos.adx.NetworkBid.BidRequest.PrivacyTreatments.class, com.google.protos.adx.NetworkBid.BidRequest.PrivacyTreatments.Builder.class);
        }

        // Construct using com.google.protos.adx.NetworkBid.BidRequest.PrivacyTreatments.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }
        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3
                  .alwaysUseFieldBuilders) {
          }
        }
        @java.lang.Override
        public Builder clear() {
          super.clear();
          nonPersonalizedAdsReason_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          allowUserDataCollection_ = false;
          bitField0_ = (bitField0_ & ~0x00000002);
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
          return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_PrivacyTreatments_descriptor;
        }

        @java.lang.Override
        public com.google.protos.adx.NetworkBid.BidRequest.PrivacyTreatments getDefaultInstanceForType() {
          return com.google.protos.adx.NetworkBid.BidRequest.PrivacyTreatments.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.protos.adx.NetworkBid.BidRequest.PrivacyTreatments build() {
          com.google.protos.adx.NetworkBid.BidRequest.PrivacyTreatments result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.protos.adx.NetworkBid.BidRequest.PrivacyTreatments buildPartial() {
          com.google.protos.adx.NetworkBid.BidRequest.PrivacyTreatments result = new com.google.protos.adx.NetworkBid.BidRequest.PrivacyTreatments(this);
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((bitField0_ & 0x00000001) != 0)) {
            nonPersonalizedAdsReason_ = java.util.Collections.unmodifiableList(nonPersonalizedAdsReason_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.nonPersonalizedAdsReason_ = nonPersonalizedAdsReason_;
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.allowUserDataCollection_ = allowUserDataCollection_;
            to_bitField0_ |= 0x00000001;
          }
          result.bitField0_ = to_bitField0_;
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }
        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.setField(field, value);
        }
        @java.lang.Override
        public Builder clearField(
            com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }
        @java.lang.Override
        public Builder clearOneof(
            com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }
        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index, java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }
        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }
        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.protos.adx.NetworkBid.BidRequest.PrivacyTreatments) {
            return mergeFrom((com.google.protos.adx.NetworkBid.BidRequest.PrivacyTreatments)other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.google.protos.adx.NetworkBid.BidRequest.PrivacyTreatments other) {
          if (other == com.google.protos.adx.NetworkBid.BidRequest.PrivacyTreatments.getDefaultInstance()) return this;
          if (!other.nonPersonalizedAdsReason_.isEmpty()) {
            if (nonPersonalizedAdsReason_.isEmpty()) {
              nonPersonalizedAdsReason_ = other.nonPersonalizedAdsReason_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureNonPersonalizedAdsReasonIsMutable();
              nonPersonalizedAdsReason_.addAll(other.nonPersonalizedAdsReason_);
            }
            onChanged();
          }
          if (other.hasAllowUserDataCollection()) {
            setAllowUserDataCollection(other.getAllowUserDataCollection());
          }
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          com.google.protos.adx.NetworkBid.BidRequest.PrivacyTreatments parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage = (com.google.protos.adx.NetworkBid.BidRequest.PrivacyTreatments) e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }
        private int bitField0_;

        private java.util.List<java.lang.Integer> nonPersonalizedAdsReason_ =
          java.util.Collections.emptyList();
        private void ensureNonPersonalizedAdsReasonIsMutable() {
          if (!((bitField0_ & 0x00000001) != 0)) {
            nonPersonalizedAdsReason_ = new java.util.ArrayList<java.lang.Integer>(nonPersonalizedAdsReason_);
            bitField0_ |= 0x00000001;
          }
        }
        /**
         * <code>repeated .com.google.protos.adx.BidRequest.PrivacyTreatments.NonPersonalizedAdsReason non_personalized_ads_reason = 6 [packed = true];</code>
         * @return A list containing the nonPersonalizedAdsReason.
         */
        public java.util.List<com.google.protos.adx.NetworkBid.BidRequest.PrivacyTreatments.NonPersonalizedAdsReason> getNonPersonalizedAdsReasonList() {
          return new com.google.protobuf.Internal.ListAdapter<
              java.lang.Integer, com.google.protos.adx.NetworkBid.BidRequest.PrivacyTreatments.NonPersonalizedAdsReason>(nonPersonalizedAdsReason_, nonPersonalizedAdsReason_converter_);
        }
        /**
         * <code>repeated .com.google.protos.adx.BidRequest.PrivacyTreatments.NonPersonalizedAdsReason non_personalized_ads_reason = 6 [packed = true];</code>
         * @return The count of nonPersonalizedAdsReason.
         */
        public int getNonPersonalizedAdsReasonCount() {
          return nonPersonalizedAdsReason_.size();
        }
        /**
         * <code>repeated .com.google.protos.adx.BidRequest.PrivacyTreatments.NonPersonalizedAdsReason non_personalized_ads_reason = 6 [packed = true];</code>
         * @param index The index of the element to return.
         * @return The nonPersonalizedAdsReason at the given index.
         */
        public com.google.protos.adx.NetworkBid.BidRequest.PrivacyTreatments.NonPersonalizedAdsReason getNonPersonalizedAdsReason(int index) {
          return nonPersonalizedAdsReason_converter_.convert(nonPersonalizedAdsReason_.get(index));
        }
        /**
         * <code>repeated .com.google.protos.adx.BidRequest.PrivacyTreatments.NonPersonalizedAdsReason non_personalized_ads_reason = 6 [packed = true];</code>
         * @param index The index to set the value at.
         * @param value The nonPersonalizedAdsReason to set.
         * @return This builder for chaining.
         */
        public Builder setNonPersonalizedAdsReason(
            int index, com.google.protos.adx.NetworkBid.BidRequest.PrivacyTreatments.NonPersonalizedAdsReason value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureNonPersonalizedAdsReasonIsMutable();
          nonPersonalizedAdsReason_.set(index, value.getNumber());
          onChanged();
          return this;
        }
        /**
         * <code>repeated .com.google.protos.adx.BidRequest.PrivacyTreatments.NonPersonalizedAdsReason non_personalized_ads_reason = 6 [packed = true];</code>
         * @param value The nonPersonalizedAdsReason to add.
         * @return This builder for chaining.
         */
        public Builder addNonPersonalizedAdsReason(com.google.protos.adx.NetworkBid.BidRequest.PrivacyTreatments.NonPersonalizedAdsReason value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureNonPersonalizedAdsReasonIsMutable();
          nonPersonalizedAdsReason_.add(value.getNumber());
          onChanged();
          return this;
        }
        /**
         * <code>repeated .com.google.protos.adx.BidRequest.PrivacyTreatments.NonPersonalizedAdsReason non_personalized_ads_reason = 6 [packed = true];</code>
         * @param values The nonPersonalizedAdsReason to add.
         * @return This builder for chaining.
         */
        public Builder addAllNonPersonalizedAdsReason(
            java.lang.Iterable<? extends com.google.protos.adx.NetworkBid.BidRequest.PrivacyTreatments.NonPersonalizedAdsReason> values) {
          ensureNonPersonalizedAdsReasonIsMutable();
          for (com.google.protos.adx.NetworkBid.BidRequest.PrivacyTreatments.NonPersonalizedAdsReason value : values) {
            nonPersonalizedAdsReason_.add(value.getNumber());
          }
          onChanged();
          return this;
        }
        /**
         * <code>repeated .com.google.protos.adx.BidRequest.PrivacyTreatments.NonPersonalizedAdsReason non_personalized_ads_reason = 6 [packed = true];</code>
         * @return This builder for chaining.
         */
        public Builder clearNonPersonalizedAdsReason() {
          nonPersonalizedAdsReason_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }

        private boolean allowUserDataCollection_ ;
        /**
         * <pre>
         * True if publisher grants the permission to allow the bidder to use
         * user visitation information from the publisher's site to create
         * interest categories that can be used to serve ads based on those
         * categories. To use this data to create interest categories, a bidder must
         * also win a given impression.
         * https://support.google.com/admanager/answer/11956152
         * </pre>
         *
         * <code>optional bool allow_user_data_collection = 7;</code>
         * @return Whether the allowUserDataCollection field is set.
         */
        @java.lang.Override
        public boolean hasAllowUserDataCollection() {
          return ((bitField0_ & 0x00000002) != 0);
        }
        /**
         * <pre>
         * True if publisher grants the permission to allow the bidder to use
         * user visitation information from the publisher's site to create
         * interest categories that can be used to serve ads based on those
         * categories. To use this data to create interest categories, a bidder must
         * also win a given impression.
         * https://support.google.com/admanager/answer/11956152
         * </pre>
         *
         * <code>optional bool allow_user_data_collection = 7;</code>
         * @return The allowUserDataCollection.
         */
        @java.lang.Override
        public boolean getAllowUserDataCollection() {
          return allowUserDataCollection_;
        }
        /**
         * <pre>
         * True if publisher grants the permission to allow the bidder to use
         * user visitation information from the publisher's site to create
         * interest categories that can be used to serve ads based on those
         * categories. To use this data to create interest categories, a bidder must
         * also win a given impression.
         * https://support.google.com/admanager/answer/11956152
         * </pre>
         *
         * <code>optional bool allow_user_data_collection = 7;</code>
         * @param value The allowUserDataCollection to set.
         * @return This builder for chaining.
         */
        public Builder setAllowUserDataCollection(boolean value) {
          bitField0_ |= 0x00000002;
          allowUserDataCollection_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * True if publisher grants the permission to allow the bidder to use
         * user visitation information from the publisher's site to create
         * interest categories that can be used to serve ads based on those
         * categories. To use this data to create interest categories, a bidder must
         * also win a given impression.
         * https://support.google.com/admanager/answer/11956152
         * </pre>
         *
         * <code>optional bool allow_user_data_collection = 7;</code>
         * @return This builder for chaining.
         */
        public Builder clearAllowUserDataCollection() {
          bitField0_ = (bitField0_ & ~0x00000002);
          allowUserDataCollection_ = false;
          onChanged();
          return this;
        }
        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }


        // @@protoc_insertion_point(builder_scope:com.google.protos.adx.BidRequest.PrivacyTreatments)
      }

      // @@protoc_insertion_point(class_scope:com.google.protos.adx.BidRequest.PrivacyTreatments)
      private static final com.google.protos.adx.NetworkBid.BidRequest.PrivacyTreatments DEFAULT_INSTANCE;
      static {
        DEFAULT_INSTANCE = new com.google.protos.adx.NetworkBid.BidRequest.PrivacyTreatments();
      }

      public static com.google.protos.adx.NetworkBid.BidRequest.PrivacyTreatments getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      @java.lang.Deprecated public static final com.google.protobuf.Parser<PrivacyTreatments>
          PARSER = new com.google.protobuf.AbstractParser<PrivacyTreatments>() {
        @java.lang.Override
        public PrivacyTreatments parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new PrivacyTreatments(input, extensionRegistry);
        }
      };

      public static com.google.protobuf.Parser<PrivacyTreatments> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<PrivacyTreatments> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protos.adx.NetworkBid.BidRequest.PrivacyTreatments getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }

    }

    public interface UserAgentOrBuilder extends
        // @@protoc_insertion_point(interface_extends:com.google.protos.adx.BidRequest.UserAgent)
        com.google.protobuf.MessageOrBuilder {

      /**
       * <pre>
       * Identifies the browser. Use the new field browsers.
       * </pre>
       *
       * <code>optional .com.google.protos.adx.BidRequest.UserAgent.BrandVersion DEPRECATED_browser = 1 [deprecated = true];</code>
       * @deprecated com.google.protos.adx.BidRequest.UserAgent.DEPRECATED_browser is deprecated.
       *     See network-bid.proto;l=132
       * @return Whether the dEPRECATEDBrowser field is set.
       */
      @java.lang.Deprecated boolean hasDEPRECATEDBrowser();
      /**
       * <pre>
       * Identifies the browser. Use the new field browsers.
       * </pre>
       *
       * <code>optional .com.google.protos.adx.BidRequest.UserAgent.BrandVersion DEPRECATED_browser = 1 [deprecated = true];</code>
       * @deprecated com.google.protos.adx.BidRequest.UserAgent.DEPRECATED_browser is deprecated.
       *     See network-bid.proto;l=132
       * @return The dEPRECATEDBrowser.
       */
      @java.lang.Deprecated com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion getDEPRECATEDBrowser();
      /**
       * <pre>
       * Identifies the browser. Use the new field browsers.
       * </pre>
       *
       * <code>optional .com.google.protos.adx.BidRequest.UserAgent.BrandVersion DEPRECATED_browser = 1 [deprecated = true];</code>
       */
      @java.lang.Deprecated com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersionOrBuilder getDEPRECATEDBrowserOrBuilder();

      /**
       * <pre>
       * Each BrandVersion object identifies a browser or similar software
       * component. Exchanges should send brands and versions derived from
       * the Sec-CH-UA-Full-Version-List header.
       * </pre>
       *
       * <code>repeated .com.google.protos.adx.BidRequest.UserAgent.BrandVersion browsers = 8;</code>
       */
      java.util.List<com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion> 
          getBrowsersList();
      /**
       * <pre>
       * Each BrandVersion object identifies a browser or similar software
       * component. Exchanges should send brands and versions derived from
       * the Sec-CH-UA-Full-Version-List header.
       * </pre>
       *
       * <code>repeated .com.google.protos.adx.BidRequest.UserAgent.BrandVersion browsers = 8;</code>
       */
      com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion getBrowsers(int index);
      /**
       * <pre>
       * Each BrandVersion object identifies a browser or similar software
       * component. Exchanges should send brands and versions derived from
       * the Sec-CH-UA-Full-Version-List header.
       * </pre>
       *
       * <code>repeated .com.google.protos.adx.BidRequest.UserAgent.BrandVersion browsers = 8;</code>
       */
      int getBrowsersCount();
      /**
       * <pre>
       * Each BrandVersion object identifies a browser or similar software
       * component. Exchanges should send brands and versions derived from
       * the Sec-CH-UA-Full-Version-List header.
       * </pre>
       *
       * <code>repeated .com.google.protos.adx.BidRequest.UserAgent.BrandVersion browsers = 8;</code>
       */
      java.util.List<? extends com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersionOrBuilder> 
          getBrowsersOrBuilderList();
      /**
       * <pre>
       * Each BrandVersion object identifies a browser or similar software
       * component. Exchanges should send brands and versions derived from
       * the Sec-CH-UA-Full-Version-List header.
       * </pre>
       *
       * <code>repeated .com.google.protos.adx.BidRequest.UserAgent.BrandVersion browsers = 8;</code>
       */
      com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersionOrBuilder getBrowsersOrBuilder(
          int index);

      /**
       * <pre>
       * Identifies the user agent's execution platform / OS. Exchanges should
       * send a brand derived from the Sec-CH-UA-Platform header, and version
       * derived from the Sec-CH-UAPlatform-Version header.
       * </pre>
       *
       * <code>optional .com.google.protos.adx.BidRequest.UserAgent.BrandVersion platform = 2;</code>
       * @return Whether the platform field is set.
       */
      boolean hasPlatform();
      /**
       * <pre>
       * Identifies the user agent's execution platform / OS. Exchanges should
       * send a brand derived from the Sec-CH-UA-Platform header, and version
       * derived from the Sec-CH-UAPlatform-Version header.
       * </pre>
       *
       * <code>optional .com.google.protos.adx.BidRequest.UserAgent.BrandVersion platform = 2;</code>
       * @return The platform.
       */
      com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion getPlatform();
      /**
       * <pre>
       * Identifies the user agent's execution platform / OS. Exchanges should
       * send a brand derived from the Sec-CH-UA-Platform header, and version
       * derived from the Sec-CH-UAPlatform-Version header.
       * </pre>
       *
       * <code>optional .com.google.protos.adx.BidRequest.UserAgent.BrandVersion platform = 2;</code>
       */
      com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersionOrBuilder getPlatformOrBuilder();

      /**
       * <pre>
       * True if the agent prefers a "mobile" version of the content if
       * available, i.e. optimized for small screens or touch input. False if
       * the agent prefers the "desktop" or "full" content. Exchanges should
       * derive this value from the Sec-CH-UAMobile header.
       * </pre>
       *
       * <code>optional bool mobile = 3;</code>
       * @return Whether the mobile field is set.
       */
      boolean hasMobile();
      /**
       * <pre>
       * True if the agent prefers a "mobile" version of the content if
       * available, i.e. optimized for small screens or touch input. False if
       * the agent prefers the "desktop" or "full" content. Exchanges should
       * derive this value from the Sec-CH-UAMobile header.
       * </pre>
       *
       * <code>optional bool mobile = 3;</code>
       * @return The mobile.
       */
      boolean getMobile();

      /**
       * <pre>
       * Device's major binary architecture, e.g. "x86" or "arm". Exchanges
       * should retrieve this value from the Sec-CH-UA-Arch header.
       * </pre>
       *
       * <code>optional string architecture = 4;</code>
       * @return Whether the architecture field is set.
       */
      boolean hasArchitecture();
      /**
       * <pre>
       * Device's major binary architecture, e.g. "x86" or "arm". Exchanges
       * should retrieve this value from the Sec-CH-UA-Arch header.
       * </pre>
       *
       * <code>optional string architecture = 4;</code>
       * @return The architecture.
       */
      java.lang.String getArchitecture();
      /**
       * <pre>
       * Device's major binary architecture, e.g. "x86" or "arm". Exchanges
       * should retrieve this value from the Sec-CH-UA-Arch header.
       * </pre>
       *
       * <code>optional string architecture = 4;</code>
       * @return The bytes for architecture.
       */
      com.google.protobuf.ByteString
          getArchitectureBytes();

      /**
       * <pre>
       * Device's bitness, e.g. "64" for 64-bit architecture. Exchanges should
       * retrieve this value from the Sec-CH-UA-Bitness header.
       * </pre>
       *
       * <code>optional string bitness = 9;</code>
       * @return Whether the bitness field is set.
       */
      boolean hasBitness();
      /**
       * <pre>
       * Device's bitness, e.g. "64" for 64-bit architecture. Exchanges should
       * retrieve this value from the Sec-CH-UA-Bitness header.
       * </pre>
       *
       * <code>optional string bitness = 9;</code>
       * @return The bitness.
       */
      java.lang.String getBitness();
      /**
       * <pre>
       * Device's bitness, e.g. "64" for 64-bit architecture. Exchanges should
       * retrieve this value from the Sec-CH-UA-Bitness header.
       * </pre>
       *
       * <code>optional string bitness = 9;</code>
       * @return The bytes for bitness.
       */
      com.google.protobuf.ByteString
          getBitnessBytes();

      /**
       * <pre>
       * Device model. Exchanges should retrieve this value from the
       * Sec-CH-UAModel header.
       * </pre>
       *
       * <code>optional string model = 5;</code>
       * @return Whether the model field is set.
       */
      boolean hasModel();
      /**
       * <pre>
       * Device model. Exchanges should retrieve this value from the
       * Sec-CH-UAModel header.
       * </pre>
       *
       * <code>optional string model = 5;</code>
       * @return The model.
       */
      java.lang.String getModel();
      /**
       * <pre>
       * Device model. Exchanges should retrieve this value from the
       * Sec-CH-UAModel header.
       * </pre>
       *
       * <code>optional string model = 5;</code>
       * @return The bytes for model.
       */
      com.google.protobuf.ByteString
          getModelBytes();
    }
    /**
     * <pre>
     * Structured user agent information, which can be used when a client
     * supports User-Agent Client Hints: https://wicg.github.io/ua-client-hints/
     * Note: When available, fields are sourced from Client Hints HTTP headers
     * or equivalent JavaScript accessors from the NavigatorUAData interface.
     * For agents that have no support for User-Agent Client Hints, an exchange
     * can also extract information from the parsed User-Agent header, so this
     * object can always be used as the source of the user agent information.
     * </pre>
     *
     * Protobuf type {@code com.google.protos.adx.BidRequest.UserAgent}
     */
    public static final class UserAgent extends
        com.google.protobuf.GeneratedMessageV3 implements
        // @@protoc_insertion_point(message_implements:com.google.protos.adx.BidRequest.UserAgent)
        UserAgentOrBuilder {
    private static final long serialVersionUID = 0L;
      // Use UserAgent.newBuilder() to construct.
      private UserAgent(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }
      private UserAgent() {
        browsers_ = java.util.Collections.emptyList();
        architecture_ = "";
        bitness_ = "";
        model_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(
          UnusedPrivateParameter unused) {
        return new UserAgent();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet
      getUnknownFields() {
        return this.unknownFields;
      }
      private UserAgent(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        int mutable_bitField0_ = 0;
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion.Builder subBuilder = null;
                if (((bitField0_ & 0x00000001) != 0)) {
                  subBuilder = dEPRECATEDBrowser_.toBuilder();
                }
                dEPRECATEDBrowser_ = input.readMessage(com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion.PARSER, extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(dEPRECATEDBrowser_);
                  dEPRECATEDBrowser_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000001;
                break;
              }
              case 18: {
                com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion.Builder subBuilder = null;
                if (((bitField0_ & 0x00000002) != 0)) {
                  subBuilder = platform_.toBuilder();
                }
                platform_ = input.readMessage(com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion.PARSER, extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(platform_);
                  platform_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000002;
                break;
              }
              case 24: {
                bitField0_ |= 0x00000004;
                mobile_ = input.readBool();
                break;
              }
              case 34: {
                com.google.protobuf.ByteString bs = input.readBytes();
                bitField0_ |= 0x00000008;
                architecture_ = bs;
                break;
              }
              case 42: {
                com.google.protobuf.ByteString bs = input.readBytes();
                bitField0_ |= 0x00000020;
                model_ = bs;
                break;
              }
              case 66: {
                if (!((mutable_bitField0_ & 0x00000002) != 0)) {
                  browsers_ = new java.util.ArrayList<com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion>();
                  mutable_bitField0_ |= 0x00000002;
                }
                browsers_.add(
                    input.readMessage(com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion.PARSER, extensionRegistry));
                break;
              }
              case 74: {
                com.google.protobuf.ByteString bs = input.readBytes();
                bitField0_ |= 0x00000010;
                bitness_ = bs;
                break;
              }
              default: {
                if (!parseUnknownField(
                    input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(
              e).setUnfinishedMessage(this);
        } finally {
          if (((mutable_bitField0_ & 0x00000002) != 0)) {
            browsers_ = java.util.Collections.unmodifiableList(browsers_);
          }
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_UserAgent_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_UserAgent_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.protos.adx.NetworkBid.BidRequest.UserAgent.class, com.google.protos.adx.NetworkBid.BidRequest.UserAgent.Builder.class);
      }

      public interface BrandVersionOrBuilder extends
          // @@protoc_insertion_point(interface_extends:com.google.protos.adx.BidRequest.UserAgent.BrandVersion)
          com.google.protobuf.MessageOrBuilder {

        /**
         * <pre>
         * A brand identifier, for example, "Chrome" or "Windows". The value may
         * be sourced from the User-Agent Client Hints headers, representing
         * either the user agent brand (from the Sec-CH-UA-Full-Version header)
         * or the platform brand (from the Sec-CH-UA-Platform header).
         * </pre>
         *
         * <code>optional string brand = 1;</code>
         * @return Whether the brand field is set.
         */
        boolean hasBrand();
        /**
         * <pre>
         * A brand identifier, for example, "Chrome" or "Windows". The value may
         * be sourced from the User-Agent Client Hints headers, representing
         * either the user agent brand (from the Sec-CH-UA-Full-Version header)
         * or the platform brand (from the Sec-CH-UA-Platform header).
         * </pre>
         *
         * <code>optional string brand = 1;</code>
         * @return The brand.
         */
        java.lang.String getBrand();
        /**
         * <pre>
         * A brand identifier, for example, "Chrome" or "Windows". The value may
         * be sourced from the User-Agent Client Hints headers, representing
         * either the user agent brand (from the Sec-CH-UA-Full-Version header)
         * or the platform brand (from the Sec-CH-UA-Platform header).
         * </pre>
         *
         * <code>optional string brand = 1;</code>
         * @return The bytes for brand.
         */
        com.google.protobuf.ByteString
            getBrandBytes();

        /**
         * <pre>
         * A sequence of version components, in descending hierarchical order
         * (major, minor, micro, ...).
         * </pre>
         *
         * <code>repeated string version = 2;</code>
         * @return A list containing the version.
         */
        java.util.List<java.lang.String>
            getVersionList();
        /**
         * <pre>
         * A sequence of version components, in descending hierarchical order
         * (major, minor, micro, ...).
         * </pre>
         *
         * <code>repeated string version = 2;</code>
         * @return The count of version.
         */
        int getVersionCount();
        /**
         * <pre>
         * A sequence of version components, in descending hierarchical order
         * (major, minor, micro, ...).
         * </pre>
         *
         * <code>repeated string version = 2;</code>
         * @param index The index of the element to return.
         * @return The version at the given index.
         */
        java.lang.String getVersion(int index);
        /**
         * <pre>
         * A sequence of version components, in descending hierarchical order
         * (major, minor, micro, ...).
         * </pre>
         *
         * <code>repeated string version = 2;</code>
         * @param index The index of the value to return.
         * @return The bytes of the version at the given index.
         */
        com.google.protobuf.ByteString
            getVersionBytes(int index);
      }
      /**
       * <pre>
       * Identifies a device's browser or similar software component, and the
       * user agent's execution platform or operating system.
       * </pre>
       *
       * Protobuf type {@code com.google.protos.adx.BidRequest.UserAgent.BrandVersion}
       */
      public static final class BrandVersion extends
          com.google.protobuf.GeneratedMessageV3 implements
          // @@protoc_insertion_point(message_implements:com.google.protos.adx.BidRequest.UserAgent.BrandVersion)
          BrandVersionOrBuilder {
      private static final long serialVersionUID = 0L;
        // Use BrandVersion.newBuilder() to construct.
        private BrandVersion(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }
        private BrandVersion() {
          brand_ = "";
          version_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(
            UnusedPrivateParameter unused) {
          return new BrandVersion();
        }

        @java.lang.Override
        public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
          return this.unknownFields;
        }
        private BrandVersion(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          this();
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          int mutable_bitField0_ = 0;
          com.google.protobuf.UnknownFieldSet.Builder unknownFields =
              com.google.protobuf.UnknownFieldSet.newBuilder();
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10: {
                  com.google.protobuf.ByteString bs = input.readBytes();
                  bitField0_ |= 0x00000001;
                  brand_ = bs;
                  break;
                }
                case 18: {
                  com.google.protobuf.ByteString bs = input.readBytes();
                  if (!((mutable_bitField0_ & 0x00000002) != 0)) {
                    version_ = new com.google.protobuf.LazyStringArrayList();
                    mutable_bitField0_ |= 0x00000002;
                  }
                  version_.add(bs);
                  break;
                }
                default: {
                  if (!parseUnknownField(
                      input, unknownFields, extensionRegistry, tag)) {
                    done = true;
                  }
                  break;
                }
              }
            }
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(this);
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(
                e).setUnfinishedMessage(this);
          } finally {
            if (((mutable_bitField0_ & 0x00000002) != 0)) {
              version_ = version_.getUnmodifiableView();
            }
            this.unknownFields = unknownFields.build();
            makeExtensionsImmutable();
          }
        }
        public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
          return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_UserAgent_BrandVersion_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_UserAgent_BrandVersion_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion.class, com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion.Builder.class);
        }

        private int bitField0_;
        public static final int BRAND_FIELD_NUMBER = 1;
        private volatile java.lang.Object brand_;
        /**
         * <pre>
         * A brand identifier, for example, "Chrome" or "Windows". The value may
         * be sourced from the User-Agent Client Hints headers, representing
         * either the user agent brand (from the Sec-CH-UA-Full-Version header)
         * or the platform brand (from the Sec-CH-UA-Platform header).
         * </pre>
         *
         * <code>optional string brand = 1;</code>
         * @return Whether the brand field is set.
         */
        @java.lang.Override
        public boolean hasBrand() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         * <pre>
         * A brand identifier, for example, "Chrome" or "Windows". The value may
         * be sourced from the User-Agent Client Hints headers, representing
         * either the user agent brand (from the Sec-CH-UA-Full-Version header)
         * or the platform brand (from the Sec-CH-UA-Platform header).
         * </pre>
         *
         * <code>optional string brand = 1;</code>
         * @return The brand.
         */
        @java.lang.Override
        public java.lang.String getBrand() {
          java.lang.Object ref = brand_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = 
                (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            if (bs.isValidUtf8()) {
              brand_ = s;
            }
            return s;
          }
        }
        /**
         * <pre>
         * A brand identifier, for example, "Chrome" or "Windows". The value may
         * be sourced from the User-Agent Client Hints headers, representing
         * either the user agent brand (from the Sec-CH-UA-Full-Version header)
         * or the platform brand (from the Sec-CH-UA-Platform header).
         * </pre>
         *
         * <code>optional string brand = 1;</code>
         * @return The bytes for brand.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString
            getBrandBytes() {
          java.lang.Object ref = brand_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b = 
                com.google.protobuf.ByteString.copyFromUtf8(
                    (java.lang.String) ref);
            brand_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        public static final int VERSION_FIELD_NUMBER = 2;
        private com.google.protobuf.LazyStringList version_;
        /**
         * <pre>
         * A sequence of version components, in descending hierarchical order
         * (major, minor, micro, ...).
         * </pre>
         *
         * <code>repeated string version = 2;</code>
         * @return A list containing the version.
         */
        public com.google.protobuf.ProtocolStringList
            getVersionList() {
          return version_;
        }
        /**
         * <pre>
         * A sequence of version components, in descending hierarchical order
         * (major, minor, micro, ...).
         * </pre>
         *
         * <code>repeated string version = 2;</code>
         * @return The count of version.
         */
        public int getVersionCount() {
          return version_.size();
        }
        /**
         * <pre>
         * A sequence of version components, in descending hierarchical order
         * (major, minor, micro, ...).
         * </pre>
         *
         * <code>repeated string version = 2;</code>
         * @param index The index of the element to return.
         * @return The version at the given index.
         */
        public java.lang.String getVersion(int index) {
          return version_.get(index);
        }
        /**
         * <pre>
         * A sequence of version components, in descending hierarchical order
         * (major, minor, micro, ...).
         * </pre>
         *
         * <code>repeated string version = 2;</code>
         * @param index The index of the value to return.
         * @return The bytes of the version at the given index.
         */
        public com.google.protobuf.ByteString
            getVersionBytes(int index) {
          return version_.getByteString(index);
        }

        private byte memoizedIsInitialized = -1;
        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
                            throws java.io.IOException {
          if (((bitField0_ & 0x00000001) != 0)) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 1, brand_);
          }
          for (int i = 0; i < version_.size(); i++) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 2, version_.getRaw(i));
          }
          unknownFields.writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (((bitField0_ & 0x00000001) != 0)) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, brand_);
          }
          {
            int dataSize = 0;
            for (int i = 0; i < version_.size(); i++) {
              dataSize += computeStringSizeNoTag(version_.getRaw(i));
            }
            size += dataSize;
            size += 1 * getVersionList().size();
          }
          size += unknownFields.getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
           return true;
          }
          if (!(obj instanceof com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion)) {
            return super.equals(obj);
          }
          com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion other = (com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion) obj;

          if (hasBrand() != other.hasBrand()) return false;
          if (hasBrand()) {
            if (!getBrand()
                .equals(other.getBrand())) return false;
          }
          if (!getVersionList()
              .equals(other.getVersionList())) return false;
          if (!unknownFields.equals(other.unknownFields)) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          if (hasBrand()) {
            hash = (37 * hash) + BRAND_FIELD_NUMBER;
            hash = (53 * hash) + getBrand().hashCode();
          }
          if (getVersionCount() > 0) {
            hash = (37 * hash) + VERSION_FIELD_NUMBER;
            hash = (53 * hash) + getVersionList().hashCode();
          }
          hash = (29 * hash) + unknownFields.hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion parseFrom(
            java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }
        public static com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion parseFrom(
            java.nio.ByteBuffer data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }
        public static com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion parseFrom(
            com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }
        public static com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }
        public static com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion parseFrom(byte[] data)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }
        public static com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion parseFrom(
            byte[] data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }
        public static com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion parseFrom(java.io.InputStream input)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3
              .parseWithIOException(PARSER, input);
        }
        public static com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion parseFrom(
            java.io.InputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3
              .parseWithIOException(PARSER, input, extensionRegistry);
        }
        public static com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion parseDelimitedFrom(java.io.InputStream input)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3
              .parseDelimitedWithIOException(PARSER, input);
        }
        public static com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion parseDelimitedFrom(
            java.io.InputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3
              .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
        }
        public static com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion parseFrom(
            com.google.protobuf.CodedInputStream input)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3
              .parseWithIOException(PARSER, input);
        }
        public static com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3
              .parseWithIOException(PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() { return newBuilder(); }
        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }
        public static Builder newBuilder(com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }
        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE
              ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         * <pre>
         * Identifies a device's browser or similar software component, and the
         * user agent's execution platform or operating system.
         * </pre>
         *
         * Protobuf type {@code com.google.protos.adx.BidRequest.UserAgent.BrandVersion}
         */
        public static final class Builder extends
            com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
            // @@protoc_insertion_point(builder_implements:com.google.protos.adx.BidRequest.UserAgent.BrandVersion)
            com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersionOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor
              getDescriptor() {
            return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_UserAgent_BrandVersion_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_UserAgent_BrandVersion_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion.class, com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion.Builder.class);
          }

          // Construct using com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion.newBuilder()
          private Builder() {
            maybeForceBuilderInitialization();
          }

          private Builder(
              com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            maybeForceBuilderInitialization();
          }
          private void maybeForceBuilderInitialization() {
            if (com.google.protobuf.GeneratedMessageV3
                    .alwaysUseFieldBuilders) {
            }
          }
          @java.lang.Override
          public Builder clear() {
            super.clear();
            brand_ = "";
            bitField0_ = (bitField0_ & ~0x00000001);
            version_ = com.google.protobuf.LazyStringArrayList.EMPTY;
            bitField0_ = (bitField0_ & ~0x00000002);
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor
              getDescriptorForType() {
            return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_UserAgent_BrandVersion_descriptor;
          }

          @java.lang.Override
          public com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion getDefaultInstanceForType() {
            return com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion.getDefaultInstance();
          }

          @java.lang.Override
          public com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion build() {
            com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion result = buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion buildPartial() {
            com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion result = new com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion(this);
            int from_bitField0_ = bitField0_;
            int to_bitField0_ = 0;
            if (((from_bitField0_ & 0x00000001) != 0)) {
              to_bitField0_ |= 0x00000001;
            }
            result.brand_ = brand_;
            if (((bitField0_ & 0x00000002) != 0)) {
              version_ = version_.getUnmodifiableView();
              bitField0_ = (bitField0_ & ~0x00000002);
            }
            result.version_ = version_;
            result.bitField0_ = to_bitField0_;
            onBuilt();
            return result;
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }
          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              java.lang.Object value) {
            return super.setField(field, value);
          }
          @java.lang.Override
          public Builder clearField(
              com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }
          @java.lang.Override
          public Builder clearOneof(
              com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }
          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index, java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }
          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }
          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other instanceof com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion) {
              return mergeFrom((com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion)other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion other) {
            if (other == com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion.getDefaultInstance()) return this;
            if (other.hasBrand()) {
              bitField0_ |= 0x00000001;
              brand_ = other.brand_;
              onChanged();
            }
            if (!other.version_.isEmpty()) {
              if (version_.isEmpty()) {
                version_ = other.version_;
                bitField0_ = (bitField0_ & ~0x00000002);
              } else {
                ensureVersionIsMutable();
                version_.addAll(other.version_);
              }
              onChanged();
            }
            this.mergeUnknownFields(other.unknownFields);
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion parsedMessage = null;
            try {
              parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              parsedMessage = (com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion) e.getUnfinishedMessage();
              throw e.unwrapIOException();
            } finally {
              if (parsedMessage != null) {
                mergeFrom(parsedMessage);
              }
            }
            return this;
          }
          private int bitField0_;

          private java.lang.Object brand_ = "";
          /**
           * <pre>
           * A brand identifier, for example, "Chrome" or "Windows". The value may
           * be sourced from the User-Agent Client Hints headers, representing
           * either the user agent brand (from the Sec-CH-UA-Full-Version header)
           * or the platform brand (from the Sec-CH-UA-Platform header).
           * </pre>
           *
           * <code>optional string brand = 1;</code>
           * @return Whether the brand field is set.
           */
          public boolean hasBrand() {
            return ((bitField0_ & 0x00000001) != 0);
          }
          /**
           * <pre>
           * A brand identifier, for example, "Chrome" or "Windows". The value may
           * be sourced from the User-Agent Client Hints headers, representing
           * either the user agent brand (from the Sec-CH-UA-Full-Version header)
           * or the platform brand (from the Sec-CH-UA-Platform header).
           * </pre>
           *
           * <code>optional string brand = 1;</code>
           * @return The brand.
           */
          public java.lang.String getBrand() {
            java.lang.Object ref = brand_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs =
                  (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              if (bs.isValidUtf8()) {
                brand_ = s;
              }
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }
          /**
           * <pre>
           * A brand identifier, for example, "Chrome" or "Windows". The value may
           * be sourced from the User-Agent Client Hints headers, representing
           * either the user agent brand (from the Sec-CH-UA-Full-Version header)
           * or the platform brand (from the Sec-CH-UA-Platform header).
           * </pre>
           *
           * <code>optional string brand = 1;</code>
           * @return The bytes for brand.
           */
          public com.google.protobuf.ByteString
              getBrandBytes() {
            java.lang.Object ref = brand_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b = 
                  com.google.protobuf.ByteString.copyFromUtf8(
                      (java.lang.String) ref);
              brand_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }
          /**
           * <pre>
           * A brand identifier, for example, "Chrome" or "Windows". The value may
           * be sourced from the User-Agent Client Hints headers, representing
           * either the user agent brand (from the Sec-CH-UA-Full-Version header)
           * or the platform brand (from the Sec-CH-UA-Platform header).
           * </pre>
           *
           * <code>optional string brand = 1;</code>
           * @param value The brand to set.
           * @return This builder for chaining.
           */
          public Builder setBrand(
              java.lang.String value) {
            if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
            brand_ = value;
            onChanged();
            return this;
          }
          /**
           * <pre>
           * A brand identifier, for example, "Chrome" or "Windows". The value may
           * be sourced from the User-Agent Client Hints headers, representing
           * either the user agent brand (from the Sec-CH-UA-Full-Version header)
           * or the platform brand (from the Sec-CH-UA-Platform header).
           * </pre>
           *
           * <code>optional string brand = 1;</code>
           * @return This builder for chaining.
           */
          public Builder clearBrand() {
            bitField0_ = (bitField0_ & ~0x00000001);
            brand_ = getDefaultInstance().getBrand();
            onChanged();
            return this;
          }
          /**
           * <pre>
           * A brand identifier, for example, "Chrome" or "Windows". The value may
           * be sourced from the User-Agent Client Hints headers, representing
           * either the user agent brand (from the Sec-CH-UA-Full-Version header)
           * or the platform brand (from the Sec-CH-UA-Platform header).
           * </pre>
           *
           * <code>optional string brand = 1;</code>
           * @param value The bytes for brand to set.
           * @return This builder for chaining.
           */
          public Builder setBrandBytes(
              com.google.protobuf.ByteString value) {
            if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
            brand_ = value;
            onChanged();
            return this;
          }

          private com.google.protobuf.LazyStringList version_ = com.google.protobuf.LazyStringArrayList.EMPTY;
          private void ensureVersionIsMutable() {
            if (!((bitField0_ & 0x00000002) != 0)) {
              version_ = new com.google.protobuf.LazyStringArrayList(version_);
              bitField0_ |= 0x00000002;
             }
          }
          /**
           * <pre>
           * A sequence of version components, in descending hierarchical order
           * (major, minor, micro, ...).
           * </pre>
           *
           * <code>repeated string version = 2;</code>
           * @return A list containing the version.
           */
          public com.google.protobuf.ProtocolStringList
              getVersionList() {
            return version_.getUnmodifiableView();
          }
          /**
           * <pre>
           * A sequence of version components, in descending hierarchical order
           * (major, minor, micro, ...).
           * </pre>
           *
           * <code>repeated string version = 2;</code>
           * @return The count of version.
           */
          public int getVersionCount() {
            return version_.size();
          }
          /**
           * <pre>
           * A sequence of version components, in descending hierarchical order
           * (major, minor, micro, ...).
           * </pre>
           *
           * <code>repeated string version = 2;</code>
           * @param index The index of the element to return.
           * @return The version at the given index.
           */
          public java.lang.String getVersion(int index) {
            return version_.get(index);
          }
          /**
           * <pre>
           * A sequence of version components, in descending hierarchical order
           * (major, minor, micro, ...).
           * </pre>
           *
           * <code>repeated string version = 2;</code>
           * @param index The index of the value to return.
           * @return The bytes of the version at the given index.
           */
          public com.google.protobuf.ByteString
              getVersionBytes(int index) {
            return version_.getByteString(index);
          }
          /**
           * <pre>
           * A sequence of version components, in descending hierarchical order
           * (major, minor, micro, ...).
           * </pre>
           *
           * <code>repeated string version = 2;</code>
           * @param index The index to set the value at.
           * @param value The version to set.
           * @return This builder for chaining.
           */
          public Builder setVersion(
              int index, java.lang.String value) {
            if (value == null) {
    throw new NullPointerException();
  }
  ensureVersionIsMutable();
            version_.set(index, value);
            onChanged();
            return this;
          }
          /**
           * <pre>
           * A sequence of version components, in descending hierarchical order
           * (major, minor, micro, ...).
           * </pre>
           *
           * <code>repeated string version = 2;</code>
           * @param value The version to add.
           * @return This builder for chaining.
           */
          public Builder addVersion(
              java.lang.String value) {
            if (value == null) {
    throw new NullPointerException();
  }
  ensureVersionIsMutable();
            version_.add(value);
            onChanged();
            return this;
          }
          /**
           * <pre>
           * A sequence of version components, in descending hierarchical order
           * (major, minor, micro, ...).
           * </pre>
           *
           * <code>repeated string version = 2;</code>
           * @param values The version to add.
           * @return This builder for chaining.
           */
          public Builder addAllVersion(
              java.lang.Iterable<java.lang.String> values) {
            ensureVersionIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(
                values, version_);
            onChanged();
            return this;
          }
          /**
           * <pre>
           * A sequence of version components, in descending hierarchical order
           * (major, minor, micro, ...).
           * </pre>
           *
           * <code>repeated string version = 2;</code>
           * @return This builder for chaining.
           */
          public Builder clearVersion() {
            version_ = com.google.protobuf.LazyStringArrayList.EMPTY;
            bitField0_ = (bitField0_ & ~0x00000002);
            onChanged();
            return this;
          }
          /**
           * <pre>
           * A sequence of version components, in descending hierarchical order
           * (major, minor, micro, ...).
           * </pre>
           *
           * <code>repeated string version = 2;</code>
           * @param value The bytes of the version to add.
           * @return This builder for chaining.
           */
          public Builder addVersionBytes(
              com.google.protobuf.ByteString value) {
            if (value == null) {
    throw new NullPointerException();
  }
  ensureVersionIsMutable();
            version_.add(value);
            onChanged();
            return this;
          }
          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }


          // @@protoc_insertion_point(builder_scope:com.google.protos.adx.BidRequest.UserAgent.BrandVersion)
        }

        // @@protoc_insertion_point(class_scope:com.google.protos.adx.BidRequest.UserAgent.BrandVersion)
        private static final com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion DEFAULT_INSTANCE;
        static {
          DEFAULT_INSTANCE = new com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion();
        }

        public static com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        @java.lang.Deprecated public static final com.google.protobuf.Parser<BrandVersion>
            PARSER = new com.google.protobuf.AbstractParser<BrandVersion>() {
          @java.lang.Override
          public BrandVersion parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new BrandVersion(input, extensionRegistry);
          }
        };

        public static com.google.protobuf.Parser<BrandVersion> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<BrandVersion> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }

      }

      private int bitField0_;
      public static final int DEPRECATED_BROWSER_FIELD_NUMBER = 1;
      private com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion dEPRECATEDBrowser_;
      /**
       * <pre>
       * Identifies the browser. Use the new field browsers.
       * </pre>
       *
       * <code>optional .com.google.protos.adx.BidRequest.UserAgent.BrandVersion DEPRECATED_browser = 1 [deprecated = true];</code>
       * @deprecated com.google.protos.adx.BidRequest.UserAgent.DEPRECATED_browser is deprecated.
       *     See network-bid.proto;l=132
       * @return Whether the dEPRECATEDBrowser field is set.
       */
      @java.lang.Override
      @java.lang.Deprecated public boolean hasDEPRECATEDBrowser() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <pre>
       * Identifies the browser. Use the new field browsers.
       * </pre>
       *
       * <code>optional .com.google.protos.adx.BidRequest.UserAgent.BrandVersion DEPRECATED_browser = 1 [deprecated = true];</code>
       * @deprecated com.google.protos.adx.BidRequest.UserAgent.DEPRECATED_browser is deprecated.
       *     See network-bid.proto;l=132
       * @return The dEPRECATEDBrowser.
       */
      @java.lang.Override
      @java.lang.Deprecated public com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion getDEPRECATEDBrowser() {
        return dEPRECATEDBrowser_ == null ? com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion.getDefaultInstance() : dEPRECATEDBrowser_;
      }
      /**
       * <pre>
       * Identifies the browser. Use the new field browsers.
       * </pre>
       *
       * <code>optional .com.google.protos.adx.BidRequest.UserAgent.BrandVersion DEPRECATED_browser = 1 [deprecated = true];</code>
       */
      @java.lang.Override
      @java.lang.Deprecated public com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersionOrBuilder getDEPRECATEDBrowserOrBuilder() {
        return dEPRECATEDBrowser_ == null ? com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion.getDefaultInstance() : dEPRECATEDBrowser_;
      }

      public static final int BROWSERS_FIELD_NUMBER = 8;
      private java.util.List<com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion> browsers_;
      /**
       * <pre>
       * Each BrandVersion object identifies a browser or similar software
       * component. Exchanges should send brands and versions derived from
       * the Sec-CH-UA-Full-Version-List header.
       * </pre>
       *
       * <code>repeated .com.google.protos.adx.BidRequest.UserAgent.BrandVersion browsers = 8;</code>
       */
      @java.lang.Override
      public java.util.List<com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion> getBrowsersList() {
        return browsers_;
      }
      /**
       * <pre>
       * Each BrandVersion object identifies a browser or similar software
       * component. Exchanges should send brands and versions derived from
       * the Sec-CH-UA-Full-Version-List header.
       * </pre>
       *
       * <code>repeated .com.google.protos.adx.BidRequest.UserAgent.BrandVersion browsers = 8;</code>
       */
      @java.lang.Override
      public java.util.List<? extends com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersionOrBuilder> 
          getBrowsersOrBuilderList() {
        return browsers_;
      }
      /**
       * <pre>
       * Each BrandVersion object identifies a browser or similar software
       * component. Exchanges should send brands and versions derived from
       * the Sec-CH-UA-Full-Version-List header.
       * </pre>
       *
       * <code>repeated .com.google.protos.adx.BidRequest.UserAgent.BrandVersion browsers = 8;</code>
       */
      @java.lang.Override
      public int getBrowsersCount() {
        return browsers_.size();
      }
      /**
       * <pre>
       * Each BrandVersion object identifies a browser or similar software
       * component. Exchanges should send brands and versions derived from
       * the Sec-CH-UA-Full-Version-List header.
       * </pre>
       *
       * <code>repeated .com.google.protos.adx.BidRequest.UserAgent.BrandVersion browsers = 8;</code>
       */
      @java.lang.Override
      public com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion getBrowsers(int index) {
        return browsers_.get(index);
      }
      /**
       * <pre>
       * Each BrandVersion object identifies a browser or similar software
       * component. Exchanges should send brands and versions derived from
       * the Sec-CH-UA-Full-Version-List header.
       * </pre>
       *
       * <code>repeated .com.google.protos.adx.BidRequest.UserAgent.BrandVersion browsers = 8;</code>
       */
      @java.lang.Override
      public com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersionOrBuilder getBrowsersOrBuilder(
          int index) {
        return browsers_.get(index);
      }

      public static final int PLATFORM_FIELD_NUMBER = 2;
      private com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion platform_;
      /**
       * <pre>
       * Identifies the user agent's execution platform / OS. Exchanges should
       * send a brand derived from the Sec-CH-UA-Platform header, and version
       * derived from the Sec-CH-UAPlatform-Version header.
       * </pre>
       *
       * <code>optional .com.google.protos.adx.BidRequest.UserAgent.BrandVersion platform = 2;</code>
       * @return Whether the platform field is set.
       */
      @java.lang.Override
      public boolean hasPlatform() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <pre>
       * Identifies the user agent's execution platform / OS. Exchanges should
       * send a brand derived from the Sec-CH-UA-Platform header, and version
       * derived from the Sec-CH-UAPlatform-Version header.
       * </pre>
       *
       * <code>optional .com.google.protos.adx.BidRequest.UserAgent.BrandVersion platform = 2;</code>
       * @return The platform.
       */
      @java.lang.Override
      public com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion getPlatform() {
        return platform_ == null ? com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion.getDefaultInstance() : platform_;
      }
      /**
       * <pre>
       * Identifies the user agent's execution platform / OS. Exchanges should
       * send a brand derived from the Sec-CH-UA-Platform header, and version
       * derived from the Sec-CH-UAPlatform-Version header.
       * </pre>
       *
       * <code>optional .com.google.protos.adx.BidRequest.UserAgent.BrandVersion platform = 2;</code>
       */
      @java.lang.Override
      public com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersionOrBuilder getPlatformOrBuilder() {
        return platform_ == null ? com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion.getDefaultInstance() : platform_;
      }

      public static final int MOBILE_FIELD_NUMBER = 3;
      private boolean mobile_;
      /**
       * <pre>
       * True if the agent prefers a "mobile" version of the content if
       * available, i.e. optimized for small screens or touch input. False if
       * the agent prefers the "desktop" or "full" content. Exchanges should
       * derive this value from the Sec-CH-UAMobile header.
       * </pre>
       *
       * <code>optional bool mobile = 3;</code>
       * @return Whether the mobile field is set.
       */
      @java.lang.Override
      public boolean hasMobile() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       * <pre>
       * True if the agent prefers a "mobile" version of the content if
       * available, i.e. optimized for small screens or touch input. False if
       * the agent prefers the "desktop" or "full" content. Exchanges should
       * derive this value from the Sec-CH-UAMobile header.
       * </pre>
       *
       * <code>optional bool mobile = 3;</code>
       * @return The mobile.
       */
      @java.lang.Override
      public boolean getMobile() {
        return mobile_;
      }

      public static final int ARCHITECTURE_FIELD_NUMBER = 4;
      private volatile java.lang.Object architecture_;
      /**
       * <pre>
       * Device's major binary architecture, e.g. "x86" or "arm". Exchanges
       * should retrieve this value from the Sec-CH-UA-Arch header.
       * </pre>
       *
       * <code>optional string architecture = 4;</code>
       * @return Whether the architecture field is set.
       */
      @java.lang.Override
      public boolean hasArchitecture() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       * <pre>
       * Device's major binary architecture, e.g. "x86" or "arm". Exchanges
       * should retrieve this value from the Sec-CH-UA-Arch header.
       * </pre>
       *
       * <code>optional string architecture = 4;</code>
       * @return The architecture.
       */
      @java.lang.Override
      public java.lang.String getArchitecture() {
        java.lang.Object ref = architecture_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = 
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            architecture_ = s;
          }
          return s;
        }
      }
      /**
       * <pre>
       * Device's major binary architecture, e.g. "x86" or "arm". Exchanges
       * should retrieve this value from the Sec-CH-UA-Arch header.
       * </pre>
       *
       * <code>optional string architecture = 4;</code>
       * @return The bytes for architecture.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString
          getArchitectureBytes() {
        java.lang.Object ref = architecture_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          architecture_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int BITNESS_FIELD_NUMBER = 9;
      private volatile java.lang.Object bitness_;
      /**
       * <pre>
       * Device's bitness, e.g. "64" for 64-bit architecture. Exchanges should
       * retrieve this value from the Sec-CH-UA-Bitness header.
       * </pre>
       *
       * <code>optional string bitness = 9;</code>
       * @return Whether the bitness field is set.
       */
      @java.lang.Override
      public boolean hasBitness() {
        return ((bitField0_ & 0x00000010) != 0);
      }
      /**
       * <pre>
       * Device's bitness, e.g. "64" for 64-bit architecture. Exchanges should
       * retrieve this value from the Sec-CH-UA-Bitness header.
       * </pre>
       *
       * <code>optional string bitness = 9;</code>
       * @return The bitness.
       */
      @java.lang.Override
      public java.lang.String getBitness() {
        java.lang.Object ref = bitness_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = 
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            bitness_ = s;
          }
          return s;
        }
      }
      /**
       * <pre>
       * Device's bitness, e.g. "64" for 64-bit architecture. Exchanges should
       * retrieve this value from the Sec-CH-UA-Bitness header.
       * </pre>
       *
       * <code>optional string bitness = 9;</code>
       * @return The bytes for bitness.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString
          getBitnessBytes() {
        java.lang.Object ref = bitness_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          bitness_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int MODEL_FIELD_NUMBER = 5;
      private volatile java.lang.Object model_;
      /**
       * <pre>
       * Device model. Exchanges should retrieve this value from the
       * Sec-CH-UAModel header.
       * </pre>
       *
       * <code>optional string model = 5;</code>
       * @return Whether the model field is set.
       */
      @java.lang.Override
      public boolean hasModel() {
        return ((bitField0_ & 0x00000020) != 0);
      }
      /**
       * <pre>
       * Device model. Exchanges should retrieve this value from the
       * Sec-CH-UAModel header.
       * </pre>
       *
       * <code>optional string model = 5;</code>
       * @return The model.
       */
      @java.lang.Override
      public java.lang.String getModel() {
        java.lang.Object ref = model_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = 
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            model_ = s;
          }
          return s;
        }
      }
      /**
       * <pre>
       * Device model. Exchanges should retrieve this value from the
       * Sec-CH-UAModel header.
       * </pre>
       *
       * <code>optional string model = 5;</code>
       * @return The bytes for model.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString
          getModelBytes() {
        java.lang.Object ref = model_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          model_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;
      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output)
                          throws java.io.IOException {
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeMessage(1, getDEPRECATEDBrowser());
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          output.writeMessage(2, getPlatform());
        }
        if (((bitField0_ & 0x00000004) != 0)) {
          output.writeBool(3, mobile_);
        }
        if (((bitField0_ & 0x00000008) != 0)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 4, architecture_);
        }
        if (((bitField0_ & 0x00000020) != 0)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 5, model_);
        }
        for (int i = 0; i < browsers_.size(); i++) {
          output.writeMessage(8, browsers_.get(i));
        }
        if (((bitField0_ & 0x00000010) != 0)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 9, bitness_);
        }
        unknownFields.writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.CodedOutputStream
            .computeMessageSize(1, getDEPRECATEDBrowser());
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          size += com.google.protobuf.CodedOutputStream
            .computeMessageSize(2, getPlatform());
        }
        if (((bitField0_ & 0x00000004) != 0)) {
          size += com.google.protobuf.CodedOutputStream
            .computeBoolSize(3, mobile_);
        }
        if (((bitField0_ & 0x00000008) != 0)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, architecture_);
        }
        if (((bitField0_ & 0x00000020) != 0)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, model_);
        }
        for (int i = 0; i < browsers_.size(); i++) {
          size += com.google.protobuf.CodedOutputStream
            .computeMessageSize(8, browsers_.get(i));
        }
        if (((bitField0_ & 0x00000010) != 0)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, bitness_);
        }
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
         return true;
        }
        if (!(obj instanceof com.google.protos.adx.NetworkBid.BidRequest.UserAgent)) {
          return super.equals(obj);
        }
        com.google.protos.adx.NetworkBid.BidRequest.UserAgent other = (com.google.protos.adx.NetworkBid.BidRequest.UserAgent) obj;

        if (hasDEPRECATEDBrowser() != other.hasDEPRECATEDBrowser()) return false;
        if (hasDEPRECATEDBrowser()) {
          if (!getDEPRECATEDBrowser()
              .equals(other.getDEPRECATEDBrowser())) return false;
        }
        if (!getBrowsersList()
            .equals(other.getBrowsersList())) return false;
        if (hasPlatform() != other.hasPlatform()) return false;
        if (hasPlatform()) {
          if (!getPlatform()
              .equals(other.getPlatform())) return false;
        }
        if (hasMobile() != other.hasMobile()) return false;
        if (hasMobile()) {
          if (getMobile()
              != other.getMobile()) return false;
        }
        if (hasArchitecture() != other.hasArchitecture()) return false;
        if (hasArchitecture()) {
          if (!getArchitecture()
              .equals(other.getArchitecture())) return false;
        }
        if (hasBitness() != other.hasBitness()) return false;
        if (hasBitness()) {
          if (!getBitness()
              .equals(other.getBitness())) return false;
        }
        if (hasModel() != other.hasModel()) return false;
        if (hasModel()) {
          if (!getModel()
              .equals(other.getModel())) return false;
        }
        if (!unknownFields.equals(other.unknownFields)) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasDEPRECATEDBrowser()) {
          hash = (37 * hash) + DEPRECATED_BROWSER_FIELD_NUMBER;
          hash = (53 * hash) + getDEPRECATEDBrowser().hashCode();
        }
        if (getBrowsersCount() > 0) {
          hash = (37 * hash) + BROWSERS_FIELD_NUMBER;
          hash = (53 * hash) + getBrowsersList().hashCode();
        }
        if (hasPlatform()) {
          hash = (37 * hash) + PLATFORM_FIELD_NUMBER;
          hash = (53 * hash) + getPlatform().hashCode();
        }
        if (hasMobile()) {
          hash = (37 * hash) + MOBILE_FIELD_NUMBER;
          hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
              getMobile());
        }
        if (hasArchitecture()) {
          hash = (37 * hash) + ARCHITECTURE_FIELD_NUMBER;
          hash = (53 * hash) + getArchitecture().hashCode();
        }
        if (hasBitness()) {
          hash = (37 * hash) + BITNESS_FIELD_NUMBER;
          hash = (53 * hash) + getBitness().hashCode();
        }
        if (hasModel()) {
          hash = (37 * hash) + MODEL_FIELD_NUMBER;
          hash = (53 * hash) + getModel().hashCode();
        }
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.protos.adx.NetworkBid.BidRequest.UserAgent parseFrom(
          java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.UserAgent parseFrom(
          java.nio.ByteBuffer data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.UserAgent parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.UserAgent parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.UserAgent parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.UserAgent parseFrom(
          byte[] data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.UserAgent parseFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.UserAgent parseFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.UserAgent parseDelimitedFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.UserAgent parseDelimitedFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.UserAgent parseFrom(
          com.google.protobuf.CodedInputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.UserAgent parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() { return newBuilder(); }
      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }
      public static Builder newBuilder(com.google.protos.adx.NetworkBid.BidRequest.UserAgent prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }
      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE
            ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * <pre>
       * Structured user agent information, which can be used when a client
       * supports User-Agent Client Hints: https://wicg.github.io/ua-client-hints/
       * Note: When available, fields are sourced from Client Hints HTTP headers
       * or equivalent JavaScript accessors from the NavigatorUAData interface.
       * For agents that have no support for User-Agent Client Hints, an exchange
       * can also extract information from the parsed User-Agent header, so this
       * object can always be used as the source of the user agent information.
       * </pre>
       *
       * Protobuf type {@code com.google.protos.adx.BidRequest.UserAgent}
       */
      public static final class Builder extends
          com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
          // @@protoc_insertion_point(builder_implements:com.google.protos.adx.BidRequest.UserAgent)
          com.google.protos.adx.NetworkBid.BidRequest.UserAgentOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
          return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_UserAgent_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_UserAgent_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.protos.adx.NetworkBid.BidRequest.UserAgent.class, com.google.protos.adx.NetworkBid.BidRequest.UserAgent.Builder.class);
        }

        // Construct using com.google.protos.adx.NetworkBid.BidRequest.UserAgent.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }
        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3
                  .alwaysUseFieldBuilders) {
            getDEPRECATEDBrowserFieldBuilder();
            getBrowsersFieldBuilder();
            getPlatformFieldBuilder();
          }
        }
        @java.lang.Override
        public Builder clear() {
          super.clear();
          if (dEPRECATEDBrowserBuilder_ == null) {
            dEPRECATEDBrowser_ = null;
          } else {
            dEPRECATEDBrowserBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000001);
          if (browsersBuilder_ == null) {
            browsers_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            browsersBuilder_.clear();
          }
          if (platformBuilder_ == null) {
            platform_ = null;
          } else {
            platformBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000004);
          mobile_ = false;
          bitField0_ = (bitField0_ & ~0x00000008);
          architecture_ = "";
          bitField0_ = (bitField0_ & ~0x00000010);
          bitness_ = "";
          bitField0_ = (bitField0_ & ~0x00000020);
          model_ = "";
          bitField0_ = (bitField0_ & ~0x00000040);
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
          return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_UserAgent_descriptor;
        }

        @java.lang.Override
        public com.google.protos.adx.NetworkBid.BidRequest.UserAgent getDefaultInstanceForType() {
          return com.google.protos.adx.NetworkBid.BidRequest.UserAgent.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.protos.adx.NetworkBid.BidRequest.UserAgent build() {
          com.google.protos.adx.NetworkBid.BidRequest.UserAgent result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.protos.adx.NetworkBid.BidRequest.UserAgent buildPartial() {
          com.google.protos.adx.NetworkBid.BidRequest.UserAgent result = new com.google.protos.adx.NetworkBid.BidRequest.UserAgent(this);
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            if (dEPRECATEDBrowserBuilder_ == null) {
              result.dEPRECATEDBrowser_ = dEPRECATEDBrowser_;
            } else {
              result.dEPRECATEDBrowser_ = dEPRECATEDBrowserBuilder_.build();
            }
            to_bitField0_ |= 0x00000001;
          }
          if (browsersBuilder_ == null) {
            if (((bitField0_ & 0x00000002) != 0)) {
              browsers_ = java.util.Collections.unmodifiableList(browsers_);
              bitField0_ = (bitField0_ & ~0x00000002);
            }
            result.browsers_ = browsers_;
          } else {
            result.browsers_ = browsersBuilder_.build();
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            if (platformBuilder_ == null) {
              result.platform_ = platform_;
            } else {
              result.platform_ = platformBuilder_.build();
            }
            to_bitField0_ |= 0x00000002;
          }
          if (((from_bitField0_ & 0x00000008) != 0)) {
            result.mobile_ = mobile_;
            to_bitField0_ |= 0x00000004;
          }
          if (((from_bitField0_ & 0x00000010) != 0)) {
            to_bitField0_ |= 0x00000008;
          }
          result.architecture_ = architecture_;
          if (((from_bitField0_ & 0x00000020) != 0)) {
            to_bitField0_ |= 0x00000010;
          }
          result.bitness_ = bitness_;
          if (((from_bitField0_ & 0x00000040) != 0)) {
            to_bitField0_ |= 0x00000020;
          }
          result.model_ = model_;
          result.bitField0_ = to_bitField0_;
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }
        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.setField(field, value);
        }
        @java.lang.Override
        public Builder clearField(
            com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }
        @java.lang.Override
        public Builder clearOneof(
            com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }
        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index, java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }
        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }
        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.protos.adx.NetworkBid.BidRequest.UserAgent) {
            return mergeFrom((com.google.protos.adx.NetworkBid.BidRequest.UserAgent)other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.google.protos.adx.NetworkBid.BidRequest.UserAgent other) {
          if (other == com.google.protos.adx.NetworkBid.BidRequest.UserAgent.getDefaultInstance()) return this;
          if (other.hasDEPRECATEDBrowser()) {
            mergeDEPRECATEDBrowser(other.getDEPRECATEDBrowser());
          }
          if (browsersBuilder_ == null) {
            if (!other.browsers_.isEmpty()) {
              if (browsers_.isEmpty()) {
                browsers_ = other.browsers_;
                bitField0_ = (bitField0_ & ~0x00000002);
              } else {
                ensureBrowsersIsMutable();
                browsers_.addAll(other.browsers_);
              }
              onChanged();
            }
          } else {
            if (!other.browsers_.isEmpty()) {
              if (browsersBuilder_.isEmpty()) {
                browsersBuilder_.dispose();
                browsersBuilder_ = null;
                browsers_ = other.browsers_;
                bitField0_ = (bitField0_ & ~0x00000002);
                browsersBuilder_ = 
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                     getBrowsersFieldBuilder() : null;
              } else {
                browsersBuilder_.addAllMessages(other.browsers_);
              }
            }
          }
          if (other.hasPlatform()) {
            mergePlatform(other.getPlatform());
          }
          if (other.hasMobile()) {
            setMobile(other.getMobile());
          }
          if (other.hasArchitecture()) {
            bitField0_ |= 0x00000010;
            architecture_ = other.architecture_;
            onChanged();
          }
          if (other.hasBitness()) {
            bitField0_ |= 0x00000020;
            bitness_ = other.bitness_;
            onChanged();
          }
          if (other.hasModel()) {
            bitField0_ |= 0x00000040;
            model_ = other.model_;
            onChanged();
          }
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          com.google.protos.adx.NetworkBid.BidRequest.UserAgent parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage = (com.google.protos.adx.NetworkBid.BidRequest.UserAgent) e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }
        private int bitField0_;

        private com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion dEPRECATEDBrowser_;
        private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion, com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion.Builder, com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersionOrBuilder> dEPRECATEDBrowserBuilder_;
        /**
         * <pre>
         * Identifies the browser. Use the new field browsers.
         * </pre>
         *
         * <code>optional .com.google.protos.adx.BidRequest.UserAgent.BrandVersion DEPRECATED_browser = 1 [deprecated = true];</code>
         * @deprecated com.google.protos.adx.BidRequest.UserAgent.DEPRECATED_browser is deprecated.
         *     See network-bid.proto;l=132
         * @return Whether the dEPRECATEDBrowser field is set.
         */
        @java.lang.Deprecated public boolean hasDEPRECATEDBrowser() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         * <pre>
         * Identifies the browser. Use the new field browsers.
         * </pre>
         *
         * <code>optional .com.google.protos.adx.BidRequest.UserAgent.BrandVersion DEPRECATED_browser = 1 [deprecated = true];</code>
         * @deprecated com.google.protos.adx.BidRequest.UserAgent.DEPRECATED_browser is deprecated.
         *     See network-bid.proto;l=132
         * @return The dEPRECATEDBrowser.
         */
        @java.lang.Deprecated public com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion getDEPRECATEDBrowser() {
          if (dEPRECATEDBrowserBuilder_ == null) {
            return dEPRECATEDBrowser_ == null ? com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion.getDefaultInstance() : dEPRECATEDBrowser_;
          } else {
            return dEPRECATEDBrowserBuilder_.getMessage();
          }
        }
        /**
         * <pre>
         * Identifies the browser. Use the new field browsers.
         * </pre>
         *
         * <code>optional .com.google.protos.adx.BidRequest.UserAgent.BrandVersion DEPRECATED_browser = 1 [deprecated = true];</code>
         */
        @java.lang.Deprecated public Builder setDEPRECATEDBrowser(com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion value) {
          if (dEPRECATEDBrowserBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            dEPRECATEDBrowser_ = value;
            onChanged();
          } else {
            dEPRECATEDBrowserBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000001;
          return this;
        }
        /**
         * <pre>
         * Identifies the browser. Use the new field browsers.
         * </pre>
         *
         * <code>optional .com.google.protos.adx.BidRequest.UserAgent.BrandVersion DEPRECATED_browser = 1 [deprecated = true];</code>
         */
        @java.lang.Deprecated public Builder setDEPRECATEDBrowser(
            com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion.Builder builderForValue) {
          if (dEPRECATEDBrowserBuilder_ == null) {
            dEPRECATEDBrowser_ = builderForValue.build();
            onChanged();
          } else {
            dEPRECATEDBrowserBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000001;
          return this;
        }
        /**
         * <pre>
         * Identifies the browser. Use the new field browsers.
         * </pre>
         *
         * <code>optional .com.google.protos.adx.BidRequest.UserAgent.BrandVersion DEPRECATED_browser = 1 [deprecated = true];</code>
         */
        @java.lang.Deprecated public Builder mergeDEPRECATEDBrowser(com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion value) {
          if (dEPRECATEDBrowserBuilder_ == null) {
            if (((bitField0_ & 0x00000001) != 0) &&
                dEPRECATEDBrowser_ != null &&
                dEPRECATEDBrowser_ != com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion.getDefaultInstance()) {
              dEPRECATEDBrowser_ =
                com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion.newBuilder(dEPRECATEDBrowser_).mergeFrom(value).buildPartial();
            } else {
              dEPRECATEDBrowser_ = value;
            }
            onChanged();
          } else {
            dEPRECATEDBrowserBuilder_.mergeFrom(value);
          }
          bitField0_ |= 0x00000001;
          return this;
        }
        /**
         * <pre>
         * Identifies the browser. Use the new field browsers.
         * </pre>
         *
         * <code>optional .com.google.protos.adx.BidRequest.UserAgent.BrandVersion DEPRECATED_browser = 1 [deprecated = true];</code>
         */
        @java.lang.Deprecated public Builder clearDEPRECATEDBrowser() {
          if (dEPRECATEDBrowserBuilder_ == null) {
            dEPRECATEDBrowser_ = null;
            onChanged();
          } else {
            dEPRECATEDBrowserBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000001);
          return this;
        }
        /**
         * <pre>
         * Identifies the browser. Use the new field browsers.
         * </pre>
         *
         * <code>optional .com.google.protos.adx.BidRequest.UserAgent.BrandVersion DEPRECATED_browser = 1 [deprecated = true];</code>
         */
        @java.lang.Deprecated public com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion.Builder getDEPRECATEDBrowserBuilder() {
          bitField0_ |= 0x00000001;
          onChanged();
          return getDEPRECATEDBrowserFieldBuilder().getBuilder();
        }
        /**
         * <pre>
         * Identifies the browser. Use the new field browsers.
         * </pre>
         *
         * <code>optional .com.google.protos.adx.BidRequest.UserAgent.BrandVersion DEPRECATED_browser = 1 [deprecated = true];</code>
         */
        @java.lang.Deprecated public com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersionOrBuilder getDEPRECATEDBrowserOrBuilder() {
          if (dEPRECATEDBrowserBuilder_ != null) {
            return dEPRECATEDBrowserBuilder_.getMessageOrBuilder();
          } else {
            return dEPRECATEDBrowser_ == null ?
                com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion.getDefaultInstance() : dEPRECATEDBrowser_;
          }
        }
        /**
         * <pre>
         * Identifies the browser. Use the new field browsers.
         * </pre>
         *
         * <code>optional .com.google.protos.adx.BidRequest.UserAgent.BrandVersion DEPRECATED_browser = 1 [deprecated = true];</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion, com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion.Builder, com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersionOrBuilder> 
            getDEPRECATEDBrowserFieldBuilder() {
          if (dEPRECATEDBrowserBuilder_ == null) {
            dEPRECATEDBrowserBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion, com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion.Builder, com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersionOrBuilder>(
                    getDEPRECATEDBrowser(),
                    getParentForChildren(),
                    isClean());
            dEPRECATEDBrowser_ = null;
          }
          return dEPRECATEDBrowserBuilder_;
        }

        private java.util.List<com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion> browsers_ =
          java.util.Collections.emptyList();
        private void ensureBrowsersIsMutable() {
          if (!((bitField0_ & 0x00000002) != 0)) {
            browsers_ = new java.util.ArrayList<com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion>(browsers_);
            bitField0_ |= 0x00000002;
           }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion, com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion.Builder, com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersionOrBuilder> browsersBuilder_;

        /**
         * <pre>
         * Each BrandVersion object identifies a browser or similar software
         * component. Exchanges should send brands and versions derived from
         * the Sec-CH-UA-Full-Version-List header.
         * </pre>
         *
         * <code>repeated .com.google.protos.adx.BidRequest.UserAgent.BrandVersion browsers = 8;</code>
         */
        public java.util.List<com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion> getBrowsersList() {
          if (browsersBuilder_ == null) {
            return java.util.Collections.unmodifiableList(browsers_);
          } else {
            return browsersBuilder_.getMessageList();
          }
        }
        /**
         * <pre>
         * Each BrandVersion object identifies a browser or similar software
         * component. Exchanges should send brands and versions derived from
         * the Sec-CH-UA-Full-Version-List header.
         * </pre>
         *
         * <code>repeated .com.google.protos.adx.BidRequest.UserAgent.BrandVersion browsers = 8;</code>
         */
        public int getBrowsersCount() {
          if (browsersBuilder_ == null) {
            return browsers_.size();
          } else {
            return browsersBuilder_.getCount();
          }
        }
        /**
         * <pre>
         * Each BrandVersion object identifies a browser or similar software
         * component. Exchanges should send brands and versions derived from
         * the Sec-CH-UA-Full-Version-List header.
         * </pre>
         *
         * <code>repeated .com.google.protos.adx.BidRequest.UserAgent.BrandVersion browsers = 8;</code>
         */
        public com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion getBrowsers(int index) {
          if (browsersBuilder_ == null) {
            return browsers_.get(index);
          } else {
            return browsersBuilder_.getMessage(index);
          }
        }
        /**
         * <pre>
         * Each BrandVersion object identifies a browser or similar software
         * component. Exchanges should send brands and versions derived from
         * the Sec-CH-UA-Full-Version-List header.
         * </pre>
         *
         * <code>repeated .com.google.protos.adx.BidRequest.UserAgent.BrandVersion browsers = 8;</code>
         */
        public Builder setBrowsers(
            int index, com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion value) {
          if (browsersBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureBrowsersIsMutable();
            browsers_.set(index, value);
            onChanged();
          } else {
            browsersBuilder_.setMessage(index, value);
          }
          return this;
        }
        /**
         * <pre>
         * Each BrandVersion object identifies a browser or similar software
         * component. Exchanges should send brands and versions derived from
         * the Sec-CH-UA-Full-Version-List header.
         * </pre>
         *
         * <code>repeated .com.google.protos.adx.BidRequest.UserAgent.BrandVersion browsers = 8;</code>
         */
        public Builder setBrowsers(
            int index, com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion.Builder builderForValue) {
          if (browsersBuilder_ == null) {
            ensureBrowsersIsMutable();
            browsers_.set(index, builderForValue.build());
            onChanged();
          } else {
            browsersBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         * <pre>
         * Each BrandVersion object identifies a browser or similar software
         * component. Exchanges should send brands and versions derived from
         * the Sec-CH-UA-Full-Version-List header.
         * </pre>
         *
         * <code>repeated .com.google.protos.adx.BidRequest.UserAgent.BrandVersion browsers = 8;</code>
         */
        public Builder addBrowsers(com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion value) {
          if (browsersBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureBrowsersIsMutable();
            browsers_.add(value);
            onChanged();
          } else {
            browsersBuilder_.addMessage(value);
          }
          return this;
        }
        /**
         * <pre>
         * Each BrandVersion object identifies a browser or similar software
         * component. Exchanges should send brands and versions derived from
         * the Sec-CH-UA-Full-Version-List header.
         * </pre>
         *
         * <code>repeated .com.google.protos.adx.BidRequest.UserAgent.BrandVersion browsers = 8;</code>
         */
        public Builder addBrowsers(
            int index, com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion value) {
          if (browsersBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureBrowsersIsMutable();
            browsers_.add(index, value);
            onChanged();
          } else {
            browsersBuilder_.addMessage(index, value);
          }
          return this;
        }
        /**
         * <pre>
         * Each BrandVersion object identifies a browser or similar software
         * component. Exchanges should send brands and versions derived from
         * the Sec-CH-UA-Full-Version-List header.
         * </pre>
         *
         * <code>repeated .com.google.protos.adx.BidRequest.UserAgent.BrandVersion browsers = 8;</code>
         */
        public Builder addBrowsers(
            com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion.Builder builderForValue) {
          if (browsersBuilder_ == null) {
            ensureBrowsersIsMutable();
            browsers_.add(builderForValue.build());
            onChanged();
          } else {
            browsersBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }
        /**
         * <pre>
         * Each BrandVersion object identifies a browser or similar software
         * component. Exchanges should send brands and versions derived from
         * the Sec-CH-UA-Full-Version-List header.
         * </pre>
         *
         * <code>repeated .com.google.protos.adx.BidRequest.UserAgent.BrandVersion browsers = 8;</code>
         */
        public Builder addBrowsers(
            int index, com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion.Builder builderForValue) {
          if (browsersBuilder_ == null) {
            ensureBrowsersIsMutable();
            browsers_.add(index, builderForValue.build());
            onChanged();
          } else {
            browsersBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         * <pre>
         * Each BrandVersion object identifies a browser or similar software
         * component. Exchanges should send brands and versions derived from
         * the Sec-CH-UA-Full-Version-List header.
         * </pre>
         *
         * <code>repeated .com.google.protos.adx.BidRequest.UserAgent.BrandVersion browsers = 8;</code>
         */
        public Builder addAllBrowsers(
            java.lang.Iterable<? extends com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion> values) {
          if (browsersBuilder_ == null) {
            ensureBrowsersIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(
                values, browsers_);
            onChanged();
          } else {
            browsersBuilder_.addAllMessages(values);
          }
          return this;
        }
        /**
         * <pre>
         * Each BrandVersion object identifies a browser or similar software
         * component. Exchanges should send brands and versions derived from
         * the Sec-CH-UA-Full-Version-List header.
         * </pre>
         *
         * <code>repeated .com.google.protos.adx.BidRequest.UserAgent.BrandVersion browsers = 8;</code>
         */
        public Builder clearBrowsers() {
          if (browsersBuilder_ == null) {
            browsers_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000002);
            onChanged();
          } else {
            browsersBuilder_.clear();
          }
          return this;
        }
        /**
         * <pre>
         * Each BrandVersion object identifies a browser or similar software
         * component. Exchanges should send brands and versions derived from
         * the Sec-CH-UA-Full-Version-List header.
         * </pre>
         *
         * <code>repeated .com.google.protos.adx.BidRequest.UserAgent.BrandVersion browsers = 8;</code>
         */
        public Builder removeBrowsers(int index) {
          if (browsersBuilder_ == null) {
            ensureBrowsersIsMutable();
            browsers_.remove(index);
            onChanged();
          } else {
            browsersBuilder_.remove(index);
          }
          return this;
        }
        /**
         * <pre>
         * Each BrandVersion object identifies a browser or similar software
         * component. Exchanges should send brands and versions derived from
         * the Sec-CH-UA-Full-Version-List header.
         * </pre>
         *
         * <code>repeated .com.google.protos.adx.BidRequest.UserAgent.BrandVersion browsers = 8;</code>
         */
        public com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion.Builder getBrowsersBuilder(
            int index) {
          return getBrowsersFieldBuilder().getBuilder(index);
        }
        /**
         * <pre>
         * Each BrandVersion object identifies a browser or similar software
         * component. Exchanges should send brands and versions derived from
         * the Sec-CH-UA-Full-Version-List header.
         * </pre>
         *
         * <code>repeated .com.google.protos.adx.BidRequest.UserAgent.BrandVersion browsers = 8;</code>
         */
        public com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersionOrBuilder getBrowsersOrBuilder(
            int index) {
          if (browsersBuilder_ == null) {
            return browsers_.get(index);  } else {
            return browsersBuilder_.getMessageOrBuilder(index);
          }
        }
        /**
         * <pre>
         * Each BrandVersion object identifies a browser or similar software
         * component. Exchanges should send brands and versions derived from
         * the Sec-CH-UA-Full-Version-List header.
         * </pre>
         *
         * <code>repeated .com.google.protos.adx.BidRequest.UserAgent.BrandVersion browsers = 8;</code>
         */
        public java.util.List<? extends com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersionOrBuilder> 
             getBrowsersOrBuilderList() {
          if (browsersBuilder_ != null) {
            return browsersBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(browsers_);
          }
        }
        /**
         * <pre>
         * Each BrandVersion object identifies a browser or similar software
         * component. Exchanges should send brands and versions derived from
         * the Sec-CH-UA-Full-Version-List header.
         * </pre>
         *
         * <code>repeated .com.google.protos.adx.BidRequest.UserAgent.BrandVersion browsers = 8;</code>
         */
        public com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion.Builder addBrowsersBuilder() {
          return getBrowsersFieldBuilder().addBuilder(
              com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion.getDefaultInstance());
        }
        /**
         * <pre>
         * Each BrandVersion object identifies a browser or similar software
         * component. Exchanges should send brands and versions derived from
         * the Sec-CH-UA-Full-Version-List header.
         * </pre>
         *
         * <code>repeated .com.google.protos.adx.BidRequest.UserAgent.BrandVersion browsers = 8;</code>
         */
        public com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion.Builder addBrowsersBuilder(
            int index) {
          return getBrowsersFieldBuilder().addBuilder(
              index, com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion.getDefaultInstance());
        }
        /**
         * <pre>
         * Each BrandVersion object identifies a browser or similar software
         * component. Exchanges should send brands and versions derived from
         * the Sec-CH-UA-Full-Version-List header.
         * </pre>
         *
         * <code>repeated .com.google.protos.adx.BidRequest.UserAgent.BrandVersion browsers = 8;</code>
         */
        public java.util.List<com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion.Builder> 
             getBrowsersBuilderList() {
          return getBrowsersFieldBuilder().getBuilderList();
        }
        private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion, com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion.Builder, com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersionOrBuilder> 
            getBrowsersFieldBuilder() {
          if (browsersBuilder_ == null) {
            browsersBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion, com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion.Builder, com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersionOrBuilder>(
                    browsers_,
                    ((bitField0_ & 0x00000002) != 0),
                    getParentForChildren(),
                    isClean());
            browsers_ = null;
          }
          return browsersBuilder_;
        }

        private com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion platform_;
        private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion, com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion.Builder, com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersionOrBuilder> platformBuilder_;
        /**
         * <pre>
         * Identifies the user agent's execution platform / OS. Exchanges should
         * send a brand derived from the Sec-CH-UA-Platform header, and version
         * derived from the Sec-CH-UAPlatform-Version header.
         * </pre>
         *
         * <code>optional .com.google.protos.adx.BidRequest.UserAgent.BrandVersion platform = 2;</code>
         * @return Whether the platform field is set.
         */
        public boolean hasPlatform() {
          return ((bitField0_ & 0x00000004) != 0);
        }
        /**
         * <pre>
         * Identifies the user agent's execution platform / OS. Exchanges should
         * send a brand derived from the Sec-CH-UA-Platform header, and version
         * derived from the Sec-CH-UAPlatform-Version header.
         * </pre>
         *
         * <code>optional .com.google.protos.adx.BidRequest.UserAgent.BrandVersion platform = 2;</code>
         * @return The platform.
         */
        public com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion getPlatform() {
          if (platformBuilder_ == null) {
            return platform_ == null ? com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion.getDefaultInstance() : platform_;
          } else {
            return platformBuilder_.getMessage();
          }
        }
        /**
         * <pre>
         * Identifies the user agent's execution platform / OS. Exchanges should
         * send a brand derived from the Sec-CH-UA-Platform header, and version
         * derived from the Sec-CH-UAPlatform-Version header.
         * </pre>
         *
         * <code>optional .com.google.protos.adx.BidRequest.UserAgent.BrandVersion platform = 2;</code>
         */
        public Builder setPlatform(com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion value) {
          if (platformBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            platform_ = value;
            onChanged();
          } else {
            platformBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000004;
          return this;
        }
        /**
         * <pre>
         * Identifies the user agent's execution platform / OS. Exchanges should
         * send a brand derived from the Sec-CH-UA-Platform header, and version
         * derived from the Sec-CH-UAPlatform-Version header.
         * </pre>
         *
         * <code>optional .com.google.protos.adx.BidRequest.UserAgent.BrandVersion platform = 2;</code>
         */
        public Builder setPlatform(
            com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion.Builder builderForValue) {
          if (platformBuilder_ == null) {
            platform_ = builderForValue.build();
            onChanged();
          } else {
            platformBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000004;
          return this;
        }
        /**
         * <pre>
         * Identifies the user agent's execution platform / OS. Exchanges should
         * send a brand derived from the Sec-CH-UA-Platform header, and version
         * derived from the Sec-CH-UAPlatform-Version header.
         * </pre>
         *
         * <code>optional .com.google.protos.adx.BidRequest.UserAgent.BrandVersion platform = 2;</code>
         */
        public Builder mergePlatform(com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion value) {
          if (platformBuilder_ == null) {
            if (((bitField0_ & 0x00000004) != 0) &&
                platform_ != null &&
                platform_ != com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion.getDefaultInstance()) {
              platform_ =
                com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion.newBuilder(platform_).mergeFrom(value).buildPartial();
            } else {
              platform_ = value;
            }
            onChanged();
          } else {
            platformBuilder_.mergeFrom(value);
          }
          bitField0_ |= 0x00000004;
          return this;
        }
        /**
         * <pre>
         * Identifies the user agent's execution platform / OS. Exchanges should
         * send a brand derived from the Sec-CH-UA-Platform header, and version
         * derived from the Sec-CH-UAPlatform-Version header.
         * </pre>
         *
         * <code>optional .com.google.protos.adx.BidRequest.UserAgent.BrandVersion platform = 2;</code>
         */
        public Builder clearPlatform() {
          if (platformBuilder_ == null) {
            platform_ = null;
            onChanged();
          } else {
            platformBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000004);
          return this;
        }
        /**
         * <pre>
         * Identifies the user agent's execution platform / OS. Exchanges should
         * send a brand derived from the Sec-CH-UA-Platform header, and version
         * derived from the Sec-CH-UAPlatform-Version header.
         * </pre>
         *
         * <code>optional .com.google.protos.adx.BidRequest.UserAgent.BrandVersion platform = 2;</code>
         */
        public com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion.Builder getPlatformBuilder() {
          bitField0_ |= 0x00000004;
          onChanged();
          return getPlatformFieldBuilder().getBuilder();
        }
        /**
         * <pre>
         * Identifies the user agent's execution platform / OS. Exchanges should
         * send a brand derived from the Sec-CH-UA-Platform header, and version
         * derived from the Sec-CH-UAPlatform-Version header.
         * </pre>
         *
         * <code>optional .com.google.protos.adx.BidRequest.UserAgent.BrandVersion platform = 2;</code>
         */
        public com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersionOrBuilder getPlatformOrBuilder() {
          if (platformBuilder_ != null) {
            return platformBuilder_.getMessageOrBuilder();
          } else {
            return platform_ == null ?
                com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion.getDefaultInstance() : platform_;
          }
        }
        /**
         * <pre>
         * Identifies the user agent's execution platform / OS. Exchanges should
         * send a brand derived from the Sec-CH-UA-Platform header, and version
         * derived from the Sec-CH-UAPlatform-Version header.
         * </pre>
         *
         * <code>optional .com.google.protos.adx.BidRequest.UserAgent.BrandVersion platform = 2;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion, com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion.Builder, com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersionOrBuilder> 
            getPlatformFieldBuilder() {
          if (platformBuilder_ == null) {
            platformBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion, com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersion.Builder, com.google.protos.adx.NetworkBid.BidRequest.UserAgent.BrandVersionOrBuilder>(
                    getPlatform(),
                    getParentForChildren(),
                    isClean());
            platform_ = null;
          }
          return platformBuilder_;
        }

        private boolean mobile_ ;
        /**
         * <pre>
         * True if the agent prefers a "mobile" version of the content if
         * available, i.e. optimized for small screens or touch input. False if
         * the agent prefers the "desktop" or "full" content. Exchanges should
         * derive this value from the Sec-CH-UAMobile header.
         * </pre>
         *
         * <code>optional bool mobile = 3;</code>
         * @return Whether the mobile field is set.
         */
        @java.lang.Override
        public boolean hasMobile() {
          return ((bitField0_ & 0x00000008) != 0);
        }
        /**
         * <pre>
         * True if the agent prefers a "mobile" version of the content if
         * available, i.e. optimized for small screens or touch input. False if
         * the agent prefers the "desktop" or "full" content. Exchanges should
         * derive this value from the Sec-CH-UAMobile header.
         * </pre>
         *
         * <code>optional bool mobile = 3;</code>
         * @return The mobile.
         */
        @java.lang.Override
        public boolean getMobile() {
          return mobile_;
        }
        /**
         * <pre>
         * True if the agent prefers a "mobile" version of the content if
         * available, i.e. optimized for small screens or touch input. False if
         * the agent prefers the "desktop" or "full" content. Exchanges should
         * derive this value from the Sec-CH-UAMobile header.
         * </pre>
         *
         * <code>optional bool mobile = 3;</code>
         * @param value The mobile to set.
         * @return This builder for chaining.
         */
        public Builder setMobile(boolean value) {
          bitField0_ |= 0x00000008;
          mobile_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * True if the agent prefers a "mobile" version of the content if
         * available, i.e. optimized for small screens or touch input. False if
         * the agent prefers the "desktop" or "full" content. Exchanges should
         * derive this value from the Sec-CH-UAMobile header.
         * </pre>
         *
         * <code>optional bool mobile = 3;</code>
         * @return This builder for chaining.
         */
        public Builder clearMobile() {
          bitField0_ = (bitField0_ & ~0x00000008);
          mobile_ = false;
          onChanged();
          return this;
        }

        private java.lang.Object architecture_ = "";
        /**
         * <pre>
         * Device's major binary architecture, e.g. "x86" or "arm". Exchanges
         * should retrieve this value from the Sec-CH-UA-Arch header.
         * </pre>
         *
         * <code>optional string architecture = 4;</code>
         * @return Whether the architecture field is set.
         */
        public boolean hasArchitecture() {
          return ((bitField0_ & 0x00000010) != 0);
        }
        /**
         * <pre>
         * Device's major binary architecture, e.g. "x86" or "arm". Exchanges
         * should retrieve this value from the Sec-CH-UA-Arch header.
         * </pre>
         *
         * <code>optional string architecture = 4;</code>
         * @return The architecture.
         */
        public java.lang.String getArchitecture() {
          java.lang.Object ref = architecture_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs =
                (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            if (bs.isValidUtf8()) {
              architecture_ = s;
            }
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         * <pre>
         * Device's major binary architecture, e.g. "x86" or "arm". Exchanges
         * should retrieve this value from the Sec-CH-UA-Arch header.
         * </pre>
         *
         * <code>optional string architecture = 4;</code>
         * @return The bytes for architecture.
         */
        public com.google.protobuf.ByteString
            getArchitectureBytes() {
          java.lang.Object ref = architecture_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b = 
                com.google.protobuf.ByteString.copyFromUtf8(
                    (java.lang.String) ref);
            architecture_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         * <pre>
         * Device's major binary architecture, e.g. "x86" or "arm". Exchanges
         * should retrieve this value from the Sec-CH-UA-Arch header.
         * </pre>
         *
         * <code>optional string architecture = 4;</code>
         * @param value The architecture to set.
         * @return This builder for chaining.
         */
        public Builder setArchitecture(
            java.lang.String value) {
          if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000010;
          architecture_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Device's major binary architecture, e.g. "x86" or "arm". Exchanges
         * should retrieve this value from the Sec-CH-UA-Arch header.
         * </pre>
         *
         * <code>optional string architecture = 4;</code>
         * @return This builder for chaining.
         */
        public Builder clearArchitecture() {
          bitField0_ = (bitField0_ & ~0x00000010);
          architecture_ = getDefaultInstance().getArchitecture();
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Device's major binary architecture, e.g. "x86" or "arm". Exchanges
         * should retrieve this value from the Sec-CH-UA-Arch header.
         * </pre>
         *
         * <code>optional string architecture = 4;</code>
         * @param value The bytes for architecture to set.
         * @return This builder for chaining.
         */
        public Builder setArchitectureBytes(
            com.google.protobuf.ByteString value) {
          if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000010;
          architecture_ = value;
          onChanged();
          return this;
        }

        private java.lang.Object bitness_ = "";
        /**
         * <pre>
         * Device's bitness, e.g. "64" for 64-bit architecture. Exchanges should
         * retrieve this value from the Sec-CH-UA-Bitness header.
         * </pre>
         *
         * <code>optional string bitness = 9;</code>
         * @return Whether the bitness field is set.
         */
        public boolean hasBitness() {
          return ((bitField0_ & 0x00000020) != 0);
        }
        /**
         * <pre>
         * Device's bitness, e.g. "64" for 64-bit architecture. Exchanges should
         * retrieve this value from the Sec-CH-UA-Bitness header.
         * </pre>
         *
         * <code>optional string bitness = 9;</code>
         * @return The bitness.
         */
        public java.lang.String getBitness() {
          java.lang.Object ref = bitness_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs =
                (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            if (bs.isValidUtf8()) {
              bitness_ = s;
            }
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         * <pre>
         * Device's bitness, e.g. "64" for 64-bit architecture. Exchanges should
         * retrieve this value from the Sec-CH-UA-Bitness header.
         * </pre>
         *
         * <code>optional string bitness = 9;</code>
         * @return The bytes for bitness.
         */
        public com.google.protobuf.ByteString
            getBitnessBytes() {
          java.lang.Object ref = bitness_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b = 
                com.google.protobuf.ByteString.copyFromUtf8(
                    (java.lang.String) ref);
            bitness_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         * <pre>
         * Device's bitness, e.g. "64" for 64-bit architecture. Exchanges should
         * retrieve this value from the Sec-CH-UA-Bitness header.
         * </pre>
         *
         * <code>optional string bitness = 9;</code>
         * @param value The bitness to set.
         * @return This builder for chaining.
         */
        public Builder setBitness(
            java.lang.String value) {
          if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000020;
          bitness_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Device's bitness, e.g. "64" for 64-bit architecture. Exchanges should
         * retrieve this value from the Sec-CH-UA-Bitness header.
         * </pre>
         *
         * <code>optional string bitness = 9;</code>
         * @return This builder for chaining.
         */
        public Builder clearBitness() {
          bitField0_ = (bitField0_ & ~0x00000020);
          bitness_ = getDefaultInstance().getBitness();
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Device's bitness, e.g. "64" for 64-bit architecture. Exchanges should
         * retrieve this value from the Sec-CH-UA-Bitness header.
         * </pre>
         *
         * <code>optional string bitness = 9;</code>
         * @param value The bytes for bitness to set.
         * @return This builder for chaining.
         */
        public Builder setBitnessBytes(
            com.google.protobuf.ByteString value) {
          if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000020;
          bitness_ = value;
          onChanged();
          return this;
        }

        private java.lang.Object model_ = "";
        /**
         * <pre>
         * Device model. Exchanges should retrieve this value from the
         * Sec-CH-UAModel header.
         * </pre>
         *
         * <code>optional string model = 5;</code>
         * @return Whether the model field is set.
         */
        public boolean hasModel() {
          return ((bitField0_ & 0x00000040) != 0);
        }
        /**
         * <pre>
         * Device model. Exchanges should retrieve this value from the
         * Sec-CH-UAModel header.
         * </pre>
         *
         * <code>optional string model = 5;</code>
         * @return The model.
         */
        public java.lang.String getModel() {
          java.lang.Object ref = model_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs =
                (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            if (bs.isValidUtf8()) {
              model_ = s;
            }
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         * <pre>
         * Device model. Exchanges should retrieve this value from the
         * Sec-CH-UAModel header.
         * </pre>
         *
         * <code>optional string model = 5;</code>
         * @return The bytes for model.
         */
        public com.google.protobuf.ByteString
            getModelBytes() {
          java.lang.Object ref = model_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b = 
                com.google.protobuf.ByteString.copyFromUtf8(
                    (java.lang.String) ref);
            model_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         * <pre>
         * Device model. Exchanges should retrieve this value from the
         * Sec-CH-UAModel header.
         * </pre>
         *
         * <code>optional string model = 5;</code>
         * @param value The model to set.
         * @return This builder for chaining.
         */
        public Builder setModel(
            java.lang.String value) {
          if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000040;
          model_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Device model. Exchanges should retrieve this value from the
         * Sec-CH-UAModel header.
         * </pre>
         *
         * <code>optional string model = 5;</code>
         * @return This builder for chaining.
         */
        public Builder clearModel() {
          bitField0_ = (bitField0_ & ~0x00000040);
          model_ = getDefaultInstance().getModel();
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Device model. Exchanges should retrieve this value from the
         * Sec-CH-UAModel header.
         * </pre>
         *
         * <code>optional string model = 5;</code>
         * @param value The bytes for model to set.
         * @return This builder for chaining.
         */
        public Builder setModelBytes(
            com.google.protobuf.ByteString value) {
          if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000040;
          model_ = value;
          onChanged();
          return this;
        }
        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }


        // @@protoc_insertion_point(builder_scope:com.google.protos.adx.BidRequest.UserAgent)
      }

      // @@protoc_insertion_point(class_scope:com.google.protos.adx.BidRequest.UserAgent)
      private static final com.google.protos.adx.NetworkBid.BidRequest.UserAgent DEFAULT_INSTANCE;
      static {
        DEFAULT_INSTANCE = new com.google.protos.adx.NetworkBid.BidRequest.UserAgent();
      }

      public static com.google.protos.adx.NetworkBid.BidRequest.UserAgent getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      @java.lang.Deprecated public static final com.google.protobuf.Parser<UserAgent>
          PARSER = new com.google.protobuf.AbstractParser<UserAgent>() {
        @java.lang.Override
        public UserAgent parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new UserAgent(input, extensionRegistry);
        }
      };

      public static com.google.protobuf.Parser<UserAgent> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<UserAgent> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protos.adx.NetworkBid.BidRequest.UserAgent getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }

    }

    public interface GeoOrBuilder extends
        // @@protoc_insertion_point(interface_extends:com.google.protos.adx.BidRequest.Geo)
        com.google.protobuf.MessageOrBuilder {

      /**
       * <pre>
       * Latitude from -90.0 to +90.0, where negative is south.
       * </pre>
       *
       * <code>optional double lat = 1;</code>
       * @return Whether the lat field is set.
       */
      boolean hasLat();
      /**
       * <pre>
       * Latitude from -90.0 to +90.0, where negative is south.
       * </pre>
       *
       * <code>optional double lat = 1;</code>
       * @return The lat.
       */
      double getLat();

      /**
       * <pre>
       * Longitude from -180.0 to +180.0, where negative is west.
       * </pre>
       *
       * <code>optional double lon = 2;</code>
       * @return Whether the lon field is set.
       */
      boolean hasLon();
      /**
       * <pre>
       * Longitude from -180.0 to +180.0, where negative is west.
       * </pre>
       *
       * <code>optional double lon = 2;</code>
       * @return The lon.
       */
      double getLon();

      /**
       * <pre>
       * Country using ISO-3166-1 Alpha-3.
       * </pre>
       *
       * <code>optional string country = 3;</code>
       * @return Whether the country field is set.
       */
      boolean hasCountry();
      /**
       * <pre>
       * Country using ISO-3166-1 Alpha-3.
       * </pre>
       *
       * <code>optional string country = 3;</code>
       * @return The country.
       */
      java.lang.String getCountry();
      /**
       * <pre>
       * Country using ISO-3166-1 Alpha-3.
       * </pre>
       *
       * <code>optional string country = 3;</code>
       * @return The bytes for country.
       */
      com.google.protobuf.ByteString
          getCountryBytes();

      /**
       * <pre>
       * Region code using ISO-3166-2; 2-letter state code if USA.
       * </pre>
       *
       * <code>optional string region = 4;</code>
       * @return Whether the region field is set.
       */
      boolean hasRegion();
      /**
       * <pre>
       * Region code using ISO-3166-2; 2-letter state code if USA.
       * </pre>
       *
       * <code>optional string region = 4;</code>
       * @return The region.
       */
      java.lang.String getRegion();
      /**
       * <pre>
       * Region code using ISO-3166-2; 2-letter state code if USA.
       * </pre>
       *
       * <code>optional string region = 4;</code>
       * @return The bytes for region.
       */
      com.google.protobuf.ByteString
          getRegionBytes();

      /**
       * <pre>
       * Google metro code; similar to but not exactly Nielsen DMAs.
       * </pre>
       *
       * <code>optional string metro = 6;</code>
       * @return Whether the metro field is set.
       */
      boolean hasMetro();
      /**
       * <pre>
       * Google metro code; similar to but not exactly Nielsen DMAs.
       * </pre>
       *
       * <code>optional string metro = 6;</code>
       * @return The metro.
       */
      java.lang.String getMetro();
      /**
       * <pre>
       * Google metro code; similar to but not exactly Nielsen DMAs.
       * </pre>
       *
       * <code>optional string metro = 6;</code>
       * @return The bytes for metro.
       */
      com.google.protobuf.ByteString
          getMetroBytes();

      /**
       * <pre>
       * City using United Nations Code for Trade &amp; Transport Locations.
       * (https://www.unece.org/cefact/locode/service/location.htm).
       * </pre>
       *
       * <code>optional string city = 7;</code>
       * @return Whether the city field is set.
       */
      boolean hasCity();
      /**
       * <pre>
       * City using United Nations Code for Trade &amp; Transport Locations.
       * (https://www.unece.org/cefact/locode/service/location.htm).
       * </pre>
       *
       * <code>optional string city = 7;</code>
       * @return The city.
       */
      java.lang.String getCity();
      /**
       * <pre>
       * City using United Nations Code for Trade &amp; Transport Locations.
       * (https://www.unece.org/cefact/locode/service/location.htm).
       * </pre>
       *
       * <code>optional string city = 7;</code>
       * @return The bytes for city.
       */
      com.google.protobuf.ByteString
          getCityBytes();

      /**
       * <pre>
       * Zip/postal code.
       * </pre>
       *
       * <code>optional string zip = 8;</code>
       * @return Whether the zip field is set.
       */
      boolean hasZip();
      /**
       * <pre>
       * Zip/postal code.
       * </pre>
       *
       * <code>optional string zip = 8;</code>
       * @return The zip.
       */
      java.lang.String getZip();
      /**
       * <pre>
       * Zip/postal code.
       * </pre>
       *
       * <code>optional string zip = 8;</code>
       * @return The bytes for zip.
       */
      com.google.protobuf.ByteString
          getZipBytes();

      /**
       * <pre>
       * Estimated location accuracy in meters.
       * </pre>
       *
       * <code>optional int32 accuracy = 11;</code>
       * @return Whether the accuracy field is set.
       */
      boolean hasAccuracy();
      /**
       * <pre>
       * Estimated location accuracy in meters.
       * </pre>
       *
       * <code>optional int32 accuracy = 11;</code>
       * @return The accuracy.
       */
      int getAccuracy();

      /**
       * <pre>
       * Local time as the number +/- of minutes from UTC.
       * </pre>
       *
       * <code>optional int32 utcoffset = 10;</code>
       * @return Whether the utcoffset field is set.
       */
      boolean hasUtcoffset();
      /**
       * <pre>
       * Local time as the number +/- of minutes from UTC.
       * </pre>
       *
       * <code>optional int32 utcoffset = 10;</code>
       * @return The utcoffset.
       */
      int getUtcoffset();
    }
    /**
     * <pre>
     * The user's approximate geographic location. All location information is
     * IP geolocation-derived.  The lat/lon fields may be a reference position
     * (e.g. centroid) for the IP geolocation-derived location that's also carried
     * by the other fields (e.g. a city), and accuracy will be the radius of a
     * circle with the approximate area of that location. Location and its
     * accuracy will be fuzzified as necessary to protect user privacy.
     * See Geotargeting Guide:
     * https://developers.google.com/authorized-buyers/rtb/geotargeting
     * </pre>
     *
     * Protobuf type {@code com.google.protos.adx.BidRequest.Geo}
     */
    public static final class Geo extends
        com.google.protobuf.GeneratedMessageV3 implements
        // @@protoc_insertion_point(message_implements:com.google.protos.adx.BidRequest.Geo)
        GeoOrBuilder {
    private static final long serialVersionUID = 0L;
      // Use Geo.newBuilder() to construct.
      private Geo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }
      private Geo() {
        country_ = "";
        region_ = "";
        metro_ = "";
        city_ = "";
        zip_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(
          UnusedPrivateParameter unused) {
        return new Geo();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet
      getUnknownFields() {
        return this.unknownFields;
      }
      private Geo(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        int mutable_bitField0_ = 0;
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 9: {
                bitField0_ |= 0x00000001;
                lat_ = input.readDouble();
                break;
              }
              case 17: {
                bitField0_ |= 0x00000002;
                lon_ = input.readDouble();
                break;
              }
              case 26: {
                com.google.protobuf.ByteString bs = input.readBytes();
                bitField0_ |= 0x00000004;
                country_ = bs;
                break;
              }
              case 34: {
                com.google.protobuf.ByteString bs = input.readBytes();
                bitField0_ |= 0x00000008;
                region_ = bs;
                break;
              }
              case 50: {
                com.google.protobuf.ByteString bs = input.readBytes();
                bitField0_ |= 0x00000010;
                metro_ = bs;
                break;
              }
              case 58: {
                com.google.protobuf.ByteString bs = input.readBytes();
                bitField0_ |= 0x00000020;
                city_ = bs;
                break;
              }
              case 66: {
                com.google.protobuf.ByteString bs = input.readBytes();
                bitField0_ |= 0x00000040;
                zip_ = bs;
                break;
              }
              case 80: {
                bitField0_ |= 0x00000100;
                utcoffset_ = input.readInt32();
                break;
              }
              case 88: {
                bitField0_ |= 0x00000080;
                accuracy_ = input.readInt32();
                break;
              }
              default: {
                if (!parseUnknownField(
                    input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(
              e).setUnfinishedMessage(this);
        } finally {
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_Geo_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_Geo_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.protos.adx.NetworkBid.BidRequest.Geo.class, com.google.protos.adx.NetworkBid.BidRequest.Geo.Builder.class);
      }

      private int bitField0_;
      public static final int LAT_FIELD_NUMBER = 1;
      private double lat_;
      /**
       * <pre>
       * Latitude from -90.0 to +90.0, where negative is south.
       * </pre>
       *
       * <code>optional double lat = 1;</code>
       * @return Whether the lat field is set.
       */
      @java.lang.Override
      public boolean hasLat() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <pre>
       * Latitude from -90.0 to +90.0, where negative is south.
       * </pre>
       *
       * <code>optional double lat = 1;</code>
       * @return The lat.
       */
      @java.lang.Override
      public double getLat() {
        return lat_;
      }

      public static final int LON_FIELD_NUMBER = 2;
      private double lon_;
      /**
       * <pre>
       * Longitude from -180.0 to +180.0, where negative is west.
       * </pre>
       *
       * <code>optional double lon = 2;</code>
       * @return Whether the lon field is set.
       */
      @java.lang.Override
      public boolean hasLon() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <pre>
       * Longitude from -180.0 to +180.0, where negative is west.
       * </pre>
       *
       * <code>optional double lon = 2;</code>
       * @return The lon.
       */
      @java.lang.Override
      public double getLon() {
        return lon_;
      }

      public static final int COUNTRY_FIELD_NUMBER = 3;
      private volatile java.lang.Object country_;
      /**
       * <pre>
       * Country using ISO-3166-1 Alpha-3.
       * </pre>
       *
       * <code>optional string country = 3;</code>
       * @return Whether the country field is set.
       */
      @java.lang.Override
      public boolean hasCountry() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       * <pre>
       * Country using ISO-3166-1 Alpha-3.
       * </pre>
       *
       * <code>optional string country = 3;</code>
       * @return The country.
       */
      @java.lang.Override
      public java.lang.String getCountry() {
        java.lang.Object ref = country_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = 
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            country_ = s;
          }
          return s;
        }
      }
      /**
       * <pre>
       * Country using ISO-3166-1 Alpha-3.
       * </pre>
       *
       * <code>optional string country = 3;</code>
       * @return The bytes for country.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString
          getCountryBytes() {
        java.lang.Object ref = country_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          country_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int REGION_FIELD_NUMBER = 4;
      private volatile java.lang.Object region_;
      /**
       * <pre>
       * Region code using ISO-3166-2; 2-letter state code if USA.
       * </pre>
       *
       * <code>optional string region = 4;</code>
       * @return Whether the region field is set.
       */
      @java.lang.Override
      public boolean hasRegion() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       * <pre>
       * Region code using ISO-3166-2; 2-letter state code if USA.
       * </pre>
       *
       * <code>optional string region = 4;</code>
       * @return The region.
       */
      @java.lang.Override
      public java.lang.String getRegion() {
        java.lang.Object ref = region_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = 
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            region_ = s;
          }
          return s;
        }
      }
      /**
       * <pre>
       * Region code using ISO-3166-2; 2-letter state code if USA.
       * </pre>
       *
       * <code>optional string region = 4;</code>
       * @return The bytes for region.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString
          getRegionBytes() {
        java.lang.Object ref = region_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          region_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int METRO_FIELD_NUMBER = 6;
      private volatile java.lang.Object metro_;
      /**
       * <pre>
       * Google metro code; similar to but not exactly Nielsen DMAs.
       * </pre>
       *
       * <code>optional string metro = 6;</code>
       * @return Whether the metro field is set.
       */
      @java.lang.Override
      public boolean hasMetro() {
        return ((bitField0_ & 0x00000010) != 0);
      }
      /**
       * <pre>
       * Google metro code; similar to but not exactly Nielsen DMAs.
       * </pre>
       *
       * <code>optional string metro = 6;</code>
       * @return The metro.
       */
      @java.lang.Override
      public java.lang.String getMetro() {
        java.lang.Object ref = metro_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = 
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            metro_ = s;
          }
          return s;
        }
      }
      /**
       * <pre>
       * Google metro code; similar to but not exactly Nielsen DMAs.
       * </pre>
       *
       * <code>optional string metro = 6;</code>
       * @return The bytes for metro.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString
          getMetroBytes() {
        java.lang.Object ref = metro_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          metro_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int CITY_FIELD_NUMBER = 7;
      private volatile java.lang.Object city_;
      /**
       * <pre>
       * City using United Nations Code for Trade &amp; Transport Locations.
       * (https://www.unece.org/cefact/locode/service/location.htm).
       * </pre>
       *
       * <code>optional string city = 7;</code>
       * @return Whether the city field is set.
       */
      @java.lang.Override
      public boolean hasCity() {
        return ((bitField0_ & 0x00000020) != 0);
      }
      /**
       * <pre>
       * City using United Nations Code for Trade &amp; Transport Locations.
       * (https://www.unece.org/cefact/locode/service/location.htm).
       * </pre>
       *
       * <code>optional string city = 7;</code>
       * @return The city.
       */
      @java.lang.Override
      public java.lang.String getCity() {
        java.lang.Object ref = city_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = 
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            city_ = s;
          }
          return s;
        }
      }
      /**
       * <pre>
       * City using United Nations Code for Trade &amp; Transport Locations.
       * (https://www.unece.org/cefact/locode/service/location.htm).
       * </pre>
       *
       * <code>optional string city = 7;</code>
       * @return The bytes for city.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString
          getCityBytes() {
        java.lang.Object ref = city_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          city_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int ZIP_FIELD_NUMBER = 8;
      private volatile java.lang.Object zip_;
      /**
       * <pre>
       * Zip/postal code.
       * </pre>
       *
       * <code>optional string zip = 8;</code>
       * @return Whether the zip field is set.
       */
      @java.lang.Override
      public boolean hasZip() {
        return ((bitField0_ & 0x00000040) != 0);
      }
      /**
       * <pre>
       * Zip/postal code.
       * </pre>
       *
       * <code>optional string zip = 8;</code>
       * @return The zip.
       */
      @java.lang.Override
      public java.lang.String getZip() {
        java.lang.Object ref = zip_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = 
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            zip_ = s;
          }
          return s;
        }
      }
      /**
       * <pre>
       * Zip/postal code.
       * </pre>
       *
       * <code>optional string zip = 8;</code>
       * @return The bytes for zip.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString
          getZipBytes() {
        java.lang.Object ref = zip_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          zip_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int ACCURACY_FIELD_NUMBER = 11;
      private int accuracy_;
      /**
       * <pre>
       * Estimated location accuracy in meters.
       * </pre>
       *
       * <code>optional int32 accuracy = 11;</code>
       * @return Whether the accuracy field is set.
       */
      @java.lang.Override
      public boolean hasAccuracy() {
        return ((bitField0_ & 0x00000080) != 0);
      }
      /**
       * <pre>
       * Estimated location accuracy in meters.
       * </pre>
       *
       * <code>optional int32 accuracy = 11;</code>
       * @return The accuracy.
       */
      @java.lang.Override
      public int getAccuracy() {
        return accuracy_;
      }

      public static final int UTCOFFSET_FIELD_NUMBER = 10;
      private int utcoffset_;
      /**
       * <pre>
       * Local time as the number +/- of minutes from UTC.
       * </pre>
       *
       * <code>optional int32 utcoffset = 10;</code>
       * @return Whether the utcoffset field is set.
       */
      @java.lang.Override
      public boolean hasUtcoffset() {
        return ((bitField0_ & 0x00000100) != 0);
      }
      /**
       * <pre>
       * Local time as the number +/- of minutes from UTC.
       * </pre>
       *
       * <code>optional int32 utcoffset = 10;</code>
       * @return The utcoffset.
       */
      @java.lang.Override
      public int getUtcoffset() {
        return utcoffset_;
      }

      private byte memoizedIsInitialized = -1;
      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output)
                          throws java.io.IOException {
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeDouble(1, lat_);
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          output.writeDouble(2, lon_);
        }
        if (((bitField0_ & 0x00000004) != 0)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 3, country_);
        }
        if (((bitField0_ & 0x00000008) != 0)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 4, region_);
        }
        if (((bitField0_ & 0x00000010) != 0)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 6, metro_);
        }
        if (((bitField0_ & 0x00000020) != 0)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 7, city_);
        }
        if (((bitField0_ & 0x00000040) != 0)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 8, zip_);
        }
        if (((bitField0_ & 0x00000100) != 0)) {
          output.writeInt32(10, utcoffset_);
        }
        if (((bitField0_ & 0x00000080) != 0)) {
          output.writeInt32(11, accuracy_);
        }
        unknownFields.writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.CodedOutputStream
            .computeDoubleSize(1, lat_);
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          size += com.google.protobuf.CodedOutputStream
            .computeDoubleSize(2, lon_);
        }
        if (((bitField0_ & 0x00000004) != 0)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, country_);
        }
        if (((bitField0_ & 0x00000008) != 0)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, region_);
        }
        if (((bitField0_ & 0x00000010) != 0)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, metro_);
        }
        if (((bitField0_ & 0x00000020) != 0)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, city_);
        }
        if (((bitField0_ & 0x00000040) != 0)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, zip_);
        }
        if (((bitField0_ & 0x00000100) != 0)) {
          size += com.google.protobuf.CodedOutputStream
            .computeInt32Size(10, utcoffset_);
        }
        if (((bitField0_ & 0x00000080) != 0)) {
          size += com.google.protobuf.CodedOutputStream
            .computeInt32Size(11, accuracy_);
        }
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
         return true;
        }
        if (!(obj instanceof com.google.protos.adx.NetworkBid.BidRequest.Geo)) {
          return super.equals(obj);
        }
        com.google.protos.adx.NetworkBid.BidRequest.Geo other = (com.google.protos.adx.NetworkBid.BidRequest.Geo) obj;

        if (hasLat() != other.hasLat()) return false;
        if (hasLat()) {
          if (java.lang.Double.doubleToLongBits(getLat())
              != java.lang.Double.doubleToLongBits(
                  other.getLat())) return false;
        }
        if (hasLon() != other.hasLon()) return false;
        if (hasLon()) {
          if (java.lang.Double.doubleToLongBits(getLon())
              != java.lang.Double.doubleToLongBits(
                  other.getLon())) return false;
        }
        if (hasCountry() != other.hasCountry()) return false;
        if (hasCountry()) {
          if (!getCountry()
              .equals(other.getCountry())) return false;
        }
        if (hasRegion() != other.hasRegion()) return false;
        if (hasRegion()) {
          if (!getRegion()
              .equals(other.getRegion())) return false;
        }
        if (hasMetro() != other.hasMetro()) return false;
        if (hasMetro()) {
          if (!getMetro()
              .equals(other.getMetro())) return false;
        }
        if (hasCity() != other.hasCity()) return false;
        if (hasCity()) {
          if (!getCity()
              .equals(other.getCity())) return false;
        }
        if (hasZip() != other.hasZip()) return false;
        if (hasZip()) {
          if (!getZip()
              .equals(other.getZip())) return false;
        }
        if (hasAccuracy() != other.hasAccuracy()) return false;
        if (hasAccuracy()) {
          if (getAccuracy()
              != other.getAccuracy()) return false;
        }
        if (hasUtcoffset() != other.hasUtcoffset()) return false;
        if (hasUtcoffset()) {
          if (getUtcoffset()
              != other.getUtcoffset()) return false;
        }
        if (!unknownFields.equals(other.unknownFields)) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasLat()) {
          hash = (37 * hash) + LAT_FIELD_NUMBER;
          hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
              java.lang.Double.doubleToLongBits(getLat()));
        }
        if (hasLon()) {
          hash = (37 * hash) + LON_FIELD_NUMBER;
          hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
              java.lang.Double.doubleToLongBits(getLon()));
        }
        if (hasCountry()) {
          hash = (37 * hash) + COUNTRY_FIELD_NUMBER;
          hash = (53 * hash) + getCountry().hashCode();
        }
        if (hasRegion()) {
          hash = (37 * hash) + REGION_FIELD_NUMBER;
          hash = (53 * hash) + getRegion().hashCode();
        }
        if (hasMetro()) {
          hash = (37 * hash) + METRO_FIELD_NUMBER;
          hash = (53 * hash) + getMetro().hashCode();
        }
        if (hasCity()) {
          hash = (37 * hash) + CITY_FIELD_NUMBER;
          hash = (53 * hash) + getCity().hashCode();
        }
        if (hasZip()) {
          hash = (37 * hash) + ZIP_FIELD_NUMBER;
          hash = (53 * hash) + getZip().hashCode();
        }
        if (hasAccuracy()) {
          hash = (37 * hash) + ACCURACY_FIELD_NUMBER;
          hash = (53 * hash) + getAccuracy();
        }
        if (hasUtcoffset()) {
          hash = (37 * hash) + UTCOFFSET_FIELD_NUMBER;
          hash = (53 * hash) + getUtcoffset();
        }
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.protos.adx.NetworkBid.BidRequest.Geo parseFrom(
          java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.Geo parseFrom(
          java.nio.ByteBuffer data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.Geo parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.Geo parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.Geo parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.Geo parseFrom(
          byte[] data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.Geo parseFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.Geo parseFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.Geo parseDelimitedFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.Geo parseDelimitedFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.Geo parseFrom(
          com.google.protobuf.CodedInputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.Geo parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() { return newBuilder(); }
      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }
      public static Builder newBuilder(com.google.protos.adx.NetworkBid.BidRequest.Geo prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }
      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE
            ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * <pre>
       * The user's approximate geographic location. All location information is
       * IP geolocation-derived.  The lat/lon fields may be a reference position
       * (e.g. centroid) for the IP geolocation-derived location that's also carried
       * by the other fields (e.g. a city), and accuracy will be the radius of a
       * circle with the approximate area of that location. Location and its
       * accuracy will be fuzzified as necessary to protect user privacy.
       * See Geotargeting Guide:
       * https://developers.google.com/authorized-buyers/rtb/geotargeting
       * </pre>
       *
       * Protobuf type {@code com.google.protos.adx.BidRequest.Geo}
       */
      public static final class Builder extends
          com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
          // @@protoc_insertion_point(builder_implements:com.google.protos.adx.BidRequest.Geo)
          com.google.protos.adx.NetworkBid.BidRequest.GeoOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
          return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_Geo_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_Geo_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.protos.adx.NetworkBid.BidRequest.Geo.class, com.google.protos.adx.NetworkBid.BidRequest.Geo.Builder.class);
        }

        // Construct using com.google.protos.adx.NetworkBid.BidRequest.Geo.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }
        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3
                  .alwaysUseFieldBuilders) {
          }
        }
        @java.lang.Override
        public Builder clear() {
          super.clear();
          lat_ = 0D;
          bitField0_ = (bitField0_ & ~0x00000001);
          lon_ = 0D;
          bitField0_ = (bitField0_ & ~0x00000002);
          country_ = "";
          bitField0_ = (bitField0_ & ~0x00000004);
          region_ = "";
          bitField0_ = (bitField0_ & ~0x00000008);
          metro_ = "";
          bitField0_ = (bitField0_ & ~0x00000010);
          city_ = "";
          bitField0_ = (bitField0_ & ~0x00000020);
          zip_ = "";
          bitField0_ = (bitField0_ & ~0x00000040);
          accuracy_ = 0;
          bitField0_ = (bitField0_ & ~0x00000080);
          utcoffset_ = 0;
          bitField0_ = (bitField0_ & ~0x00000100);
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
          return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_Geo_descriptor;
        }

        @java.lang.Override
        public com.google.protos.adx.NetworkBid.BidRequest.Geo getDefaultInstanceForType() {
          return com.google.protos.adx.NetworkBid.BidRequest.Geo.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.protos.adx.NetworkBid.BidRequest.Geo build() {
          com.google.protos.adx.NetworkBid.BidRequest.Geo result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.protos.adx.NetworkBid.BidRequest.Geo buildPartial() {
          com.google.protos.adx.NetworkBid.BidRequest.Geo result = new com.google.protos.adx.NetworkBid.BidRequest.Geo(this);
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.lat_ = lat_;
            to_bitField0_ |= 0x00000001;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.lon_ = lon_;
            to_bitField0_ |= 0x00000002;
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            to_bitField0_ |= 0x00000004;
          }
          result.country_ = country_;
          if (((from_bitField0_ & 0x00000008) != 0)) {
            to_bitField0_ |= 0x00000008;
          }
          result.region_ = region_;
          if (((from_bitField0_ & 0x00000010) != 0)) {
            to_bitField0_ |= 0x00000010;
          }
          result.metro_ = metro_;
          if (((from_bitField0_ & 0x00000020) != 0)) {
            to_bitField0_ |= 0x00000020;
          }
          result.city_ = city_;
          if (((from_bitField0_ & 0x00000040) != 0)) {
            to_bitField0_ |= 0x00000040;
          }
          result.zip_ = zip_;
          if (((from_bitField0_ & 0x00000080) != 0)) {
            result.accuracy_ = accuracy_;
            to_bitField0_ |= 0x00000080;
          }
          if (((from_bitField0_ & 0x00000100) != 0)) {
            result.utcoffset_ = utcoffset_;
            to_bitField0_ |= 0x00000100;
          }
          result.bitField0_ = to_bitField0_;
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }
        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.setField(field, value);
        }
        @java.lang.Override
        public Builder clearField(
            com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }
        @java.lang.Override
        public Builder clearOneof(
            com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }
        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index, java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }
        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }
        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.protos.adx.NetworkBid.BidRequest.Geo) {
            return mergeFrom((com.google.protos.adx.NetworkBid.BidRequest.Geo)other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.google.protos.adx.NetworkBid.BidRequest.Geo other) {
          if (other == com.google.protos.adx.NetworkBid.BidRequest.Geo.getDefaultInstance()) return this;
          if (other.hasLat()) {
            setLat(other.getLat());
          }
          if (other.hasLon()) {
            setLon(other.getLon());
          }
          if (other.hasCountry()) {
            bitField0_ |= 0x00000004;
            country_ = other.country_;
            onChanged();
          }
          if (other.hasRegion()) {
            bitField0_ |= 0x00000008;
            region_ = other.region_;
            onChanged();
          }
          if (other.hasMetro()) {
            bitField0_ |= 0x00000010;
            metro_ = other.metro_;
            onChanged();
          }
          if (other.hasCity()) {
            bitField0_ |= 0x00000020;
            city_ = other.city_;
            onChanged();
          }
          if (other.hasZip()) {
            bitField0_ |= 0x00000040;
            zip_ = other.zip_;
            onChanged();
          }
          if (other.hasAccuracy()) {
            setAccuracy(other.getAccuracy());
          }
          if (other.hasUtcoffset()) {
            setUtcoffset(other.getUtcoffset());
          }
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          com.google.protos.adx.NetworkBid.BidRequest.Geo parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage = (com.google.protos.adx.NetworkBid.BidRequest.Geo) e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }
        private int bitField0_;

        private double lat_ ;
        /**
         * <pre>
         * Latitude from -90.0 to +90.0, where negative is south.
         * </pre>
         *
         * <code>optional double lat = 1;</code>
         * @return Whether the lat field is set.
         */
        @java.lang.Override
        public boolean hasLat() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         * <pre>
         * Latitude from -90.0 to +90.0, where negative is south.
         * </pre>
         *
         * <code>optional double lat = 1;</code>
         * @return The lat.
         */
        @java.lang.Override
        public double getLat() {
          return lat_;
        }
        /**
         * <pre>
         * Latitude from -90.0 to +90.0, where negative is south.
         * </pre>
         *
         * <code>optional double lat = 1;</code>
         * @param value The lat to set.
         * @return This builder for chaining.
         */
        public Builder setLat(double value) {
          bitField0_ |= 0x00000001;
          lat_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Latitude from -90.0 to +90.0, where negative is south.
         * </pre>
         *
         * <code>optional double lat = 1;</code>
         * @return This builder for chaining.
         */
        public Builder clearLat() {
          bitField0_ = (bitField0_ & ~0x00000001);
          lat_ = 0D;
          onChanged();
          return this;
        }

        private double lon_ ;
        /**
         * <pre>
         * Longitude from -180.0 to +180.0, where negative is west.
         * </pre>
         *
         * <code>optional double lon = 2;</code>
         * @return Whether the lon field is set.
         */
        @java.lang.Override
        public boolean hasLon() {
          return ((bitField0_ & 0x00000002) != 0);
        }
        /**
         * <pre>
         * Longitude from -180.0 to +180.0, where negative is west.
         * </pre>
         *
         * <code>optional double lon = 2;</code>
         * @return The lon.
         */
        @java.lang.Override
        public double getLon() {
          return lon_;
        }
        /**
         * <pre>
         * Longitude from -180.0 to +180.0, where negative is west.
         * </pre>
         *
         * <code>optional double lon = 2;</code>
         * @param value The lon to set.
         * @return This builder for chaining.
         */
        public Builder setLon(double value) {
          bitField0_ |= 0x00000002;
          lon_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Longitude from -180.0 to +180.0, where negative is west.
         * </pre>
         *
         * <code>optional double lon = 2;</code>
         * @return This builder for chaining.
         */
        public Builder clearLon() {
          bitField0_ = (bitField0_ & ~0x00000002);
          lon_ = 0D;
          onChanged();
          return this;
        }

        private java.lang.Object country_ = "";
        /**
         * <pre>
         * Country using ISO-3166-1 Alpha-3.
         * </pre>
         *
         * <code>optional string country = 3;</code>
         * @return Whether the country field is set.
         */
        public boolean hasCountry() {
          return ((bitField0_ & 0x00000004) != 0);
        }
        /**
         * <pre>
         * Country using ISO-3166-1 Alpha-3.
         * </pre>
         *
         * <code>optional string country = 3;</code>
         * @return The country.
         */
        public java.lang.String getCountry() {
          java.lang.Object ref = country_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs =
                (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            if (bs.isValidUtf8()) {
              country_ = s;
            }
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         * <pre>
         * Country using ISO-3166-1 Alpha-3.
         * </pre>
         *
         * <code>optional string country = 3;</code>
         * @return The bytes for country.
         */
        public com.google.protobuf.ByteString
            getCountryBytes() {
          java.lang.Object ref = country_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b = 
                com.google.protobuf.ByteString.copyFromUtf8(
                    (java.lang.String) ref);
            country_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         * <pre>
         * Country using ISO-3166-1 Alpha-3.
         * </pre>
         *
         * <code>optional string country = 3;</code>
         * @param value The country to set.
         * @return This builder for chaining.
         */
        public Builder setCountry(
            java.lang.String value) {
          if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000004;
          country_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Country using ISO-3166-1 Alpha-3.
         * </pre>
         *
         * <code>optional string country = 3;</code>
         * @return This builder for chaining.
         */
        public Builder clearCountry() {
          bitField0_ = (bitField0_ & ~0x00000004);
          country_ = getDefaultInstance().getCountry();
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Country using ISO-3166-1 Alpha-3.
         * </pre>
         *
         * <code>optional string country = 3;</code>
         * @param value The bytes for country to set.
         * @return This builder for chaining.
         */
        public Builder setCountryBytes(
            com.google.protobuf.ByteString value) {
          if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000004;
          country_ = value;
          onChanged();
          return this;
        }

        private java.lang.Object region_ = "";
        /**
         * <pre>
         * Region code using ISO-3166-2; 2-letter state code if USA.
         * </pre>
         *
         * <code>optional string region = 4;</code>
         * @return Whether the region field is set.
         */
        public boolean hasRegion() {
          return ((bitField0_ & 0x00000008) != 0);
        }
        /**
         * <pre>
         * Region code using ISO-3166-2; 2-letter state code if USA.
         * </pre>
         *
         * <code>optional string region = 4;</code>
         * @return The region.
         */
        public java.lang.String getRegion() {
          java.lang.Object ref = region_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs =
                (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            if (bs.isValidUtf8()) {
              region_ = s;
            }
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         * <pre>
         * Region code using ISO-3166-2; 2-letter state code if USA.
         * </pre>
         *
         * <code>optional string region = 4;</code>
         * @return The bytes for region.
         */
        public com.google.protobuf.ByteString
            getRegionBytes() {
          java.lang.Object ref = region_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b = 
                com.google.protobuf.ByteString.copyFromUtf8(
                    (java.lang.String) ref);
            region_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         * <pre>
         * Region code using ISO-3166-2; 2-letter state code if USA.
         * </pre>
         *
         * <code>optional string region = 4;</code>
         * @param value The region to set.
         * @return This builder for chaining.
         */
        public Builder setRegion(
            java.lang.String value) {
          if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000008;
          region_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Region code using ISO-3166-2; 2-letter state code if USA.
         * </pre>
         *
         * <code>optional string region = 4;</code>
         * @return This builder for chaining.
         */
        public Builder clearRegion() {
          bitField0_ = (bitField0_ & ~0x00000008);
          region_ = getDefaultInstance().getRegion();
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Region code using ISO-3166-2; 2-letter state code if USA.
         * </pre>
         *
         * <code>optional string region = 4;</code>
         * @param value The bytes for region to set.
         * @return This builder for chaining.
         */
        public Builder setRegionBytes(
            com.google.protobuf.ByteString value) {
          if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000008;
          region_ = value;
          onChanged();
          return this;
        }

        private java.lang.Object metro_ = "";
        /**
         * <pre>
         * Google metro code; similar to but not exactly Nielsen DMAs.
         * </pre>
         *
         * <code>optional string metro = 6;</code>
         * @return Whether the metro field is set.
         */
        public boolean hasMetro() {
          return ((bitField0_ & 0x00000010) != 0);
        }
        /**
         * <pre>
         * Google metro code; similar to but not exactly Nielsen DMAs.
         * </pre>
         *
         * <code>optional string metro = 6;</code>
         * @return The metro.
         */
        public java.lang.String getMetro() {
          java.lang.Object ref = metro_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs =
                (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            if (bs.isValidUtf8()) {
              metro_ = s;
            }
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         * <pre>
         * Google metro code; similar to but not exactly Nielsen DMAs.
         * </pre>
         *
         * <code>optional string metro = 6;</code>
         * @return The bytes for metro.
         */
        public com.google.protobuf.ByteString
            getMetroBytes() {
          java.lang.Object ref = metro_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b = 
                com.google.protobuf.ByteString.copyFromUtf8(
                    (java.lang.String) ref);
            metro_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         * <pre>
         * Google metro code; similar to but not exactly Nielsen DMAs.
         * </pre>
         *
         * <code>optional string metro = 6;</code>
         * @param value The metro to set.
         * @return This builder for chaining.
         */
        public Builder setMetro(
            java.lang.String value) {
          if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000010;
          metro_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Google metro code; similar to but not exactly Nielsen DMAs.
         * </pre>
         *
         * <code>optional string metro = 6;</code>
         * @return This builder for chaining.
         */
        public Builder clearMetro() {
          bitField0_ = (bitField0_ & ~0x00000010);
          metro_ = getDefaultInstance().getMetro();
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Google metro code; similar to but not exactly Nielsen DMAs.
         * </pre>
         *
         * <code>optional string metro = 6;</code>
         * @param value The bytes for metro to set.
         * @return This builder for chaining.
         */
        public Builder setMetroBytes(
            com.google.protobuf.ByteString value) {
          if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000010;
          metro_ = value;
          onChanged();
          return this;
        }

        private java.lang.Object city_ = "";
        /**
         * <pre>
         * City using United Nations Code for Trade &amp; Transport Locations.
         * (https://www.unece.org/cefact/locode/service/location.htm).
         * </pre>
         *
         * <code>optional string city = 7;</code>
         * @return Whether the city field is set.
         */
        public boolean hasCity() {
          return ((bitField0_ & 0x00000020) != 0);
        }
        /**
         * <pre>
         * City using United Nations Code for Trade &amp; Transport Locations.
         * (https://www.unece.org/cefact/locode/service/location.htm).
         * </pre>
         *
         * <code>optional string city = 7;</code>
         * @return The city.
         */
        public java.lang.String getCity() {
          java.lang.Object ref = city_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs =
                (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            if (bs.isValidUtf8()) {
              city_ = s;
            }
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         * <pre>
         * City using United Nations Code for Trade &amp; Transport Locations.
         * (https://www.unece.org/cefact/locode/service/location.htm).
         * </pre>
         *
         * <code>optional string city = 7;</code>
         * @return The bytes for city.
         */
        public com.google.protobuf.ByteString
            getCityBytes() {
          java.lang.Object ref = city_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b = 
                com.google.protobuf.ByteString.copyFromUtf8(
                    (java.lang.String) ref);
            city_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         * <pre>
         * City using United Nations Code for Trade &amp; Transport Locations.
         * (https://www.unece.org/cefact/locode/service/location.htm).
         * </pre>
         *
         * <code>optional string city = 7;</code>
         * @param value The city to set.
         * @return This builder for chaining.
         */
        public Builder setCity(
            java.lang.String value) {
          if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000020;
          city_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * City using United Nations Code for Trade &amp; Transport Locations.
         * (https://www.unece.org/cefact/locode/service/location.htm).
         * </pre>
         *
         * <code>optional string city = 7;</code>
         * @return This builder for chaining.
         */
        public Builder clearCity() {
          bitField0_ = (bitField0_ & ~0x00000020);
          city_ = getDefaultInstance().getCity();
          onChanged();
          return this;
        }
        /**
         * <pre>
         * City using United Nations Code for Trade &amp; Transport Locations.
         * (https://www.unece.org/cefact/locode/service/location.htm).
         * </pre>
         *
         * <code>optional string city = 7;</code>
         * @param value The bytes for city to set.
         * @return This builder for chaining.
         */
        public Builder setCityBytes(
            com.google.protobuf.ByteString value) {
          if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000020;
          city_ = value;
          onChanged();
          return this;
        }

        private java.lang.Object zip_ = "";
        /**
         * <pre>
         * Zip/postal code.
         * </pre>
         *
         * <code>optional string zip = 8;</code>
         * @return Whether the zip field is set.
         */
        public boolean hasZip() {
          return ((bitField0_ & 0x00000040) != 0);
        }
        /**
         * <pre>
         * Zip/postal code.
         * </pre>
         *
         * <code>optional string zip = 8;</code>
         * @return The zip.
         */
        public java.lang.String getZip() {
          java.lang.Object ref = zip_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs =
                (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            if (bs.isValidUtf8()) {
              zip_ = s;
            }
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         * <pre>
         * Zip/postal code.
         * </pre>
         *
         * <code>optional string zip = 8;</code>
         * @return The bytes for zip.
         */
        public com.google.protobuf.ByteString
            getZipBytes() {
          java.lang.Object ref = zip_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b = 
                com.google.protobuf.ByteString.copyFromUtf8(
                    (java.lang.String) ref);
            zip_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         * <pre>
         * Zip/postal code.
         * </pre>
         *
         * <code>optional string zip = 8;</code>
         * @param value The zip to set.
         * @return This builder for chaining.
         */
        public Builder setZip(
            java.lang.String value) {
          if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000040;
          zip_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Zip/postal code.
         * </pre>
         *
         * <code>optional string zip = 8;</code>
         * @return This builder for chaining.
         */
        public Builder clearZip() {
          bitField0_ = (bitField0_ & ~0x00000040);
          zip_ = getDefaultInstance().getZip();
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Zip/postal code.
         * </pre>
         *
         * <code>optional string zip = 8;</code>
         * @param value The bytes for zip to set.
         * @return This builder for chaining.
         */
        public Builder setZipBytes(
            com.google.protobuf.ByteString value) {
          if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000040;
          zip_ = value;
          onChanged();
          return this;
        }

        private int accuracy_ ;
        /**
         * <pre>
         * Estimated location accuracy in meters.
         * </pre>
         *
         * <code>optional int32 accuracy = 11;</code>
         * @return Whether the accuracy field is set.
         */
        @java.lang.Override
        public boolean hasAccuracy() {
          return ((bitField0_ & 0x00000080) != 0);
        }
        /**
         * <pre>
         * Estimated location accuracy in meters.
         * </pre>
         *
         * <code>optional int32 accuracy = 11;</code>
         * @return The accuracy.
         */
        @java.lang.Override
        public int getAccuracy() {
          return accuracy_;
        }
        /**
         * <pre>
         * Estimated location accuracy in meters.
         * </pre>
         *
         * <code>optional int32 accuracy = 11;</code>
         * @param value The accuracy to set.
         * @return This builder for chaining.
         */
        public Builder setAccuracy(int value) {
          bitField0_ |= 0x00000080;
          accuracy_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Estimated location accuracy in meters.
         * </pre>
         *
         * <code>optional int32 accuracy = 11;</code>
         * @return This builder for chaining.
         */
        public Builder clearAccuracy() {
          bitField0_ = (bitField0_ & ~0x00000080);
          accuracy_ = 0;
          onChanged();
          return this;
        }

        private int utcoffset_ ;
        /**
         * <pre>
         * Local time as the number +/- of minutes from UTC.
         * </pre>
         *
         * <code>optional int32 utcoffset = 10;</code>
         * @return Whether the utcoffset field is set.
         */
        @java.lang.Override
        public boolean hasUtcoffset() {
          return ((bitField0_ & 0x00000100) != 0);
        }
        /**
         * <pre>
         * Local time as the number +/- of minutes from UTC.
         * </pre>
         *
         * <code>optional int32 utcoffset = 10;</code>
         * @return The utcoffset.
         */
        @java.lang.Override
        public int getUtcoffset() {
          return utcoffset_;
        }
        /**
         * <pre>
         * Local time as the number +/- of minutes from UTC.
         * </pre>
         *
         * <code>optional int32 utcoffset = 10;</code>
         * @param value The utcoffset to set.
         * @return This builder for chaining.
         */
        public Builder setUtcoffset(int value) {
          bitField0_ |= 0x00000100;
          utcoffset_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Local time as the number +/- of minutes from UTC.
         * </pre>
         *
         * <code>optional int32 utcoffset = 10;</code>
         * @return This builder for chaining.
         */
        public Builder clearUtcoffset() {
          bitField0_ = (bitField0_ & ~0x00000100);
          utcoffset_ = 0;
          onChanged();
          return this;
        }
        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }


        // @@protoc_insertion_point(builder_scope:com.google.protos.adx.BidRequest.Geo)
      }

      // @@protoc_insertion_point(class_scope:com.google.protos.adx.BidRequest.Geo)
      private static final com.google.protos.adx.NetworkBid.BidRequest.Geo DEFAULT_INSTANCE;
      static {
        DEFAULT_INSTANCE = new com.google.protos.adx.NetworkBid.BidRequest.Geo();
      }

      public static com.google.protos.adx.NetworkBid.BidRequest.Geo getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      @java.lang.Deprecated public static final com.google.protobuf.Parser<Geo>
          PARSER = new com.google.protobuf.AbstractParser<Geo>() {
        @java.lang.Override
        public Geo parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new Geo(input, extensionRegistry);
        }
      };

      public static com.google.protobuf.Parser<Geo> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Geo> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protos.adx.NetworkBid.BidRequest.Geo getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }

    }

    public interface HyperlocalOrBuilder extends
        // @@protoc_insertion_point(interface_extends:com.google.protos.adx.BidRequest.Hyperlocal)
        com.google.protobuf.MessageOrBuilder {

      /**
       * <pre>
       * The mobile device can be at any point inside the geofence polygon defined
       * by a list of corners. Currently, the polygon is always a parallelogram
       * with 4 corners.
       * </pre>
       *
       * <code>repeated .com.google.protos.adx.BidRequest.Hyperlocal.Point corners = 1;</code>
       */
      java.util.List<com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point> 
          getCornersList();
      /**
       * <pre>
       * The mobile device can be at any point inside the geofence polygon defined
       * by a list of corners. Currently, the polygon is always a parallelogram
       * with 4 corners.
       * </pre>
       *
       * <code>repeated .com.google.protos.adx.BidRequest.Hyperlocal.Point corners = 1;</code>
       */
      com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point getCorners(int index);
      /**
       * <pre>
       * The mobile device can be at any point inside the geofence polygon defined
       * by a list of corners. Currently, the polygon is always a parallelogram
       * with 4 corners.
       * </pre>
       *
       * <code>repeated .com.google.protos.adx.BidRequest.Hyperlocal.Point corners = 1;</code>
       */
      int getCornersCount();
      /**
       * <pre>
       * The mobile device can be at any point inside the geofence polygon defined
       * by a list of corners. Currently, the polygon is always a parallelogram
       * with 4 corners.
       * </pre>
       *
       * <code>repeated .com.google.protos.adx.BidRequest.Hyperlocal.Point corners = 1;</code>
       */
      java.util.List<? extends com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.PointOrBuilder> 
          getCornersOrBuilderList();
      /**
       * <pre>
       * The mobile device can be at any point inside the geofence polygon defined
       * by a list of corners. Currently, the polygon is always a parallelogram
       * with 4 corners.
       * </pre>
       *
       * <code>repeated .com.google.protos.adx.BidRequest.Hyperlocal.Point corners = 1;</code>
       */
      com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.PointOrBuilder getCornersOrBuilder(
          int index);
    }
    /**
     * <pre>
     * A hyperlocal targeting location when available.
     * </pre>
     *
     * Protobuf type {@code com.google.protos.adx.BidRequest.Hyperlocal}
     */
    public static final class Hyperlocal extends
        com.google.protobuf.GeneratedMessageV3 implements
        // @@protoc_insertion_point(message_implements:com.google.protos.adx.BidRequest.Hyperlocal)
        HyperlocalOrBuilder {
    private static final long serialVersionUID = 0L;
      // Use Hyperlocal.newBuilder() to construct.
      private Hyperlocal(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }
      private Hyperlocal() {
        corners_ = java.util.Collections.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(
          UnusedPrivateParameter unused) {
        return new Hyperlocal();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet
      getUnknownFields() {
        return this.unknownFields;
      }
      private Hyperlocal(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        int mutable_bitField0_ = 0;
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                  corners_ = new java.util.ArrayList<com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point>();
                  mutable_bitField0_ |= 0x00000001;
                }
                corners_.add(
                    input.readMessage(com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point.PARSER, extensionRegistry));
                break;
              }
              default: {
                if (!parseUnknownField(
                    input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(
              e).setUnfinishedMessage(this);
        } finally {
          if (((mutable_bitField0_ & 0x00000001) != 0)) {
            corners_ = java.util.Collections.unmodifiableList(corners_);
          }
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_Hyperlocal_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_Hyperlocal_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.class, com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Builder.class);
      }

      public interface PointOrBuilder extends
          // @@protoc_insertion_point(interface_extends:com.google.protos.adx.BidRequest.Hyperlocal.Point)
          com.google.protobuf.MessageOrBuilder {

        /**
         * <code>optional float latitude = 1;</code>
         * @return Whether the latitude field is set.
         */
        boolean hasLatitude();
        /**
         * <code>optional float latitude = 1;</code>
         * @return The latitude.
         */
        float getLatitude();

        /**
         * <code>optional float longitude = 2;</code>
         * @return Whether the longitude field is set.
         */
        boolean hasLongitude();
        /**
         * <code>optional float longitude = 2;</code>
         * @return The longitude.
         */
        float getLongitude();
      }
      /**
       * <pre>
       * A location on the Earth's surface.
       * </pre>
       *
       * Protobuf type {@code com.google.protos.adx.BidRequest.Hyperlocal.Point}
       */
      public static final class Point extends
          com.google.protobuf.GeneratedMessageV3 implements
          // @@protoc_insertion_point(message_implements:com.google.protos.adx.BidRequest.Hyperlocal.Point)
          PointOrBuilder {
      private static final long serialVersionUID = 0L;
        // Use Point.newBuilder() to construct.
        private Point(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }
        private Point() {
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(
            UnusedPrivateParameter unused) {
          return new Point();
        }

        @java.lang.Override
        public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
          return this.unknownFields;
        }
        private Point(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          this();
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          int mutable_bitField0_ = 0;
          com.google.protobuf.UnknownFieldSet.Builder unknownFields =
              com.google.protobuf.UnknownFieldSet.newBuilder();
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 13: {
                  bitField0_ |= 0x00000001;
                  latitude_ = input.readFloat();
                  break;
                }
                case 21: {
                  bitField0_ |= 0x00000002;
                  longitude_ = input.readFloat();
                  break;
                }
                default: {
                  if (!parseUnknownField(
                      input, unknownFields, extensionRegistry, tag)) {
                    done = true;
                  }
                  break;
                }
              }
            }
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(this);
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(
                e).setUnfinishedMessage(this);
          } finally {
            this.unknownFields = unknownFields.build();
            makeExtensionsImmutable();
          }
        }
        public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
          return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_Hyperlocal_Point_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_Hyperlocal_Point_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point.class, com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point.Builder.class);
        }

        private int bitField0_;
        public static final int LATITUDE_FIELD_NUMBER = 1;
        private float latitude_;
        /**
         * <code>optional float latitude = 1;</code>
         * @return Whether the latitude field is set.
         */
        @java.lang.Override
        public boolean hasLatitude() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         * <code>optional float latitude = 1;</code>
         * @return The latitude.
         */
        @java.lang.Override
        public float getLatitude() {
          return latitude_;
        }

        public static final int LONGITUDE_FIELD_NUMBER = 2;
        private float longitude_;
        /**
         * <code>optional float longitude = 2;</code>
         * @return Whether the longitude field is set.
         */
        @java.lang.Override
        public boolean hasLongitude() {
          return ((bitField0_ & 0x00000002) != 0);
        }
        /**
         * <code>optional float longitude = 2;</code>
         * @return The longitude.
         */
        @java.lang.Override
        public float getLongitude() {
          return longitude_;
        }

        private byte memoizedIsInitialized = -1;
        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
                            throws java.io.IOException {
          if (((bitField0_ & 0x00000001) != 0)) {
            output.writeFloat(1, latitude_);
          }
          if (((bitField0_ & 0x00000002) != 0)) {
            output.writeFloat(2, longitude_);
          }
          unknownFields.writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (((bitField0_ & 0x00000001) != 0)) {
            size += com.google.protobuf.CodedOutputStream
              .computeFloatSize(1, latitude_);
          }
          if (((bitField0_ & 0x00000002) != 0)) {
            size += com.google.protobuf.CodedOutputStream
              .computeFloatSize(2, longitude_);
          }
          size += unknownFields.getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
           return true;
          }
          if (!(obj instanceof com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point)) {
            return super.equals(obj);
          }
          com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point other = (com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point) obj;

          if (hasLatitude() != other.hasLatitude()) return false;
          if (hasLatitude()) {
            if (java.lang.Float.floatToIntBits(getLatitude())
                != java.lang.Float.floatToIntBits(
                    other.getLatitude())) return false;
          }
          if (hasLongitude() != other.hasLongitude()) return false;
          if (hasLongitude()) {
            if (java.lang.Float.floatToIntBits(getLongitude())
                != java.lang.Float.floatToIntBits(
                    other.getLongitude())) return false;
          }
          if (!unknownFields.equals(other.unknownFields)) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          if (hasLatitude()) {
            hash = (37 * hash) + LATITUDE_FIELD_NUMBER;
            hash = (53 * hash) + java.lang.Float.floatToIntBits(
                getLatitude());
          }
          if (hasLongitude()) {
            hash = (37 * hash) + LONGITUDE_FIELD_NUMBER;
            hash = (53 * hash) + java.lang.Float.floatToIntBits(
                getLongitude());
          }
          hash = (29 * hash) + unknownFields.hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point parseFrom(
            java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }
        public static com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point parseFrom(
            java.nio.ByteBuffer data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }
        public static com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point parseFrom(
            com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }
        public static com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }
        public static com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point parseFrom(byte[] data)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }
        public static com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point parseFrom(
            byte[] data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }
        public static com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point parseFrom(java.io.InputStream input)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3
              .parseWithIOException(PARSER, input);
        }
        public static com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point parseFrom(
            java.io.InputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3
              .parseWithIOException(PARSER, input, extensionRegistry);
        }
        public static com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point parseDelimitedFrom(java.io.InputStream input)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3
              .parseDelimitedWithIOException(PARSER, input);
        }
        public static com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point parseDelimitedFrom(
            java.io.InputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3
              .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
        }
        public static com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point parseFrom(
            com.google.protobuf.CodedInputStream input)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3
              .parseWithIOException(PARSER, input);
        }
        public static com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3
              .parseWithIOException(PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() { return newBuilder(); }
        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }
        public static Builder newBuilder(com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }
        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE
              ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         * <pre>
         * A location on the Earth's surface.
         * </pre>
         *
         * Protobuf type {@code com.google.protos.adx.BidRequest.Hyperlocal.Point}
         */
        public static final class Builder extends
            com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
            // @@protoc_insertion_point(builder_implements:com.google.protos.adx.BidRequest.Hyperlocal.Point)
            com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.PointOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor
              getDescriptor() {
            return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_Hyperlocal_Point_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_Hyperlocal_Point_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point.class, com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point.Builder.class);
          }

          // Construct using com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point.newBuilder()
          private Builder() {
            maybeForceBuilderInitialization();
          }

          private Builder(
              com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            maybeForceBuilderInitialization();
          }
          private void maybeForceBuilderInitialization() {
            if (com.google.protobuf.GeneratedMessageV3
                    .alwaysUseFieldBuilders) {
            }
          }
          @java.lang.Override
          public Builder clear() {
            super.clear();
            latitude_ = 0F;
            bitField0_ = (bitField0_ & ~0x00000001);
            longitude_ = 0F;
            bitField0_ = (bitField0_ & ~0x00000002);
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor
              getDescriptorForType() {
            return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_Hyperlocal_Point_descriptor;
          }

          @java.lang.Override
          public com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point getDefaultInstanceForType() {
            return com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point.getDefaultInstance();
          }

          @java.lang.Override
          public com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point build() {
            com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point result = buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point buildPartial() {
            com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point result = new com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point(this);
            int from_bitField0_ = bitField0_;
            int to_bitField0_ = 0;
            if (((from_bitField0_ & 0x00000001) != 0)) {
              result.latitude_ = latitude_;
              to_bitField0_ |= 0x00000001;
            }
            if (((from_bitField0_ & 0x00000002) != 0)) {
              result.longitude_ = longitude_;
              to_bitField0_ |= 0x00000002;
            }
            result.bitField0_ = to_bitField0_;
            onBuilt();
            return result;
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }
          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              java.lang.Object value) {
            return super.setField(field, value);
          }
          @java.lang.Override
          public Builder clearField(
              com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }
          @java.lang.Override
          public Builder clearOneof(
              com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }
          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index, java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }
          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }
          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other instanceof com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point) {
              return mergeFrom((com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point)other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point other) {
            if (other == com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point.getDefaultInstance()) return this;
            if (other.hasLatitude()) {
              setLatitude(other.getLatitude());
            }
            if (other.hasLongitude()) {
              setLongitude(other.getLongitude());
            }
            this.mergeUnknownFields(other.unknownFields);
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point parsedMessage = null;
            try {
              parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              parsedMessage = (com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point) e.getUnfinishedMessage();
              throw e.unwrapIOException();
            } finally {
              if (parsedMessage != null) {
                mergeFrom(parsedMessage);
              }
            }
            return this;
          }
          private int bitField0_;

          private float latitude_ ;
          /**
           * <code>optional float latitude = 1;</code>
           * @return Whether the latitude field is set.
           */
          @java.lang.Override
          public boolean hasLatitude() {
            return ((bitField0_ & 0x00000001) != 0);
          }
          /**
           * <code>optional float latitude = 1;</code>
           * @return The latitude.
           */
          @java.lang.Override
          public float getLatitude() {
            return latitude_;
          }
          /**
           * <code>optional float latitude = 1;</code>
           * @param value The latitude to set.
           * @return This builder for chaining.
           */
          public Builder setLatitude(float value) {
            bitField0_ |= 0x00000001;
            latitude_ = value;
            onChanged();
            return this;
          }
          /**
           * <code>optional float latitude = 1;</code>
           * @return This builder for chaining.
           */
          public Builder clearLatitude() {
            bitField0_ = (bitField0_ & ~0x00000001);
            latitude_ = 0F;
            onChanged();
            return this;
          }

          private float longitude_ ;
          /**
           * <code>optional float longitude = 2;</code>
           * @return Whether the longitude field is set.
           */
          @java.lang.Override
          public boolean hasLongitude() {
            return ((bitField0_ & 0x00000002) != 0);
          }
          /**
           * <code>optional float longitude = 2;</code>
           * @return The longitude.
           */
          @java.lang.Override
          public float getLongitude() {
            return longitude_;
          }
          /**
           * <code>optional float longitude = 2;</code>
           * @param value The longitude to set.
           * @return This builder for chaining.
           */
          public Builder setLongitude(float value) {
            bitField0_ |= 0x00000002;
            longitude_ = value;
            onChanged();
            return this;
          }
          /**
           * <code>optional float longitude = 2;</code>
           * @return This builder for chaining.
           */
          public Builder clearLongitude() {
            bitField0_ = (bitField0_ & ~0x00000002);
            longitude_ = 0F;
            onChanged();
            return this;
          }
          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }


          // @@protoc_insertion_point(builder_scope:com.google.protos.adx.BidRequest.Hyperlocal.Point)
        }

        // @@protoc_insertion_point(class_scope:com.google.protos.adx.BidRequest.Hyperlocal.Point)
        private static final com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point DEFAULT_INSTANCE;
        static {
          DEFAULT_INSTANCE = new com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point();
        }

        public static com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        @java.lang.Deprecated public static final com.google.protobuf.Parser<Point>
            PARSER = new com.google.protobuf.AbstractParser<Point>() {
          @java.lang.Override
          public Point parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new Point(input, extensionRegistry);
          }
        };

        public static com.google.protobuf.Parser<Point> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<Point> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }

      }

      public static final int CORNERS_FIELD_NUMBER = 1;
      private java.util.List<com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point> corners_;
      /**
       * <pre>
       * The mobile device can be at any point inside the geofence polygon defined
       * by a list of corners. Currently, the polygon is always a parallelogram
       * with 4 corners.
       * </pre>
       *
       * <code>repeated .com.google.protos.adx.BidRequest.Hyperlocal.Point corners = 1;</code>
       */
      @java.lang.Override
      public java.util.List<com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point> getCornersList() {
        return corners_;
      }
      /**
       * <pre>
       * The mobile device can be at any point inside the geofence polygon defined
       * by a list of corners. Currently, the polygon is always a parallelogram
       * with 4 corners.
       * </pre>
       *
       * <code>repeated .com.google.protos.adx.BidRequest.Hyperlocal.Point corners = 1;</code>
       */
      @java.lang.Override
      public java.util.List<? extends com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.PointOrBuilder> 
          getCornersOrBuilderList() {
        return corners_;
      }
      /**
       * <pre>
       * The mobile device can be at any point inside the geofence polygon defined
       * by a list of corners. Currently, the polygon is always a parallelogram
       * with 4 corners.
       * </pre>
       *
       * <code>repeated .com.google.protos.adx.BidRequest.Hyperlocal.Point corners = 1;</code>
       */
      @java.lang.Override
      public int getCornersCount() {
        return corners_.size();
      }
      /**
       * <pre>
       * The mobile device can be at any point inside the geofence polygon defined
       * by a list of corners. Currently, the polygon is always a parallelogram
       * with 4 corners.
       * </pre>
       *
       * <code>repeated .com.google.protos.adx.BidRequest.Hyperlocal.Point corners = 1;</code>
       */
      @java.lang.Override
      public com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point getCorners(int index) {
        return corners_.get(index);
      }
      /**
       * <pre>
       * The mobile device can be at any point inside the geofence polygon defined
       * by a list of corners. Currently, the polygon is always a parallelogram
       * with 4 corners.
       * </pre>
       *
       * <code>repeated .com.google.protos.adx.BidRequest.Hyperlocal.Point corners = 1;</code>
       */
      @java.lang.Override
      public com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.PointOrBuilder getCornersOrBuilder(
          int index) {
        return corners_.get(index);
      }

      private byte memoizedIsInitialized = -1;
      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output)
                          throws java.io.IOException {
        for (int i = 0; i < corners_.size(); i++) {
          output.writeMessage(1, corners_.get(i));
        }
        unknownFields.writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        for (int i = 0; i < corners_.size(); i++) {
          size += com.google.protobuf.CodedOutputStream
            .computeMessageSize(1, corners_.get(i));
        }
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
         return true;
        }
        if (!(obj instanceof com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal)) {
          return super.equals(obj);
        }
        com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal other = (com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal) obj;

        if (!getCornersList()
            .equals(other.getCornersList())) return false;
        if (!unknownFields.equals(other.unknownFields)) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (getCornersCount() > 0) {
          hash = (37 * hash) + CORNERS_FIELD_NUMBER;
          hash = (53 * hash) + getCornersList().hashCode();
        }
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal parseFrom(
          java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal parseFrom(
          java.nio.ByteBuffer data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal parseFrom(
          byte[] data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal parseFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal parseFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal parseDelimitedFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal parseDelimitedFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal parseFrom(
          com.google.protobuf.CodedInputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() { return newBuilder(); }
      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }
      public static Builder newBuilder(com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }
      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE
            ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * <pre>
       * A hyperlocal targeting location when available.
       * </pre>
       *
       * Protobuf type {@code com.google.protos.adx.BidRequest.Hyperlocal}
       */
      public static final class Builder extends
          com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
          // @@protoc_insertion_point(builder_implements:com.google.protos.adx.BidRequest.Hyperlocal)
          com.google.protos.adx.NetworkBid.BidRequest.HyperlocalOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
          return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_Hyperlocal_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_Hyperlocal_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.class, com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Builder.class);
        }

        // Construct using com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }
        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3
                  .alwaysUseFieldBuilders) {
            getCornersFieldBuilder();
          }
        }
        @java.lang.Override
        public Builder clear() {
          super.clear();
          if (cornersBuilder_ == null) {
            corners_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            cornersBuilder_.clear();
          }
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
          return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_Hyperlocal_descriptor;
        }

        @java.lang.Override
        public com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal getDefaultInstanceForType() {
          return com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal build() {
          com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal buildPartial() {
          com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal result = new com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal(this);
          int from_bitField0_ = bitField0_;
          if (cornersBuilder_ == null) {
            if (((bitField0_ & 0x00000001) != 0)) {
              corners_ = java.util.Collections.unmodifiableList(corners_);
              bitField0_ = (bitField0_ & ~0x00000001);
            }
            result.corners_ = corners_;
          } else {
            result.corners_ = cornersBuilder_.build();
          }
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }
        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.setField(field, value);
        }
        @java.lang.Override
        public Builder clearField(
            com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }
        @java.lang.Override
        public Builder clearOneof(
            com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }
        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index, java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }
        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }
        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal) {
            return mergeFrom((com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal)other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal other) {
          if (other == com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.getDefaultInstance()) return this;
          if (cornersBuilder_ == null) {
            if (!other.corners_.isEmpty()) {
              if (corners_.isEmpty()) {
                corners_ = other.corners_;
                bitField0_ = (bitField0_ & ~0x00000001);
              } else {
                ensureCornersIsMutable();
                corners_.addAll(other.corners_);
              }
              onChanged();
            }
          } else {
            if (!other.corners_.isEmpty()) {
              if (cornersBuilder_.isEmpty()) {
                cornersBuilder_.dispose();
                cornersBuilder_ = null;
                corners_ = other.corners_;
                bitField0_ = (bitField0_ & ~0x00000001);
                cornersBuilder_ = 
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                     getCornersFieldBuilder() : null;
              } else {
                cornersBuilder_.addAllMessages(other.corners_);
              }
            }
          }
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage = (com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal) e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }
        private int bitField0_;

        private java.util.List<com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point> corners_ =
          java.util.Collections.emptyList();
        private void ensureCornersIsMutable() {
          if (!((bitField0_ & 0x00000001) != 0)) {
            corners_ = new java.util.ArrayList<com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point>(corners_);
            bitField0_ |= 0x00000001;
           }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point, com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point.Builder, com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.PointOrBuilder> cornersBuilder_;

        /**
         * <pre>
         * The mobile device can be at any point inside the geofence polygon defined
         * by a list of corners. Currently, the polygon is always a parallelogram
         * with 4 corners.
         * </pre>
         *
         * <code>repeated .com.google.protos.adx.BidRequest.Hyperlocal.Point corners = 1;</code>
         */
        public java.util.List<com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point> getCornersList() {
          if (cornersBuilder_ == null) {
            return java.util.Collections.unmodifiableList(corners_);
          } else {
            return cornersBuilder_.getMessageList();
          }
        }
        /**
         * <pre>
         * The mobile device can be at any point inside the geofence polygon defined
         * by a list of corners. Currently, the polygon is always a parallelogram
         * with 4 corners.
         * </pre>
         *
         * <code>repeated .com.google.protos.adx.BidRequest.Hyperlocal.Point corners = 1;</code>
         */
        public int getCornersCount() {
          if (cornersBuilder_ == null) {
            return corners_.size();
          } else {
            return cornersBuilder_.getCount();
          }
        }
        /**
         * <pre>
         * The mobile device can be at any point inside the geofence polygon defined
         * by a list of corners. Currently, the polygon is always a parallelogram
         * with 4 corners.
         * </pre>
         *
         * <code>repeated .com.google.protos.adx.BidRequest.Hyperlocal.Point corners = 1;</code>
         */
        public com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point getCorners(int index) {
          if (cornersBuilder_ == null) {
            return corners_.get(index);
          } else {
            return cornersBuilder_.getMessage(index);
          }
        }
        /**
         * <pre>
         * The mobile device can be at any point inside the geofence polygon defined
         * by a list of corners. Currently, the polygon is always a parallelogram
         * with 4 corners.
         * </pre>
         *
         * <code>repeated .com.google.protos.adx.BidRequest.Hyperlocal.Point corners = 1;</code>
         */
        public Builder setCorners(
            int index, com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point value) {
          if (cornersBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureCornersIsMutable();
            corners_.set(index, value);
            onChanged();
          } else {
            cornersBuilder_.setMessage(index, value);
          }
          return this;
        }
        /**
         * <pre>
         * The mobile device can be at any point inside the geofence polygon defined
         * by a list of corners. Currently, the polygon is always a parallelogram
         * with 4 corners.
         * </pre>
         *
         * <code>repeated .com.google.protos.adx.BidRequest.Hyperlocal.Point corners = 1;</code>
         */
        public Builder setCorners(
            int index, com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point.Builder builderForValue) {
          if (cornersBuilder_ == null) {
            ensureCornersIsMutable();
            corners_.set(index, builderForValue.build());
            onChanged();
          } else {
            cornersBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         * <pre>
         * The mobile device can be at any point inside the geofence polygon defined
         * by a list of corners. Currently, the polygon is always a parallelogram
         * with 4 corners.
         * </pre>
         *
         * <code>repeated .com.google.protos.adx.BidRequest.Hyperlocal.Point corners = 1;</code>
         */
        public Builder addCorners(com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point value) {
          if (cornersBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureCornersIsMutable();
            corners_.add(value);
            onChanged();
          } else {
            cornersBuilder_.addMessage(value);
          }
          return this;
        }
        /**
         * <pre>
         * The mobile device can be at any point inside the geofence polygon defined
         * by a list of corners. Currently, the polygon is always a parallelogram
         * with 4 corners.
         * </pre>
         *
         * <code>repeated .com.google.protos.adx.BidRequest.Hyperlocal.Point corners = 1;</code>
         */
        public Builder addCorners(
            int index, com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point value) {
          if (cornersBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureCornersIsMutable();
            corners_.add(index, value);
            onChanged();
          } else {
            cornersBuilder_.addMessage(index, value);
          }
          return this;
        }
        /**
         * <pre>
         * The mobile device can be at any point inside the geofence polygon defined
         * by a list of corners. Currently, the polygon is always a parallelogram
         * with 4 corners.
         * </pre>
         *
         * <code>repeated .com.google.protos.adx.BidRequest.Hyperlocal.Point corners = 1;</code>
         */
        public Builder addCorners(
            com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point.Builder builderForValue) {
          if (cornersBuilder_ == null) {
            ensureCornersIsMutable();
            corners_.add(builderForValue.build());
            onChanged();
          } else {
            cornersBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }
        /**
         * <pre>
         * The mobile device can be at any point inside the geofence polygon defined
         * by a list of corners. Currently, the polygon is always a parallelogram
         * with 4 corners.
         * </pre>
         *
         * <code>repeated .com.google.protos.adx.BidRequest.Hyperlocal.Point corners = 1;</code>
         */
        public Builder addCorners(
            int index, com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point.Builder builderForValue) {
          if (cornersBuilder_ == null) {
            ensureCornersIsMutable();
            corners_.add(index, builderForValue.build());
            onChanged();
          } else {
            cornersBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         * <pre>
         * The mobile device can be at any point inside the geofence polygon defined
         * by a list of corners. Currently, the polygon is always a parallelogram
         * with 4 corners.
         * </pre>
         *
         * <code>repeated .com.google.protos.adx.BidRequest.Hyperlocal.Point corners = 1;</code>
         */
        public Builder addAllCorners(
            java.lang.Iterable<? extends com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point> values) {
          if (cornersBuilder_ == null) {
            ensureCornersIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(
                values, corners_);
            onChanged();
          } else {
            cornersBuilder_.addAllMessages(values);
          }
          return this;
        }
        /**
         * <pre>
         * The mobile device can be at any point inside the geofence polygon defined
         * by a list of corners. Currently, the polygon is always a parallelogram
         * with 4 corners.
         * </pre>
         *
         * <code>repeated .com.google.protos.adx.BidRequest.Hyperlocal.Point corners = 1;</code>
         */
        public Builder clearCorners() {
          if (cornersBuilder_ == null) {
            corners_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000001);
            onChanged();
          } else {
            cornersBuilder_.clear();
          }
          return this;
        }
        /**
         * <pre>
         * The mobile device can be at any point inside the geofence polygon defined
         * by a list of corners. Currently, the polygon is always a parallelogram
         * with 4 corners.
         * </pre>
         *
         * <code>repeated .com.google.protos.adx.BidRequest.Hyperlocal.Point corners = 1;</code>
         */
        public Builder removeCorners(int index) {
          if (cornersBuilder_ == null) {
            ensureCornersIsMutable();
            corners_.remove(index);
            onChanged();
          } else {
            cornersBuilder_.remove(index);
          }
          return this;
        }
        /**
         * <pre>
         * The mobile device can be at any point inside the geofence polygon defined
         * by a list of corners. Currently, the polygon is always a parallelogram
         * with 4 corners.
         * </pre>
         *
         * <code>repeated .com.google.protos.adx.BidRequest.Hyperlocal.Point corners = 1;</code>
         */
        public com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point.Builder getCornersBuilder(
            int index) {
          return getCornersFieldBuilder().getBuilder(index);
        }
        /**
         * <pre>
         * The mobile device can be at any point inside the geofence polygon defined
         * by a list of corners. Currently, the polygon is always a parallelogram
         * with 4 corners.
         * </pre>
         *
         * <code>repeated .com.google.protos.adx.BidRequest.Hyperlocal.Point corners = 1;</code>
         */
        public com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.PointOrBuilder getCornersOrBuilder(
            int index) {
          if (cornersBuilder_ == null) {
            return corners_.get(index);  } else {
            return cornersBuilder_.getMessageOrBuilder(index);
          }
        }
        /**
         * <pre>
         * The mobile device can be at any point inside the geofence polygon defined
         * by a list of corners. Currently, the polygon is always a parallelogram
         * with 4 corners.
         * </pre>
         *
         * <code>repeated .com.google.protos.adx.BidRequest.Hyperlocal.Point corners = 1;</code>
         */
        public java.util.List<? extends com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.PointOrBuilder> 
             getCornersOrBuilderList() {
          if (cornersBuilder_ != null) {
            return cornersBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(corners_);
          }
        }
        /**
         * <pre>
         * The mobile device can be at any point inside the geofence polygon defined
         * by a list of corners. Currently, the polygon is always a parallelogram
         * with 4 corners.
         * </pre>
         *
         * <code>repeated .com.google.protos.adx.BidRequest.Hyperlocal.Point corners = 1;</code>
         */
        public com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point.Builder addCornersBuilder() {
          return getCornersFieldBuilder().addBuilder(
              com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point.getDefaultInstance());
        }
        /**
         * <pre>
         * The mobile device can be at any point inside the geofence polygon defined
         * by a list of corners. Currently, the polygon is always a parallelogram
         * with 4 corners.
         * </pre>
         *
         * <code>repeated .com.google.protos.adx.BidRequest.Hyperlocal.Point corners = 1;</code>
         */
        public com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point.Builder addCornersBuilder(
            int index) {
          return getCornersFieldBuilder().addBuilder(
              index, com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point.getDefaultInstance());
        }
        /**
         * <pre>
         * The mobile device can be at any point inside the geofence polygon defined
         * by a list of corners. Currently, the polygon is always a parallelogram
         * with 4 corners.
         * </pre>
         *
         * <code>repeated .com.google.protos.adx.BidRequest.Hyperlocal.Point corners = 1;</code>
         */
        public java.util.List<com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point.Builder> 
             getCornersBuilderList() {
          return getCornersFieldBuilder().getBuilderList();
        }
        private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point, com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point.Builder, com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.PointOrBuilder> 
            getCornersFieldBuilder() {
          if (cornersBuilder_ == null) {
            cornersBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point, com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point.Builder, com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.PointOrBuilder>(
                    corners_,
                    ((bitField0_ & 0x00000001) != 0),
                    getParentForChildren(),
                    isClean());
            corners_ = null;
          }
          return cornersBuilder_;
        }
        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }


        // @@protoc_insertion_point(builder_scope:com.google.protos.adx.BidRequest.Hyperlocal)
      }

      // @@protoc_insertion_point(class_scope:com.google.protos.adx.BidRequest.Hyperlocal)
      private static final com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal DEFAULT_INSTANCE;
      static {
        DEFAULT_INSTANCE = new com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal();
      }

      public static com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      @java.lang.Deprecated public static final com.google.protobuf.Parser<Hyperlocal>
          PARSER = new com.google.protobuf.AbstractParser<Hyperlocal>() {
        @java.lang.Override
        public Hyperlocal parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new Hyperlocal(input, extensionRegistry);
        }
      };

      public static com.google.protobuf.Parser<Hyperlocal> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Hyperlocal> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }

    }

    public interface HyperlocalSetOrBuilder extends
        // @@protoc_insertion_point(interface_extends:com.google.protos.adx.BidRequest.HyperlocalSet)
        com.google.protobuf.MessageOrBuilder {

      /**
       * <pre>
       * This field currently contains at most one hyperlocal polygon.
       * </pre>
       *
       * <code>repeated .com.google.protos.adx.BidRequest.Hyperlocal hyperlocal = 1;</code>
       */
      java.util.List<com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal> 
          getHyperlocalList();
      /**
       * <pre>
       * This field currently contains at most one hyperlocal polygon.
       * </pre>
       *
       * <code>repeated .com.google.protos.adx.BidRequest.Hyperlocal hyperlocal = 1;</code>
       */
      com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal getHyperlocal(int index);
      /**
       * <pre>
       * This field currently contains at most one hyperlocal polygon.
       * </pre>
       *
       * <code>repeated .com.google.protos.adx.BidRequest.Hyperlocal hyperlocal = 1;</code>
       */
      int getHyperlocalCount();
      /**
       * <pre>
       * This field currently contains at most one hyperlocal polygon.
       * </pre>
       *
       * <code>repeated .com.google.protos.adx.BidRequest.Hyperlocal hyperlocal = 1;</code>
       */
      java.util.List<? extends com.google.protos.adx.NetworkBid.BidRequest.HyperlocalOrBuilder> 
          getHyperlocalOrBuilderList();
      /**
       * <pre>
       * This field currently contains at most one hyperlocal polygon.
       * </pre>
       *
       * <code>repeated .com.google.protos.adx.BidRequest.Hyperlocal hyperlocal = 1;</code>
       */
      com.google.protos.adx.NetworkBid.BidRequest.HyperlocalOrBuilder getHyperlocalOrBuilder(
          int index);

      /**
       * <pre>
       * The approximate geometric center of the geofence area. It is calculated
       * exclusively based on the geometric shape of the geofence area and in no
       * way indicates the mobile device's actual location within the geofence
       * area. If multiple hyperlocal polygons are specified above then
       * center_point is the geometric center of all hyperlocal polygons.
       * </pre>
       *
       * <code>optional .com.google.protos.adx.BidRequest.Hyperlocal.Point center_point = 2;</code>
       * @return Whether the centerPoint field is set.
       */
      boolean hasCenterPoint();
      /**
       * <pre>
       * The approximate geometric center of the geofence area. It is calculated
       * exclusively based on the geometric shape of the geofence area and in no
       * way indicates the mobile device's actual location within the geofence
       * area. If multiple hyperlocal polygons are specified above then
       * center_point is the geometric center of all hyperlocal polygons.
       * </pre>
       *
       * <code>optional .com.google.protos.adx.BidRequest.Hyperlocal.Point center_point = 2;</code>
       * @return The centerPoint.
       */
      com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point getCenterPoint();
      /**
       * <pre>
       * The approximate geometric center of the geofence area. It is calculated
       * exclusively based on the geometric shape of the geofence area and in no
       * way indicates the mobile device's actual location within the geofence
       * area. If multiple hyperlocal polygons are specified above then
       * center_point is the geometric center of all hyperlocal polygons.
       * </pre>
       *
       * <code>optional .com.google.protos.adx.BidRequest.Hyperlocal.Point center_point = 2;</code>
       */
      com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.PointOrBuilder getCenterPointOrBuilder();
    }
    /**
     * Protobuf type {@code com.google.protos.adx.BidRequest.HyperlocalSet}
     */
    public static final class HyperlocalSet extends
        com.google.protobuf.GeneratedMessageV3 implements
        // @@protoc_insertion_point(message_implements:com.google.protos.adx.BidRequest.HyperlocalSet)
        HyperlocalSetOrBuilder {
    private static final long serialVersionUID = 0L;
      // Use HyperlocalSet.newBuilder() to construct.
      private HyperlocalSet(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }
      private HyperlocalSet() {
        hyperlocal_ = java.util.Collections.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(
          UnusedPrivateParameter unused) {
        return new HyperlocalSet();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet
      getUnknownFields() {
        return this.unknownFields;
      }
      private HyperlocalSet(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        int mutable_bitField0_ = 0;
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                  hyperlocal_ = new java.util.ArrayList<com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal>();
                  mutable_bitField0_ |= 0x00000001;
                }
                hyperlocal_.add(
                    input.readMessage(com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.PARSER, extensionRegistry));
                break;
              }
              case 18: {
                com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point.Builder subBuilder = null;
                if (((bitField0_ & 0x00000001) != 0)) {
                  subBuilder = centerPoint_.toBuilder();
                }
                centerPoint_ = input.readMessage(com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point.PARSER, extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(centerPoint_);
                  centerPoint_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000001;
                break;
              }
              default: {
                if (!parseUnknownField(
                    input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(
              e).setUnfinishedMessage(this);
        } finally {
          if (((mutable_bitField0_ & 0x00000001) != 0)) {
            hyperlocal_ = java.util.Collections.unmodifiableList(hyperlocal_);
          }
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_HyperlocalSet_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_HyperlocalSet_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.protos.adx.NetworkBid.BidRequest.HyperlocalSet.class, com.google.protos.adx.NetworkBid.BidRequest.HyperlocalSet.Builder.class);
      }

      private int bitField0_;
      public static final int HYPERLOCAL_FIELD_NUMBER = 1;
      private java.util.List<com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal> hyperlocal_;
      /**
       * <pre>
       * This field currently contains at most one hyperlocal polygon.
       * </pre>
       *
       * <code>repeated .com.google.protos.adx.BidRequest.Hyperlocal hyperlocal = 1;</code>
       */
      @java.lang.Override
      public java.util.List<com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal> getHyperlocalList() {
        return hyperlocal_;
      }
      /**
       * <pre>
       * This field currently contains at most one hyperlocal polygon.
       * </pre>
       *
       * <code>repeated .com.google.protos.adx.BidRequest.Hyperlocal hyperlocal = 1;</code>
       */
      @java.lang.Override
      public java.util.List<? extends com.google.protos.adx.NetworkBid.BidRequest.HyperlocalOrBuilder> 
          getHyperlocalOrBuilderList() {
        return hyperlocal_;
      }
      /**
       * <pre>
       * This field currently contains at most one hyperlocal polygon.
       * </pre>
       *
       * <code>repeated .com.google.protos.adx.BidRequest.Hyperlocal hyperlocal = 1;</code>
       */
      @java.lang.Override
      public int getHyperlocalCount() {
        return hyperlocal_.size();
      }
      /**
       * <pre>
       * This field currently contains at most one hyperlocal polygon.
       * </pre>
       *
       * <code>repeated .com.google.protos.adx.BidRequest.Hyperlocal hyperlocal = 1;</code>
       */
      @java.lang.Override
      public com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal getHyperlocal(int index) {
        return hyperlocal_.get(index);
      }
      /**
       * <pre>
       * This field currently contains at most one hyperlocal polygon.
       * </pre>
       *
       * <code>repeated .com.google.protos.adx.BidRequest.Hyperlocal hyperlocal = 1;</code>
       */
      @java.lang.Override
      public com.google.protos.adx.NetworkBid.BidRequest.HyperlocalOrBuilder getHyperlocalOrBuilder(
          int index) {
        return hyperlocal_.get(index);
      }

      public static final int CENTER_POINT_FIELD_NUMBER = 2;
      private com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point centerPoint_;
      /**
       * <pre>
       * The approximate geometric center of the geofence area. It is calculated
       * exclusively based on the geometric shape of the geofence area and in no
       * way indicates the mobile device's actual location within the geofence
       * area. If multiple hyperlocal polygons are specified above then
       * center_point is the geometric center of all hyperlocal polygons.
       * </pre>
       *
       * <code>optional .com.google.protos.adx.BidRequest.Hyperlocal.Point center_point = 2;</code>
       * @return Whether the centerPoint field is set.
       */
      @java.lang.Override
      public boolean hasCenterPoint() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <pre>
       * The approximate geometric center of the geofence area. It is calculated
       * exclusively based on the geometric shape of the geofence area and in no
       * way indicates the mobile device's actual location within the geofence
       * area. If multiple hyperlocal polygons are specified above then
       * center_point is the geometric center of all hyperlocal polygons.
       * </pre>
       *
       * <code>optional .com.google.protos.adx.BidRequest.Hyperlocal.Point center_point = 2;</code>
       * @return The centerPoint.
       */
      @java.lang.Override
      public com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point getCenterPoint() {
        return centerPoint_ == null ? com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point.getDefaultInstance() : centerPoint_;
      }
      /**
       * <pre>
       * The approximate geometric center of the geofence area. It is calculated
       * exclusively based on the geometric shape of the geofence area and in no
       * way indicates the mobile device's actual location within the geofence
       * area. If multiple hyperlocal polygons are specified above then
       * center_point is the geometric center of all hyperlocal polygons.
       * </pre>
       *
       * <code>optional .com.google.protos.adx.BidRequest.Hyperlocal.Point center_point = 2;</code>
       */
      @java.lang.Override
      public com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.PointOrBuilder getCenterPointOrBuilder() {
        return centerPoint_ == null ? com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point.getDefaultInstance() : centerPoint_;
      }

      private byte memoizedIsInitialized = -1;
      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output)
                          throws java.io.IOException {
        for (int i = 0; i < hyperlocal_.size(); i++) {
          output.writeMessage(1, hyperlocal_.get(i));
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeMessage(2, getCenterPoint());
        }
        unknownFields.writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        for (int i = 0; i < hyperlocal_.size(); i++) {
          size += com.google.protobuf.CodedOutputStream
            .computeMessageSize(1, hyperlocal_.get(i));
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.CodedOutputStream
            .computeMessageSize(2, getCenterPoint());
        }
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
         return true;
        }
        if (!(obj instanceof com.google.protos.adx.NetworkBid.BidRequest.HyperlocalSet)) {
          return super.equals(obj);
        }
        com.google.protos.adx.NetworkBid.BidRequest.HyperlocalSet other = (com.google.protos.adx.NetworkBid.BidRequest.HyperlocalSet) obj;

        if (!getHyperlocalList()
            .equals(other.getHyperlocalList())) return false;
        if (hasCenterPoint() != other.hasCenterPoint()) return false;
        if (hasCenterPoint()) {
          if (!getCenterPoint()
              .equals(other.getCenterPoint())) return false;
        }
        if (!unknownFields.equals(other.unknownFields)) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (getHyperlocalCount() > 0) {
          hash = (37 * hash) + HYPERLOCAL_FIELD_NUMBER;
          hash = (53 * hash) + getHyperlocalList().hashCode();
        }
        if (hasCenterPoint()) {
          hash = (37 * hash) + CENTER_POINT_FIELD_NUMBER;
          hash = (53 * hash) + getCenterPoint().hashCode();
        }
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.protos.adx.NetworkBid.BidRequest.HyperlocalSet parseFrom(
          java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.HyperlocalSet parseFrom(
          java.nio.ByteBuffer data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.HyperlocalSet parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.HyperlocalSet parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.HyperlocalSet parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.HyperlocalSet parseFrom(
          byte[] data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.HyperlocalSet parseFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.HyperlocalSet parseFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.HyperlocalSet parseDelimitedFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.HyperlocalSet parseDelimitedFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.HyperlocalSet parseFrom(
          com.google.protobuf.CodedInputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.HyperlocalSet parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() { return newBuilder(); }
      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }
      public static Builder newBuilder(com.google.protos.adx.NetworkBid.BidRequest.HyperlocalSet prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }
      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE
            ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * Protobuf type {@code com.google.protos.adx.BidRequest.HyperlocalSet}
       */
      public static final class Builder extends
          com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
          // @@protoc_insertion_point(builder_implements:com.google.protos.adx.BidRequest.HyperlocalSet)
          com.google.protos.adx.NetworkBid.BidRequest.HyperlocalSetOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
          return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_HyperlocalSet_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_HyperlocalSet_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.protos.adx.NetworkBid.BidRequest.HyperlocalSet.class, com.google.protos.adx.NetworkBid.BidRequest.HyperlocalSet.Builder.class);
        }

        // Construct using com.google.protos.adx.NetworkBid.BidRequest.HyperlocalSet.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }
        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3
                  .alwaysUseFieldBuilders) {
            getHyperlocalFieldBuilder();
            getCenterPointFieldBuilder();
          }
        }
        @java.lang.Override
        public Builder clear() {
          super.clear();
          if (hyperlocalBuilder_ == null) {
            hyperlocal_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            hyperlocalBuilder_.clear();
          }
          if (centerPointBuilder_ == null) {
            centerPoint_ = null;
          } else {
            centerPointBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000002);
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
          return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_HyperlocalSet_descriptor;
        }

        @java.lang.Override
        public com.google.protos.adx.NetworkBid.BidRequest.HyperlocalSet getDefaultInstanceForType() {
          return com.google.protos.adx.NetworkBid.BidRequest.HyperlocalSet.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.protos.adx.NetworkBid.BidRequest.HyperlocalSet build() {
          com.google.protos.adx.NetworkBid.BidRequest.HyperlocalSet result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.protos.adx.NetworkBid.BidRequest.HyperlocalSet buildPartial() {
          com.google.protos.adx.NetworkBid.BidRequest.HyperlocalSet result = new com.google.protos.adx.NetworkBid.BidRequest.HyperlocalSet(this);
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (hyperlocalBuilder_ == null) {
            if (((bitField0_ & 0x00000001) != 0)) {
              hyperlocal_ = java.util.Collections.unmodifiableList(hyperlocal_);
              bitField0_ = (bitField0_ & ~0x00000001);
            }
            result.hyperlocal_ = hyperlocal_;
          } else {
            result.hyperlocal_ = hyperlocalBuilder_.build();
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            if (centerPointBuilder_ == null) {
              result.centerPoint_ = centerPoint_;
            } else {
              result.centerPoint_ = centerPointBuilder_.build();
            }
            to_bitField0_ |= 0x00000001;
          }
          result.bitField0_ = to_bitField0_;
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }
        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.setField(field, value);
        }
        @java.lang.Override
        public Builder clearField(
            com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }
        @java.lang.Override
        public Builder clearOneof(
            com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }
        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index, java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }
        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }
        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.protos.adx.NetworkBid.BidRequest.HyperlocalSet) {
            return mergeFrom((com.google.protos.adx.NetworkBid.BidRequest.HyperlocalSet)other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.google.protos.adx.NetworkBid.BidRequest.HyperlocalSet other) {
          if (other == com.google.protos.adx.NetworkBid.BidRequest.HyperlocalSet.getDefaultInstance()) return this;
          if (hyperlocalBuilder_ == null) {
            if (!other.hyperlocal_.isEmpty()) {
              if (hyperlocal_.isEmpty()) {
                hyperlocal_ = other.hyperlocal_;
                bitField0_ = (bitField0_ & ~0x00000001);
              } else {
                ensureHyperlocalIsMutable();
                hyperlocal_.addAll(other.hyperlocal_);
              }
              onChanged();
            }
          } else {
            if (!other.hyperlocal_.isEmpty()) {
              if (hyperlocalBuilder_.isEmpty()) {
                hyperlocalBuilder_.dispose();
                hyperlocalBuilder_ = null;
                hyperlocal_ = other.hyperlocal_;
                bitField0_ = (bitField0_ & ~0x00000001);
                hyperlocalBuilder_ = 
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                     getHyperlocalFieldBuilder() : null;
              } else {
                hyperlocalBuilder_.addAllMessages(other.hyperlocal_);
              }
            }
          }
          if (other.hasCenterPoint()) {
            mergeCenterPoint(other.getCenterPoint());
          }
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          com.google.protos.adx.NetworkBid.BidRequest.HyperlocalSet parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage = (com.google.protos.adx.NetworkBid.BidRequest.HyperlocalSet) e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }
        private int bitField0_;

        private java.util.List<com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal> hyperlocal_ =
          java.util.Collections.emptyList();
        private void ensureHyperlocalIsMutable() {
          if (!((bitField0_ & 0x00000001) != 0)) {
            hyperlocal_ = new java.util.ArrayList<com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal>(hyperlocal_);
            bitField0_ |= 0x00000001;
           }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal, com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Builder, com.google.protos.adx.NetworkBid.BidRequest.HyperlocalOrBuilder> hyperlocalBuilder_;

        /**
         * <pre>
         * This field currently contains at most one hyperlocal polygon.
         * </pre>
         *
         * <code>repeated .com.google.protos.adx.BidRequest.Hyperlocal hyperlocal = 1;</code>
         */
        public java.util.List<com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal> getHyperlocalList() {
          if (hyperlocalBuilder_ == null) {
            return java.util.Collections.unmodifiableList(hyperlocal_);
          } else {
            return hyperlocalBuilder_.getMessageList();
          }
        }
        /**
         * <pre>
         * This field currently contains at most one hyperlocal polygon.
         * </pre>
         *
         * <code>repeated .com.google.protos.adx.BidRequest.Hyperlocal hyperlocal = 1;</code>
         */
        public int getHyperlocalCount() {
          if (hyperlocalBuilder_ == null) {
            return hyperlocal_.size();
          } else {
            return hyperlocalBuilder_.getCount();
          }
        }
        /**
         * <pre>
         * This field currently contains at most one hyperlocal polygon.
         * </pre>
         *
         * <code>repeated .com.google.protos.adx.BidRequest.Hyperlocal hyperlocal = 1;</code>
         */
        public com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal getHyperlocal(int index) {
          if (hyperlocalBuilder_ == null) {
            return hyperlocal_.get(index);
          } else {
            return hyperlocalBuilder_.getMessage(index);
          }
        }
        /**
         * <pre>
         * This field currently contains at most one hyperlocal polygon.
         * </pre>
         *
         * <code>repeated .com.google.protos.adx.BidRequest.Hyperlocal hyperlocal = 1;</code>
         */
        public Builder setHyperlocal(
            int index, com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal value) {
          if (hyperlocalBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureHyperlocalIsMutable();
            hyperlocal_.set(index, value);
            onChanged();
          } else {
            hyperlocalBuilder_.setMessage(index, value);
          }
          return this;
        }
        /**
         * <pre>
         * This field currently contains at most one hyperlocal polygon.
         * </pre>
         *
         * <code>repeated .com.google.protos.adx.BidRequest.Hyperlocal hyperlocal = 1;</code>
         */
        public Builder setHyperlocal(
            int index, com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Builder builderForValue) {
          if (hyperlocalBuilder_ == null) {
            ensureHyperlocalIsMutable();
            hyperlocal_.set(index, builderForValue.build());
            onChanged();
          } else {
            hyperlocalBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         * <pre>
         * This field currently contains at most one hyperlocal polygon.
         * </pre>
         *
         * <code>repeated .com.google.protos.adx.BidRequest.Hyperlocal hyperlocal = 1;</code>
         */
        public Builder addHyperlocal(com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal value) {
          if (hyperlocalBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureHyperlocalIsMutable();
            hyperlocal_.add(value);
            onChanged();
          } else {
            hyperlocalBuilder_.addMessage(value);
          }
          return this;
        }
        /**
         * <pre>
         * This field currently contains at most one hyperlocal polygon.
         * </pre>
         *
         * <code>repeated .com.google.protos.adx.BidRequest.Hyperlocal hyperlocal = 1;</code>
         */
        public Builder addHyperlocal(
            int index, com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal value) {
          if (hyperlocalBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureHyperlocalIsMutable();
            hyperlocal_.add(index, value);
            onChanged();
          } else {
            hyperlocalBuilder_.addMessage(index, value);
          }
          return this;
        }
        /**
         * <pre>
         * This field currently contains at most one hyperlocal polygon.
         * </pre>
         *
         * <code>repeated .com.google.protos.adx.BidRequest.Hyperlocal hyperlocal = 1;</code>
         */
        public Builder addHyperlocal(
            com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Builder builderForValue) {
          if (hyperlocalBuilder_ == null) {
            ensureHyperlocalIsMutable();
            hyperlocal_.add(builderForValue.build());
            onChanged();
          } else {
            hyperlocalBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }
        /**
         * <pre>
         * This field currently contains at most one hyperlocal polygon.
         * </pre>
         *
         * <code>repeated .com.google.protos.adx.BidRequest.Hyperlocal hyperlocal = 1;</code>
         */
        public Builder addHyperlocal(
            int index, com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Builder builderForValue) {
          if (hyperlocalBuilder_ == null) {
            ensureHyperlocalIsMutable();
            hyperlocal_.add(index, builderForValue.build());
            onChanged();
          } else {
            hyperlocalBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         * <pre>
         * This field currently contains at most one hyperlocal polygon.
         * </pre>
         *
         * <code>repeated .com.google.protos.adx.BidRequest.Hyperlocal hyperlocal = 1;</code>
         */
        public Builder addAllHyperlocal(
            java.lang.Iterable<? extends com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal> values) {
          if (hyperlocalBuilder_ == null) {
            ensureHyperlocalIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(
                values, hyperlocal_);
            onChanged();
          } else {
            hyperlocalBuilder_.addAllMessages(values);
          }
          return this;
        }
        /**
         * <pre>
         * This field currently contains at most one hyperlocal polygon.
         * </pre>
         *
         * <code>repeated .com.google.protos.adx.BidRequest.Hyperlocal hyperlocal = 1;</code>
         */
        public Builder clearHyperlocal() {
          if (hyperlocalBuilder_ == null) {
            hyperlocal_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000001);
            onChanged();
          } else {
            hyperlocalBuilder_.clear();
          }
          return this;
        }
        /**
         * <pre>
         * This field currently contains at most one hyperlocal polygon.
         * </pre>
         *
         * <code>repeated .com.google.protos.adx.BidRequest.Hyperlocal hyperlocal = 1;</code>
         */
        public Builder removeHyperlocal(int index) {
          if (hyperlocalBuilder_ == null) {
            ensureHyperlocalIsMutable();
            hyperlocal_.remove(index);
            onChanged();
          } else {
            hyperlocalBuilder_.remove(index);
          }
          return this;
        }
        /**
         * <pre>
         * This field currently contains at most one hyperlocal polygon.
         * </pre>
         *
         * <code>repeated .com.google.protos.adx.BidRequest.Hyperlocal hyperlocal = 1;</code>
         */
        public com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Builder getHyperlocalBuilder(
            int index) {
          return getHyperlocalFieldBuilder().getBuilder(index);
        }
        /**
         * <pre>
         * This field currently contains at most one hyperlocal polygon.
         * </pre>
         *
         * <code>repeated .com.google.protos.adx.BidRequest.Hyperlocal hyperlocal = 1;</code>
         */
        public com.google.protos.adx.NetworkBid.BidRequest.HyperlocalOrBuilder getHyperlocalOrBuilder(
            int index) {
          if (hyperlocalBuilder_ == null) {
            return hyperlocal_.get(index);  } else {
            return hyperlocalBuilder_.getMessageOrBuilder(index);
          }
        }
        /**
         * <pre>
         * This field currently contains at most one hyperlocal polygon.
         * </pre>
         *
         * <code>repeated .com.google.protos.adx.BidRequest.Hyperlocal hyperlocal = 1;</code>
         */
        public java.util.List<? extends com.google.protos.adx.NetworkBid.BidRequest.HyperlocalOrBuilder> 
             getHyperlocalOrBuilderList() {
          if (hyperlocalBuilder_ != null) {
            return hyperlocalBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(hyperlocal_);
          }
        }
        /**
         * <pre>
         * This field currently contains at most one hyperlocal polygon.
         * </pre>
         *
         * <code>repeated .com.google.protos.adx.BidRequest.Hyperlocal hyperlocal = 1;</code>
         */
        public com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Builder addHyperlocalBuilder() {
          return getHyperlocalFieldBuilder().addBuilder(
              com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.getDefaultInstance());
        }
        /**
         * <pre>
         * This field currently contains at most one hyperlocal polygon.
         * </pre>
         *
         * <code>repeated .com.google.protos.adx.BidRequest.Hyperlocal hyperlocal = 1;</code>
         */
        public com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Builder addHyperlocalBuilder(
            int index) {
          return getHyperlocalFieldBuilder().addBuilder(
              index, com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.getDefaultInstance());
        }
        /**
         * <pre>
         * This field currently contains at most one hyperlocal polygon.
         * </pre>
         *
         * <code>repeated .com.google.protos.adx.BidRequest.Hyperlocal hyperlocal = 1;</code>
         */
        public java.util.List<com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Builder> 
             getHyperlocalBuilderList() {
          return getHyperlocalFieldBuilder().getBuilderList();
        }
        private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal, com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Builder, com.google.protos.adx.NetworkBid.BidRequest.HyperlocalOrBuilder> 
            getHyperlocalFieldBuilder() {
          if (hyperlocalBuilder_ == null) {
            hyperlocalBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal, com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Builder, com.google.protos.adx.NetworkBid.BidRequest.HyperlocalOrBuilder>(
                    hyperlocal_,
                    ((bitField0_ & 0x00000001) != 0),
                    getParentForChildren(),
                    isClean());
            hyperlocal_ = null;
          }
          return hyperlocalBuilder_;
        }

        private com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point centerPoint_;
        private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point, com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point.Builder, com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.PointOrBuilder> centerPointBuilder_;
        /**
         * <pre>
         * The approximate geometric center of the geofence area. It is calculated
         * exclusively based on the geometric shape of the geofence area and in no
         * way indicates the mobile device's actual location within the geofence
         * area. If multiple hyperlocal polygons are specified above then
         * center_point is the geometric center of all hyperlocal polygons.
         * </pre>
         *
         * <code>optional .com.google.protos.adx.BidRequest.Hyperlocal.Point center_point = 2;</code>
         * @return Whether the centerPoint field is set.
         */
        public boolean hasCenterPoint() {
          return ((bitField0_ & 0x00000002) != 0);
        }
        /**
         * <pre>
         * The approximate geometric center of the geofence area. It is calculated
         * exclusively based on the geometric shape of the geofence area and in no
         * way indicates the mobile device's actual location within the geofence
         * area. If multiple hyperlocal polygons are specified above then
         * center_point is the geometric center of all hyperlocal polygons.
         * </pre>
         *
         * <code>optional .com.google.protos.adx.BidRequest.Hyperlocal.Point center_point = 2;</code>
         * @return The centerPoint.
         */
        public com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point getCenterPoint() {
          if (centerPointBuilder_ == null) {
            return centerPoint_ == null ? com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point.getDefaultInstance() : centerPoint_;
          } else {
            return centerPointBuilder_.getMessage();
          }
        }
        /**
         * <pre>
         * The approximate geometric center of the geofence area. It is calculated
         * exclusively based on the geometric shape of the geofence area and in no
         * way indicates the mobile device's actual location within the geofence
         * area. If multiple hyperlocal polygons are specified above then
         * center_point is the geometric center of all hyperlocal polygons.
         * </pre>
         *
         * <code>optional .com.google.protos.adx.BidRequest.Hyperlocal.Point center_point = 2;</code>
         */
        public Builder setCenterPoint(com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point value) {
          if (centerPointBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            centerPoint_ = value;
            onChanged();
          } else {
            centerPointBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000002;
          return this;
        }
        /**
         * <pre>
         * The approximate geometric center of the geofence area. It is calculated
         * exclusively based on the geometric shape of the geofence area and in no
         * way indicates the mobile device's actual location within the geofence
         * area. If multiple hyperlocal polygons are specified above then
         * center_point is the geometric center of all hyperlocal polygons.
         * </pre>
         *
         * <code>optional .com.google.protos.adx.BidRequest.Hyperlocal.Point center_point = 2;</code>
         */
        public Builder setCenterPoint(
            com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point.Builder builderForValue) {
          if (centerPointBuilder_ == null) {
            centerPoint_ = builderForValue.build();
            onChanged();
          } else {
            centerPointBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000002;
          return this;
        }
        /**
         * <pre>
         * The approximate geometric center of the geofence area. It is calculated
         * exclusively based on the geometric shape of the geofence area and in no
         * way indicates the mobile device's actual location within the geofence
         * area. If multiple hyperlocal polygons are specified above then
         * center_point is the geometric center of all hyperlocal polygons.
         * </pre>
         *
         * <code>optional .com.google.protos.adx.BidRequest.Hyperlocal.Point center_point = 2;</code>
         */
        public Builder mergeCenterPoint(com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point value) {
          if (centerPointBuilder_ == null) {
            if (((bitField0_ & 0x00000002) != 0) &&
                centerPoint_ != null &&
                centerPoint_ != com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point.getDefaultInstance()) {
              centerPoint_ =
                com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point.newBuilder(centerPoint_).mergeFrom(value).buildPartial();
            } else {
              centerPoint_ = value;
            }
            onChanged();
          } else {
            centerPointBuilder_.mergeFrom(value);
          }
          bitField0_ |= 0x00000002;
          return this;
        }
        /**
         * <pre>
         * The approximate geometric center of the geofence area. It is calculated
         * exclusively based on the geometric shape of the geofence area and in no
         * way indicates the mobile device's actual location within the geofence
         * area. If multiple hyperlocal polygons are specified above then
         * center_point is the geometric center of all hyperlocal polygons.
         * </pre>
         *
         * <code>optional .com.google.protos.adx.BidRequest.Hyperlocal.Point center_point = 2;</code>
         */
        public Builder clearCenterPoint() {
          if (centerPointBuilder_ == null) {
            centerPoint_ = null;
            onChanged();
          } else {
            centerPointBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000002);
          return this;
        }
        /**
         * <pre>
         * The approximate geometric center of the geofence area. It is calculated
         * exclusively based on the geometric shape of the geofence area and in no
         * way indicates the mobile device's actual location within the geofence
         * area. If multiple hyperlocal polygons are specified above then
         * center_point is the geometric center of all hyperlocal polygons.
         * </pre>
         *
         * <code>optional .com.google.protos.adx.BidRequest.Hyperlocal.Point center_point = 2;</code>
         */
        public com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point.Builder getCenterPointBuilder() {
          bitField0_ |= 0x00000002;
          onChanged();
          return getCenterPointFieldBuilder().getBuilder();
        }
        /**
         * <pre>
         * The approximate geometric center of the geofence area. It is calculated
         * exclusively based on the geometric shape of the geofence area and in no
         * way indicates the mobile device's actual location within the geofence
         * area. If multiple hyperlocal polygons are specified above then
         * center_point is the geometric center of all hyperlocal polygons.
         * </pre>
         *
         * <code>optional .com.google.protos.adx.BidRequest.Hyperlocal.Point center_point = 2;</code>
         */
        public com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.PointOrBuilder getCenterPointOrBuilder() {
          if (centerPointBuilder_ != null) {
            return centerPointBuilder_.getMessageOrBuilder();
          } else {
            return centerPoint_ == null ?
                com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point.getDefaultInstance() : centerPoint_;
          }
        }
        /**
         * <pre>
         * The approximate geometric center of the geofence area. It is calculated
         * exclusively based on the geometric shape of the geofence area and in no
         * way indicates the mobile device's actual location within the geofence
         * area. If multiple hyperlocal polygons are specified above then
         * center_point is the geometric center of all hyperlocal polygons.
         * </pre>
         *
         * <code>optional .com.google.protos.adx.BidRequest.Hyperlocal.Point center_point = 2;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point, com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point.Builder, com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.PointOrBuilder> 
            getCenterPointFieldBuilder() {
          if (centerPointBuilder_ == null) {
            centerPointBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point, com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.Point.Builder, com.google.protos.adx.NetworkBid.BidRequest.Hyperlocal.PointOrBuilder>(
                    getCenterPoint(),
                    getParentForChildren(),
                    isClean());
            centerPoint_ = null;
          }
          return centerPointBuilder_;
        }
        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }


        // @@protoc_insertion_point(builder_scope:com.google.protos.adx.BidRequest.HyperlocalSet)
      }

      // @@protoc_insertion_point(class_scope:com.google.protos.adx.BidRequest.HyperlocalSet)
      private static final com.google.protos.adx.NetworkBid.BidRequest.HyperlocalSet DEFAULT_INSTANCE;
      static {
        DEFAULT_INSTANCE = new com.google.protos.adx.NetworkBid.BidRequest.HyperlocalSet();
      }

      public static com.google.protos.adx.NetworkBid.BidRequest.HyperlocalSet getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      @java.lang.Deprecated public static final com.google.protobuf.Parser<HyperlocalSet>
          PARSER = new com.google.protobuf.AbstractParser<HyperlocalSet>() {
        @java.lang.Override
        public HyperlocalSet parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new HyperlocalSet(input, extensionRegistry);
        }
      };

      public static com.google.protobuf.Parser<HyperlocalSet> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<HyperlocalSet> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protos.adx.NetworkBid.BidRequest.HyperlocalSet getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }

    }

    public interface UserListOrBuilder extends
        // @@protoc_insertion_point(interface_extends:com.google.protos.adx.BidRequest.UserList)
        com.google.protobuf.MessageOrBuilder {

      /**
       * <pre>
       * The user list id.
       * </pre>
       *
       * <code>optional int64 id = 1;</code>
       * @return Whether the id field is set.
       */
      boolean hasId();
      /**
       * <pre>
       * The user list id.
       * </pre>
       *
       * <code>optional int64 id = 1;</code>
       * @return The id.
       */
      long getId();

      /**
       * <pre>
       * The time in seconds since the user was added to the list.
       * </pre>
       *
       * <code>optional int32 age_seconds = 2;</code>
       * @return Whether the ageSeconds field is set.
       */
      boolean hasAgeSeconds();
      /**
       * <pre>
       * The time in seconds since the user was added to the list.
       * </pre>
       *
       * <code>optional int32 age_seconds = 2;</code>
       * @return The ageSeconds.
       */
      int getAgeSeconds();
    }
    /**
     * <pre>
     * This field is not populated by default. We recommend that bidders instead
     * store and look up list ids using either google_user_id or hosted_match_data
     * as keys.
     * </pre>
     *
     * Protobuf type {@code com.google.protos.adx.BidRequest.UserList}
     */
    public static final class UserList extends
        com.google.protobuf.GeneratedMessageV3 implements
        // @@protoc_insertion_point(message_implements:com.google.protos.adx.BidRequest.UserList)
        UserListOrBuilder {
    private static final long serialVersionUID = 0L;
      // Use UserList.newBuilder() to construct.
      private UserList(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }
      private UserList() {
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(
          UnusedPrivateParameter unused) {
        return new UserList();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet
      getUnknownFields() {
        return this.unknownFields;
      }
      private UserList(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        int mutable_bitField0_ = 0;
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8: {
                bitField0_ |= 0x00000001;
                id_ = input.readInt64();
                break;
              }
              case 16: {
                bitField0_ |= 0x00000002;
                ageSeconds_ = input.readInt32();
                break;
              }
              default: {
                if (!parseUnknownField(
                    input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(
              e).setUnfinishedMessage(this);
        } finally {
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_UserList_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_UserList_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.protos.adx.NetworkBid.BidRequest.UserList.class, com.google.protos.adx.NetworkBid.BidRequest.UserList.Builder.class);
      }

      private int bitField0_;
      public static final int ID_FIELD_NUMBER = 1;
      private long id_;
      /**
       * <pre>
       * The user list id.
       * </pre>
       *
       * <code>optional int64 id = 1;</code>
       * @return Whether the id field is set.
       */
      @java.lang.Override
      public boolean hasId() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <pre>
       * The user list id.
       * </pre>
       *
       * <code>optional int64 id = 1;</code>
       * @return The id.
       */
      @java.lang.Override
      public long getId() {
        return id_;
      }

      public static final int AGE_SECONDS_FIELD_NUMBER = 2;
      private int ageSeconds_;
      /**
       * <pre>
       * The time in seconds since the user was added to the list.
       * </pre>
       *
       * <code>optional int32 age_seconds = 2;</code>
       * @return Whether the ageSeconds field is set.
       */
      @java.lang.Override
      public boolean hasAgeSeconds() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <pre>
       * The time in seconds since the user was added to the list.
       * </pre>
       *
       * <code>optional int32 age_seconds = 2;</code>
       * @return The ageSeconds.
       */
      @java.lang.Override
      public int getAgeSeconds() {
        return ageSeconds_;
      }

      private byte memoizedIsInitialized = -1;
      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output)
                          throws java.io.IOException {
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeInt64(1, id_);
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          output.writeInt32(2, ageSeconds_);
        }
        unknownFields.writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.CodedOutputStream
            .computeInt64Size(1, id_);
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          size += com.google.protobuf.CodedOutputStream
            .computeInt32Size(2, ageSeconds_);
        }
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
         return true;
        }
        if (!(obj instanceof com.google.protos.adx.NetworkBid.BidRequest.UserList)) {
          return super.equals(obj);
        }
        com.google.protos.adx.NetworkBid.BidRequest.UserList other = (com.google.protos.adx.NetworkBid.BidRequest.UserList) obj;

        if (hasId() != other.hasId()) return false;
        if (hasId()) {
          if (getId()
              != other.getId()) return false;
        }
        if (hasAgeSeconds() != other.hasAgeSeconds()) return false;
        if (hasAgeSeconds()) {
          if (getAgeSeconds()
              != other.getAgeSeconds()) return false;
        }
        if (!unknownFields.equals(other.unknownFields)) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasId()) {
          hash = (37 * hash) + ID_FIELD_NUMBER;
          hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
              getId());
        }
        if (hasAgeSeconds()) {
          hash = (37 * hash) + AGE_SECONDS_FIELD_NUMBER;
          hash = (53 * hash) + getAgeSeconds();
        }
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.protos.adx.NetworkBid.BidRequest.UserList parseFrom(
          java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.UserList parseFrom(
          java.nio.ByteBuffer data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.UserList parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.UserList parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.UserList parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.UserList parseFrom(
          byte[] data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.UserList parseFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.UserList parseFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.UserList parseDelimitedFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.UserList parseDelimitedFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.UserList parseFrom(
          com.google.protobuf.CodedInputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.UserList parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() { return newBuilder(); }
      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }
      public static Builder newBuilder(com.google.protos.adx.NetworkBid.BidRequest.UserList prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }
      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE
            ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * <pre>
       * This field is not populated by default. We recommend that bidders instead
       * store and look up list ids using either google_user_id or hosted_match_data
       * as keys.
       * </pre>
       *
       * Protobuf type {@code com.google.protos.adx.BidRequest.UserList}
       */
      public static final class Builder extends
          com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
          // @@protoc_insertion_point(builder_implements:com.google.protos.adx.BidRequest.UserList)
          com.google.protos.adx.NetworkBid.BidRequest.UserListOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
          return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_UserList_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_UserList_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.protos.adx.NetworkBid.BidRequest.UserList.class, com.google.protos.adx.NetworkBid.BidRequest.UserList.Builder.class);
        }

        // Construct using com.google.protos.adx.NetworkBid.BidRequest.UserList.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }
        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3
                  .alwaysUseFieldBuilders) {
          }
        }
        @java.lang.Override
        public Builder clear() {
          super.clear();
          id_ = 0L;
          bitField0_ = (bitField0_ & ~0x00000001);
          ageSeconds_ = 0;
          bitField0_ = (bitField0_ & ~0x00000002);
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
          return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_UserList_descriptor;
        }

        @java.lang.Override
        public com.google.protos.adx.NetworkBid.BidRequest.UserList getDefaultInstanceForType() {
          return com.google.protos.adx.NetworkBid.BidRequest.UserList.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.protos.adx.NetworkBid.BidRequest.UserList build() {
          com.google.protos.adx.NetworkBid.BidRequest.UserList result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.protos.adx.NetworkBid.BidRequest.UserList buildPartial() {
          com.google.protos.adx.NetworkBid.BidRequest.UserList result = new com.google.protos.adx.NetworkBid.BidRequest.UserList(this);
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.id_ = id_;
            to_bitField0_ |= 0x00000001;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.ageSeconds_ = ageSeconds_;
            to_bitField0_ |= 0x00000002;
          }
          result.bitField0_ = to_bitField0_;
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }
        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.setField(field, value);
        }
        @java.lang.Override
        public Builder clearField(
            com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }
        @java.lang.Override
        public Builder clearOneof(
            com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }
        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index, java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }
        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }
        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.protos.adx.NetworkBid.BidRequest.UserList) {
            return mergeFrom((com.google.protos.adx.NetworkBid.BidRequest.UserList)other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.google.protos.adx.NetworkBid.BidRequest.UserList other) {
          if (other == com.google.protos.adx.NetworkBid.BidRequest.UserList.getDefaultInstance()) return this;
          if (other.hasId()) {
            setId(other.getId());
          }
          if (other.hasAgeSeconds()) {
            setAgeSeconds(other.getAgeSeconds());
          }
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          com.google.protos.adx.NetworkBid.BidRequest.UserList parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage = (com.google.protos.adx.NetworkBid.BidRequest.UserList) e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }
        private int bitField0_;

        private long id_ ;
        /**
         * <pre>
         * The user list id.
         * </pre>
         *
         * <code>optional int64 id = 1;</code>
         * @return Whether the id field is set.
         */
        @java.lang.Override
        public boolean hasId() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         * <pre>
         * The user list id.
         * </pre>
         *
         * <code>optional int64 id = 1;</code>
         * @return The id.
         */
        @java.lang.Override
        public long getId() {
          return id_;
        }
        /**
         * <pre>
         * The user list id.
         * </pre>
         *
         * <code>optional int64 id = 1;</code>
         * @param value The id to set.
         * @return This builder for chaining.
         */
        public Builder setId(long value) {
          bitField0_ |= 0x00000001;
          id_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * The user list id.
         * </pre>
         *
         * <code>optional int64 id = 1;</code>
         * @return This builder for chaining.
         */
        public Builder clearId() {
          bitField0_ = (bitField0_ & ~0x00000001);
          id_ = 0L;
          onChanged();
          return this;
        }

        private int ageSeconds_ ;
        /**
         * <pre>
         * The time in seconds since the user was added to the list.
         * </pre>
         *
         * <code>optional int32 age_seconds = 2;</code>
         * @return Whether the ageSeconds field is set.
         */
        @java.lang.Override
        public boolean hasAgeSeconds() {
          return ((bitField0_ & 0x00000002) != 0);
        }
        /**
         * <pre>
         * The time in seconds since the user was added to the list.
         * </pre>
         *
         * <code>optional int32 age_seconds = 2;</code>
         * @return The ageSeconds.
         */
        @java.lang.Override
        public int getAgeSeconds() {
          return ageSeconds_;
        }
        /**
         * <pre>
         * The time in seconds since the user was added to the list.
         * </pre>
         *
         * <code>optional int32 age_seconds = 2;</code>
         * @param value The ageSeconds to set.
         * @return This builder for chaining.
         */
        public Builder setAgeSeconds(int value) {
          bitField0_ |= 0x00000002;
          ageSeconds_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * The time in seconds since the user was added to the list.
         * </pre>
         *
         * <code>optional int32 age_seconds = 2;</code>
         * @return This builder for chaining.
         */
        public Builder clearAgeSeconds() {
          bitField0_ = (bitField0_ & ~0x00000002);
          ageSeconds_ = 0;
          onChanged();
          return this;
        }
        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }


        // @@protoc_insertion_point(builder_scope:com.google.protos.adx.BidRequest.UserList)
      }

      // @@protoc_insertion_point(class_scope:com.google.protos.adx.BidRequest.UserList)
      private static final com.google.protos.adx.NetworkBid.BidRequest.UserList DEFAULT_INSTANCE;
      static {
        DEFAULT_INSTANCE = new com.google.protos.adx.NetworkBid.BidRequest.UserList();
      }

      public static com.google.protos.adx.NetworkBid.BidRequest.UserList getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      @java.lang.Deprecated public static final com.google.protobuf.Parser<UserList>
          PARSER = new com.google.protobuf.AbstractParser<UserList>() {
        @java.lang.Override
        public UserList parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new UserList(input, extensionRegistry);
        }
      };

      public static com.google.protobuf.Parser<UserList> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<UserList> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protos.adx.NetworkBid.BidRequest.UserList getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }

    }

    public interface VerticalOrBuilder extends
        // @@protoc_insertion_point(interface_extends:com.google.protos.adx.BidRequest.Vertical)
        com.google.protobuf.MessageOrBuilder {

      /**
       * <pre>
       * The vertical id. See the publisher-verticals.txt file in the technical
       * documentation for a list of ids.
       * </pre>
       *
       * <code>required int32 id = 1;</code>
       * @return Whether the id field is set.
       */
      boolean hasId();
      /**
       * <pre>
       * The vertical id. See the publisher-verticals.txt file in the technical
       * documentation for a list of ids.
       * </pre>
       *
       * <code>required int32 id = 1;</code>
       * @return The id.
       */
      int getId();

      /**
       * <pre>
       * Weight for this vertical, in the (0.0, 1.0] range. More relevant
       * verticals have higher weights.
       * </pre>
       *
       * <code>required float weight = 2;</code>
       * @return Whether the weight field is set.
       */
      boolean hasWeight();
      /**
       * <pre>
       * Weight for this vertical, in the (0.0, 1.0] range. More relevant
       * verticals have higher weights.
       * </pre>
       *
       * <code>required float weight = 2;</code>
       * @return The weight.
       */
      float getWeight();
    }
    /**
     * <pre>
     * One or more detected verticals for the page as determined by Google.
     * </pre>
     *
     * Protobuf type {@code com.google.protos.adx.BidRequest.Vertical}
     */
    public static final class Vertical extends
        com.google.protobuf.GeneratedMessageV3 implements
        // @@protoc_insertion_point(message_implements:com.google.protos.adx.BidRequest.Vertical)
        VerticalOrBuilder {
    private static final long serialVersionUID = 0L;
      // Use Vertical.newBuilder() to construct.
      private Vertical(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }
      private Vertical() {
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(
          UnusedPrivateParameter unused) {
        return new Vertical();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet
      getUnknownFields() {
        return this.unknownFields;
      }
      private Vertical(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        int mutable_bitField0_ = 0;
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8: {
                bitField0_ |= 0x00000001;
                id_ = input.readInt32();
                break;
              }
              case 21: {
                bitField0_ |= 0x00000002;
                weight_ = input.readFloat();
                break;
              }
              default: {
                if (!parseUnknownField(
                    input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(
              e).setUnfinishedMessage(this);
        } finally {
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_Vertical_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_Vertical_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.protos.adx.NetworkBid.BidRequest.Vertical.class, com.google.protos.adx.NetworkBid.BidRequest.Vertical.Builder.class);
      }

      private int bitField0_;
      public static final int ID_FIELD_NUMBER = 1;
      private int id_;
      /**
       * <pre>
       * The vertical id. See the publisher-verticals.txt file in the technical
       * documentation for a list of ids.
       * </pre>
       *
       * <code>required int32 id = 1;</code>
       * @return Whether the id field is set.
       */
      @java.lang.Override
      public boolean hasId() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <pre>
       * The vertical id. See the publisher-verticals.txt file in the technical
       * documentation for a list of ids.
       * </pre>
       *
       * <code>required int32 id = 1;</code>
       * @return The id.
       */
      @java.lang.Override
      public int getId() {
        return id_;
      }

      public static final int WEIGHT_FIELD_NUMBER = 2;
      private float weight_;
      /**
       * <pre>
       * Weight for this vertical, in the (0.0, 1.0] range. More relevant
       * verticals have higher weights.
       * </pre>
       *
       * <code>required float weight = 2;</code>
       * @return Whether the weight field is set.
       */
      @java.lang.Override
      public boolean hasWeight() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <pre>
       * Weight for this vertical, in the (0.0, 1.0] range. More relevant
       * verticals have higher weights.
       * </pre>
       *
       * <code>required float weight = 2;</code>
       * @return The weight.
       */
      @java.lang.Override
      public float getWeight() {
        return weight_;
      }

      private byte memoizedIsInitialized = -1;
      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        if (!hasId()) {
          memoizedIsInitialized = 0;
          return false;
        }
        if (!hasWeight()) {
          memoizedIsInitialized = 0;
          return false;
        }
        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output)
                          throws java.io.IOException {
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeInt32(1, id_);
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          output.writeFloat(2, weight_);
        }
        unknownFields.writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.CodedOutputStream
            .computeInt32Size(1, id_);
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          size += com.google.protobuf.CodedOutputStream
            .computeFloatSize(2, weight_);
        }
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
         return true;
        }
        if (!(obj instanceof com.google.protos.adx.NetworkBid.BidRequest.Vertical)) {
          return super.equals(obj);
        }
        com.google.protos.adx.NetworkBid.BidRequest.Vertical other = (com.google.protos.adx.NetworkBid.BidRequest.Vertical) obj;

        if (hasId() != other.hasId()) return false;
        if (hasId()) {
          if (getId()
              != other.getId()) return false;
        }
        if (hasWeight() != other.hasWeight()) return false;
        if (hasWeight()) {
          if (java.lang.Float.floatToIntBits(getWeight())
              != java.lang.Float.floatToIntBits(
                  other.getWeight())) return false;
        }
        if (!unknownFields.equals(other.unknownFields)) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasId()) {
          hash = (37 * hash) + ID_FIELD_NUMBER;
          hash = (53 * hash) + getId();
        }
        if (hasWeight()) {
          hash = (37 * hash) + WEIGHT_FIELD_NUMBER;
          hash = (53 * hash) + java.lang.Float.floatToIntBits(
              getWeight());
        }
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.protos.adx.NetworkBid.BidRequest.Vertical parseFrom(
          java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.Vertical parseFrom(
          java.nio.ByteBuffer data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.Vertical parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.Vertical parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.Vertical parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.Vertical parseFrom(
          byte[] data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.Vertical parseFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.Vertical parseFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.Vertical parseDelimitedFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.Vertical parseDelimitedFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.Vertical parseFrom(
          com.google.protobuf.CodedInputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.Vertical parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() { return newBuilder(); }
      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }
      public static Builder newBuilder(com.google.protos.adx.NetworkBid.BidRequest.Vertical prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }
      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE
            ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * <pre>
       * One or more detected verticals for the page as determined by Google.
       * </pre>
       *
       * Protobuf type {@code com.google.protos.adx.BidRequest.Vertical}
       */
      public static final class Builder extends
          com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
          // @@protoc_insertion_point(builder_implements:com.google.protos.adx.BidRequest.Vertical)
          com.google.protos.adx.NetworkBid.BidRequest.VerticalOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
          return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_Vertical_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_Vertical_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.protos.adx.NetworkBid.BidRequest.Vertical.class, com.google.protos.adx.NetworkBid.BidRequest.Vertical.Builder.class);
        }

        // Construct using com.google.protos.adx.NetworkBid.BidRequest.Vertical.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }
        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3
                  .alwaysUseFieldBuilders) {
          }
        }
        @java.lang.Override
        public Builder clear() {
          super.clear();
          id_ = 0;
          bitField0_ = (bitField0_ & ~0x00000001);
          weight_ = 0F;
          bitField0_ = (bitField0_ & ~0x00000002);
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
          return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_Vertical_descriptor;
        }

        @java.lang.Override
        public com.google.protos.adx.NetworkBid.BidRequest.Vertical getDefaultInstanceForType() {
          return com.google.protos.adx.NetworkBid.BidRequest.Vertical.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.protos.adx.NetworkBid.BidRequest.Vertical build() {
          com.google.protos.adx.NetworkBid.BidRequest.Vertical result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.protos.adx.NetworkBid.BidRequest.Vertical buildPartial() {
          com.google.protos.adx.NetworkBid.BidRequest.Vertical result = new com.google.protos.adx.NetworkBid.BidRequest.Vertical(this);
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.id_ = id_;
            to_bitField0_ |= 0x00000001;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.weight_ = weight_;
            to_bitField0_ |= 0x00000002;
          }
          result.bitField0_ = to_bitField0_;
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }
        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.setField(field, value);
        }
        @java.lang.Override
        public Builder clearField(
            com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }
        @java.lang.Override
        public Builder clearOneof(
            com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }
        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index, java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }
        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }
        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.protos.adx.NetworkBid.BidRequest.Vertical) {
            return mergeFrom((com.google.protos.adx.NetworkBid.BidRequest.Vertical)other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.google.protos.adx.NetworkBid.BidRequest.Vertical other) {
          if (other == com.google.protos.adx.NetworkBid.BidRequest.Vertical.getDefaultInstance()) return this;
          if (other.hasId()) {
            setId(other.getId());
          }
          if (other.hasWeight()) {
            setWeight(other.getWeight());
          }
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          if (!hasId()) {
            return false;
          }
          if (!hasWeight()) {
            return false;
          }
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          com.google.protos.adx.NetworkBid.BidRequest.Vertical parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage = (com.google.protos.adx.NetworkBid.BidRequest.Vertical) e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }
        private int bitField0_;

        private int id_ ;
        /**
         * <pre>
         * The vertical id. See the publisher-verticals.txt file in the technical
         * documentation for a list of ids.
         * </pre>
         *
         * <code>required int32 id = 1;</code>
         * @return Whether the id field is set.
         */
        @java.lang.Override
        public boolean hasId() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         * <pre>
         * The vertical id. See the publisher-verticals.txt file in the technical
         * documentation for a list of ids.
         * </pre>
         *
         * <code>required int32 id = 1;</code>
         * @return The id.
         */
        @java.lang.Override
        public int getId() {
          return id_;
        }
        /**
         * <pre>
         * The vertical id. See the publisher-verticals.txt file in the technical
         * documentation for a list of ids.
         * </pre>
         *
         * <code>required int32 id = 1;</code>
         * @param value The id to set.
         * @return This builder for chaining.
         */
        public Builder setId(int value) {
          bitField0_ |= 0x00000001;
          id_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * The vertical id. See the publisher-verticals.txt file in the technical
         * documentation for a list of ids.
         * </pre>
         *
         * <code>required int32 id = 1;</code>
         * @return This builder for chaining.
         */
        public Builder clearId() {
          bitField0_ = (bitField0_ & ~0x00000001);
          id_ = 0;
          onChanged();
          return this;
        }

        private float weight_ ;
        /**
         * <pre>
         * Weight for this vertical, in the (0.0, 1.0] range. More relevant
         * verticals have higher weights.
         * </pre>
         *
         * <code>required float weight = 2;</code>
         * @return Whether the weight field is set.
         */
        @java.lang.Override
        public boolean hasWeight() {
          return ((bitField0_ & 0x00000002) != 0);
        }
        /**
         * <pre>
         * Weight for this vertical, in the (0.0, 1.0] range. More relevant
         * verticals have higher weights.
         * </pre>
         *
         * <code>required float weight = 2;</code>
         * @return The weight.
         */
        @java.lang.Override
        public float getWeight() {
          return weight_;
        }
        /**
         * <pre>
         * Weight for this vertical, in the (0.0, 1.0] range. More relevant
         * verticals have higher weights.
         * </pre>
         *
         * <code>required float weight = 2;</code>
         * @param value The weight to set.
         * @return This builder for chaining.
         */
        public Builder setWeight(float value) {
          bitField0_ |= 0x00000002;
          weight_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Weight for this vertical, in the (0.0, 1.0] range. More relevant
         * verticals have higher weights.
         * </pre>
         *
         * <code>required float weight = 2;</code>
         * @return This builder for chaining.
         */
        public Builder clearWeight() {
          bitField0_ = (bitField0_ & ~0x00000002);
          weight_ = 0F;
          onChanged();
          return this;
        }
        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }


        // @@protoc_insertion_point(builder_scope:com.google.protos.adx.BidRequest.Vertical)
      }

      // @@protoc_insertion_point(class_scope:com.google.protos.adx.BidRequest.Vertical)
      private static final com.google.protos.adx.NetworkBid.BidRequest.Vertical DEFAULT_INSTANCE;
      static {
        DEFAULT_INSTANCE = new com.google.protos.adx.NetworkBid.BidRequest.Vertical();
      }

      public static com.google.protos.adx.NetworkBid.BidRequest.Vertical getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      @java.lang.Deprecated public static final com.google.protobuf.Parser<Vertical>
          PARSER = new com.google.protobuf.AbstractParser<Vertical>() {
        @java.lang.Override
        public Vertical parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new Vertical(input, extensionRegistry);
        }
      };

      public static com.google.protobuf.Parser<Vertical> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Vertical> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protos.adx.NetworkBid.BidRequest.Vertical getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }

    }

    public interface DeviceOrBuilder extends
        // @@protoc_insertion_point(interface_extends:com.google.protos.adx.BidRequest.Device)
        com.google.protobuf.MessageOrBuilder {

      /**
       * <code>optional .com.google.protos.adx.BidRequest.Device.DeviceType device_type = 1 [default = UNKNOWN_DEVICE];</code>
       * @return Whether the deviceType field is set.
       */
      boolean hasDeviceType();
      /**
       * <code>optional .com.google.protos.adx.BidRequest.Device.DeviceType device_type = 1 [default = UNKNOWN_DEVICE];</code>
       * @return The deviceType.
       */
      com.google.protos.adx.NetworkBid.BidRequest.Device.DeviceType getDeviceType();

      /**
       * <pre>
       * The platform of the device. Examples: android, iphone, palm
       * </pre>
       *
       * <code>optional string platform = 2 [default = ""];</code>
       * @return Whether the platform field is set.
       */
      boolean hasPlatform();
      /**
       * <pre>
       * The platform of the device. Examples: android, iphone, palm
       * </pre>
       *
       * <code>optional string platform = 2 [default = ""];</code>
       * @return The platform.
       */
      java.lang.String getPlatform();
      /**
       * <pre>
       * The platform of the device. Examples: android, iphone, palm
       * </pre>
       *
       * <code>optional string platform = 2 [default = ""];</code>
       * @return The bytes for platform.
       */
      com.google.protobuf.ByteString
          getPlatformBytes();

      /**
       * <pre>
       * The brand of the device, e.g., Nokia, Samsung.
       * </pre>
       *
       * <code>optional string brand = 3 [default = ""];</code>
       * @return Whether the brand field is set.
       */
      boolean hasBrand();
      /**
       * <pre>
       * The brand of the device, e.g., Nokia, Samsung.
       * </pre>
       *
       * <code>optional string brand = 3 [default = ""];</code>
       * @return The brand.
       */
      java.lang.String getBrand();
      /**
       * <pre>
       * The brand of the device, e.g., Nokia, Samsung.
       * </pre>
       *
       * <code>optional string brand = 3 [default = ""];</code>
       * @return The bytes for brand.
       */
      com.google.protobuf.ByteString
          getBrandBytes();

      /**
       * <pre>
       * The model of the device, e.g., N70, Galaxy.
       * </pre>
       *
       * <code>optional string model = 4 [default = ""];</code>
       * @return Whether the model field is set.
       */
      boolean hasModel();
      /**
       * <pre>
       * The model of the device, e.g., N70, Galaxy.
       * </pre>
       *
       * <code>optional string model = 4 [default = ""];</code>
       * @return The model.
       */
      java.lang.String getModel();
      /**
       * <pre>
       * The model of the device, e.g., N70, Galaxy.
       * </pre>
       *
       * <code>optional string model = 4 [default = ""];</code>
       * @return The bytes for model.
       */
      com.google.protobuf.ByteString
          getModelBytes();

      /**
       * <pre>
       * The OS version; e.g., 2 for Android 2.1, or 3.3 for iOS 3.3.1.
       * </pre>
       *
       * <code>optional .com.google.protos.adx.BidRequest.Device.OsVersion os_version = 5;</code>
       * @return Whether the osVersion field is set.
       */
      boolean hasOsVersion();
      /**
       * <pre>
       * The OS version; e.g., 2 for Android 2.1, or 3.3 for iOS 3.3.1.
       * </pre>
       *
       * <code>optional .com.google.protos.adx.BidRequest.Device.OsVersion os_version = 5;</code>
       * @return The osVersion.
       */
      com.google.protos.adx.NetworkBid.BidRequest.Device.OsVersion getOsVersion();
      /**
       * <pre>
       * The OS version; e.g., 2 for Android 2.1, or 3.3 for iOS 3.3.1.
       * </pre>
       *
       * <code>optional .com.google.protos.adx.BidRequest.Device.OsVersion os_version = 5;</code>
       */
      com.google.protos.adx.NetworkBid.BidRequest.Device.OsVersionOrBuilder getOsVersionOrBuilder();

      /**
       * <pre>
       * Unique identifier for the mobile carrier if the device is connected to
       * the internet via a carrier (as opposed to via WiFi). To look up carrier
       * name from carrier ID, please refer to:
       * https://storage.googleapis.com/adx-rtb-dictionaries/mobile-carriers.csv.
       * </pre>
       *
       * <code>optional int64 carrier_id = 6 [default = 0];</code>
       * @return Whether the carrierId field is set.
       */
      boolean hasCarrierId();
      /**
       * <pre>
       * Unique identifier for the mobile carrier if the device is connected to
       * the internet via a carrier (as opposed to via WiFi). To look up carrier
       * name from carrier ID, please refer to:
       * https://storage.googleapis.com/adx-rtb-dictionaries/mobile-carriers.csv.
       * </pre>
       *
       * <code>optional int64 carrier_id = 6 [default = 0];</code>
       * @return The carrierId.
       */
      long getCarrierId();

      /**
       * <pre>
       * The width of the device screen in pixels.
       * </pre>
       *
       * <code>optional int32 screen_width = 7 [default = 0];</code>
       * @return Whether the screenWidth field is set.
       */
      boolean hasScreenWidth();
      /**
       * <pre>
       * The width of the device screen in pixels.
       * </pre>
       *
       * <code>optional int32 screen_width = 7 [default = 0];</code>
       * @return The screenWidth.
       */
      int getScreenWidth();

      /**
       * <pre>
       * The height of the device screen in pixels.
       * </pre>
       *
       * <code>optional int32 screen_height = 8 [default = 0];</code>
       * @return Whether the screenHeight field is set.
       */
      boolean hasScreenHeight();
      /**
       * <pre>
       * The height of the device screen in pixels.
       * </pre>
       *
       * <code>optional int32 screen_height = 8 [default = 0];</code>
       * @return The screenHeight.
       */
      int getScreenHeight();

      /**
       * <pre>
       * Used for high-density devices (e.g., iOS retina displays). A non-default
       * value indicates that the nominal screen size (with pixels as the unit)
       * does not describe the actual number of pixels in the screen. For example,
       * nominal width and height may be 320x640 for a screen that actually has
       * 640x1280 pixels, in which case screen_width=320, screen_height=640, and
       * screen_pixel_ratio_millis=2000, since each axis has twice as many pixels
       * as its dimensions would indicate.
       * </pre>
       *
       * <code>optional int32 screen_pixel_ratio_millis = 9 [default = 0];</code>
       * @return Whether the screenPixelRatioMillis field is set.
       */
      boolean hasScreenPixelRatioMillis();
      /**
       * <pre>
       * Used for high-density devices (e.g., iOS retina displays). A non-default
       * value indicates that the nominal screen size (with pixels as the unit)
       * does not describe the actual number of pixels in the screen. For example,
       * nominal width and height may be 320x640 for a screen that actually has
       * 640x1280 pixels, in which case screen_width=320, screen_height=640, and
       * screen_pixel_ratio_millis=2000, since each axis has twice as many pixels
       * as its dimensions would indicate.
       * </pre>
       *
       * <code>optional int32 screen_pixel_ratio_millis = 9 [default = 0];</code>
       * @return The screenPixelRatioMillis.
       */
      int getScreenPixelRatioMillis();

      /**
       * <pre>
       * The screen orientation of the device when the ad request is sent.
       * </pre>
       *
       * <code>optional .com.google.protos.adx.BidRequest.Device.ScreenOrientation screen_orientation = 10 [default = UNKNOWN_ORIENTATION];</code>
       * @return Whether the screenOrientation field is set.
       */
      boolean hasScreenOrientation();
      /**
       * <pre>
       * The screen orientation of the device when the ad request is sent.
       * </pre>
       *
       * <code>optional .com.google.protos.adx.BidRequest.Device.ScreenOrientation screen_orientation = 10 [default = UNKNOWN_ORIENTATION];</code>
       * @return The screenOrientation.
       */
      com.google.protos.adx.NetworkBid.BidRequest.Device.ScreenOrientation getScreenOrientation();

      /**
       * <pre>
       * Apple iOS device model, e.g., "iphone 5s", "iphone 6+", "ipad 4".
       * </pre>
       *
       * <code>optional string hardware_version = 11;</code>
       * @return Whether the hardwareVersion field is set.
       */
      boolean hasHardwareVersion();
      /**
       * <pre>
       * Apple iOS device model, e.g., "iphone 5s", "iphone 6+", "ipad 4".
       * </pre>
       *
       * <code>optional string hardware_version = 11;</code>
       * @return The hardwareVersion.
       */
      java.lang.String getHardwareVersion();
      /**
       * <pre>
       * Apple iOS device model, e.g., "iphone 5s", "iphone 6+", "ipad 4".
       * </pre>
       *
       * <code>optional string hardware_version = 11;</code>
       * @return The bytes for hardwareVersion.
       */
      com.google.protobuf.ByteString
          getHardwareVersionBytes();

      /**
       * <pre>
       * Indicates whether the user has opted out of interest based advertising or
       * ads personalization as determined by an OS-level setting in iOS or
       * Android:
       * https://support.apple.com/en-us/HT202074
       * https://support.google.com/googleplay/answer/3405269
       * </pre>
       *
       * <code>optional bool limit_ad_tracking = 12;</code>
       * @return Whether the limitAdTracking field is set.
       */
      boolean hasLimitAdTracking();
      /**
       * <pre>
       * Indicates whether the user has opted out of interest based advertising or
       * ads personalization as determined by an OS-level setting in iOS or
       * Android:
       * https://support.apple.com/en-us/HT202074
       * https://support.google.com/googleplay/answer/3405269
       * </pre>
       *
       * <code>optional bool limit_ad_tracking = 12;</code>
       * @return The limitAdTracking.
       */
      boolean getLimitAdTracking();

      /**
       * <pre>
       * This field is only populated for iOS devices. Indicates the app tracking
       * authorization status. This value is retrieved from ATTrackingManager
       * and provided as is. For more information about iOS's app tracking
       * authorization status, see:
       * https://developer.apple.com/documentation/apptrackingtransparency/attrackingmanager/authorizationstatus
       * </pre>
       *
       * <code>optional .com.google.protos.adx.BidRequest.Device.AuthorizationStatus app_tracking_authorization_status = 13;</code>
       * @return Whether the appTrackingAuthorizationStatus field is set.
       */
      boolean hasAppTrackingAuthorizationStatus();
      /**
       * <pre>
       * This field is only populated for iOS devices. Indicates the app tracking
       * authorization status. This value is retrieved from ATTrackingManager
       * and provided as is. For more information about iOS's app tracking
       * authorization status, see:
       * https://developer.apple.com/documentation/apptrackingtransparency/attrackingmanager/authorizationstatus
       * </pre>
       *
       * <code>optional .com.google.protos.adx.BidRequest.Device.AuthorizationStatus app_tracking_authorization_status = 13;</code>
       * @return The appTrackingAuthorizationStatus.
       */
      com.google.protos.adx.NetworkBid.BidRequest.Device.AuthorizationStatus getAppTrackingAuthorizationStatus();
    }
    /**
     * <pre>
     * Information about the device.
     * </pre>
     *
     * Protobuf type {@code com.google.protos.adx.BidRequest.Device}
     */
    public static final class Device extends
        com.google.protobuf.GeneratedMessageV3 implements
        // @@protoc_insertion_point(message_implements:com.google.protos.adx.BidRequest.Device)
        DeviceOrBuilder {
    private static final long serialVersionUID = 0L;
      // Use Device.newBuilder() to construct.
      private Device(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }
      private Device() {
        deviceType_ = 0;
        platform_ = "";
        brand_ = "";
        model_ = "";
        screenOrientation_ = 0;
        hardwareVersion_ = "";
        appTrackingAuthorizationStatus_ = 0;
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(
          UnusedPrivateParameter unused) {
        return new Device();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet
      getUnknownFields() {
        return this.unknownFields;
      }
      private Device(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        int mutable_bitField0_ = 0;
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8: {
                int rawValue = input.readEnum();
                  @SuppressWarnings("deprecation")
                com.google.protos.adx.NetworkBid.BidRequest.Device.DeviceType value = com.google.protos.adx.NetworkBid.BidRequest.Device.DeviceType.valueOf(rawValue);
                if (value == null) {
                  unknownFields.mergeVarintField(1, rawValue);
                } else {
                  bitField0_ |= 0x00000001;
                  deviceType_ = rawValue;
                }
                break;
              }
              case 18: {
                com.google.protobuf.ByteString bs = input.readBytes();
                bitField0_ |= 0x00000002;
                platform_ = bs;
                break;
              }
              case 26: {
                com.google.protobuf.ByteString bs = input.readBytes();
                bitField0_ |= 0x00000004;
                brand_ = bs;
                break;
              }
              case 34: {
                com.google.protobuf.ByteString bs = input.readBytes();
                bitField0_ |= 0x00000008;
                model_ = bs;
                break;
              }
              case 42: {
                com.google.protos.adx.NetworkBid.BidRequest.Device.OsVersion.Builder subBuilder = null;
                if (((bitField0_ & 0x00000010) != 0)) {
                  subBuilder = osVersion_.toBuilder();
                }
                osVersion_ = input.readMessage(com.google.protos.adx.NetworkBid.BidRequest.Device.OsVersion.PARSER, extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(osVersion_);
                  osVersion_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000010;
                break;
              }
              case 48: {
                bitField0_ |= 0x00000020;
                carrierId_ = input.readInt64();
                break;
              }
              case 56: {
                bitField0_ |= 0x00000040;
                screenWidth_ = input.readInt32();
                break;
              }
              case 64: {
                bitField0_ |= 0x00000080;
                screenHeight_ = input.readInt32();
                break;
              }
              case 72: {
                bitField0_ |= 0x00000100;
                screenPixelRatioMillis_ = input.readInt32();
                break;
              }
              case 80: {
                int rawValue = input.readEnum();
                  @SuppressWarnings("deprecation")
                com.google.protos.adx.NetworkBid.BidRequest.Device.ScreenOrientation value = com.google.protos.adx.NetworkBid.BidRequest.Device.ScreenOrientation.valueOf(rawValue);
                if (value == null) {
                  unknownFields.mergeVarintField(10, rawValue);
                } else {
                  bitField0_ |= 0x00000200;
                  screenOrientation_ = rawValue;
                }
                break;
              }
              case 90: {
                com.google.protobuf.ByteString bs = input.readBytes();
                bitField0_ |= 0x00000400;
                hardwareVersion_ = bs;
                break;
              }
              case 96: {
                bitField0_ |= 0x00000800;
                limitAdTracking_ = input.readBool();
                break;
              }
              case 104: {
                int rawValue = input.readEnum();
                  @SuppressWarnings("deprecation")
                com.google.protos.adx.NetworkBid.BidRequest.Device.AuthorizationStatus value = com.google.protos.adx.NetworkBid.BidRequest.Device.AuthorizationStatus.valueOf(rawValue);
                if (value == null) {
                  unknownFields.mergeVarintField(13, rawValue);
                } else {
                  bitField0_ |= 0x00001000;
                  appTrackingAuthorizationStatus_ = rawValue;
                }
                break;
              }
              default: {
                if (!parseUnknownField(
                    input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(
              e).setUnfinishedMessage(this);
        } finally {
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_Device_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_Device_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.protos.adx.NetworkBid.BidRequest.Device.class, com.google.protos.adx.NetworkBid.BidRequest.Device.Builder.class);
      }

      /**
       * <pre>
       * The type of device on which the ad will be shown.
       * </pre>
       *
       * Protobuf enum {@code com.google.protos.adx.BidRequest.Device.DeviceType}
       */
      public enum DeviceType
          implements com.google.protobuf.ProtocolMessageEnum {
        /**
         * <code>UNKNOWN_DEVICE = 0;</code>
         */
        UNKNOWN_DEVICE(0),
        /**
         * <code>HIGHEND_PHONE = 1;</code>
         */
        HIGHEND_PHONE(1),
        /**
         * <code>TABLET = 2;</code>
         */
        TABLET(2),
        /**
         * <pre>
         * Desktop or laptop devices.
         * </pre>
         *
         * <code>PERSONAL_COMPUTER = 3;</code>
         */
        PERSONAL_COMPUTER(3),
        /**
         * <pre>
         * Both connected TVs (that is, smart TVs) and connected devices
         * (such as Roku and Apple TV).
         * </pre>
         *
         * <code>CONNECTED_TV = 4;</code>
         */
        CONNECTED_TV(4),
        /**
         * <code>GAME_CONSOLE = 5;</code>
         */
        GAME_CONSOLE(5),
        /**
         * <code>SET_TOP_BOX = 6;</code>
         */
        SET_TOP_BOX(6),
        ;

        /**
         * <code>UNKNOWN_DEVICE = 0;</code>
         */
        public static final int UNKNOWN_DEVICE_VALUE = 0;
        /**
         * <code>HIGHEND_PHONE = 1;</code>
         */
        public static final int HIGHEND_PHONE_VALUE = 1;
        /**
         * <code>TABLET = 2;</code>
         */
        public static final int TABLET_VALUE = 2;
        /**
         * <pre>
         * Desktop or laptop devices.
         * </pre>
         *
         * <code>PERSONAL_COMPUTER = 3;</code>
         */
        public static final int PERSONAL_COMPUTER_VALUE = 3;
        /**
         * <pre>
         * Both connected TVs (that is, smart TVs) and connected devices
         * (such as Roku and Apple TV).
         * </pre>
         *
         * <code>CONNECTED_TV = 4;</code>
         */
        public static final int CONNECTED_TV_VALUE = 4;
        /**
         * <code>GAME_CONSOLE = 5;</code>
         */
        public static final int GAME_CONSOLE_VALUE = 5;
        /**
         * <code>SET_TOP_BOX = 6;</code>
         */
        public static final int SET_TOP_BOX_VALUE = 6;


        public final int getNumber() {
          return value;
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static DeviceType valueOf(int value) {
          return forNumber(value);
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         */
        public static DeviceType forNumber(int value) {
          switch (value) {
            case 0: return UNKNOWN_DEVICE;
            case 1: return HIGHEND_PHONE;
            case 2: return TABLET;
            case 3: return PERSONAL_COMPUTER;
            case 4: return CONNECTED_TV;
            case 5: return GAME_CONSOLE;
            case 6: return SET_TOP_BOX;
            default: return null;
          }
        }

        public static com.google.protobuf.Internal.EnumLiteMap<DeviceType>
            internalGetValueMap() {
          return internalValueMap;
        }
        private static final com.google.protobuf.Internal.EnumLiteMap<
            DeviceType> internalValueMap =
              new com.google.protobuf.Internal.EnumLiteMap<DeviceType>() {
                public DeviceType findValueByNumber(int number) {
                  return DeviceType.forNumber(number);
                }
              };

        public final com.google.protobuf.Descriptors.EnumValueDescriptor
            getValueDescriptor() {
          return getDescriptor().getValues().get(ordinal());
        }
        public final com.google.protobuf.Descriptors.EnumDescriptor
            getDescriptorForType() {
          return getDescriptor();
        }
        public static final com.google.protobuf.Descriptors.EnumDescriptor
            getDescriptor() {
          return com.google.protos.adx.NetworkBid.BidRequest.Device.getDescriptor().getEnumTypes().get(0);
        }

        private static final DeviceType[] VALUES = values();

        public static DeviceType valueOf(
            com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
          if (desc.getType() != getDescriptor()) {
            throw new java.lang.IllegalArgumentException(
              "EnumValueDescriptor is not for this type.");
          }
          return VALUES[desc.getIndex()];
        }

        private final int value;

        private DeviceType(int value) {
          this.value = value;
        }

        // @@protoc_insertion_point(enum_scope:com.google.protos.adx.BidRequest.Device.DeviceType)
      }

      /**
       * Protobuf enum {@code com.google.protos.adx.BidRequest.Device.ScreenOrientation}
       */
      public enum ScreenOrientation
          implements com.google.protobuf.ProtocolMessageEnum {
        /**
         * <code>UNKNOWN_ORIENTATION = 0;</code>
         */
        UNKNOWN_ORIENTATION(0),
        /**
         * <code>PORTRAIT = 1;</code>
         */
        PORTRAIT(1),
        /**
         * <code>LANDSCAPE = 2;</code>
         */
        LANDSCAPE(2),
        ;

        /**
         * <code>UNKNOWN_ORIENTATION = 0;</code>
         */
        public static final int UNKNOWN_ORIENTATION_VALUE = 0;
        /**
         * <code>PORTRAIT = 1;</code>
         */
        public static final int PORTRAIT_VALUE = 1;
        /**
         * <code>LANDSCAPE = 2;</code>
         */
        public static final int LANDSCAPE_VALUE = 2;


        public final int getNumber() {
          return value;
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static ScreenOrientation valueOf(int value) {
          return forNumber(value);
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         */
        public static ScreenOrientation forNumber(int value) {
          switch (value) {
            case 0: return UNKNOWN_ORIENTATION;
            case 1: return PORTRAIT;
            case 2: return LANDSCAPE;
            default: return null;
          }
        }

        public static com.google.protobuf.Internal.EnumLiteMap<ScreenOrientation>
            internalGetValueMap() {
          return internalValueMap;
        }
        private static final com.google.protobuf.Internal.EnumLiteMap<
            ScreenOrientation> internalValueMap =
              new com.google.protobuf.Internal.EnumLiteMap<ScreenOrientation>() {
                public ScreenOrientation findValueByNumber(int number) {
                  return ScreenOrientation.forNumber(number);
                }
              };

        public final com.google.protobuf.Descriptors.EnumValueDescriptor
            getValueDescriptor() {
          return getDescriptor().getValues().get(ordinal());
        }
        public final com.google.protobuf.Descriptors.EnumDescriptor
            getDescriptorForType() {
          return getDescriptor();
        }
        public static final com.google.protobuf.Descriptors.EnumDescriptor
            getDescriptor() {
          return com.google.protos.adx.NetworkBid.BidRequest.Device.getDescriptor().getEnumTypes().get(1);
        }

        private static final ScreenOrientation[] VALUES = values();

        public static ScreenOrientation valueOf(
            com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
          if (desc.getType() != getDescriptor()) {
            throw new java.lang.IllegalArgumentException(
              "EnumValueDescriptor is not for this type.");
          }
          return VALUES[desc.getIndex()];
        }

        private final int value;

        private ScreenOrientation(int value) {
          this.value = value;
        }

        // @@protoc_insertion_point(enum_scope:com.google.protos.adx.BidRequest.Device.ScreenOrientation)
      }

      /**
       * <pre>
       * The possible app tracking authorization statuses that could be applicable
       * for bid requests from iOS devices. For more information about iOS's app
       * tracking authorization status, see:
       * https://developer.apple.com/documentation/apptrackingtransparency/attrackingmanager/authorizationstatus
       * </pre>
       *
       * Protobuf enum {@code com.google.protos.adx.BidRequest.Device.AuthorizationStatus}
       */
      public enum AuthorizationStatus
          implements com.google.protobuf.ProtocolMessageEnum {
        /**
         * <pre>
         * User has not yet received a request to authorize access to app-related
         * data that can be used for tracking the user or the device.
         * </pre>
         *
         * <code>NOT_DETERMINED = 0;</code>
         */
        NOT_DETERMINED(0),
        /**
         * <pre>
         * Authorization to access app-related data that can be used for tracking
         * the user or the device is restricted.
         * </pre>
         *
         * <code>RESTRICTED = 1;</code>
         */
        RESTRICTED(1),
        /**
         * <pre>
         * User denies authorization to access app-related data that can be used
         * for tracking the user or the device.
         * </pre>
         *
         * <code>DENIED = 2;</code>
         */
        DENIED(2),
        /**
         * <pre>
         * User authorizes access to app-related data that can be used for
         * tracking the user or the device.
         * </pre>
         *
         * <code>AUTHORIZED = 3;</code>
         */
        AUTHORIZED(3),
        ;

        /**
         * <pre>
         * User has not yet received a request to authorize access to app-related
         * data that can be used for tracking the user or the device.
         * </pre>
         *
         * <code>NOT_DETERMINED = 0;</code>
         */
        public static final int NOT_DETERMINED_VALUE = 0;
        /**
         * <pre>
         * Authorization to access app-related data that can be used for tracking
         * the user or the device is restricted.
         * </pre>
         *
         * <code>RESTRICTED = 1;</code>
         */
        public static final int RESTRICTED_VALUE = 1;
        /**
         * <pre>
         * User denies authorization to access app-related data that can be used
         * for tracking the user or the device.
         * </pre>
         *
         * <code>DENIED = 2;</code>
         */
        public static final int DENIED_VALUE = 2;
        /**
         * <pre>
         * User authorizes access to app-related data that can be used for
         * tracking the user or the device.
         * </pre>
         *
         * <code>AUTHORIZED = 3;</code>
         */
        public static final int AUTHORIZED_VALUE = 3;


        public final int getNumber() {
          return value;
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static AuthorizationStatus valueOf(int value) {
          return forNumber(value);
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         */
        public static AuthorizationStatus forNumber(int value) {
          switch (value) {
            case 0: return NOT_DETERMINED;
            case 1: return RESTRICTED;
            case 2: return DENIED;
            case 3: return AUTHORIZED;
            default: return null;
          }
        }

        public static com.google.protobuf.Internal.EnumLiteMap<AuthorizationStatus>
            internalGetValueMap() {
          return internalValueMap;
        }
        private static final com.google.protobuf.Internal.EnumLiteMap<
            AuthorizationStatus> internalValueMap =
              new com.google.protobuf.Internal.EnumLiteMap<AuthorizationStatus>() {
                public AuthorizationStatus findValueByNumber(int number) {
                  return AuthorizationStatus.forNumber(number);
                }
              };

        public final com.google.protobuf.Descriptors.EnumValueDescriptor
            getValueDescriptor() {
          return getDescriptor().getValues().get(ordinal());
        }
        public final com.google.protobuf.Descriptors.EnumDescriptor
            getDescriptorForType() {
          return getDescriptor();
        }
        public static final com.google.protobuf.Descriptors.EnumDescriptor
            getDescriptor() {
          return com.google.protos.adx.NetworkBid.BidRequest.Device.getDescriptor().getEnumTypes().get(2);
        }

        private static final AuthorizationStatus[] VALUES = values();

        public static AuthorizationStatus valueOf(
            com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
          if (desc.getType() != getDescriptor()) {
            throw new java.lang.IllegalArgumentException(
              "EnumValueDescriptor is not for this type.");
          }
          return VALUES[desc.getIndex()];
        }

        private final int value;

        private AuthorizationStatus(int value) {
          this.value = value;
        }

        // @@protoc_insertion_point(enum_scope:com.google.protos.adx.BidRequest.Device.AuthorizationStatus)
      }

      public interface OsVersionOrBuilder extends
          // @@protoc_insertion_point(interface_extends:com.google.protos.adx.BidRequest.Device.OsVersion)
          com.google.protobuf.MessageOrBuilder {

        /**
         * <code>optional int32 major = 1 [default = -1];</code>
         * @return Whether the major field is set.
         */
        boolean hasMajor();
        /**
         * <code>optional int32 major = 1 [default = -1];</code>
         * @return The major.
         */
        int getMajor();

        /**
         * <code>optional int32 minor = 2 [default = -1];</code>
         * @return Whether the minor field is set.
         */
        boolean hasMinor();
        /**
         * <code>optional int32 minor = 2 [default = -1];</code>
         * @return The minor.
         */
        int getMinor();

        /**
         * <code>optional int32 micro = 3 [default = -1];</code>
         * @return Whether the micro field is set.
         */
        boolean hasMicro();
        /**
         * <code>optional int32 micro = 3 [default = -1];</code>
         * @return The micro.
         */
        int getMicro();
      }
      /**
       * <pre>
       * Contains the OS version of the platform. For instance, for Android 2,
       * major=2, minor=0. For iPhone 3.3.1, major=3 and minor=3.
       * </pre>
       *
       * Protobuf type {@code com.google.protos.adx.BidRequest.Device.OsVersion}
       */
      public static final class OsVersion extends
          com.google.protobuf.GeneratedMessageV3 implements
          // @@protoc_insertion_point(message_implements:com.google.protos.adx.BidRequest.Device.OsVersion)
          OsVersionOrBuilder {
      private static final long serialVersionUID = 0L;
        // Use OsVersion.newBuilder() to construct.
        private OsVersion(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }
        private OsVersion() {
          major_ = -1;
          minor_ = -1;
          micro_ = -1;
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(
            UnusedPrivateParameter unused) {
          return new OsVersion();
        }

        @java.lang.Override
        public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
          return this.unknownFields;
        }
        private OsVersion(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          this();
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          int mutable_bitField0_ = 0;
          com.google.protobuf.UnknownFieldSet.Builder unknownFields =
              com.google.protobuf.UnknownFieldSet.newBuilder();
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 8: {
                  bitField0_ |= 0x00000001;
                  major_ = input.readInt32();
                  break;
                }
                case 16: {
                  bitField0_ |= 0x00000002;
                  minor_ = input.readInt32();
                  break;
                }
                case 24: {
                  bitField0_ |= 0x00000004;
                  micro_ = input.readInt32();
                  break;
                }
                default: {
                  if (!parseUnknownField(
                      input, unknownFields, extensionRegistry, tag)) {
                    done = true;
                  }
                  break;
                }
              }
            }
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(this);
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(
                e).setUnfinishedMessage(this);
          } finally {
            this.unknownFields = unknownFields.build();
            makeExtensionsImmutable();
          }
        }
        public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
          return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_Device_OsVersion_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_Device_OsVersion_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.protos.adx.NetworkBid.BidRequest.Device.OsVersion.class, com.google.protos.adx.NetworkBid.BidRequest.Device.OsVersion.Builder.class);
        }

        private int bitField0_;
        public static final int MAJOR_FIELD_NUMBER = 1;
        private int major_;
        /**
         * <code>optional int32 major = 1 [default = -1];</code>
         * @return Whether the major field is set.
         */
        @java.lang.Override
        public boolean hasMajor() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         * <code>optional int32 major = 1 [default = -1];</code>
         * @return The major.
         */
        @java.lang.Override
        public int getMajor() {
          return major_;
        }

        public static final int MINOR_FIELD_NUMBER = 2;
        private int minor_;
        /**
         * <code>optional int32 minor = 2 [default = -1];</code>
         * @return Whether the minor field is set.
         */
        @java.lang.Override
        public boolean hasMinor() {
          return ((bitField0_ & 0x00000002) != 0);
        }
        /**
         * <code>optional int32 minor = 2 [default = -1];</code>
         * @return The minor.
         */
        @java.lang.Override
        public int getMinor() {
          return minor_;
        }

        public static final int MICRO_FIELD_NUMBER = 3;
        private int micro_;
        /**
         * <code>optional int32 micro = 3 [default = -1];</code>
         * @return Whether the micro field is set.
         */
        @java.lang.Override
        public boolean hasMicro() {
          return ((bitField0_ & 0x00000004) != 0);
        }
        /**
         * <code>optional int32 micro = 3 [default = -1];</code>
         * @return The micro.
         */
        @java.lang.Override
        public int getMicro() {
          return micro_;
        }

        private byte memoizedIsInitialized = -1;
        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
                            throws java.io.IOException {
          if (((bitField0_ & 0x00000001) != 0)) {
            output.writeInt32(1, major_);
          }
          if (((bitField0_ & 0x00000002) != 0)) {
            output.writeInt32(2, minor_);
          }
          if (((bitField0_ & 0x00000004) != 0)) {
            output.writeInt32(3, micro_);
          }
          unknownFields.writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (((bitField0_ & 0x00000001) != 0)) {
            size += com.google.protobuf.CodedOutputStream
              .computeInt32Size(1, major_);
          }
          if (((bitField0_ & 0x00000002) != 0)) {
            size += com.google.protobuf.CodedOutputStream
              .computeInt32Size(2, minor_);
          }
          if (((bitField0_ & 0x00000004) != 0)) {
            size += com.google.protobuf.CodedOutputStream
              .computeInt32Size(3, micro_);
          }
          size += unknownFields.getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
           return true;
          }
          if (!(obj instanceof com.google.protos.adx.NetworkBid.BidRequest.Device.OsVersion)) {
            return super.equals(obj);
          }
          com.google.protos.adx.NetworkBid.BidRequest.Device.OsVersion other = (com.google.protos.adx.NetworkBid.BidRequest.Device.OsVersion) obj;

          if (hasMajor() != other.hasMajor()) return false;
          if (hasMajor()) {
            if (getMajor()
                != other.getMajor()) return false;
          }
          if (hasMinor() != other.hasMinor()) return false;
          if (hasMinor()) {
            if (getMinor()
                != other.getMinor()) return false;
          }
          if (hasMicro() != other.hasMicro()) return false;
          if (hasMicro()) {
            if (getMicro()
                != other.getMicro()) return false;
          }
          if (!unknownFields.equals(other.unknownFields)) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          if (hasMajor()) {
            hash = (37 * hash) + MAJOR_FIELD_NUMBER;
            hash = (53 * hash) + getMajor();
          }
          if (hasMinor()) {
            hash = (37 * hash) + MINOR_FIELD_NUMBER;
            hash = (53 * hash) + getMinor();
          }
          if (hasMicro()) {
            hash = (37 * hash) + MICRO_FIELD_NUMBER;
            hash = (53 * hash) + getMicro();
          }
          hash = (29 * hash) + unknownFields.hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.protos.adx.NetworkBid.BidRequest.Device.OsVersion parseFrom(
            java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }
        public static com.google.protos.adx.NetworkBid.BidRequest.Device.OsVersion parseFrom(
            java.nio.ByteBuffer data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }
        public static com.google.protos.adx.NetworkBid.BidRequest.Device.OsVersion parseFrom(
            com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }
        public static com.google.protos.adx.NetworkBid.BidRequest.Device.OsVersion parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }
        public static com.google.protos.adx.NetworkBid.BidRequest.Device.OsVersion parseFrom(byte[] data)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }
        public static com.google.protos.adx.NetworkBid.BidRequest.Device.OsVersion parseFrom(
            byte[] data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }
        public static com.google.protos.adx.NetworkBid.BidRequest.Device.OsVersion parseFrom(java.io.InputStream input)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3
              .parseWithIOException(PARSER, input);
        }
        public static com.google.protos.adx.NetworkBid.BidRequest.Device.OsVersion parseFrom(
            java.io.InputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3
              .parseWithIOException(PARSER, input, extensionRegistry);
        }
        public static com.google.protos.adx.NetworkBid.BidRequest.Device.OsVersion parseDelimitedFrom(java.io.InputStream input)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3
              .parseDelimitedWithIOException(PARSER, input);
        }
        public static com.google.protos.adx.NetworkBid.BidRequest.Device.OsVersion parseDelimitedFrom(
            java.io.InputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3
              .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
        }
        public static com.google.protos.adx.NetworkBid.BidRequest.Device.OsVersion parseFrom(
            com.google.protobuf.CodedInputStream input)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3
              .parseWithIOException(PARSER, input);
        }
        public static com.google.protos.adx.NetworkBid.BidRequest.Device.OsVersion parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3
              .parseWithIOException(PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() { return newBuilder(); }
        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }
        public static Builder newBuilder(com.google.protos.adx.NetworkBid.BidRequest.Device.OsVersion prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }
        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE
              ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         * <pre>
         * Contains the OS version of the platform. For instance, for Android 2,
         * major=2, minor=0. For iPhone 3.3.1, major=3 and minor=3.
         * </pre>
         *
         * Protobuf type {@code com.google.protos.adx.BidRequest.Device.OsVersion}
         */
        public static final class Builder extends
            com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
            // @@protoc_insertion_point(builder_implements:com.google.protos.adx.BidRequest.Device.OsVersion)
            com.google.protos.adx.NetworkBid.BidRequest.Device.OsVersionOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor
              getDescriptor() {
            return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_Device_OsVersion_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_Device_OsVersion_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.protos.adx.NetworkBid.BidRequest.Device.OsVersion.class, com.google.protos.adx.NetworkBid.BidRequest.Device.OsVersion.Builder.class);
          }

          // Construct using com.google.protos.adx.NetworkBid.BidRequest.Device.OsVersion.newBuilder()
          private Builder() {
            maybeForceBuilderInitialization();
          }

          private Builder(
              com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            maybeForceBuilderInitialization();
          }
          private void maybeForceBuilderInitialization() {
            if (com.google.protobuf.GeneratedMessageV3
                    .alwaysUseFieldBuilders) {
            }
          }
          @java.lang.Override
          public Builder clear() {
            super.clear();
            major_ = -1;
            bitField0_ = (bitField0_ & ~0x00000001);
            minor_ = -1;
            bitField0_ = (bitField0_ & ~0x00000002);
            micro_ = -1;
            bitField0_ = (bitField0_ & ~0x00000004);
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor
              getDescriptorForType() {
            return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_Device_OsVersion_descriptor;
          }

          @java.lang.Override
          public com.google.protos.adx.NetworkBid.BidRequest.Device.OsVersion getDefaultInstanceForType() {
            return com.google.protos.adx.NetworkBid.BidRequest.Device.OsVersion.getDefaultInstance();
          }

          @java.lang.Override
          public com.google.protos.adx.NetworkBid.BidRequest.Device.OsVersion build() {
            com.google.protos.adx.NetworkBid.BidRequest.Device.OsVersion result = buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.protos.adx.NetworkBid.BidRequest.Device.OsVersion buildPartial() {
            com.google.protos.adx.NetworkBid.BidRequest.Device.OsVersion result = new com.google.protos.adx.NetworkBid.BidRequest.Device.OsVersion(this);
            int from_bitField0_ = bitField0_;
            int to_bitField0_ = 0;
            if (((from_bitField0_ & 0x00000001) != 0)) {
              to_bitField0_ |= 0x00000001;
            }
            result.major_ = major_;
            if (((from_bitField0_ & 0x00000002) != 0)) {
              to_bitField0_ |= 0x00000002;
            }
            result.minor_ = minor_;
            if (((from_bitField0_ & 0x00000004) != 0)) {
              to_bitField0_ |= 0x00000004;
            }
            result.micro_ = micro_;
            result.bitField0_ = to_bitField0_;
            onBuilt();
            return result;
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }
          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              java.lang.Object value) {
            return super.setField(field, value);
          }
          @java.lang.Override
          public Builder clearField(
              com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }
          @java.lang.Override
          public Builder clearOneof(
              com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }
          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index, java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }
          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }
          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other instanceof com.google.protos.adx.NetworkBid.BidRequest.Device.OsVersion) {
              return mergeFrom((com.google.protos.adx.NetworkBid.BidRequest.Device.OsVersion)other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(com.google.protos.adx.NetworkBid.BidRequest.Device.OsVersion other) {
            if (other == com.google.protos.adx.NetworkBid.BidRequest.Device.OsVersion.getDefaultInstance()) return this;
            if (other.hasMajor()) {
              setMajor(other.getMajor());
            }
            if (other.hasMinor()) {
              setMinor(other.getMinor());
            }
            if (other.hasMicro()) {
              setMicro(other.getMicro());
            }
            this.mergeUnknownFields(other.unknownFields);
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            com.google.protos.adx.NetworkBid.BidRequest.Device.OsVersion parsedMessage = null;
            try {
              parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              parsedMessage = (com.google.protos.adx.NetworkBid.BidRequest.Device.OsVersion) e.getUnfinishedMessage();
              throw e.unwrapIOException();
            } finally {
              if (parsedMessage != null) {
                mergeFrom(parsedMessage);
              }
            }
            return this;
          }
          private int bitField0_;

          private int major_ = -1;
          /**
           * <code>optional int32 major = 1 [default = -1];</code>
           * @return Whether the major field is set.
           */
          @java.lang.Override
          public boolean hasMajor() {
            return ((bitField0_ & 0x00000001) != 0);
          }
          /**
           * <code>optional int32 major = 1 [default = -1];</code>
           * @return The major.
           */
          @java.lang.Override
          public int getMajor() {
            return major_;
          }
          /**
           * <code>optional int32 major = 1 [default = -1];</code>
           * @param value The major to set.
           * @return This builder for chaining.
           */
          public Builder setMajor(int value) {
            bitField0_ |= 0x00000001;
            major_ = value;
            onChanged();
            return this;
          }
          /**
           * <code>optional int32 major = 1 [default = -1];</code>
           * @return This builder for chaining.
           */
          public Builder clearMajor() {
            bitField0_ = (bitField0_ & ~0x00000001);
            major_ = -1;
            onChanged();
            return this;
          }

          private int minor_ = -1;
          /**
           * <code>optional int32 minor = 2 [default = -1];</code>
           * @return Whether the minor field is set.
           */
          @java.lang.Override
          public boolean hasMinor() {
            return ((bitField0_ & 0x00000002) != 0);
          }
          /**
           * <code>optional int32 minor = 2 [default = -1];</code>
           * @return The minor.
           */
          @java.lang.Override
          public int getMinor() {
            return minor_;
          }
          /**
           * <code>optional int32 minor = 2 [default = -1];</code>
           * @param value The minor to set.
           * @return This builder for chaining.
           */
          public Builder setMinor(int value) {
            bitField0_ |= 0x00000002;
            minor_ = value;
            onChanged();
            return this;
          }
          /**
           * <code>optional int32 minor = 2 [default = -1];</code>
           * @return This builder for chaining.
           */
          public Builder clearMinor() {
            bitField0_ = (bitField0_ & ~0x00000002);
            minor_ = -1;
            onChanged();
            return this;
          }

          private int micro_ = -1;
          /**
           * <code>optional int32 micro = 3 [default = -1];</code>
           * @return Whether the micro field is set.
           */
          @java.lang.Override
          public boolean hasMicro() {
            return ((bitField0_ & 0x00000004) != 0);
          }
          /**
           * <code>optional int32 micro = 3 [default = -1];</code>
           * @return The micro.
           */
          @java.lang.Override
          public int getMicro() {
            return micro_;
          }
          /**
           * <code>optional int32 micro = 3 [default = -1];</code>
           * @param value The micro to set.
           * @return This builder for chaining.
           */
          public Builder setMicro(int value) {
            bitField0_ |= 0x00000004;
            micro_ = value;
            onChanged();
            return this;
          }
          /**
           * <code>optional int32 micro = 3 [default = -1];</code>
           * @return This builder for chaining.
           */
          public Builder clearMicro() {
            bitField0_ = (bitField0_ & ~0x00000004);
            micro_ = -1;
            onChanged();
            return this;
          }
          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }


          // @@protoc_insertion_point(builder_scope:com.google.protos.adx.BidRequest.Device.OsVersion)
        }

        // @@protoc_insertion_point(class_scope:com.google.protos.adx.BidRequest.Device.OsVersion)
        private static final com.google.protos.adx.NetworkBid.BidRequest.Device.OsVersion DEFAULT_INSTANCE;
        static {
          DEFAULT_INSTANCE = new com.google.protos.adx.NetworkBid.BidRequest.Device.OsVersion();
        }

        public static com.google.protos.adx.NetworkBid.BidRequest.Device.OsVersion getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        @java.lang.Deprecated public static final com.google.protobuf.Parser<OsVersion>
            PARSER = new com.google.protobuf.AbstractParser<OsVersion>() {
          @java.lang.Override
          public OsVersion parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new OsVersion(input, extensionRegistry);
          }
        };

        public static com.google.protobuf.Parser<OsVersion> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<OsVersion> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protos.adx.NetworkBid.BidRequest.Device.OsVersion getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }

      }

      private int bitField0_;
      public static final int DEVICE_TYPE_FIELD_NUMBER = 1;
      private int deviceType_;
      /**
       * <code>optional .com.google.protos.adx.BidRequest.Device.DeviceType device_type = 1 [default = UNKNOWN_DEVICE];</code>
       * @return Whether the deviceType field is set.
       */
      @java.lang.Override public boolean hasDeviceType() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <code>optional .com.google.protos.adx.BidRequest.Device.DeviceType device_type = 1 [default = UNKNOWN_DEVICE];</code>
       * @return The deviceType.
       */
      @java.lang.Override public com.google.protos.adx.NetworkBid.BidRequest.Device.DeviceType getDeviceType() {
        @SuppressWarnings("deprecation")
        com.google.protos.adx.NetworkBid.BidRequest.Device.DeviceType result = com.google.protos.adx.NetworkBid.BidRequest.Device.DeviceType.valueOf(deviceType_);
        return result == null ? com.google.protos.adx.NetworkBid.BidRequest.Device.DeviceType.UNKNOWN_DEVICE : result;
      }

      public static final int PLATFORM_FIELD_NUMBER = 2;
      private volatile java.lang.Object platform_;
      /**
       * <pre>
       * The platform of the device. Examples: android, iphone, palm
       * </pre>
       *
       * <code>optional string platform = 2 [default = ""];</code>
       * @return Whether the platform field is set.
       */
      @java.lang.Override
      public boolean hasPlatform() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <pre>
       * The platform of the device. Examples: android, iphone, palm
       * </pre>
       *
       * <code>optional string platform = 2 [default = ""];</code>
       * @return The platform.
       */
      @java.lang.Override
      public java.lang.String getPlatform() {
        java.lang.Object ref = platform_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = 
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            platform_ = s;
          }
          return s;
        }
      }
      /**
       * <pre>
       * The platform of the device. Examples: android, iphone, palm
       * </pre>
       *
       * <code>optional string platform = 2 [default = ""];</code>
       * @return The bytes for platform.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString
          getPlatformBytes() {
        java.lang.Object ref = platform_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          platform_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int BRAND_FIELD_NUMBER = 3;
      private volatile java.lang.Object brand_;
      /**
       * <pre>
       * The brand of the device, e.g., Nokia, Samsung.
       * </pre>
       *
       * <code>optional string brand = 3 [default = ""];</code>
       * @return Whether the brand field is set.
       */
      @java.lang.Override
      public boolean hasBrand() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       * <pre>
       * The brand of the device, e.g., Nokia, Samsung.
       * </pre>
       *
       * <code>optional string brand = 3 [default = ""];</code>
       * @return The brand.
       */
      @java.lang.Override
      public java.lang.String getBrand() {
        java.lang.Object ref = brand_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = 
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            brand_ = s;
          }
          return s;
        }
      }
      /**
       * <pre>
       * The brand of the device, e.g., Nokia, Samsung.
       * </pre>
       *
       * <code>optional string brand = 3 [default = ""];</code>
       * @return The bytes for brand.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString
          getBrandBytes() {
        java.lang.Object ref = brand_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          brand_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int MODEL_FIELD_NUMBER = 4;
      private volatile java.lang.Object model_;
      /**
       * <pre>
       * The model of the device, e.g., N70, Galaxy.
       * </pre>
       *
       * <code>optional string model = 4 [default = ""];</code>
       * @return Whether the model field is set.
       */
      @java.lang.Override
      public boolean hasModel() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       * <pre>
       * The model of the device, e.g., N70, Galaxy.
       * </pre>
       *
       * <code>optional string model = 4 [default = ""];</code>
       * @return The model.
       */
      @java.lang.Override
      public java.lang.String getModel() {
        java.lang.Object ref = model_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = 
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            model_ = s;
          }
          return s;
        }
      }
      /**
       * <pre>
       * The model of the device, e.g., N70, Galaxy.
       * </pre>
       *
       * <code>optional string model = 4 [default = ""];</code>
       * @return The bytes for model.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString
          getModelBytes() {
        java.lang.Object ref = model_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          model_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int OS_VERSION_FIELD_NUMBER = 5;
      private com.google.protos.adx.NetworkBid.BidRequest.Device.OsVersion osVersion_;
      /**
       * <pre>
       * The OS version; e.g., 2 for Android 2.1, or 3.3 for iOS 3.3.1.
       * </pre>
       *
       * <code>optional .com.google.protos.adx.BidRequest.Device.OsVersion os_version = 5;</code>
       * @return Whether the osVersion field is set.
       */
      @java.lang.Override
      public boolean hasOsVersion() {
        return ((bitField0_ & 0x00000010) != 0);
      }
      /**
       * <pre>
       * The OS version; e.g., 2 for Android 2.1, or 3.3 for iOS 3.3.1.
       * </pre>
       *
       * <code>optional .com.google.protos.adx.BidRequest.Device.OsVersion os_version = 5;</code>
       * @return The osVersion.
       */
      @java.lang.Override
      public com.google.protos.adx.NetworkBid.BidRequest.Device.OsVersion getOsVersion() {
        return osVersion_ == null ? com.google.protos.adx.NetworkBid.BidRequest.Device.OsVersion.getDefaultInstance() : osVersion_;
      }
      /**
       * <pre>
       * The OS version; e.g., 2 for Android 2.1, or 3.3 for iOS 3.3.1.
       * </pre>
       *
       * <code>optional .com.google.protos.adx.BidRequest.Device.OsVersion os_version = 5;</code>
       */
      @java.lang.Override
      public com.google.protos.adx.NetworkBid.BidRequest.Device.OsVersionOrBuilder getOsVersionOrBuilder() {
        return osVersion_ == null ? com.google.protos.adx.NetworkBid.BidRequest.Device.OsVersion.getDefaultInstance() : osVersion_;
      }

      public static final int CARRIER_ID_FIELD_NUMBER = 6;
      private long carrierId_;
      /**
       * <pre>
       * Unique identifier for the mobile carrier if the device is connected to
       * the internet via a carrier (as opposed to via WiFi). To look up carrier
       * name from carrier ID, please refer to:
       * https://storage.googleapis.com/adx-rtb-dictionaries/mobile-carriers.csv.
       * </pre>
       *
       * <code>optional int64 carrier_id = 6 [default = 0];</code>
       * @return Whether the carrierId field is set.
       */
      @java.lang.Override
      public boolean hasCarrierId() {
        return ((bitField0_ & 0x00000020) != 0);
      }
      /**
       * <pre>
       * Unique identifier for the mobile carrier if the device is connected to
       * the internet via a carrier (as opposed to via WiFi). To look up carrier
       * name from carrier ID, please refer to:
       * https://storage.googleapis.com/adx-rtb-dictionaries/mobile-carriers.csv.
       * </pre>
       *
       * <code>optional int64 carrier_id = 6 [default = 0];</code>
       * @return The carrierId.
       */
      @java.lang.Override
      public long getCarrierId() {
        return carrierId_;
      }

      public static final int SCREEN_WIDTH_FIELD_NUMBER = 7;
      private int screenWidth_;
      /**
       * <pre>
       * The width of the device screen in pixels.
       * </pre>
       *
       * <code>optional int32 screen_width = 7 [default = 0];</code>
       * @return Whether the screenWidth field is set.
       */
      @java.lang.Override
      public boolean hasScreenWidth() {
        return ((bitField0_ & 0x00000040) != 0);
      }
      /**
       * <pre>
       * The width of the device screen in pixels.
       * </pre>
       *
       * <code>optional int32 screen_width = 7 [default = 0];</code>
       * @return The screenWidth.
       */
      @java.lang.Override
      public int getScreenWidth() {
        return screenWidth_;
      }

      public static final int SCREEN_HEIGHT_FIELD_NUMBER = 8;
      private int screenHeight_;
      /**
       * <pre>
       * The height of the device screen in pixels.
       * </pre>
       *
       * <code>optional int32 screen_height = 8 [default = 0];</code>
       * @return Whether the screenHeight field is set.
       */
      @java.lang.Override
      public boolean hasScreenHeight() {
        return ((bitField0_ & 0x00000080) != 0);
      }
      /**
       * <pre>
       * The height of the device screen in pixels.
       * </pre>
       *
       * <code>optional int32 screen_height = 8 [default = 0];</code>
       * @return The screenHeight.
       */
      @java.lang.Override
      public int getScreenHeight() {
        return screenHeight_;
      }

      public static final int SCREEN_PIXEL_RATIO_MILLIS_FIELD_NUMBER = 9;
      private int screenPixelRatioMillis_;
      /**
       * <pre>
       * Used for high-density devices (e.g., iOS retina displays). A non-default
       * value indicates that the nominal screen size (with pixels as the unit)
       * does not describe the actual number of pixels in the screen. For example,
       * nominal width and height may be 320x640 for a screen that actually has
       * 640x1280 pixels, in which case screen_width=320, screen_height=640, and
       * screen_pixel_ratio_millis=2000, since each axis has twice as many pixels
       * as its dimensions would indicate.
       * </pre>
       *
       * <code>optional int32 screen_pixel_ratio_millis = 9 [default = 0];</code>
       * @return Whether the screenPixelRatioMillis field is set.
       */
      @java.lang.Override
      public boolean hasScreenPixelRatioMillis() {
        return ((bitField0_ & 0x00000100) != 0);
      }
      /**
       * <pre>
       * Used for high-density devices (e.g., iOS retina displays). A non-default
       * value indicates that the nominal screen size (with pixels as the unit)
       * does not describe the actual number of pixels in the screen. For example,
       * nominal width and height may be 320x640 for a screen that actually has
       * 640x1280 pixels, in which case screen_width=320, screen_height=640, and
       * screen_pixel_ratio_millis=2000, since each axis has twice as many pixels
       * as its dimensions would indicate.
       * </pre>
       *
       * <code>optional int32 screen_pixel_ratio_millis = 9 [default = 0];</code>
       * @return The screenPixelRatioMillis.
       */
      @java.lang.Override
      public int getScreenPixelRatioMillis() {
        return screenPixelRatioMillis_;
      }

      public static final int SCREEN_ORIENTATION_FIELD_NUMBER = 10;
      private int screenOrientation_;
      /**
       * <pre>
       * The screen orientation of the device when the ad request is sent.
       * </pre>
       *
       * <code>optional .com.google.protos.adx.BidRequest.Device.ScreenOrientation screen_orientation = 10 [default = UNKNOWN_ORIENTATION];</code>
       * @return Whether the screenOrientation field is set.
       */
      @java.lang.Override public boolean hasScreenOrientation() {
        return ((bitField0_ & 0x00000200) != 0);
      }
      /**
       * <pre>
       * The screen orientation of the device when the ad request is sent.
       * </pre>
       *
       * <code>optional .com.google.protos.adx.BidRequest.Device.ScreenOrientation screen_orientation = 10 [default = UNKNOWN_ORIENTATION];</code>
       * @return The screenOrientation.
       */
      @java.lang.Override public com.google.protos.adx.NetworkBid.BidRequest.Device.ScreenOrientation getScreenOrientation() {
        @SuppressWarnings("deprecation")
        com.google.protos.adx.NetworkBid.BidRequest.Device.ScreenOrientation result = com.google.protos.adx.NetworkBid.BidRequest.Device.ScreenOrientation.valueOf(screenOrientation_);
        return result == null ? com.google.protos.adx.NetworkBid.BidRequest.Device.ScreenOrientation.UNKNOWN_ORIENTATION : result;
      }

      public static final int HARDWARE_VERSION_FIELD_NUMBER = 11;
      private volatile java.lang.Object hardwareVersion_;
      /**
       * <pre>
       * Apple iOS device model, e.g., "iphone 5s", "iphone 6+", "ipad 4".
       * </pre>
       *
       * <code>optional string hardware_version = 11;</code>
       * @return Whether the hardwareVersion field is set.
       */
      @java.lang.Override
      public boolean hasHardwareVersion() {
        return ((bitField0_ & 0x00000400) != 0);
      }
      /**
       * <pre>
       * Apple iOS device model, e.g., "iphone 5s", "iphone 6+", "ipad 4".
       * </pre>
       *
       * <code>optional string hardware_version = 11;</code>
       * @return The hardwareVersion.
       */
      @java.lang.Override
      public java.lang.String getHardwareVersion() {
        java.lang.Object ref = hardwareVersion_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = 
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            hardwareVersion_ = s;
          }
          return s;
        }
      }
      /**
       * <pre>
       * Apple iOS device model, e.g., "iphone 5s", "iphone 6+", "ipad 4".
       * </pre>
       *
       * <code>optional string hardware_version = 11;</code>
       * @return The bytes for hardwareVersion.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString
          getHardwareVersionBytes() {
        java.lang.Object ref = hardwareVersion_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          hardwareVersion_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int LIMIT_AD_TRACKING_FIELD_NUMBER = 12;
      private boolean limitAdTracking_;
      /**
       * <pre>
       * Indicates whether the user has opted out of interest based advertising or
       * ads personalization as determined by an OS-level setting in iOS or
       * Android:
       * https://support.apple.com/en-us/HT202074
       * https://support.google.com/googleplay/answer/3405269
       * </pre>
       *
       * <code>optional bool limit_ad_tracking = 12;</code>
       * @return Whether the limitAdTracking field is set.
       */
      @java.lang.Override
      public boolean hasLimitAdTracking() {
        return ((bitField0_ & 0x00000800) != 0);
      }
      /**
       * <pre>
       * Indicates whether the user has opted out of interest based advertising or
       * ads personalization as determined by an OS-level setting in iOS or
       * Android:
       * https://support.apple.com/en-us/HT202074
       * https://support.google.com/googleplay/answer/3405269
       * </pre>
       *
       * <code>optional bool limit_ad_tracking = 12;</code>
       * @return The limitAdTracking.
       */
      @java.lang.Override
      public boolean getLimitAdTracking() {
        return limitAdTracking_;
      }

      public static final int APP_TRACKING_AUTHORIZATION_STATUS_FIELD_NUMBER = 13;
      private int appTrackingAuthorizationStatus_;
      /**
       * <pre>
       * This field is only populated for iOS devices. Indicates the app tracking
       * authorization status. This value is retrieved from ATTrackingManager
       * and provided as is. For more information about iOS's app tracking
       * authorization status, see:
       * https://developer.apple.com/documentation/apptrackingtransparency/attrackingmanager/authorizationstatus
       * </pre>
       *
       * <code>optional .com.google.protos.adx.BidRequest.Device.AuthorizationStatus app_tracking_authorization_status = 13;</code>
       * @return Whether the appTrackingAuthorizationStatus field is set.
       */
      @java.lang.Override public boolean hasAppTrackingAuthorizationStatus() {
        return ((bitField0_ & 0x00001000) != 0);
      }
      /**
       * <pre>
       * This field is only populated for iOS devices. Indicates the app tracking
       * authorization status. This value is retrieved from ATTrackingManager
       * and provided as is. For more information about iOS's app tracking
       * authorization status, see:
       * https://developer.apple.com/documentation/apptrackingtransparency/attrackingmanager/authorizationstatus
       * </pre>
       *
       * <code>optional .com.google.protos.adx.BidRequest.Device.AuthorizationStatus app_tracking_authorization_status = 13;</code>
       * @return The appTrackingAuthorizationStatus.
       */
      @java.lang.Override public com.google.protos.adx.NetworkBid.BidRequest.Device.AuthorizationStatus getAppTrackingAuthorizationStatus() {
        @SuppressWarnings("deprecation")
        com.google.protos.adx.NetworkBid.BidRequest.Device.AuthorizationStatus result = com.google.protos.adx.NetworkBid.BidRequest.Device.AuthorizationStatus.valueOf(appTrackingAuthorizationStatus_);
        return result == null ? com.google.protos.adx.NetworkBid.BidRequest.Device.AuthorizationStatus.NOT_DETERMINED : result;
      }

      private byte memoizedIsInitialized = -1;
      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output)
                          throws java.io.IOException {
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeEnum(1, deviceType_);
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 2, platform_);
        }
        if (((bitField0_ & 0x00000004) != 0)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 3, brand_);
        }
        if (((bitField0_ & 0x00000008) != 0)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 4, model_);
        }
        if (((bitField0_ & 0x00000010) != 0)) {
          output.writeMessage(5, getOsVersion());
        }
        if (((bitField0_ & 0x00000020) != 0)) {
          output.writeInt64(6, carrierId_);
        }
        if (((bitField0_ & 0x00000040) != 0)) {
          output.writeInt32(7, screenWidth_);
        }
        if (((bitField0_ & 0x00000080) != 0)) {
          output.writeInt32(8, screenHeight_);
        }
        if (((bitField0_ & 0x00000100) != 0)) {
          output.writeInt32(9, screenPixelRatioMillis_);
        }
        if (((bitField0_ & 0x00000200) != 0)) {
          output.writeEnum(10, screenOrientation_);
        }
        if (((bitField0_ & 0x00000400) != 0)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 11, hardwareVersion_);
        }
        if (((bitField0_ & 0x00000800) != 0)) {
          output.writeBool(12, limitAdTracking_);
        }
        if (((bitField0_ & 0x00001000) != 0)) {
          output.writeEnum(13, appTrackingAuthorizationStatus_);
        }
        unknownFields.writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.CodedOutputStream
            .computeEnumSize(1, deviceType_);
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, platform_);
        }
        if (((bitField0_ & 0x00000004) != 0)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, brand_);
        }
        if (((bitField0_ & 0x00000008) != 0)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, model_);
        }
        if (((bitField0_ & 0x00000010) != 0)) {
          size += com.google.protobuf.CodedOutputStream
            .computeMessageSize(5, getOsVersion());
        }
        if (((bitField0_ & 0x00000020) != 0)) {
          size += com.google.protobuf.CodedOutputStream
            .computeInt64Size(6, carrierId_);
        }
        if (((bitField0_ & 0x00000040) != 0)) {
          size += com.google.protobuf.CodedOutputStream
            .computeInt32Size(7, screenWidth_);
        }
        if (((bitField0_ & 0x00000080) != 0)) {
          size += com.google.protobuf.CodedOutputStream
            .computeInt32Size(8, screenHeight_);
        }
        if (((bitField0_ & 0x00000100) != 0)) {
          size += com.google.protobuf.CodedOutputStream
            .computeInt32Size(9, screenPixelRatioMillis_);
        }
        if (((bitField0_ & 0x00000200) != 0)) {
          size += com.google.protobuf.CodedOutputStream
            .computeEnumSize(10, screenOrientation_);
        }
        if (((bitField0_ & 0x00000400) != 0)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, hardwareVersion_);
        }
        if (((bitField0_ & 0x00000800) != 0)) {
          size += com.google.protobuf.CodedOutputStream
            .computeBoolSize(12, limitAdTracking_);
        }
        if (((bitField0_ & 0x00001000) != 0)) {
          size += com.google.protobuf.CodedOutputStream
            .computeEnumSize(13, appTrackingAuthorizationStatus_);
        }
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
         return true;
        }
        if (!(obj instanceof com.google.protos.adx.NetworkBid.BidRequest.Device)) {
          return super.equals(obj);
        }
        com.google.protos.adx.NetworkBid.BidRequest.Device other = (com.google.protos.adx.NetworkBid.BidRequest.Device) obj;

        if (hasDeviceType() != other.hasDeviceType()) return false;
        if (hasDeviceType()) {
          if (deviceType_ != other.deviceType_) return false;
        }
        if (hasPlatform() != other.hasPlatform()) return false;
        if (hasPlatform()) {
          if (!getPlatform()
              .equals(other.getPlatform())) return false;
        }
        if (hasBrand() != other.hasBrand()) return false;
        if (hasBrand()) {
          if (!getBrand()
              .equals(other.getBrand())) return false;
        }
        if (hasModel() != other.hasModel()) return false;
        if (hasModel()) {
          if (!getModel()
              .equals(other.getModel())) return false;
        }
        if (hasOsVersion() != other.hasOsVersion()) return false;
        if (hasOsVersion()) {
          if (!getOsVersion()
              .equals(other.getOsVersion())) return false;
        }
        if (hasCarrierId() != other.hasCarrierId()) return false;
        if (hasCarrierId()) {
          if (getCarrierId()
              != other.getCarrierId()) return false;
        }
        if (hasScreenWidth() != other.hasScreenWidth()) return false;
        if (hasScreenWidth()) {
          if (getScreenWidth()
              != other.getScreenWidth()) return false;
        }
        if (hasScreenHeight() != other.hasScreenHeight()) return false;
        if (hasScreenHeight()) {
          if (getScreenHeight()
              != other.getScreenHeight()) return false;
        }
        if (hasScreenPixelRatioMillis() != other.hasScreenPixelRatioMillis()) return false;
        if (hasScreenPixelRatioMillis()) {
          if (getScreenPixelRatioMillis()
              != other.getScreenPixelRatioMillis()) return false;
        }
        if (hasScreenOrientation() != other.hasScreenOrientation()) return false;
        if (hasScreenOrientation()) {
          if (screenOrientation_ != other.screenOrientation_) return false;
        }
        if (hasHardwareVersion() != other.hasHardwareVersion()) return false;
        if (hasHardwareVersion()) {
          if (!getHardwareVersion()
              .equals(other.getHardwareVersion())) return false;
        }
        if (hasLimitAdTracking() != other.hasLimitAdTracking()) return false;
        if (hasLimitAdTracking()) {
          if (getLimitAdTracking()
              != other.getLimitAdTracking()) return false;
        }
        if (hasAppTrackingAuthorizationStatus() != other.hasAppTrackingAuthorizationStatus()) return false;
        if (hasAppTrackingAuthorizationStatus()) {
          if (appTrackingAuthorizationStatus_ != other.appTrackingAuthorizationStatus_) return false;
        }
        if (!unknownFields.equals(other.unknownFields)) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasDeviceType()) {
          hash = (37 * hash) + DEVICE_TYPE_FIELD_NUMBER;
          hash = (53 * hash) + deviceType_;
        }
        if (hasPlatform()) {
          hash = (37 * hash) + PLATFORM_FIELD_NUMBER;
          hash = (53 * hash) + getPlatform().hashCode();
        }
        if (hasBrand()) {
          hash = (37 * hash) + BRAND_FIELD_NUMBER;
          hash = (53 * hash) + getBrand().hashCode();
        }
        if (hasModel()) {
          hash = (37 * hash) + MODEL_FIELD_NUMBER;
          hash = (53 * hash) + getModel().hashCode();
        }
        if (hasOsVersion()) {
          hash = (37 * hash) + OS_VERSION_FIELD_NUMBER;
          hash = (53 * hash) + getOsVersion().hashCode();
        }
        if (hasCarrierId()) {
          hash = (37 * hash) + CARRIER_ID_FIELD_NUMBER;
          hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
              getCarrierId());
        }
        if (hasScreenWidth()) {
          hash = (37 * hash) + SCREEN_WIDTH_FIELD_NUMBER;
          hash = (53 * hash) + getScreenWidth();
        }
        if (hasScreenHeight()) {
          hash = (37 * hash) + SCREEN_HEIGHT_FIELD_NUMBER;
          hash = (53 * hash) + getScreenHeight();
        }
        if (hasScreenPixelRatioMillis()) {
          hash = (37 * hash) + SCREEN_PIXEL_RATIO_MILLIS_FIELD_NUMBER;
          hash = (53 * hash) + getScreenPixelRatioMillis();
        }
        if (hasScreenOrientation()) {
          hash = (37 * hash) + SCREEN_ORIENTATION_FIELD_NUMBER;
          hash = (53 * hash) + screenOrientation_;
        }
        if (hasHardwareVersion()) {
          hash = (37 * hash) + HARDWARE_VERSION_FIELD_NUMBER;
          hash = (53 * hash) + getHardwareVersion().hashCode();
        }
        if (hasLimitAdTracking()) {
          hash = (37 * hash) + LIMIT_AD_TRACKING_FIELD_NUMBER;
          hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
              getLimitAdTracking());
        }
        if (hasAppTrackingAuthorizationStatus()) {
          hash = (37 * hash) + APP_TRACKING_AUTHORIZATION_STATUS_FIELD_NUMBER;
          hash = (53 * hash) + appTrackingAuthorizationStatus_;
        }
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.protos.adx.NetworkBid.BidRequest.Device parseFrom(
          java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.Device parseFrom(
          java.nio.ByteBuffer data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.Device parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.Device parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.Device parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.Device parseFrom(
          byte[] data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.Device parseFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.Device parseFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.Device parseDelimitedFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.Device parseDelimitedFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.Device parseFrom(
          com.google.protobuf.CodedInputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.Device parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() { return newBuilder(); }
      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }
      public static Builder newBuilder(com.google.protos.adx.NetworkBid.BidRequest.Device prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }
      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE
            ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * <pre>
       * Information about the device.
       * </pre>
       *
       * Protobuf type {@code com.google.protos.adx.BidRequest.Device}
       */
      public static final class Builder extends
          com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
          // @@protoc_insertion_point(builder_implements:com.google.protos.adx.BidRequest.Device)
          com.google.protos.adx.NetworkBid.BidRequest.DeviceOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
          return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_Device_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_Device_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.protos.adx.NetworkBid.BidRequest.Device.class, com.google.protos.adx.NetworkBid.BidRequest.Device.Builder.class);
        }

        // Construct using com.google.protos.adx.NetworkBid.BidRequest.Device.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }
        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3
                  .alwaysUseFieldBuilders) {
            getOsVersionFieldBuilder();
          }
        }
        @java.lang.Override
        public Builder clear() {
          super.clear();
          deviceType_ = 0;
          bitField0_ = (bitField0_ & ~0x00000001);
          platform_ = "";
          bitField0_ = (bitField0_ & ~0x00000002);
          brand_ = "";
          bitField0_ = (bitField0_ & ~0x00000004);
          model_ = "";
          bitField0_ = (bitField0_ & ~0x00000008);
          if (osVersionBuilder_ == null) {
            osVersion_ = null;
          } else {
            osVersionBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000010);
          carrierId_ = 0L;
          bitField0_ = (bitField0_ & ~0x00000020);
          screenWidth_ = 0;
          bitField0_ = (bitField0_ & ~0x00000040);
          screenHeight_ = 0;
          bitField0_ = (bitField0_ & ~0x00000080);
          screenPixelRatioMillis_ = 0;
          bitField0_ = (bitField0_ & ~0x00000100);
          screenOrientation_ = 0;
          bitField0_ = (bitField0_ & ~0x00000200);
          hardwareVersion_ = "";
          bitField0_ = (bitField0_ & ~0x00000400);
          limitAdTracking_ = false;
          bitField0_ = (bitField0_ & ~0x00000800);
          appTrackingAuthorizationStatus_ = 0;
          bitField0_ = (bitField0_ & ~0x00001000);
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
          return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_Device_descriptor;
        }

        @java.lang.Override
        public com.google.protos.adx.NetworkBid.BidRequest.Device getDefaultInstanceForType() {
          return com.google.protos.adx.NetworkBid.BidRequest.Device.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.protos.adx.NetworkBid.BidRequest.Device build() {
          com.google.protos.adx.NetworkBid.BidRequest.Device result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.protos.adx.NetworkBid.BidRequest.Device buildPartial() {
          com.google.protos.adx.NetworkBid.BidRequest.Device result = new com.google.protos.adx.NetworkBid.BidRequest.Device(this);
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            to_bitField0_ |= 0x00000001;
          }
          result.deviceType_ = deviceType_;
          if (((from_bitField0_ & 0x00000002) != 0)) {
            to_bitField0_ |= 0x00000002;
          }
          result.platform_ = platform_;
          if (((from_bitField0_ & 0x00000004) != 0)) {
            to_bitField0_ |= 0x00000004;
          }
          result.brand_ = brand_;
          if (((from_bitField0_ & 0x00000008) != 0)) {
            to_bitField0_ |= 0x00000008;
          }
          result.model_ = model_;
          if (((from_bitField0_ & 0x00000010) != 0)) {
            if (osVersionBuilder_ == null) {
              result.osVersion_ = osVersion_;
            } else {
              result.osVersion_ = osVersionBuilder_.build();
            }
            to_bitField0_ |= 0x00000010;
          }
          if (((from_bitField0_ & 0x00000020) != 0)) {
            result.carrierId_ = carrierId_;
            to_bitField0_ |= 0x00000020;
          }
          if (((from_bitField0_ & 0x00000040) != 0)) {
            result.screenWidth_ = screenWidth_;
            to_bitField0_ |= 0x00000040;
          }
          if (((from_bitField0_ & 0x00000080) != 0)) {
            result.screenHeight_ = screenHeight_;
            to_bitField0_ |= 0x00000080;
          }
          if (((from_bitField0_ & 0x00000100) != 0)) {
            result.screenPixelRatioMillis_ = screenPixelRatioMillis_;
            to_bitField0_ |= 0x00000100;
          }
          if (((from_bitField0_ & 0x00000200) != 0)) {
            to_bitField0_ |= 0x00000200;
          }
          result.screenOrientation_ = screenOrientation_;
          if (((from_bitField0_ & 0x00000400) != 0)) {
            to_bitField0_ |= 0x00000400;
          }
          result.hardwareVersion_ = hardwareVersion_;
          if (((from_bitField0_ & 0x00000800) != 0)) {
            result.limitAdTracking_ = limitAdTracking_;
            to_bitField0_ |= 0x00000800;
          }
          if (((from_bitField0_ & 0x00001000) != 0)) {
            to_bitField0_ |= 0x00001000;
          }
          result.appTrackingAuthorizationStatus_ = appTrackingAuthorizationStatus_;
          result.bitField0_ = to_bitField0_;
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }
        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.setField(field, value);
        }
        @java.lang.Override
        public Builder clearField(
            com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }
        @java.lang.Override
        public Builder clearOneof(
            com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }
        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index, java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }
        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }
        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.protos.adx.NetworkBid.BidRequest.Device) {
            return mergeFrom((com.google.protos.adx.NetworkBid.BidRequest.Device)other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.google.protos.adx.NetworkBid.BidRequest.Device other) {
          if (other == com.google.protos.adx.NetworkBid.BidRequest.Device.getDefaultInstance()) return this;
          if (other.hasDeviceType()) {
            setDeviceType(other.getDeviceType());
          }
          if (other.hasPlatform()) {
            bitField0_ |= 0x00000002;
            platform_ = other.platform_;
            onChanged();
          }
          if (other.hasBrand()) {
            bitField0_ |= 0x00000004;
            brand_ = other.brand_;
            onChanged();
          }
          if (other.hasModel()) {
            bitField0_ |= 0x00000008;
            model_ = other.model_;
            onChanged();
          }
          if (other.hasOsVersion()) {
            mergeOsVersion(other.getOsVersion());
          }
          if (other.hasCarrierId()) {
            setCarrierId(other.getCarrierId());
          }
          if (other.hasScreenWidth()) {
            setScreenWidth(other.getScreenWidth());
          }
          if (other.hasScreenHeight()) {
            setScreenHeight(other.getScreenHeight());
          }
          if (other.hasScreenPixelRatioMillis()) {
            setScreenPixelRatioMillis(other.getScreenPixelRatioMillis());
          }
          if (other.hasScreenOrientation()) {
            setScreenOrientation(other.getScreenOrientation());
          }
          if (other.hasHardwareVersion()) {
            bitField0_ |= 0x00000400;
            hardwareVersion_ = other.hardwareVersion_;
            onChanged();
          }
          if (other.hasLimitAdTracking()) {
            setLimitAdTracking(other.getLimitAdTracking());
          }
          if (other.hasAppTrackingAuthorizationStatus()) {
            setAppTrackingAuthorizationStatus(other.getAppTrackingAuthorizationStatus());
          }
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          com.google.protos.adx.NetworkBid.BidRequest.Device parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage = (com.google.protos.adx.NetworkBid.BidRequest.Device) e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }
        private int bitField0_;

        private int deviceType_ = 0;
        /**
         * <code>optional .com.google.protos.adx.BidRequest.Device.DeviceType device_type = 1 [default = UNKNOWN_DEVICE];</code>
         * @return Whether the deviceType field is set.
         */
        @java.lang.Override public boolean hasDeviceType() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         * <code>optional .com.google.protos.adx.BidRequest.Device.DeviceType device_type = 1 [default = UNKNOWN_DEVICE];</code>
         * @return The deviceType.
         */
        @java.lang.Override
        public com.google.protos.adx.NetworkBid.BidRequest.Device.DeviceType getDeviceType() {
          @SuppressWarnings("deprecation")
          com.google.protos.adx.NetworkBid.BidRequest.Device.DeviceType result = com.google.protos.adx.NetworkBid.BidRequest.Device.DeviceType.valueOf(deviceType_);
          return result == null ? com.google.protos.adx.NetworkBid.BidRequest.Device.DeviceType.UNKNOWN_DEVICE : result;
        }
        /**
         * <code>optional .com.google.protos.adx.BidRequest.Device.DeviceType device_type = 1 [default = UNKNOWN_DEVICE];</code>
         * @param value The deviceType to set.
         * @return This builder for chaining.
         */
        public Builder setDeviceType(com.google.protos.adx.NetworkBid.BidRequest.Device.DeviceType value) {
          if (value == null) {
            throw new NullPointerException();
          }
          bitField0_ |= 0x00000001;
          deviceType_ = value.getNumber();
          onChanged();
          return this;
        }
        /**
         * <code>optional .com.google.protos.adx.BidRequest.Device.DeviceType device_type = 1 [default = UNKNOWN_DEVICE];</code>
         * @return This builder for chaining.
         */
        public Builder clearDeviceType() {
          bitField0_ = (bitField0_ & ~0x00000001);
          deviceType_ = 0;
          onChanged();
          return this;
        }

        private java.lang.Object platform_ = "";
        /**
         * <pre>
         * The platform of the device. Examples: android, iphone, palm
         * </pre>
         *
         * <code>optional string platform = 2 [default = ""];</code>
         * @return Whether the platform field is set.
         */
        public boolean hasPlatform() {
          return ((bitField0_ & 0x00000002) != 0);
        }
        /**
         * <pre>
         * The platform of the device. Examples: android, iphone, palm
         * </pre>
         *
         * <code>optional string platform = 2 [default = ""];</code>
         * @return The platform.
         */
        public java.lang.String getPlatform() {
          java.lang.Object ref = platform_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs =
                (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            if (bs.isValidUtf8()) {
              platform_ = s;
            }
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         * <pre>
         * The platform of the device. Examples: android, iphone, palm
         * </pre>
         *
         * <code>optional string platform = 2 [default = ""];</code>
         * @return The bytes for platform.
         */
        public com.google.protobuf.ByteString
            getPlatformBytes() {
          java.lang.Object ref = platform_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b = 
                com.google.protobuf.ByteString.copyFromUtf8(
                    (java.lang.String) ref);
            platform_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         * <pre>
         * The platform of the device. Examples: android, iphone, palm
         * </pre>
         *
         * <code>optional string platform = 2 [default = ""];</code>
         * @param value The platform to set.
         * @return This builder for chaining.
         */
        public Builder setPlatform(
            java.lang.String value) {
          if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
          platform_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * The platform of the device. Examples: android, iphone, palm
         * </pre>
         *
         * <code>optional string platform = 2 [default = ""];</code>
         * @return This builder for chaining.
         */
        public Builder clearPlatform() {
          bitField0_ = (bitField0_ & ~0x00000002);
          platform_ = getDefaultInstance().getPlatform();
          onChanged();
          return this;
        }
        /**
         * <pre>
         * The platform of the device. Examples: android, iphone, palm
         * </pre>
         *
         * <code>optional string platform = 2 [default = ""];</code>
         * @param value The bytes for platform to set.
         * @return This builder for chaining.
         */
        public Builder setPlatformBytes(
            com.google.protobuf.ByteString value) {
          if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
          platform_ = value;
          onChanged();
          return this;
        }

        private java.lang.Object brand_ = "";
        /**
         * <pre>
         * The brand of the device, e.g., Nokia, Samsung.
         * </pre>
         *
         * <code>optional string brand = 3 [default = ""];</code>
         * @return Whether the brand field is set.
         */
        public boolean hasBrand() {
          return ((bitField0_ & 0x00000004) != 0);
        }
        /**
         * <pre>
         * The brand of the device, e.g., Nokia, Samsung.
         * </pre>
         *
         * <code>optional string brand = 3 [default = ""];</code>
         * @return The brand.
         */
        public java.lang.String getBrand() {
          java.lang.Object ref = brand_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs =
                (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            if (bs.isValidUtf8()) {
              brand_ = s;
            }
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         * <pre>
         * The brand of the device, e.g., Nokia, Samsung.
         * </pre>
         *
         * <code>optional string brand = 3 [default = ""];</code>
         * @return The bytes for brand.
         */
        public com.google.protobuf.ByteString
            getBrandBytes() {
          java.lang.Object ref = brand_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b = 
                com.google.protobuf.ByteString.copyFromUtf8(
                    (java.lang.String) ref);
            brand_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         * <pre>
         * The brand of the device, e.g., Nokia, Samsung.
         * </pre>
         *
         * <code>optional string brand = 3 [default = ""];</code>
         * @param value The brand to set.
         * @return This builder for chaining.
         */
        public Builder setBrand(
            java.lang.String value) {
          if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000004;
          brand_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * The brand of the device, e.g., Nokia, Samsung.
         * </pre>
         *
         * <code>optional string brand = 3 [default = ""];</code>
         * @return This builder for chaining.
         */
        public Builder clearBrand() {
          bitField0_ = (bitField0_ & ~0x00000004);
          brand_ = getDefaultInstance().getBrand();
          onChanged();
          return this;
        }
        /**
         * <pre>
         * The brand of the device, e.g., Nokia, Samsung.
         * </pre>
         *
         * <code>optional string brand = 3 [default = ""];</code>
         * @param value The bytes for brand to set.
         * @return This builder for chaining.
         */
        public Builder setBrandBytes(
            com.google.protobuf.ByteString value) {
          if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000004;
          brand_ = value;
          onChanged();
          return this;
        }

        private java.lang.Object model_ = "";
        /**
         * <pre>
         * The model of the device, e.g., N70, Galaxy.
         * </pre>
         *
         * <code>optional string model = 4 [default = ""];</code>
         * @return Whether the model field is set.
         */
        public boolean hasModel() {
          return ((bitField0_ & 0x00000008) != 0);
        }
        /**
         * <pre>
         * The model of the device, e.g., N70, Galaxy.
         * </pre>
         *
         * <code>optional string model = 4 [default = ""];</code>
         * @return The model.
         */
        public java.lang.String getModel() {
          java.lang.Object ref = model_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs =
                (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            if (bs.isValidUtf8()) {
              model_ = s;
            }
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         * <pre>
         * The model of the device, e.g., N70, Galaxy.
         * </pre>
         *
         * <code>optional string model = 4 [default = ""];</code>
         * @return The bytes for model.
         */
        public com.google.protobuf.ByteString
            getModelBytes() {
          java.lang.Object ref = model_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b = 
                com.google.protobuf.ByteString.copyFromUtf8(
                    (java.lang.String) ref);
            model_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         * <pre>
         * The model of the device, e.g., N70, Galaxy.
         * </pre>
         *
         * <code>optional string model = 4 [default = ""];</code>
         * @param value The model to set.
         * @return This builder for chaining.
         */
        public Builder setModel(
            java.lang.String value) {
          if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000008;
          model_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * The model of the device, e.g., N70, Galaxy.
         * </pre>
         *
         * <code>optional string model = 4 [default = ""];</code>
         * @return This builder for chaining.
         */
        public Builder clearModel() {
          bitField0_ = (bitField0_ & ~0x00000008);
          model_ = getDefaultInstance().getModel();
          onChanged();
          return this;
        }
        /**
         * <pre>
         * The model of the device, e.g., N70, Galaxy.
         * </pre>
         *
         * <code>optional string model = 4 [default = ""];</code>
         * @param value The bytes for model to set.
         * @return This builder for chaining.
         */
        public Builder setModelBytes(
            com.google.protobuf.ByteString value) {
          if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000008;
          model_ = value;
          onChanged();
          return this;
        }

        private com.google.protos.adx.NetworkBid.BidRequest.Device.OsVersion osVersion_;
        private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protos.adx.NetworkBid.BidRequest.Device.OsVersion, com.google.protos.adx.NetworkBid.BidRequest.Device.OsVersion.Builder, com.google.protos.adx.NetworkBid.BidRequest.Device.OsVersionOrBuilder> osVersionBuilder_;
        /**
         * <pre>
         * The OS version; e.g., 2 for Android 2.1, or 3.3 for iOS 3.3.1.
         * </pre>
         *
         * <code>optional .com.google.protos.adx.BidRequest.Device.OsVersion os_version = 5;</code>
         * @return Whether the osVersion field is set.
         */
        public boolean hasOsVersion() {
          return ((bitField0_ & 0x00000010) != 0);
        }
        /**
         * <pre>
         * The OS version; e.g., 2 for Android 2.1, or 3.3 for iOS 3.3.1.
         * </pre>
         *
         * <code>optional .com.google.protos.adx.BidRequest.Device.OsVersion os_version = 5;</code>
         * @return The osVersion.
         */
        public com.google.protos.adx.NetworkBid.BidRequest.Device.OsVersion getOsVersion() {
          if (osVersionBuilder_ == null) {
            return osVersion_ == null ? com.google.protos.adx.NetworkBid.BidRequest.Device.OsVersion.getDefaultInstance() : osVersion_;
          } else {
            return osVersionBuilder_.getMessage();
          }
        }
        /**
         * <pre>
         * The OS version; e.g., 2 for Android 2.1, or 3.3 for iOS 3.3.1.
         * </pre>
         *
         * <code>optional .com.google.protos.adx.BidRequest.Device.OsVersion os_version = 5;</code>
         */
        public Builder setOsVersion(com.google.protos.adx.NetworkBid.BidRequest.Device.OsVersion value) {
          if (osVersionBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            osVersion_ = value;
            onChanged();
          } else {
            osVersionBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000010;
          return this;
        }
        /**
         * <pre>
         * The OS version; e.g., 2 for Android 2.1, or 3.3 for iOS 3.3.1.
         * </pre>
         *
         * <code>optional .com.google.protos.adx.BidRequest.Device.OsVersion os_version = 5;</code>
         */
        public Builder setOsVersion(
            com.google.protos.adx.NetworkBid.BidRequest.Device.OsVersion.Builder builderForValue) {
          if (osVersionBuilder_ == null) {
            osVersion_ = builderForValue.build();
            onChanged();
          } else {
            osVersionBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000010;
          return this;
        }
        /**
         * <pre>
         * The OS version; e.g., 2 for Android 2.1, or 3.3 for iOS 3.3.1.
         * </pre>
         *
         * <code>optional .com.google.protos.adx.BidRequest.Device.OsVersion os_version = 5;</code>
         */
        public Builder mergeOsVersion(com.google.protos.adx.NetworkBid.BidRequest.Device.OsVersion value) {
          if (osVersionBuilder_ == null) {
            if (((bitField0_ & 0x00000010) != 0) &&
                osVersion_ != null &&
                osVersion_ != com.google.protos.adx.NetworkBid.BidRequest.Device.OsVersion.getDefaultInstance()) {
              osVersion_ =
                com.google.protos.adx.NetworkBid.BidRequest.Device.OsVersion.newBuilder(osVersion_).mergeFrom(value).buildPartial();
            } else {
              osVersion_ = value;
            }
            onChanged();
          } else {
            osVersionBuilder_.mergeFrom(value);
          }
          bitField0_ |= 0x00000010;
          return this;
        }
        /**
         * <pre>
         * The OS version; e.g., 2 for Android 2.1, or 3.3 for iOS 3.3.1.
         * </pre>
         *
         * <code>optional .com.google.protos.adx.BidRequest.Device.OsVersion os_version = 5;</code>
         */
        public Builder clearOsVersion() {
          if (osVersionBuilder_ == null) {
            osVersion_ = null;
            onChanged();
          } else {
            osVersionBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000010);
          return this;
        }
        /**
         * <pre>
         * The OS version; e.g., 2 for Android 2.1, or 3.3 for iOS 3.3.1.
         * </pre>
         *
         * <code>optional .com.google.protos.adx.BidRequest.Device.OsVersion os_version = 5;</code>
         */
        public com.google.protos.adx.NetworkBid.BidRequest.Device.OsVersion.Builder getOsVersionBuilder() {
          bitField0_ |= 0x00000010;
          onChanged();
          return getOsVersionFieldBuilder().getBuilder();
        }
        /**
         * <pre>
         * The OS version; e.g., 2 for Android 2.1, or 3.3 for iOS 3.3.1.
         * </pre>
         *
         * <code>optional .com.google.protos.adx.BidRequest.Device.OsVersion os_version = 5;</code>
         */
        public com.google.protos.adx.NetworkBid.BidRequest.Device.OsVersionOrBuilder getOsVersionOrBuilder() {
          if (osVersionBuilder_ != null) {
            return osVersionBuilder_.getMessageOrBuilder();
          } else {
            return osVersion_ == null ?
                com.google.protos.adx.NetworkBid.BidRequest.Device.OsVersion.getDefaultInstance() : osVersion_;
          }
        }
        /**
         * <pre>
         * The OS version; e.g., 2 for Android 2.1, or 3.3 for iOS 3.3.1.
         * </pre>
         *
         * <code>optional .com.google.protos.adx.BidRequest.Device.OsVersion os_version = 5;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protos.adx.NetworkBid.BidRequest.Device.OsVersion, com.google.protos.adx.NetworkBid.BidRequest.Device.OsVersion.Builder, com.google.protos.adx.NetworkBid.BidRequest.Device.OsVersionOrBuilder> 
            getOsVersionFieldBuilder() {
          if (osVersionBuilder_ == null) {
            osVersionBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protos.adx.NetworkBid.BidRequest.Device.OsVersion, com.google.protos.adx.NetworkBid.BidRequest.Device.OsVersion.Builder, com.google.protos.adx.NetworkBid.BidRequest.Device.OsVersionOrBuilder>(
                    getOsVersion(),
                    getParentForChildren(),
                    isClean());
            osVersion_ = null;
          }
          return osVersionBuilder_;
        }

        private long carrierId_ ;
        /**
         * <pre>
         * Unique identifier for the mobile carrier if the device is connected to
         * the internet via a carrier (as opposed to via WiFi). To look up carrier
         * name from carrier ID, please refer to:
         * https://storage.googleapis.com/adx-rtb-dictionaries/mobile-carriers.csv.
         * </pre>
         *
         * <code>optional int64 carrier_id = 6 [default = 0];</code>
         * @return Whether the carrierId field is set.
         */
        @java.lang.Override
        public boolean hasCarrierId() {
          return ((bitField0_ & 0x00000020) != 0);
        }
        /**
         * <pre>
         * Unique identifier for the mobile carrier if the device is connected to
         * the internet via a carrier (as opposed to via WiFi). To look up carrier
         * name from carrier ID, please refer to:
         * https://storage.googleapis.com/adx-rtb-dictionaries/mobile-carriers.csv.
         * </pre>
         *
         * <code>optional int64 carrier_id = 6 [default = 0];</code>
         * @return The carrierId.
         */
        @java.lang.Override
        public long getCarrierId() {
          return carrierId_;
        }
        /**
         * <pre>
         * Unique identifier for the mobile carrier if the device is connected to
         * the internet via a carrier (as opposed to via WiFi). To look up carrier
         * name from carrier ID, please refer to:
         * https://storage.googleapis.com/adx-rtb-dictionaries/mobile-carriers.csv.
         * </pre>
         *
         * <code>optional int64 carrier_id = 6 [default = 0];</code>
         * @param value The carrierId to set.
         * @return This builder for chaining.
         */
        public Builder setCarrierId(long value) {
          bitField0_ |= 0x00000020;
          carrierId_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Unique identifier for the mobile carrier if the device is connected to
         * the internet via a carrier (as opposed to via WiFi). To look up carrier
         * name from carrier ID, please refer to:
         * https://storage.googleapis.com/adx-rtb-dictionaries/mobile-carriers.csv.
         * </pre>
         *
         * <code>optional int64 carrier_id = 6 [default = 0];</code>
         * @return This builder for chaining.
         */
        public Builder clearCarrierId() {
          bitField0_ = (bitField0_ & ~0x00000020);
          carrierId_ = 0L;
          onChanged();
          return this;
        }

        private int screenWidth_ ;
        /**
         * <pre>
         * The width of the device screen in pixels.
         * </pre>
         *
         * <code>optional int32 screen_width = 7 [default = 0];</code>
         * @return Whether the screenWidth field is set.
         */
        @java.lang.Override
        public boolean hasScreenWidth() {
          return ((bitField0_ & 0x00000040) != 0);
        }
        /**
         * <pre>
         * The width of the device screen in pixels.
         * </pre>
         *
         * <code>optional int32 screen_width = 7 [default = 0];</code>
         * @return The screenWidth.
         */
        @java.lang.Override
        public int getScreenWidth() {
          return screenWidth_;
        }
        /**
         * <pre>
         * The width of the device screen in pixels.
         * </pre>
         *
         * <code>optional int32 screen_width = 7 [default = 0];</code>
         * @param value The screenWidth to set.
         * @return This builder for chaining.
         */
        public Builder setScreenWidth(int value) {
          bitField0_ |= 0x00000040;
          screenWidth_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * The width of the device screen in pixels.
         * </pre>
         *
         * <code>optional int32 screen_width = 7 [default = 0];</code>
         * @return This builder for chaining.
         */
        public Builder clearScreenWidth() {
          bitField0_ = (bitField0_ & ~0x00000040);
          screenWidth_ = 0;
          onChanged();
          return this;
        }

        private int screenHeight_ ;
        /**
         * <pre>
         * The height of the device screen in pixels.
         * </pre>
         *
         * <code>optional int32 screen_height = 8 [default = 0];</code>
         * @return Whether the screenHeight field is set.
         */
        @java.lang.Override
        public boolean hasScreenHeight() {
          return ((bitField0_ & 0x00000080) != 0);
        }
        /**
         * <pre>
         * The height of the device screen in pixels.
         * </pre>
         *
         * <code>optional int32 screen_height = 8 [default = 0];</code>
         * @return The screenHeight.
         */
        @java.lang.Override
        public int getScreenHeight() {
          return screenHeight_;
        }
        /**
         * <pre>
         * The height of the device screen in pixels.
         * </pre>
         *
         * <code>optional int32 screen_height = 8 [default = 0];</code>
         * @param value The screenHeight to set.
         * @return This builder for chaining.
         */
        public Builder setScreenHeight(int value) {
          bitField0_ |= 0x00000080;
          screenHeight_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * The height of the device screen in pixels.
         * </pre>
         *
         * <code>optional int32 screen_height = 8 [default = 0];</code>
         * @return This builder for chaining.
         */
        public Builder clearScreenHeight() {
          bitField0_ = (bitField0_ & ~0x00000080);
          screenHeight_ = 0;
          onChanged();
          return this;
        }

        private int screenPixelRatioMillis_ ;
        /**
         * <pre>
         * Used for high-density devices (e.g., iOS retina displays). A non-default
         * value indicates that the nominal screen size (with pixels as the unit)
         * does not describe the actual number of pixels in the screen. For example,
         * nominal width and height may be 320x640 for a screen that actually has
         * 640x1280 pixels, in which case screen_width=320, screen_height=640, and
         * screen_pixel_ratio_millis=2000, since each axis has twice as many pixels
         * as its dimensions would indicate.
         * </pre>
         *
         * <code>optional int32 screen_pixel_ratio_millis = 9 [default = 0];</code>
         * @return Whether the screenPixelRatioMillis field is set.
         */
        @java.lang.Override
        public boolean hasScreenPixelRatioMillis() {
          return ((bitField0_ & 0x00000100) != 0);
        }
        /**
         * <pre>
         * Used for high-density devices (e.g., iOS retina displays). A non-default
         * value indicates that the nominal screen size (with pixels as the unit)
         * does not describe the actual number of pixels in the screen. For example,
         * nominal width and height may be 320x640 for a screen that actually has
         * 640x1280 pixels, in which case screen_width=320, screen_height=640, and
         * screen_pixel_ratio_millis=2000, since each axis has twice as many pixels
         * as its dimensions would indicate.
         * </pre>
         *
         * <code>optional int32 screen_pixel_ratio_millis = 9 [default = 0];</code>
         * @return The screenPixelRatioMillis.
         */
        @java.lang.Override
        public int getScreenPixelRatioMillis() {
          return screenPixelRatioMillis_;
        }
        /**
         * <pre>
         * Used for high-density devices (e.g., iOS retina displays). A non-default
         * value indicates that the nominal screen size (with pixels as the unit)
         * does not describe the actual number of pixels in the screen. For example,
         * nominal width and height may be 320x640 for a screen that actually has
         * 640x1280 pixels, in which case screen_width=320, screen_height=640, and
         * screen_pixel_ratio_millis=2000, since each axis has twice as many pixels
         * as its dimensions would indicate.
         * </pre>
         *
         * <code>optional int32 screen_pixel_ratio_millis = 9 [default = 0];</code>
         * @param value The screenPixelRatioMillis to set.
         * @return This builder for chaining.
         */
        public Builder setScreenPixelRatioMillis(int value) {
          bitField0_ |= 0x00000100;
          screenPixelRatioMillis_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Used for high-density devices (e.g., iOS retina displays). A non-default
         * value indicates that the nominal screen size (with pixels as the unit)
         * does not describe the actual number of pixels in the screen. For example,
         * nominal width and height may be 320x640 for a screen that actually has
         * 640x1280 pixels, in which case screen_width=320, screen_height=640, and
         * screen_pixel_ratio_millis=2000, since each axis has twice as many pixels
         * as its dimensions would indicate.
         * </pre>
         *
         * <code>optional int32 screen_pixel_ratio_millis = 9 [default = 0];</code>
         * @return This builder for chaining.
         */
        public Builder clearScreenPixelRatioMillis() {
          bitField0_ = (bitField0_ & ~0x00000100);
          screenPixelRatioMillis_ = 0;
          onChanged();
          return this;
        }

        private int screenOrientation_ = 0;
        /**
         * <pre>
         * The screen orientation of the device when the ad request is sent.
         * </pre>
         *
         * <code>optional .com.google.protos.adx.BidRequest.Device.ScreenOrientation screen_orientation = 10 [default = UNKNOWN_ORIENTATION];</code>
         * @return Whether the screenOrientation field is set.
         */
        @java.lang.Override public boolean hasScreenOrientation() {
          return ((bitField0_ & 0x00000200) != 0);
        }
        /**
         * <pre>
         * The screen orientation of the device when the ad request is sent.
         * </pre>
         *
         * <code>optional .com.google.protos.adx.BidRequest.Device.ScreenOrientation screen_orientation = 10 [default = UNKNOWN_ORIENTATION];</code>
         * @return The screenOrientation.
         */
        @java.lang.Override
        public com.google.protos.adx.NetworkBid.BidRequest.Device.ScreenOrientation getScreenOrientation() {
          @SuppressWarnings("deprecation")
          com.google.protos.adx.NetworkBid.BidRequest.Device.ScreenOrientation result = com.google.protos.adx.NetworkBid.BidRequest.Device.ScreenOrientation.valueOf(screenOrientation_);
          return result == null ? com.google.protos.adx.NetworkBid.BidRequest.Device.ScreenOrientation.UNKNOWN_ORIENTATION : result;
        }
        /**
         * <pre>
         * The screen orientation of the device when the ad request is sent.
         * </pre>
         *
         * <code>optional .com.google.protos.adx.BidRequest.Device.ScreenOrientation screen_orientation = 10 [default = UNKNOWN_ORIENTATION];</code>
         * @param value The screenOrientation to set.
         * @return This builder for chaining.
         */
        public Builder setScreenOrientation(com.google.protos.adx.NetworkBid.BidRequest.Device.ScreenOrientation value) {
          if (value == null) {
            throw new NullPointerException();
          }
          bitField0_ |= 0x00000200;
          screenOrientation_ = value.getNumber();
          onChanged();
          return this;
        }
        /**
         * <pre>
         * The screen orientation of the device when the ad request is sent.
         * </pre>
         *
         * <code>optional .com.google.protos.adx.BidRequest.Device.ScreenOrientation screen_orientation = 10 [default = UNKNOWN_ORIENTATION];</code>
         * @return This builder for chaining.
         */
        public Builder clearScreenOrientation() {
          bitField0_ = (bitField0_ & ~0x00000200);
          screenOrientation_ = 0;
          onChanged();
          return this;
        }

        private java.lang.Object hardwareVersion_ = "";
        /**
         * <pre>
         * Apple iOS device model, e.g., "iphone 5s", "iphone 6+", "ipad 4".
         * </pre>
         *
         * <code>optional string hardware_version = 11;</code>
         * @return Whether the hardwareVersion field is set.
         */
        public boolean hasHardwareVersion() {
          return ((bitField0_ & 0x00000400) != 0);
        }
        /**
         * <pre>
         * Apple iOS device model, e.g., "iphone 5s", "iphone 6+", "ipad 4".
         * </pre>
         *
         * <code>optional string hardware_version = 11;</code>
         * @return The hardwareVersion.
         */
        public java.lang.String getHardwareVersion() {
          java.lang.Object ref = hardwareVersion_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs =
                (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            if (bs.isValidUtf8()) {
              hardwareVersion_ = s;
            }
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         * <pre>
         * Apple iOS device model, e.g., "iphone 5s", "iphone 6+", "ipad 4".
         * </pre>
         *
         * <code>optional string hardware_version = 11;</code>
         * @return The bytes for hardwareVersion.
         */
        public com.google.protobuf.ByteString
            getHardwareVersionBytes() {
          java.lang.Object ref = hardwareVersion_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b = 
                com.google.protobuf.ByteString.copyFromUtf8(
                    (java.lang.String) ref);
            hardwareVersion_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         * <pre>
         * Apple iOS device model, e.g., "iphone 5s", "iphone 6+", "ipad 4".
         * </pre>
         *
         * <code>optional string hardware_version = 11;</code>
         * @param value The hardwareVersion to set.
         * @return This builder for chaining.
         */
        public Builder setHardwareVersion(
            java.lang.String value) {
          if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000400;
          hardwareVersion_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Apple iOS device model, e.g., "iphone 5s", "iphone 6+", "ipad 4".
         * </pre>
         *
         * <code>optional string hardware_version = 11;</code>
         * @return This builder for chaining.
         */
        public Builder clearHardwareVersion() {
          bitField0_ = (bitField0_ & ~0x00000400);
          hardwareVersion_ = getDefaultInstance().getHardwareVersion();
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Apple iOS device model, e.g., "iphone 5s", "iphone 6+", "ipad 4".
         * </pre>
         *
         * <code>optional string hardware_version = 11;</code>
         * @param value The bytes for hardwareVersion to set.
         * @return This builder for chaining.
         */
        public Builder setHardwareVersionBytes(
            com.google.protobuf.ByteString value) {
          if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000400;
          hardwareVersion_ = value;
          onChanged();
          return this;
        }

        private boolean limitAdTracking_ ;
        /**
         * <pre>
         * Indicates whether the user has opted out of interest based advertising or
         * ads personalization as determined by an OS-level setting in iOS or
         * Android:
         * https://support.apple.com/en-us/HT202074
         * https://support.google.com/googleplay/answer/3405269
         * </pre>
         *
         * <code>optional bool limit_ad_tracking = 12;</code>
         * @return Whether the limitAdTracking field is set.
         */
        @java.lang.Override
        public boolean hasLimitAdTracking() {
          return ((bitField0_ & 0x00000800) != 0);
        }
        /**
         * <pre>
         * Indicates whether the user has opted out of interest based advertising or
         * ads personalization as determined by an OS-level setting in iOS or
         * Android:
         * https://support.apple.com/en-us/HT202074
         * https://support.google.com/googleplay/answer/3405269
         * </pre>
         *
         * <code>optional bool limit_ad_tracking = 12;</code>
         * @return The limitAdTracking.
         */
        @java.lang.Override
        public boolean getLimitAdTracking() {
          return limitAdTracking_;
        }
        /**
         * <pre>
         * Indicates whether the user has opted out of interest based advertising or
         * ads personalization as determined by an OS-level setting in iOS or
         * Android:
         * https://support.apple.com/en-us/HT202074
         * https://support.google.com/googleplay/answer/3405269
         * </pre>
         *
         * <code>optional bool limit_ad_tracking = 12;</code>
         * @param value The limitAdTracking to set.
         * @return This builder for chaining.
         */
        public Builder setLimitAdTracking(boolean value) {
          bitField0_ |= 0x00000800;
          limitAdTracking_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Indicates whether the user has opted out of interest based advertising or
         * ads personalization as determined by an OS-level setting in iOS or
         * Android:
         * https://support.apple.com/en-us/HT202074
         * https://support.google.com/googleplay/answer/3405269
         * </pre>
         *
         * <code>optional bool limit_ad_tracking = 12;</code>
         * @return This builder for chaining.
         */
        public Builder clearLimitAdTracking() {
          bitField0_ = (bitField0_ & ~0x00000800);
          limitAdTracking_ = false;
          onChanged();
          return this;
        }

        private int appTrackingAuthorizationStatus_ = 0;
        /**
         * <pre>
         * This field is only populated for iOS devices. Indicates the app tracking
         * authorization status. This value is retrieved from ATTrackingManager
         * and provided as is. For more information about iOS's app tracking
         * authorization status, see:
         * https://developer.apple.com/documentation/apptrackingtransparency/attrackingmanager/authorizationstatus
         * </pre>
         *
         * <code>optional .com.google.protos.adx.BidRequest.Device.AuthorizationStatus app_tracking_authorization_status = 13;</code>
         * @return Whether the appTrackingAuthorizationStatus field is set.
         */
        @java.lang.Override public boolean hasAppTrackingAuthorizationStatus() {
          return ((bitField0_ & 0x00001000) != 0);
        }
        /**
         * <pre>
         * This field is only populated for iOS devices. Indicates the app tracking
         * authorization status. This value is retrieved from ATTrackingManager
         * and provided as is. For more information about iOS's app tracking
         * authorization status, see:
         * https://developer.apple.com/documentation/apptrackingtransparency/attrackingmanager/authorizationstatus
         * </pre>
         *
         * <code>optional .com.google.protos.adx.BidRequest.Device.AuthorizationStatus app_tracking_authorization_status = 13;</code>
         * @return The appTrackingAuthorizationStatus.
         */
        @java.lang.Override
        public com.google.protos.adx.NetworkBid.BidRequest.Device.AuthorizationStatus getAppTrackingAuthorizationStatus() {
          @SuppressWarnings("deprecation")
          com.google.protos.adx.NetworkBid.BidRequest.Device.AuthorizationStatus result = com.google.protos.adx.NetworkBid.BidRequest.Device.AuthorizationStatus.valueOf(appTrackingAuthorizationStatus_);
          return result == null ? com.google.protos.adx.NetworkBid.BidRequest.Device.AuthorizationStatus.NOT_DETERMINED : result;
        }
        /**
         * <pre>
         * This field is only populated for iOS devices. Indicates the app tracking
         * authorization status. This value is retrieved from ATTrackingManager
         * and provided as is. For more information about iOS's app tracking
         * authorization status, see:
         * https://developer.apple.com/documentation/apptrackingtransparency/attrackingmanager/authorizationstatus
         * </pre>
         *
         * <code>optional .com.google.protos.adx.BidRequest.Device.AuthorizationStatus app_tracking_authorization_status = 13;</code>
         * @param value The appTrackingAuthorizationStatus to set.
         * @return This builder for chaining.
         */
        public Builder setAppTrackingAuthorizationStatus(com.google.protos.adx.NetworkBid.BidRequest.Device.AuthorizationStatus value) {
          if (value == null) {
            throw new NullPointerException();
          }
          bitField0_ |= 0x00001000;
          appTrackingAuthorizationStatus_ = value.getNumber();
          onChanged();
          return this;
        }
        /**
         * <pre>
         * This field is only populated for iOS devices. Indicates the app tracking
         * authorization status. This value is retrieved from ATTrackingManager
         * and provided as is. For more information about iOS's app tracking
         * authorization status, see:
         * https://developer.apple.com/documentation/apptrackingtransparency/attrackingmanager/authorizationstatus
         * </pre>
         *
         * <code>optional .com.google.protos.adx.BidRequest.Device.AuthorizationStatus app_tracking_authorization_status = 13;</code>
         * @return This builder for chaining.
         */
        public Builder clearAppTrackingAuthorizationStatus() {
          bitField0_ = (bitField0_ & ~0x00001000);
          appTrackingAuthorizationStatus_ = 0;
          onChanged();
          return this;
        }
        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }


        // @@protoc_insertion_point(builder_scope:com.google.protos.adx.BidRequest.Device)
      }

      // @@protoc_insertion_point(class_scope:com.google.protos.adx.BidRequest.Device)
      private static final com.google.protos.adx.NetworkBid.BidRequest.Device DEFAULT_INSTANCE;
      static {
        DEFAULT_INSTANCE = new com.google.protos.adx.NetworkBid.BidRequest.Device();
      }

      public static com.google.protos.adx.NetworkBid.BidRequest.Device getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      @java.lang.Deprecated public static final com.google.protobuf.Parser<Device>
          PARSER = new com.google.protobuf.AbstractParser<Device>() {
        @java.lang.Override
        public Device parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new Device(input, extensionRegistry);
        }
      };

      public static com.google.protobuf.Parser<Device> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Device> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protos.adx.NetworkBid.BidRequest.Device getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }

    }

    public interface KeyValueOrBuilder extends
        // @@protoc_insertion_point(interface_extends:com.google.protos.adx.BidRequest.KeyValue)
        com.google.protobuf.MessageOrBuilder {

      /**
       * <code>optional string key = 1;</code>
       * @return Whether the key field is set.
       */
      boolean hasKey();
      /**
       * <code>optional string key = 1;</code>
       * @return The key.
       */
      java.lang.String getKey();
      /**
       * <code>optional string key = 1;</code>
       * @return The bytes for key.
       */
      com.google.protobuf.ByteString
          getKeyBytes();

      /**
       * <code>optional string value = 2;</code>
       * @return Whether the value field is set.
       */
      boolean hasValue();
      /**
       * <code>optional string value = 2;</code>
       * @return The value.
       */
      java.lang.String getValue();
      /**
       * <code>optional string value = 2;</code>
       * @return The bytes for value.
       */
      com.google.protobuf.ByteString
          getValueBytes();
    }
    /**
     * <pre>
     * Additional key-value attributes. Currently unused.
     * </pre>
     *
     * Protobuf type {@code com.google.protos.adx.BidRequest.KeyValue}
     */
    public static final class KeyValue extends
        com.google.protobuf.GeneratedMessageV3 implements
        // @@protoc_insertion_point(message_implements:com.google.protos.adx.BidRequest.KeyValue)
        KeyValueOrBuilder {
    private static final long serialVersionUID = 0L;
      // Use KeyValue.newBuilder() to construct.
      private KeyValue(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }
      private KeyValue() {
        key_ = "";
        value_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(
          UnusedPrivateParameter unused) {
        return new KeyValue();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet
      getUnknownFields() {
        return this.unknownFields;
      }
      private KeyValue(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        int mutable_bitField0_ = 0;
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                com.google.protobuf.ByteString bs = input.readBytes();
                bitField0_ |= 0x00000001;
                key_ = bs;
                break;
              }
              case 18: {
                com.google.protobuf.ByteString bs = input.readBytes();
                bitField0_ |= 0x00000002;
                value_ = bs;
                break;
              }
              default: {
                if (!parseUnknownField(
                    input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(
              e).setUnfinishedMessage(this);
        } finally {
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_KeyValue_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_KeyValue_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.protos.adx.NetworkBid.BidRequest.KeyValue.class, com.google.protos.adx.NetworkBid.BidRequest.KeyValue.Builder.class);
      }

      private int bitField0_;
      public static final int KEY_FIELD_NUMBER = 1;
      private volatile java.lang.Object key_;
      /**
       * <code>optional string key = 1;</code>
       * @return Whether the key field is set.
       */
      @java.lang.Override
      public boolean hasKey() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <code>optional string key = 1;</code>
       * @return The key.
       */
      @java.lang.Override
      public java.lang.String getKey() {
        java.lang.Object ref = key_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = 
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            key_ = s;
          }
          return s;
        }
      }
      /**
       * <code>optional string key = 1;</code>
       * @return The bytes for key.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString
          getKeyBytes() {
        java.lang.Object ref = key_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          key_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int VALUE_FIELD_NUMBER = 2;
      private volatile java.lang.Object value_;
      /**
       * <code>optional string value = 2;</code>
       * @return Whether the value field is set.
       */
      @java.lang.Override
      public boolean hasValue() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <code>optional string value = 2;</code>
       * @return The value.
       */
      @java.lang.Override
      public java.lang.String getValue() {
        java.lang.Object ref = value_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = 
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            value_ = s;
          }
          return s;
        }
      }
      /**
       * <code>optional string value = 2;</code>
       * @return The bytes for value.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString
          getValueBytes() {
        java.lang.Object ref = value_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          value_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;
      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output)
                          throws java.io.IOException {
        if (((bitField0_ & 0x00000001) != 0)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, key_);
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 2, value_);
        }
        unknownFields.writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, key_);
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, value_);
        }
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
         return true;
        }
        if (!(obj instanceof com.google.protos.adx.NetworkBid.BidRequest.KeyValue)) {
          return super.equals(obj);
        }
        com.google.protos.adx.NetworkBid.BidRequest.KeyValue other = (com.google.protos.adx.NetworkBid.BidRequest.KeyValue) obj;

        if (hasKey() != other.hasKey()) return false;
        if (hasKey()) {
          if (!getKey()
              .equals(other.getKey())) return false;
        }
        if (hasValue() != other.hasValue()) return false;
        if (hasValue()) {
          if (!getValue()
              .equals(other.getValue())) return false;
        }
        if (!unknownFields.equals(other.unknownFields)) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasKey()) {
          hash = (37 * hash) + KEY_FIELD_NUMBER;
          hash = (53 * hash) + getKey().hashCode();
        }
        if (hasValue()) {
          hash = (37 * hash) + VALUE_FIELD_NUMBER;
          hash = (53 * hash) + getValue().hashCode();
        }
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.protos.adx.NetworkBid.BidRequest.KeyValue parseFrom(
          java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.KeyValue parseFrom(
          java.nio.ByteBuffer data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.KeyValue parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.KeyValue parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.KeyValue parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.KeyValue parseFrom(
          byte[] data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.KeyValue parseFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.KeyValue parseFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.KeyValue parseDelimitedFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.KeyValue parseDelimitedFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.KeyValue parseFrom(
          com.google.protobuf.CodedInputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.KeyValue parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() { return newBuilder(); }
      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }
      public static Builder newBuilder(com.google.protos.adx.NetworkBid.BidRequest.KeyValue prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }
      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE
            ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * <pre>
       * Additional key-value attributes. Currently unused.
       * </pre>
       *
       * Protobuf type {@code com.google.protos.adx.BidRequest.KeyValue}
       */
      public static final class Builder extends
          com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
          // @@protoc_insertion_point(builder_implements:com.google.protos.adx.BidRequest.KeyValue)
          com.google.protos.adx.NetworkBid.BidRequest.KeyValueOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
          return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_KeyValue_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_KeyValue_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.protos.adx.NetworkBid.BidRequest.KeyValue.class, com.google.protos.adx.NetworkBid.BidRequest.KeyValue.Builder.class);
        }

        // Construct using com.google.protos.adx.NetworkBid.BidRequest.KeyValue.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }
        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3
                  .alwaysUseFieldBuilders) {
          }
        }
        @java.lang.Override
        public Builder clear() {
          super.clear();
          key_ = "";
          bitField0_ = (bitField0_ & ~0x00000001);
          value_ = "";
          bitField0_ = (bitField0_ & ~0x00000002);
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
          return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_KeyValue_descriptor;
        }

        @java.lang.Override
        public com.google.protos.adx.NetworkBid.BidRequest.KeyValue getDefaultInstanceForType() {
          return com.google.protos.adx.NetworkBid.BidRequest.KeyValue.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.protos.adx.NetworkBid.BidRequest.KeyValue build() {
          com.google.protos.adx.NetworkBid.BidRequest.KeyValue result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.protos.adx.NetworkBid.BidRequest.KeyValue buildPartial() {
          com.google.protos.adx.NetworkBid.BidRequest.KeyValue result = new com.google.protos.adx.NetworkBid.BidRequest.KeyValue(this);
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            to_bitField0_ |= 0x00000001;
          }
          result.key_ = key_;
          if (((from_bitField0_ & 0x00000002) != 0)) {
            to_bitField0_ |= 0x00000002;
          }
          result.value_ = value_;
          result.bitField0_ = to_bitField0_;
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }
        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.setField(field, value);
        }
        @java.lang.Override
        public Builder clearField(
            com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }
        @java.lang.Override
        public Builder clearOneof(
            com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }
        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index, java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }
        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }
        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.protos.adx.NetworkBid.BidRequest.KeyValue) {
            return mergeFrom((com.google.protos.adx.NetworkBid.BidRequest.KeyValue)other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.google.protos.adx.NetworkBid.BidRequest.KeyValue other) {
          if (other == com.google.protos.adx.NetworkBid.BidRequest.KeyValue.getDefaultInstance()) return this;
          if (other.hasKey()) {
            bitField0_ |= 0x00000001;
            key_ = other.key_;
            onChanged();
          }
          if (other.hasValue()) {
            bitField0_ |= 0x00000002;
            value_ = other.value_;
            onChanged();
          }
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          com.google.protos.adx.NetworkBid.BidRequest.KeyValue parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage = (com.google.protos.adx.NetworkBid.BidRequest.KeyValue) e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }
        private int bitField0_;

        private java.lang.Object key_ = "";
        /**
         * <code>optional string key = 1;</code>
         * @return Whether the key field is set.
         */
        public boolean hasKey() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         * <code>optional string key = 1;</code>
         * @return The key.
         */
        public java.lang.String getKey() {
          java.lang.Object ref = key_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs =
                (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            if (bs.isValidUtf8()) {
              key_ = s;
            }
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         * <code>optional string key = 1;</code>
         * @return The bytes for key.
         */
        public com.google.protobuf.ByteString
            getKeyBytes() {
          java.lang.Object ref = key_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b = 
                com.google.protobuf.ByteString.copyFromUtf8(
                    (java.lang.String) ref);
            key_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         * <code>optional string key = 1;</code>
         * @param value The key to set.
         * @return This builder for chaining.
         */
        public Builder setKey(
            java.lang.String value) {
          if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
          key_ = value;
          onChanged();
          return this;
        }
        /**
         * <code>optional string key = 1;</code>
         * @return This builder for chaining.
         */
        public Builder clearKey() {
          bitField0_ = (bitField0_ & ~0x00000001);
          key_ = getDefaultInstance().getKey();
          onChanged();
          return this;
        }
        /**
         * <code>optional string key = 1;</code>
         * @param value The bytes for key to set.
         * @return This builder for chaining.
         */
        public Builder setKeyBytes(
            com.google.protobuf.ByteString value) {
          if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
          key_ = value;
          onChanged();
          return this;
        }

        private java.lang.Object value_ = "";
        /**
         * <code>optional string value = 2;</code>
         * @return Whether the value field is set.
         */
        public boolean hasValue() {
          return ((bitField0_ & 0x00000002) != 0);
        }
        /**
         * <code>optional string value = 2;</code>
         * @return The value.
         */
        public java.lang.String getValue() {
          java.lang.Object ref = value_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs =
                (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            if (bs.isValidUtf8()) {
              value_ = s;
            }
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         * <code>optional string value = 2;</code>
         * @return The bytes for value.
         */
        public com.google.protobuf.ByteString
            getValueBytes() {
          java.lang.Object ref = value_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b = 
                com.google.protobuf.ByteString.copyFromUtf8(
                    (java.lang.String) ref);
            value_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         * <code>optional string value = 2;</code>
         * @param value The value to set.
         * @return This builder for chaining.
         */
        public Builder setValue(
            java.lang.String value) {
          if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
          value_ = value;
          onChanged();
          return this;
        }
        /**
         * <code>optional string value = 2;</code>
         * @return This builder for chaining.
         */
        public Builder clearValue() {
          bitField0_ = (bitField0_ & ~0x00000002);
          value_ = getDefaultInstance().getValue();
          onChanged();
          return this;
        }
        /**
         * <code>optional string value = 2;</code>
         * @param value The bytes for value to set.
         * @return This builder for chaining.
         */
        public Builder setValueBytes(
            com.google.protobuf.ByteString value) {
          if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
          value_ = value;
          onChanged();
          return this;
        }
        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }


        // @@protoc_insertion_point(builder_scope:com.google.protos.adx.BidRequest.KeyValue)
      }

      // @@protoc_insertion_point(class_scope:com.google.protos.adx.BidRequest.KeyValue)
      private static final com.google.protos.adx.NetworkBid.BidRequest.KeyValue DEFAULT_INSTANCE;
      static {
        DEFAULT_INSTANCE = new com.google.protos.adx.NetworkBid.BidRequest.KeyValue();
      }

      public static com.google.protos.adx.NetworkBid.BidRequest.KeyValue getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      @java.lang.Deprecated public static final com.google.protobuf.Parser<KeyValue>
          PARSER = new com.google.protobuf.AbstractParser<KeyValue>() {
        @java.lang.Override
        public KeyValue parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new KeyValue(input, extensionRegistry);
        }
      };

      public static com.google.protobuf.Parser<KeyValue> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<KeyValue> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protos.adx.NetworkBid.BidRequest.KeyValue getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }

    }

    public interface MobileOrBuilder extends
        // @@protoc_insertion_point(interface_extends:com.google.protos.adx.BidRequest.Mobile)
        com.google.protobuf.MessageOrBuilder {

      /**
       * <pre>
       * If true, then this request is from a mobile application. For branded
       * requests, app_id will also be filled in. If the request is from a mobile
       * web page contained inside an app, is_app will still be false, but app_id
       * could be filled in with the app identifier. For SDK-less requests (mostly
       * from connected TVs), this will be true if an app ID is provided directly
       * in the request.
       * </pre>
       *
       * <code>optional bool is_app = 7 [default = false];</code>
       * @return Whether the isApp field is set.
       */
      boolean hasIsApp();
      /**
       * <pre>
       * If true, then this request is from a mobile application. For branded
       * requests, app_id will also be filled in. If the request is from a mobile
       * web page contained inside an app, is_app will still be false, but app_id
       * could be filled in with the app identifier. For SDK-less requests (mostly
       * from connected TVs), this will be true if an app ID is provided directly
       * in the request.
       * </pre>
       *
       * <code>optional bool is_app = 7 [default = false];</code>
       * @return The isApp.
       */
      boolean getIsApp();

      /**
       * <pre>
       * The identifier of the mobile app when this ad query comes from a mobile
       * app, or from a mobile web page contained inside an app. If the app was
       * downloaded from the Apple iTunes app store, then this is the app-store
       * id, e.g., 343200656. For Android devices, this is the fully qualified
       * package name, e.g., com.rovio.angrybirds. For Windows devices it's the
       * App ID, e.g., f15abcde-f6gh-47i0-j3k8-37l93817mn3o. For SDK-less requests
       * (mostly from connected TVs), the app ID provided by the publisher
       * directly in the request.
       * </pre>
       *
       * <code>optional string app_id = 6;</code>
       * @return Whether the appId field is set.
       */
      boolean hasAppId();
      /**
       * <pre>
       * The identifier of the mobile app when this ad query comes from a mobile
       * app, or from a mobile web page contained inside an app. If the app was
       * downloaded from the Apple iTunes app store, then this is the app-store
       * id, e.g., 343200656. For Android devices, this is the fully qualified
       * package name, e.g., com.rovio.angrybirds. For Windows devices it's the
       * App ID, e.g., f15abcde-f6gh-47i0-j3k8-37l93817mn3o. For SDK-less requests
       * (mostly from connected TVs), the app ID provided by the publisher
       * directly in the request.
       * </pre>
       *
       * <code>optional string app_id = 6;</code>
       * @return The appId.
       */
      java.lang.String getAppId();
      /**
       * <pre>
       * The identifier of the mobile app when this ad query comes from a mobile
       * app, or from a mobile web page contained inside an app. If the app was
       * downloaded from the Apple iTunes app store, then this is the app-store
       * id, e.g., 343200656. For Android devices, this is the fully qualified
       * package name, e.g., com.rovio.angrybirds. For Windows devices it's the
       * App ID, e.g., f15abcde-f6gh-47i0-j3k8-37l93817mn3o. For SDK-less requests
       * (mostly from connected TVs), the app ID provided by the publisher
       * directly in the request.
       * </pre>
       *
       * <code>optional string app_id = 6;</code>
       * @return The bytes for appId.
       */
      com.google.protobuf.ByteString
          getAppIdBytes();

      /**
       * <pre>
       * If true, then this is a mobile full screen ad request.
       * </pre>
       *
       * <code>optional bool is_interstitial_request = 10 [default = false];</code>
       * @return Whether the isInterstitialRequest field is set.
       */
      boolean hasIsInterstitialRequest();
      /**
       * <pre>
       * If true, then this is a mobile full screen ad request.
       * </pre>
       *
       * <code>optional bool is_interstitial_request = 10 [default = false];</code>
       * @return The isInterstitialRequest.
       */
      boolean getIsInterstitialRequest();

      /**
       * <pre>
       * This field contains the IDs of categories to which the current mobile app
       * belongs. This field will be empty if is_app is false. The mapping between
       * mobile apps and categories is defined by the Google Play Store for
       * Android apps, or the Apple iTunes Store for iOS apps. To look up category
       * name from category ID, please refer to
       * https://developers.google.com/google-ads/api/reference/data/codes-formats#mobile_app_categories
       * </pre>
       *
       * <code>repeated int32 app_category_ids = 11;</code>
       * @return A list containing the appCategoryIds.
       */
      java.util.List<java.lang.Integer> getAppCategoryIdsList();
      /**
       * <pre>
       * This field contains the IDs of categories to which the current mobile app
       * belongs. This field will be empty if is_app is false. The mapping between
       * mobile apps and categories is defined by the Google Play Store for
       * Android apps, or the Apple iTunes Store for iOS apps. To look up category
       * name from category ID, please refer to
       * https://developers.google.com/google-ads/api/reference/data/codes-formats#mobile_app_categories
       * </pre>
       *
       * <code>repeated int32 app_category_ids = 11;</code>
       * @return The count of appCategoryIds.
       */
      int getAppCategoryIdsCount();
      /**
       * <pre>
       * This field contains the IDs of categories to which the current mobile app
       * belongs. This field will be empty if is_app is false. The mapping between
       * mobile apps and categories is defined by the Google Play Store for
       * Android apps, or the Apple iTunes Store for iOS apps. To look up category
       * name from category ID, please refer to
       * https://developers.google.com/google-ads/api/reference/data/codes-formats#mobile_app_categories
       * </pre>
       *
       * <code>repeated int32 app_category_ids = 11;</code>
       * @param index The index of the element to return.
       * @return The appCategoryIds at the given index.
       */
      int getAppCategoryIds(int index);

      /**
       * <pre>
       * For a mobile web request, this field indicates whether the page is
       * optimized for mobile browsers on high-end mobile phones.
       * </pre>
       *
       * <code>optional bool is_mobile_web_optimized = 17 [default = false];</code>
       * @return Whether the isMobileWebOptimized field is set.
       */
      boolean hasIsMobileWebOptimized();
      /**
       * <pre>
       * For a mobile web request, this field indicates whether the page is
       * optimized for mobile browsers on high-end mobile phones.
       * </pre>
       *
       * <code>optional bool is_mobile_web_optimized = 17 [default = false];</code>
       * @return The isMobileWebOptimized.
       */
      boolean getIsMobileWebOptimized();

      /**
       * <pre>
       * This field is used for advertising identifiers for
       * 1) iOS devices (This is called Identifier for Advertising, or IDFA, as
       * described at https://support.google.com/authorizedbuyers/answer/3221407),
       * 2) Android devices,
       * 3) Roku devices,
       * 4) Microsoft Xbox devices,
       * 5) Amazon devices (i.e. Amazon Fire).
       * When the encrypted_advertising_id is an IDFA, the plaintext after
       * decrypting the ciphertext is the IDFA (16 byte UUID) returned by iOS's
       * [ASIdentifierManager advertisingIdentifier]. For encrypted_hashed_idfa,
       * the plaintext is the 16 byte MD5 hash of the IDFA. Only one of the two
       * fields will be available, depending on the version of the SDK making the
       * request. Later SDKs provide unhashed values. They are not set if there is
       * one or more user_data_treatment value in the BidRequest.
       * </pre>
       *
       * <code>optional bytes encrypted_advertising_id = 20;</code>
       * @return Whether the encryptedAdvertisingId field is set.
       */
      boolean hasEncryptedAdvertisingId();
      /**
       * <pre>
       * This field is used for advertising identifiers for
       * 1) iOS devices (This is called Identifier for Advertising, or IDFA, as
       * described at https://support.google.com/authorizedbuyers/answer/3221407),
       * 2) Android devices,
       * 3) Roku devices,
       * 4) Microsoft Xbox devices,
       * 5) Amazon devices (i.e. Amazon Fire).
       * When the encrypted_advertising_id is an IDFA, the plaintext after
       * decrypting the ciphertext is the IDFA (16 byte UUID) returned by iOS's
       * [ASIdentifierManager advertisingIdentifier]. For encrypted_hashed_idfa,
       * the plaintext is the 16 byte MD5 hash of the IDFA. Only one of the two
       * fields will be available, depending on the version of the SDK making the
       * request. Later SDKs provide unhashed values. They are not set if there is
       * one or more user_data_treatment value in the BidRequest.
       * </pre>
       *
       * <code>optional bytes encrypted_advertising_id = 20;</code>
       * @return The encryptedAdvertisingId.
       */
      com.google.protobuf.ByteString getEncryptedAdvertisingId();

      /**
       * <pre>
       * Unencrypted version of encrypted_advertising_id. This field is only set
       * when using an SSL connection. This field is a 16 byte UUID (binary form)
       * or a 32 byte alphanumeric id (such as Samsung ID).
       * </pre>
       *
       * <code>optional bytes advertising_id = 27;</code>
       * @return Whether the advertisingId field is set.
       */
      boolean hasAdvertisingId();
      /**
       * <pre>
       * Unencrypted version of encrypted_advertising_id. This field is only set
       * when using an SSL connection. This field is a 16 byte UUID (binary form)
       * or a 32 byte alphanumeric id (such as Samsung ID).
       * </pre>
       *
       * <code>optional bytes advertising_id = 27;</code>
       * @return The advertisingId.
       */
      com.google.protobuf.ByteString getAdvertisingId();

      /**
       * <code>optional bytes encrypted_hashed_idfa = 21;</code>
       * @return Whether the encryptedHashedIdfa field is set.
       */
      boolean hasEncryptedHashedIdfa();
      /**
       * <code>optional bytes encrypted_hashed_idfa = 21;</code>
       * @return The encryptedHashedIdfa.
       */
      com.google.protobuf.ByteString getEncryptedHashedIdfa();

      /**
       * <pre>
       * Unencrypted version of encrypted_hashed_idfa. This field is only set
       * when using an SSL connection. This field is a 16 byte MD5.
       * </pre>
       *
       * <code>optional bytes hashed_idfa = 28;</code>
       * @return Whether the hashedIdfa field is set.
       */
      boolean hasHashedIdfa();
      /**
       * <pre>
       * Unencrypted version of encrypted_hashed_idfa. This field is only set
       * when using an SSL connection. This field is a 16 byte MD5.
       * </pre>
       *
       * <code>optional bytes hashed_idfa = 28;</code>
       * @return The hashedIdfa.
       */
      com.google.protobuf.ByteString getHashedIdfa();

      /**
       * <pre>
       * App names for Android apps are from the Google Play store.
       * App names for iOS apps are provided by App Annie
       * (https://www.appannie.com). App names for SDK-less requests (mostly from
       * connected TVs) are provided by the publisher directly in the request.
       * </pre>
       *
       * <code>optional string app_name = 24;</code>
       * @return Whether the appName field is set.
       */
      boolean hasAppName();
      /**
       * <pre>
       * App names for Android apps are from the Google Play store.
       * App names for iOS apps are provided by App Annie
       * (https://www.appannie.com). App names for SDK-less requests (mostly from
       * connected TVs) are provided by the publisher directly in the request.
       * </pre>
       *
       * <code>optional string app_name = 24;</code>
       * @return The appName.
       */
      java.lang.String getAppName();
      /**
       * <pre>
       * App names for Android apps are from the Google Play store.
       * App names for iOS apps are provided by App Annie
       * (https://www.appannie.com). App names for SDK-less requests (mostly from
       * connected TVs) are provided by the publisher directly in the request.
       * </pre>
       *
       * <code>optional string app_name = 24;</code>
       * @return The bytes for appName.
       */
      com.google.protobuf.ByteString
          getAppNameBytes();

      /**
       * <pre>
       * Average user rating for the app. The range of user rating is between 1.0
       * and 5.0. Currently only available for apps in Google Play store.
       * </pre>
       *
       * <code>optional float app_rating = 25;</code>
       * @return Whether the appRating field is set.
       */
      boolean hasAppRating();
      /**
       * <pre>
       * Average user rating for the app. The range of user rating is between 1.0
       * and 5.0. Currently only available for apps in Google Play store.
       * </pre>
       *
       * <code>optional float app_rating = 25;</code>
       * @return The appRating.
       */
      float getAppRating();

      /**
       * <code>repeated .com.google.protos.adx.BidRequest.Mobile.InstalledSdk installed_sdk = 32;</code>
       */
      java.util.List<com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk> 
          getInstalledSdkList();
      /**
       * <code>repeated .com.google.protos.adx.BidRequest.Mobile.InstalledSdk installed_sdk = 32;</code>
       */
      com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk getInstalledSdk(int index);
      /**
       * <code>repeated .com.google.protos.adx.BidRequest.Mobile.InstalledSdk installed_sdk = 32;</code>
       */
      int getInstalledSdkCount();
      /**
       * <code>repeated .com.google.protos.adx.BidRequest.Mobile.InstalledSdk installed_sdk = 32;</code>
       */
      java.util.List<? extends com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdkOrBuilder> 
          getInstalledSdkOrBuilderList();
      /**
       * <code>repeated .com.google.protos.adx.BidRequest.Mobile.InstalledSdk installed_sdk = 32;</code>
       */
      com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdkOrBuilder getInstalledSdkOrBuilder(
          int index);

      /**
       * <code>optional .com.google.protos.adx.BidRequest.Mobile.SKAdNetworkRequest skadn = 34;</code>
       * @return Whether the skadn field is set.
       */
      boolean hasSkadn();
      /**
       * <code>optional .com.google.protos.adx.BidRequest.Mobile.SKAdNetworkRequest skadn = 34;</code>
       * @return The skadn.
       */
      com.google.protos.adx.NetworkBid.BidRequest.Mobile.SKAdNetworkRequest getSkadn();
      /**
       * <code>optional .com.google.protos.adx.BidRequest.Mobile.SKAdNetworkRequest skadn = 34;</code>
       */
      com.google.protos.adx.NetworkBid.BidRequest.Mobile.SKAdNetworkRequestOrBuilder getSkadnOrBuilder();
    }
    /**
     * <pre>
     * Information for ad queries coming from mobile devices. A mobile device is
     * either a smartphone or a tablet. This is present for ad queries both from
     * mobile devices browsing the web and from mobile apps.
     * </pre>
     *
     * Protobuf type {@code com.google.protos.adx.BidRequest.Mobile}
     */
    public static final class Mobile extends
        com.google.protobuf.GeneratedMessageV3 implements
        // @@protoc_insertion_point(message_implements:com.google.protos.adx.BidRequest.Mobile)
        MobileOrBuilder {
    private static final long serialVersionUID = 0L;
      // Use Mobile.newBuilder() to construct.
      private Mobile(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }
      private Mobile() {
        appId_ = "";
        appCategoryIds_ = emptyIntList();
        encryptedAdvertisingId_ = com.google.protobuf.ByteString.EMPTY;
        advertisingId_ = com.google.protobuf.ByteString.EMPTY;
        encryptedHashedIdfa_ = com.google.protobuf.ByteString.EMPTY;
        hashedIdfa_ = com.google.protobuf.ByteString.EMPTY;
        appName_ = "";
        installedSdk_ = java.util.Collections.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(
          UnusedPrivateParameter unused) {
        return new Mobile();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet
      getUnknownFields() {
        return this.unknownFields;
      }
      private Mobile(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        int mutable_bitField0_ = 0;
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 50: {
                com.google.protobuf.ByteString bs = input.readBytes();
                bitField0_ |= 0x00000002;
                appId_ = bs;
                break;
              }
              case 56: {
                bitField0_ |= 0x00000001;
                isApp_ = input.readBool();
                break;
              }
              case 80: {
                bitField0_ |= 0x00000004;
                isInterstitialRequest_ = input.readBool();
                break;
              }
              case 88: {
                if (!((mutable_bitField0_ & 0x00000008) != 0)) {
                  appCategoryIds_ = newIntList();
                  mutable_bitField0_ |= 0x00000008;
                }
                appCategoryIds_.addInt(input.readInt32());
                break;
              }
              case 90: {
                int length = input.readRawVarint32();
                int limit = input.pushLimit(length);
                if (!((mutable_bitField0_ & 0x00000008) != 0) && input.getBytesUntilLimit() > 0) {
                  appCategoryIds_ = newIntList();
                  mutable_bitField0_ |= 0x00000008;
                }
                while (input.getBytesUntilLimit() > 0) {
                  appCategoryIds_.addInt(input.readInt32());
                }
                input.popLimit(limit);
                break;
              }
              case 136: {
                bitField0_ |= 0x00000008;
                isMobileWebOptimized_ = input.readBool();
                break;
              }
              case 162: {
                bitField0_ |= 0x00000010;
                encryptedAdvertisingId_ = input.readBytes();
                break;
              }
              case 170: {
                bitField0_ |= 0x00000040;
                encryptedHashedIdfa_ = input.readBytes();
                break;
              }
              case 194: {
                com.google.protobuf.ByteString bs = input.readBytes();
                bitField0_ |= 0x00000100;
                appName_ = bs;
                break;
              }
              case 205: {
                bitField0_ |= 0x00000200;
                appRating_ = input.readFloat();
                break;
              }
              case 218: {
                bitField0_ |= 0x00000020;
                advertisingId_ = input.readBytes();
                break;
              }
              case 226: {
                bitField0_ |= 0x00000080;
                hashedIdfa_ = input.readBytes();
                break;
              }
              case 258: {
                if (!((mutable_bitField0_ & 0x00000800) != 0)) {
                  installedSdk_ = new java.util.ArrayList<com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk>();
                  mutable_bitField0_ |= 0x00000800;
                }
                installedSdk_.add(
                    input.readMessage(com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.PARSER, extensionRegistry));
                break;
              }
              case 274: {
                com.google.protos.adx.NetworkBid.BidRequest.Mobile.SKAdNetworkRequest.Builder subBuilder = null;
                if (((bitField0_ & 0x00000400) != 0)) {
                  subBuilder = skadn_.toBuilder();
                }
                skadn_ = input.readMessage(com.google.protos.adx.NetworkBid.BidRequest.Mobile.SKAdNetworkRequest.PARSER, extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(skadn_);
                  skadn_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000400;
                break;
              }
              default: {
                if (!parseUnknownField(
                    input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(
              e).setUnfinishedMessage(this);
        } finally {
          if (((mutable_bitField0_ & 0x00000008) != 0)) {
            appCategoryIds_.makeImmutable(); // C
          }
          if (((mutable_bitField0_ & 0x00000800) != 0)) {
            installedSdk_ = java.util.Collections.unmodifiableList(installedSdk_);
          }
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_Mobile_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_Mobile_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.protos.adx.NetworkBid.BidRequest.Mobile.class, com.google.protos.adx.NetworkBid.BidRequest.Mobile.Builder.class);
      }

      public interface InstalledSdkOrBuilder extends
          // @@protoc_insertion_point(interface_extends:com.google.protos.adx.BidRequest.Mobile.InstalledSdk)
          com.google.protobuf.MessageOrBuilder {

        /**
         * <pre>
         * Identifier for the installed SDK.
         * </pre>
         *
         * <code>optional string id = 1;</code>
         * @return Whether the id field is set.
         */
        boolean hasId();
        /**
         * <pre>
         * Identifier for the installed SDK.
         * </pre>
         *
         * <code>optional string id = 1;</code>
         * @return The id.
         */
        java.lang.String getId();
        /**
         * <pre>
         * Identifier for the installed SDK.
         * </pre>
         *
         * <code>optional string id = 1;</code>
         * @return The bytes for id.
         */
        com.google.protobuf.ByteString
            getIdBytes();

        /**
         * <pre>
         * The version of the installed SDK.
         * </pre>
         *
         * <code>optional .com.google.protos.adx.BidRequest.Mobile.InstalledSdk.Version sdk_version = 2;</code>
         * @return Whether the sdkVersion field is set.
         */
        boolean hasSdkVersion();
        /**
         * <pre>
         * The version of the installed SDK.
         * </pre>
         *
         * <code>optional .com.google.protos.adx.BidRequest.Mobile.InstalledSdk.Version sdk_version = 2;</code>
         * @return The sdkVersion.
         */
        com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version getSdkVersion();
        /**
         * <pre>
         * The version of the installed SDK.
         * </pre>
         *
         * <code>optional .com.google.protos.adx.BidRequest.Mobile.InstalledSdk.Version sdk_version = 2;</code>
         */
        com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.VersionOrBuilder getSdkVersionOrBuilder();

        /**
         * <pre>
         * The version of the adapter that communicates with the installed SDK.
         * </pre>
         *
         * <code>optional .com.google.protos.adx.BidRequest.Mobile.InstalledSdk.Version adapter_version = 3;</code>
         * @return Whether the adapterVersion field is set.
         */
        boolean hasAdapterVersion();
        /**
         * <pre>
         * The version of the adapter that communicates with the installed SDK.
         * </pre>
         *
         * <code>optional .com.google.protos.adx.BidRequest.Mobile.InstalledSdk.Version adapter_version = 3;</code>
         * @return The adapterVersion.
         */
        com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version getAdapterVersion();
        /**
         * <pre>
         * The version of the adapter that communicates with the installed SDK.
         * </pre>
         *
         * <code>optional .com.google.protos.adx.BidRequest.Mobile.InstalledSdk.Version adapter_version = 3;</code>
         */
        com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.VersionOrBuilder getAdapterVersionOrBuilder();
      }
      /**
       * <pre>
       * Identification of and information about an SDK installed in the
       * publisher's app that the bidder has access to, often because it's the
       * bidder's SDK.
       * </pre>
       *
       * Protobuf type {@code com.google.protos.adx.BidRequest.Mobile.InstalledSdk}
       */
      public static final class InstalledSdk extends
          com.google.protobuf.GeneratedMessageV3 implements
          // @@protoc_insertion_point(message_implements:com.google.protos.adx.BidRequest.Mobile.InstalledSdk)
          InstalledSdkOrBuilder {
      private static final long serialVersionUID = 0L;
        // Use InstalledSdk.newBuilder() to construct.
        private InstalledSdk(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }
        private InstalledSdk() {
          id_ = "";
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(
            UnusedPrivateParameter unused) {
          return new InstalledSdk();
        }

        @java.lang.Override
        public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
          return this.unknownFields;
        }
        private InstalledSdk(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          this();
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          int mutable_bitField0_ = 0;
          com.google.protobuf.UnknownFieldSet.Builder unknownFields =
              com.google.protobuf.UnknownFieldSet.newBuilder();
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10: {
                  com.google.protobuf.ByteString bs = input.readBytes();
                  bitField0_ |= 0x00000001;
                  id_ = bs;
                  break;
                }
                case 18: {
                  com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version.Builder subBuilder = null;
                  if (((bitField0_ & 0x00000002) != 0)) {
                    subBuilder = sdkVersion_.toBuilder();
                  }
                  sdkVersion_ = input.readMessage(com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version.PARSER, extensionRegistry);
                  if (subBuilder != null) {
                    subBuilder.mergeFrom(sdkVersion_);
                    sdkVersion_ = subBuilder.buildPartial();
                  }
                  bitField0_ |= 0x00000002;
                  break;
                }
                case 26: {
                  com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version.Builder subBuilder = null;
                  if (((bitField0_ & 0x00000004) != 0)) {
                    subBuilder = adapterVersion_.toBuilder();
                  }
                  adapterVersion_ = input.readMessage(com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version.PARSER, extensionRegistry);
                  if (subBuilder != null) {
                    subBuilder.mergeFrom(adapterVersion_);
                    adapterVersion_ = subBuilder.buildPartial();
                  }
                  bitField0_ |= 0x00000004;
                  break;
                }
                default: {
                  if (!parseUnknownField(
                      input, unknownFields, extensionRegistry, tag)) {
                    done = true;
                  }
                  break;
                }
              }
            }
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(this);
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(
                e).setUnfinishedMessage(this);
          } finally {
            this.unknownFields = unknownFields.build();
            makeExtensionsImmutable();
          }
        }
        public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
          return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_Mobile_InstalledSdk_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_Mobile_InstalledSdk_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.class, com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Builder.class);
        }

        public interface VersionOrBuilder extends
            // @@protoc_insertion_point(interface_extends:com.google.protos.adx.BidRequest.Mobile.InstalledSdk.Version)
            com.google.protobuf.MessageOrBuilder {

          /**
           * <code>optional int32 major = 1 [default = -1];</code>
           * @return Whether the major field is set.
           */
          boolean hasMajor();
          /**
           * <code>optional int32 major = 1 [default = -1];</code>
           * @return The major.
           */
          int getMajor();

          /**
           * <code>optional int32 minor = 2 [default = -1];</code>
           * @return Whether the minor field is set.
           */
          boolean hasMinor();
          /**
           * <code>optional int32 minor = 2 [default = -1];</code>
           * @return The minor.
           */
          int getMinor();

          /**
           * <code>optional int32 micro = 3 [default = -1];</code>
           * @return Whether the micro field is set.
           */
          boolean hasMicro();
          /**
           * <code>optional int32 micro = 3 [default = -1];</code>
           * @return The micro.
           */
          int getMicro();
        }
        /**
         * <pre>
         * Semantic version of the installed SDK and the adapter that communicates
         * between the installed SDK and Google's SDK.
         * </pre>
         *
         * Protobuf type {@code com.google.protos.adx.BidRequest.Mobile.InstalledSdk.Version}
         */
        public static final class Version extends
            com.google.protobuf.GeneratedMessageV3 implements
            // @@protoc_insertion_point(message_implements:com.google.protos.adx.BidRequest.Mobile.InstalledSdk.Version)
            VersionOrBuilder {
        private static final long serialVersionUID = 0L;
          // Use Version.newBuilder() to construct.
          private Version(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
            super(builder);
          }
          private Version() {
            major_ = -1;
            minor_ = -1;
            micro_ = -1;
          }

          @java.lang.Override
          @SuppressWarnings({"unused"})
          protected java.lang.Object newInstance(
              UnusedPrivateParameter unused) {
            return new Version();
          }

          @java.lang.Override
          public final com.google.protobuf.UnknownFieldSet
          getUnknownFields() {
            return this.unknownFields;
          }
          private Version(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            this();
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            int mutable_bitField0_ = 0;
            com.google.protobuf.UnknownFieldSet.Builder unknownFields =
                com.google.protobuf.UnknownFieldSet.newBuilder();
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 8: {
                    bitField0_ |= 0x00000001;
                    major_ = input.readInt32();
                    break;
                  }
                  case 16: {
                    bitField0_ |= 0x00000002;
                    minor_ = input.readInt32();
                    break;
                  }
                  case 24: {
                    bitField0_ |= 0x00000004;
                    micro_ = input.readInt32();
                    break;
                  }
                  default: {
                    if (!parseUnknownField(
                        input, unknownFields, extensionRegistry, tag)) {
                      done = true;
                    }
                    break;
                  }
                }
              }
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(this);
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(
                  e).setUnfinishedMessage(this);
            } finally {
              this.unknownFields = unknownFields.build();
              makeExtensionsImmutable();
            }
          }
          public static final com.google.protobuf.Descriptors.Descriptor
              getDescriptor() {
            return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_Mobile_InstalledSdk_Version_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_Mobile_InstalledSdk_Version_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version.class, com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version.Builder.class);
          }

          private int bitField0_;
          public static final int MAJOR_FIELD_NUMBER = 1;
          private int major_;
          /**
           * <code>optional int32 major = 1 [default = -1];</code>
           * @return Whether the major field is set.
           */
          @java.lang.Override
          public boolean hasMajor() {
            return ((bitField0_ & 0x00000001) != 0);
          }
          /**
           * <code>optional int32 major = 1 [default = -1];</code>
           * @return The major.
           */
          @java.lang.Override
          public int getMajor() {
            return major_;
          }

          public static final int MINOR_FIELD_NUMBER = 2;
          private int minor_;
          /**
           * <code>optional int32 minor = 2 [default = -1];</code>
           * @return Whether the minor field is set.
           */
          @java.lang.Override
          public boolean hasMinor() {
            return ((bitField0_ & 0x00000002) != 0);
          }
          /**
           * <code>optional int32 minor = 2 [default = -1];</code>
           * @return The minor.
           */
          @java.lang.Override
          public int getMinor() {
            return minor_;
          }

          public static final int MICRO_FIELD_NUMBER = 3;
          private int micro_;
          /**
           * <code>optional int32 micro = 3 [default = -1];</code>
           * @return Whether the micro field is set.
           */
          @java.lang.Override
          public boolean hasMicro() {
            return ((bitField0_ & 0x00000004) != 0);
          }
          /**
           * <code>optional int32 micro = 3 [default = -1];</code>
           * @return The micro.
           */
          @java.lang.Override
          public int getMicro() {
            return micro_;
          }

          private byte memoizedIsInitialized = -1;
          @java.lang.Override
          public final boolean isInitialized() {
            byte isInitialized = memoizedIsInitialized;
            if (isInitialized == 1) return true;
            if (isInitialized == 0) return false;

            memoizedIsInitialized = 1;
            return true;
          }

          @java.lang.Override
          public void writeTo(com.google.protobuf.CodedOutputStream output)
                              throws java.io.IOException {
            if (((bitField0_ & 0x00000001) != 0)) {
              output.writeInt32(1, major_);
            }
            if (((bitField0_ & 0x00000002) != 0)) {
              output.writeInt32(2, minor_);
            }
            if (((bitField0_ & 0x00000004) != 0)) {
              output.writeInt32(3, micro_);
            }
            unknownFields.writeTo(output);
          }

          @java.lang.Override
          public int getSerializedSize() {
            int size = memoizedSize;
            if (size != -1) return size;

            size = 0;
            if (((bitField0_ & 0x00000001) != 0)) {
              size += com.google.protobuf.CodedOutputStream
                .computeInt32Size(1, major_);
            }
            if (((bitField0_ & 0x00000002) != 0)) {
              size += com.google.protobuf.CodedOutputStream
                .computeInt32Size(2, minor_);
            }
            if (((bitField0_ & 0x00000004) != 0)) {
              size += com.google.protobuf.CodedOutputStream
                .computeInt32Size(3, micro_);
            }
            size += unknownFields.getSerializedSize();
            memoizedSize = size;
            return size;
          }

          @java.lang.Override
          public boolean equals(final java.lang.Object obj) {
            if (obj == this) {
             return true;
            }
            if (!(obj instanceof com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version)) {
              return super.equals(obj);
            }
            com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version other = (com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version) obj;

            if (hasMajor() != other.hasMajor()) return false;
            if (hasMajor()) {
              if (getMajor()
                  != other.getMajor()) return false;
            }
            if (hasMinor() != other.hasMinor()) return false;
            if (hasMinor()) {
              if (getMinor()
                  != other.getMinor()) return false;
            }
            if (hasMicro() != other.hasMicro()) return false;
            if (hasMicro()) {
              if (getMicro()
                  != other.getMicro()) return false;
            }
            if (!unknownFields.equals(other.unknownFields)) return false;
            return true;
          }

          @java.lang.Override
          public int hashCode() {
            if (memoizedHashCode != 0) {
              return memoizedHashCode;
            }
            int hash = 41;
            hash = (19 * hash) + getDescriptor().hashCode();
            if (hasMajor()) {
              hash = (37 * hash) + MAJOR_FIELD_NUMBER;
              hash = (53 * hash) + getMajor();
            }
            if (hasMinor()) {
              hash = (37 * hash) + MINOR_FIELD_NUMBER;
              hash = (53 * hash) + getMinor();
            }
            if (hasMicro()) {
              hash = (37 * hash) + MICRO_FIELD_NUMBER;
              hash = (53 * hash) + getMicro();
            }
            hash = (29 * hash) + unknownFields.hashCode();
            memoizedHashCode = hash;
            return hash;
          }

          public static com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version parseFrom(
              java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
          }
          public static com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version parseFrom(
              java.nio.ByteBuffer data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
          }
          public static com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version parseFrom(
              com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
          }
          public static com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
          }
          public static com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version parseFrom(byte[] data)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
          }
          public static com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version parseFrom(
              byte[] data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
          }
          public static com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version parseFrom(java.io.InputStream input)
              throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                .parseWithIOException(PARSER, input);
          }
          public static com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                .parseWithIOException(PARSER, input, extensionRegistry);
          }
          public static com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version parseDelimitedFrom(java.io.InputStream input)
              throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                .parseDelimitedWithIOException(PARSER, input);
          }
          public static com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
          }
          public static com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version parseFrom(
              com.google.protobuf.CodedInputStream input)
              throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                .parseWithIOException(PARSER, input);
          }
          public static com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                .parseWithIOException(PARSER, input, extensionRegistry);
          }

          @java.lang.Override
          public Builder newBuilderForType() { return newBuilder(); }
          public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
          }
          public static Builder newBuilder(com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
          }
          @java.lang.Override
          public Builder toBuilder() {
            return this == DEFAULT_INSTANCE
                ? new Builder() : new Builder().mergeFrom(this);
          }

          @java.lang.Override
          protected Builder newBuilderForType(
              com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
          }
          /**
           * <pre>
           * Semantic version of the installed SDK and the adapter that communicates
           * between the installed SDK and Google's SDK.
           * </pre>
           *
           * Protobuf type {@code com.google.protos.adx.BidRequest.Mobile.InstalledSdk.Version}
           */
          public static final class Builder extends
              com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
              // @@protoc_insertion_point(builder_implements:com.google.protos.adx.BidRequest.Mobile.InstalledSdk.Version)
              com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.VersionOrBuilder {
            public static final com.google.protobuf.Descriptors.Descriptor
                getDescriptor() {
              return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_Mobile_InstalledSdk_Version_descriptor;
            }

            @java.lang.Override
            protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
                internalGetFieldAccessorTable() {
              return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_Mobile_InstalledSdk_Version_fieldAccessorTable
                  .ensureFieldAccessorsInitialized(
                      com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version.class, com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version.Builder.class);
            }

            // Construct using com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version.newBuilder()
            private Builder() {
              maybeForceBuilderInitialization();
            }

            private Builder(
                com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
              super(parent);
              maybeForceBuilderInitialization();
            }
            private void maybeForceBuilderInitialization() {
              if (com.google.protobuf.GeneratedMessageV3
                      .alwaysUseFieldBuilders) {
              }
            }
            @java.lang.Override
            public Builder clear() {
              super.clear();
              major_ = -1;
              bitField0_ = (bitField0_ & ~0x00000001);
              minor_ = -1;
              bitField0_ = (bitField0_ & ~0x00000002);
              micro_ = -1;
              bitField0_ = (bitField0_ & ~0x00000004);
              return this;
            }

            @java.lang.Override
            public com.google.protobuf.Descriptors.Descriptor
                getDescriptorForType() {
              return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_Mobile_InstalledSdk_Version_descriptor;
            }

            @java.lang.Override
            public com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version getDefaultInstanceForType() {
              return com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version.getDefaultInstance();
            }

            @java.lang.Override
            public com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version build() {
              com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version result = buildPartial();
              if (!result.isInitialized()) {
                throw newUninitializedMessageException(result);
              }
              return result;
            }

            @java.lang.Override
            public com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version buildPartial() {
              com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version result = new com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version(this);
              int from_bitField0_ = bitField0_;
              int to_bitField0_ = 0;
              if (((from_bitField0_ & 0x00000001) != 0)) {
                to_bitField0_ |= 0x00000001;
              }
              result.major_ = major_;
              if (((from_bitField0_ & 0x00000002) != 0)) {
                to_bitField0_ |= 0x00000002;
              }
              result.minor_ = minor_;
              if (((from_bitField0_ & 0x00000004) != 0)) {
                to_bitField0_ |= 0x00000004;
              }
              result.micro_ = micro_;
              result.bitField0_ = to_bitField0_;
              onBuilt();
              return result;
            }

            @java.lang.Override
            public Builder clone() {
              return super.clone();
            }
            @java.lang.Override
            public Builder setField(
                com.google.protobuf.Descriptors.FieldDescriptor field,
                java.lang.Object value) {
              return super.setField(field, value);
            }
            @java.lang.Override
            public Builder clearField(
                com.google.protobuf.Descriptors.FieldDescriptor field) {
              return super.clearField(field);
            }
            @java.lang.Override
            public Builder clearOneof(
                com.google.protobuf.Descriptors.OneofDescriptor oneof) {
              return super.clearOneof(oneof);
            }
            @java.lang.Override
            public Builder setRepeatedField(
                com.google.protobuf.Descriptors.FieldDescriptor field,
                int index, java.lang.Object value) {
              return super.setRepeatedField(field, index, value);
            }
            @java.lang.Override
            public Builder addRepeatedField(
                com.google.protobuf.Descriptors.FieldDescriptor field,
                java.lang.Object value) {
              return super.addRepeatedField(field, value);
            }
            @java.lang.Override
            public Builder mergeFrom(com.google.protobuf.Message other) {
              if (other instanceof com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version) {
                return mergeFrom((com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version)other);
              } else {
                super.mergeFrom(other);
                return this;
              }
            }

            public Builder mergeFrom(com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version other) {
              if (other == com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version.getDefaultInstance()) return this;
              if (other.hasMajor()) {
                setMajor(other.getMajor());
              }
              if (other.hasMinor()) {
                setMinor(other.getMinor());
              }
              if (other.hasMicro()) {
                setMicro(other.getMicro());
              }
              this.mergeUnknownFields(other.unknownFields);
              onChanged();
              return this;
            }

            @java.lang.Override
            public final boolean isInitialized() {
              return true;
            }

            @java.lang.Override
            public Builder mergeFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
              com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version parsedMessage = null;
              try {
                parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                parsedMessage = (com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version) e.getUnfinishedMessage();
                throw e.unwrapIOException();
              } finally {
                if (parsedMessage != null) {
                  mergeFrom(parsedMessage);
                }
              }
              return this;
            }
            private int bitField0_;

            private int major_ = -1;
            /**
             * <code>optional int32 major = 1 [default = -1];</code>
             * @return Whether the major field is set.
             */
            @java.lang.Override
            public boolean hasMajor() {
              return ((bitField0_ & 0x00000001) != 0);
            }
            /**
             * <code>optional int32 major = 1 [default = -1];</code>
             * @return The major.
             */
            @java.lang.Override
            public int getMajor() {
              return major_;
            }
            /**
             * <code>optional int32 major = 1 [default = -1];</code>
             * @param value The major to set.
             * @return This builder for chaining.
             */
            public Builder setMajor(int value) {
              bitField0_ |= 0x00000001;
              major_ = value;
              onChanged();
              return this;
            }
            /**
             * <code>optional int32 major = 1 [default = -1];</code>
             * @return This builder for chaining.
             */
            public Builder clearMajor() {
              bitField0_ = (bitField0_ & ~0x00000001);
              major_ = -1;
              onChanged();
              return this;
            }

            private int minor_ = -1;
            /**
             * <code>optional int32 minor = 2 [default = -1];</code>
             * @return Whether the minor field is set.
             */
            @java.lang.Override
            public boolean hasMinor() {
              return ((bitField0_ & 0x00000002) != 0);
            }
            /**
             * <code>optional int32 minor = 2 [default = -1];</code>
             * @return The minor.
             */
            @java.lang.Override
            public int getMinor() {
              return minor_;
            }
            /**
             * <code>optional int32 minor = 2 [default = -1];</code>
             * @param value The minor to set.
             * @return This builder for chaining.
             */
            public Builder setMinor(int value) {
              bitField0_ |= 0x00000002;
              minor_ = value;
              onChanged();
              return this;
            }
            /**
             * <code>optional int32 minor = 2 [default = -1];</code>
             * @return This builder for chaining.
             */
            public Builder clearMinor() {
              bitField0_ = (bitField0_ & ~0x00000002);
              minor_ = -1;
              onChanged();
              return this;
            }

            private int micro_ = -1;
            /**
             * <code>optional int32 micro = 3 [default = -1];</code>
             * @return Whether the micro field is set.
             */
            @java.lang.Override
            public boolean hasMicro() {
              return ((bitField0_ & 0x00000004) != 0);
            }
            /**
             * <code>optional int32 micro = 3 [default = -1];</code>
             * @return The micro.
             */
            @java.lang.Override
            public int getMicro() {
              return micro_;
            }
            /**
             * <code>optional int32 micro = 3 [default = -1];</code>
             * @param value The micro to set.
             * @return This builder for chaining.
             */
            public Builder setMicro(int value) {
              bitField0_ |= 0x00000004;
              micro_ = value;
              onChanged();
              return this;
            }
            /**
             * <code>optional int32 micro = 3 [default = -1];</code>
             * @return This builder for chaining.
             */
            public Builder clearMicro() {
              bitField0_ = (bitField0_ & ~0x00000004);
              micro_ = -1;
              onChanged();
              return this;
            }
            @java.lang.Override
            public final Builder setUnknownFields(
                final com.google.protobuf.UnknownFieldSet unknownFields) {
              return super.setUnknownFields(unknownFields);
            }

            @java.lang.Override
            public final Builder mergeUnknownFields(
                final com.google.protobuf.UnknownFieldSet unknownFields) {
              return super.mergeUnknownFields(unknownFields);
            }


            // @@protoc_insertion_point(builder_scope:com.google.protos.adx.BidRequest.Mobile.InstalledSdk.Version)
          }

          // @@protoc_insertion_point(class_scope:com.google.protos.adx.BidRequest.Mobile.InstalledSdk.Version)
          private static final com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version DEFAULT_INSTANCE;
          static {
            DEFAULT_INSTANCE = new com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version();
          }

          public static com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version getDefaultInstance() {
            return DEFAULT_INSTANCE;
          }

          @java.lang.Deprecated public static final com.google.protobuf.Parser<Version>
              PARSER = new com.google.protobuf.AbstractParser<Version>() {
            @java.lang.Override
            public Version parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              return new Version(input, extensionRegistry);
            }
          };

          public static com.google.protobuf.Parser<Version> parser() {
            return PARSER;
          }

          @java.lang.Override
          public com.google.protobuf.Parser<Version> getParserForType() {
            return PARSER;
          }

          @java.lang.Override
          public com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
          }

        }

        private int bitField0_;
        public static final int ID_FIELD_NUMBER = 1;
        private volatile java.lang.Object id_;
        /**
         * <pre>
         * Identifier for the installed SDK.
         * </pre>
         *
         * <code>optional string id = 1;</code>
         * @return Whether the id field is set.
         */
        @java.lang.Override
        public boolean hasId() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         * <pre>
         * Identifier for the installed SDK.
         * </pre>
         *
         * <code>optional string id = 1;</code>
         * @return The id.
         */
        @java.lang.Override
        public java.lang.String getId() {
          java.lang.Object ref = id_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = 
                (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            if (bs.isValidUtf8()) {
              id_ = s;
            }
            return s;
          }
        }
        /**
         * <pre>
         * Identifier for the installed SDK.
         * </pre>
         *
         * <code>optional string id = 1;</code>
         * @return The bytes for id.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString
            getIdBytes() {
          java.lang.Object ref = id_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b = 
                com.google.protobuf.ByteString.copyFromUtf8(
                    (java.lang.String) ref);
            id_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        public static final int SDK_VERSION_FIELD_NUMBER = 2;
        private com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version sdkVersion_;
        /**
         * <pre>
         * The version of the installed SDK.
         * </pre>
         *
         * <code>optional .com.google.protos.adx.BidRequest.Mobile.InstalledSdk.Version sdk_version = 2;</code>
         * @return Whether the sdkVersion field is set.
         */
        @java.lang.Override
        public boolean hasSdkVersion() {
          return ((bitField0_ & 0x00000002) != 0);
        }
        /**
         * <pre>
         * The version of the installed SDK.
         * </pre>
         *
         * <code>optional .com.google.protos.adx.BidRequest.Mobile.InstalledSdk.Version sdk_version = 2;</code>
         * @return The sdkVersion.
         */
        @java.lang.Override
        public com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version getSdkVersion() {
          return sdkVersion_ == null ? com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version.getDefaultInstance() : sdkVersion_;
        }
        /**
         * <pre>
         * The version of the installed SDK.
         * </pre>
         *
         * <code>optional .com.google.protos.adx.BidRequest.Mobile.InstalledSdk.Version sdk_version = 2;</code>
         */
        @java.lang.Override
        public com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.VersionOrBuilder getSdkVersionOrBuilder() {
          return sdkVersion_ == null ? com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version.getDefaultInstance() : sdkVersion_;
        }

        public static final int ADAPTER_VERSION_FIELD_NUMBER = 3;
        private com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version adapterVersion_;
        /**
         * <pre>
         * The version of the adapter that communicates with the installed SDK.
         * </pre>
         *
         * <code>optional .com.google.protos.adx.BidRequest.Mobile.InstalledSdk.Version adapter_version = 3;</code>
         * @return Whether the adapterVersion field is set.
         */
        @java.lang.Override
        public boolean hasAdapterVersion() {
          return ((bitField0_ & 0x00000004) != 0);
        }
        /**
         * <pre>
         * The version of the adapter that communicates with the installed SDK.
         * </pre>
         *
         * <code>optional .com.google.protos.adx.BidRequest.Mobile.InstalledSdk.Version adapter_version = 3;</code>
         * @return The adapterVersion.
         */
        @java.lang.Override
        public com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version getAdapterVersion() {
          return adapterVersion_ == null ? com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version.getDefaultInstance() : adapterVersion_;
        }
        /**
         * <pre>
         * The version of the adapter that communicates with the installed SDK.
         * </pre>
         *
         * <code>optional .com.google.protos.adx.BidRequest.Mobile.InstalledSdk.Version adapter_version = 3;</code>
         */
        @java.lang.Override
        public com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.VersionOrBuilder getAdapterVersionOrBuilder() {
          return adapterVersion_ == null ? com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version.getDefaultInstance() : adapterVersion_;
        }

        private byte memoizedIsInitialized = -1;
        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
                            throws java.io.IOException {
          if (((bitField0_ & 0x00000001) != 0)) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 1, id_);
          }
          if (((bitField0_ & 0x00000002) != 0)) {
            output.writeMessage(2, getSdkVersion());
          }
          if (((bitField0_ & 0x00000004) != 0)) {
            output.writeMessage(3, getAdapterVersion());
          }
          unknownFields.writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (((bitField0_ & 0x00000001) != 0)) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, id_);
          }
          if (((bitField0_ & 0x00000002) != 0)) {
            size += com.google.protobuf.CodedOutputStream
              .computeMessageSize(2, getSdkVersion());
          }
          if (((bitField0_ & 0x00000004) != 0)) {
            size += com.google.protobuf.CodedOutputStream
              .computeMessageSize(3, getAdapterVersion());
          }
          size += unknownFields.getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
           return true;
          }
          if (!(obj instanceof com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk)) {
            return super.equals(obj);
          }
          com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk other = (com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk) obj;

          if (hasId() != other.hasId()) return false;
          if (hasId()) {
            if (!getId()
                .equals(other.getId())) return false;
          }
          if (hasSdkVersion() != other.hasSdkVersion()) return false;
          if (hasSdkVersion()) {
            if (!getSdkVersion()
                .equals(other.getSdkVersion())) return false;
          }
          if (hasAdapterVersion() != other.hasAdapterVersion()) return false;
          if (hasAdapterVersion()) {
            if (!getAdapterVersion()
                .equals(other.getAdapterVersion())) return false;
          }
          if (!unknownFields.equals(other.unknownFields)) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          if (hasId()) {
            hash = (37 * hash) + ID_FIELD_NUMBER;
            hash = (53 * hash) + getId().hashCode();
          }
          if (hasSdkVersion()) {
            hash = (37 * hash) + SDK_VERSION_FIELD_NUMBER;
            hash = (53 * hash) + getSdkVersion().hashCode();
          }
          if (hasAdapterVersion()) {
            hash = (37 * hash) + ADAPTER_VERSION_FIELD_NUMBER;
            hash = (53 * hash) + getAdapterVersion().hashCode();
          }
          hash = (29 * hash) + unknownFields.hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk parseFrom(
            java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }
        public static com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk parseFrom(
            java.nio.ByteBuffer data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }
        public static com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk parseFrom(
            com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }
        public static com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }
        public static com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk parseFrom(byte[] data)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }
        public static com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk parseFrom(
            byte[] data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }
        public static com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk parseFrom(java.io.InputStream input)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3
              .parseWithIOException(PARSER, input);
        }
        public static com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk parseFrom(
            java.io.InputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3
              .parseWithIOException(PARSER, input, extensionRegistry);
        }
        public static com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk parseDelimitedFrom(java.io.InputStream input)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3
              .parseDelimitedWithIOException(PARSER, input);
        }
        public static com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk parseDelimitedFrom(
            java.io.InputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3
              .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
        }
        public static com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk parseFrom(
            com.google.protobuf.CodedInputStream input)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3
              .parseWithIOException(PARSER, input);
        }
        public static com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3
              .parseWithIOException(PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() { return newBuilder(); }
        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }
        public static Builder newBuilder(com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }
        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE
              ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         * <pre>
         * Identification of and information about an SDK installed in the
         * publisher's app that the bidder has access to, often because it's the
         * bidder's SDK.
         * </pre>
         *
         * Protobuf type {@code com.google.protos.adx.BidRequest.Mobile.InstalledSdk}
         */
        public static final class Builder extends
            com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
            // @@protoc_insertion_point(builder_implements:com.google.protos.adx.BidRequest.Mobile.InstalledSdk)
            com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdkOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor
              getDescriptor() {
            return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_Mobile_InstalledSdk_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_Mobile_InstalledSdk_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.class, com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Builder.class);
          }

          // Construct using com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.newBuilder()
          private Builder() {
            maybeForceBuilderInitialization();
          }

          private Builder(
              com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            maybeForceBuilderInitialization();
          }
          private void maybeForceBuilderInitialization() {
            if (com.google.protobuf.GeneratedMessageV3
                    .alwaysUseFieldBuilders) {
              getSdkVersionFieldBuilder();
              getAdapterVersionFieldBuilder();
            }
          }
          @java.lang.Override
          public Builder clear() {
            super.clear();
            id_ = "";
            bitField0_ = (bitField0_ & ~0x00000001);
            if (sdkVersionBuilder_ == null) {
              sdkVersion_ = null;
            } else {
              sdkVersionBuilder_.clear();
            }
            bitField0_ = (bitField0_ & ~0x00000002);
            if (adapterVersionBuilder_ == null) {
              adapterVersion_ = null;
            } else {
              adapterVersionBuilder_.clear();
            }
            bitField0_ = (bitField0_ & ~0x00000004);
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor
              getDescriptorForType() {
            return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_Mobile_InstalledSdk_descriptor;
          }

          @java.lang.Override
          public com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk getDefaultInstanceForType() {
            return com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.getDefaultInstance();
          }

          @java.lang.Override
          public com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk build() {
            com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk result = buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk buildPartial() {
            com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk result = new com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk(this);
            int from_bitField0_ = bitField0_;
            int to_bitField0_ = 0;
            if (((from_bitField0_ & 0x00000001) != 0)) {
              to_bitField0_ |= 0x00000001;
            }
            result.id_ = id_;
            if (((from_bitField0_ & 0x00000002) != 0)) {
              if (sdkVersionBuilder_ == null) {
                result.sdkVersion_ = sdkVersion_;
              } else {
                result.sdkVersion_ = sdkVersionBuilder_.build();
              }
              to_bitField0_ |= 0x00000002;
            }
            if (((from_bitField0_ & 0x00000004) != 0)) {
              if (adapterVersionBuilder_ == null) {
                result.adapterVersion_ = adapterVersion_;
              } else {
                result.adapterVersion_ = adapterVersionBuilder_.build();
              }
              to_bitField0_ |= 0x00000004;
            }
            result.bitField0_ = to_bitField0_;
            onBuilt();
            return result;
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }
          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              java.lang.Object value) {
            return super.setField(field, value);
          }
          @java.lang.Override
          public Builder clearField(
              com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }
          @java.lang.Override
          public Builder clearOneof(
              com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }
          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index, java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }
          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }
          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other instanceof com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk) {
              return mergeFrom((com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk)other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk other) {
            if (other == com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.getDefaultInstance()) return this;
            if (other.hasId()) {
              bitField0_ |= 0x00000001;
              id_ = other.id_;
              onChanged();
            }
            if (other.hasSdkVersion()) {
              mergeSdkVersion(other.getSdkVersion());
            }
            if (other.hasAdapterVersion()) {
              mergeAdapterVersion(other.getAdapterVersion());
            }
            this.mergeUnknownFields(other.unknownFields);
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk parsedMessage = null;
            try {
              parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              parsedMessage = (com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk) e.getUnfinishedMessage();
              throw e.unwrapIOException();
            } finally {
              if (parsedMessage != null) {
                mergeFrom(parsedMessage);
              }
            }
            return this;
          }
          private int bitField0_;

          private java.lang.Object id_ = "";
          /**
           * <pre>
           * Identifier for the installed SDK.
           * </pre>
           *
           * <code>optional string id = 1;</code>
           * @return Whether the id field is set.
           */
          public boolean hasId() {
            return ((bitField0_ & 0x00000001) != 0);
          }
          /**
           * <pre>
           * Identifier for the installed SDK.
           * </pre>
           *
           * <code>optional string id = 1;</code>
           * @return The id.
           */
          public java.lang.String getId() {
            java.lang.Object ref = id_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs =
                  (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              if (bs.isValidUtf8()) {
                id_ = s;
              }
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }
          /**
           * <pre>
           * Identifier for the installed SDK.
           * </pre>
           *
           * <code>optional string id = 1;</code>
           * @return The bytes for id.
           */
          public com.google.protobuf.ByteString
              getIdBytes() {
            java.lang.Object ref = id_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b = 
                  com.google.protobuf.ByteString.copyFromUtf8(
                      (java.lang.String) ref);
              id_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }
          /**
           * <pre>
           * Identifier for the installed SDK.
           * </pre>
           *
           * <code>optional string id = 1;</code>
           * @param value The id to set.
           * @return This builder for chaining.
           */
          public Builder setId(
              java.lang.String value) {
            if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
            id_ = value;
            onChanged();
            return this;
          }
          /**
           * <pre>
           * Identifier for the installed SDK.
           * </pre>
           *
           * <code>optional string id = 1;</code>
           * @return This builder for chaining.
           */
          public Builder clearId() {
            bitField0_ = (bitField0_ & ~0x00000001);
            id_ = getDefaultInstance().getId();
            onChanged();
            return this;
          }
          /**
           * <pre>
           * Identifier for the installed SDK.
           * </pre>
           *
           * <code>optional string id = 1;</code>
           * @param value The bytes for id to set.
           * @return This builder for chaining.
           */
          public Builder setIdBytes(
              com.google.protobuf.ByteString value) {
            if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
            id_ = value;
            onChanged();
            return this;
          }

          private com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version sdkVersion_;
          private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version, com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version.Builder, com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.VersionOrBuilder> sdkVersionBuilder_;
          /**
           * <pre>
           * The version of the installed SDK.
           * </pre>
           *
           * <code>optional .com.google.protos.adx.BidRequest.Mobile.InstalledSdk.Version sdk_version = 2;</code>
           * @return Whether the sdkVersion field is set.
           */
          public boolean hasSdkVersion() {
            return ((bitField0_ & 0x00000002) != 0);
          }
          /**
           * <pre>
           * The version of the installed SDK.
           * </pre>
           *
           * <code>optional .com.google.protos.adx.BidRequest.Mobile.InstalledSdk.Version sdk_version = 2;</code>
           * @return The sdkVersion.
           */
          public com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version getSdkVersion() {
            if (sdkVersionBuilder_ == null) {
              return sdkVersion_ == null ? com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version.getDefaultInstance() : sdkVersion_;
            } else {
              return sdkVersionBuilder_.getMessage();
            }
          }
          /**
           * <pre>
           * The version of the installed SDK.
           * </pre>
           *
           * <code>optional .com.google.protos.adx.BidRequest.Mobile.InstalledSdk.Version sdk_version = 2;</code>
           */
          public Builder setSdkVersion(com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version value) {
            if (sdkVersionBuilder_ == null) {
              if (value == null) {
                throw new NullPointerException();
              }
              sdkVersion_ = value;
              onChanged();
            } else {
              sdkVersionBuilder_.setMessage(value);
            }
            bitField0_ |= 0x00000002;
            return this;
          }
          /**
           * <pre>
           * The version of the installed SDK.
           * </pre>
           *
           * <code>optional .com.google.protos.adx.BidRequest.Mobile.InstalledSdk.Version sdk_version = 2;</code>
           */
          public Builder setSdkVersion(
              com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version.Builder builderForValue) {
            if (sdkVersionBuilder_ == null) {
              sdkVersion_ = builderForValue.build();
              onChanged();
            } else {
              sdkVersionBuilder_.setMessage(builderForValue.build());
            }
            bitField0_ |= 0x00000002;
            return this;
          }
          /**
           * <pre>
           * The version of the installed SDK.
           * </pre>
           *
           * <code>optional .com.google.protos.adx.BidRequest.Mobile.InstalledSdk.Version sdk_version = 2;</code>
           */
          public Builder mergeSdkVersion(com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version value) {
            if (sdkVersionBuilder_ == null) {
              if (((bitField0_ & 0x00000002) != 0) &&
                  sdkVersion_ != null &&
                  sdkVersion_ != com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version.getDefaultInstance()) {
                sdkVersion_ =
                  com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version.newBuilder(sdkVersion_).mergeFrom(value).buildPartial();
              } else {
                sdkVersion_ = value;
              }
              onChanged();
            } else {
              sdkVersionBuilder_.mergeFrom(value);
            }
            bitField0_ |= 0x00000002;
            return this;
          }
          /**
           * <pre>
           * The version of the installed SDK.
           * </pre>
           *
           * <code>optional .com.google.protos.adx.BidRequest.Mobile.InstalledSdk.Version sdk_version = 2;</code>
           */
          public Builder clearSdkVersion() {
            if (sdkVersionBuilder_ == null) {
              sdkVersion_ = null;
              onChanged();
            } else {
              sdkVersionBuilder_.clear();
            }
            bitField0_ = (bitField0_ & ~0x00000002);
            return this;
          }
          /**
           * <pre>
           * The version of the installed SDK.
           * </pre>
           *
           * <code>optional .com.google.protos.adx.BidRequest.Mobile.InstalledSdk.Version sdk_version = 2;</code>
           */
          public com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version.Builder getSdkVersionBuilder() {
            bitField0_ |= 0x00000002;
            onChanged();
            return getSdkVersionFieldBuilder().getBuilder();
          }
          /**
           * <pre>
           * The version of the installed SDK.
           * </pre>
           *
           * <code>optional .com.google.protos.adx.BidRequest.Mobile.InstalledSdk.Version sdk_version = 2;</code>
           */
          public com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.VersionOrBuilder getSdkVersionOrBuilder() {
            if (sdkVersionBuilder_ != null) {
              return sdkVersionBuilder_.getMessageOrBuilder();
            } else {
              return sdkVersion_ == null ?
                  com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version.getDefaultInstance() : sdkVersion_;
            }
          }
          /**
           * <pre>
           * The version of the installed SDK.
           * </pre>
           *
           * <code>optional .com.google.protos.adx.BidRequest.Mobile.InstalledSdk.Version sdk_version = 2;</code>
           */
          private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version, com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version.Builder, com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.VersionOrBuilder> 
              getSdkVersionFieldBuilder() {
            if (sdkVersionBuilder_ == null) {
              sdkVersionBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version, com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version.Builder, com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.VersionOrBuilder>(
                      getSdkVersion(),
                      getParentForChildren(),
                      isClean());
              sdkVersion_ = null;
            }
            return sdkVersionBuilder_;
          }

          private com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version adapterVersion_;
          private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version, com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version.Builder, com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.VersionOrBuilder> adapterVersionBuilder_;
          /**
           * <pre>
           * The version of the adapter that communicates with the installed SDK.
           * </pre>
           *
           * <code>optional .com.google.protos.adx.BidRequest.Mobile.InstalledSdk.Version adapter_version = 3;</code>
           * @return Whether the adapterVersion field is set.
           */
          public boolean hasAdapterVersion() {
            return ((bitField0_ & 0x00000004) != 0);
          }
          /**
           * <pre>
           * The version of the adapter that communicates with the installed SDK.
           * </pre>
           *
           * <code>optional .com.google.protos.adx.BidRequest.Mobile.InstalledSdk.Version adapter_version = 3;</code>
           * @return The adapterVersion.
           */
          public com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version getAdapterVersion() {
            if (adapterVersionBuilder_ == null) {
              return adapterVersion_ == null ? com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version.getDefaultInstance() : adapterVersion_;
            } else {
              return adapterVersionBuilder_.getMessage();
            }
          }
          /**
           * <pre>
           * The version of the adapter that communicates with the installed SDK.
           * </pre>
           *
           * <code>optional .com.google.protos.adx.BidRequest.Mobile.InstalledSdk.Version adapter_version = 3;</code>
           */
          public Builder setAdapterVersion(com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version value) {
            if (adapterVersionBuilder_ == null) {
              if (value == null) {
                throw new NullPointerException();
              }
              adapterVersion_ = value;
              onChanged();
            } else {
              adapterVersionBuilder_.setMessage(value);
            }
            bitField0_ |= 0x00000004;
            return this;
          }
          /**
           * <pre>
           * The version of the adapter that communicates with the installed SDK.
           * </pre>
           *
           * <code>optional .com.google.protos.adx.BidRequest.Mobile.InstalledSdk.Version adapter_version = 3;</code>
           */
          public Builder setAdapterVersion(
              com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version.Builder builderForValue) {
            if (adapterVersionBuilder_ == null) {
              adapterVersion_ = builderForValue.build();
              onChanged();
            } else {
              adapterVersionBuilder_.setMessage(builderForValue.build());
            }
            bitField0_ |= 0x00000004;
            return this;
          }
          /**
           * <pre>
           * The version of the adapter that communicates with the installed SDK.
           * </pre>
           *
           * <code>optional .com.google.protos.adx.BidRequest.Mobile.InstalledSdk.Version adapter_version = 3;</code>
           */
          public Builder mergeAdapterVersion(com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version value) {
            if (adapterVersionBuilder_ == null) {
              if (((bitField0_ & 0x00000004) != 0) &&
                  adapterVersion_ != null &&
                  adapterVersion_ != com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version.getDefaultInstance()) {
                adapterVersion_ =
                  com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version.newBuilder(adapterVersion_).mergeFrom(value).buildPartial();
              } else {
                adapterVersion_ = value;
              }
              onChanged();
            } else {
              adapterVersionBuilder_.mergeFrom(value);
            }
            bitField0_ |= 0x00000004;
            return this;
          }
          /**
           * <pre>
           * The version of the adapter that communicates with the installed SDK.
           * </pre>
           *
           * <code>optional .com.google.protos.adx.BidRequest.Mobile.InstalledSdk.Version adapter_version = 3;</code>
           */
          public Builder clearAdapterVersion() {
            if (adapterVersionBuilder_ == null) {
              adapterVersion_ = null;
              onChanged();
            } else {
              adapterVersionBuilder_.clear();
            }
            bitField0_ = (bitField0_ & ~0x00000004);
            return this;
          }
          /**
           * <pre>
           * The version of the adapter that communicates with the installed SDK.
           * </pre>
           *
           * <code>optional .com.google.protos.adx.BidRequest.Mobile.InstalledSdk.Version adapter_version = 3;</code>
           */
          public com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version.Builder getAdapterVersionBuilder() {
            bitField0_ |= 0x00000004;
            onChanged();
            return getAdapterVersionFieldBuilder().getBuilder();
          }
          /**
           * <pre>
           * The version of the adapter that communicates with the installed SDK.
           * </pre>
           *
           * <code>optional .com.google.protos.adx.BidRequest.Mobile.InstalledSdk.Version adapter_version = 3;</code>
           */
          public com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.VersionOrBuilder getAdapterVersionOrBuilder() {
            if (adapterVersionBuilder_ != null) {
              return adapterVersionBuilder_.getMessageOrBuilder();
            } else {
              return adapterVersion_ == null ?
                  com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version.getDefaultInstance() : adapterVersion_;
            }
          }
          /**
           * <pre>
           * The version of the adapter that communicates with the installed SDK.
           * </pre>
           *
           * <code>optional .com.google.protos.adx.BidRequest.Mobile.InstalledSdk.Version adapter_version = 3;</code>
           */
          private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version, com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version.Builder, com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.VersionOrBuilder> 
              getAdapterVersionFieldBuilder() {
            if (adapterVersionBuilder_ == null) {
              adapterVersionBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version, com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Version.Builder, com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.VersionOrBuilder>(
                      getAdapterVersion(),
                      getParentForChildren(),
                      isClean());
              adapterVersion_ = null;
            }
            return adapterVersionBuilder_;
          }
          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }


          // @@protoc_insertion_point(builder_scope:com.google.protos.adx.BidRequest.Mobile.InstalledSdk)
        }

        // @@protoc_insertion_point(class_scope:com.google.protos.adx.BidRequest.Mobile.InstalledSdk)
        private static final com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk DEFAULT_INSTANCE;
        static {
          DEFAULT_INSTANCE = new com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk();
        }

        public static com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        @java.lang.Deprecated public static final com.google.protobuf.Parser<InstalledSdk>
            PARSER = new com.google.protobuf.AbstractParser<InstalledSdk>() {
          @java.lang.Override
          public InstalledSdk parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new InstalledSdk(input, extensionRegistry);
          }
        };

        public static com.google.protobuf.Parser<InstalledSdk> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<InstalledSdk> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }

      }

      public interface SKAdNetworkRequestOrBuilder extends
          // @@protoc_insertion_point(interface_extends:com.google.protos.adx.BidRequest.Mobile.SKAdNetworkRequest)
          com.google.protobuf.MessageOrBuilder {

        /**
         * <pre>
         * Version of SKAdNetwork supported. Dependent on both the OS version
         * and the SDK version.
         * Note:  This field will be replaced by the
         * BidRequest.mobile.skadn.versions field to support a list of version
         * numbers.
         * </pre>
         *
         * <code>optional string version = 1;</code>
         * @return Whether the version field is set.
         */
        boolean hasVersion();
        /**
         * <pre>
         * Version of SKAdNetwork supported. Dependent on both the OS version
         * and the SDK version.
         * Note:  This field will be replaced by the
         * BidRequest.mobile.skadn.versions field to support a list of version
         * numbers.
         * </pre>
         *
         * <code>optional string version = 1;</code>
         * @return The version.
         */
        java.lang.String getVersion();
        /**
         * <pre>
         * Version of SKAdNetwork supported. Dependent on both the OS version
         * and the SDK version.
         * Note:  This field will be replaced by the
         * BidRequest.mobile.skadn.versions field to support a list of version
         * numbers.
         * </pre>
         *
         * <code>optional string version = 1;</code>
         * @return The bytes for version.
         */
        com.google.protobuf.ByteString
            getVersionBytes();

        /**
         * <pre>
         * List of SKAdNetwork versions supported, depending on the OS version
         * and the SDK version.
         * </pre>
         *
         * <code>repeated string versions = 4;</code>
         * @return A list containing the versions.
         */
        java.util.List<java.lang.String>
            getVersionsList();
        /**
         * <pre>
         * List of SKAdNetwork versions supported, depending on the OS version
         * and the SDK version.
         * </pre>
         *
         * <code>repeated string versions = 4;</code>
         * @return The count of versions.
         */
        int getVersionsCount();
        /**
         * <pre>
         * List of SKAdNetwork versions supported, depending on the OS version
         * and the SDK version.
         * </pre>
         *
         * <code>repeated string versions = 4;</code>
         * @param index The index of the element to return.
         * @return The versions at the given index.
         */
        java.lang.String getVersions(int index);
        /**
         * <pre>
         * List of SKAdNetwork versions supported, depending on the OS version
         * and the SDK version.
         * </pre>
         *
         * <code>repeated string versions = 4;</code>
         * @param index The index of the value to return.
         * @return The bytes of the versions at the given index.
         */
        com.google.protobuf.ByteString
            getVersionsBytes(int index);

        /**
         * <pre>
         * ID of publisher app in Apple's App Store.
         * </pre>
         *
         * <code>optional string sourceapp = 2;</code>
         * @return Whether the sourceapp field is set.
         */
        boolean hasSourceapp();
        /**
         * <pre>
         * ID of publisher app in Apple's App Store.
         * </pre>
         *
         * <code>optional string sourceapp = 2;</code>
         * @return The sourceapp.
         */
        java.lang.String getSourceapp();
        /**
         * <pre>
         * ID of publisher app in Apple's App Store.
         * </pre>
         *
         * <code>optional string sourceapp = 2;</code>
         * @return The bytes for sourceapp.
         */
        com.google.protobuf.ByteString
            getSourceappBytes();

        /**
         * <pre>
         * SKAdNetworkIdentifier entries in the publisher app's Info.plist.
         * </pre>
         *
         * <code>repeated string skadnetids = 3;</code>
         * @return A list containing the skadnetids.
         */
        java.util.List<java.lang.String>
            getSkadnetidsList();
        /**
         * <pre>
         * SKAdNetworkIdentifier entries in the publisher app's Info.plist.
         * </pre>
         *
         * <code>repeated string skadnetids = 3;</code>
         * @return The count of skadnetids.
         */
        int getSkadnetidsCount();
        /**
         * <pre>
         * SKAdNetworkIdentifier entries in the publisher app's Info.plist.
         * </pre>
         *
         * <code>repeated string skadnetids = 3;</code>
         * @param index The index of the element to return.
         * @return The skadnetids at the given index.
         */
        java.lang.String getSkadnetids(int index);
        /**
         * <pre>
         * SKAdNetworkIdentifier entries in the publisher app's Info.plist.
         * </pre>
         *
         * <code>repeated string skadnetids = 3;</code>
         * @param index The index of the value to return.
         * @return The bytes of the skadnetids at the given index.
         */
        com.google.protobuf.ByteString
            getSkadnetidsBytes(int index);

        /**
         * <pre>
         * List of fidelity types supported, depending on the SKAdNetwork API
         * version supported by the operating system and SDK as well as ad slot
         * properties.
         * </pre>
         *
         * <code>repeated .com.google.protos.adx.SKAdNetworkFidelityType supported_fidelity_types = 5 [packed = true];</code>
         * @return A list containing the supportedFidelityTypes.
         */
        java.util.List<com.google.protos.adx.NetworkBid.SKAdNetworkFidelityType> getSupportedFidelityTypesList();
        /**
         * <pre>
         * List of fidelity types supported, depending on the SKAdNetwork API
         * version supported by the operating system and SDK as well as ad slot
         * properties.
         * </pre>
         *
         * <code>repeated .com.google.protos.adx.SKAdNetworkFidelityType supported_fidelity_types = 5 [packed = true];</code>
         * @return The count of supportedFidelityTypes.
         */
        int getSupportedFidelityTypesCount();
        /**
         * <pre>
         * List of fidelity types supported, depending on the SKAdNetwork API
         * version supported by the operating system and SDK as well as ad slot
         * properties.
         * </pre>
         *
         * <code>repeated .com.google.protos.adx.SKAdNetworkFidelityType supported_fidelity_types = 5 [packed = true];</code>
         * @param index The index of the element to return.
         * @return The supportedFidelityTypes at the given index.
         */
        com.google.protos.adx.NetworkBid.SKAdNetworkFidelityType getSupportedFidelityTypes(int index);
      }
      /**
       * <pre>
       * Publisher's SKAdNetwork information to support app installation
       * attribution for iOS 14 and later. Apple's SKAdNetwork API helps
       * advertisers measure ad-driven app installation by sending a postback
       * to the ad network after a successful install. Publishers will need
       * to configure supported ad networks in their app's property list
       * (Info.plist) to allow an install to be attributed to the ad impression.
       * For more info visit:
       * https://developer.apple.com/documentation/storekit/skadnetwork
       * </pre>
       *
       * Protobuf type {@code com.google.protos.adx.BidRequest.Mobile.SKAdNetworkRequest}
       */
      public static final class SKAdNetworkRequest extends
          com.google.protobuf.GeneratedMessageV3 implements
          // @@protoc_insertion_point(message_implements:com.google.protos.adx.BidRequest.Mobile.SKAdNetworkRequest)
          SKAdNetworkRequestOrBuilder {
      private static final long serialVersionUID = 0L;
        // Use SKAdNetworkRequest.newBuilder() to construct.
        private SKAdNetworkRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }
        private SKAdNetworkRequest() {
          version_ = "";
          versions_ = com.google.protobuf.LazyStringArrayList.EMPTY;
          sourceapp_ = "";
          skadnetids_ = com.google.protobuf.LazyStringArrayList.EMPTY;
          supportedFidelityTypes_ = java.util.Collections.emptyList();
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(
            UnusedPrivateParameter unused) {
          return new SKAdNetworkRequest();
        }

        @java.lang.Override
        public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
          return this.unknownFields;
        }
        private SKAdNetworkRequest(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          this();
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          int mutable_bitField0_ = 0;
          com.google.protobuf.UnknownFieldSet.Builder unknownFields =
              com.google.protobuf.UnknownFieldSet.newBuilder();
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10: {
                  com.google.protobuf.ByteString bs = input.readBytes();
                  bitField0_ |= 0x00000001;
                  version_ = bs;
                  break;
                }
                case 18: {
                  com.google.protobuf.ByteString bs = input.readBytes();
                  bitField0_ |= 0x00000002;
                  sourceapp_ = bs;
                  break;
                }
                case 26: {
                  com.google.protobuf.ByteString bs = input.readBytes();
                  if (!((mutable_bitField0_ & 0x00000008) != 0)) {
                    skadnetids_ = new com.google.protobuf.LazyStringArrayList();
                    mutable_bitField0_ |= 0x00000008;
                  }
                  skadnetids_.add(bs);
                  break;
                }
                case 34: {
                  com.google.protobuf.ByteString bs = input.readBytes();
                  if (!((mutable_bitField0_ & 0x00000002) != 0)) {
                    versions_ = new com.google.protobuf.LazyStringArrayList();
                    mutable_bitField0_ |= 0x00000002;
                  }
                  versions_.add(bs);
                  break;
                }
                case 40: {
                  int rawValue = input.readEnum();
                  @SuppressWarnings("deprecation")
                  com.google.protos.adx.NetworkBid.SKAdNetworkFidelityType value = com.google.protos.adx.NetworkBid.SKAdNetworkFidelityType.valueOf(rawValue);
                  if (value == null) {
                    unknownFields.mergeVarintField(5, rawValue);
                  } else {
                    if (!((mutable_bitField0_ & 0x00000010) != 0)) {
                      supportedFidelityTypes_ = new java.util.ArrayList<java.lang.Integer>();
                      mutable_bitField0_ |= 0x00000010;
                    }
                    supportedFidelityTypes_.add(rawValue);
                  }
                  break;
                }
                case 42: {
                  int length = input.readRawVarint32();
                  int oldLimit = input.pushLimit(length);
                  while(input.getBytesUntilLimit() > 0) {
                    int rawValue = input.readEnum();
                    @SuppressWarnings("deprecation")
                    com.google.protos.adx.NetworkBid.SKAdNetworkFidelityType value = com.google.protos.adx.NetworkBid.SKAdNetworkFidelityType.valueOf(rawValue);
                    if (value == null) {
                      unknownFields.mergeVarintField(5, rawValue);
                    } else {
                      if (!((mutable_bitField0_ & 0x00000010) != 0)) {
                        supportedFidelityTypes_ = new java.util.ArrayList<java.lang.Integer>();
                        mutable_bitField0_ |= 0x00000010;
                      }
                      supportedFidelityTypes_.add(rawValue);
                    }
                  }
                  input.popLimit(oldLimit);
                  break;
                }
                default: {
                  if (!parseUnknownField(
                      input, unknownFields, extensionRegistry, tag)) {
                    done = true;
                  }
                  break;
                }
              }
            }
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(this);
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(
                e).setUnfinishedMessage(this);
          } finally {
            if (((mutable_bitField0_ & 0x00000008) != 0)) {
              skadnetids_ = skadnetids_.getUnmodifiableView();
            }
            if (((mutable_bitField0_ & 0x00000002) != 0)) {
              versions_ = versions_.getUnmodifiableView();
            }
            if (((mutable_bitField0_ & 0x00000010) != 0)) {
              supportedFidelityTypes_ = java.util.Collections.unmodifiableList(supportedFidelityTypes_);
            }
            this.unknownFields = unknownFields.build();
            makeExtensionsImmutable();
          }
        }
        public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
          return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_Mobile_SKAdNetworkRequest_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_Mobile_SKAdNetworkRequest_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.protos.adx.NetworkBid.BidRequest.Mobile.SKAdNetworkRequest.class, com.google.protos.adx.NetworkBid.BidRequest.Mobile.SKAdNetworkRequest.Builder.class);
        }

        private int bitField0_;
        public static final int VERSION_FIELD_NUMBER = 1;
        private volatile java.lang.Object version_;
        /**
         * <pre>
         * Version of SKAdNetwork supported. Dependent on both the OS version
         * and the SDK version.
         * Note:  This field will be replaced by the
         * BidRequest.mobile.skadn.versions field to support a list of version
         * numbers.
         * </pre>
         *
         * <code>optional string version = 1;</code>
         * @return Whether the version field is set.
         */
        @java.lang.Override
        public boolean hasVersion() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         * <pre>
         * Version of SKAdNetwork supported. Dependent on both the OS version
         * and the SDK version.
         * Note:  This field will be replaced by the
         * BidRequest.mobile.skadn.versions field to support a list of version
         * numbers.
         * </pre>
         *
         * <code>optional string version = 1;</code>
         * @return The version.
         */
        @java.lang.Override
        public java.lang.String getVersion() {
          java.lang.Object ref = version_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = 
                (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            if (bs.isValidUtf8()) {
              version_ = s;
            }
            return s;
          }
        }
        /**
         * <pre>
         * Version of SKAdNetwork supported. Dependent on both the OS version
         * and the SDK version.
         * Note:  This field will be replaced by the
         * BidRequest.mobile.skadn.versions field to support a list of version
         * numbers.
         * </pre>
         *
         * <code>optional string version = 1;</code>
         * @return The bytes for version.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString
            getVersionBytes() {
          java.lang.Object ref = version_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b = 
                com.google.protobuf.ByteString.copyFromUtf8(
                    (java.lang.String) ref);
            version_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        public static final int VERSIONS_FIELD_NUMBER = 4;
        private com.google.protobuf.LazyStringList versions_;
        /**
         * <pre>
         * List of SKAdNetwork versions supported, depending on the OS version
         * and the SDK version.
         * </pre>
         *
         * <code>repeated string versions = 4;</code>
         * @return A list containing the versions.
         */
        public com.google.protobuf.ProtocolStringList
            getVersionsList() {
          return versions_;
        }
        /**
         * <pre>
         * List of SKAdNetwork versions supported, depending on the OS version
         * and the SDK version.
         * </pre>
         *
         * <code>repeated string versions = 4;</code>
         * @return The count of versions.
         */
        public int getVersionsCount() {
          return versions_.size();
        }
        /**
         * <pre>
         * List of SKAdNetwork versions supported, depending on the OS version
         * and the SDK version.
         * </pre>
         *
         * <code>repeated string versions = 4;</code>
         * @param index The index of the element to return.
         * @return The versions at the given index.
         */
        public java.lang.String getVersions(int index) {
          return versions_.get(index);
        }
        /**
         * <pre>
         * List of SKAdNetwork versions supported, depending on the OS version
         * and the SDK version.
         * </pre>
         *
         * <code>repeated string versions = 4;</code>
         * @param index The index of the value to return.
         * @return The bytes of the versions at the given index.
         */
        public com.google.protobuf.ByteString
            getVersionsBytes(int index) {
          return versions_.getByteString(index);
        }

        public static final int SOURCEAPP_FIELD_NUMBER = 2;
        private volatile java.lang.Object sourceapp_;
        /**
         * <pre>
         * ID of publisher app in Apple's App Store.
         * </pre>
         *
         * <code>optional string sourceapp = 2;</code>
         * @return Whether the sourceapp field is set.
         */
        @java.lang.Override
        public boolean hasSourceapp() {
          return ((bitField0_ & 0x00000002) != 0);
        }
        /**
         * <pre>
         * ID of publisher app in Apple's App Store.
         * </pre>
         *
         * <code>optional string sourceapp = 2;</code>
         * @return The sourceapp.
         */
        @java.lang.Override
        public java.lang.String getSourceapp() {
          java.lang.Object ref = sourceapp_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = 
                (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            if (bs.isValidUtf8()) {
              sourceapp_ = s;
            }
            return s;
          }
        }
        /**
         * <pre>
         * ID of publisher app in Apple's App Store.
         * </pre>
         *
         * <code>optional string sourceapp = 2;</code>
         * @return The bytes for sourceapp.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString
            getSourceappBytes() {
          java.lang.Object ref = sourceapp_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b = 
                com.google.protobuf.ByteString.copyFromUtf8(
                    (java.lang.String) ref);
            sourceapp_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        public static final int SKADNETIDS_FIELD_NUMBER = 3;
        private com.google.protobuf.LazyStringList skadnetids_;
        /**
         * <pre>
         * SKAdNetworkIdentifier entries in the publisher app's Info.plist.
         * </pre>
         *
         * <code>repeated string skadnetids = 3;</code>
         * @return A list containing the skadnetids.
         */
        public com.google.protobuf.ProtocolStringList
            getSkadnetidsList() {
          return skadnetids_;
        }
        /**
         * <pre>
         * SKAdNetworkIdentifier entries in the publisher app's Info.plist.
         * </pre>
         *
         * <code>repeated string skadnetids = 3;</code>
         * @return The count of skadnetids.
         */
        public int getSkadnetidsCount() {
          return skadnetids_.size();
        }
        /**
         * <pre>
         * SKAdNetworkIdentifier entries in the publisher app's Info.plist.
         * </pre>
         *
         * <code>repeated string skadnetids = 3;</code>
         * @param index The index of the element to return.
         * @return The skadnetids at the given index.
         */
        public java.lang.String getSkadnetids(int index) {
          return skadnetids_.get(index);
        }
        /**
         * <pre>
         * SKAdNetworkIdentifier entries in the publisher app's Info.plist.
         * </pre>
         *
         * <code>repeated string skadnetids = 3;</code>
         * @param index The index of the value to return.
         * @return The bytes of the skadnetids at the given index.
         */
        public com.google.protobuf.ByteString
            getSkadnetidsBytes(int index) {
          return skadnetids_.getByteString(index);
        }

        public static final int SUPPORTED_FIDELITY_TYPES_FIELD_NUMBER = 5;
        private java.util.List<java.lang.Integer> supportedFidelityTypes_;
        private static final com.google.protobuf.Internal.ListAdapter.Converter<
            java.lang.Integer, com.google.protos.adx.NetworkBid.SKAdNetworkFidelityType> supportedFidelityTypes_converter_ =
                new com.google.protobuf.Internal.ListAdapter.Converter<
                    java.lang.Integer, com.google.protos.adx.NetworkBid.SKAdNetworkFidelityType>() {
                  public com.google.protos.adx.NetworkBid.SKAdNetworkFidelityType convert(java.lang.Integer from) {
                    @SuppressWarnings("deprecation")
                    com.google.protos.adx.NetworkBid.SKAdNetworkFidelityType result = com.google.protos.adx.NetworkBid.SKAdNetworkFidelityType.valueOf(from);
                    return result == null ? com.google.protos.adx.NetworkBid.SKAdNetworkFidelityType.VIEW_THROUGH_ADS : result;
                  }
                };
        /**
         * <pre>
         * List of fidelity types supported, depending on the SKAdNetwork API
         * version supported by the operating system and SDK as well as ad slot
         * properties.
         * </pre>
         *
         * <code>repeated .com.google.protos.adx.SKAdNetworkFidelityType supported_fidelity_types = 5 [packed = true];</code>
         * @return A list containing the supportedFidelityTypes.
         */
        @java.lang.Override
        public java.util.List<com.google.protos.adx.NetworkBid.SKAdNetworkFidelityType> getSupportedFidelityTypesList() {
          return new com.google.protobuf.Internal.ListAdapter<
              java.lang.Integer, com.google.protos.adx.NetworkBid.SKAdNetworkFidelityType>(supportedFidelityTypes_, supportedFidelityTypes_converter_);
        }
        /**
         * <pre>
         * List of fidelity types supported, depending on the SKAdNetwork API
         * version supported by the operating system and SDK as well as ad slot
         * properties.
         * </pre>
         *
         * <code>repeated .com.google.protos.adx.SKAdNetworkFidelityType supported_fidelity_types = 5 [packed = true];</code>
         * @return The count of supportedFidelityTypes.
         */
        @java.lang.Override
        public int getSupportedFidelityTypesCount() {
          return supportedFidelityTypes_.size();
        }
        /**
         * <pre>
         * List of fidelity types supported, depending on the SKAdNetwork API
         * version supported by the operating system and SDK as well as ad slot
         * properties.
         * </pre>
         *
         * <code>repeated .com.google.protos.adx.SKAdNetworkFidelityType supported_fidelity_types = 5 [packed = true];</code>
         * @param index The index of the element to return.
         * @return The supportedFidelityTypes at the given index.
         */
        @java.lang.Override
        public com.google.protos.adx.NetworkBid.SKAdNetworkFidelityType getSupportedFidelityTypes(int index) {
          return supportedFidelityTypes_converter_.convert(supportedFidelityTypes_.get(index));
        }
        private int supportedFidelityTypesMemoizedSerializedSize;

        private byte memoizedIsInitialized = -1;
        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
                            throws java.io.IOException {
          getSerializedSize();
          if (((bitField0_ & 0x00000001) != 0)) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 1, version_);
          }
          if (((bitField0_ & 0x00000002) != 0)) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 2, sourceapp_);
          }
          for (int i = 0; i < skadnetids_.size(); i++) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 3, skadnetids_.getRaw(i));
          }
          for (int i = 0; i < versions_.size(); i++) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 4, versions_.getRaw(i));
          }
          if (getSupportedFidelityTypesList().size() > 0) {
            output.writeUInt32NoTag(42);
            output.writeUInt32NoTag(supportedFidelityTypesMemoizedSerializedSize);
          }
          for (int i = 0; i < supportedFidelityTypes_.size(); i++) {
            output.writeEnumNoTag(supportedFidelityTypes_.get(i));
          }
          unknownFields.writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (((bitField0_ & 0x00000001) != 0)) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, version_);
          }
          if (((bitField0_ & 0x00000002) != 0)) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, sourceapp_);
          }
          {
            int dataSize = 0;
            for (int i = 0; i < skadnetids_.size(); i++) {
              dataSize += computeStringSizeNoTag(skadnetids_.getRaw(i));
            }
            size += dataSize;
            size += 1 * getSkadnetidsList().size();
          }
          {
            int dataSize = 0;
            for (int i = 0; i < versions_.size(); i++) {
              dataSize += computeStringSizeNoTag(versions_.getRaw(i));
            }
            size += dataSize;
            size += 1 * getVersionsList().size();
          }
          {
            int dataSize = 0;
            for (int i = 0; i < supportedFidelityTypes_.size(); i++) {
              dataSize += com.google.protobuf.CodedOutputStream
                .computeEnumSizeNoTag(supportedFidelityTypes_.get(i));
            }
            size += dataSize;
            if (!getSupportedFidelityTypesList().isEmpty()) {  size += 1;
              size += com.google.protobuf.CodedOutputStream
                .computeUInt32SizeNoTag(dataSize);
            }supportedFidelityTypesMemoizedSerializedSize = dataSize;
          }
          size += unknownFields.getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
           return true;
          }
          if (!(obj instanceof com.google.protos.adx.NetworkBid.BidRequest.Mobile.SKAdNetworkRequest)) {
            return super.equals(obj);
          }
          com.google.protos.adx.NetworkBid.BidRequest.Mobile.SKAdNetworkRequest other = (com.google.protos.adx.NetworkBid.BidRequest.Mobile.SKAdNetworkRequest) obj;

          if (hasVersion() != other.hasVersion()) return false;
          if (hasVersion()) {
            if (!getVersion()
                .equals(other.getVersion())) return false;
          }
          if (!getVersionsList()
              .equals(other.getVersionsList())) return false;
          if (hasSourceapp() != other.hasSourceapp()) return false;
          if (hasSourceapp()) {
            if (!getSourceapp()
                .equals(other.getSourceapp())) return false;
          }
          if (!getSkadnetidsList()
              .equals(other.getSkadnetidsList())) return false;
          if (!supportedFidelityTypes_.equals(other.supportedFidelityTypes_)) return false;
          if (!unknownFields.equals(other.unknownFields)) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          if (hasVersion()) {
            hash = (37 * hash) + VERSION_FIELD_NUMBER;
            hash = (53 * hash) + getVersion().hashCode();
          }
          if (getVersionsCount() > 0) {
            hash = (37 * hash) + VERSIONS_FIELD_NUMBER;
            hash = (53 * hash) + getVersionsList().hashCode();
          }
          if (hasSourceapp()) {
            hash = (37 * hash) + SOURCEAPP_FIELD_NUMBER;
            hash = (53 * hash) + getSourceapp().hashCode();
          }
          if (getSkadnetidsCount() > 0) {
            hash = (37 * hash) + SKADNETIDS_FIELD_NUMBER;
            hash = (53 * hash) + getSkadnetidsList().hashCode();
          }
          if (getSupportedFidelityTypesCount() > 0) {
            hash = (37 * hash) + SUPPORTED_FIDELITY_TYPES_FIELD_NUMBER;
            hash = (53 * hash) + supportedFidelityTypes_.hashCode();
          }
          hash = (29 * hash) + unknownFields.hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.protos.adx.NetworkBid.BidRequest.Mobile.SKAdNetworkRequest parseFrom(
            java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }
        public static com.google.protos.adx.NetworkBid.BidRequest.Mobile.SKAdNetworkRequest parseFrom(
            java.nio.ByteBuffer data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }
        public static com.google.protos.adx.NetworkBid.BidRequest.Mobile.SKAdNetworkRequest parseFrom(
            com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }
        public static com.google.protos.adx.NetworkBid.BidRequest.Mobile.SKAdNetworkRequest parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }
        public static com.google.protos.adx.NetworkBid.BidRequest.Mobile.SKAdNetworkRequest parseFrom(byte[] data)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }
        public static com.google.protos.adx.NetworkBid.BidRequest.Mobile.SKAdNetworkRequest parseFrom(
            byte[] data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }
        public static com.google.protos.adx.NetworkBid.BidRequest.Mobile.SKAdNetworkRequest parseFrom(java.io.InputStream input)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3
              .parseWithIOException(PARSER, input);
        }
        public static com.google.protos.adx.NetworkBid.BidRequest.Mobile.SKAdNetworkRequest parseFrom(
            java.io.InputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3
              .parseWithIOException(PARSER, input, extensionRegistry);
        }
        public static com.google.protos.adx.NetworkBid.BidRequest.Mobile.SKAdNetworkRequest parseDelimitedFrom(java.io.InputStream input)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3
              .parseDelimitedWithIOException(PARSER, input);
        }
        public static com.google.protos.adx.NetworkBid.BidRequest.Mobile.SKAdNetworkRequest parseDelimitedFrom(
            java.io.InputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3
              .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
        }
        public static com.google.protos.adx.NetworkBid.BidRequest.Mobile.SKAdNetworkRequest parseFrom(
            com.google.protobuf.CodedInputStream input)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3
              .parseWithIOException(PARSER, input);
        }
        public static com.google.protos.adx.NetworkBid.BidRequest.Mobile.SKAdNetworkRequest parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3
              .parseWithIOException(PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() { return newBuilder(); }
        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }
        public static Builder newBuilder(com.google.protos.adx.NetworkBid.BidRequest.Mobile.SKAdNetworkRequest prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }
        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE
              ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         * <pre>
         * Publisher's SKAdNetwork information to support app installation
         * attribution for iOS 14 and later. Apple's SKAdNetwork API helps
         * advertisers measure ad-driven app installation by sending a postback
         * to the ad network after a successful install. Publishers will need
         * to configure supported ad networks in their app's property list
         * (Info.plist) to allow an install to be attributed to the ad impression.
         * For more info visit:
         * https://developer.apple.com/documentation/storekit/skadnetwork
         * </pre>
         *
         * Protobuf type {@code com.google.protos.adx.BidRequest.Mobile.SKAdNetworkRequest}
         */
        public static final class Builder extends
            com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
            // @@protoc_insertion_point(builder_implements:com.google.protos.adx.BidRequest.Mobile.SKAdNetworkRequest)
            com.google.protos.adx.NetworkBid.BidRequest.Mobile.SKAdNetworkRequestOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor
              getDescriptor() {
            return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_Mobile_SKAdNetworkRequest_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_Mobile_SKAdNetworkRequest_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.protos.adx.NetworkBid.BidRequest.Mobile.SKAdNetworkRequest.class, com.google.protos.adx.NetworkBid.BidRequest.Mobile.SKAdNetworkRequest.Builder.class);
          }

          // Construct using com.google.protos.adx.NetworkBid.BidRequest.Mobile.SKAdNetworkRequest.newBuilder()
          private Builder() {
            maybeForceBuilderInitialization();
          }

          private Builder(
              com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            maybeForceBuilderInitialization();
          }
          private void maybeForceBuilderInitialization() {
            if (com.google.protobuf.GeneratedMessageV3
                    .alwaysUseFieldBuilders) {
            }
          }
          @java.lang.Override
          public Builder clear() {
            super.clear();
            version_ = "";
            bitField0_ = (bitField0_ & ~0x00000001);
            versions_ = com.google.protobuf.LazyStringArrayList.EMPTY;
            bitField0_ = (bitField0_ & ~0x00000002);
            sourceapp_ = "";
            bitField0_ = (bitField0_ & ~0x00000004);
            skadnetids_ = com.google.protobuf.LazyStringArrayList.EMPTY;
            bitField0_ = (bitField0_ & ~0x00000008);
            supportedFidelityTypes_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000010);
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor
              getDescriptorForType() {
            return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_Mobile_SKAdNetworkRequest_descriptor;
          }

          @java.lang.Override
          public com.google.protos.adx.NetworkBid.BidRequest.Mobile.SKAdNetworkRequest getDefaultInstanceForType() {
            return com.google.protos.adx.NetworkBid.BidRequest.Mobile.SKAdNetworkRequest.getDefaultInstance();
          }

          @java.lang.Override
          public com.google.protos.adx.NetworkBid.BidRequest.Mobile.SKAdNetworkRequest build() {
            com.google.protos.adx.NetworkBid.BidRequest.Mobile.SKAdNetworkRequest result = buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.protos.adx.NetworkBid.BidRequest.Mobile.SKAdNetworkRequest buildPartial() {
            com.google.protos.adx.NetworkBid.BidRequest.Mobile.SKAdNetworkRequest result = new com.google.protos.adx.NetworkBid.BidRequest.Mobile.SKAdNetworkRequest(this);
            int from_bitField0_ = bitField0_;
            int to_bitField0_ = 0;
            if (((from_bitField0_ & 0x00000001) != 0)) {
              to_bitField0_ |= 0x00000001;
            }
            result.version_ = version_;
            if (((bitField0_ & 0x00000002) != 0)) {
              versions_ = versions_.getUnmodifiableView();
              bitField0_ = (bitField0_ & ~0x00000002);
            }
            result.versions_ = versions_;
            if (((from_bitField0_ & 0x00000004) != 0)) {
              to_bitField0_ |= 0x00000002;
            }
            result.sourceapp_ = sourceapp_;
            if (((bitField0_ & 0x00000008) != 0)) {
              skadnetids_ = skadnetids_.getUnmodifiableView();
              bitField0_ = (bitField0_ & ~0x00000008);
            }
            result.skadnetids_ = skadnetids_;
            if (((bitField0_ & 0x00000010) != 0)) {
              supportedFidelityTypes_ = java.util.Collections.unmodifiableList(supportedFidelityTypes_);
              bitField0_ = (bitField0_ & ~0x00000010);
            }
            result.supportedFidelityTypes_ = supportedFidelityTypes_;
            result.bitField0_ = to_bitField0_;
            onBuilt();
            return result;
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }
          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              java.lang.Object value) {
            return super.setField(field, value);
          }
          @java.lang.Override
          public Builder clearField(
              com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }
          @java.lang.Override
          public Builder clearOneof(
              com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }
          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index, java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }
          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }
          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other instanceof com.google.protos.adx.NetworkBid.BidRequest.Mobile.SKAdNetworkRequest) {
              return mergeFrom((com.google.protos.adx.NetworkBid.BidRequest.Mobile.SKAdNetworkRequest)other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(com.google.protos.adx.NetworkBid.BidRequest.Mobile.SKAdNetworkRequest other) {
            if (other == com.google.protos.adx.NetworkBid.BidRequest.Mobile.SKAdNetworkRequest.getDefaultInstance()) return this;
            if (other.hasVersion()) {
              bitField0_ |= 0x00000001;
              version_ = other.version_;
              onChanged();
            }
            if (!other.versions_.isEmpty()) {
              if (versions_.isEmpty()) {
                versions_ = other.versions_;
                bitField0_ = (bitField0_ & ~0x00000002);
              } else {
                ensureVersionsIsMutable();
                versions_.addAll(other.versions_);
              }
              onChanged();
            }
            if (other.hasSourceapp()) {
              bitField0_ |= 0x00000004;
              sourceapp_ = other.sourceapp_;
              onChanged();
            }
            if (!other.skadnetids_.isEmpty()) {
              if (skadnetids_.isEmpty()) {
                skadnetids_ = other.skadnetids_;
                bitField0_ = (bitField0_ & ~0x00000008);
              } else {
                ensureSkadnetidsIsMutable();
                skadnetids_.addAll(other.skadnetids_);
              }
              onChanged();
            }
            if (!other.supportedFidelityTypes_.isEmpty()) {
              if (supportedFidelityTypes_.isEmpty()) {
                supportedFidelityTypes_ = other.supportedFidelityTypes_;
                bitField0_ = (bitField0_ & ~0x00000010);
              } else {
                ensureSupportedFidelityTypesIsMutable();
                supportedFidelityTypes_.addAll(other.supportedFidelityTypes_);
              }
              onChanged();
            }
            this.mergeUnknownFields(other.unknownFields);
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            com.google.protos.adx.NetworkBid.BidRequest.Mobile.SKAdNetworkRequest parsedMessage = null;
            try {
              parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              parsedMessage = (com.google.protos.adx.NetworkBid.BidRequest.Mobile.SKAdNetworkRequest) e.getUnfinishedMessage();
              throw e.unwrapIOException();
            } finally {
              if (parsedMessage != null) {
                mergeFrom(parsedMessage);
              }
            }
            return this;
          }
          private int bitField0_;

          private java.lang.Object version_ = "";
          /**
           * <pre>
           * Version of SKAdNetwork supported. Dependent on both the OS version
           * and the SDK version.
           * Note:  This field will be replaced by the
           * BidRequest.mobile.skadn.versions field to support a list of version
           * numbers.
           * </pre>
           *
           * <code>optional string version = 1;</code>
           * @return Whether the version field is set.
           */
          public boolean hasVersion() {
            return ((bitField0_ & 0x00000001) != 0);
          }
          /**
           * <pre>
           * Version of SKAdNetwork supported. Dependent on both the OS version
           * and the SDK version.
           * Note:  This field will be replaced by the
           * BidRequest.mobile.skadn.versions field to support a list of version
           * numbers.
           * </pre>
           *
           * <code>optional string version = 1;</code>
           * @return The version.
           */
          public java.lang.String getVersion() {
            java.lang.Object ref = version_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs =
                  (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              if (bs.isValidUtf8()) {
                version_ = s;
              }
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }
          /**
           * <pre>
           * Version of SKAdNetwork supported. Dependent on both the OS version
           * and the SDK version.
           * Note:  This field will be replaced by the
           * BidRequest.mobile.skadn.versions field to support a list of version
           * numbers.
           * </pre>
           *
           * <code>optional string version = 1;</code>
           * @return The bytes for version.
           */
          public com.google.protobuf.ByteString
              getVersionBytes() {
            java.lang.Object ref = version_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b = 
                  com.google.protobuf.ByteString.copyFromUtf8(
                      (java.lang.String) ref);
              version_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }
          /**
           * <pre>
           * Version of SKAdNetwork supported. Dependent on both the OS version
           * and the SDK version.
           * Note:  This field will be replaced by the
           * BidRequest.mobile.skadn.versions field to support a list of version
           * numbers.
           * </pre>
           *
           * <code>optional string version = 1;</code>
           * @param value The version to set.
           * @return This builder for chaining.
           */
          public Builder setVersion(
              java.lang.String value) {
            if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
            version_ = value;
            onChanged();
            return this;
          }
          /**
           * <pre>
           * Version of SKAdNetwork supported. Dependent on both the OS version
           * and the SDK version.
           * Note:  This field will be replaced by the
           * BidRequest.mobile.skadn.versions field to support a list of version
           * numbers.
           * </pre>
           *
           * <code>optional string version = 1;</code>
           * @return This builder for chaining.
           */
          public Builder clearVersion() {
            bitField0_ = (bitField0_ & ~0x00000001);
            version_ = getDefaultInstance().getVersion();
            onChanged();
            return this;
          }
          /**
           * <pre>
           * Version of SKAdNetwork supported. Dependent on both the OS version
           * and the SDK version.
           * Note:  This field will be replaced by the
           * BidRequest.mobile.skadn.versions field to support a list of version
           * numbers.
           * </pre>
           *
           * <code>optional string version = 1;</code>
           * @param value The bytes for version to set.
           * @return This builder for chaining.
           */
          public Builder setVersionBytes(
              com.google.protobuf.ByteString value) {
            if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
            version_ = value;
            onChanged();
            return this;
          }

          private com.google.protobuf.LazyStringList versions_ = com.google.protobuf.LazyStringArrayList.EMPTY;
          private void ensureVersionsIsMutable() {
            if (!((bitField0_ & 0x00000002) != 0)) {
              versions_ = new com.google.protobuf.LazyStringArrayList(versions_);
              bitField0_ |= 0x00000002;
             }
          }
          /**
           * <pre>
           * List of SKAdNetwork versions supported, depending on the OS version
           * and the SDK version.
           * </pre>
           *
           * <code>repeated string versions = 4;</code>
           * @return A list containing the versions.
           */
          public com.google.protobuf.ProtocolStringList
              getVersionsList() {
            return versions_.getUnmodifiableView();
          }
          /**
           * <pre>
           * List of SKAdNetwork versions supported, depending on the OS version
           * and the SDK version.
           * </pre>
           *
           * <code>repeated string versions = 4;</code>
           * @return The count of versions.
           */
          public int getVersionsCount() {
            return versions_.size();
          }
          /**
           * <pre>
           * List of SKAdNetwork versions supported, depending on the OS version
           * and the SDK version.
           * </pre>
           *
           * <code>repeated string versions = 4;</code>
           * @param index The index of the element to return.
           * @return The versions at the given index.
           */
          public java.lang.String getVersions(int index) {
            return versions_.get(index);
          }
          /**
           * <pre>
           * List of SKAdNetwork versions supported, depending on the OS version
           * and the SDK version.
           * </pre>
           *
           * <code>repeated string versions = 4;</code>
           * @param index The index of the value to return.
           * @return The bytes of the versions at the given index.
           */
          public com.google.protobuf.ByteString
              getVersionsBytes(int index) {
            return versions_.getByteString(index);
          }
          /**
           * <pre>
           * List of SKAdNetwork versions supported, depending on the OS version
           * and the SDK version.
           * </pre>
           *
           * <code>repeated string versions = 4;</code>
           * @param index The index to set the value at.
           * @param value The versions to set.
           * @return This builder for chaining.
           */
          public Builder setVersions(
              int index, java.lang.String value) {
            if (value == null) {
    throw new NullPointerException();
  }
  ensureVersionsIsMutable();
            versions_.set(index, value);
            onChanged();
            return this;
          }
          /**
           * <pre>
           * List of SKAdNetwork versions supported, depending on the OS version
           * and the SDK version.
           * </pre>
           *
           * <code>repeated string versions = 4;</code>
           * @param value The versions to add.
           * @return This builder for chaining.
           */
          public Builder addVersions(
              java.lang.String value) {
            if (value == null) {
    throw new NullPointerException();
  }
  ensureVersionsIsMutable();
            versions_.add(value);
            onChanged();
            return this;
          }
          /**
           * <pre>
           * List of SKAdNetwork versions supported, depending on the OS version
           * and the SDK version.
           * </pre>
           *
           * <code>repeated string versions = 4;</code>
           * @param values The versions to add.
           * @return This builder for chaining.
           */
          public Builder addAllVersions(
              java.lang.Iterable<java.lang.String> values) {
            ensureVersionsIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(
                values, versions_);
            onChanged();
            return this;
          }
          /**
           * <pre>
           * List of SKAdNetwork versions supported, depending on the OS version
           * and the SDK version.
           * </pre>
           *
           * <code>repeated string versions = 4;</code>
           * @return This builder for chaining.
           */
          public Builder clearVersions() {
            versions_ = com.google.protobuf.LazyStringArrayList.EMPTY;
            bitField0_ = (bitField0_ & ~0x00000002);
            onChanged();
            return this;
          }
          /**
           * <pre>
           * List of SKAdNetwork versions supported, depending on the OS version
           * and the SDK version.
           * </pre>
           *
           * <code>repeated string versions = 4;</code>
           * @param value The bytes of the versions to add.
           * @return This builder for chaining.
           */
          public Builder addVersionsBytes(
              com.google.protobuf.ByteString value) {
            if (value == null) {
    throw new NullPointerException();
  }
  ensureVersionsIsMutable();
            versions_.add(value);
            onChanged();
            return this;
          }

          private java.lang.Object sourceapp_ = "";
          /**
           * <pre>
           * ID of publisher app in Apple's App Store.
           * </pre>
           *
           * <code>optional string sourceapp = 2;</code>
           * @return Whether the sourceapp field is set.
           */
          public boolean hasSourceapp() {
            return ((bitField0_ & 0x00000004) != 0);
          }
          /**
           * <pre>
           * ID of publisher app in Apple's App Store.
           * </pre>
           *
           * <code>optional string sourceapp = 2;</code>
           * @return The sourceapp.
           */
          public java.lang.String getSourceapp() {
            java.lang.Object ref = sourceapp_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs =
                  (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              if (bs.isValidUtf8()) {
                sourceapp_ = s;
              }
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }
          /**
           * <pre>
           * ID of publisher app in Apple's App Store.
           * </pre>
           *
           * <code>optional string sourceapp = 2;</code>
           * @return The bytes for sourceapp.
           */
          public com.google.protobuf.ByteString
              getSourceappBytes() {
            java.lang.Object ref = sourceapp_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b = 
                  com.google.protobuf.ByteString.copyFromUtf8(
                      (java.lang.String) ref);
              sourceapp_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }
          /**
           * <pre>
           * ID of publisher app in Apple's App Store.
           * </pre>
           *
           * <code>optional string sourceapp = 2;</code>
           * @param value The sourceapp to set.
           * @return This builder for chaining.
           */
          public Builder setSourceapp(
              java.lang.String value) {
            if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000004;
            sourceapp_ = value;
            onChanged();
            return this;
          }
          /**
           * <pre>
           * ID of publisher app in Apple's App Store.
           * </pre>
           *
           * <code>optional string sourceapp = 2;</code>
           * @return This builder for chaining.
           */
          public Builder clearSourceapp() {
            bitField0_ = (bitField0_ & ~0x00000004);
            sourceapp_ = getDefaultInstance().getSourceapp();
            onChanged();
            return this;
          }
          /**
           * <pre>
           * ID of publisher app in Apple's App Store.
           * </pre>
           *
           * <code>optional string sourceapp = 2;</code>
           * @param value The bytes for sourceapp to set.
           * @return This builder for chaining.
           */
          public Builder setSourceappBytes(
              com.google.protobuf.ByteString value) {
            if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000004;
            sourceapp_ = value;
            onChanged();
            return this;
          }

          private com.google.protobuf.LazyStringList skadnetids_ = com.google.protobuf.LazyStringArrayList.EMPTY;
          private void ensureSkadnetidsIsMutable() {
            if (!((bitField0_ & 0x00000008) != 0)) {
              skadnetids_ = new com.google.protobuf.LazyStringArrayList(skadnetids_);
              bitField0_ |= 0x00000008;
             }
          }
          /**
           * <pre>
           * SKAdNetworkIdentifier entries in the publisher app's Info.plist.
           * </pre>
           *
           * <code>repeated string skadnetids = 3;</code>
           * @return A list containing the skadnetids.
           */
          public com.google.protobuf.ProtocolStringList
              getSkadnetidsList() {
            return skadnetids_.getUnmodifiableView();
          }
          /**
           * <pre>
           * SKAdNetworkIdentifier entries in the publisher app's Info.plist.
           * </pre>
           *
           * <code>repeated string skadnetids = 3;</code>
           * @return The count of skadnetids.
           */
          public int getSkadnetidsCount() {
            return skadnetids_.size();
          }
          /**
           * <pre>
           * SKAdNetworkIdentifier entries in the publisher app's Info.plist.
           * </pre>
           *
           * <code>repeated string skadnetids = 3;</code>
           * @param index The index of the element to return.
           * @return The skadnetids at the given index.
           */
          public java.lang.String getSkadnetids(int index) {
            return skadnetids_.get(index);
          }
          /**
           * <pre>
           * SKAdNetworkIdentifier entries in the publisher app's Info.plist.
           * </pre>
           *
           * <code>repeated string skadnetids = 3;</code>
           * @param index The index of the value to return.
           * @return The bytes of the skadnetids at the given index.
           */
          public com.google.protobuf.ByteString
              getSkadnetidsBytes(int index) {
            return skadnetids_.getByteString(index);
          }
          /**
           * <pre>
           * SKAdNetworkIdentifier entries in the publisher app's Info.plist.
           * </pre>
           *
           * <code>repeated string skadnetids = 3;</code>
           * @param index The index to set the value at.
           * @param value The skadnetids to set.
           * @return This builder for chaining.
           */
          public Builder setSkadnetids(
              int index, java.lang.String value) {
            if (value == null) {
    throw new NullPointerException();
  }
  ensureSkadnetidsIsMutable();
            skadnetids_.set(index, value);
            onChanged();
            return this;
          }
          /**
           * <pre>
           * SKAdNetworkIdentifier entries in the publisher app's Info.plist.
           * </pre>
           *
           * <code>repeated string skadnetids = 3;</code>
           * @param value The skadnetids to add.
           * @return This builder for chaining.
           */
          public Builder addSkadnetids(
              java.lang.String value) {
            if (value == null) {
    throw new NullPointerException();
  }
  ensureSkadnetidsIsMutable();
            skadnetids_.add(value);
            onChanged();
            return this;
          }
          /**
           * <pre>
           * SKAdNetworkIdentifier entries in the publisher app's Info.plist.
           * </pre>
           *
           * <code>repeated string skadnetids = 3;</code>
           * @param values The skadnetids to add.
           * @return This builder for chaining.
           */
          public Builder addAllSkadnetids(
              java.lang.Iterable<java.lang.String> values) {
            ensureSkadnetidsIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(
                values, skadnetids_);
            onChanged();
            return this;
          }
          /**
           * <pre>
           * SKAdNetworkIdentifier entries in the publisher app's Info.plist.
           * </pre>
           *
           * <code>repeated string skadnetids = 3;</code>
           * @return This builder for chaining.
           */
          public Builder clearSkadnetids() {
            skadnetids_ = com.google.protobuf.LazyStringArrayList.EMPTY;
            bitField0_ = (bitField0_ & ~0x00000008);
            onChanged();
            return this;
          }
          /**
           * <pre>
           * SKAdNetworkIdentifier entries in the publisher app's Info.plist.
           * </pre>
           *
           * <code>repeated string skadnetids = 3;</code>
           * @param value The bytes of the skadnetids to add.
           * @return This builder for chaining.
           */
          public Builder addSkadnetidsBytes(
              com.google.protobuf.ByteString value) {
            if (value == null) {
    throw new NullPointerException();
  }
  ensureSkadnetidsIsMutable();
            skadnetids_.add(value);
            onChanged();
            return this;
          }

          private java.util.List<java.lang.Integer> supportedFidelityTypes_ =
            java.util.Collections.emptyList();
          private void ensureSupportedFidelityTypesIsMutable() {
            if (!((bitField0_ & 0x00000010) != 0)) {
              supportedFidelityTypes_ = new java.util.ArrayList<java.lang.Integer>(supportedFidelityTypes_);
              bitField0_ |= 0x00000010;
            }
          }
          /**
           * <pre>
           * List of fidelity types supported, depending on the SKAdNetwork API
           * version supported by the operating system and SDK as well as ad slot
           * properties.
           * </pre>
           *
           * <code>repeated .com.google.protos.adx.SKAdNetworkFidelityType supported_fidelity_types = 5 [packed = true];</code>
           * @return A list containing the supportedFidelityTypes.
           */
          public java.util.List<com.google.protos.adx.NetworkBid.SKAdNetworkFidelityType> getSupportedFidelityTypesList() {
            return new com.google.protobuf.Internal.ListAdapter<
                java.lang.Integer, com.google.protos.adx.NetworkBid.SKAdNetworkFidelityType>(supportedFidelityTypes_, supportedFidelityTypes_converter_);
          }
          /**
           * <pre>
           * List of fidelity types supported, depending on the SKAdNetwork API
           * version supported by the operating system and SDK as well as ad slot
           * properties.
           * </pre>
           *
           * <code>repeated .com.google.protos.adx.SKAdNetworkFidelityType supported_fidelity_types = 5 [packed = true];</code>
           * @return The count of supportedFidelityTypes.
           */
          public int getSupportedFidelityTypesCount() {
            return supportedFidelityTypes_.size();
          }
          /**
           * <pre>
           * List of fidelity types supported, depending on the SKAdNetwork API
           * version supported by the operating system and SDK as well as ad slot
           * properties.
           * </pre>
           *
           * <code>repeated .com.google.protos.adx.SKAdNetworkFidelityType supported_fidelity_types = 5 [packed = true];</code>
           * @param index The index of the element to return.
           * @return The supportedFidelityTypes at the given index.
           */
          public com.google.protos.adx.NetworkBid.SKAdNetworkFidelityType getSupportedFidelityTypes(int index) {
            return supportedFidelityTypes_converter_.convert(supportedFidelityTypes_.get(index));
          }
          /**
           * <pre>
           * List of fidelity types supported, depending on the SKAdNetwork API
           * version supported by the operating system and SDK as well as ad slot
           * properties.
           * </pre>
           *
           * <code>repeated .com.google.protos.adx.SKAdNetworkFidelityType supported_fidelity_types = 5 [packed = true];</code>
           * @param index The index to set the value at.
           * @param value The supportedFidelityTypes to set.
           * @return This builder for chaining.
           */
          public Builder setSupportedFidelityTypes(
              int index, com.google.protos.adx.NetworkBid.SKAdNetworkFidelityType value) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureSupportedFidelityTypesIsMutable();
            supportedFidelityTypes_.set(index, value.getNumber());
            onChanged();
            return this;
          }
          /**
           * <pre>
           * List of fidelity types supported, depending on the SKAdNetwork API
           * version supported by the operating system and SDK as well as ad slot
           * properties.
           * </pre>
           *
           * <code>repeated .com.google.protos.adx.SKAdNetworkFidelityType supported_fidelity_types = 5 [packed = true];</code>
           * @param value The supportedFidelityTypes to add.
           * @return This builder for chaining.
           */
          public Builder addSupportedFidelityTypes(com.google.protos.adx.NetworkBid.SKAdNetworkFidelityType value) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureSupportedFidelityTypesIsMutable();
            supportedFidelityTypes_.add(value.getNumber());
            onChanged();
            return this;
          }
          /**
           * <pre>
           * List of fidelity types supported, depending on the SKAdNetwork API
           * version supported by the operating system and SDK as well as ad slot
           * properties.
           * </pre>
           *
           * <code>repeated .com.google.protos.adx.SKAdNetworkFidelityType supported_fidelity_types = 5 [packed = true];</code>
           * @param values The supportedFidelityTypes to add.
           * @return This builder for chaining.
           */
          public Builder addAllSupportedFidelityTypes(
              java.lang.Iterable<? extends com.google.protos.adx.NetworkBid.SKAdNetworkFidelityType> values) {
            ensureSupportedFidelityTypesIsMutable();
            for (com.google.protos.adx.NetworkBid.SKAdNetworkFidelityType value : values) {
              supportedFidelityTypes_.add(value.getNumber());
            }
            onChanged();
            return this;
          }
          /**
           * <pre>
           * List of fidelity types supported, depending on the SKAdNetwork API
           * version supported by the operating system and SDK as well as ad slot
           * properties.
           * </pre>
           *
           * <code>repeated .com.google.protos.adx.SKAdNetworkFidelityType supported_fidelity_types = 5 [packed = true];</code>
           * @return This builder for chaining.
           */
          public Builder clearSupportedFidelityTypes() {
            supportedFidelityTypes_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000010);
            onChanged();
            return this;
          }
          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }


          // @@protoc_insertion_point(builder_scope:com.google.protos.adx.BidRequest.Mobile.SKAdNetworkRequest)
        }

        // @@protoc_insertion_point(class_scope:com.google.protos.adx.BidRequest.Mobile.SKAdNetworkRequest)
        private static final com.google.protos.adx.NetworkBid.BidRequest.Mobile.SKAdNetworkRequest DEFAULT_INSTANCE;
        static {
          DEFAULT_INSTANCE = new com.google.protos.adx.NetworkBid.BidRequest.Mobile.SKAdNetworkRequest();
        }

        public static com.google.protos.adx.NetworkBid.BidRequest.Mobile.SKAdNetworkRequest getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        @java.lang.Deprecated public static final com.google.protobuf.Parser<SKAdNetworkRequest>
            PARSER = new com.google.protobuf.AbstractParser<SKAdNetworkRequest>() {
          @java.lang.Override
          public SKAdNetworkRequest parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new SKAdNetworkRequest(input, extensionRegistry);
          }
        };

        public static com.google.protobuf.Parser<SKAdNetworkRequest> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<SKAdNetworkRequest> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protos.adx.NetworkBid.BidRequest.Mobile.SKAdNetworkRequest getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }

      }

      private int bitField0_;
      public static final int IS_APP_FIELD_NUMBER = 7;
      private boolean isApp_;
      /**
       * <pre>
       * If true, then this request is from a mobile application. For branded
       * requests, app_id will also be filled in. If the request is from a mobile
       * web page contained inside an app, is_app will still be false, but app_id
       * could be filled in with the app identifier. For SDK-less requests (mostly
       * from connected TVs), this will be true if an app ID is provided directly
       * in the request.
       * </pre>
       *
       * <code>optional bool is_app = 7 [default = false];</code>
       * @return Whether the isApp field is set.
       */
      @java.lang.Override
      public boolean hasIsApp() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <pre>
       * If true, then this request is from a mobile application. For branded
       * requests, app_id will also be filled in. If the request is from a mobile
       * web page contained inside an app, is_app will still be false, but app_id
       * could be filled in with the app identifier. For SDK-less requests (mostly
       * from connected TVs), this will be true if an app ID is provided directly
       * in the request.
       * </pre>
       *
       * <code>optional bool is_app = 7 [default = false];</code>
       * @return The isApp.
       */
      @java.lang.Override
      public boolean getIsApp() {
        return isApp_;
      }

      public static final int APP_ID_FIELD_NUMBER = 6;
      private volatile java.lang.Object appId_;
      /**
       * <pre>
       * The identifier of the mobile app when this ad query comes from a mobile
       * app, or from a mobile web page contained inside an app. If the app was
       * downloaded from the Apple iTunes app store, then this is the app-store
       * id, e.g., 343200656. For Android devices, this is the fully qualified
       * package name, e.g., com.rovio.angrybirds. For Windows devices it's the
       * App ID, e.g., f15abcde-f6gh-47i0-j3k8-37l93817mn3o. For SDK-less requests
       * (mostly from connected TVs), the app ID provided by the publisher
       * directly in the request.
       * </pre>
       *
       * <code>optional string app_id = 6;</code>
       * @return Whether the appId field is set.
       */
      @java.lang.Override
      public boolean hasAppId() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <pre>
       * The identifier of the mobile app when this ad query comes from a mobile
       * app, or from a mobile web page contained inside an app. If the app was
       * downloaded from the Apple iTunes app store, then this is the app-store
       * id, e.g., 343200656. For Android devices, this is the fully qualified
       * package name, e.g., com.rovio.angrybirds. For Windows devices it's the
       * App ID, e.g., f15abcde-f6gh-47i0-j3k8-37l93817mn3o. For SDK-less requests
       * (mostly from connected TVs), the app ID provided by the publisher
       * directly in the request.
       * </pre>
       *
       * <code>optional string app_id = 6;</code>
       * @return The appId.
       */
      @java.lang.Override
      public java.lang.String getAppId() {
        java.lang.Object ref = appId_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = 
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            appId_ = s;
          }
          return s;
        }
      }
      /**
       * <pre>
       * The identifier of the mobile app when this ad query comes from a mobile
       * app, or from a mobile web page contained inside an app. If the app was
       * downloaded from the Apple iTunes app store, then this is the app-store
       * id, e.g., 343200656. For Android devices, this is the fully qualified
       * package name, e.g., com.rovio.angrybirds. For Windows devices it's the
       * App ID, e.g., f15abcde-f6gh-47i0-j3k8-37l93817mn3o. For SDK-less requests
       * (mostly from connected TVs), the app ID provided by the publisher
       * directly in the request.
       * </pre>
       *
       * <code>optional string app_id = 6;</code>
       * @return The bytes for appId.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString
          getAppIdBytes() {
        java.lang.Object ref = appId_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          appId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int IS_INTERSTITIAL_REQUEST_FIELD_NUMBER = 10;
      private boolean isInterstitialRequest_;
      /**
       * <pre>
       * If true, then this is a mobile full screen ad request.
       * </pre>
       *
       * <code>optional bool is_interstitial_request = 10 [default = false];</code>
       * @return Whether the isInterstitialRequest field is set.
       */
      @java.lang.Override
      public boolean hasIsInterstitialRequest() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       * <pre>
       * If true, then this is a mobile full screen ad request.
       * </pre>
       *
       * <code>optional bool is_interstitial_request = 10 [default = false];</code>
       * @return The isInterstitialRequest.
       */
      @java.lang.Override
      public boolean getIsInterstitialRequest() {
        return isInterstitialRequest_;
      }

      public static final int APP_CATEGORY_IDS_FIELD_NUMBER = 11;
      private com.google.protobuf.Internal.IntList appCategoryIds_;
      /**
       * <pre>
       * This field contains the IDs of categories to which the current mobile app
       * belongs. This field will be empty if is_app is false. The mapping between
       * mobile apps and categories is defined by the Google Play Store for
       * Android apps, or the Apple iTunes Store for iOS apps. To look up category
       * name from category ID, please refer to
       * https://developers.google.com/google-ads/api/reference/data/codes-formats#mobile_app_categories
       * </pre>
       *
       * <code>repeated int32 app_category_ids = 11;</code>
       * @return A list containing the appCategoryIds.
       */
      @java.lang.Override
      public java.util.List<java.lang.Integer>
          getAppCategoryIdsList() {
        return appCategoryIds_;
      }
      /**
       * <pre>
       * This field contains the IDs of categories to which the current mobile app
       * belongs. This field will be empty if is_app is false. The mapping between
       * mobile apps and categories is defined by the Google Play Store for
       * Android apps, or the Apple iTunes Store for iOS apps. To look up category
       * name from category ID, please refer to
       * https://developers.google.com/google-ads/api/reference/data/codes-formats#mobile_app_categories
       * </pre>
       *
       * <code>repeated int32 app_category_ids = 11;</code>
       * @return The count of appCategoryIds.
       */
      public int getAppCategoryIdsCount() {
        return appCategoryIds_.size();
      }
      /**
       * <pre>
       * This field contains the IDs of categories to which the current mobile app
       * belongs. This field will be empty if is_app is false. The mapping between
       * mobile apps and categories is defined by the Google Play Store for
       * Android apps, or the Apple iTunes Store for iOS apps. To look up category
       * name from category ID, please refer to
       * https://developers.google.com/google-ads/api/reference/data/codes-formats#mobile_app_categories
       * </pre>
       *
       * <code>repeated int32 app_category_ids = 11;</code>
       * @param index The index of the element to return.
       * @return The appCategoryIds at the given index.
       */
      public int getAppCategoryIds(int index) {
        return appCategoryIds_.getInt(index);
      }

      public static final int IS_MOBILE_WEB_OPTIMIZED_FIELD_NUMBER = 17;
      private boolean isMobileWebOptimized_;
      /**
       * <pre>
       * For a mobile web request, this field indicates whether the page is
       * optimized for mobile browsers on high-end mobile phones.
       * </pre>
       *
       * <code>optional bool is_mobile_web_optimized = 17 [default = false];</code>
       * @return Whether the isMobileWebOptimized field is set.
       */
      @java.lang.Override
      public boolean hasIsMobileWebOptimized() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       * <pre>
       * For a mobile web request, this field indicates whether the page is
       * optimized for mobile browsers on high-end mobile phones.
       * </pre>
       *
       * <code>optional bool is_mobile_web_optimized = 17 [default = false];</code>
       * @return The isMobileWebOptimized.
       */
      @java.lang.Override
      public boolean getIsMobileWebOptimized() {
        return isMobileWebOptimized_;
      }

      public static final int ENCRYPTED_ADVERTISING_ID_FIELD_NUMBER = 20;
      private com.google.protobuf.ByteString encryptedAdvertisingId_;
      /**
       * <pre>
       * This field is used for advertising identifiers for
       * 1) iOS devices (This is called Identifier for Advertising, or IDFA, as
       * described at https://support.google.com/authorizedbuyers/answer/3221407),
       * 2) Android devices,
       * 3) Roku devices,
       * 4) Microsoft Xbox devices,
       * 5) Amazon devices (i.e. Amazon Fire).
       * When the encrypted_advertising_id is an IDFA, the plaintext after
       * decrypting the ciphertext is the IDFA (16 byte UUID) returned by iOS's
       * [ASIdentifierManager advertisingIdentifier]. For encrypted_hashed_idfa,
       * the plaintext is the 16 byte MD5 hash of the IDFA. Only one of the two
       * fields will be available, depending on the version of the SDK making the
       * request. Later SDKs provide unhashed values. They are not set if there is
       * one or more user_data_treatment value in the BidRequest.
       * </pre>
       *
       * <code>optional bytes encrypted_advertising_id = 20;</code>
       * @return Whether the encryptedAdvertisingId field is set.
       */
      @java.lang.Override
      public boolean hasEncryptedAdvertisingId() {
        return ((bitField0_ & 0x00000010) != 0);
      }
      /**
       * <pre>
       * This field is used for advertising identifiers for
       * 1) iOS devices (This is called Identifier for Advertising, or IDFA, as
       * described at https://support.google.com/authorizedbuyers/answer/3221407),
       * 2) Android devices,
       * 3) Roku devices,
       * 4) Microsoft Xbox devices,
       * 5) Amazon devices (i.e. Amazon Fire).
       * When the encrypted_advertising_id is an IDFA, the plaintext after
       * decrypting the ciphertext is the IDFA (16 byte UUID) returned by iOS's
       * [ASIdentifierManager advertisingIdentifier]. For encrypted_hashed_idfa,
       * the plaintext is the 16 byte MD5 hash of the IDFA. Only one of the two
       * fields will be available, depending on the version of the SDK making the
       * request. Later SDKs provide unhashed values. They are not set if there is
       * one or more user_data_treatment value in the BidRequest.
       * </pre>
       *
       * <code>optional bytes encrypted_advertising_id = 20;</code>
       * @return The encryptedAdvertisingId.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getEncryptedAdvertisingId() {
        return encryptedAdvertisingId_;
      }

      public static final int ADVERTISING_ID_FIELD_NUMBER = 27;
      private com.google.protobuf.ByteString advertisingId_;
      /**
       * <pre>
       * Unencrypted version of encrypted_advertising_id. This field is only set
       * when using an SSL connection. This field is a 16 byte UUID (binary form)
       * or a 32 byte alphanumeric id (such as Samsung ID).
       * </pre>
       *
       * <code>optional bytes advertising_id = 27;</code>
       * @return Whether the advertisingId field is set.
       */
      @java.lang.Override
      public boolean hasAdvertisingId() {
        return ((bitField0_ & 0x00000020) != 0);
      }
      /**
       * <pre>
       * Unencrypted version of encrypted_advertising_id. This field is only set
       * when using an SSL connection. This field is a 16 byte UUID (binary form)
       * or a 32 byte alphanumeric id (such as Samsung ID).
       * </pre>
       *
       * <code>optional bytes advertising_id = 27;</code>
       * @return The advertisingId.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getAdvertisingId() {
        return advertisingId_;
      }

      public static final int ENCRYPTED_HASHED_IDFA_FIELD_NUMBER = 21;
      private com.google.protobuf.ByteString encryptedHashedIdfa_;
      /**
       * <code>optional bytes encrypted_hashed_idfa = 21;</code>
       * @return Whether the encryptedHashedIdfa field is set.
       */
      @java.lang.Override
      public boolean hasEncryptedHashedIdfa() {
        return ((bitField0_ & 0x00000040) != 0);
      }
      /**
       * <code>optional bytes encrypted_hashed_idfa = 21;</code>
       * @return The encryptedHashedIdfa.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getEncryptedHashedIdfa() {
        return encryptedHashedIdfa_;
      }

      public static final int HASHED_IDFA_FIELD_NUMBER = 28;
      private com.google.protobuf.ByteString hashedIdfa_;
      /**
       * <pre>
       * Unencrypted version of encrypted_hashed_idfa. This field is only set
       * when using an SSL connection. This field is a 16 byte MD5.
       * </pre>
       *
       * <code>optional bytes hashed_idfa = 28;</code>
       * @return Whether the hashedIdfa field is set.
       */
      @java.lang.Override
      public boolean hasHashedIdfa() {
        return ((bitField0_ & 0x00000080) != 0);
      }
      /**
       * <pre>
       * Unencrypted version of encrypted_hashed_idfa. This field is only set
       * when using an SSL connection. This field is a 16 byte MD5.
       * </pre>
       *
       * <code>optional bytes hashed_idfa = 28;</code>
       * @return The hashedIdfa.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getHashedIdfa() {
        return hashedIdfa_;
      }

      public static final int APP_NAME_FIELD_NUMBER = 24;
      private volatile java.lang.Object appName_;
      /**
       * <pre>
       * App names for Android apps are from the Google Play store.
       * App names for iOS apps are provided by App Annie
       * (https://www.appannie.com). App names for SDK-less requests (mostly from
       * connected TVs) are provided by the publisher directly in the request.
       * </pre>
       *
       * <code>optional string app_name = 24;</code>
       * @return Whether the appName field is set.
       */
      @java.lang.Override
      public boolean hasAppName() {
        return ((bitField0_ & 0x00000100) != 0);
      }
      /**
       * <pre>
       * App names for Android apps are from the Google Play store.
       * App names for iOS apps are provided by App Annie
       * (https://www.appannie.com). App names for SDK-less requests (mostly from
       * connected TVs) are provided by the publisher directly in the request.
       * </pre>
       *
       * <code>optional string app_name = 24;</code>
       * @return The appName.
       */
      @java.lang.Override
      public java.lang.String getAppName() {
        java.lang.Object ref = appName_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = 
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            appName_ = s;
          }
          return s;
        }
      }
      /**
       * <pre>
       * App names for Android apps are from the Google Play store.
       * App names for iOS apps are provided by App Annie
       * (https://www.appannie.com). App names for SDK-less requests (mostly from
       * connected TVs) are provided by the publisher directly in the request.
       * </pre>
       *
       * <code>optional string app_name = 24;</code>
       * @return The bytes for appName.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString
          getAppNameBytes() {
        java.lang.Object ref = appName_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          appName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int APP_RATING_FIELD_NUMBER = 25;
      private float appRating_;
      /**
       * <pre>
       * Average user rating for the app. The range of user rating is between 1.0
       * and 5.0. Currently only available for apps in Google Play store.
       * </pre>
       *
       * <code>optional float app_rating = 25;</code>
       * @return Whether the appRating field is set.
       */
      @java.lang.Override
      public boolean hasAppRating() {
        return ((bitField0_ & 0x00000200) != 0);
      }
      /**
       * <pre>
       * Average user rating for the app. The range of user rating is between 1.0
       * and 5.0. Currently only available for apps in Google Play store.
       * </pre>
       *
       * <code>optional float app_rating = 25;</code>
       * @return The appRating.
       */
      @java.lang.Override
      public float getAppRating() {
        return appRating_;
      }

      public static final int INSTALLED_SDK_FIELD_NUMBER = 32;
      private java.util.List<com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk> installedSdk_;
      /**
       * <code>repeated .com.google.protos.adx.BidRequest.Mobile.InstalledSdk installed_sdk = 32;</code>
       */
      @java.lang.Override
      public java.util.List<com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk> getInstalledSdkList() {
        return installedSdk_;
      }
      /**
       * <code>repeated .com.google.protos.adx.BidRequest.Mobile.InstalledSdk installed_sdk = 32;</code>
       */
      @java.lang.Override
      public java.util.List<? extends com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdkOrBuilder> 
          getInstalledSdkOrBuilderList() {
        return installedSdk_;
      }
      /**
       * <code>repeated .com.google.protos.adx.BidRequest.Mobile.InstalledSdk installed_sdk = 32;</code>
       */
      @java.lang.Override
      public int getInstalledSdkCount() {
        return installedSdk_.size();
      }
      /**
       * <code>repeated .com.google.protos.adx.BidRequest.Mobile.InstalledSdk installed_sdk = 32;</code>
       */
      @java.lang.Override
      public com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk getInstalledSdk(int index) {
        return installedSdk_.get(index);
      }
      /**
       * <code>repeated .com.google.protos.adx.BidRequest.Mobile.InstalledSdk installed_sdk = 32;</code>
       */
      @java.lang.Override
      public com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdkOrBuilder getInstalledSdkOrBuilder(
          int index) {
        return installedSdk_.get(index);
      }

      public static final int SKADN_FIELD_NUMBER = 34;
      private com.google.protos.adx.NetworkBid.BidRequest.Mobile.SKAdNetworkRequest skadn_;
      /**
       * <code>optional .com.google.protos.adx.BidRequest.Mobile.SKAdNetworkRequest skadn = 34;</code>
       * @return Whether the skadn field is set.
       */
      @java.lang.Override
      public boolean hasSkadn() {
        return ((bitField0_ & 0x00000400) != 0);
      }
      /**
       * <code>optional .com.google.protos.adx.BidRequest.Mobile.SKAdNetworkRequest skadn = 34;</code>
       * @return The skadn.
       */
      @java.lang.Override
      public com.google.protos.adx.NetworkBid.BidRequest.Mobile.SKAdNetworkRequest getSkadn() {
        return skadn_ == null ? com.google.protos.adx.NetworkBid.BidRequest.Mobile.SKAdNetworkRequest.getDefaultInstance() : skadn_;
      }
      /**
       * <code>optional .com.google.protos.adx.BidRequest.Mobile.SKAdNetworkRequest skadn = 34;</code>
       */
      @java.lang.Override
      public com.google.protos.adx.NetworkBid.BidRequest.Mobile.SKAdNetworkRequestOrBuilder getSkadnOrBuilder() {
        return skadn_ == null ? com.google.protos.adx.NetworkBid.BidRequest.Mobile.SKAdNetworkRequest.getDefaultInstance() : skadn_;
      }

      private byte memoizedIsInitialized = -1;
      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output)
                          throws java.io.IOException {
        if (((bitField0_ & 0x00000002) != 0)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 6, appId_);
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeBool(7, isApp_);
        }
        if (((bitField0_ & 0x00000004) != 0)) {
          output.writeBool(10, isInterstitialRequest_);
        }
        for (int i = 0; i < appCategoryIds_.size(); i++) {
          output.writeInt32(11, appCategoryIds_.getInt(i));
        }
        if (((bitField0_ & 0x00000008) != 0)) {
          output.writeBool(17, isMobileWebOptimized_);
        }
        if (((bitField0_ & 0x00000010) != 0)) {
          output.writeBytes(20, encryptedAdvertisingId_);
        }
        if (((bitField0_ & 0x00000040) != 0)) {
          output.writeBytes(21, encryptedHashedIdfa_);
        }
        if (((bitField0_ & 0x00000100) != 0)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 24, appName_);
        }
        if (((bitField0_ & 0x00000200) != 0)) {
          output.writeFloat(25, appRating_);
        }
        if (((bitField0_ & 0x00000020) != 0)) {
          output.writeBytes(27, advertisingId_);
        }
        if (((bitField0_ & 0x00000080) != 0)) {
          output.writeBytes(28, hashedIdfa_);
        }
        for (int i = 0; i < installedSdk_.size(); i++) {
          output.writeMessage(32, installedSdk_.get(i));
        }
        if (((bitField0_ & 0x00000400) != 0)) {
          output.writeMessage(34, getSkadn());
        }
        unknownFields.writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000002) != 0)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, appId_);
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.CodedOutputStream
            .computeBoolSize(7, isApp_);
        }
        if (((bitField0_ & 0x00000004) != 0)) {
          size += com.google.protobuf.CodedOutputStream
            .computeBoolSize(10, isInterstitialRequest_);
        }
        {
          int dataSize = 0;
          for (int i = 0; i < appCategoryIds_.size(); i++) {
            dataSize += com.google.protobuf.CodedOutputStream
              .computeInt32SizeNoTag(appCategoryIds_.getInt(i));
          }
          size += dataSize;
          size += 1 * getAppCategoryIdsList().size();
        }
        if (((bitField0_ & 0x00000008) != 0)) {
          size += com.google.protobuf.CodedOutputStream
            .computeBoolSize(17, isMobileWebOptimized_);
        }
        if (((bitField0_ & 0x00000010) != 0)) {
          size += com.google.protobuf.CodedOutputStream
            .computeBytesSize(20, encryptedAdvertisingId_);
        }
        if (((bitField0_ & 0x00000040) != 0)) {
          size += com.google.protobuf.CodedOutputStream
            .computeBytesSize(21, encryptedHashedIdfa_);
        }
        if (((bitField0_ & 0x00000100) != 0)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(24, appName_);
        }
        if (((bitField0_ & 0x00000200) != 0)) {
          size += com.google.protobuf.CodedOutputStream
            .computeFloatSize(25, appRating_);
        }
        if (((bitField0_ & 0x00000020) != 0)) {
          size += com.google.protobuf.CodedOutputStream
            .computeBytesSize(27, advertisingId_);
        }
        if (((bitField0_ & 0x00000080) != 0)) {
          size += com.google.protobuf.CodedOutputStream
            .computeBytesSize(28, hashedIdfa_);
        }
        for (int i = 0; i < installedSdk_.size(); i++) {
          size += com.google.protobuf.CodedOutputStream
            .computeMessageSize(32, installedSdk_.get(i));
        }
        if (((bitField0_ & 0x00000400) != 0)) {
          size += com.google.protobuf.CodedOutputStream
            .computeMessageSize(34, getSkadn());
        }
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
         return true;
        }
        if (!(obj instanceof com.google.protos.adx.NetworkBid.BidRequest.Mobile)) {
          return super.equals(obj);
        }
        com.google.protos.adx.NetworkBid.BidRequest.Mobile other = (com.google.protos.adx.NetworkBid.BidRequest.Mobile) obj;

        if (hasIsApp() != other.hasIsApp()) return false;
        if (hasIsApp()) {
          if (getIsApp()
              != other.getIsApp()) return false;
        }
        if (hasAppId() != other.hasAppId()) return false;
        if (hasAppId()) {
          if (!getAppId()
              .equals(other.getAppId())) return false;
        }
        if (hasIsInterstitialRequest() != other.hasIsInterstitialRequest()) return false;
        if (hasIsInterstitialRequest()) {
          if (getIsInterstitialRequest()
              != other.getIsInterstitialRequest()) return false;
        }
        if (!getAppCategoryIdsList()
            .equals(other.getAppCategoryIdsList())) return false;
        if (hasIsMobileWebOptimized() != other.hasIsMobileWebOptimized()) return false;
        if (hasIsMobileWebOptimized()) {
          if (getIsMobileWebOptimized()
              != other.getIsMobileWebOptimized()) return false;
        }
        if (hasEncryptedAdvertisingId() != other.hasEncryptedAdvertisingId()) return false;
        if (hasEncryptedAdvertisingId()) {
          if (!getEncryptedAdvertisingId()
              .equals(other.getEncryptedAdvertisingId())) return false;
        }
        if (hasAdvertisingId() != other.hasAdvertisingId()) return false;
        if (hasAdvertisingId()) {
          if (!getAdvertisingId()
              .equals(other.getAdvertisingId())) return false;
        }
        if (hasEncryptedHashedIdfa() != other.hasEncryptedHashedIdfa()) return false;
        if (hasEncryptedHashedIdfa()) {
          if (!getEncryptedHashedIdfa()
              .equals(other.getEncryptedHashedIdfa())) return false;
        }
        if (hasHashedIdfa() != other.hasHashedIdfa()) return false;
        if (hasHashedIdfa()) {
          if (!getHashedIdfa()
              .equals(other.getHashedIdfa())) return false;
        }
        if (hasAppName() != other.hasAppName()) return false;
        if (hasAppName()) {
          if (!getAppName()
              .equals(other.getAppName())) return false;
        }
        if (hasAppRating() != other.hasAppRating()) return false;
        if (hasAppRating()) {
          if (java.lang.Float.floatToIntBits(getAppRating())
              != java.lang.Float.floatToIntBits(
                  other.getAppRating())) return false;
        }
        if (!getInstalledSdkList()
            .equals(other.getInstalledSdkList())) return false;
        if (hasSkadn() != other.hasSkadn()) return false;
        if (hasSkadn()) {
          if (!getSkadn()
              .equals(other.getSkadn())) return false;
        }
        if (!unknownFields.equals(other.unknownFields)) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasIsApp()) {
          hash = (37 * hash) + IS_APP_FIELD_NUMBER;
          hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
              getIsApp());
        }
        if (hasAppId()) {
          hash = (37 * hash) + APP_ID_FIELD_NUMBER;
          hash = (53 * hash) + getAppId().hashCode();
        }
        if (hasIsInterstitialRequest()) {
          hash = (37 * hash) + IS_INTERSTITIAL_REQUEST_FIELD_NUMBER;
          hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
              getIsInterstitialRequest());
        }
        if (getAppCategoryIdsCount() > 0) {
          hash = (37 * hash) + APP_CATEGORY_IDS_FIELD_NUMBER;
          hash = (53 * hash) + getAppCategoryIdsList().hashCode();
        }
        if (hasIsMobileWebOptimized()) {
          hash = (37 * hash) + IS_MOBILE_WEB_OPTIMIZED_FIELD_NUMBER;
          hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
              getIsMobileWebOptimized());
        }
        if (hasEncryptedAdvertisingId()) {
          hash = (37 * hash) + ENCRYPTED_ADVERTISING_ID_FIELD_NUMBER;
          hash = (53 * hash) + getEncryptedAdvertisingId().hashCode();
        }
        if (hasAdvertisingId()) {
          hash = (37 * hash) + ADVERTISING_ID_FIELD_NUMBER;
          hash = (53 * hash) + getAdvertisingId().hashCode();
        }
        if (hasEncryptedHashedIdfa()) {
          hash = (37 * hash) + ENCRYPTED_HASHED_IDFA_FIELD_NUMBER;
          hash = (53 * hash) + getEncryptedHashedIdfa().hashCode();
        }
        if (hasHashedIdfa()) {
          hash = (37 * hash) + HASHED_IDFA_FIELD_NUMBER;
          hash = (53 * hash) + getHashedIdfa().hashCode();
        }
        if (hasAppName()) {
          hash = (37 * hash) + APP_NAME_FIELD_NUMBER;
          hash = (53 * hash) + getAppName().hashCode();
        }
        if (hasAppRating()) {
          hash = (37 * hash) + APP_RATING_FIELD_NUMBER;
          hash = (53 * hash) + java.lang.Float.floatToIntBits(
              getAppRating());
        }
        if (getInstalledSdkCount() > 0) {
          hash = (37 * hash) + INSTALLED_SDK_FIELD_NUMBER;
          hash = (53 * hash) + getInstalledSdkList().hashCode();
        }
        if (hasSkadn()) {
          hash = (37 * hash) + SKADN_FIELD_NUMBER;
          hash = (53 * hash) + getSkadn().hashCode();
        }
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.protos.adx.NetworkBid.BidRequest.Mobile parseFrom(
          java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.Mobile parseFrom(
          java.nio.ByteBuffer data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.Mobile parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.Mobile parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.Mobile parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.Mobile parseFrom(
          byte[] data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.Mobile parseFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.Mobile parseFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.Mobile parseDelimitedFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.Mobile parseDelimitedFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.Mobile parseFrom(
          com.google.protobuf.CodedInputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static com.google.protos.adx.NetworkBid.BidRequest.Mobile parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() { return newBuilder(); }
      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }
      public static Builder newBuilder(com.google.protos.adx.NetworkBid.BidRequest.Mobile prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }
      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE
            ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * <pre>
       * Information for ad queries coming from mobile devices. A mobile device is
       * either a smartphone or a tablet. This is present for ad queries both from
       * mobile devices browsing the web and from mobile apps.
       * </pre>
       *
       * Protobuf type {@code com.google.protos.adx.BidRequest.Mobile}
       */
      public static final class Builder extends
          com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
          // @@protoc_insertion_point(builder_implements:com.google.protos.adx.BidRequest.Mobile)
          com.google.protos.adx.NetworkBid.BidRequest.MobileOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
          return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_Mobile_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_Mobile_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.protos.adx.NetworkBid.BidRequest.Mobile.class, com.google.protos.adx.NetworkBid.BidRequest.Mobile.Builder.class);
        }

        // Construct using com.google.protos.adx.NetworkBid.BidRequest.Mobile.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }
        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3
                  .alwaysUseFieldBuilders) {
            getInstalledSdkFieldBuilder();
            getSkadnFieldBuilder();
          }
        }
        @java.lang.Override
        public Builder clear() {
          super.clear();
          isApp_ = false;
          bitField0_ = (bitField0_ & ~0x00000001);
          appId_ = "";
          bitField0_ = (bitField0_ & ~0x00000002);
          isInterstitialRequest_ = false;
          bitField0_ = (bitField0_ & ~0x00000004);
          appCategoryIds_ = emptyIntList();
          bitField0_ = (bitField0_ & ~0x00000008);
          isMobileWebOptimized_ = false;
          bitField0_ = (bitField0_ & ~0x00000010);
          encryptedAdvertisingId_ = com.google.protobuf.ByteString.EMPTY;
          bitField0_ = (bitField0_ & ~0x00000020);
          advertisingId_ = com.google.protobuf.ByteString.EMPTY;
          bitField0_ = (bitField0_ & ~0x00000040);
          encryptedHashedIdfa_ = com.google.protobuf.ByteString.EMPTY;
          bitField0_ = (bitField0_ & ~0x00000080);
          hashedIdfa_ = com.google.protobuf.ByteString.EMPTY;
          bitField0_ = (bitField0_ & ~0x00000100);
          appName_ = "";
          bitField0_ = (bitField0_ & ~0x00000200);
          appRating_ = 0F;
          bitField0_ = (bitField0_ & ~0x00000400);
          if (installedSdkBuilder_ == null) {
            installedSdk_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000800);
          } else {
            installedSdkBuilder_.clear();
          }
          if (skadnBuilder_ == null) {
            skadn_ = null;
          } else {
            skadnBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00001000);
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
          return com.google.protos.adx.NetworkBid.internal_static_com_google_protos_adx_BidRequest_Mobile_descriptor;
        }

        @java.lang.Override
        public com.google.protos.adx.NetworkBid.BidRequest.Mobile getDefaultInstanceForType() {
          return com.google.protos.adx.NetworkBid.BidRequest.Mobile.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.protos.adx.NetworkBid.BidRequest.Mobile build() {
          com.google.protos.adx.NetworkBid.BidRequest.Mobile result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.protos.adx.NetworkBid.BidRequest.Mobile buildPartial() {
          com.google.protos.adx.NetworkBid.BidRequest.Mobile result = new com.google.protos.adx.NetworkBid.BidRequest.Mobile(this);
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.isApp_ = isApp_;
            to_bitField0_ |= 0x00000001;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            to_bitField0_ |= 0x00000002;
          }
          result.appId_ = appId_;
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.isInterstitialRequest_ = isInterstitialRequest_;
            to_bitField0_ |= 0x00000004;
          }
          if (((bitField0_ & 0x00000008) != 0)) {
            appCategoryIds_.makeImmutable();
            bitField0_ = (bitField0_ & ~0x00000008);
          }
          result.appCategoryIds_ = appCategoryIds_;
          if (((from_bitField0_ & 0x00000010) != 0)) {
            result.isMobileWebOptimized_ = isMobileWebOptimized_;
            to_bitField0_ |= 0x00000008;
          }
          if (((from_bitField0_ & 0x00000020) != 0)) {
            to_bitField0_ |= 0x00000010;
          }
          result.encryptedAdvertisingId_ = encryptedAdvertisingId_;
          if (((from_bitField0_ & 0x00000040) != 0)) {
            to_bitField0_ |= 0x00000020;
          }
          result.advertisingId_ = advertisingId_;
          if (((from_bitField0_ & 0x00000080) != 0)) {
            to_bitField0_ |= 0x00000040;
          }
          result.encryptedHashedIdfa_ = encryptedHashedIdfa_;
          if (((from_bitField0_ & 0x00000100) != 0)) {
            to_bitField0_ |= 0x00000080;
          }
          result.hashedIdfa_ = hashedIdfa_;
          if (((from_bitField0_ & 0x00000200) != 0)) {
            to_bitField0_ |= 0x00000100;
          }
          result.appName_ = appName_;
          if (((from_bitField0_ & 0x00000400) != 0)) {
            result.appRating_ = appRating_;
            to_bitField0_ |= 0x00000200;
          }
          if (installedSdkBuilder_ == null) {
            if (((bitField0_ & 0x00000800) != 0)) {
              installedSdk_ = java.util.Collections.unmodifiableList(installedSdk_);
              bitField0_ = (bitField0_ & ~0x00000800);
            }
            result.installedSdk_ = installedSdk_;
          } else {
            result.installedSdk_ = installedSdkBuilder_.build();
          }
          if (((from_bitField0_ & 0x00001000) != 0)) {
            if (skadnBuilder_ == null) {
              result.skadn_ = skadn_;
            } else {
              result.skadn_ = skadnBuilder_.build();
            }
            to_bitField0_ |= 0x00000400;
          }
          result.bitField0_ = to_bitField0_;
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }
        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.setField(field, value);
        }
        @java.lang.Override
        public Builder clearField(
            com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }
        @java.lang.Override
        public Builder clearOneof(
            com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }
        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index, java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }
        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }
        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.protos.adx.NetworkBid.BidRequest.Mobile) {
            return mergeFrom((com.google.protos.adx.NetworkBid.BidRequest.Mobile)other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.google.protos.adx.NetworkBid.BidRequest.Mobile other) {
          if (other == com.google.protos.adx.NetworkBid.BidRequest.Mobile.getDefaultInstance()) return this;
          if (other.hasIsApp()) {
            setIsApp(other.getIsApp());
          }
          if (other.hasAppId()) {
            bitField0_ |= 0x00000002;
            appId_ = other.appId_;
            onChanged();
          }
          if (other.hasIsInterstitialRequest()) {
            setIsInterstitialRequest(other.getIsInterstitialRequest());
          }
          if (!other.appCategoryIds_.isEmpty()) {
            if (appCategoryIds_.isEmpty()) {
              appCategoryIds_ = other.appCategoryIds_;
              bitField0_ = (bitField0_ & ~0x00000008);
            } else {
              ensureAppCategoryIdsIsMutable();
              appCategoryIds_.addAll(other.appCategoryIds_);
            }
            onChanged();
          }
          if (other.hasIsMobileWebOptimized()) {
            setIsMobileWebOptimized(other.getIsMobileWebOptimized());
          }
          if (other.hasEncryptedAdvertisingId()) {
            setEncryptedAdvertisingId(other.getEncryptedAdvertisingId());
          }
          if (other.hasAdvertisingId()) {
            setAdvertisingId(other.getAdvertisingId());
          }
          if (other.hasEncryptedHashedIdfa()) {
            setEncryptedHashedIdfa(other.getEncryptedHashedIdfa());
          }
          if (other.hasHashedIdfa()) {
            setHashedIdfa(other.getHashedIdfa());
          }
          if (other.hasAppName()) {
            bitField0_ |= 0x00000200;
            appName_ = other.appName_;
            onChanged();
          }
          if (other.hasAppRating()) {
            setAppRating(other.getAppRating());
          }
          if (installedSdkBuilder_ == null) {
            if (!other.installedSdk_.isEmpty()) {
              if (installedSdk_.isEmpty()) {
                installedSdk_ = other.installedSdk_;
                bitField0_ = (bitField0_ & ~0x00000800);
              } else {
                ensureInstalledSdkIsMutable();
                installedSdk_.addAll(other.installedSdk_);
              }
              onChanged();
            }
          } else {
            if (!other.installedSdk_.isEmpty()) {
              if (installedSdkBuilder_.isEmpty()) {
                installedSdkBuilder_.dispose();
                installedSdkBuilder_ = null;
                installedSdk_ = other.installedSdk_;
                bitField0_ = (bitField0_ & ~0x00000800);
                installedSdkBuilder_ = 
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                     getInstalledSdkFieldBuilder() : null;
              } else {
                installedSdkBuilder_.addAllMessages(other.installedSdk_);
              }
            }
          }
          if (other.hasSkadn()) {
            mergeSkadn(other.getSkadn());
          }
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          com.google.protos.adx.NetworkBid.BidRequest.Mobile parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage = (com.google.protos.adx.NetworkBid.BidRequest.Mobile) e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }
        private int bitField0_;

        private boolean isApp_ ;
        /**
         * <pre>
         * If true, then this request is from a mobile application. For branded
         * requests, app_id will also be filled in. If the request is from a mobile
         * web page contained inside an app, is_app will still be false, but app_id
         * could be filled in with the app identifier. For SDK-less requests (mostly
         * from connected TVs), this will be true if an app ID is provided directly
         * in the request.
         * </pre>
         *
         * <code>optional bool is_app = 7 [default = false];</code>
         * @return Whether the isApp field is set.
         */
        @java.lang.Override
        public boolean hasIsApp() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         * <pre>
         * If true, then this request is from a mobile application. For branded
         * requests, app_id will also be filled in. If the request is from a mobile
         * web page contained inside an app, is_app will still be false, but app_id
         * could be filled in with the app identifier. For SDK-less requests (mostly
         * from connected TVs), this will be true if an app ID is provided directly
         * in the request.
         * </pre>
         *
         * <code>optional bool is_app = 7 [default = false];</code>
         * @return The isApp.
         */
        @java.lang.Override
        public boolean getIsApp() {
          return isApp_;
        }
        /**
         * <pre>
         * If true, then this request is from a mobile application. For branded
         * requests, app_id will also be filled in. If the request is from a mobile
         * web page contained inside an app, is_app will still be false, but app_id
         * could be filled in with the app identifier. For SDK-less requests (mostly
         * from connected TVs), this will be true if an app ID is provided directly
         * in the request.
         * </pre>
         *
         * <code>optional bool is_app = 7 [default = false];</code>
         * @param value The isApp to set.
         * @return This builder for chaining.
         */
        public Builder setIsApp(boolean value) {
          bitField0_ |= 0x00000001;
          isApp_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * If true, then this request is from a mobile application. For branded
         * requests, app_id will also be filled in. If the request is from a mobile
         * web page contained inside an app, is_app will still be false, but app_id
         * could be filled in with the app identifier. For SDK-less requests (mostly
         * from connected TVs), this will be true if an app ID is provided directly
         * in the request.
         * </pre>
         *
         * <code>optional bool is_app = 7 [default = false];</code>
         * @return This builder for chaining.
         */
        public Builder clearIsApp() {
          bitField0_ = (bitField0_ & ~0x00000001);
          isApp_ = false;
          onChanged();
          return this;
        }

        private java.lang.Object appId_ = "";
        /**
         * <pre>
         * The identifier of the mobile app when this ad query comes from a mobile
         * app, or from a mobile web page contained inside an app. If the app was
         * downloaded from the Apple iTunes app store, then this is the app-store
         * id, e.g., 343200656. For Android devices, this is the fully qualified
         * package name, e.g., com.rovio.angrybirds. For Windows devices it's the
         * App ID, e.g., f15abcde-f6gh-47i0-j3k8-37l93817mn3o. For SDK-less requests
         * (mostly from connected TVs), the app ID provided by the publisher
         * directly in the request.
         * </pre>
         *
         * <code>optional string app_id = 6;</code>
         * @return Whether the appId field is set.
         */
        public boolean hasAppId() {
          return ((bitField0_ & 0x00000002) != 0);
        }
        /**
         * <pre>
         * The identifier of the mobile app when this ad query comes from a mobile
         * app, or from a mobile web page contained inside an app. If the app was
         * downloaded from the Apple iTunes app store, then this is the app-store
         * id, e.g., 343200656. For Android devices, this is the fully qualified
         * package name, e.g., com.rovio.angrybirds. For Windows devices it's the
         * App ID, e.g., f15abcde-f6gh-47i0-j3k8-37l93817mn3o. For SDK-less requests
         * (mostly from connected TVs), the app ID provided by the publisher
         * directly in the request.
         * </pre>
         *
         * <code>optional string app_id = 6;</code>
         * @return The appId.
         */
        public java.lang.String getAppId() {
          java.lang.Object ref = appId_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs =
                (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            if (bs.isValidUtf8()) {
              appId_ = s;
            }
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         * <pre>
         * The identifier of the mobile app when this ad query comes from a mobile
         * app, or from a mobile web page contained inside an app. If the app was
         * downloaded from the Apple iTunes app store, then this is the app-store
         * id, e.g., 343200656. For Android devices, this is the fully qualified
         * package name, e.g., com.rovio.angrybirds. For Windows devices it's the
         * App ID, e.g., f15abcde-f6gh-47i0-j3k8-37l93817mn3o. For SDK-less requests
         * (mostly from connected TVs), the app ID provided by the publisher
         * directly in the request.
         * </pre>
         *
         * <code>optional string app_id = 6;</code>
         * @return The bytes for appId.
         */
        public com.google.protobuf.ByteString
            getAppIdBytes() {
          java.lang.Object ref = appId_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b = 
                com.google.protobuf.ByteString.copyFromUtf8(
                    (java.lang.String) ref);
            appId_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         * <pre>
         * The identifier of the mobile app when this ad query comes from a mobile
         * app, or from a mobile web page contained inside an app. If the app was
         * downloaded from the Apple iTunes app store, then this is the app-store
         * id, e.g., 343200656. For Android devices, this is the fully qualified
         * package name, e.g., com.rovio.angrybirds. For Windows devices it's the
         * App ID, e.g., f15abcde-f6gh-47i0-j3k8-37l93817mn3o. For SDK-less requests
         * (mostly from connected TVs), the app ID provided by the publisher
         * directly in the request.
         * </pre>
         *
         * <code>optional string app_id = 6;</code>
         * @param value The appId to set.
         * @return This builder for chaining.
         */
        public Builder setAppId(
            java.lang.String value) {
          if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
          appId_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * The identifier of the mobile app when this ad query comes from a mobile
         * app, or from a mobile web page contained inside an app. If the app was
         * downloaded from the Apple iTunes app store, then this is the app-store
         * id, e.g., 343200656. For Android devices, this is the fully qualified
         * package name, e.g., com.rovio.angrybirds. For Windows devices it's the
         * App ID, e.g., f15abcde-f6gh-47i0-j3k8-37l93817mn3o. For SDK-less requests
         * (mostly from connected TVs), the app ID provided by the publisher
         * directly in the request.
         * </pre>
         *
         * <code>optional string app_id = 6;</code>
         * @return This builder for chaining.
         */
        public Builder clearAppId() {
          bitField0_ = (bitField0_ & ~0x00000002);
          appId_ = getDefaultInstance().getAppId();
          onChanged();
          return this;
        }
        /**
         * <pre>
         * The identifier of the mobile app when this ad query comes from a mobile
         * app, or from a mobile web page contained inside an app. If the app was
         * downloaded from the Apple iTunes app store, then this is the app-store
         * id, e.g., 343200656. For Android devices, this is the fully qualified
         * package name, e.g., com.rovio.angrybirds. For Windows devices it's the
         * App ID, e.g., f15abcde-f6gh-47i0-j3k8-37l93817mn3o. For SDK-less requests
         * (mostly from connected TVs), the app ID provided by the publisher
         * directly in the request.
         * </pre>
         *
         * <code>optional string app_id = 6;</code>
         * @param value The bytes for appId to set.
         * @return This builder for chaining.
         */
        public Builder setAppIdBytes(
            com.google.protobuf.ByteString value) {
          if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
          appId_ = value;
          onChanged();
          return this;
        }

        private boolean isInterstitialRequest_ ;
        /**
         * <pre>
         * If true, then this is a mobile full screen ad request.
         * </pre>
         *
         * <code>optional bool is_interstitial_request = 10 [default = false];</code>
         * @return Whether the isInterstitialRequest field is set.
         */
        @java.lang.Override
        public boolean hasIsInterstitialRequest() {
          return ((bitField0_ & 0x00000004) != 0);
        }
        /**
         * <pre>
         * If true, then this is a mobile full screen ad request.
         * </pre>
         *
         * <code>optional bool is_interstitial_request = 10 [default = false];</code>
         * @return The isInterstitialRequest.
         */
        @java.lang.Override
        public boolean getIsInterstitialRequest() {
          return isInterstitialRequest_;
        }
        /**
         * <pre>
         * If true, then this is a mobile full screen ad request.
         * </pre>
         *
         * <code>optional bool is_interstitial_request = 10 [default = false];</code>
         * @param value The isInterstitialRequest to set.
         * @return This builder for chaining.
         */
        public Builder setIsInterstitialRequest(boolean value) {
          bitField0_ |= 0x00000004;
          isInterstitialRequest_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * If true, then this is a mobile full screen ad request.
         * </pre>
         *
         * <code>optional bool is_interstitial_request = 10 [default = false];</code>
         * @return This builder for chaining.
         */
        public Builder clearIsInterstitialRequest() {
          bitField0_ = (bitField0_ & ~0x00000004);
          isInterstitialRequest_ = false;
          onChanged();
          return this;
        }

        private com.google.protobuf.Internal.IntList appCategoryIds_ = emptyIntList();
        private void ensureAppCategoryIdsIsMutable() {
          if (!((bitField0_ & 0x00000008) != 0)) {
            appCategoryIds_ = mutableCopy(appCategoryIds_);
            bitField0_ |= 0x00000008;
           }
        }
        /**
         * <pre>
         * This field contains the IDs of categories to which the current mobile app
         * belongs. This field will be empty if is_app is false. The mapping between
         * mobile apps and categories is defined by the Google Play Store for
         * Android apps, or the Apple iTunes Store for iOS apps. To look up category
         * name from category ID, please refer to
         * https://developers.google.com/google-ads/api/reference/data/codes-formats#mobile_app_categories
         * </pre>
         *
         * <code>repeated int32 app_category_ids = 11;</code>
         * @return A list containing the appCategoryIds.
         */
        public java.util.List<java.lang.Integer>
            getAppCategoryIdsList() {
          return ((bitField0_ & 0x00000008) != 0) ?
                   java.util.Collections.unmodifiableList(appCategoryIds_) : appCategoryIds_;
        }
        /**
         * <pre>
         * This field contains the IDs of categories to which the current mobile app
         * belongs. This field will be empty if is_app is false. The mapping between
         * mobile apps and categories is defined by the Google Play Store for
         * Android apps, or the Apple iTunes Store for iOS apps. To look up category
         * name from category ID, please refer to
         * https://developers.google.com/google-ads/api/reference/data/codes-formats#mobile_app_categories
         * </pre>
         *
         * <code>repeated int32 app_category_ids = 11;</code>
         * @return The count of appCategoryIds.
         */
        public int getAppCategoryIdsCount() {
          return appCategoryIds_.size();
        }
        /**
         * <pre>
         * This field contains the IDs of categories to which the current mobile app
         * belongs. This field will be empty if is_app is false. The mapping between
         * mobile apps and categories is defined by the Google Play Store for
         * Android apps, or the Apple iTunes Store for iOS apps. To look up category
         * name from category ID, please refer to
         * https://developers.google.com/google-ads/api/reference/data/codes-formats#mobile_app_categories
         * </pre>
         *
         * <code>repeated int32 app_category_ids = 11;</code>
         * @param index The index of the element to return.
         * @return The appCategoryIds at the given index.
         */
        public int getAppCategoryIds(int index) {
          return appCategoryIds_.getInt(index);
        }
        /**
         * <pre>
         * This field contains the IDs of categories to which the current mobile app
         * belongs. This field will be empty if is_app is false. The mapping between
         * mobile apps and categories is defined by the Google Play Store for
         * Android apps, or the Apple iTunes Store for iOS apps. To look up category
         * name from category ID, please refer to
         * https://developers.google.com/google-ads/api/reference/data/codes-formats#mobile_app_categories
         * </pre>
         *
         * <code>repeated int32 app_category_ids = 11;</code>
         * @param index The index to set the value at.
         * @param value The appCategoryIds to set.
         * @return This builder for chaining.
         */
        public Builder setAppCategoryIds(
            int index, int value) {
          ensureAppCategoryIdsIsMutable();
          appCategoryIds_.setInt(index, value);
          onChanged();
          return this;
        }
        /**
         * <pre>
         * This field contains the IDs of categories to which the current mobile app
         * belongs. This field will be empty if is_app is false. The mapping between
         * mobile apps and categories is defined by the Google Play Store for
         * Android apps, or the Apple iTunes Store for iOS apps. To look up category
         * name from category ID, please refer to
         * https://developers.google.com/google-ads/api/reference/data/codes-formats#mobile_app_categories
         * </pre>
         *
         * <code>repeated int32 app_category_ids = 11;</code>
         * @param value The appCategoryIds to add.
         * @return This builder for chaining.
         */
        public Builder addAppCategoryIds(int value) {
          ensureAppCategoryIdsIsMutable();
          appCategoryIds_.addInt(value);
          onChanged();
          return this;
        }
        /**
         * <pre>
         * This field contains the IDs of categories to which the current mobile app
         * belongs. This field will be empty if is_app is false. The mapping between
         * mobile apps and categories is defined by the Google Play Store for
         * Android apps, or the Apple iTunes Store for iOS apps. To look up category
         * name from category ID, please refer to
         * https://developers.google.com/google-ads/api/reference/data/codes-formats#mobile_app_categories
         * </pre>
         *
         * <code>repeated int32 app_category_ids = 11;</code>
         * @param values The appCategoryIds to add.
         * @return This builder for chaining.
         */
        public Builder addAllAppCategoryIds(
            java.lang.Iterable<? extends java.lang.Integer> values) {
          ensureAppCategoryIdsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, appCategoryIds_);
          onChanged();
          return this;
        }
        /**
         * <pre>
         * This field contains the IDs of categories to which the current mobile app
         * belongs. This field will be empty if is_app is false. The mapping between
         * mobile apps and categories is defined by the Google Play Store for
         * Android apps, or the Apple iTunes Store for iOS apps. To look up category
         * name from category ID, please refer to
         * https://developers.google.com/google-ads/api/reference/data/codes-formats#mobile_app_categories
         * </pre>
         *
         * <code>repeated int32 app_category_ids = 11;</code>
         * @return This builder for chaining.
         */
        public Builder clearAppCategoryIds() {
          appCategoryIds_ = emptyIntList();
          bitField0_ = (bitField0_ & ~0x00000008);
          onChanged();
          return this;
        }

        private boolean isMobileWebOptimized_ ;
        /**
         * <pre>
         * For a mobile web request, this field indicates whether the page is
         * optimized for mobile browsers on high-end mobile phones.
         * </pre>
         *
         * <code>optional bool is_mobile_web_optimized = 17 [default = false];</code>
         * @return Whether the isMobileWebOptimized field is set.
         */
        @java.lang.Override
        public boolean hasIsMobileWebOptimized() {
          return ((bitField0_ & 0x00000010) != 0);
        }
        /**
         * <pre>
         * For a mobile web request, this field indicates whether the page is
         * optimized for mobile browsers on high-end mobile phones.
         * </pre>
         *
         * <code>optional bool is_mobile_web_optimized = 17 [default = false];</code>
         * @return The isMobileWebOptimized.
         */
        @java.lang.Override
        public boolean getIsMobileWebOptimized() {
          return isMobileWebOptimized_;
        }
        /**
         * <pre>
         * For a mobile web request, this field indicates whether the page is
         * optimized for mobile browsers on high-end mobile phones.
         * </pre>
         *
         * <code>optional bool is_mobile_web_optimized = 17 [default = false];</code>
         * @param value The isMobileWebOptimized to set.
         * @return This builder for chaining.
         */
        public Builder setIsMobileWebOptimized(boolean value) {
          bitField0_ |= 0x00000010;
          isMobileWebOptimized_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * For a mobile web request, this field indicates whether the page is
         * optimized for mobile browsers on high-end mobile phones.
         * </pre>
         *
         * <code>optional bool is_mobile_web_optimized = 17 [default = false];</code>
         * @return This builder for chaining.
         */
        public Builder clearIsMobileWebOptimized() {
          bitField0_ = (bitField0_ & ~0x00000010);
          isMobileWebOptimized_ = false;
          onChanged();
          return this;
        }

        private com.google.protobuf.ByteString encryptedAdvertisingId_ = com.google.protobuf.ByteString.EMPTY;
        /**
         * <pre>
         * This field is used for advertising identifiers for
         * 1) iOS devices (This is called Identifier for Advertising, or IDFA, as
         * described at https://support.google.com/authorizedbuyers/answer/3221407),
         * 2) Android devices,
         * 3) Roku devices,
         * 4) Microsoft Xbox devices,
         * 5) Amazon devices (i.e. Amazon Fire).
         * When the encrypted_advertising_id is an IDFA, the plaintext after
         * decrypting the ciphertext is the IDFA (16 byte UUID) returned by iOS's
         * [ASIdentifierManager advertisingIdentifier]. For encrypted_hashed_idfa,
         * the plaintext is the 16 byte MD5 hash of the IDFA. Only one of the two
         * fields will be available, depending on the version of the SDK making the
         * request. Later SDKs provide unhashed values. They are not set if there is
         * one or more user_data_treatment value in the BidRequest.
         * </pre>
         *
         * <code>optional bytes encrypted_advertising_id = 20;</code>
         * @return Whether the encryptedAdvertisingId field is set.
         */
        @java.lang.Override
        public boolean hasEncryptedAdvertisingId() {
          return ((bitField0_ & 0x00000020) != 0);
        }
        /**
         * <pre>
         * This field is used for advertising identifiers for
         * 1) iOS devices (This is called Identifier for Advertising, or IDFA, as
         * described at https://support.google.com/authorizedbuyers/answer/3221407),
         * 2) Android devices,
         * 3) Roku devices,
         * 4) Microsoft Xbox devices,
         * 5) Amazon devices (i.e. Amazon Fire).
         * When the encrypted_advertising_id is an IDFA, the plaintext after
         * decrypting the ciphertext is the IDFA (16 byte UUID) returned by iOS's
         * [ASIdentifierManager advertisingIdentifier]. For encrypted_hashed_idfa,
         * the plaintext is the 16 byte MD5 hash of the IDFA. Only one of the two
         * fields will be available, depending on the version of the SDK making the
         * request. Later SDKs provide unhashed values. They are not set if there is
         * one or more user_data_treatment value in the BidRequest.
         * </pre>
         *
         * <code>optional bytes encrypted_advertising_id = 20;</code>
         * @return The encryptedAdvertisingId.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getEncryptedAdvertisingId() {
          return encryptedAdvertisingId_;
        }
        /**
         * <pre>
         * This field is used for advertising identifiers for
         * 1) iOS devices (This is called Identifier for Advertising, or IDFA, as
         * described at https://support.google.com/authorizedbuyers/answer/3221407),
         * 2) Android devices,
         * 3) Roku devices,
         * 4) Microsoft Xbox devices,
         * 5) Amazon devices (i.e. Amazon Fire).
         * When the encrypted_advertising_id is an IDFA, the plaintext after
         * decrypting the ciphertext is the IDFA (16 byte UUID) returned by iOS's
         * [ASIdentifierManager advertisingIdentifier]. For encrypted_hashed_idfa,
         * the plaintext is the 16 byte MD5 hash of the IDFA. Only one of the two
         * fields will be available, depending on the version of the SDK making the
         * request. Later SDKs provide unhashed values. They are not set if there is
         * one or more user_data_treatment value in the BidRequest.
         * </pre>
         *
         * <code>optional bytes encrypted_advertising_id = 20;</code>
         * @param value The encryptedAdvertisingId to set.
         * @return This builder for chaining.
         */
        public Builder setEncryptedAdvertisingId(com.google.protobuf.ByteString value) {
          if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000020;
          encryptedAdvertisingId_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * This field is used for advertising identifiers for
         * 1) iOS devices (This is called Identifier for Advertising, or IDFA, as
         * described at https://support.google.com/authorizedbuyers/answer/3221407),
         * 2) Android devices,
         * 3) Roku devices,
         * 4) Microsoft Xbox devices,
         * 5) Amazon devices (i.e. Amazon Fire).
         * When the encrypted_advertising_id is an IDFA, the plaintext after
         * decrypting the ciphertext is the IDFA (16 byte UUID) returned by iOS's
         * [ASIdentifierManager advertisingIdentifier]. For encrypted_hashed_idfa,
         * the plaintext is the 16 byte MD5 hash of the IDFA. Only one of the two
         * fields will be available, depending on the version of the SDK making the
         * request. Later SDKs provide unhashed values. They are not set if there is
         * one or more user_data_treatment value in the BidRequest.
         * </pre>
         *
         * <code>optional bytes encrypted_advertising_id = 20;</code>
         * @return This builder for chaining.
         */
        public Builder clearEncryptedAdvertisingId() {
          bitField0_ = (bitField0_ & ~0x00000020);
          encryptedAdvertisingId_ = getDefaultInstance().getEncryptedAdvertisingId();
          onChanged();
          return this;
        }

        private com.google.protobuf.ByteString advertisingId_ = com.google.protobuf.ByteString.EMPTY;
        /**
         * <pre>
         * Unencrypted version of encrypted_advertising_id. This field is only set
         * when using an SSL connection. This field is a 16 byte UUID (binary form)
         * or a 32 byte alphanumeric id (such as Samsung ID).
         * </pre>
         *
         * <code>optional bytes advertising_id = 27;</code>
         * @return Whether the advertisingId field is set.
         */
        @java.lang.Override
        public boolean hasAdvertisingId() {
          return ((bitField0_ & 0x00000040) != 0);
        }
        /**
         * <pre>
         * Unencrypted version of encrypted_advertising_id. This field is only set
         * when using an SSL connection. This field is a 16 byte UUID (binary form)
         * or a 32 byte alphanumeric id (such as Samsung ID).
         * </pre>
         *
         * <code>optional bytes advertising_id = 27;</code>
         * @return The advertisingId.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getAdvertisingId() {
          return advertisingId_;
        }
        /**
         * <pre>
         * Unencrypted version of encrypted_advertising_id. This field is only set
         * when using an SSL connection. This field is a 16 byte UUID (binary form)
         * or a 32 byte alphanumeric id (such as Samsung ID).
         * </pre>
         *
         * <code>optional bytes advertising_id = 27;</code>
         * @param value The advertisingId to set.
         * @return This builder for chaining.
         */
        public Builder setAdvertisingId(com.google.protobuf.ByteString value) {
          if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000040;
          advertisingId_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Unencrypted version of encrypted_advertising_id. This field is only set
         * when using an SSL connection. This field is a 16 byte UUID (binary form)
         * or a 32 byte alphanumeric id (such as Samsung ID).
         * </pre>
         *
         * <code>optional bytes advertising_id = 27;</code>
         * @return This builder for chaining.
         */
        public Builder clearAdvertisingId() {
          bitField0_ = (bitField0_ & ~0x00000040);
          advertisingId_ = getDefaultInstance().getAdvertisingId();
          onChanged();
          return this;
        }

        private com.google.protobuf.ByteString encryptedHashedIdfa_ = com.google.protobuf.ByteString.EMPTY;
        /**
         * <code>optional bytes encrypted_hashed_idfa = 21;</code>
         * @return Whether the encryptedHashedIdfa field is set.
         */
        @java.lang.Override
        public boolean hasEncryptedHashedIdfa() {
          return ((bitField0_ & 0x00000080) != 0);
        }
        /**
         * <code>optional bytes encrypted_hashed_idfa = 21;</code>
         * @return The encryptedHashedIdfa.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getEncryptedHashedIdfa() {
          return encryptedHashedIdfa_;
        }
        /**
         * <code>optional bytes encrypted_hashed_idfa = 21;</code>
         * @param value The encryptedHashedIdfa to set.
         * @return This builder for chaining.
         */
        public Builder setEncryptedHashedIdfa(com.google.protobuf.ByteString value) {
          if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000080;
          encryptedHashedIdfa_ = value;
          onChanged();
          return this;
        }
        /**
         * <code>optional bytes encrypted_hashed_idfa = 21;</code>
         * @return This builder for chaining.
         */
        public Builder clearEncryptedHashedIdfa() {
          bitField0_ = (bitField0_ & ~0x00000080);
          encryptedHashedIdfa_ = getDefaultInstance().getEncryptedHashedIdfa();
          onChanged();
          return this;
        }

        private com.google.protobuf.ByteString hashedIdfa_ = com.google.protobuf.ByteString.EMPTY;
        /**
         * <pre>
         * Unencrypted version of encrypted_hashed_idfa. This field is only set
         * when using an SSL connection. This field is a 16 byte MD5.
         * </pre>
         *
         * <code>optional bytes hashed_idfa = 28;</code>
         * @return Whether the hashedIdfa field is set.
         */
        @java.lang.Override
        public boolean hasHashedIdfa() {
          return ((bitField0_ & 0x00000100) != 0);
        }
        /**
         * <pre>
         * Unencrypted version of encrypted_hashed_idfa. This field is only set
         * when using an SSL connection. This field is a 16 byte MD5.
         * </pre>
         *
         * <code>optional bytes hashed_idfa = 28;</code>
         * @return The hashedIdfa.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getHashedIdfa() {
          return hashedIdfa_;
        }
        /**
         * <pre>
         * Unencrypted version of encrypted_hashed_idfa. This field is only set
         * when using an SSL connection. This field is a 16 byte MD5.
         * </pre>
         *
         * <code>optional bytes hashed_idfa = 28;</code>
         * @param value The hashedIdfa to set.
         * @return This builder for chaining.
         */
        public Builder setHashedIdfa(com.google.protobuf.ByteString value) {
          if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000100;
          hashedIdfa_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Unencrypted version of encrypted_hashed_idfa. This field is only set
         * when using an SSL connection. This field is a 16 byte MD5.
         * </pre>
         *
         * <code>optional bytes hashed_idfa = 28;</code>
         * @return This builder for chaining.
         */
        public Builder clearHashedIdfa() {
          bitField0_ = (bitField0_ & ~0x00000100);
          hashedIdfa_ = getDefaultInstance().getHashedIdfa();
          onChanged();
          return this;
        }

        private java.lang.Object appName_ = "";
        /**
         * <pre>
         * App names for Android apps are from the Google Play store.
         * App names for iOS apps are provided by App Annie
         * (https://www.appannie.com). App names for SDK-less requests (mostly from
         * connected TVs) are provided by the publisher directly in the request.
         * </pre>
         *
         * <code>optional string app_name = 24;</code>
         * @return Whether the appName field is set.
         */
        public boolean hasAppName() {
          return ((bitField0_ & 0x00000200) != 0);
        }
        /**
         * <pre>
         * App names for Android apps are from the Google Play store.
         * App names for iOS apps are provided by App Annie
         * (https://www.appannie.com). App names for SDK-less requests (mostly from
         * connected TVs) are provided by the publisher directly in the request.
         * </pre>
         *
         * <code>optional string app_name = 24;</code>
         * @return The appName.
         */
        public java.lang.String getAppName() {
          java.lang.Object ref = appName_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs =
                (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            if (bs.isValidUtf8()) {
              appName_ = s;
            }
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         * <pre>
         * App names for Android apps are from the Google Play store.
         * App names for iOS apps are provided by App Annie
         * (https://www.appannie.com). App names for SDK-less requests (mostly from
         * connected TVs) are provided by the publisher directly in the request.
         * </pre>
         *
         * <code>optional string app_name = 24;</code>
         * @return The bytes for appName.
         */
        public com.google.protobuf.ByteString
            getAppNameBytes() {
          java.lang.Object ref = appName_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b = 
                com.google.protobuf.ByteString.copyFromUtf8(
                    (java.lang.String) ref);
            appName_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         * <pre>
         * App names for Android apps are from the Google Play store.
         * App names for iOS apps are provided by App Annie
         * (https://www.appannie.com). App names for SDK-less requests (mostly from
         * connected TVs) are provided by the publisher directly in the request.
         * </pre>
         *
         * <code>optional string app_name = 24;</code>
         * @param value The appName to set.
         * @return This builder for chaining.
         */
        public Builder setAppName(
            java.lang.String value) {
          if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000200;
          appName_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * App names for Android apps are from the Google Play store.
         * App names for iOS apps are provided by App Annie
         * (https://www.appannie.com). App names for SDK-less requests (mostly from
         * connected TVs) are provided by the publisher directly in the request.
         * </pre>
         *
         * <code>optional string app_name = 24;</code>
         * @return This builder for chaining.
         */
        public Builder clearAppName() {
          bitField0_ = (bitField0_ & ~0x00000200);
          appName_ = getDefaultInstance().getAppName();
          onChanged();
          return this;
        }
        /**
         * <pre>
         * App names for Android apps are from the Google Play store.
         * App names for iOS apps are provided by App Annie
         * (https://www.appannie.com). App names for SDK-less requests (mostly from
         * connected TVs) are provided by the publisher directly in the request.
         * </pre>
         *
         * <code>optional string app_name = 24;</code>
         * @param value The bytes for appName to set.
         * @return This builder for chaining.
         */
        public Builder setAppNameBytes(
            com.google.protobuf.ByteString value) {
          if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000200;
          appName_ = value;
          onChanged();
          return this;
        }

        private float appRating_ ;
        /**
         * <pre>
         * Average user rating for the app. The range of user rating is between 1.0
         * and 5.0. Currently only available for apps in Google Play store.
         * </pre>
         *
         * <code>optional float app_rating = 25;</code>
         * @return Whether the appRating field is set.
         */
        @java.lang.Override
        public boolean hasAppRating() {
          return ((bitField0_ & 0x00000400) != 0);
        }
        /**
         * <pre>
         * Average user rating for the app. The range of user rating is between 1.0
         * and 5.0. Currently only available for apps in Google Play store.
         * </pre>
         *
         * <code>optional float app_rating = 25;</code>
         * @return The appRating.
         */
        @java.lang.Override
        public float getAppRating() {
          return appRating_;
        }
        /**
         * <pre>
         * Average user rating for the app. The range of user rating is between 1.0
         * and 5.0. Currently only available for apps in Google Play store.
         * </pre>
         *
         * <code>optional float app_rating = 25;</code>
         * @param value The appRating to set.
         * @return This builder for chaining.
         */
        public Builder setAppRating(float value) {
          bitField0_ |= 0x00000400;
          appRating_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Average user rating for the app. The range of user rating is between 1.0
         * and 5.0. Currently only available for apps in Google Play store.
         * </pre>
         *
         * <code>optional float app_rating = 25;</code>
         * @return This builder for chaining.
         */
        public Builder clearAppRating() {
          bitField0_ = (bitField0_ & ~0x00000400);
          appRating_ = 0F;
          onChanged();
          return this;
        }

        private java.util.List<com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk> installedSdk_ =
          java.util.Collections.emptyList();
        private void ensureInstalledSdkIsMutable() {
          if (!((bitField0_ & 0x00000800) != 0)) {
            installedSdk_ = new java.util.ArrayList<com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk>(installedSdk_);
            bitField0_ |= 0x00000800;
           }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk, com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Builder, com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdkOrBuilder> installedSdkBuilder_;

        /**
         * <code>repeated .com.google.protos.adx.BidRequest.Mobile.InstalledSdk installed_sdk = 32;</code>
         */
        public java.util.List<com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk> getInstalledSdkList() {
          if (installedSdkBuilder_ == null) {
            return java.util.Collections.unmodifiableList(installedSdk_);
          } else {
            return installedSdkBuilder_.getMessageList();
          }
        }
        /**
         * <code>repeated .com.google.protos.adx.BidRequest.Mobile.InstalledSdk installed_sdk = 32;</code>
         */
        public int getInstalledSdkCount() {
          if (installedSdkBuilder_ == null) {
            return installedSdk_.size();
          } else {
            return installedSdkBuilder_.getCount();
          }
        }
        /**
         * <code>repeated .com.google.protos.adx.BidRequest.Mobile.InstalledSdk installed_sdk = 32;</code>
         */
        public com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk getInstalledSdk(int index) {
          if (installedSdkBuilder_ == null) {
            return installedSdk_.get(index);
          } else {
            return installedSdkBuilder_.getMessage(index);
          }
        }
        /**
         * <code>repeated .com.google.protos.adx.BidRequest.Mobile.InstalledSdk installed_sdk = 32;</code>
         */
        public Builder setInstalledSdk(
            int index, com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk value) {
          if (installedSdkBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureInstalledSdkIsMutable();
            installedSdk_.set(index, value);
            onChanged();
          } else {
            installedSdkBuilder_.setMessage(index, value);
          }
          return this;
        }
        /**
         * <code>repeated .com.google.protos.adx.BidRequest.Mobile.InstalledSdk installed_sdk = 32;</code>
         */
        public Builder setInstalledSdk(
            int index, com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Builder builderForValue) {
          if (installedSdkBuilder_ == null) {
            ensureInstalledSdkIsMutable();
            installedSdk_.set(index, builderForValue.build());
            onChanged();
          } else {
            installedSdkBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         * <code>repeated .com.google.protos.adx.BidRequest.Mobile.InstalledSdk installed_sdk = 32;</code>
         */
        public Builder addInstalledSdk(com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk value) {
          if (installedSdkBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureInstalledSdkIsMutable();
            installedSdk_.add(value);
            onChanged();
          } else {
            installedSdkBuilder_.addMessage(value);
          }
          return this;
        }
        /**
         * <code>repeated .com.google.protos.adx.BidRequest.Mobile.InstalledSdk installed_sdk = 32;</code>
         */
        public Builder addInstalledSdk(
            int index, com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk value) {
          if (installedSdkBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureInstalledSdkIsMutable();
            installedSdk_.add(index, value);
            onChanged();
          } else {
            installedSdkBuilder_.addMessage(index, value);
          }
          return this;
        }
        /**
         * <code>repeated .com.google.protos.adx.BidRequest.Mobile.InstalledSdk installed_sdk = 32;</code>
         */
        public Builder addInstalledSdk(
            com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Builder builderForValue) {
          if (installedSdkBuilder_ == null) {
            ensureInstalledSdkIsMutable();
            installedSdk_.add(builderForValue.build());
            onChanged();
          } else {
            installedSdkBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }
        /**
         * <code>repeated .com.google.protos.adx.BidRequest.Mobile.InstalledSdk installed_sdk = 32;</code>
         */
        public Builder addInstalledSdk(
            int index, com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Builder builderForValue) {
          if (installedSdkBuilder_ == null) {
            ensureInstalledSdkIsMutable();
            installedSdk_.add(index, builderForValue.build());
            onChanged();
          } else {
            installedSdkBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         * <code>repeated .com.google.protos.adx.BidRequest.Mobile.InstalledSdk installed_sdk = 32;</code>
         */
        public Builder addAllInstalledSdk(
            java.lang.Iterable<? extends com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk> values) {
          if (installedSdkBuilder_ == null) {
            ensureInstalledSdkIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(
                values, installedSdk_);
            onChanged();
          } else {
            installedSdkBuilder_.addAllMessages(values);
          }
          return this;
        }
        /**
         * <code>repeated .com.google.protos.adx.BidRequest.Mobile.InstalledSdk installed_sdk = 32;</code>
         */
        public Builder clearInstalledSdk() {
          if (installedSdkBuilder_ == null) {
            installedSdk_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000800);
            onChanged();
          } else {
            installedSdkBuilder_.clear();
          }
          return this;
        }
        /**
         * <code>repeated .com.google.protos.adx.BidRequest.Mobile.InstalledSdk installed_sdk = 32;</code>
         */
        public Builder removeInstalledSdk(int index) {
          if (installedSdkBuilder_ == null) {
            ensureInstalledSdkIsMutable();
            installedSdk_.remove(index);
            onChanged();
          } else {
            installedSdkBuilder_.remove(index);
          }
          return this;
        }
        /**
         * <code>repeated .com.google.protos.adx.BidRequest.Mobile.InstalledSdk installed_sdk = 32;</code>
         */
        public com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Builder getInstalledSdkBuilder(
            int index) {
          return getInstalledSdkFieldBuilder().getBuilder(index);
        }
        /**
         * <code>repeated .com.google.protos.adx.BidRequest.Mobile.InstalledSdk installed_sdk = 32;</code>
         */
        public com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdkOrBuilder getInstalledSdkOrBuilder(
            int index) {
          if (installedSdkBuilder_ == null) {
            return installedSdk_.get(index);  } else {
            return installedSdkBuilder_.getMessageOrBuilder(index);
          }
        }
        /**
         * <code>repeated .com.google.protos.adx.BidRequest.Mobile.InstalledSdk installed_sdk = 32;</code>
         */
        public java.util.List<? extends com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdkOrBuilder> 
             getInstalledSdkOrBuilderList() {
          if (installedSdkBuilder_ != null) {
            return installedSdkBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(installedSdk_);
          }
        }
        /**
         * <code>repeated .com.google.protos.adx.BidRequest.Mobile.InstalledSdk installed_sdk = 32;</code>
         */
        public com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Builder addInstalledSdkBuilder() {
          return getInstalledSdkFieldBuilder().addBuilder(
              com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.getDefaultInstance());
        }
        /**
         * <code>repeated .com.google.protos.adx.BidRequest.Mobile.InstalledSdk installed_sdk = 32;</code>
         */
        public com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Builder addInstalledSdkBuilder(
            int index) {
          return getInstalledSdkFieldBuilder().addBuilder(
              index, com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.getDefaultInstance());
        }
        /**
         * <code>repeated .com.google.protos.adx.BidRequest.Mobile.InstalledSdk installed_sdk = 32;</code>
         */
        public java.util.List<com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Builder> 
             getInstalledSdkBuilderList() {
          return getInstalledSdkFieldBuilder().getBuilderList();
        }
        private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk, com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Builder, com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdkOrBuilder> 
            getInstalledSdkFieldBuilder() {
          if (installedSdkBuilder_ == null) {
            installedSdkBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk, com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdk.Builder, com.google.protos.adx.NetworkBid.BidRequest.Mobile.InstalledSdkOrBuilder>(
                    installedSdk_,
                    ((bitField0_ & 0x00000800) != 0),
                    getParentForChildren(),
                    isClean());
            installedSdk_ = null;
          }
          return installedSdkBuilder_;
        }

        private com.google.protos.adx.NetworkBid.BidRequest.Mobile.SKAdNetworkRequest skadn_;
        private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protos.adx.NetworkBid.BidRequest.Mobile.SKAdNetworkRequest, com.google.protos.adx.NetworkBid.BidRequest.Mobile.SKAdNetworkRequest.Builder, com.google.protos.adx.NetworkBid.BidRequest.Mobile.SKAdNetworkRequestOrBuilder> skadnBuilder_;
        /**
         * <code>optional .com.google.protos.adx.BidRequest.Mobile.SKAdNetworkRequest skadn = 34;</code>
         * @return Whether the skadn field is set.
         */
        public boolean hasSkadn() {
          return ((bitField0_ & 0x00001000) != 0);
        }
        /**
         * <code>optional .com.google.protos.adx.BidRequest.Mobile.SKAdNetworkRequest skadn = 34;</code>
         * @return The skadn.
         */
        public com.google.protos.adx.NetworkBid.BidRequest.Mobile.SKAdNetworkRequest getSkadn() {
          if (skadnBuilder_ == null) {
            return skadn_ == null ? com.google.protos.adx.NetworkBid.BidRequest.Mobile.SKAdNetworkRequest.getDefaultInstance() : skadn_;
          } else {
            return skadnBuilder_.getMessage();
          }
        }
        /**
         * <code>optional .com.google.protos.adx.BidRequest.Mobile.SKAdNetworkRequest skadn = 34;</code>
         */
        public Builder setSkadn(com.google.protos.adx.NetworkBid.BidRequest.Mobile.SKAdNetworkRequest value) {
          if (skadnBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            skadn_ = value;
            onChanged();
          } else {
            skadnBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00001000;
          return this;
        }
        /**
         * <code>optional .com.google.protos.adx.BidRequest.Mobile.SKAdNetworkRequest skadn = 34;</code>
         */
        public Builder setSkadn(
            com.google.protos.adx.NetworkBid.BidRequest.Mobile.SKAdNetworkRequest.Builder builderForValue) {
          if (skadnBuilder_ == null) {
            skadn_ = builderForValue.build();
            onChanged();
          } else {
            skadnBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00001000;
          return this;
        }
        /**
         * <code>optional .com.google.protos.adx.BidRequest.Mobile.SKAdNetworkRequest skadn = 34;</code>
         */
        public Builder mergeSkadn(com.google.protos.adx.NetworkBid.BidRequest.Mobile.SKAdNetworkRequest value) {
          if (skadnBuilder_ == null) {
            if (((bitField0_ & 0x00001000) != 0) &&
                skadn_ != null &&
                skadn_ != com.google.protos.adx.NetworkBid.BidRequest.Mobile.SKAdNetworkRequest.getDefaultInstance()) {
              skadn_ =
                com.google.protos.adx.NetworkBid.BidRequest.Mobile.SKAdNetworkRequest.newBuilder(skadn_).mergeFrom(value).buildPartial();
            } else {
              skadn_ = value;
            }
            onChanged();
          } else {
            skadnBuilder_.mergeFrom(value);
          }
          bitField0_ |= 0x00001000;
          return this;
        }
        /**
         * <code>optional .com.google.protos.adx.BidRequest.Mobile.SKAdNetworkRequest skadn = 34;</code>
         */
        public Builder clearSkadn() {
          if (skadnBuilder_ == null) {
            skadn_ = null;
            onChanged();
          } else {
            skadnBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00001000);
          return this;
        }
        /**
         * <code>optional .com.google.protos.adx.BidRequest.Mobile.SKAdNetworkRequest skadn = 34;</code>
         */
        public com.google.protos.adx.NetworkBid.BidRequest.Mobile.SKAdNetworkRequest.Builder getSkadnBuilder() {
          bitField0_ |= 0x00001000;
          onChanged();
          return getSkadnFieldBuilder().getBuilder();
        }
        /**
         * <code>optional .com.google.protos.adx.BidRequest.Mobile.SKAdNetworkRequest skadn = 34;</code>
         */
        public com.google.protos.adx.NetworkBid.BidRequest.Mobile.SKAdNetworkRequestOrBuilder getSkadnOrBuilder() {
          if (skadnBuilder_ != null) {
            return skadnBuilder_.getMessageOrBuilder();
          } else {
            return skadn_ == null ?
                com.google.protos.adx.NetworkBid.BidRequest.Mobile.SKAdNetworkRequest.getDefaultInstance() : skadn_;
          }
        }
        /**
         * <code>optional .com.google.protos.adx.BidRequest.Mobile.SKAdNetworkRequest skadn = 34;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protos.adx.NetworkBid.BidRequest.Mobile.SKAdNetworkRequest, com.google.protos.adx.NetworkBid.BidRequest.Mobile.SKAdNetworkRequest.Builder, com.google.protos.adx.NetworkBid.BidRequest.Mobile.SKAdNetworkRequestOrBuilder> 
            getSkadnFieldBuilder() {
          if (skadnBuilder_ == null) {
            skadnBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protos.adx.NetworkBid.BidRequest.Mobile.SKAdNetworkRequest, com.google.protos.adx.NetworkBid.BidRequest.Mobile.SKAdNetworkRequest.Builder, com.google.protos.adx.NetworkBid.BidRequest.Mobile.SKAdNetworkRequestOrBuilder>(
                    getSkadn(),
                    getParentForChildren(),
                    isClean());
            skadn_ = null;
          }
          return skadnBuilder_;
        }
        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }


        // @@protoc_insertion_point(builder_scope:com.google.protos.adx.BidRequest.Mobile)
      }

      // @@protoc_insertion_point(class_scope:com.google.protos.adx.BidRequest.Mobile)
      private static final com.google.protos.adx.NetworkBid.BidRequest.Mobile DEFAULT_INSTANCE;
      static {
        DEFAULT_INSTANCE = new com.google.protos.adx.NetworkBid.BidRequest.Mobile();
      }

      public static com.google.protos.adx.NetworkBid.BidRequest.Mobile getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      @java.lang.Deprecated public static final com.google.protobuf.Parser<Mobile>
          PARSER = new com.google.protobuf.AbstractParser<Mobile>() {
        @java.lang.Override
        public Mobile parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new Mobile(input, extensionRegistry);
        }
      };

      public static com.google.protobuf.Parser<Mobile> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Mobile> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protos.adx.NetworkBid.BidRequest.Mobile getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }

    }

    public interface VideoOrBuilder extends
        // @@protoc_insertion_point(interface_extends:com.google.protos.adx.BidRequest.Video)
        com.google.protobuf.MessageOrBuilder {

      /**
       * <code>optional .com.google.protos.adx.BidRequest.Video.Placement placement = 16 [default = UNKNOWN_PLACEMENT];</code>
       * @return Whether the placement field is set.
       */
      boolean hasPlacement();
      /**
       * <code>optional .com.google.protos.adx.BidRequest.Video.Placement placement = 16 [default = UNKNOWN_PLACEMENT];</code>
       * @return The placement.
       */
      com.google.protos.adx.NetworkBid.BidRequest.Video.Placement getPlacement();

      /**
       * <pre>
       * The URL of the page that the publisher gives Google to describe the video
       * content, with parameters removed.
       * </pre>
       *
       * <code>optional string description_url = 10;</code>
       * @return Whether the descriptionUrl field is set.
       */
      boolean hasDescriptionUrl();
      /**
       * <pre>
       * The URL of the page that the publisher gives Google to describe the video
       * content, with parameters removed.
       * </pre>
       *
       * <code>optional string description_url = 10;</code>
       * @return The descriptionUrl.
       */
      java.lang.String getDescriptionUrl();
      /**
       * <pre>
       * The URL of the page that the publisher gives Google to describe the video
       * content, with parameters removed.
       * </pre>
       *
       * <code>optional string description_url = 10;</code>
       * @return The bytes for descriptionUrl.
       */
      com.google.protobuf.ByteString
          getDescriptionUrlBytes();

      /**
       * <pre>
       * If true, the video is embedded on a page outside the publisher's domain.
       * When this is set, description_url points to a description of the video
       * (as it always does), and the url field in BidRequest is the page in which
       * the video is embedded. For example, a request for an in-stream ad in a
       * Vimeo video shared on Facebook has is_embedded_offsite set. The url field
       * is for a Facebook page and the description_url points to the video on
       * Vimeo.
       * </pre>
       *
       * <code>optional bool is_embedded_offsite = 11 [default = false];</code>
       * @return Whether the isEmbeddedOffsite field is set.
       */
      boolean hasIsEmbeddedOffsite();
      /**
       * <pre>
       * If true, the video is embedded on a page outside the publisher's domain.
       * When this is set, description_url points to a description of the video
       * (as it always does), and the url field in BidRequest is the page in which
       * the video is embedded. For example, a request for an in-stream ad in a
       * Vimeo video shared on Facebook has is_embedded_offsite set. The url field
       * is for a Facebook page and the description_url points to the video on
       * Vimeo.
       * </pre>
       *
       * <code>optional bool is_embedded_offsite = 11 [default = false];</code>
       * @return The isEmbeddedOffsite.
       */
      boolean getIsEmbeddedOffsite();

      /**
       * <code>optional .com.google.protos.adx.BidRequest.Video.VideoPlaybackMethod playback_method = 14 [default = METHOD_UNKNOWN];</code>
       * @return Whether the playbackMethod field is set.
       */
      boolean hasPlaybackMethod();
      /**
       * <code>optional .com.google.protos.adx.BidRequest.Video.VideoPlaybackMethod playback_method = 14 [default = METHOD_UNKNOWN];</code>
       * @return The playbackMethod.
       */
      com.google.protos.adx.NetworkBid.BidRequest.Video.VideoPlaybackMethod getPlaybackMethod();

      /**
       * <pre>
       * Whether the inventory allows clicking on the video ad to take the user to
       * an advertiser site. Some platforms, notably connected TVs, do not
       * support clicking on video ads, in which case this field is set to false.
       * </pre>
       *
       * <code>optional bool is_clickable = 15;</code>
       * @return Whether the isClickable field is set.
       */
      boolean hasIsClickable();
      /**
       * <pre>
       * Whether the inventory allows clicking on the video ad to take the user to
       * an advertiser site. Some platforms, notably connected TVs, do not
       * support clicking on video ads, in which case this field is set to false.
       * </pre>
       *
       * <code>optional bool is_clickable = 15;</code>
       * @return The isClickable.
       */
      boolean getIsClickable();

      /**
       * <pre>
       * The time in milliseconds from the start of the video when the ad will be
       * displayed. 0 means pre-roll and -1 means post-roll. The value is valid
       * only if this param is set. When not set, the display position is unknown.
       * </pre>
       *
       * <code>optional int32 videoad_start_delay = 1;</code>
       * @return Whether the videoadStartDelay field is set.
       */
      boolean hasVideoadStartDelay();
      /**
       * <pre>
       * The time in milliseconds from the start of the video when the ad will be
       * displayed. 0 means pre-roll and -1 means post-roll. The value is valid
       * only if this param is set. When not set, the display position is unknown.
       * </pre>
       *
       * <code>optional int32 videoad_start_delay = 1;</code>
       * @return The videoadStartDelay.
       */
      int getVideoadStartDelay();

      /**
       * <pre>
       * The maximum duration in milliseconds of the ad that you should return.
       * If this is not set or has value &lt;= 0, any duration is allowed.
       * </pre>
       *
       * <code>optional int32 max_ad_duration = 2;</code>
       * @return Whether the maxAdDuration field is set.
       */
      boolean hasMaxAdDuration();
      /**
       * <pre>
       * The maximum duration in milliseconds of the ad that you should return.
       * If this is not set or has value &lt;= 0, any duration is allowed.
       * </pre>
       *
       * <code>optional int32 max_ad_duration = 2;</code>
       * @return The maxAdDuration.
       */
      int getMaxAdDuration();

      /**
       * <pre>
       * The minimum duration in milliseconds of the ad that you should return.
       * If this is not set or has value &lt;= 0, there is no minimum duration.
       * </pre>
       *
       * <code>optional int32 min_ad_duration = 8;</code>
       * @return Whether the minAdDuration field is set.
       */
      boolean hasMinAdDuration();
      /**
       * <pre>
       * The minimum duration in milliseconds of the ad that you should return.
       * If this is not set or has value &lt;= 0, there is no minimum duration.
       * </pre>
       *
       * <code>optional int32 min_ad_duration = 8;</code>
       * @return The minAdDuration.
       */
      int getMinAdDuration();

      /**
       * <pre>
       * The maximum number of ads in an Adx video pod. A non-zero value indicates
       * that the current ad slot is a video pod that can show multiple video
       * ads. Actual number of video ads shown can be less than or equal to this
       * value but cannot exceed it.
       * </pre>
       *
       * <code>optional int32 max_ads_in_pod = 12;</code>
       * @return Whether the maxAdsInPod field is set.
       */
      boolean hasMaxAdsInPod();
      /**
       * <pre>
       * The maximum number of ads in an Adx video pod. A non-zero value indicates
       * that the current ad slot is a video pod that can show multiple video
       * ads. Actual number of video ads shown can be less than or equal to this
       * value but cannot exceed it.
       * </pre>
       *
       * <code>optional int32 max_ads_in_pod = 12;</code>
       * @return The maxAdsInPod.
       */
      int getMaxAdsInPod();

      /**
       * <code>optional .com.google.protos.adx.BidRequest.Video.SkippableBidRequestType video_ad_skippable = 4 [default = ALLOW_SKIPPABLE];</code>
       * @return Whether the videoAdSkippable field is set.
       */
      boolean hasVideoAdSkippable();
      /**
       * <code>optional .com.google.protos.adx.BidRequest.Video.SkippableBidRequestType video_ad_skippable = 4 [default = ALLOW_SKIPPABLE];</code>
       * @return The videoAdSkippable.
       */
      com.google.protos.adx.NetworkBid.BidRequest.Video.SkippableBidRequestType getVideoAdSkippable();

      /**
       * <pre>
       * The maximum duration in milliseconds for the ad you should return, if
       * this ad is skippable (this generally differs from the maximum duration
       * allowed for non-skippable ads). If this is not set or has value &lt;= 0, any
       * duration is allowed.
       * </pre>
       *
       * <code>optional int32 skippable_max_ad_duration = 5;</code>
       * @return Whether the skippableMaxAdDuration field is set.
       */
      boolean hasSkippableMaxAdDuration();
      /**
       * <pre>
       * The maximum duration in milliseconds for the ad you should return, if
       * this ad is skippable (this generally differs from the maximum duration
       * allowed for non-skippable ads). If this is not set or has value &lt;= 0, any
       * duration is allowed.
       * </pre>
       *
       * <code>optional int32 skippable_max_ad_duration = 5;</code>
       * @return The skippableMaxAdDuration.
       */
      int getSkippableMaxAdDuration();

      /**
       * <pre>
       * Array of supported video bid response protocols.
       * </pre>
       *
       * <code>repeated .com.google.protos.adx.BidRequest.Video.VideoProtocol protocols = 17 [packed = true];</code>
       * @return A list containing the protocols.
       */
      java.util.List<com.google.protos.adx.NetworkBid.BidRequest.Video.VideoProtocol> getProtocolsList();
      /**
       * <pre>
       * Array of supported video bid response protocols.
       * </pre>
       *
       * <code>repeated .com.google.protos.adx.BidRequest.Video.VideoProtocol protocols = 17 [packed = true];</code>
       * @return The count of protocols.
       */
      int getProtocolsCount();
      /**
       * <pre>
       * Array of supported video bid response protocols.
       * </pre>
       *
       * <code>repeated .com.google.protos.adx.BidRequest.Video.VideoProtocol protocols = 17 [packed = true];</code>
       * @param index The index of the element to return.
       * @return The protocols at the given index.
       */
      com.google.protos.adx.NetworkBid.BidRequest.Video.VideoProtocol getProtocols(int index);

      /**
       * <code>repeated .com.google.protos.adx.BidRequest.Video.VideoFormat allowed_video_formats = 6;</code>
       * @return A list containing the allowedVideoFormats.
       */
      java.util.List<com.google.protos.adx.NetworkBid.BidRequest.Video.VideoFormat> getAllowedVideoFormatsList();
      /**
       * <code>repeated .com.google.protos.adx.BidRequest.Video.VideoFormat allowed_video_formats = 6;</code>
       * @return The count of allowedVideoFormats.
       */
      int getAllowedVideoFormatsCount();
      /**
       * <code>repeated .com.google.protos.adx.BidRequest.Video.VideoFormat allowed_video_formats = 6;</code>
       * @param index The index of the element to return.
       * @return The allowedVideoFormats at the given index.
       */
      com.google.protos.adx.NetworkBid.BidRequest.Video.VideoFormat getAllowedVideoFormats(int index);

      /**
       * <code>repeated .com.google.protos.adx.BidRequest.Video.CompanionSlot companion_slot = 7;</code>
       */
      java.util.List<com.google.protos.adx.NetworkBid.BidRequest.Video.CompanionSlot> 
          getCompanionSlotList();
      /**
       * <code>repeated .com.google.protos.adx.BidRequest.Video.CompanionSlot companion_slot = 7;</code>
       */
      com.google.protos.adx.NetworkBid.BidRequest.Video.CompanionSlot getCompanionSlot(int index);
      /**
       * <code>repeated .com.google.protos.adx.BidRequest.Video.CompanionSlot companion_slot = 7;</code>
       */
      int getCompanionSlotCount();
      /**
       * <code>repeated .com.google.protos.adx.BidRequest.Video.CompanionSlot companion_slot = 7;</code>
       */
      java.util.List<? extends com.google.protos.adx.NetworkBid.BidRequest.Video.CompanionSlotOrBuilder> 
          getCompanionSlotOrBuilderList();
      /**
       * <code>repeated .com.google.protos.adx.BidRequest.Video.CompanionSlot companion_slot = 7;</code>
       */
      com.google.protos.adx.NetworkBid.BidRequest.Video.CompanionSlotOrBuilder getCompanionSlotOrBuilder(
          int index);

      /**
       * <code>optional .com.google.protos.adx.BidRequest.Video.EndCapSupport end_cap_support = 13 [default = END_CAP_NOT_ENABLED];</code>
       * @return Whether the endCapSupport field is set.
       */
      boolean hasEndCapSupport();
      /**
       * <code>optional .com.google.protos.adx.BidRequest.Video.EndCapSupport end_cap_support = 13 [default = END_CAP_NOT_ENABLED];</code>
       * @return The endCapSupport.
       */
      com.google.protos.adx.NetworkBid.BidRequest.Video.EndCapSupport getEndCapSupport();

      /**
       * <code>optional .com.google.protos.adx.BidRequest.Video.ContentAttributes content_attributes = 9;</code>
       * @return Whether the contentAttributes field is set.
       */
      boolean hasContentAttributes();
      /**
       * <code>optional .com.google.protos.adx.BidRequest.Video.ContentAttributes content_attributes = 9;</code>
       * @return The contentAttributes.
       */
      com.google.protos.adx.NetworkBid.BidRequest.Video.ContentAttributes getContentAttributes();
      /**
       * <code>optional .com.google.protos.adx.BidRequest.Video.ContentAttributes content_attributes = 9;</code>
       */
      com.google.protos.adx.NetworkBid.BidRequest.Video.ContentAttributesOrBuilder getContentAttributesOrBuilder();

      /**
       * <pre>
       * Identify whether or not the ad request is being served from a live video
       * stream (0 = is not live, 1 = is live).
       * </pre>
       *
       * <code>optional bool is_livestream = 18 [default = false];</code>
       * @return Whether the isLivestream field is set.
       */
      boolean hasIsLivestream();
      /**
       * <pre>
       * Identify whether or not the ad request is being served from a live video
       * stream (0 = is not live, 1 = is live).
       * </pre>
       *
       * <code>optional bool is_livestream = 18 [default = false];</code>
       * @return The isLivestream.
       */
      boolean getIsLivestream();
    }
    /**
     * <pre>
     * Information about the video if this is an in-video ad request.
     * </pre>
     *
     * Protobuf type {@code com.google.protos.adx.BidRequest.Video}
     */
    public static final class Video extends
        com.google.protobuf.GeneratedMessageV3 implements
        // @@protoc_insertion_point(message_implements:com.google.protos.adx.BidRequest.Video)
        VideoOrBuilder {
    private static final long serialVersionUID = 0L;
      // Use Video.newBuilder() to construct.
      private Video(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }
      private Video() {
        placement_ = 0;
        descriptionUrl_ = "";
        playbackMethod_ = 0;
        videoAdSkippable_ = 0;
        protocols_ = java.util.Collections.emptyList();
        allowedVideoFormats_ = java.util.Collections.emptyList();
        companionSlot_ = java.util.Collections.emptyList();
        endCapSupport_ = 0;
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(
          UnusedPrivateParameter unused) {
        return new Video();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet
      getUnknownFields() {
        return this.unknownFields;
      }
      private Video(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        int mutable_bitField0_ = 0;
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8: {
                bitField0_ |= 0x00000020;
                videoadStartDelay_ = input.readInt32();
                break;
              }
              case 16: {
                bitField0_ |= 0x00000040;
                maxAdDuration_ = input.readInt32();
                break;
              }
              case 32: {
                int rawValue = input.readEnum();
                  @SuppressWarnings("deprecation")
                com.google.protos.adx.NetworkBid.BidRequest.Video.SkippableBidRequestType value = com.google.protos.adx.NetworkBid.BidRequest.Video.SkippableBidRequestType.valueOf(rawValue);
                if (value == null) {
                  unknownFields.mergeVarintField(4, rawValue);
                } else {
                  bitField0_ |= 0x00000200;
                  videoAdSkippable_ = rawValue;
                }
                break;
              }
              case 40: {
                bitField0_ |= 0x00000400;
                skippableMaxAdDuration_ = input.readInt32();
                break;
              }
              case 48: {
                int rawValue = input.readEnum();
                @SuppressWarnings("deprecation")
                com.google.protos.adx.NetworkBid.BidRequest.Video.VideoFormat value = com.google.protos.adx.NetworkBid.BidRequest.Video.VideoFormat.valueOf(rawValue);
                if (value == null) {
                  unknownFields.mergeVarintField(6, rawValue);
                } else {
                  if (!((mutable_bitField0_ & 0x00001000) != 0)) {
                    allowedVideoFormats_ = new java.util.ArrayList<java.lang.Integer>();
                    mutable_bitField0_ |= 0x00001000;
                  }
                  allowedVideoFormats_.add(rawValue);
                }
                break;
              }
              case 50: {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while(input.getBytesUntilLimit() > 0) {
                  int rawValue = input.readEnum();
                  @SuppressWarnings("deprecation")
                  com.google.protos.adx.NetworkBid.BidRequest.Video.VideoFormat value = com.google.protos.adx.NetworkBid.BidRequest.Video.VideoFormat.valueOf(rawValue);
                  if (value == null) {
                    unknownFields.mergeVarintField(6, rawValue);
                  } else {
                    if (!((mutable_bitField0_ & 0x00001000) != 0)) {
                      allowedVideoFormats_ = new java.util.ArrayList<java.lang.Integer>();
                      mutable_bitField0_ |= 0x00001000;
                    }
                    allowedVideoFormats_.add(rawValue);
                  }
                }
                input.popLimit(oldLimit);
                break;
              }
              case 58: {
                if (!((mutable_bitField0_ & 0x00002000) != 0)) {
                  companionSlot_ = new java.util.ArrayList<com.google.protos.adx.NetworkBid.BidRequest.Video.CompanionSlot>();
                  mutable_bitField0_ |= 0x00002000;
                }
                companionSlot_.add(
                    input.readMessage(com.google.protos.adx.NetworkBid.BidRequest.Video.CompanionSlot.PARSER, extensionRegistry));
                break;
              }
              case 64: {
                bitField0_ |= 0x00000080;
                minAdDuration_ = input.readInt32();
                break;
              }
              case 74: {
                com.google.protos.adx.NetworkBid.BidRequest.Video.ContentAttributes.Builder subBuilder = null;
                if (((bitField0_ & 0x00001000) != 0)) {
                  subBuilder = contentAttributes_.toBuilder();
                }
                contentAttributes_ = input.readMessage(com.google.protos.adx.NetworkBid.BidRequest.Video.ContentAttributes.PARSER, extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(contentAttributes_);
                  contentAttributes_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00001000;
                break;
              }
              case 82: {
                com.google.protobuf.ByteString bs = input.readBytes();
                bitField0_ |= 0x00000002;
                descriptionUrl_ = bs;
                break;
              }
              case 88: {
                bitField0_ |= 0x00000004;
                isEmbeddedOffsite_ = input.readBool();
                break;
              }
              case 96: {
                bitField0_ |= 0x00000100;
                maxAdsInPod_ = input.readInt32();
                break;
              }
              case 104: {
                int rawValue = input.readEnum();
                  @SuppressWarnings("deprecation")
                com.google.protos.adx.NetworkBid.BidRequest.Video.EndCapSupport value = com.google.protos.adx.NetworkBid.BidRequest.Video.EndCapSupport.valueOf(rawValue);
                if (value == null) {
                  unknownFields.mergeVarintField(13, rawValue);
                } else {
                  bitField0_ |= 0x00000800;
                  endCapSupport_ = rawValue;
                }
                break;
              }
              case 112: {
                int rawValue = input.readEnum();
                  @SuppressWarnings("deprecation")
                com.google.protos.adx.NetworkBid.BidRequest.Video.VideoPlaybackMethod value = com.google.protos.adx.NetworkBid.BidRequest.Video.VideoPlaybackMethod.valueOf(rawValue);
                if (value == null) {
                  unknownFields.mergeVarintField(14, rawValue);
                } else {
                  bitField0_ |= 0x00000008;
                  playbackMethod_ = rawValue;
                }
                break;
              }
              case 120: {
                bitField0_ |= 0x00000010;
                isClickable_ = input.readBool();
                break;
              }
              case 128: {
                int rawValue = input.readEnum();
                  @SuppressWarnings("deprecation")
                com.google.protos.adx.NetworkBid.BidRequest.Video.Placement value = com.google.protos.adx.NetworkBid.BidRequest.Video.Placement.valueOf(rawValue);
                if (value == null) {
                  unknownFields.mergeVarintField(16, rawValue);
                } else {
                  bitField0_ |= 0x00000001;
                  placement_ = rawValue;
                }
                break;
              }
              case 136: {
                int rawValue = input.readEnum();
                @SuppressWarnings("deprecation")
                com.google.protos.adx.NetworkBid.BidRequest.Video.VideoProtocol value = com.google.protos.adx.NetworkBid.BidRequest.Video.VideoProtocol.valueOf(rawValue);
                if (value == null) {
                  unknownFields.mergeVarintField(17, rawValue);
                } else {
                  if (!((mutable_bitField0_ & 0x00000800) != 0)) {
                    protocols_ = new java.util.ArrayList<java.lang.Integer>();
                    mutable_bitField0_ |= 0x00000800;
                  }
                  protocols_.add(rawValue);
                }
                break;
              }
              case 138: {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while(input.getBytesUntilLimit() > 0) {
                  int rawValue = input.readEnum();
                  @SuppressWarnings("deprecation")
                  com.google.protos.adx.NetworkBid.BidRequest.Video.VideoProtocol value = com.google.protos.adx.NetworkBid.BidRequest.Video.VideoProtocol.valueOf(rawValue);
                  if (value == null) {
                    unknownFields.mergeVarintField(17, rawValue);
                  } else {
                    if (!