/*
 * Decompiled with CFR 0.152.
 */
package com.google.doubleclick.util;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.google.common.collect.Lists;
import com.google.doubleclick.util.CityDMARegionKey;
import com.google.doubleclick.util.CityDMARegionValue;
import com.google.doubleclick.util.CountryCodes;
import com.google.doubleclick.util.GeoTarget;
import com.google.doubleclick.util.impl.CSVParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.ParseException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DoubleClickMetadata {
    private static final Logger logger = LoggerFactory.getLogger(DoubleClickMetadata.class);
    private static final String BASE_URL = "https://storage.googleapis.com";
    private static final String ADX_DICT = "https://storage.googleapis.com/adx-rtb-dictionaries/";
    private final ImmutableMap<Integer, String> vendors;
    private final ImmutableMap<Integer, String> adSensitiveCategories;
    private final ImmutableMap<Integer, String> adProductCategories;
    private final ImmutableMap<Integer, String> adRestrictedCategories;
    private final ImmutableMap<Integer, String> agencies;
    private final ImmutableMap<Integer, String> allAdCategories;
    private final ImmutableMap<Integer, String> pubExcCreativeAttributes;
    private final ImmutableMap<Integer, String> buyDecCreativeAttributes;
    private final ImmutableMap<Integer, String> allCreativeAttributes;
    private final ImmutableMap<Integer, String> creativeStatusCodes;
    private final ImmutableMap<Integer, String> sellerNetworks;
    private final ImmutableMap<Integer, String> siteLists;
    private final ImmutableMap<Integer, String> contentLabels;
    private final ImmutableMap<Integer, String> publisherVerticals;
    private final ImmutableMap<Integer, String> mobileCarriers;
    private final ImmutableMap<Integer, GeoTarget> geoTargetsByCriteriaId;
    private final ImmutableMap<GeoTarget.CanonicalKey, GeoTarget> geoTargetsByCanonicalKey;
    private final ImmutableMap<Object, CountryCodes> countryCodes;

    @Inject
    public DoubleClickMetadata(Transport transport) {
        Pattern ssvp = Pattern.compile("(\\d+)\\s+(.*)");
        Pattern csvp = Pattern.compile("(\\d+),(.*)");
        Interner interner = Interners.newStrongInterner();
        this.vendors = DoubleClickMetadata.load((Interner<String>)interner, transport, ssvp, "https://storage.googleapis.com/adx-rtb-dictionaries/vendors.txt");
        HashMap<Integer, String> cats = new HashMap<Integer, String>();
        this.adSensitiveCategories = DoubleClickMetadata.load((Interner<String>)interner, transport, ssvp, "https://storage.googleapis.com/adx-rtb-dictionaries/ad-sensitive-categories.txt");
        cats.putAll((Map<Integer, String>)this.adSensitiveCategories);
        this.adProductCategories = DoubleClickMetadata.load((Interner<String>)interner, transport, ssvp, "https://storage.googleapis.com/adx-rtb-dictionaries/ad-product-categories.txt");
        cats.putAll((Map<Integer, String>)this.adProductCategories);
        this.adRestrictedCategories = DoubleClickMetadata.load((Interner<String>)interner, transport, ssvp, "https://storage.googleapis.com/adx-rtb-dictionaries/ad-restricted-categories.txt");
        cats.putAll((Map<Integer, String>)this.adRestrictedCategories);
        this.allAdCategories = ImmutableMap.copyOf(cats);
        this.agencies = DoubleClickMetadata.load((Interner<String>)interner, transport, ssvp, "https://storage.googleapis.com/adx-rtb-dictionaries/agencies.txt");
        HashMap<Integer, String> attrs = new HashMap<Integer, String>();
        this.pubExcCreativeAttributes = DoubleClickMetadata.load((Interner<String>)interner, transport, ssvp, "https://storage.googleapis.com/adx-rtb-dictionaries/publisher-excludable-creative-attributes.txt");
        attrs.putAll((Map<Integer, String>)this.pubExcCreativeAttributes);
        this.buyDecCreativeAttributes = DoubleClickMetadata.load((Interner<String>)interner, transport, ssvp, "https://storage.googleapis.com/adx-rtb-dictionaries/buyer-declarable-creative-attributes.txt");
        attrs.putAll((Map<Integer, String>)this.buyDecCreativeAttributes);
        this.allCreativeAttributes = ImmutableMap.copyOf(attrs);
        this.creativeStatusCodes = DoubleClickMetadata.load((Interner<String>)interner, transport, ssvp, "https://storage.googleapis.com/adx-rtb-dictionaries/creative-status-codes.txt");
        this.sellerNetworks = DoubleClickMetadata.load((Interner<String>)interner, transport, ssvp, "https://storage.googleapis.com/adx-rtb-dictionaries/seller-network-ids.txt");
        this.siteLists = DoubleClickMetadata.load((Interner<String>)interner, transport, ssvp, "https://storage.googleapis.com/adx-rtb-dictionaries/site-lists.txt");
        this.contentLabels = DoubleClickMetadata.load((Interner<String>)interner, transport, ssvp, "https://storage.googleapis.com/adx-rtb-dictionaries/content-labels.txt");
        this.publisherVerticals = DoubleClickMetadata.load((Interner<String>)interner, transport, ssvp, "https://storage.googleapis.com/adx-rtb-dictionaries/publisher-verticals.txt");
        this.mobileCarriers = DoubleClickMetadata.load((Interner<String>)interner, transport, CSVParser.csvParser(), csvp, "https://storage.googleapis.com/adx-rtb-dictionaries/mobile-carriers.csv");
        this.geoTargetsByCriteriaId = DoubleClickMetadata.loadGeoTargets((Interner<String>)interner, transport, "https://storage.googleapis.com/adx-rtb-dictionaries/geo-table.csv");
        HashMap<GeoTarget.CanonicalKey, GeoTarget> byKey = new HashMap<GeoTarget.CanonicalKey, GeoTarget>();
        for (GeoTarget target : this.geoTargetsByCriteriaId.values()) {
            byKey.put(target.key(), target);
        }
        this.geoTargetsByCanonicalKey = ImmutableMap.copyOf(byKey);
        this.countryCodes = this.loadCountryCodes((Interner<String>)interner, "https://storage.googleapis.com/adx-rtb-dictionaries/countries.txt");
    }

    public ImmutableMap<Integer, String> publisherExcludableCreativeAttributes() {
        return this.pubExcCreativeAttributes;
    }

    public ImmutableMap<Integer, String> buyerDeclarableCreativeAttributes() {
        return this.buyDecCreativeAttributes;
    }

    public ImmutableMap<Integer, String> allCreativeAttributes() {
        return this.allCreativeAttributes;
    }

    public ImmutableMap<Integer, String> creativeStatusCodes() {
        return this.creativeStatusCodes;
    }

    public ImmutableMap<Integer, String> sensitiveCategories() {
        return this.adSensitiveCategories;
    }

    public ImmutableMap<Integer, String> productCategories() {
        return this.adProductCategories;
    }

    public ImmutableMap<Integer, String> restrictedCategories() {
        return this.adRestrictedCategories;
    }

    public ImmutableMap<Integer, String> allCategories() {
        return this.allAdCategories;
    }

    public ImmutableMap<Integer, String> agencies() {
        return this.agencies;
    }

    public ImmutableMap<Integer, String> vendors() {
        return this.vendors;
    }

    public ImmutableMap<Integer, String> sellerNetworks() {
        return this.sellerNetworks;
    }

    public ImmutableMap<Integer, String> siteLists() {
        return this.siteLists;
    }

    public ImmutableMap<Integer, String> contentLabels() {
        return this.contentLabels;
    }

    public ImmutableMap<Integer, String> publisherVerticals() {
        return this.publisherVerticals;
    }

    @Deprecated
    public ImmutableMap<CityDMARegionKey, CityDMARegionValue> dmaRegions() {
        return ImmutableMap.of();
    }

    public ImmutableMap<Integer, GeoTarget> geoTargets() {
        return this.geoTargetsByCriteriaId;
    }

    public GeoTarget geoTargetFor(int criteriaId) {
        return (GeoTarget)this.geoTargetsByCriteriaId.get((Object)criteriaId);
    }

    public GeoTarget geoTargetFor(GeoTarget.Type type, String canonicalName) {
        return (GeoTarget)this.geoTargetsByCanonicalKey.get((Object)new GeoTarget.CanonicalKey(type, canonicalName));
    }

    public ImmutableMap<Object, CountryCodes> countryCodes() {
        return this.countryCodes;
    }

    public ImmutableMap<Integer, String> mobileCarriers() {
        return this.mobileCarriers;
    }

    public static String toString(Map<Integer, String> metadata, int code) {
        StringBuilder sb = new StringBuilder();
        sb.append(code).append(": ");
        String description = metadata.get(code);
        sb.append(description == null ? "<invalid>" : description);
        return sb.toString();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("agencies#", this.agencies.size()).add("buyDecCreativeAttributes#", this.buyDecCreativeAttributes.size()).add("contentLabels#", this.contentLabels.size()).add("countryCodes#", this.countryCodes.size()).add("mobileCarriers#", this.mobileCarriers.size()).add("creativeStatusCodes#", this.creativeStatusCodes.size()).add("productCategories#", this.adProductCategories.size()).add("pubExcCreativeAttributes#", this.pubExcCreativeAttributes.size()).add("publisherVerticals#", this.publisherVerticals.size()).add("restrictedCategories#", this.adRestrictedCategories.size()).add("sellerNetworks#", this.sellerNetworks.size()).add("sensitiveCategories#", this.adSensitiveCategories.size()).add("siteLists#", this.siteLists.size()).add("geoTargets#", this.geoTargetsByCriteriaId.size()).add("vendors#", this.vendors.size()).toString();
    }

    private static ImmutableMap<Integer, String> load(Interner<String> interner, Transport transport, Pattern pattern, String resourceName) {
        ImmutableMap immutableMap;
        block11: {
            InputStream isMetadata = transport.open(resourceName);
            try {
                String record;
                ImmutableMap.Builder builder = ImmutableMap.builder();
                BufferedReader rd = new BufferedReader(new InputStreamReader(isMetadata));
                while ((record = rd.readLine()) != null) {
                    Matcher matcher = pattern.matcher(record);
                    if (!matcher.matches()) continue;
                    try {
                        builder.put((Object)Integer.parseInt(matcher.group(1)), (Object)((String)interner.intern((Object)matcher.group(2))));
                    }
                    catch (NumberFormatException e) {
                        logger.trace("Bad record [{}]: {}", (Object)record, (Object)e.toString());
                    }
                }
                immutableMap = builder.build();
                if (isMetadata == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (isMetadata != null) {
                        try {
                            isMetadata.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    logger.warn(e.toString());
                    return ImmutableMap.of();
                }
            }
            isMetadata.close();
        }
        return immutableMap;
    }

    private static ImmutableMap<Integer, String> load(Interner<String> interner, Transport transport, CSVParser csvParser, Pattern pattern, String resourceName) {
        ImmutableMap immutableMap;
        block8: {
            InputStream is = transport.open(resourceName);
            try {
                ImmutableMap.Builder builder = ImmutableMap.builder();
                csvParser.parse(is, pattern, fields -> {
                    try {
                        builder.put((Object)Integer.parseInt((String)fields.get(0)), (Object)((String)interner.intern((Object)((String)fields.get(1)))));
                    }
                    catch (NumberFormatException e) {
                        logger.trace("Bad record [{}]: {}", fields, (Object)e.toString());
                    }
                    return true;
                });
                immutableMap = builder.build();
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    logger.warn(e.toString());
                    return ImmutableMap.of();
                }
            }
            is.close();
        }
        return immutableMap;
    }

    private static ImmutableMap<Integer, GeoTarget> loadGeoTargets(Interner<String> interner, Transport transport, String resourceName) {
        ImmutableMap immutableMap;
        block11: {
            LinkedHashMap targetsById = new LinkedHashMap();
            LinkedHashMap parentIdsById = new LinkedHashMap();
            LinkedHashMap targetsByCanon = new LinkedHashMap();
            LinkedHashSet duplicateCanon = new LinkedHashSet();
            InputStream is = transport.open(resourceName);
            try {
                GeoTarget target;
                CSVParser.csvParser().parse(is, "(\\d+),(.*)", fields -> {
                    try {
                        if (fields.size() == 7) {
                            GeoTarget target = new GeoTarget(Integer.valueOf((String)fields.get(0)), GeoTarget.Type.valueOf(DoubleClickMetadata.toEnumName((String)fields.get(6))), (String)interner.intern((Object)((String)fields.get(2))), (String)interner.intern((Object)((String)fields.get(1))), (String)interner.intern((Object)((String)fields.get(5))));
                            List idParent = Lists.transform(CSVParser.csvParser().parse((String)fields.get(3)), id -> Integer.valueOf(id));
                            targetsById.put(target.criteriaId(), target);
                            parentIdsById.put(target.criteriaId(), idParent);
                            if (targetsByCanon.containsKey(target.canonicalName())) {
                                duplicateCanon.add(target.canonicalName());
                                targetsByCanon.remove(target.canonicalName());
                            } else {
                                targetsByCanon.put(target.canonicalName(), target);
                            }
                        }
                    }
                    catch (IllegalArgumentException | ParseException e) {
                        logger.trace("Bad record [{}]: {}", fields, (Object)e.toString());
                    }
                    return true;
                });
                for (Map.Entry entry : targetsById.entrySet()) {
                    target = (GeoTarget)entry.getValue();
                    GeoTarget canonParent = (GeoTarget)targetsByCanon.get(target.findCanonParentName());
                    if (canonParent == null) continue;
                    target.setCanonParent(canonParent);
                }
                block8: for (Map.Entry entry : targetsById.entrySet()) {
                    target = (GeoTarget)entry.getValue();
                    List parentIds = (List)parentIdsById.get(target.criteriaId());
                    for (Integer parentId : parentIds) {
                        GeoTarget idParent = (GeoTarget)targetsById.get(parentId);
                        if (idParent == null) continue;
                        target.setIdParent(idParent);
                        continue block8;
                    }
                }
                immutableMap = ImmutableMap.copyOf(targetsById);
                if (is == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    logger.warn(e.toString());
                    return ImmutableMap.of();
                }
            }
            is.close();
        }
        return immutableMap;
    }

    private ImmutableMap<Object, CountryCodes> loadCountryCodes(Interner<String> interner, String resourceName) {
        ImmutableMap.Builder map = ImmutableMap.builder();
        try (InputStream is = new ResourceTransport().open(resourceName);){
            CSVParser.tsvParser().parse(is, "(\\d+)\\s+(.*)", fields -> {
                try {
                    CountryCodes codes = new CountryCodes(Integer.parseInt((String)fields.get(0)), (String)interner.intern((Object)((String)fields.get(2))), (String)interner.intern((Object)((String)fields.get(3))));
                    map.put((Object)codes.numeric(), (Object)codes);
                    map.put((Object)codes.alpha2(), (Object)codes);
                    map.put((Object)codes.alpha3(), (Object)codes);
                }
                catch (IllegalArgumentException e) {
                    logger.trace("Bad record [{}]: {}", fields, (Object)e.toString());
                }
                return true;
            });
        }
        catch (IOException e) {
            logger.warn(e.toString());
            return ImmutableMap.of();
        }
        return map.build();
    }

    private static String toEnumName(String csvName) {
        return csvName.replace(' ', '_').toUpperCase();
    }

    public static class ResourceTransport
    implements Transport {
        @Override
        public InputStream open(String url) throws IOException {
            String resourceName = url.startsWith("/") ? url : new URL(url).getPath();
            InputStream is = ResourceTransport.class.getResourceAsStream(resourceName);
            if (is == null) {
                throw new IOException("Cannot open local resource: " + resourceName);
            }
            return is;
        }
    }

    public static class URLConnectionTransport
    implements Transport {
        @Override
        public InputStream open(String url) throws IOException {
            return new URL(url).openStream();
        }
    }

    public static interface Transport {
        public InputStream open(String var1) throws IOException;
    }
}

