/*
 * Decompiled with CFR 0.152.
 */
package com.google.doubleclick.util;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.doubleclick.util.DoubleClickMetadata;
import com.google.doubleclick.util.ProtoUtils;
import com.google.protos.adx.NetworkBid;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DoubleClickValidator {
    private static final Logger logger = LoggerFactory.getLogger(DoubleClickValidator.class);
    private static final int GDN = 1;
    static final int CREATIVE_FLASH = 34;
    static final int CREATIVE_NON_FLASH = 50;
    static final int CREATIVE_SSL = 47;
    static final int CREATIVE_NON_SSL = 48;
    private final DoubleClickMetadata metadata;
    private final Counter unmatchedImp = new Counter();
    private final Counter unmatchedDeal = new Counter();
    private final Counter needsNonflashAttr = new Counter();
    private final Counter needsSslAttr = new Counter();
    private final Counter invalidCreatAttr = new Counter();
    private final Counter invalidVendor = new Counter();
    private final Counter invalidProdCat = new Counter();
    private final Counter invalidRestrCat = new Counter();
    private final Counter invalidSensCat = new Counter();
    private final Counter invalidAttrTotal = new Counter();
    private final Counter unknownAttrTotal = new Counter();

    @Inject
    public DoubleClickValidator(MetricRegistry metricRegistry, DoubleClickMetadata metadata) {
        this.metadata = metadata;
        metricRegistry.register(MetricRegistry.name(this.getClass(), (String[])new String[]{"unmatched-imp"}), (Metric)this.unmatchedImp);
        metricRegistry.register(MetricRegistry.name(this.getClass(), (String[])new String[]{"unmatched-deal"}), (Metric)this.unmatchedDeal);
        metricRegistry.register(MetricRegistry.name(this.getClass(), (String[])new String[]{"needs-nonflash-attr"}), (Metric)this.needsNonflashAttr);
        metricRegistry.register(MetricRegistry.name(this.getClass(), (String[])new String[]{"needs-ssl-attr"}), (Metric)this.needsSslAttr);
        metricRegistry.register(MetricRegistry.name(this.getClass(), (String[])new String[]{"invalid-creative-attr"}), (Metric)this.invalidCreatAttr);
        metricRegistry.register(MetricRegistry.name(this.getClass(), (String[])new String[]{"invalid-vendor"}), (Metric)this.invalidVendor);
        metricRegistry.register(MetricRegistry.name(this.getClass(), (String[])new String[]{"invalid-ad-product-cat"}), (Metric)this.invalidProdCat);
        metricRegistry.register(MetricRegistry.name(this.getClass(), (String[])new String[]{"invalid-ad-restricted-cat"}), (Metric)this.invalidRestrCat);
        metricRegistry.register(MetricRegistry.name(this.getClass(), (String[])new String[]{"invalid-ad-sensitive-cat"}), (Metric)this.invalidSensCat);
        metricRegistry.register(MetricRegistry.name(this.getClass(), (String[])new String[]{"invalid-attr-total"}), (Metric)this.invalidAttrTotal);
        metricRegistry.register(MetricRegistry.name(this.getClass(), (String[])new String[]{"unknown-attr-total"}), (Metric)this.unknownAttrTotal);
    }

    public boolean validate(NetworkBid.BidRequest request, NetworkBid.BidResponse.Builder response) {
        boolean hasBad = false;
        boolean hasEmpty = false;
        List<NetworkBid.BidResponse.Ad.Builder> ads = response.getAdBuilderList();
        for (int iAd = 0; iAd < ads.size(); ++iAd) {
            NetworkBid.BidResponse.Ad.Builder ad = ads.get(iAd);
            List<NetworkBid.BidResponse.Ad.AdSlot.Builder> adslots = ad.getAdslotBuilderList();
            if (adslots.isEmpty()) {
                hasEmpty = true;
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Ad #{} removed, clean but empty adslot", (Object)iAd);
                continue;
            }
            List<NetworkBid.BidResponse.Ad.AdSlot.Builder> filteredAdslots = ProtoUtils.filter(adslots, adslot -> this.validate(request, ad, (NetworkBid.BidResponse.Ad.AdSlot.Builder)adslot));
            if (filteredAdslots == adslots) continue;
            hasBad = true;
            ad.clearAdslot();
            if (Iterables.isEmpty(filteredAdslots)) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Ad #{} removed, all adslot values rejected", (Object)iAd);
                continue;
            }
            for (NetworkBid.BidResponse.Ad.AdSlot.Builder filteredAdslot : filteredAdslots) {
                ad.addAdslot(filteredAdslot);
            }
        }
        if (hasBad || hasEmpty) {
            ArrayList<NetworkBid.BidResponse.Ad.Builder> adsNew = new ArrayList<NetworkBid.BidResponse.Ad.Builder>(ads.size());
            for (NetworkBid.BidResponse.Ad.Builder ad : ads) {
                if (ad.getAdslotCount() == 0) continue;
                adsNew.add(ad);
            }
            response.clearAd();
            for (NetworkBid.BidResponse.Ad.Builder ad : adsNew) {
                response.addAd(ad);
            }
        }
        return hasBad;
    }

    public boolean validate(NetworkBid.BidRequest request, NetworkBid.BidResponse.Ad.Builder ad, NetworkBid.BidResponse.Ad.AdSlot.Builder adslot) {
        NetworkBid.BidRequest.AdSlot.MatchingAdData.DirectDeal deal;
        NetworkBid.BidRequest.AdSlot reqSlot = DoubleClickValidator.findRequestSlot(request, adslot.getId());
        if (reqSlot == null) {
            this.unmatchedImp.inc();
            if (logger.isDebugEnabled()) {
                logger.debug("AdSlot {} rejected, unmatched id", (Object)DoubleClickValidator.logId(adslot));
            }
            return false;
        }
        boolean valid = true;
        if (adslot.hasDealId() && (deal = DoubleClickValidator.findDeal(reqSlot, adslot.getDealId())) == null) {
            this.unmatchedDeal.inc();
            if (logger.isDebugEnabled()) {
                logger.debug("AdSlot {} rejected, unmatched dealid: {}", (Object)DoubleClickValidator.logId(adslot), (Object)adslot.getDealId());
            }
            return false;
        }
        if (reqSlot.getExcludedAttributeList().contains(34) && !ad.getAttributeList().contains(50)) {
            this.needsNonflashAttr.inc();
            if (logger.isDebugEnabled()) {
                logger.debug("{} rejected, ad.attribute needs value: {}", (Object)DoubleClickValidator.logId(adslot), (Object)DoubleClickMetadata.toString(this.metadata.buyerDeclarableCreativeAttributes(), 50));
            }
            valid = false;
        }
        if (reqSlot.getExcludedAttributeList().contains(48) && !ad.getAttributeList().contains(47)) {
            this.needsSslAttr.inc();
            if (logger.isDebugEnabled()) {
                logger.debug("{} rejected, ad.attribute needs value: {}", (Object)DoubleClickValidator.logId(adslot), (Object)DoubleClickMetadata.toString(this.metadata.buyerDeclarableCreativeAttributes(), 47));
            }
            valid = false;
        }
        ImmutableMap<Integer, String> metaVendors = this.metadata.vendors();
        List<Integer> bad = this.checkAttributes((List)reqSlot.getAllowedVendorTypeList(), (List)ad.getVendorTypeList(), (Map)metaVendors, true);
        if (!bad.isEmpty()) {
            if (logger.isDebugEnabled()) {
                logger.debug("{} rejected, unknown or not-allowed ad.vendor_type values: {}", new Object[]{DoubleClickValidator.logId(adslot), request.getSellerNetworkId() == 1 ? "GDN " : "", bad});
            }
            this.invalidVendor.inc();
            valid = false;
        }
        if (!(bad = this.checkAttributes((List)reqSlot.getAllowedRestrictedCategoryList(), (List)ad.getRestrictedCategoryList(), (Map)this.metadata.restrictedCategories(), true)).isEmpty()) {
            if (logger.isDebugEnabled()) {
                logger.debug("{} rejected, unknown or not-allowed ad.restricted_category values: {}", (Object)DoubleClickValidator.logId(adslot), bad);
            }
            this.invalidRestrCat.inc();
            valid = false;
        }
        if (!(bad = this.checkAttributes((List)reqSlot.getExcludedProductCategoryList(), (List)ad.getCategoryList(), (Map)this.metadata.allCategories(), false)).isEmpty()) {
            if (logger.isDebugEnabled()) {
                logger.debug("{} rejected, unknown or excluded product ad.category values: {}", (Object)DoubleClickValidator.logId(adslot), bad);
            }
            this.invalidProdCat.inc();
            valid = false;
        }
        if (!(bad = this.checkAttributes((List)reqSlot.getExcludedSensitiveCategoryList(), (List)ad.getCategoryList(), (Map)this.metadata.allCategories(), false)).isEmpty()) {
            if (logger.isDebugEnabled()) {
                logger.debug("{} rejected, unknown or excluded sensitive ad.category values: {}", (Object)DoubleClickValidator.logId(adslot), bad);
            }
            this.invalidSensCat.inc();
            valid = false;
        }
        if (!(bad = this.checkAttributes((List)reqSlot.getExcludedAttributeList(), (List)ad.getAttributeList(), (Map)this.metadata.buyerDeclarableCreativeAttributes(), false)).isEmpty()) {
            if (logger.isDebugEnabled()) {
                logger.debug("{} rejected, unknown or excluded ad.attribute values: {}", (Object)DoubleClickValidator.logId(adslot), bad);
            }
            this.invalidCreatAttr.inc();
            valid = false;
        }
        return valid;
    }

    @Nullable
    protected static NetworkBid.BidRequest.AdSlot.MatchingAdData.DirectDeal findDeal(NetworkBid.BidRequest.AdSlot reqSlot, long dealId) {
        for (NetworkBid.BidRequest.AdSlot.MatchingAdData reqMad : reqSlot.getMatchingAdDataList()) {
            for (NetworkBid.BidRequest.AdSlot.MatchingAdData.DirectDeal reqDeal : reqMad.getDirectDealList()) {
                if (!reqDeal.hasDirectDealId() || reqDeal.getDirectDealId() != dealId) continue;
                return reqDeal;
            }
        }
        return null;
    }

    protected static String logId(NetworkBid.BidResponse.Ad.AdSlot.Builder adslot) {
        return "AdSlot " + adslot.getId();
    }

    protected static NetworkBid.BidRequest.AdSlot findRequestSlot(NetworkBid.BidRequest request, int adslotId) {
        for (NetworkBid.BidRequest.AdSlot adslot : request.getAdslotList()) {
            if (adslot.getId() != adslotId) continue;
            return adslot;
        }
        return null;
    }

    protected <T> List<T> checkAttributes(List<T> reqAttrs, List<T> respAttrs, Map<T, String> metadata, boolean allowed) {
        ArrayList<T> bad = null;
        if (!respAttrs.isEmpty()) {
            ImmutableSet reqIndex = reqAttrs.size() > 4 ? ImmutableSet.copyOf(reqAttrs) : reqAttrs;
            for (T respValue : respAttrs) {
                if (!metadata.containsKey(respValue)) {
                    bad = bad == null ? new ArrayList<T>() : bad;
                    bad.add(respValue);
                    this.unknownAttrTotal.inc();
                    continue;
                }
                if (reqIndex.contains(respValue) == allowed) continue;
                bad = bad == null ? new ArrayList<T>() : bad;
                bad.add(respValue);
                this.invalidAttrTotal.inc();
            }
        }
        return bad == null ? ImmutableList.of() : bad;
    }
}

