/*
 * Decompiled with CFR 0.152.
 */
package com.google.doubleclick.util;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;

public class GeoTarget {
    private final int criteriaId;
    private final String name;
    private final CanonicalKey key;
    private final String countryCode;
    private GeoTarget canonParent;
    private GeoTarget idParent;

    public GeoTarget(int criteriaId, Type type, String canonicalName, String name, String countryCode) {
        this(criteriaId, new CanonicalKey(type, canonicalName), name, countryCode, null, null);
    }

    public GeoTarget(int criteriaId, CanonicalKey key, String name, String countryCode, @Nullable GeoTarget canonParent, @Nullable GeoTarget idParent) {
        this.criteriaId = criteriaId;
        this.key = key;
        this.name = name;
        this.countryCode = countryCode;
        this.canonParent = canonParent;
        this.idParent = idParent;
    }

    public final int criteriaId() {
        return this.criteriaId;
    }

    public final String name() {
        return this.name;
    }

    public final String canonicalName() {
        return this.key.canonicalName;
    }

    final CanonicalKey key() {
        return this.key;
    }

    @Nullable
    public final GeoTarget canonParent() {
        return this.canonParent;
    }

    final void setCanonParent(GeoTarget canonParent) {
        Preconditions.checkState((this.canonParent == null ? 1 : 0) != 0);
        this.canonParent = (GeoTarget)Preconditions.checkNotNull((Object)canonParent);
    }

    @Nullable
    public final GeoTarget idParent() {
        return this.idParent;
    }

    final void setIdParent(GeoTarget idParent) {
        Preconditions.checkState((this.idParent == null ? 1 : 0) != 0);
        this.idParent = (GeoTarget)Preconditions.checkNotNull((Object)idParent);
    }

    public final String countryCode() {
        return this.countryCode;
    }

    public final Type type() {
        return this.key.type;
    }

    @Nullable
    public GeoTarget getCanonAncestor(Type type) {
        for (GeoTarget target = this; target != null; target = target.canonParent()) {
            if (target.key.type != type) continue;
            return target;
        }
        return null;
    }

    @Nullable
    public GeoTarget getIdAncestor(Type type) {
        GeoTarget target = this;
        while (target != null) {
            if (target.key.type == type) {
                return target;
            }
            target = target.idParent;
        }
        return null;
    }

    public int hashCode() {
        return this.criteriaId;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof GeoTarget && this.criteriaId == ((GeoTarget)obj).criteriaId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("criteriaId", this.criteriaId).add("name", (Object)this.name).add("canonicalName", (Object)this.key.canonicalName).add("canonParent", this.canonParent == null ? null : Integer.valueOf(this.canonParent.criteriaId)).add("idParent", this.idParent == null || this.idParent == this.canonParent ? null : Integer.valueOf(this.idParent.criteriaId)).add("countryCode", (Object)this.countryCode).add("targetType", (Object)this.key.type).toString();
    }

    String findCanonParentName() {
        int canonPos;
        int pos = this.name.indexOf(44);
        if (pos == -1) {
            int canonPos2 = this.key.canonicalName.indexOf(44);
            return canonPos2 == -1 ? null : this.key.canonicalName.substring(canonPos2 + 1);
        }
        int commas = 1;
        for (int i = pos + 1; i < this.name.length(); ++i) {
            if (this.name.charAt(i) != ',') continue;
            ++commas;
        }
        for (canonPos = 0; canonPos < this.key.canonicalName.length() && commas >= 0; ++canonPos) {
            if (this.key.canonicalName.charAt(canonPos) != ',') continue;
            --commas;
        }
        if (commas == 0) {
            return null;
        }
        if (commas != -1 || canonPos == this.key.canonicalName.length()) {
            return null;
        }
        return this.key.canonicalName.substring(canonPos + 1);
    }

    static class CanonicalKey {
        final Type type;
        final String canonicalName;

        CanonicalKey(Type type, String canonicalName) {
            this.type = type;
            this.canonicalName = canonicalName;
        }

        public int hashCode() {
            return this.type.hashCode() ^ this.canonicalName.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof CanonicalKey)) {
                return false;
            }
            CanonicalKey other = (CanonicalKey)obj;
            return this.type == other.type && this.canonicalName.equals(other.canonicalName);
        }

        public String toString() {
            return this.type.name() + ' ' + this.canonicalName;
        }
    }

    public static enum Type {
        UNKNOWN,
        OTHER,
        COUNTRY,
        REGION,
        TERRITORY,
        PROVINCE,
        STATE,
        PREFECTURE,
        GOVERNORATE,
        CANTON,
        UNION_TERRITORY,
        AUTONOMOUS_COMMUNITY,
        DMA_REGION,
        METRO,
        CONGRESSIONAL_DISTRICT,
        COUNTY,
        MUNICIPALITY,
        CITY,
        POSTAL_CODE,
        DEPARTMENT,
        AIRPORT,
        TV_REGION,
        OKRUG,
        BOROUGH,
        CITY_REGION,
        ARRONDISSEMENT,
        NEIGHBORHOOD,
        UNIVERSITY,
        DISTRICT;

    }
}

