/*
 * Decompiled with CFR 0.152.
 */
package com.google.doubleclick.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.MessageLiteOrBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

final class ProtoUtils {
    private ProtoUtils() {
    }

    public static <M extends MessageLiteOrBuilder> List<M> filter(List<M> objs, Predicate<M> filter) {
        Preconditions.checkNotNull(filter);
        for (int i = 0; i < objs.size(); ++i) {
            if (filter.test((MessageLiteOrBuilder)objs.get(i))) continue;
            return ProtoUtils.filterFrom(objs, filter, i);
        }
        return objs;
    }

    private static <M extends MessageLiteOrBuilder> List<M> filterFrom(List<M> objs, Predicate<M> filter, int firstDiscarded) {
        int i;
        ArrayList<MessageLiteOrBuilder> filtered;
        if (firstDiscarded == 0) {
            filtered = null;
        } else {
            filtered = new ArrayList<MessageLiteOrBuilder>(objs.size() - 1);
            for (i = 0; i < firstDiscarded; ++i) {
                filtered.add((MessageLiteOrBuilder)objs.get(i));
            }
        }
        for (i = firstDiscarded + 1; i < objs.size(); ++i) {
            MessageLiteOrBuilder obj = (MessageLiteOrBuilder)objs.get(i);
            if (!filter.test(obj)) continue;
            if (filtered == null) {
                filtered = new ArrayList(objs.size() - i);
            }
            filtered.add(obj);
        }
        return filtered == null ? ImmutableList.of() : filtered;
    }
}

