/*
 * Decompiled with CFR 0.152.
 */
package com.google.doubleclick.util.impl;

import com.google.common.base.MoreObjects;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class CSVParser {
    public static final char EOT = '\u0003';
    public static final char NUL = '\u0000';
    private static final CSVParser TSV_PARSER = new CSVParser('\t', '\u0000', '\u0000', "", false);
    private static final CSVParser CSV_PARSER = new CSVParser(',', '\"', '\u0000', "", false);
    final char separator;
    final char quote;
    final char escape;
    final String empty;
    final boolean trim;

    public CSVParser(char separator, char quote, char escape, @Nullable String empty, boolean trim) {
        this.separator = separator;
        this.quote = quote;
        this.escape = escape;
        this.empty = empty;
        this.trim = trim;
    }

    public static CSVParser csvParser() {
        return CSV_PARSER;
    }

    public static CSVParser tsvParser() {
        return TSV_PARSER;
    }

    public boolean parse(InputStream is, String regex, Function<List<String>, Boolean> sink) throws IOException {
        return this.parse(is, Pattern.compile(regex), sink);
    }

    public boolean parse(InputStream is, Pattern pattern, Function<List<String>, Boolean> sink) throws IOException {
        String record;
        BufferedReader rd = new BufferedReader(new InputStreamReader(is));
        while ((record = rd.readLine()) != null) {
            if (!pattern.matcher(record).matches()) continue;
            try {
                if (sink.apply(this.parse(record)).booleanValue()) continue;
                return false;
            }
            catch (ParseException parseException) {
            }
        }
        return true;
    }

    public List<String> parse(String line) throws ParseException {
        ArrayList<String> cols = new ArrayList<String>();
        boolean afterQuote = false;
        boolean afterEscape = false;
        boolean afterSeparator = false;
        boolean outerQuote = false;
        boolean afterEndField = false;
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (true) {
            char c;
            char c2 = c = i == line.length() ? (char)'\u0003' : (char)line.charAt(i);
            if (afterEndField && c != this.separator && c != '\u0003') {
                if (!this.trim || c != ' ') {
                    throw new ParseException("Extraneous character after end of quoted field", i);
                }
            } else if (afterEscape) {
                if (c == '\u0003') {
                    throw new ParseException("Escape not followed by a character", i);
                }
                afterEscape = false;
                sb.append(c);
            } else if (c == this.separator) {
                if (outerQuote && !afterQuote) {
                    sb.append(c);
                    afterSeparator = false;
                } else {
                    this.endCol(cols, sb, i, outerQuote, afterQuote);
                    outerQuote = false;
                    afterEndField = false;
                    afterEscape = false;
                    afterQuote = false;
                    afterSeparator = true;
                }
            } else {
                if (c == '\u0003') {
                    if (sb.length() != 0 || afterSeparator || outerQuote) {
                        this.endCol(cols, sb, i, outerQuote, afterQuote);
                    }
                    return cols;
                }
                if (c == this.escape) {
                    afterEscape = true;
                    afterSeparator = false;
                } else if (c == this.quote) {
                    if (afterQuote && outerQuote) {
                        sb.append(this.quote);
                        afterQuote = false;
                    } else if (sb.length() == 0 && !outerQuote) {
                        outerQuote = true;
                    } else {
                        if (sb.length() != 0 && !outerQuote) {
                            throw new ParseException(this.escape == '\u0000' ? "Unescaped quote inside non-quote-delimited field" : "Quote inside non-quote-delimited field", i);
                        }
                        afterQuote = true;
                    }
                    afterSeparator = false;
                } else if (c != ' ' || !this.trim || (outerQuote || sb.length() != 0) && !afterEndField) {
                    if (c == ' ' && this.trim && afterQuote) {
                        afterEndField = true;
                    } else {
                        if (outerQuote && afterQuote) {
                            throw new ParseException("Extraneous character after end of quoted field", i);
                        }
                        sb.append(c);
                        afterSeparator = false;
                    }
                }
            }
            ++i;
        }
    }

    protected void endCol(List<String> cols, StringBuilder sb, int i, boolean outerQuote, boolean afterQuote) throws ParseException {
        if (outerQuote && !afterQuote) {
            throw new ParseException("Field starts with quote but ends unquoted", i);
        }
        if (this.trim && !outerQuote) {
            while (sb.length() != 0 && sb.charAt(sb.length() - 1) == ' ') {
                sb.setLength(sb.length() - 1);
            }
        }
        cols.add(!outerQuote && sb.length() == 0 ? this.empty : sb.toString());
        sb.setLength(0);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("separator", this.separator == '\u0000' ? null : "0x" + Integer.toHexString(this.separator)).add("quote", this.quote == '\u0000' ? null : "0x" + Integer.toHexString(this.quote)).add("escape", this.escape == '\u0000' ? null : "0x" + Integer.toHexString(this.escape)).add("empty", (Object)String.valueOf(this.empty)).add("trim", this.trim).toString();
    }
}

