/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.sjavac.client;

import com.sun.tools.sjavac.JavacState;
import com.sun.tools.sjavac.Log;
import com.sun.tools.sjavac.Module;
import com.sun.tools.sjavac.ProblemException;
import com.sun.tools.sjavac.Source;
import com.sun.tools.sjavac.Transformer;
import com.sun.tools.sjavac.Util;
import com.sun.tools.sjavac.client.SjavacClient;
import com.sun.tools.sjavac.comp.PooledSjavac;
import com.sun.tools.sjavac.comp.SjavacImpl;
import com.sun.tools.sjavac.options.Options;
import com.sun.tools.sjavac.options.SourceLocation;
import com.sun.tools.sjavac.server.Sjavac;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClientMain {
    public static int run(String[] args) {
        return ClientMain.run(args, System.out, System.err);
    }

    public static int run(String[] args, PrintStream out, PrintStream err) {
        Options options;
        Log.initializeLog(out, err);
        try {
            options = Options.parseArgs(args);
        }
        catch (IllegalArgumentException e) {
            Log.error(e.getMessage());
            return -1;
        }
        Log.setLogLevel(options.getLogLevel());
        if (!ClientMain.validateOptions(options)) {
            return -1;
        }
        if (!ClientMain.createIfMissing(options.getDestDir())) {
            return -1;
        }
        if (!ClientMain.createIfMissing(options.getStateDir())) {
            return -1;
        }
        Path gensrc = options.getGenSrcDir();
        if (gensrc != null && !ClientMain.createIfMissing(gensrc)) {
            return -1;
        }
        Path hdrdir = options.getHeaderDir();
        if (hdrdir != null && !ClientMain.createIfMissing(hdrdir)) {
            return -1;
        }
        Log.debug("==========================================================");
        Log.debug("Launching sjavac client with the following parameters:");
        Log.debug("    " + options.getStateArgsString());
        Log.debug("==========================================================");
        JavacState javac_state = JavacState.load(options, out, err);
        HashMap<String, Transformer> suffixRules = new HashMap<String, Transformer>();
        suffixRules.putAll(javac_state.getJavaSuffixRule());
        suffixRules.putAll(options.getTranslationRules());
        HashMap<String, Module> modules = new HashMap<String, Module>();
        Module current_module = new Module("", "");
        modules.put("", current_module);
        HashMap<String, Source> sources = new HashMap<String, Source>();
        ClientMain.findSourceFiles(options.getSources(), suffixRules.keySet(), sources, modules, current_module, options.isDefaultPackagePermitted(), false);
        if (sources.isEmpty()) {
            Log.error("Found nothing to compile!");
            return -1;
        }
        HashMap<String, Source> sources_to_link_to = new HashMap<String, Source>();
        ArrayList<SourceLocation> sourceResolutionLocations = new ArrayList<SourceLocation>();
        sourceResolutionLocations.addAll(options.getSources());
        sourceResolutionLocations.addAll(options.getSourceSearchPaths());
        ClientMain.findSourceFiles(sourceResolutionLocations, Collections.singleton(".java"), sources_to_link_to, modules, current_module, options.isDefaultPackagePermitted(), true);
        javac_state.now().flattenPackagesSourcesAndArtifacts(modules);
        javac_state.now().checkInternalState("checking sources", false, sources);
        javac_state.now().checkInternalState("checking linked sources", true, sources_to_link_to);
        javac_state.setVisibleSources(sources_to_link_to);
        int round = 0;
        ClientMain.printRound(round);
        javac_state.checkSourceStatus(false);
        javac_state.findAllArtifacts();
        if (!options.areUnidentifiedArtifactsPermitted()) {
            javac_state.removeUnidentifiedArtifacts();
        }
        javac_state.taintPackagesThatMissArtifacts();
        javac_state.taintPackagesDependingOnChangedClasspathPackages();
        javac_state.deleteClassArtifactsInTaintedPackages();
        javac_state.performCopying(Util.pathToFile(options.getDestDir()), suffixRules);
        javac_state.performTranslation(Util.pathToFile(gensrc), suffixRules);
        HashMap<String, Source> generated_sources = new HashMap<String, Source>();
        try {
            boolean again;
            Sjavac sjavac;
            Source.scanRoot(Util.pathToFile(options.getGenSrcDir()), Util.set(".java"), null, null, null, null, generated_sources, modules, current_module, false, true, false);
            javac_state.now().flattenPackagesSourcesAndArtifacts(modules);
            javac_state.checkSourceStatus(true);
            javac_state.compareWithMakefileList(Util.pathToFile(options.getSourceReferenceList()));
            HashSet<String> recently_compiled = new HashSet<String>();
            boolean[] rc = new boolean[1];
            boolean background = Util.extractBooleanOption("background", options.getServerConf(), true);
            if (background) {
                sjavac = new SjavacClient(options);
            } else {
                int poolsize = Util.extractIntOption("poolsize", options.getServerConf());
                if (poolsize <= 0) {
                    poolsize = Runtime.getRuntime().availableProcessors();
                }
                sjavac = new PooledSjavac(new SjavacImpl(), poolsize);
            }
            do {
                if (round > 0) {
                    ClientMain.printRound(round);
                }
                javac_state.deleteClassArtifactsInTaintedPackages();
                again = javac_state.performJavaCompilations(sjavac, options, recently_compiled, rc);
                if (!rc[0]) {
                    Log.debug("Compilation failed.");
                    break;
                }
                if (!again) {
                    Log.debug("Nothing left to do.");
                }
                ++round;
            } while (again);
            Log.debug("No need to do another round.");
            if (rc[0]) {
                javac_state.save();
                javac_state.now().flattenArtifacts(modules);
                javac_state.removeSuperfluousArtifacts(recently_compiled);
            }
            if (!background) {
                sjavac.shutdown();
            }
            return rc[0] ? 0 : -1;
        }
        catch (ProblemException e) {
            Log.error(e.getMessage());
            return -1;
        }
        catch (Exception e) {
            e.printStackTrace(err);
            return -1;
        }
    }

    private static boolean validateOptions(Options options) {
        String err = null;
        if (options.getDestDir() == null) {
            err = "Please specify output directory.";
        } else if (options.isJavaFilesAmongJavacArgs()) {
            err = "Sjavac does not handle explicit compilation of single .java files.";
        } else if (options.getServerConf() == null) {
            err = "No server configuration provided.";
        } else if (!options.getImplicitPolicy().equals("none")) {
            err = "The only allowed setting for sjavac is -implicit:none";
        } else if (options.getSources().isEmpty()) {
            err = "You have to specify -src.";
        } else if (options.getTranslationRules().size() > 1 && options.getGenSrcDir() == null) {
            err = "You have translators but no gensrc dir (-s) specified!";
        }
        if (err != null) {
            Log.error(err);
        }
        return err == null;
    }

    private static boolean createIfMissing(Path dir) {
        if (Files.isDirectory(dir, new LinkOption[0])) {
            return true;
        }
        if (Files.exists(dir, new LinkOption[0])) {
            Log.error(dir + " is not a directory.");
            return false;
        }
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        catch (IOException e) {
            Log.error("Could not create directory: " + e.getMessage());
            return false;
        }
        return true;
    }

    public static void findSourceFiles(List<SourceLocation> sourceLocations, Set<String> sourceTypes, Map<String, Source> foundFiles, Map<String, Module> foundModules, Module currentModule, boolean permitSourcesInDefaultPackage, boolean inLinksrc) {
        for (SourceLocation source : sourceLocations) {
            source.findSourceFiles(sourceTypes, foundFiles, foundModules, currentModule, permitSourcesInDefaultPackage, inLinksrc);
        }
    }

    private static void printRound(int round) {
        Log.debug("****************************************");
        Log.debug("* Round " + round + "                              *");
        Log.debug("****************************************");
    }
}

